/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialFeeUnAssignedChecher
extends CMCalChecker {
    private static Logger logger = Logger.getLogger((String)MaterialFeeUnAssignedChecher.class.getName());
    private static final char CLF = '\n';
    private CalCostCheckItemCheckResultCollection rc;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(param);
        return this.rc;
    }

    private void checktable(Map param) throws BOSException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String tblAllocResult = null;
        try {
            tblAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        PeriodInfo period = null;
        try {
            period = (PeriodInfo)PeriodFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(periodId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.checkMatReq(param, ctx, tblAllocResult, period);
        this.checkOtherInWarehs(ctx, companyId, periodId, tblAllocResult, period);
        this.checkCostAdjust(ctx, companyId, periodId, tblAllocResult, period);
    }

    private void checkMatReq(Map param, Context ctx, String tblAllocResult, PeriodInfo period) throws BOSException {
        IRowSet rs = null;
        String reason = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_MaterialFeeUnAssignedChecher");
        try {
            CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
            String T_TMP_MatReq = costDataCache.getMatReqTable();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT top 100 t.FNumber, t.FSeq").append('\n');
            sql.append("FROM " + T_TMP_MatReq + " t ").append('\n');
            sql.append("where not exists (").append('\n');
            sql.append("    select 1 from " + tblAllocResult + " r ").append('\n');
            sql.append("    where r.FSourceBillID = t.FSourceBillID and r.FSourceBillEntryID = t.FSourceBillEntryID ").append('\n');
            sql.append(") ").append('\n');
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_MaterialFeeUnAssignedChecher"));
                rinfo.setReason(MessageFormat.format(reason, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_MaterialFeeUnAssignedChecher"));
                this.rc.add(rinfo);
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void checkOtherInWarehs(Context ctx, String companyID, String periodId, String tblAllocResult, PeriodInfo period) throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select distinct top 100 \n");
        ksql.append("    b.FNumber, be.FSeq \n");
        ksql.append("from T_IM_OtherInWarehsBill b \n");
        ksql.append("join T_IM_OtherInWarehsBillEntry be on be.FParentID = b.FID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("join T_SCM_TransactionType tt on tt.FID = b.FTransactionTypeID \n");
        ksql.append("inner join T_IM_InvUpdateType ut on be.FINVUPDATETYPEID = ut.fid ").append('\n');
        ksql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid  ").append('\n');
        ksql.append("left join " + tblAllocResult + " s \n");
        ksql.append("    on s.FSourceBillID = b.FID and s.FSourceBillEntryID = be.FID \n");
        ksql.append("where be.FCompanyOrgUnitID = '" + companyID + "' \n");
        ksql.append("and b.FYear = " + period.getPeriodYear() + " \n");
        ksql.append("and b.FPeriod = " + period.getPeriodNumber() + " \n");
        ksql.append("and b.FBaseStatus = 4 \n");
        ksql.append("and b.FIsReversed = 0 \n");
        ksql.append("and tt.FIsManuCostCalculate = 1 \n");
        ksql.append("and st.FISFORWARDAMT = 1 \n");
        ksql.append("and cc.FCostCenterType = 0 \n");
        ksql.append("and s.FID is null \n");
        String description = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_OtherInWarehsUnAssignedChecher");
        String reason = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_OtherInWarehsUnAssignedChecher");
        String suggestOperation = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_OtherInWarehsUnAssignedChecher");
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(description);
                String r = MessageFormat.format(reason, rs.getString("FNumber"), rs.getString("FSeq"));
                rinfo.setReason(r);
                rinfo.setSuggestOperation(suggestOperation);
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void checkCostAdjust(Context ctx, String companyId, String periodId, String tblAllocResult, PeriodInfo period) throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select distinct top 100 \n");
        ksql.append("    b.FNumber, be.FSeq \n");
        ksql.append("from T_CL_CostAdjustBill b \n");
        ksql.append("join T_CL_CostAdjustBillEntry be on be.FParentID = b.FID \n");
        ksql.append("join T_ORG_CostCenter cc on cc.FID = b.FCostCenterOrgUnitID \n");
        ksql.append("left join " + tblAllocResult + " s \n");
        ksql.append("    on s.FSourceBillID = b.FID and s.FSourceBillEntryID = be.FID \n");
        ksql.append("where be.FCompanyOrgUnitID = '" + companyId + "' \n");
        ksql.append("and b.FYear = " + period.getPeriodYear() + " \n");
        ksql.append("and b.FPeriod = " + period.getPeriodNumber() + " \n");
        ksql.append("and b.FBaseStatus = 4 \n");
        ksql.append("and (cc.FCostCenterType = 0 or cc.FCostCenterType = 1) \n");
        ksql.append("and b.FIssueType = 1 \n");
        ksql.append("and b.FCalculateKind = 1 \n");
        ksql.append("and s.FID is null \n");
        String description = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_CostAdjustUnAssignedChecher");
        String reason = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_CostAdjustUnAssignedChecher");
        String suggestOperation = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_CostAdjustUnAssignedChecher");
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(description);
                String r = MessageFormat.format(reason, rs.getString("FNumber"), rs.getString("FSeq"));
                rinfo.setReason(r);
                rinfo.setSuggestOperation(suggestOperation);
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

