/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;

public class MaterialNoCostItemChecker
extends CMCalChecker {
    private static final char CLF = '\n';
    CalCostCheckItemCheckResultCollection rc;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(ctx, companyId, periodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("\tSELECT top 100 bill.FNumber, M.FName_L2 || '(' || M.FNumber || ')' As FMaterialDisp ").append('\n').append("\tFROM T_IM_OtherInWarehsBill bill").append('\n').append("\tLEFT OUTER JOIN T_IM_OtherInWarehsBillEntry entry on entry.FParentID=bill.FID").append('\n').append("\tLEFT OUTER JOIN T_SCM_TransactionType TT ON bill.FTransactionTypeID = TT.FID").append('\n').append("\tINNER JOIN T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append('\n').append("\tINNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid  ").append('\n').append("\tLEFT OUTER JOIN T_BD_MaterialCost MT ON MT.FMaterialID=entry.FMaterialID AND MT.FOrgUnit = entry.FCompanyOrgUnitID ").append('\n').append("\tLEFT OUTER JOIN T_BD_Material M ON M.FID=entry.FMaterialID ").append('\n').append("\tLEFT OUTER JOIN T_ORG_CostCenter CC ON CC.FID=bill.FCostCenterOrgUnitID and CC.FCostCenterType = 0 ").append('\n').append("\tLEFT OUTER JOIN T_BD_Period PD ON bill.FYear = PD.FPeriodYear AND bill.FPeriod = PD.FPeriodNumber ").append('\n').append("\tWHERE bill.FBaseStatus=4 ").append('\n').append("\t    AND TT.FIsManuCostCalculate=1 AND TT.FNumber='032' ").append('\n').append("\t    AND st.FISFORWARDAMT = 1 ").append('\n').append("\t\tAND entry.FCompanyOrgUnitID='").append(companyId).append("' AND PD.FID='").append(periodId).append("' ").append('\n').append("\t\tAND CC.FIsBizUnit=1 AND CC.FCostCenterType=0 AND CC.FisSealUp=0 ").append('\n').append("\t\tAND (entry.FCostItemID is null and MT.FDefaultCostItemID is null) ").append('\n');
        IRowSet rs = null;
        String descrip = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_MaterialNoCostItemChecker");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber"), rs.getString("FMaterialDisp")));
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_MaterialNoCostItemChecker"));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_MaterialNoCostItemChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

