/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherFeeUnAssignedChecker
extends CMCalChecker {
    private static Logger logger = Logger.getLogger((String)OtherFeeUnAssignedChecker.class.getName());
    private static final char CLF = '\n';
    private CalCostCheckItemCheckResultCollection rc;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(ctx, companyId, periodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        String tblAllocResult = null;
        try {
            tblAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT B.FNumber,E.FSeq").append('\n').append("FROM T_NCM_OtherFeeBill B").append('\n').append("LEFT OUTER JOIN T_NCM_OtherFeeBillEntry E ON B.FID = E.FParentID").append('\n').append("WHERE B.FBillStatus=4 AND B.FCompanyOrg=? AND B.FCalculatePeriod = ? ").append('\n').append("\tAND NOT EXISTS(").append('\n').append("  \t\tSELECT 1").append('\n').append("\t\tFROM ").append(tblAllocResult).append(" S").append('\n').append("\t\tWHERE S.FSourceBillID=B.FID AND S.FSourceBillEntryID=E.FID AND S.FCompanyID=? AND S.FCalculatePeriodID=?").append('\n').append("\t)").append('\n');
        Object[] params = new Object[]{companyId, periodId, companyId, periodId};
        IRowSet rs = null;
        String reason = CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_OtherFeeUnAssignedChecker");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_OtherFeeUnAssignedChecker"));
                rinfo.setReason(MessageFormat.format(reason, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_OtherFeeUnAssignedChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

