/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class PutinCostObjectForInitBalanceChecker
extends CMCalChecker {
    private static Logger logger = Logger.getLogger((String)PutinCostObjectForInitBalanceChecker.class.getName());
    private CalCostCheckItemCheckResultCollection rc;

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(ctx, companyId, periodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        boolean hasValidCostObject = false;
        try {
            hasValidCostObject = NCMServerUtils.checkHasValidCostObject((Context)ctx, (String)companyId, (String)periodId);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        CompanyOrgUnitInfo company = null;
        try {
            company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!hasValidCostObject) {
            CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
            rinfo.setDescription(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription_PutinCostObjectForInitBalanceChecker"));
            rinfo.setReason(MessageFormat.format(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_PutinCostObjectForInitBalanceChecker"), company.getName()));
            rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_PutinCostObjectForInitBalanceChecker"));
            this.rc.add(rinfo);
        }
    }
}

