/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Map;

public class PutinCostObjectForManufactureRecChecker
extends CMCalChecker {
    private CalCostCheckItemCheckResultCollection rc;
    protected static final char CLF = '\n';

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(param);
        return this.rc;
    }

    private void checktable(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        try {
            StringBuffer sql = new StringBuffer();
            String locLan = ctx.getLocale().toString();
            String T_TMP_InputQty = costDataCache.getInputQtyTable();
            String T_TMP_FinishedQty = costDataCache.getFinishedQtyTable();
            sql.append("SELECT top 100 \n");
            sql.append("    CC.FNUMBER||','||CC.FNAME_" + locLan + ", \n");
            sql.append("    CO.FNumber||','||CO.FName_" + locLan + " \n ");
            sql.append("from " + T_TMP_FinishedQty + " t \n");
            sql.append("join T_ORG_CostCenter AS CC \n");
            sql.append("    on CC.FID = t.FCostCenterID and CC.FCostCenterType = 0 \n");
            sql.append("join T_BD_CostObject CO ON CO.FID = t.FCostObjectID \n");
            sql.append("where t.FQty <> 0 \n");
            sql.append("    and not exists ( \n");
            sql.append("        select 1 from " + T_TMP_InputQty + " a \n");
            sql.append("        where a.FCostCenterID = t.FCostCenterID and a.FCostObjectID = t.FCostObjectID \n");
            sql.append("        and a.FQty <> 0 \n");
            sql.append("    ) \n");
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String ccName = rs.getString(1);
                String coName = rs.getString(2);
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setReason(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrReason_PutinCostObjectForManufactureRecChecker"));
                rinfo.setDescription(MessageFormat.format(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrDescription__PutinCostObjectForManufactureRecChecker"), coName, ccName));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "CheckErrSuggest_PutinCostObjectForManufactureRecChecker"));
                this.rc.add(rinfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

