/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.app.LowLevelCodeBuilder;
import com.kingdee.eas.ncm.cal.app.LowLevelCodeBuilderByMat;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.util.List;
import java.util.Map;

public class RankCodeCycleChecker
extends CMCalChecker {
    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection results = new CalCostCheckItemCheckResultCollection();
        this.checking(param, results);
        return results;
    }

    private void checking(Map param, CalCostCheckItemCheckResultCollection results) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)ctx, (String)companyId);
        CalCostCheckItemCheckResultInfo result = null;
        Map calResutl = null;
        try {
            Object builder;
            param.put("llcType", LowLevelCodeTypeEnum.Normal);
            if (isOutsourcCalc) {
                builder = new LowLevelCodeBuilderByMat(param);
                calResutl = ((LowLevelCodeBuilderByMat)builder).build2();
            } else {
                builder = new LowLevelCodeBuilder(param);
                calResutl = ((LowLevelCodeBuilder)builder).build2();
            }
        }
        catch (EASBizException e) {
            if (EASBizException.CHECKBLANK.getCode().equals(e.getSubCode()) || EASBizException.CHECKDUPLICATED.getCode().equals(e.getSubCode())) {
                result = new CalCostCheckItemCheckResultInfo();
                result.setDescription(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_description2"));
                result.setReason(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_reason2"));
                result.setSuggestOperation(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_SO2"));
                results.add(result);
                return;
            }
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (calResutl == null || calResutl.size() == 0) {
            return;
        }
        List cycleList = (List)calResutl.get("cycResult");
        if (cycleList == null || cycleList.size() == 0) {
            return;
        }
        for (int i = 0; i < cycleList.size(); ++i) {
            result = new CalCostCheckItemCheckResultInfo();
            result.setDescription(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_description3") + (String)cycleList.get(i));
            result.setReason(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_Reason"));
            result.setSuggestOperation(NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_SO1") + NCMUtils.getNcmCheckResource((String)"RankCodeCycleChecker_InitBalanceName"));
            results.add(result);
        }
    }
}

