/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.cal.app.checker.PutinCostObjectForInitBalanceChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShareCostObjectFillChecker
extends CMCalChecker {
    private static Logger logger = Logger.getLogger((String)PutinCostObjectForInitBalanceChecker.class.getName());

    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        CalCostCheckItemCheckResultCollection rc = new CalCostCheckItemCheckResultCollection();
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            String preNumber = null;
            String curNumber = null;
            String seq = null;
            sql.append("select a.FNumber, b.FSeq \n");
            sql.append("from T_IM_MaterialReqBill as a \n");
            sql.append("join T_IM_MaterialReqBillEntry as b on b.FParentID = a.FID \n");
            sql.append("join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("inner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEPREID = st.fid  \n");
            sql.append("join t_org_costcenter as cc on cc.FID = b.FCostCenterOrgUnitID \n");
            sql.append("where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("and a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("and a.FbaseStatus = 4 \n");
            sql.append("and a.FIsReversed = 0 \n");
            sql.append("and cc.FCostCenterType = 0 \n");
            sql.append("and tt.FIsManuCostCalculate = 1 \n");
            sql.append("and st.FISFORWARDAMT = 1  \n");
            sql.append("and (b.FCostObjectID is null and b.FCostObjectSuiteID is null) \n");
            sql.append("order by a.FNumber, b.FSeq \n");
            int BILL_COUNT = 2;
            int ENTRY_COUNT = 2;
            int billCount = 0;
            int entryCount = 0;
            StringBuffer materialReqBills = new StringBuffer();
            rs = stmt.executeQuery(sql.toString());
            preNumber = null;
            while (rs.next()) {
                curNumber = rs.getString("FNumber");
                seq = rs.getString("FSeq");
                if (curNumber.equals(preNumber)) {
                    if (++entryCount > ENTRY_COUNT) {
                        if (entryCount != ENTRY_COUNT + 1) continue;
                        materialReqBills.append("...\uff0c");
                        continue;
                    }
                    materialReqBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                } else {
                    ++billCount;
                    entryCount = 1;
                    if (preNumber == null) {
                        materialReqBills.append(CalSeverUtils.getNcmCheckResource(ctx, "MaterialReqBill"));
                    } else {
                        materialReqBills.deleteCharAt(materialReqBills.length() - 1);
                        materialReqBills.append("\u3011\u3001");
                        if (billCount > BILL_COUNT) {
                            materialReqBills.append("... ");
                            break;
                        }
                    }
                    materialReqBills.append("\u3010");
                    materialReqBills.append(curNumber + "\uff0c");
                    materialReqBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                }
                preNumber = curNumber;
            }
            if (materialReqBills.length() > 0 && billCount <= BILL_COUNT) {
                materialReqBills.deleteCharAt(materialReqBills.length() - 1);
                materialReqBills.append("\u3011");
            }
            SQLUtils.cleanup((ResultSet)rs);
            sql.setLength(0);
            sql.append("select a.FNumber, b.FSeq \n");
            sql.append("from T_IM_OtherInWarehsBill as a \n");
            sql.append("join T_IM_OtherInWarehsBillEntry as b on b.FParentID = a.FID \n");
            sql.append("join T_SCM_TransactionType tt on tt.FID = a.FTransactionTypeID \n");
            sql.append("inner join T_IM_InvUpdateType ut on b.FINVUPDATETYPEID = ut.fid \n");
            sql.append("inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid  \n");
            sql.append("join t_org_costcenter as cc on cc.FID = a.FCostCenterOrgUnitID \n");
            sql.append("where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("and a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("and a.FbaseStatus = 4 \n");
            sql.append("and a.FIsReversed = 0 \n");
            sql.append("and cc.FCostCenterType = 0 \n");
            sql.append("and tt.FIsManuCostCalculate = 1 \n");
            sql.append("and st.FISFORWARDAMT = 1 \n");
            sql.append("and (b.FCostObjectID is null and b.FCostObjectSuiteID is null) \n");
            sql.append("order by a.FNumber, b.FSeq \n");
            billCount = 0;
            entryCount = 0;
            StringBuffer otherInWarehsBills = new StringBuffer();
            rs = stmt.executeQuery(sql.toString());
            preNumber = null;
            while (rs.next()) {
                curNumber = rs.getString("FNumber");
                seq = rs.getString("FSeq");
                if (curNumber.equals(preNumber)) {
                    if (++entryCount > ENTRY_COUNT) {
                        if (entryCount != ENTRY_COUNT + 1) continue;
                        otherInWarehsBills.append("...\uff0c");
                        continue;
                    }
                    otherInWarehsBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                } else {
                    ++billCount;
                    entryCount = 1;
                    if (preNumber == null) {
                        otherInWarehsBills.append(CalSeverUtils.getNcmCheckResource(ctx, "OtherInWarehsBill"));
                    } else {
                        otherInWarehsBills.deleteCharAt(otherInWarehsBills.length() - 1);
                        otherInWarehsBills.append("\u3011\u3001");
                        if (billCount > BILL_COUNT) {
                            otherInWarehsBills.append("... ");
                            break;
                        }
                    }
                    otherInWarehsBills.append("\u3010");
                    otherInWarehsBills.append(curNumber + "\uff0c");
                    otherInWarehsBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                }
                preNumber = curNumber;
            }
            if (otherInWarehsBills.length() > 0 && billCount <= BILL_COUNT) {
                otherInWarehsBills.deleteCharAt(otherInWarehsBills.length() - 1);
                otherInWarehsBills.append("\u3011");
            }
            SQLUtils.cleanup((ResultSet)rs);
            sql.setLength(0);
            sql.append("select a.FNumber, b.FSeq \n");
            sql.append("from t_cl_CostAdjustBill as a \n");
            sql.append("join t_cl_CostAdjustBillentry as b on b.FParentID = a.FID \n");
            sql.append("join t_org_costcenter as cc on cc.FID = a.FCostCenterOrgUnit \n");
            sql.append("where b.FCompanyOrgUnitID = '" + companyId + "' \n");
            sql.append("and a.FYear = " + period.getPeriodYear() + " and a.FPeriod = " + period.getPeriodNumber() + " \n");
            sql.append("and a.FbaseStatus = 4 \n");
            sql.append("and a.FIsReversed = 0 \n");
            sql.append("and a.FCalculateKind = 1 \n");
            sql.append("and a.FIssueType = 1 \n");
            sql.append("and cc.FCostCenterType = 0 \n");
            sql.append("and b.FCostObjectID is null \n");
            sql.append("order by a.FNumber, b.FSeq \n");
            billCount = 0;
            entryCount = 0;
            StringBuffer costAdjustBills = new StringBuffer();
            rs = stmt.executeQuery(sql.toString());
            preNumber = null;
            while (rs.next()) {
                curNumber = rs.getString("FNumber");
                seq = rs.getString("FSeq");
                if (curNumber.equals(preNumber)) {
                    if (++entryCount > ENTRY_COUNT) {
                        if (entryCount != ENTRY_COUNT + 1) continue;
                        costAdjustBills.append("...\uff0c");
                        continue;
                    }
                    costAdjustBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                } else {
                    ++billCount;
                    entryCount = 1;
                    if (preNumber == null) {
                        costAdjustBills.append(CalSeverUtils.getNcmCheckResource(ctx, "CostAdjustBill"));
                    } else {
                        costAdjustBills.deleteCharAt(costAdjustBills.length() - 1);
                        costAdjustBills.append("\u3011\u3001");
                        if (billCount > BILL_COUNT) {
                            costAdjustBills.append("... ");
                            break;
                        }
                    }
                    costAdjustBills.append("\u3010");
                    costAdjustBills.append(curNumber + "\uff0c");
                    costAdjustBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                }
                preNumber = curNumber;
            }
            if (costAdjustBills.length() > 0 && billCount <= BILL_COUNT) {
                costAdjustBills.deleteCharAt(costAdjustBills.length() - 1);
                costAdjustBills.append("\u3011");
            }
            SQLUtils.cleanup((ResultSet)rs);
            sql.setLength(0);
            sql.append("select a.FNumber, b.FSeq \n");
            sql.append("from t_ncm_otherfeebill as a \n");
            sql.append("join t_ncm_otherfeebillentry as b on b.FParentID = a.FID \n");
            sql.append("join t_org_costcenter as cc on cc.FID = a.FCostCenterID \n");
            sql.append("where a.FCompanyOrg = '" + companyId + "' \n");
            sql.append("and a.FCalculatePeriod = '" + periodId + "' \n");
            sql.append("and a.FBillStatus = 4 \n");
            sql.append("and (cc.FCostCenterType = 0 or cc.FCostCenterType = 1) \n");
            sql.append("and (b.FCostObjectID is null and b.FCostObjectSuiteID is null) \n");
            sql.append("order by a.FNumber, b.FSeq \n");
            billCount = 0;
            entryCount = 0;
            StringBuffer otherFeeBills = new StringBuffer();
            rs = stmt.executeQuery(sql.toString());
            preNumber = null;
            while (rs.next()) {
                curNumber = rs.getString("FNumber");
                seq = rs.getString("FSeq");
                if (curNumber.equals(preNumber)) {
                    if (++entryCount > ENTRY_COUNT) {
                        if (entryCount != ENTRY_COUNT + 1) continue;
                        otherFeeBills.append("...\uff0c");
                        continue;
                    }
                    otherFeeBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                } else {
                    ++billCount;
                    entryCount = 1;
                    if (preNumber == null) {
                        otherFeeBills.append(CalSeverUtils.getNcmCheckResource(ctx, "OtherFeeBill"));
                    } else {
                        otherFeeBills.deleteCharAt(otherFeeBills.length() - 1);
                        otherFeeBills.append("\u3011\u3001");
                        if (billCount > BILL_COUNT) {
                            otherFeeBills.append("... ");
                            break;
                        }
                    }
                    otherFeeBills.append("\u3010");
                    otherFeeBills.append(curNumber + "\uff0c");
                    otherFeeBills.append(CalSeverUtils.getNcmCheckResource(ctx, "ENTRY") + seq + "\uff0c");
                }
                preNumber = curNumber;
            }
            if (otherFeeBills.length() > 0 && billCount <= BILL_COUNT) {
                otherFeeBills.deleteCharAt(otherFeeBills.length() - 1);
                otherFeeBills.append("\u3011");
            }
            SQLUtils.cleanup((ResultSet)rs);
            StringBuffer bills = new StringBuffer();
            if (materialReqBills.length() > 0 || otherInWarehsBills.length() > 0 || costAdjustBills.length() > 0 || otherFeeBills.length() > 0) {
                if (materialReqBills.length() > 0) {
                    bills.append(materialReqBills).append("\uff1b");
                }
                if (otherInWarehsBills.length() > 0) {
                    bills.append(otherInWarehsBills).append("\uff1b");
                }
                if (costAdjustBills.length() > 0) {
                    bills.append(costAdjustBills).append("\uff1b");
                }
                if (otherFeeBills.length() > 0) {
                    bills.append(otherFeeBills).append("\uff1b");
                }
                bills.deleteCharAt(bills.length() - 1);
                bills.append(CalSeverUtils.getNcmCheckResource(ctx, "NOT_FILL_COSTOBJECT"));
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(CalSeverUtils.getNcmCheckResource(ctx, "ShareCostObjectFillCheck_DESC"));
                rinfo.setReason(bills.toString());
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource(ctx, "ShareCostObjectFillCheck_SUGGEST"));
                rc.add(rinfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rc;
    }
}

