/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.CMCalChecker;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class UnitActualCostChecker
extends CMCalChecker {
    @Override
    public CalCostCheckItemCheckResultCollection calChecker(Map param) throws BOSException, EASBizException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String comId = "'" + companyId + "'";
        String perId = "'" + periodId + "'";
        String sql_MR = this.getSQL(comId, perId, "MR");
        String sql_OI = this.getSQL(comId, perId, "OI");
        CalCostCheckItemCheckResultCollection results = new CalCostCheckItemCheckResultCollection();
        this.checking(ctx, sql_MR, results, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"146_BillType_MatReqBill", (Locale)ctx.getLocale()));
        this.checking(ctx, sql_OI, results, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"147_BillType_OtherBill", (Locale)ctx.getLocale()));
        return results;
    }

    protected void checking(Context ctx, String query, CalCostCheckItemCheckResultCollection results, String which) throws BOSException, EASBizException {
        String description = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"102_UnitActualCostChecker", (Locale)ctx.getLocale());
        String reason = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"103_UnitActualCostChecker", (Locale)ctx.getLocale());
        String suggestOperation = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.app.CALAPPAutoGenerateResource", (String)"104_UnitActualCostChecker", (Locale)ctx.getLocale());
        CalCostCheckItemCheckResultInfo result = null;
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() == 0) {
            return;
        }
        try {
            while (rs.next() && rs.getString(1) != null) {
                result = new CalCostCheckItemCheckResultInfo();
                String desc = MessageFormat.format(description, rs.getString("FMatNumber") + ", " + rs.getString("FMatName"), rs.getString("FBillNumber"), which);
                result.setDescription(desc);
                result.setReason(reason);
                result.setSuggestOperation(suggestOperation);
                results.add(result);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected String getSQL(String companyOrgID, String periodID, String which) {
        String select = "SELECT distinct top 100 \nENTRY.FMATERIALID, PARENT.FNUMBER FBillNumber, MATERIAL.FNumber FMatNumber, MATERIAL.FNAME_L2 FMatName \n";
        StringBuffer from = new StringBuffer();
        from.append(" ON  PARENT .FID =  ENTRY .FParentID \n");
        from.append(" LEFT OUTER JOIN T_SCM_TransactionType TT \n");
        from.append(" ON PARENT.FTransactionTypeID = TT.FID \n");
        from.append(" LEFT OUTER JOIN T_BD_Period AS  YEARPERIOD \n");
        from.append(" ON ( PARENT .FYear =  YEARPERIOD .FPeriodYear AND  PARENT .FPeriod =  YEARPERIOD .FPeriodNumber) \n");
        from.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON ENTRY.FMaterialID=MATERIAL.FID \n");
        from.append(" inner join t_bd_materialCompanyInfo matCom on matCom.FMaterialID = material.FID \n");
        from.append("     and matCom.FCompanyID = " + companyOrgID + " \n");
        StringBuffer where = new StringBuffer();
        where.append(" WHERE (PARENT.FBASESTATUS = 4 AND \n");
        where.append(" TT.FISMANUCOSTCALCULATE = 1 \n");
        where.append(" AND ENTRY.FISPRESENT = 0 \n");
        where.append(" AND ENTRY .FCompanyOrgUnitID =  ");
        where.append(companyOrgID);
        where.append("   AND  YEARPERIOD .FID =  ");
        where.append(periodID);
        where.append("   ) \n");
        where.append(" AND ENTRY .FUnitActualCost <= 0 \n");
        where.append(" and (matCom.FCalculateType = 0 or matCom.FCalculateType = 1) and matCom.FStatus = 1 \n");
        String fromPre = null;
        if ("MR".equalsIgnoreCase(which)) {
            StringBuffer sql1 = new StringBuffer();
            sql1.append(" FROM T_IM_MaterialReqBill AS  PARENT ");
            sql1.append(" LEFT OUTER JOIN T_IM_MaterialReqBillEntry AS ENTRY ");
            fromPre = sql1.toString();
        } else {
            StringBuffer sql2 = new StringBuffer();
            sql2.append(" FROM T_IM_OtherIssueBill AS  PARENT ");
            sql2.append(" LEFT OUTER JOIN T_IM_OtherIssueBillEntry AS ENTRY ");
            fromPre = sql2.toString();
        }
        return new StringBuffer().append("SELECT distinct top 100 \nENTRY.FMATERIALID, PARENT.FNUMBER FBillNumber, MATERIAL.FNumber FMatNumber, MATERIAL.FNAME_L2 FMatName \n").append(fromPre).append(from).append(where).toString();
    }
}

