/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AUXOverheadDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)AUXOverheadDetailReport.class.getName());

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        Assert.that((!StringUtils.isEmpty((String)reportID) ? 1 : 0) != 0);
        Assert.that((filter != null ? 1 : 0) != 0);
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        Context ctx = this.getContext();
        CompanyOrgUnitInfo currCompany = null;
        currCompany = filter.getObject("companyOrg") instanceof CompanyOrgUnitInfo ? (CompanyOrgUnitInfo)filter.getObject("companyOrg") : ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = currCompany.getId().toString();
        String yearFrom = filter.getString("yearForm");
        String yearTo = filter.getString("yearTo");
        String monthFrom = filter.getString("monthFrom");
        String monthTo = filter.getString("monthTo");
        Locale locale = this.getContext().getLocale();
        String TMP_NCM_OverheadDetailRpt = null;
        Connection conn = null;
        Object rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            int periodFrom = this.getPeriodNumber(companyId, yearFrom, monthFrom);
            int periodTo = this.getPeriodNumber(companyId, yearTo, monthTo);
            StringBuffer kSql = new StringBuffer();
            kSql.setLength(0);
            kSql.append("create table TMP_NCM_OverheadDetailRpt(");
            kSql.append(" \tFPeriodID \t\t      varchar(44),");
            kSql.append(" \tFPeriodNumber         varchar(80),");
            kSql.append(" \tFPeriodName \t      varchar(100),");
            kSql.append(" \tFCostCenterID \t\t  varchar(44),");
            kSql.append(" \tFCostCenterNumber \t  varchar(80),");
            kSql.append(" \tFCostCenterName \t  varchar(255), ");
            kSql.append(" \tFBizDate\t\t      varchar(40),");
            kSql.append(" \tFBillNumber\t\t      varchar(80),");
            kSql.append(" \tFBillStatus\t\t      nvarchar(10),");
            kSql.append(" \tFBillEntrySeq\t\t  smallint,");
            kSql.append(" \tFExpenseID\t\t      varchar(44),");
            kSql.append(" \tFExpenseNumber \t      varchar(80),");
            kSql.append(" \tFExpenseName  \t      varchar(255),");
            kSql.append(" \tFAUXOverheadID\t\t  varchar(44),");
            kSql.append(" \tFAUXOverheadNumber \t  varchar(80),");
            kSql.append(" \tFAUXOverheadName  \t  varchar(255),");
            kSql.append(" \tFCostItemID \t\t  varchar(44),");
            kSql.append(" \tFCostItemNumber \t  varchar(80),");
            kSql.append(" \tFCostItemName \t\t  varchar(255),");
            kSql.append(" \tFCostObjectID\t\t  nvarchar(44),");
            kSql.append(" \tFCostObjectNumber \t  varchar(80),");
            kSql.append(" \tFCostObjectName \t  varchar(255),");
            kSql.append("   FModel                nvarchar(255),");
            kSql.append("   FMeasureUnitName      nvarchar(255),");
            kSql.append(" \tFQty \t\t\t      decimal(21,8),");
            kSql.append(" \tFPrice \t\t\t      decimal(21,8),");
            kSql.append(" \tFAmount \t\t\t  decimal(17,4),");
            kSql.append(" \tFDesc \t\t\t      nvarchar(255),");
            kSql.append(" \tFTotalRow \t\t      decimal(21,8) not null default(0),");
            kSql.append(" \tFTotalRow2 \t\t      decimal(21,8) not null default(0),");
            kSql.append(" \tFOrderID \t\t  varchar(44),");
            kSql.append(" \tFOrderNumber \t  varchar(80),");
            kSql.append(" \tFProjectID \t  \t  varchar(44),");
            kSql.append(" \tFProjectNumber \t  varchar(80),");
            kSql.append(" \tFTrackID \t  \t  varchar(44),");
            kSql.append(" \tFTrackNumber \t  varchar(80),");
            kSql.append(" \tFBatchID \t      nvarchar(80),");
            kSql.append(" \tFBatchNumber \t  nvarchar(80),");
            kSql.append(" \tFMaterialID \t  varchar(44),");
            kSql.append(" \tFMaterialNumber   varchar(80),");
            kSql.append(" \tFMaterialName \t  varchar(255),");
            kSql.append("   FIsTotalRow int not null default(1), ");
            kSql.append("   FTotalPeriodRow int not null default(0), ");
            kSql.append("   FTotalCostCenterRow int not null default(0), ");
            kSql.append("\tFQtyDecimal \t      int default(4),");
            kSql.append("\tFPriceDecimal \t      int default(2),");
            kSql.append("\tFAmountDecimal \t      int default(2)");
            kSql.append(" ) ");
            TMP_NCM_OverheadDetailRpt = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_OverheadDetailRpt, "FPeriodID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_OverheadDetailRpt, "FExpenseID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_OverheadDetailRpt, "FAUXOverheadID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_OverheadDetailRpt, "FCostCenterID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TMP_NCM_OverheadDetailRpt, "FCostItemID", false, false);
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_OverheadDetailRpt + " \n");
            kSql.append("            (FPeriodID, \n");
            kSql.append("             FPeriodNumber, \n");
            kSql.append("             FPeriodName, \n");
            kSql.append("             FCostCenterID, \n");
            kSql.append("             FCostCenterNumber, \n");
            kSql.append("             FCostCenterName, \n");
            kSql.append("             FBizDate, \n");
            kSql.append("             FBillNumber, \n");
            kSql.append("             FBillStatus, \n");
            kSql.append("             FBillEntrySeq, \n");
            kSql.append("             FExpenseID, \n");
            kSql.append("             FExpenseNumber, \n");
            kSql.append("             FExpenseName, \n");
            kSql.append("             FAUXOverheadID, \n");
            kSql.append("             FAUXOverheadNumber, \n");
            kSql.append("             FAUXOverheadName, \n");
            kSql.append("             FCostItemID, \n");
            kSql.append("             FCostItemNumber, \n");
            kSql.append("             FCostItemName, \n");
            kSql.append("             FCostObjectID, \n");
            kSql.append("             FCostObjectNumber, \n");
            kSql.append("             FCostObjectName, \n");
            kSql.append("\t\t\t  FOrderID, \n");
            kSql.append("\t\t \t  FOrderNumber,\n");
            kSql.append("\t\t\t  FProjectID,\n");
            kSql.append("\t\t\t  FProjectNumber,\n");
            kSql.append("\t\t\t  FTrackID,\n");
            kSql.append("\t\t\t  FTrackNumber,\n");
            kSql.append("\t\t\t  FMaterialID,\n");
            kSql.append("\t\t\t  FMaterialNumber,\n");
            kSql.append("\t\t\t  FMaterialName,\n");
            kSql.append("\t\t\t  FBatchID,\n");
            kSql.append("\t\t\t  FBatchNumber,\n");
            kSql.append("             FModel, \n");
            kSql.append("             FMeasureUnitName, \n");
            kSql.append("             FQty, \n");
            kSql.append("             FPrice, \n");
            kSql.append("             FAmount, \n");
            kSql.append("             FDesc, \n");
            kSql.append("             FTotalRow, \n");
            kSql.append("             FTotalRow2, \n");
            kSql.append("             FQtyDecimal, \n");
            kSql.append("             FPriceDecimal, \n");
            kSql.append("             FAmountDecimal, \n");
            kSql.append("             FIsTotalRow) \n");
            kSql.append(" SELECT DISTINCT \n");
            kSql.append("        period.FID AS FPeriodID, \n");
            kSql.append("        TO_CHAR(period.FNumber) AS FPeriodNumber, \n");
            kSql.append("        (TO_CHAR(period.FPeriodYear) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + "' || TO_CHAR(period.FPeriodNumber) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"178_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "') AS FPeriodName, \n");
            kSql.append("        cc.FID AS FCostCenterID, \n");
            kSql.append("        cc.FNumber AS FCostCenterNumber, \n");
            kSql.append("        cc.FName_" + locale.getLanguage() + " AS FCostCenterName, \n");
            kSql.append("        TO_CHAR(innerBill.FBizDate,'yyyy-MM-dd') AS FBizDate, \n");
            kSql.append("        innerBill.FNumber AS FBillNumber, \n");
            kSql.append("        '" + BillBaseStatusEnum.AUDITED.getAlias() + "' AS FBillStatus, \n");
            kSql.append("        innerBillEntry.FSeq AS FBillEntrySeq, \n");
            kSql.append("        exp.FID AS FExpenseID, \n");
            kSql.append("        exp.FNumber AS FExpenseNumber, \n");
            kSql.append("        exp.FName_" + locale.getLanguage() + " AS FExpenseName, \n");
            kSql.append("        aux.FID AS FAUXOverheadID, \n");
            kSql.append("        aux.FNumber AS FAUXOverheadNumber, \n");
            kSql.append("        aux.FName_" + locale.getLanguage() + " AS FAUXOverheadName, \n");
            kSql.append("        ci.FID AS FCostItemID, \n");
            kSql.append("        ci.FNumber FCostItemNumber, \n");
            kSql.append("        ci.Fname_" + locale.getLanguage() + " AS FCostItemName, \n");
            kSql.append("        co.FID AS FCostObjectID, \n");
            kSql.append("        co.FNumber AS FCostObjectNumber, \n");
            kSql.append("        co.FName_" + locale.getLanguage() + " AS FCostObjectName, \n");
            kSql.append("\t\t co.FOrderID as FOrderID, \n");
            kSql.append("\t\t co.FOrderNumber as FOrderNumber, \n");
            kSql.append("\t\t co.FProjectID as FProjectID, \n");
            kSql.append("\t\t po.FNumber as FProjectNumber, \n");
            kSql.append("\t\t co.FTrackID as FTrackID, \n");
            kSql.append("\t\t tr.FNumber as FTrackNumber, \n");
            kSql.append("\t\t co.FStdProductIDID as FMaterialID, \n");
            kSql.append("\t\t mat.FNumber as FMaterialNumber, \n");
            kSql.append("\t\t mat.FName_" + locale.getLanguage() + " as FMaterialName, \n");
            kSql.append("\t\t co.FBatchNumber as FBatchID, \n");
            kSql.append("\t\t co.FBatchNumber as FBatchNumber, \n");
            kSql.append("        NULL AS FModel, \n");
            kSql.append("        mu.FName_" + locale.getLanguage() + " AS FMeasureUnitName, \n");
            kSql.append("        innerBillEntry.FQty AS FQty, \n");
            kSql.append("        innerBillEntry.FActualPrice AS FPrice, \n");
            kSql.append("        innerBillEntry.FActualAmount AS FAmount, \n");
            kSql.append("        innerBillEntry.FRemark_" + locale.getLanguage() + " AS FDesc, \n");
            kSql.append("        0 AS FTotalRow, \n");
            kSql.append("        0 AS FTotalRow2, \n");
            kSql.append("        aux.FQtyPrecision AS FQtyDecimal, \n");
            kSql.append("        axuCompany.FPricePrecision AS FPriceDecimal, \n");
            kSql.append("        2 AS FAmountDecimal, \n");
            kSql.append("        0 AS FIsTotalRow \n");
            kSql.append(" FROM   T_NCM_InnerOverheadBill innerBill \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_InnerOverheadBillEntry innerBillEntry \n");
            kSql.append("          ON innerBill.FID = innerBillEntry.FParentID \n");
            kSql.append("        LEFT OUTER JOIN T_BD_Period period \n");
            kSql.append("          ON innerBill.FCalculatePeriod = period.FID \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_AUXOverhead aux \n");
            kSql.append("          ON innerBillEntry.FAUXOverheadID = aux.FID \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_AUXOverheadCompanyInfo axuCompany \n");
            kSql.append("          ON axuCompany.FAUXOverheadID = aux.FID \n");
            kSql.append("   \t\t AND  axuCompany.FCompanyID = '" + companyId + "' \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_Expense exp \n");
            kSql.append("          ON axuCompany.FDefaultExpenseID = exp.FID \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_ExpenseCompanyInfo expCompany \n");
            kSql.append("          ON expCompany.FExpenseID = exp.FID \n");
            kSql.append("           AND  expCompany.FCompanyOrgUnitID = '" + companyId + "' \n");
            kSql.append("        LEFT OUTER JOIN T_NCM_CostItem ci \n");
            kSql.append("          ON expCompany.FCostItemID = ci.FID \n");
            kSql.append("        LEFT OUTER JOIN T_ORG_CostCenter cc \n");
            kSql.append("          ON innerBillEntry.FConsumeCostCenterID = cc.FID \n");
            kSql.append("        LEFT OUTER JOIN T_BD_CostObject co \n");
            kSql.append("          ON innerBillEntry.FConsumeCostObjectID = co.FID \n");
            kSql.append("\t\t left join t_mm_project po on co.FProjectID = po.FID \n");
            kSql.append("\t\t left join t_mm_trackNumber tr on co.FTrackID = tr.FID \n");
            kSql.append("\t\t left join t_bd_material mat on co.FStdProductIDID = mat.FID \n");
            kSql.append("        LEFT OUTER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("          ON innerBillEntry.FMeasureUnitID = mu.FID \n");
            kSql.append(" WHERE  innerBill.FCompanyOrg = '" + companyId + "'\n");
            kSql.append("   AND  innerBill.FBillStatus = 4 \n");
            kSql.append("   AND  period.FNumber >= " + periodFrom + " \n");
            kSql.append("   AND  period.FNumber <= " + periodTo + " \n");
            if (this.isFilterCostCenter(filter)) {
                kSql.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
            }
            if (this.isFilterExpense(filter)) {
                kSql.append("  AND exp.FNumber in (" + this.filterExpense(filter) + ") \n");
            }
            if (this.isFilterOverhead(filter)) {
                kSql.append("  AND aux.FNumber in (" + this.filterOverhead(filter) + ") \n");
            }
            if (this.isFilterCostObject(filter)) {
                kSql.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
            }
            if (this.isFilterCostItem(filter)) {
                kSql.append("  AND ci.FNumber in (" + this.filterCostItem(filter) + ") \n");
            }
            if (this.isFilterOrder(filter)) {
                kSql.append("  AND co.FOrderNumber in (" + this.filterOrder(filter) + ") \n");
            }
            if (this.isFilterBatchNumber(filter)) {
                kSql.append("  AND co.FBatchNumber in (" + this.filterBatchNumber(filter) + ") \n");
            }
            if (this.isFilterProjectNumber(filter)) {
                kSql.append("  AND po.FNumber in (" + this.filterProjectNumber(filter) + ") \n");
            }
            if (this.isFilterTrackNumber(filter)) {
                kSql.append("  AND tr.FNumber in (" + this.filterTrackNumber(filter) + ") \n");
            }
            if (this.isFilterMaterialNumber(filter)) {
                kSql.append("  AND mat.FNumber in (" + this.filterMaterialNumber(filter) + ") \n");
            }
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            StringBuffer updateDecimalSql = new StringBuffer();
            updateDecimalSql.append("UPDATE ").append(TMP_NCM_OverheadDetailRpt).append(" SET (FAmountDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyId).append("'").append(" \n").append(")").append(" \n");
            updateDecimalSql.append("\n\n;");
            String upDecimalSql = updateDecimalSql.toString();
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)upDecimalSql);
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TMP_NCM_OverheadDetailRpt);
            String[] fields = this.getGroupByFields((ArrayList)filter.getObject("table"));
            kSql.setLength(0);
            if (fields != null) {
                kSql.append(" INSERT INTO " + TMP_NCM_OverheadDetailRpt + " \n");
                kSql.append("   (FTotalRow, \n");
                kSql.append("    FTotalRow2, \n");
                kSql.append("    " + fields[0] + ", \n");
                kSql.append("    FQtyDecimal, \n");
                kSql.append("    FPriceDecimal, \n");
                kSql.append("    FAmountDecimal, \n");
                kSql.append("    FAmount) \n");
                kSql.append("   SELECT " + fields[1] + ",\n");
                kSql.append("          CASE WHEN GROUPING(" + fields[2] + ") = 1 THEN 1 ELSE 0 END,\n");
                kSql.append("          " + fields[0] + ",");
                kSql.append("          ISNULL(MAX(FQtyDecimal), 0),\n");
                kSql.append("          ISNULL(MAX(FPriceDecimal), 0), \n");
                kSql.append("          ISNULL(MAX(FAmountDecimal), 0), \n");
                kSql.append("          SUM(FAmount) \n");
                kSql.append("     FROM " + TMP_NCM_OverheadDetailRpt + " \n");
                kSql.append("    WHERE FTotalRow = 0 \n");
                kSql.append("     GROUP BY \n");
                kSql.append("           " + fields[0] + " \n");
                kSql.append("        WITH ROLLUP \n");
            } else {
                kSql.append(" INSERT INTO " + TMP_NCM_OverheadDetailRpt + " \n");
                kSql.append("   (FTotalRow, \n");
                kSql.append("    FTotalRow2, \n");
                kSql.append("    FQtyDecimal, \n");
                kSql.append("    FPriceDecimal, \n");
                kSql.append("    FAmountDecimal, \n");
                kSql.append("    FAmount) \n");
                kSql.append("   SELECT 105,\n");
                kSql.append("          1,");
                kSql.append("          ISNULL(MAX(FQtyDecimal), 0),\n");
                kSql.append("          ISNULL(MAX(FPriceDecimal), 0), \n");
                kSql.append("          ISNULL(MAX(FAmountDecimal), 0), \n");
                kSql.append("          SUM(FAmount) \n");
                kSql.append("     FROM " + TMP_NCM_OverheadDetailRpt + " \n");
                kSql.append("    WHERE FTotalRow = 0 \n");
            }
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_OverheadDetailRpt + " \n");
            kSql.append("    SET (FPeriodNumber, FPeriodName) =  \n");
            kSql.append("    (SELECT TO_CHAR(prd.FNumber), \n");
            kSql.append("            (TO_CHAR(prd.FPeriodYear) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + "' || TO_CHAR(prd.FPeriodNumber) || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"178_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "') \n");
            kSql.append("      FROM T_BD_Period prd \n");
            kSql.append("     WHERE prd.FID = " + TMP_NCM_OverheadDetailRpt + ".FPeriodID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_OverheadDetailRpt + " \n");
            kSql.append("    SET (FCostCenterNumber, FCostCenterName) =  \n");
            kSql.append("    (SELECT cc.FNumber, \n");
            kSql.append("            cc.FName_" + locale.getLanguage() + " \n");
            kSql.append("      FROM T_ORG_CostCenter cc \n");
            kSql.append("     WHERE cc.FID = " + TMP_NCM_OverheadDetailRpt + ".FCostCenterID) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_OverheadDetailRpt + " \n");
            kSql.append("    SET (FMaterialNumber, FMaterialName) =  \n");
            kSql.append("    (SELECT au.FNumber, \n");
            kSql.append("            au.FName_" + locale.getLanguage() + " \n");
            kSql.append("      FROM T_BD_CostObject co \n");
            kSql.append("\t   left join T_NCM_AUXOverhead au on au.FID = co.FRelatedID \n");
            kSql.append("     WHERE co.FID = " + TMP_NCM_OverheadDetailRpt + ".FCostObjectID \t  and co.FRelatedType = 3) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            StringBuffer orderBy = new StringBuffer();
            ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
            kSql.setLength(0);
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                String field = (String)map.get("id");
                String fieldName = field.substring(0, field.length() - 2) + "Name";
                String fieldNumber = field.substring(0, field.length() - 2) + "Number";
                String whichTotal = "";
                String orderByWhichTotal = "";
                if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                    whichTotal = ", FTotalPeriodRow = 1 ";
                    orderByWhichTotal = ", FTotalPeriodRow " + orderByMode;
                }
                if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                    whichTotal = ", FTotalCostCenterRow = 1 ";
                    orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
                }
                kSql.append(" update " + TMP_NCM_OverheadDetailRpt + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
                kSql.append(whichTotal);
                kSql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                kSql.append(";");
                orderBy.append(fieldNumber);
                orderBy.append(orderByWhichTotal);
                orderBy.append(",");
            }
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + TMP_NCM_OverheadDetailRpt + "\n");
            kSql.append("    SET FPeriodNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n");
            kSql.append("        FTotalRow = 200 \n");
            kSql.append("  WHERE FTotalRow2 = 1 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
            String where = "";
            if (isOnlyDisplayTotal) {
                where = " Where FIsTotalRow = 1 ";
            }
            kSql.setLength(0);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return TMP_NCM_OverheadDetailRpt;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer orderBy = new StringBuffer();
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
                orderByWhichTotal = ", FTotalPeriodRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
            }
            orderBy.append(fieldNumber);
            orderBy.append(orderByWhichTotal);
            orderBy.append(",");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " Order by FTotalRow2 " + orderByMode + "," + orderBy + " FTotalRow ,FBillNumber,FBillEntrySeq "), (int)start, (int)rows);
        return rs;
    }

    private boolean isFilterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenters");
        return !StringUtils.isEmpty((String)costCenterNumbers);
    }

    private StringBuffer filterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenters");
        String[] numbers = costCenterNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterExpense(RptParams filter) throws Exception {
        String expenseNumbers = filter.getString("expense");
        return !StringUtils.isEmpty((String)expenseNumbers);
    }

    private StringBuffer filterExpense(RptParams filter) throws Exception {
        String expenseNumbers = filter.getString("expense");
        String[] numbers = expenseNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("overhead");
        return !StringUtils.isEmpty((String)overheadNumbers);
    }

    private StringBuffer filterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("overhead");
        String[] numbers = overheadNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjects");
        return !StringUtils.isEmpty((String)costObjectNumbers);
    }

    private StringBuffer filterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjects");
        String[] numbers = costObjectNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItems");
        return !StringUtils.isEmpty((String)costItemNumbers);
    }

    private StringBuffer filterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItems");
        String[] numbers = costItemNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterOrder(RptParams filter) throws Exception {
        String orderNumbers = filter.getString("order");
        return !StringUtils.isEmpty((String)orderNumbers);
    }

    private StringBuffer filterOrder(RptParams filter) throws Exception {
        String orderNumbers = filter.getString("order");
        String[] numbers = orderNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterBatchNumber(RptParams filter) throws Exception {
        String batchNumbers = filter.getString("batchNumber");
        return !StringUtils.isEmpty((String)batchNumbers);
    }

    private StringBuffer filterBatchNumber(RptParams filter) throws Exception {
        String batchNumbers = filter.getString("batchNumber");
        String[] numbers = batchNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterProjectNumber(RptParams filter) throws Exception {
        String projectNumbers = filter.getString("projectNumber");
        return !StringUtils.isEmpty((String)projectNumbers);
    }

    private StringBuffer filterProjectNumber(RptParams filter) throws Exception {
        String projectNumbers = filter.getString("projectNumber");
        String[] numbers = projectNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterTrackNumber(RptParams filter) throws Exception {
        String trackNumbers = filter.getString("trackNumber");
        return !StringUtils.isEmpty((String)trackNumbers);
    }

    private StringBuffer filterTrackNumber(RptParams filter) throws Exception {
        String trackNumbers = filter.getString("trackNumber");
        String[] numbers = trackNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterMaterialNumber(RptParams filter) throws Exception {
        String materialNumbers = filter.getString("material");
        return !StringUtils.isEmpty((String)materialNumbers);
    }

    private StringBuffer filterMaterialNumber(RptParams filter) throws Exception {
        String materialNumbers = filter.getString("material");
        String[] numbers = materialNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private StringBuffer generateCondtion(String[] numbers) {
        Object[] numbersObj = new Object[numbers.length];
        System.arraycopy(numbers, 0, numbersObj, 0, numbers.length);
        return BDCMUtils.splitPK((Object[])numbersObj);
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyOrg");
        String companyName = "";
        companyName = companyInfo == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : companyInfo.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + companyName);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"24_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearForm") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("monthFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("monthTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        String costCenters = filter.getString("costCenters");
        String costCenterNumbers = "";
        costCenterNumbers = StringUtils.isEmpty((String)costCenters) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costCenters.replaceAll(";", ",");
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"26_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costCenterNumbers);
        String expenses = filter.getString("expense");
        String expenseNumbers = "";
        expenseNumbers = StringUtils.isEmpty((String)expenses) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : expenses.replaceAll(";", ",");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"27_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + expenseNumbers);
        String overheads = filter.getString("overhead");
        String overheadNumbers = "";
        overheadNumbers = StringUtils.isEmpty((String)overheads) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : overheads.replaceAll(";", ",");
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"28_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + overheadNumbers);
        String costObjects = filter.getString("costObjects");
        String costObjectNumbers = "";
        costObjectNumbers = StringUtils.isEmpty((String)costObjects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costObjects.replaceAll(";", ",");
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"29_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costObjectNumbers);
        String orders = filter.getString("order");
        String orderNumbers = "";
        orderNumbers = StringUtils.isEmpty((String)orders) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : orders.replaceAll(";", ",");
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()) + "\uff1a" + orderNumbers);
        String batchs = filter.getString("batchNumber");
        String batchNumbers = "";
        batchNumbers = StringUtils.isEmpty((String)batchs) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : batchs.replaceAll(";", ",");
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()) + "\uff1a" + batchNumbers);
        String projects = filter.getString("projectNumber");
        String projectNumbers = "";
        projectNumbers = StringUtils.isEmpty((String)projects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : projects.replaceAll(";", ",");
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()) + "\uff1a" + projectNumbers);
        String tracks = filter.getString("trackNumber");
        String trackNumbers = "";
        trackNumbers = StringUtils.isEmpty((String)tracks) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : tracks.replaceAll(";", ",");
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()) + "\uff1a" + trackNumbers);
        String materials = filter.getString("material");
        String materialNumbers = "";
        materialNumbers = StringUtils.isEmpty((String)materials) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : materials.replaceAll(";", ",");
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_Material", (Locale)ctx.getLocale()) + "\uff1a" + materialNumbers);
        String costItems = filter.getString("costItems");
        String costItemNumbers = "";
        costItemNumbers = StringUtils.isEmpty((String)costItems) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costItems.replaceAll(";", ",");
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"30_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costItemNumbers);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = new ReportHeader();
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        int index = 1;
        for (int i = 0; i < orderStrings.length; ++i) {
            ++index;
            if (orderStrings[i].equalsIgnoreCase("FPeriodNumber")) {
                reportHeader.addChild("FPeriodNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"192_AUXOverheadDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
            }
            if (orderStrings[i].equalsIgnoreCase("FPeriodName")) {
                reportHeader.addChild("FPeriodName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"193_AUXOverheadDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(1);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostcenterName")) continue;
            reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
        }
        reportHeader.addChild("FBizDate", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BizDate", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FBillNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FBillStatus", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillStatus", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FBillEntrySeq", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillEntrySeq", (Locale)ctx.getLocale())).setAlign(2).setIndex(index++);
        reportHeader.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FAUXOverheadNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FAUXOverheadName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++ + 4);
        reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMeasureUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Unit", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimalField("FQtyDecimal");
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ActualPrice", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimalField("FPriceDecimal");
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ActualAmount", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimalField("FAmountDecimal");
        reportHeader.addChild("FDesc", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Remark", (Locale)ctx.getLocale())).setAlign(1);
        reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 16);
        reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), 17);
        reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 18);
        reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 19);
        reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()), 20);
        reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()), 21);
        return reportHeader;
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = Integer.valueOf(temp);
        return number;
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private String[] getGroupByFields(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sqlCase = new StringBuffer();
        String firstFields = null;
        sqlCase.append(" case ");
        int n = 105;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            sqlCase.append(" when grouping(" + fieldID + ") = 1 then " + n + " \n");
            if (firstFields == null) {
                firstFields = fieldID;
            }
            --n;
        }
        sqlCase.append(" else " + n + " end ");
        if (sb.length() == 0) {
            return null;
        }
        return new String[]{sb.toString(), sqlCase.toString(), firstFields};
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }
}

