/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Locale;

public class AuxAllocDiffReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.report.AuxAllocDiffReportResource";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append("order by FCostCenterNumber, FAUXOverheadNumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    private boolean isSumByCC(RptParams filter) {
        return filter.getBoolean("isSumByCC");
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FCostCenterID varchar(44), \n");
        ksql.append("    FCostCenterNumber varchar(80), \n");
        ksql.append("    FCostCenterName nvarchar(256), \n");
        ksql.append("    FCostObjectID varchar(44), \n");
        ksql.append("    FAUXOverheadID varchar(44), \n");
        ksql.append("    FAUXOverheadNumber varchar(80), \n");
        ksql.append("    FAUXOverheadName nvarchar(256), \n");
        ksql.append("    FExpenseID varchar(44), \n");
        ksql.append("    FExpenseNumber varchar(80), \n");
        ksql.append("    FExpenseName nvarchar(256), \n");
        ksql.append("    FCostItemID varchar(44), \n");
        ksql.append("    FCostItemNumber varchar(80), \n");
        ksql.append("    FCostItemName nvarchar(256), \n");
        ksql.append("    FActualAmount decimal(21,8) default(0), \n");
        ksql.append("    FPlanAmount decimal(21,8) default(0), \n");
        ksql.append("    FDiffAmount decimal(21,8) default(0), \n");
        ksql.append("    FIsCostCenterTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        String T_NCM_LinearEquations;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        String tempTable = this.createReportDataTempTable();
        String loc = this.getContext().getLocale().getLanguage();
        String sPeriod = filter.getString("period");
        int period = Integer.parseInt(sPeriod);
        try {
            T_NCM_LinearEquations = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_LinearEquations", (int)period, (int)period);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("     FCostCenterID, \n");
        ksql.append("     FCostObjectID, \n");
        ksql.append("     FAUXOverheadID, \n");
        ksql.append("     FExpenseID, \n");
        ksql.append("     FCostItemID, \n");
        ksql.append("     FActualAmount, \n");
        ksql.append("     FPlanAmount, \n");
        ksql.append("     FDiffAmount \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    lin.FCostCenterID FCostCenterID, \n");
        ksql.append("    lin.FCostObjectID FCostObjectID, \n");
        ksql.append("    aux.FID FAUXOverheadID, \n");
        ksql.append("    e.FID FExpenseID, \n");
        ksql.append("    ci.FID FCostItemID, \n");
        ksql.append("    lin.FTotalAmount FActualAmount, \n");
        ksql.append("    (lin.FTotalQty * lin.FUnitPrice) FPlanAmount, \n");
        ksql.append("    0 FDiffAmount \n");
        ksql.append("from " + T_NCM_LinearEquations + " lin \n");
        ksql.append("join T_BD_PERIOD p \n");
        ksql.append("    on p.FID = lin.FCalculatePeriodID \n");
        ksql.append("join T_ORG_CostCenter cc \n");
        ksql.append("    on cc.FID = lin.FCostCenterID \n");
        ksql.append("join T_BD_CostObject co \n");
        ksql.append("    on co.FID = lin.FCostObjectID \n");
        ksql.append("join T_NCM_AUXOverhead aux \n");
        ksql.append("    on aux.FID = co.FRelatedID \n");
        ksql.append("join T_NCM_AUXOverheadCompanyInfo auxcom \n");
        ksql.append("    on auxcom.FAUXOverheadID = aux.FID \n");
        ksql.append("    and auxcom.FCompanyID = '" + companyId + "' \n");
        ksql.append("join T_NCM_Expense e \n");
        ksql.append("    on e.FID = auxcom.FDefaultExpenseID \n");
        ksql.append("join T_NCM_ExpenseCompanyInfo ecom \n");
        ksql.append("    on ecom.FExpenseID = e.FID \n");
        ksql.append("    and ecom.FCompanyOrgUnitID = '" + companyId + "' \n");
        ksql.append("join T_NCM_CostItem ci \n");
        ksql.append("    on ci.FID = ecom.FCostItemID \n");
        ksql.append("where lin.FCompanyID = '" + companyId + "' \n");
        ksql.append("and p.FNumber = " + period + " \n");
        String temp = filter.getString("costCenterFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and cc.FNumber >= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costCenterTo")))) {
            ksql.append(" and cc.FNumber <= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("auxOverheadFrom")))) {
            ksql.append(" and aux.FNumber >= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("auxOverheadTo")))) {
            ksql.append(" and aux.FNumber <= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("expenseFrom")))) {
            ksql.append(" and e.FNumber >= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("expenseTo")))) {
            ksql.append(" and e.FNumber <= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costItemFrom")))) {
            ksql.append(" and ci.FNumber >= '").append(temp).append("' \n");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costItemTo")))) {
            ksql.append(" and ci.FNumber <= '").append(temp).append("' \n");
        }
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        if (this.isSumByCC(filter)) {
            ksql.append("insert into " + tempTable + " \n");
            ksql.append("( \n");
            ksql.append("    FCostCenterID, \n");
            ksql.append("    FActualAmount, \n");
            ksql.append("    FPlanAmount, \n");
            ksql.append("    FDiffAmount, \n");
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsCostCenterTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FCostCenterID FCostCenterID, \n");
            ksql.append("    sum(FActualAmount) FActualAmount, \n");
            ksql.append("    sum(FPlanAmount) FPlanAmount, \n");
            ksql.append("    0 FDiffAmount, \n");
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    1 FIsCostCenterTotalRow \n");
            ksql.append("from " + tempTable + " r \n");
            ksql.append("group by FCostCenterID \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FCostCenterNumber, \n");
        ksql.append("    FActualAmount, \n");
        ksql.append("    FPlanAmount, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    '" + this.getResource("sum") + "' FCostCenterNumber, \n");
        ksql.append("    sum(FActualAmount) FActualAmount, \n");
        ksql.append("    sum(FPlanAmount) FPlanAmount, \n");
        ksql.append("    1 FIsTotalRow \n");
        ksql.append("from " + tempTable + " r \n");
        ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set \n");
        ksql.append("    FDiffAmount = FActualAmount - FPlanAmount \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FCostCenterNumber, \n");
        ksql.append("    FCostCenterName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        cc.FNumber, \n");
        ksql.append("        cc.FName_" + loc + " \n");
        ksql.append("    from T_ORG_CostCenter cc \n");
        ksql.append("    where cc.FID = r.FCostCenterID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FAUXOverheadNumber, \n");
        ksql.append("    FAUXOverheadName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        aux.FNumber, \n");
        ksql.append("        aux.FName_" + loc + " \n");
        ksql.append("    from T_NCM_AUXOverhead aux \n");
        ksql.append("    where aux.FID = r.FAUXOverheadID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FExpenseNumber, \n");
        ksql.append("    FExpenseName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        e.FNumber, \n");
        ksql.append("        e.FName_" + loc + " \n");
        ksql.append("    from T_NCM_Expense e \n");
        ksql.append("    where e.FID = r.FExpenseID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FCostItemNumber, \n");
        ksql.append("    FCostItemName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        ci.FNumber, \n");
        ksql.append("        ci.FName_" + loc + " \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = r.FCostItemID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FCostCenterName = FCostCenterName || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsCostCenterTotalRow = 1 \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        return tempTable;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        titles.AddTitle(0, this.getResource("company") + company.getName());
        titles.AddTitle(1, this.getResource("period") + filter.getString("period"));
        titles.AddTitle(2, this.getResource("costCenter") + this.buildFilterRange(filter.getString("costCenterFrom"), filter.getString("costCenterTo")));
        titles.AddTitle(3, this.getResource("auxOverhead") + this.buildFilterRange(filter.getString("auxOverheadFrom"), filter.getString("auxOverheadTo")));
        titles.AddTitle(4, this.getResource("expense") + this.buildFilterRange(filter.getString("expenseFrom"), filter.getString("expenseTo")));
        titles.AddTitle(5, this.getResource("costItem") + this.buildFilterRange(filter.getString("costItemFrom"), filter.getString("costItemTo")));
        return titles;
    }

    private String buildFilterRange(String from, String to) {
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"all", (Locale)this.getContext().getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"fromFirstTo", (Locale)this.getContext().getLocale()) + " " + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"from", (Locale)this.getContext().getLocale()) + " " + from + " " + ResourceBase.getString((String)RES_CLASSNAME, (String)"toLast", (Locale)this.getContext().getLocale());
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)"from", (Locale)this.getContext().getLocale()) + " " + from + " " + ResourceBase.getString((String)RES_CLASSNAME, (String)"to", (Locale)this.getContext().getLocale()) + " " + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        int amountPrecision = 2;
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
            amountPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        ReportHeader reportHeader = new ReportHeader();
        int index = 0;
        reportHeader.addChild("FCostCenterNumber", this.getResource("FCostCenterNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostCenterName", this.getResource("FCostCenterName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FAUXOverheadNumber", this.getResource("FAUXOverheadNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FAUXOverheadName", this.getResource("FAUXOverheadName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FExpenseNumber", this.getResource("FExpenseNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FExpenseName", this.getResource("FExpenseName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostItemNumber", this.getResource("FCostItemNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostItemName", this.getResource("FCostItemName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActualAmount", this.getResource("FActualAmount"), index++).setAlign(3).setType(2).setDecimal(amountPrecision);
        reportHeader.addChild("FPlanAmount", this.getResource("FPlanAmount"), index++).setAlign(3).setType(2).setDecimal(amountPrecision);
        reportHeader.addChild("FDiffAmount", this.getResource("FDiffAmount"), index++).setAlign(3).setType(2).setDecimal(amountPrecision);
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

