/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AuxFeeAllocResultReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger(AuxFeeAllocResultReport.class);
    protected static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String sTableName = super.getTablename();
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" UPDATE " + sTableName + " \n");
        kSql.append("    SET (FMaterialNumber, FMaterialName) =  \n");
        kSql.append("    (SELECT au.FNumber, \n");
        kSql.append("            au.FName_" + this.getContext().getLocale().getLanguage() + " \n");
        kSql.append("      FROM T_BD_CostObject co \n");
        kSql.append("\t   left join T_NCM_AUXOverhead au on au.FID = co.FRelatedID \n");
        kSql.append("     WHERE co.FID = " + sTableName + ".FCostObjectID \t  and co.FRelatedType = 3) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName + this.getORDERBY()));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String sTableName = null;
        try {
            sTableName = this.buildReportDataTableName(filter);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.setTablename(sTableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + this.getORDERBY()), (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataTableName(RptParams filter) throws Exception {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyOrg")).getId().toString();
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String companyName = company.getName();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        int amtPrecision = currency.getPrecision();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        String sTmpTblName = this.createTmpTable();
        String sqlAll = this.getSQL(companyName, amtPrecision, filter, physicalTblNames, sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sqlAll, (Object[])new String[]{companyID});
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" UPDATE " + sTmpTblName + " \n");
        kSql.append("    SET (FMaterialNumber, FMaterialName) =  \n");
        kSql.append("    (SELECT au.FNumber, \n");
        kSql.append("            au.FName_" + this.getContext().getLocale().getLanguage() + " \n");
        kSql.append("      FROM T_BD_CostObject co \n");
        kSql.append("\t   left join T_NCM_AUXOverhead au on au.FID = co.FRelatedID \n");
        kSql.append("     WHERE co.FID = " + sTmpTblName + ".FCostObjectID \t  and co.FRelatedType = 3) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        super.setTablename(sTmpTblName);
        return sTmpTblName;
    }

    protected void updateSEQ(StringBuffer processSumSql, String[] physicalTblNames, String sTmpTblName) {
        processSumSql.append("update ").append(sTmpTblName).append(" AS T set ").append(this.getSEQField()).append(" = ").append('\n').append(" ( SELECT ").append(this.getSEQField()).append(" * 100 FROM ").append(physicalTblNames[0]).append(" WHERE FID = T.FID ) where T.FTotalRow <>  ").append(4).append(" ; ").append('\n');
        processSumSql.append("update ").append(sTmpTblName).append(" AS T set ").append(this.getSEQField()).append(" = ").append('\n').append(" ( SELECT TOP 1 B.").append(this.getSEQField()).append(" - 5 FROM ").append(sTmpTblName).append('\n').append(" B where B.FTotalRow = ").append(3).append(" AND T.FProductID = B.FProductID and T.FCostItemGroupID =B.FCostItemGroupID ").append(this.getORDERBY()).append('\n').append(" ) where T.FTotalRow = ").append(4).append(" ; ").append('\n');
    }

    protected void updateFTotalRow(StringBuffer sql, String tempTableNameSum, RptParams filter) {
        sql.append('\n').append(" UPDATE ").append(tempTableNameSum).append(" SET FTotalRow = ( ").append('\n').append(" CASE ").append('\n').append(" WHEN  FCostItemID is NOT null AND FMaterialID is null THEN ").append(3).append('\n').append(" WHEN  FCostItemGroupID is null AND FCostItemID is null THEN ").append(5).append('\n').append(" WHEN FCostItemGroupID is not null AND FCostItemID is null AND FMaterialID is null THEN  ").append(4).append('\n').append(" ELSE ").append(0).append('\n').append(" END ").append('\n').append(" ) ; ");
    }

    protected StringBuffer insertDataToTableSum(StringBuffer sql, String tempTableNameSum, RptParams filter) {
        sql.append('\n').append("INSERT INTO ").append(tempTableNameSum).append('\n').append(" ( FID, FProductId,FPeriodDispNumber,FProductNumber ,FCostItemGroupID,FTotalRow,FCostItemNumber,FCostItemName ").append('\n').append(",FBeforeQty ,FBeforeAmount  ,FSFPQty,FSFPAmount,FProcessQty,FProcessAmount ,FAfterQty,FAfterAmount ").append('\n').append(" ,FQtyDecimal,FPriceDecimal,FAmountDecimal  )                                        \t\t\t\t").append('\n').append(" SELECT newbosid('43218765'),FProductId,FPeriodDispNumber,FProductNumber, FCostItemGroupID,       ").append(4).append('\n').append(" ,FCostItemGroupNumber,FCostItemGroupName,sum(FBeforeQty) ,sum(FBeforeAmount),sum(FSFPQty),sum(FSFPAmount),sum(FProcessQty) ").append('\n').append(" ,sum(FProcessAmount) ,sum(FAfterQty),sum(FAfterAmount)                                            ").append('\n').append(" ,FQtyDecimal,FPriceDecimal,FAmountDecimal                                          \t\t\t\t").append('\n').append(" FROM   ").append(tempTableNameSum).append('\n').append(" WHERE FTotalRow =   ").append(3).append('\n').append(" AND FCostItemGroupID is NOT null").append(" GROUP BY FProductId,FPeriodDispNumber,FProductNumber,FCostItemGroupID                             ").append('\n').append(" ,FCostItemGroupNumber,FCostItemGroupName,FQtyDecimal,FPriceDecimal,FAmountDecimal                \t").append('\n').append(" ; ");
        return sql;
    }

    protected String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException, SQLException {
        int fromPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
        int toPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        String[] physicalTblNames = new String[]{NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_AuxAllocResult", (int)fromPeriod, (int)toPeriod)};
        return physicalTblNames;
    }

    protected String createTmpTable() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("Create Table t_SUN ( ").append("FOrgName\t \t\t\tVARCHAR(255),").append("FPeriodNumber\t\t \tVARCHAR(50),").append("FBillNumber \t\t\tVARCHAR(255),").append("FBizDate\t\t\t \tVARCHAR(10),").append("FExpenseNumber\t\t \tVARCHAR(255),").append("FExpenseName \t\t\tVARCHAR(255),").append("FAuxFeeNumber\t\t\tVARCHAR(255),").append("FAuxFeeName\t\t\tVARCHAR(255),").append("FCostCenterNumber\t\tvarchar(255),").append("FCostCenterName \t\tvarchar(255),").append("FCostObjectNumber\t\tvarchar(255),").append("FCostObjectName \t\tvarchar(255),").append("FCostItemNumber \t\tvarchar(255),").append("FCostItemName \t\t\tvarchar(255),").append("FUnitName \t\t\t\tvarchar(255),").append("FQty \t\t\t\t\tNUMERIC(21,8) DEFAULT 0,").append("FActualPrice\t\t\tNUMERIC(21,8) DEFAULT 0,").append("FActualAmount\t\t\tNUMERIC(17,4) DEFAULT 0,").append("FAllocStdName \t\t\tVARCHAR(255),").append("FAllocStdData \t\t\tNUMERIC(24,12) DEFAULT 1,").append("FOrderNumber\t\t\tvarchar(255),").append("FBatchNumber\t\t\tnvarchar(255),").append("FProjectNumber\t\t\tvarchar(255),").append("FTrackNumber\t\t\tvarchar(255),").append("FMaterialNumber\t\tvarchar(255),").append("FMaterialName\t\t\tvarchar(255),").append("FCostObjectID\t\t\tvarchar(255),").append("FQtyDecimal \t\t\tint default(4), ").append("FPriceDecimal\t\t\tint default(2), ").append("FAmtDecimal \t\t\tint default(2), ").append("FStdDecimal\t\t\tint default(6)  ").append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected String getSQL(String companyName, int amtPrecision, RptParams filter, String[] physicalTblNames, String tmpTblName) throws Exception {
        Context ctx = this.getContext();
        StringBuffer insert = new StringBuffer();
        insert.append(" INSERT INTO ").append(tmpTblName).append(" ( ").append(" FOrgName,FPeriodNumber,FBillNumber,FBizDate,FExpenseNumber,FExpenseName, ").append(" FAuxFeeNumber,FAuxFeeName,FCostCenterNumber,FCostCenterName, ").append(" FCostObjectID,FCostObjectNumber,FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName, FCostObjectName,FCostItemNumber,FCostItemName,FUnitName, ").append(" FQty,FActualPrice,FActualAmount,FAllocStdName,FAllocStdData, ").append(" FQtyDecimal,FPriceDecimal,FAmtDecimal,FStdDecimal ").append(" ) ").append('\n').append(" SELECT '").append(companyName).append("',to_char(prd.FNumber),B.FNumber,TO_CHAR(B.FBizDate, 'YYYY-MM-DD') ").append('\n').append("\t,Ex.FNumber,Ex.FName_" + ctx.getLocale() + ",Aux.FNumber,Aux.FName_" + ctx.getLocale() + ",cc.FNumber,cc.FName_" + ctx.getLocale() + ",co.FID,co.FNumber,    co.FOrderNumber,co.FBatchNumber,po.FNumber,tr.FNumber,mat.FNumber,mat.FName_" + ctx.getLocale() + "").append('\n').append(" \t,co.FName_" + ctx.getLocale() + ",ci.FNumber,ci.FName_" + ctx.getLocale() + ",mu.FName_" + ctx.getLocale() + "  \t\t\t\t\t\t    ").append('\n').append(" \t,R.FTotalQty,R.FPrice,R.FAmount\t\t\t\t\t\t\t\t\t\t  \t\t").append('\n').append(" \t,sd.FName_" + ctx.getLocale() + ",R.FAllocStdData, Aux.FqtyPrecision,Auxc.FPricePrecision, \t\t\t").append('\n').append(amtPrecision).append(", ").append(10).append('\n').append(" FROM ").append(physicalTblNames[0]).append(" AS R ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBill B ON B.FID = R.FSourceBillID ").append('\n').append(" LEFT JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID AND E.FID = FSourceBillEntryID ").append('\n').append(" INNER JOIN T_BD_Period prd on R.FCalculatePeriodID = prd.FID     ").append('\n').append(" INNER JOIN T_NCM_Expense Ex ON R.FExpenseID=Ex.FID\t\t\t   ").append('\n').append(" INNER JOIN T_NCM_AUXOverhead Aux ON Aux.FID=E.FAuxOverheadID     ").append('\n').append(" LEFT JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON  ").append('\n').append("\t\tAuxc.FAuxOverheadID = Aux.FID AND Auxc.FCompanyID = R.FCompanyID \t  ").append('\n').append(" LEFT JOIN T_ORG_CostCenter cc on R.FCostCenterID =cc.FID ").append('\n').append(" LEFT JOIN T_BD_CostObject co on  R.FCostObjectID =co.FID ").append('\n').append(" left join t_mm_project po on po.FID = co.FProjectID \n").append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n").append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n").append(" LEFT JOIN T_NCM_CostItem ci on R.FCostItemID = ci.FID    ").append('\n').append(" LEFT JOIN T_BD_MeasureUnit mu on mu.FID = Aux.FUnitID  \t   ").append('\n').append(" LEFT JOIN T_NCM_AllocStd sd on sd.FID = R.FAllocStdID\t\t\t   ").append('\n');
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append(" WHERE R.FCompanyID = ? ").append('\n');
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, true, " prd.FNumber", "", "");
        if (this.isFilterCostCenter(filter)) {
            whereSQL.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
        }
        if (this.isFilterExpense(filter)) {
            whereSQL.append("  AND ex.FNumber in (" + this.filterExpense(filter) + ") \n");
        }
        if (this.isFilterOverhead(filter)) {
            whereSQL.append("  AND aux.FNumber in (" + this.filterOverhead(filter) + ") \n");
        }
        if (this.isFilterCostObject(filter)) {
            whereSQL.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
        }
        if (this.isFilterCostItem(filter)) {
            whereSQL.append("  AND ci.FNumber in (" + this.filterCostItem(filter) + ") \n");
        }
        if (this.isFilterOrder(filter)) {
            whereSQL.append("  AND co.FOrderNumber in (" + this.filterOrder(filter) + ") \n");
        }
        if (this.isFilterBatchNumber(filter)) {
            whereSQL.append("  AND co.FBatchNumber in (" + this.filterBatchNumber(filter) + ") \n");
        }
        if (this.isFilterProjectNumber(filter)) {
            whereSQL.append("  AND po.FNumber in (" + this.filterProjectNumber(filter) + ") \n");
        }
        if (this.isFilterTrackNumber(filter)) {
            whereSQL.append("  AND tr.FNumber in (" + this.filterTrackNumber(filter) + ") \n");
        }
        if (this.isFilterMaterialNumber(filter)) {
            whereSQL.append("  AND mat.FNumber in (" + this.filterMaterialNumber(filter) + ") \n");
        }
        whereSQL.append('\n').append(" ORDER BY B.FBizDate,B.FNumber,Ex.FNumber,Aux.FNumber,cc.FNumber,co.FNumber,ci.FNumber");
        String sql = insert.append(whereSQL).toString();
        return sql;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        String costCenters = filter.getString("costCenterFrom");
        String costCenterNumbers = "";
        costCenterNumbers = StringUtils.isEmpty((String)costCenters) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costCenters.replaceAll(";", ",");
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"26_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costCenterNumbers);
        String expenses = filter.getString("expenseFrom");
        String expenseNumbers = "";
        expenseNumbers = StringUtils.isEmpty((String)expenses) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : expenses.replaceAll(";", ",");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"27_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + expenseNumbers);
        String overheads = filter.getString("auxOverheadFrom");
        String overheadNumbers = "";
        overheadNumbers = StringUtils.isEmpty((String)overheads) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : overheads.replaceAll(";", ",");
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"28_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + overheadNumbers);
        String costObjects = filter.getString("costObjectFrom");
        String costObjectNumbers = "";
        costObjectNumbers = StringUtils.isEmpty((String)costObjects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costObjects.replaceAll(";", ",");
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"29_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costObjectNumbers);
        String orders = filter.getString("orderNumberFrom");
        String orderNumbers = "";
        orderNumbers = StringUtils.isEmpty((String)orders) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : orders.replaceAll(";", ",");
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()) + "\uff1a" + orderNumbers);
        String batchs = filter.getString("batchNumber");
        String batchNumbers = "";
        batchNumbers = StringUtils.isEmpty((String)batchs) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : batchs.replaceAll(";", ",");
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()) + "\uff1a" + batchNumbers);
        String projects = filter.getString("projectNumber");
        String projectNumbers = "";
        projectNumbers = StringUtils.isEmpty((String)projects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : projects.replaceAll(";", ",");
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()) + "\uff1a" + projectNumbers);
        String tracks = filter.getString("trackNumber");
        String trackNumbers = "";
        trackNumbers = StringUtils.isEmpty((String)tracks) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : tracks.replaceAll(";", ",");
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()) + "\uff1a" + trackNumbers);
        String materials = filter.getString("materialNumber");
        String materialNumbers = "";
        materialNumbers = StringUtils.isEmpty((String)materials) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : materials.replaceAll(";", ",");
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_Material", (Locale)ctx.getLocale()) + "\uff1a" + materialNumbers);
        String costItems = filter.getString("costItemFrom");
        String costItemNumbers = "";
        costItemNumbers = StringUtils.isEmpty((String)costItems) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costItems.replaceAll(";", ",");
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"30_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costItemNumbers);
        return titles;
    }

    protected String getSEQField() {
        return " KSQL_SEQ ";
    }

    protected String getSELECT() {
        return "SELECT distinct FPeriodNumber,FExpenseNumber,FAuxOverheadNumber,FCostCenterNumber,FCostObjectNumber,FCostItemNumber FROM ";
    }

    protected String getORDERBY() {
        return " ORDER BY FPeriodNumber,FBillNumber,FExpenseNumber,FAuxFeeNumber,FCostCenterNumber,FCostObjectNumber,FCostItemNumber ";
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 12);
        header.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), 13);
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 14);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 15);
        header.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()), 16);
        header.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()), 17);
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FExpenseNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FExpenseName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBillNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_Funit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBizDate")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BizDate", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAuxFeeNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAuxFeeName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FOrgName")) {
                header.getChilds().remove(childHeader);
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FActualPrice")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ActualPrice", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FActualAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ActualAmount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAllocStdName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdName", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FAllocStdData")) continue;
            childHeader.setType(0);
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdData", (Locale)ctx.getLocale()));
        }
        return header;
    }

    private boolean isFilterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenterFrom");
        return !StringUtils.isEmpty((String)costCenterNumbers);
    }

    private StringBuffer filterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenterFrom");
        String[] numbers = costCenterNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterExpense(RptParams filter) throws Exception {
        String expenseNumbers = filter.getString("expenseFrom");
        return !StringUtils.isEmpty((String)expenseNumbers);
    }

    private StringBuffer filterExpense(RptParams filter) throws Exception {
        String expenseNumbers = filter.getString("expenseFrom");
        String[] numbers = expenseNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("auxOverheadFrom");
        return !StringUtils.isEmpty((String)overheadNumbers);
    }

    private StringBuffer filterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("auxOverheadFrom");
        String[] numbers = overheadNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjectFrom");
        return !StringUtils.isEmpty((String)costObjectNumbers);
    }

    private StringBuffer filterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjectFrom");
        String[] numbers = costObjectNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItemFrom");
        return !StringUtils.isEmpty((String)costItemNumbers);
    }

    private StringBuffer filterCostItem(RptParams filter) throws Exception {
        String costItemNumbers = filter.getString("costItemFrom");
        String[] numbers = costItemNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterOrder(RptParams filter) throws Exception {
        String orderNumbers = filter.getString("orderNumberFrom");
        return !StringUtils.isEmpty((String)orderNumbers);
    }

    private StringBuffer filterOrder(RptParams filter) throws Exception {
        String orderNumbers = filter.getString("orderNumberFrom");
        String[] numbers = orderNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterBatchNumber(RptParams filter) throws Exception {
        String batchNumbers = filter.getString("batchNumber");
        return !StringUtils.isEmpty((String)batchNumbers);
    }

    private StringBuffer filterBatchNumber(RptParams filter) throws Exception {
        String batchNumbers = filter.getString("batchNumber");
        String[] numbers = batchNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterProjectNumber(RptParams filter) throws Exception {
        String projectNumbers = filter.getString("projectNumber");
        return !StringUtils.isEmpty((String)projectNumbers);
    }

    private StringBuffer filterProjectNumber(RptParams filter) throws Exception {
        String projectNumbers = filter.getString("projectNumber");
        String[] numbers = projectNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterTrackNumber(RptParams filter) throws Exception {
        String trackNumbers = filter.getString("trackNumber");
        return !StringUtils.isEmpty((String)trackNumbers);
    }

    private StringBuffer filterTrackNumber(RptParams filter) throws Exception {
        String trackNumbers = filter.getString("trackNumber");
        String[] numbers = trackNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterMaterialNumber(RptParams filter) throws Exception {
        String materialNumbers = filter.getString("materialNumber");
        return !StringUtils.isEmpty((String)materialNumbers);
    }

    private StringBuffer filterMaterialNumber(RptParams filter) throws Exception {
        String materialNumbers = filter.getString("materialNumber");
        String[] numbers = materialNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private StringBuffer generateCondtion(String[] numbers) {
        Object[] numbersObj = new Object[numbers.length];
        System.arraycopy(numbers, 0, numbersObj, 0, numbers.length);
        return BDCMUtils.splitPK((Object[])numbersObj);
    }
}

