/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMConst;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AuxFeeCostCalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger(AuxFeeCostCalReport.class);
    protected static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String sTableName = super.getTablename();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName + this.getORDERBY()));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + " ORDER BY FPeriodNumber, FCostObjectNumber "), (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String sTableName = null;
        try {
            sTableName = this.buildReportDataTableName(filter);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.setTablename(sTableName);
        return super.getTablename();
    }

    protected String buildReportDataTableName(RptParams filter) throws Exception {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyOrg")).getId().toString();
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String companyName = company.getName();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        int amtPrecision = currency.getPrecision();
        Locale locale = this.getContext().getLocale();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        IRowSet rsAuxOverhead = this.getAuxOverheads(companyID, locale, filter, physicalTblNames);
        StringBuffer rowToColumn = this.getRowToColumnForCreate(rsAuxOverhead, locale);
        String sTmpTblName = this.createTmpTable(rowToColumn.toString());
        String sqlAll = this.getSQL(companyName, amtPrecision, filter, physicalTblNames, sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sqlAll, (Object[])new String[]{companyID});
        StringBuffer[] dynmicCol = this.getRowToColumnForSelect(rsAuxOverhead, locale);
        try {
            this.updateForDynamicColumns(filter, companyID, physicalTblNames, rsAuxOverhead, dynmicCol);
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        super.setTablename(sTmpTblName);
        return sTmpTblName;
    }

    protected String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException, SQLException {
        int fromPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
        int toPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        String[] physicalTblNames = new String[]{NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_LinearEquations", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_AugmentedMatrix", (int)fromPeriod, (int)toPeriod)};
        return physicalTblNames;
    }

    protected String createTmpTable(String otherColumns) throws BOSException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("Create Table t_SUN ( ").append("FID \t\t\t\t    VARCHAR(44) NOT NULL,").append("FPeriodNumber\t\t \tVARCHAR(50),").append("FCostCenterID\t\t    VARCHAR(44),").append("FCostCenterNumber\t\tvarchar(255),").append("FCostCenterName \t\tvarchar(255),").append("FUnitName \t\t\t\tvarchar(255),").append("FCostObjectID\t\t    VARCHAR(44),").append("FCostObjectNumber\t\tvarchar(255),").append("FCostObjectName \t\tvarchar(255),").append("FAUXOverheadID\t\t\tvarchar(44),").append("FAUXOverheadNumber\t\tvarchar(255),").append("FAUXOverheadName \t\tvarchar(255),").append("FCollectAmount\t\t\tNUMERIC(17,4) DEFAULT 0,").append("FAlgebraAmount\t\t\tNUMERIC(17,4) DEFAULT 0 ").append(" {0} , ").append("FTotalAmount\t\t\tNUMERIC(17,4) DEFAULT 0,").append("FTotalQty \t\t\t\tNUMERIC(21,8) DEFAULT 0,").append("FUnitPrice \t\t\tNUMERIC(21,8) DEFAULT 0,").append("FEquationString\t\tNVARCHAR(2000) ,").append("FQtyDecimal \t\t\tint default(4), ").append("FPriceDecimal\t\t\tint default(2), ").append("FAmtDecimal \t\t\tint default(2), ").append("FTotalRow \t   decimal(5,2)  default(0) ").append(" ) ");
        String bigTable = MessageFormat.format(createTable.toString(), otherColumns);
        String sTmpTblName = null;
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(bigTable);
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected String getSQL(String companyName, int amtPrecision, RptParams filter, String[] physicalTblNames, String tmpTblName) throws Exception {
        Context ctx = this.getContext();
        StringBuffer insert = new StringBuffer();
        insert.append(" INSERT INTO ").append(tmpTblName).append(" ( ").append(" FID,FPeriodNumber, ").append(" FCostCenterID,FCostCenterNumber,FCostCenterName,FUnitName, ").append(" FCostObjectID,FCostObjectNumber,FCostObjectName,FAUXOverheadID,FAUXOverheadNumber,FAUXOverheadName, ").append(" FCollectAmount,FAlgebraAmount,FTotalAmount,FTotalQty,FUnitPrice, FEquationString , ").append(" FQtyDecimal,FPriceDecimal,FAmtDecimal ").append(" ) ").append('\n').append(" SELECT LE.FID , to_char(prd.FNumber) ").append('\n').append("\t,cc.FID,cc.FNumber, cc.FName_l2,mu.FName_l2 ").append('\n').append(" \t,co.FID,co.FNumber,co.FName_l2,Aux.FID,Aux.FNumber,Aux.FName_l2 ").append('\n').append(" \t,isnull(LE.FCollectAmount,0),isnull(LE.FAlgebraAmount,0),isnull(LE.FTotalAmount,0) ").append('\n').append(" \t,isnull(LE.FTotalQty,0),isnull(LE.FUnitPrice,0),LE.FEquationString  ").append('\n').append(" \t,Aux.FqtyPrecision,Auxc.FPricePrecision,").append(amtPrecision).append('\n').append(" FROM ").append(physicalTblNames[0]).append(" AS LE ").append('\n').append(" INNER JOIN T_BD_Period prd on LE.FCalculatePeriodID = prd.FID ").append('\n').append(" INNER JOIN T_ORG_CostCenter cc on cc.FID = LE.FCostCenterID ").append('\n').append(" LEFT JOIN T_BD_CostObject co on co.FID= LE.FCostObjectID ").append('\n').append(" LEFT JOIN T_BD_CostObjectEntry coe on co.FID= coe.FParentID ").append('\n').append(" LEFT JOIN T_NCM_AUXOverhead Aux ON Aux.FID = coe.FRelatedID ").append('\n').append(" LEFT JOIN T_NCM_AUXOverheadCompanyInfo Auxc ON ").append('\n').append("\t\tAuxc.FAuxOverheadID = Aux.FID AND Auxc.FCompanyID = LE.FCompanyID ").append('\n').append(" LEFT JOIN T_NCM_Expense Ex ON Ex.FID = Auxc.FDefaultExpenseID ").append('\n').append(" LEFT JOIN T_NCM_ExpenseCompanyInfo Exc ON Exc.FExpenseID=Ex.FID ").append('\n').append("\t\tAND FCompanyOrgUnitID = LE.FCompanyID ").append('\n').append(" LEFT JOIN T_NCM_CostItem ci on ci.FID = Exc.FCostItemID ").append('\n').append(" LEFT JOIN T_BD_MeasureUnit mu on mu.FID = Aux.FUnitID ").append('\n');
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append(" WHERE LE.FCompanyID = ? ").append('\n');
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, true, " prd.FNumber", "", "");
        if (this.isFilterCostCenter(filter)) {
            whereSQL.append("  AND cc.FNumber in (" + this.filterCostCenter(filter) + ") \n");
        }
        if (this.isFilterCostObject(filter)) {
            whereSQL.append("  AND co.FNumber in (" + this.filterCostObject(filter) + ") \n");
        }
        if (this.isFilterOverhead(filter)) {
            whereSQL.append("  AND aux.FNumber in (" + this.filterOverhead(filter) + ") \n");
        }
        whereSQL.append('\n').append(" ORDER BY Aux.FNumber ");
        String sql = insert.append(whereSQL).toString();
        return sql;
    }

    private boolean isFilterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenterFrom");
        return !StringUtils.isEmpty((String)costCenterNumbers);
    }

    private StringBuffer filterCostCenter(RptParams filter) throws Exception {
        String costCenterNumbers = filter.getString("costCenterFrom");
        String[] numbers = costCenterNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjectFrom");
        return !StringUtils.isEmpty((String)costObjectNumbers);
    }

    private StringBuffer filterCostObject(RptParams filter) throws Exception {
        String costObjectNumbers = filter.getString("costObjectFrom");
        String[] numbers = costObjectNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private boolean isFilterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("auxOverheadFrom");
        return !StringUtils.isEmpty((String)overheadNumbers);
    }

    private StringBuffer filterOverhead(RptParams filter) throws Exception {
        String overheadNumbers = filter.getString("auxOverheadFrom");
        String[] numbers = overheadNumbers.replaceAll(" ", "").split(";");
        return this.generateCondtion(numbers);
    }

    private StringBuffer generateCondtion(String[] numbers) {
        Object[] numbersObj = new Object[numbers.length];
        System.arraycopy(numbers, 0, numbersObj, 0, numbers.length);
        return BDCMUtils.splitPK((Object[])numbersObj);
    }

    private IRowSet getAuxOverheads(String companyID, Locale locale, RptParams filter, String[] tableNames) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer sql = new StringBuffer();
        sql.append('\n').append(" SELECT  distinct Aux.FID,Aux.FNumber,Aux.FName_").append(locale).append('\n').append(" ,auxc.FPricePrecision FROM ").append('\n').append(tableNames[1]).append("  mrx INNER JOIN\t              \t\t\t\t          ").append('\n').append(tableNames[0]).append("  equ on equ.FID = mrx.FParentID                       ").append('\n').append(" INNER JOIN T_NCM_AuxOverhead Aux ON Aux.FID = mrx.FUnkownNumber\t\t\t\t  ").append('\n').append(" INNER JOIN T_NCM_AuxOverheadCompanyinfo auxc on auxc.FAuxOverHeadID = aux.FId and auxc.FCompanyID = '" + companyID + "'               ").append('\n').append(" INNER JOIN T_BD_Period prd on equ.FCalculatePeriodID = prd.FID      ").append('\n').append(" WHERE equ.FCompanyID = ? \t\t \t\t      ").append('\n');
        NCMReportHelper.AppendPredicate(ctx, sql, filter, true, " prd.FNumber", "", "");
        sql.append('\n').append(" ORDER BY Aux.FNumber  ;  ").append('\n');
        IRowSet rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)sql.toString(), (Object[])new String[]{companyID});
        return rs;
    }

    private StringBuffer getRowToColumnForCreate(IRowSet rsAuxOverhead, Locale locale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String name = "";
        try {
            rsAuxOverhead.beforeFirst();
            name = "FName_" + locale;
            int colSeq = 0;
            while (rsAuxOverhead.next() && rsAuxOverhead.getString(name) != null && rsAuxOverhead.getString("FNumber") != null) {
                sql.append(",FCoefficient" + ++colSeq + " Decimal(21,8) Default(0) \n");
                sql.append(",FSolution" + colSeq + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount" + colSeq + " Decimal(21,8) Default(0) \n");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sql;
    }

    private StringBuffer[] getRowToColumnForSelect(IRowSet rsAuxOverhead, Locale locale) throws BOSException {
        StringBuffer[] sqls = new StringBuffer[rsAuxOverhead.size()];
        try {
            if (rsAuxOverhead.size() > 0) {
                String name = "";
                rsAuxOverhead.beforeFirst();
                name = "FName_" + locale;
                int colSeq = 0;
                while (rsAuxOverhead.next() && rsAuxOverhead.getString(name) != null && rsAuxOverhead.getString("FNumber") != null) {
                    StringBuffer sql;
                    sqls[colSeq] = sql = new StringBuffer();
                    sql.append(" FCoefficient" + ++colSeq);
                    sql.append(",FSolution" + colSeq);
                    sql.append(",FAmount" + colSeq);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sqls;
    }

    private StringBuffer getRowToColumnForSum(IRowSet rsAuxOverhead, Locale locale) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            if (rsAuxOverhead.size() > 0) {
                String name = "";
                rsAuxOverhead.beforeFirst();
                name = "FName_" + locale;
                int colSeq = 0;
                while (rsAuxOverhead.next() && rsAuxOverhead.getString(name) != null && rsAuxOverhead.getString("FNumber") != null) {
                    sql.append(",SUM( FCoefficient" + ++colSeq + ") as FCoefficient" + colSeq + ", \n");
                    sql.append("SUM(FAmount" + colSeq + ") as FAmount" + colSeq + "\n");
                }
            }
            return sql;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void updateForDynamicColumns(RptParams filter, String companyID, String[] physicalTblNames, IRowSet rsAuxOverhead, StringBuffer[] dynmicCol) throws SQLException, BOSException {
        Context ctx = this.getContext();
        StringBuffer updates = new StringBuffer();
        int equationNum = 0;
        rsAuxOverhead.beforeFirst();
        while (rsAuxOverhead.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append('\n').append(" UPDATE  ").append(this.getTablename()).append('\n').append("  AS RPT SET ( {0} ) = ( \t\t\t\t\t\t\t\t\t\t   \t\t\t\t").append('\n').append("     SELECT MRX.FCoefficient,MRX.FSolution\t\t\t\t\t\t\t\t\t\t").append('\n').append("            , Round(MRX.FCoefficient * MRX.FSolution, FAmtDecimal )\t\t\t\t\t\t").append('\n').append("      FROM   ").append(physicalTblNames[1]).append(" MRX\t\t\t\t\t\t").append('\n').append("             INNER JOIN ").append(physicalTblNames[0]).append(" LE\t\t\t\t").append('\n').append("                     ON MRX.FParentID = LE.FID\t\t\t\t\t\t\t\t\t").append('\n').append("             INNER JOIN T_BD_Period prd\t\t\t\t\t\t\t\t\t\t").append('\n').append("                     ON LE.FCalculatePeriodID = prd.FID\t\t\t\t\t\t").append('\n').append("      WHERE  FCompanyID = ''{1}''\t\t\t\t\t\t\t\t\t\t\t\t").append('\n').append("      AND LE.FID = RPT.FID\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append('\n').append("      AND MRX.FUnkownNumber = ''{2}'' ").append('\n');
            NCMReportHelper.AppendPredicate(ctx, sb, filter, true, " prd.FNumber", "", "");
            sb.append("   ) ; ").append('\n');
            updates.append(MessageFormat.format(sb.toString(), dynmicCol[equationNum++], companyID, rsAuxOverhead.getString("FID")));
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)updates.toString());
    }

    private void insertDataToTableSum(String[] physicalTblNames, String sTmpTblName, String companyName, RptParams filter, String companyID, StringBuffer[] dynmicCol, StringBuffer rowToColumnForSum, int amtPrecision) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer dynmicCols = new StringBuffer();
        for (int i = 0; i < dynmicCol.length; ++i) {
            dynmicCols.append(",").append(dynmicCol[i]);
        }
        sql.append(" INSERT INTO ").append(sTmpTblName).append(" ( ").append(" FID,FOrgName,FPeriodNumber, ").append(" FCostCenterID,FCostCenterNumber,FCostCenterName,FUnitName, ").append(" FCostObjectID,FCostObjectNumber,FCostObjectName,FAUXOverheadID,FAUXOverheadNumber,FAUXOverheadName, ").append(" FCollectAmount,FAlgebraAmount,FTotalAmount,FTotalQty").append(dynmicCols.toString().replaceAll("\\,FSolution\\d", " ")).append(" ,FToTalRow) ").append('\n').append(" SELECT ").append("   ' ' ,'").append(companyName).append("',' '  ").append('\n').append("\t,FCostCenterID,FCostCenterNumber,FCostCenterName,FUnitName\t\t\t\t\t").append('\n').append(" \t,FCostObjectID,FCostObjectNumber,FCostObjectName,FAUXOverheadID,FAUXOverheadNumber,FAUXOverheadName, ").append('\n').append(" \tSum(FCollectAmount),Sum(FAlgebraAmount),Sum(FTotalAmount),Sum(FTotalQty)\t").append('\n').append(rowToColumnForSum).append(" , ").append(1).append('\n').append(" FROM ").append(sTmpTblName).append('\n').append(" GROUP BY FID,FOrgName,FPeriodNumber, ").append(" FCostCenterID,FCostCenterNumber,FCostCenterName,FUnitName, ").append(" FCostObjectID,FCostObjectNumber,FCostObjectName,FAUXOverheadID,FAUXOverheadNumber,FAUXOverheadName ");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        String costCenters = filter.getString("costCenterFrom");
        String costCenterNumbers = "";
        costCenterNumbers = StringUtils.isEmpty((String)costCenters) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costCenters.replaceAll(";", ",");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"26_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costCenterNumbers);
        String costObjects = filter.getString("costObjectFrom");
        String costObjectNumbers = "";
        costObjectNumbers = StringUtils.isEmpty((String)costObjects) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : costObjects.replaceAll(";", ",");
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"29_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + costObjectNumbers);
        String overheads = filter.getString("auxOverheadFrom");
        String overheadNumbers = "";
        overheadNumbers = StringUtils.isEmpty((String)overheads) ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : overheads.replaceAll(";", ",");
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadSumReportFilter2UI", (Locale)ctx.getLocale()) + "\uff1a" + overheadNumbers);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        String strSQL = "";
        strSQL = "SELECT T_BAS_REPORTHEADER.FID,FParentFieldName,FReportID,FCaption_" + BDCMConst.LocLan + " as FCaption,FFieldName,FDecimalField,FDecimal, FColType,FWidth,FAlign,FLevel,FIndex,FMergeable,FFormatString,fishiberarchy,fleaffield   FROM T_BAS_REPORTHEADER  LEFT JOIN T_BAS_RptDataType ON T_BAS_RptDataType.FParentID=T_BAS_REPORTHEADER.FID  WHERE  FReportID = ?  order by FIndex ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
        if (!rs.next()) {
            return new ReportHeader();
        }
        ReportHeader reportHeader = ReportHeader.createReportHeader((IRowSet)rs);
        reportHeader.addChild("FAUXOverheadNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadNumber", (Locale)ctx.getLocale()), 6);
        reportHeader.addChild("FAUXOverheadName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AUXOverheadName", (Locale)ctx.getLocale()), 7);
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyOrg")).getId().toString();
        ArrayList childList = reportHeader.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (!"FAlgebraAmount".equals(fieldName) || NCMUtils.isAlgebraicdAuxAlloc((Context)ctx, (String)companyID)) continue;
            childHeader.setCaption("\u8ba1\u5212\u5206\u914d\u7684\u91d1\u989d\u5408\u8ba1");
        }
        Locale locale = this.getContext().getLocale();
        String[] tables = this.getPhysicalTableName(companyID, filter);
        IRowSet rsAuxOverheads = this.getAuxOverheads(companyID, locale, filter, tables);
        rsAuxOverheads.beforeFirst();
        String name = "FName_" + locale;
        int colSeq = 0;
        String colName = "F" + Integer.toString(colSeq);
        ReportHeader bandTemp = NCMUtils.isAlgebraicdAuxAlloc((Context)ctx, (String)companyID) ? reportHeader.addChild("JHFP", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"14_AuxFeeCostCalReport", (Locale)ctx.getLocale())) : reportHeader.addChild("JHFP", "\u8ba1\u5212\u5206\u914d\u7684\u91d1\u989d");
        while (rsAuxOverheads.next() && rsAuxOverheads.getString(name) != null && rsAuxOverheads.getString("FNumber") != null) {
            colName = "F" + Integer.toString(++colSeq);
            ReportHeader interactionAmount = bandTemp.addChild(colName, rsAuxOverheads.getString(name));
            interactionAmount.addChild("FCoefficient" + colSeq, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"15_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            interactionAmount.addChild("FSolution" + colSeq, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"16_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(rsAuxOverheads.getInt("FPricePrecision"));
            interactionAmount.addChild("FAmount" + colSeq, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"17_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmtDecimal");
        }
        return reportHeader;
    }

    protected String getORDERBY() {
        return " ORDER BY FPeriodNumber, FTotalRow,Aux.FNumber  ";
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        return NCMUtils.formatConditions((String)"FTotalRow");
    }
}

