/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.utils.BDCMConst;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ByClassCostCalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)ByClassCostCalReport.class.getName());
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private static final String ORDER_BY = " ORDER BY FPeriodNumber,FCostCenterID,FCostObjectID,FProductID,FCostItemId ";
    private int amountPrecision = -1;
    public static final Object[] HeaderGroup = new Object[]{new String[]{"FPeriodNumber"}, new String[]{"FCostCenterID", "FCostCenterNumber", "FCostCenterName"}, new String[]{"FCostObjectID", "FCostObjectNumber", "FCostObjectName"}, new String[]{"FCurCompQty", "FProductID", "FProductNumber", "FProductName", "FModel", "FUnitName"}, new String[]{"FCostItemID", "FCostItemNumber", "FCostItemName"}};

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String sTableName = super.getTablename();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName + ORDER_BY));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("disPlayOnlyTotalRow");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderBy = this.getSortString(ctx, filter, orderByMode);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " ORDER BY FTotalRow2 " + orderByMode + "," + orderBy + ", FTotalRow"), (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String[] physicalTblNames;
        Context ctx = this.getContext();
        String companyID = null;
        if (filter.getObject("prmtCompanyOrg") != null) {
            companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        } else {
            return null;
        }
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct cpr.FCostObjectID,co.FNumber FROM ").append(physicalTblNames[0]).append(" cpr ").append("INNER JOIN T_BD_Period prd on cpr.FcalculatePeriodID = prd.FID\n").append("INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID\n").append("INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID = ci.FID ").append("INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID) \n").append("INNER JOIN T_BD_Material mat on cpr.FProductID=mat.FID\n").append(" WHERE cpr.FCompanyID = ? \n").append(" \tAND CO.FCalculateMode = ").append(3);
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, true, "prd.FNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "mat.FNumber", ">=", "prmtProductFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "mat.FNumber", "<=", "prmtProductTo");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "ci.FNumber", ">=", "prmtCostItemFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "ci.FNumber", "<=", "prmtCostItemTo");
        sbSQL.append(" ORDER BY co.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
        Integer nCountPerPage = Integer.valueOf(filter.getString("spCostObjectNum"));
        if (nCountPerPage <= 0) {
            nCountPerPage = 1;
        }
        IRowSet drs = null;
        drs = NCMReportHelper.getListWithDynamicRowSet(ctx, nCountPerPage, rs, "FCostObjectID");
        if (drs != null && drs.size() == 0) {
            drs.moveToInsertRow();
            drs.updateString("FCostObjectID", "" + BOSUuid.create((String)"39734A77").toString() + "");
            drs.insertRow();
        }
        return drs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String sTableName = this.buildReportData(filter);
        this.setTablename(sTableName);
        return super.getTablename();
    }

    protected String buildReportData(RptParams filter) throws BOSException, EASBizException {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
        CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String companyName = company.getName();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        String sTmpTblName = this.createTmpTable();
        String sqlAll = this.getSQL(companyName, filter, physicalTblNames, sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sqlAll, (Object[])new String[]{companyID});
        StringBuffer sqlResult = this.insertDataToTableSum(physicalTblNames, sTmpTblName, companyName, filter, companyID);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlResult.toString());
        return sTmpTblName;
    }

    private StringBuffer insertDataToTableSum(String[] physicalTblNames, String tempTableNameSum, String orgCompanyName, RptParams filter, String companyID) {
        Context ctx = this.getContext();
        ArrayList list = NCMReportHelper.getGroupByList((ArrayList)filter.getObject("table"));
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("groupby");
            fields = fields.replaceAll("FPeriodNumber", "FPeriodID,FPeriodNumber,FPeriodName");
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FCurAllAmount ) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FCurAllAmount) as FCurAllAmount \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" WHERE FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
        }
        sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
        sql.append(" FOrgName,FTotalRow, FTotalRow2, \n");
        sql.append(" FCurAllAmount\n");
        sql.append(" ) \n");
        sql.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', ").append(2).append(", 1, ");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
            sql.setLength(0);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurCompQty)= (SELECT  ").append(" \tdbo.FFinishedQty ").append(" FROM ").append(physicalTblNames[2]).append(" dbo INNER JOIN T_BD_Period P on dbo.FCalculatePeriodID = P.FID               \n ").append(" where dbo.FcompanyID = '").append(companyID).append("' ").append(" AND P.FID = S.FPeriodID AND ").append(" S.FCostCenterID = dbo.FCostCenterID AND S.FCostObjectID = dbo.FCostObjectID ").append(" ) WHERE FTotalRow > ").append(5).append(" ; \n ");
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurCompQty)= (SELECT  ").append(" \tdbo.FFinishedQty ").append(" FROM ").append(physicalTblNames[1]).append(" dbo INNER JOIN T_BD_Period P on dbo.FCalculatePeriodID = P.FID            \n ").append(" where dbo.FcompanyID = '").append(companyID).append("' ").append(" AND P.FID = S.FPeriodID AND S.FCostCenterID = dbo.FCostCenterID").append(" AND S.FCostObjectID = dbo.FCostObjectID AND S.FProductID = dbo.FProductID ").append(" ) WHERE FTotalRow = ").append(5).append(" or FTotalRow = ").append(4).append(" ; \n ");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + BDCMConst.LocLan + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append(" Where FTotalRow > 0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + "\n");
        sql.append(" FROM T_BD_CostObject T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID ) \n ");
        sql.append(" Where FTotalRow > 0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FProductNumber,FProductName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + "\n");
        sql.append(" FROM T_BD_Material T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID =T2.FID ) \n ");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostItemNumber,FCostItemName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + BDCMConst.LocLan + " \n");
        sql.append(" FROM T_NCM_CostItem T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostItemID =T2.FID ) \n ");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET FOrgName= '" + orgCompanyName + "' \n");
        sql.append(" Where FTotalRow >0 AND FTotalRow2 <> 1 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FUnitName,FModel)= \n");
        sql.append(" (SELECT T4.FName_" + BDCMConst.LocLan + ",T3.FModel \n");
        sql.append(" FROM  ");
        sql.append(" t_bd_Material T3  \n");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID=T3.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal= \n");
        sql.append(" (SELECT MAX(T4.FqtyPrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FPriceDecimal= \n");
        sql.append(" (SELECT MAX(T3.FPricePrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        sql.append("UPDATE ").append(tempTableNameSum).append(" SET (FPriceDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sql.append(" Where FTotalRow >0 ");
        sql.append("\n\n;");
        String field = "";
        String fieldNumber = "";
        String fieldName = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            fieldName = "FPeriodNumber".equals(field) ? field.substring(0, field.length() - 6) + "Name" : field.substring(0, field.length() - 2) + "Name";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProductID")) {
                whichTotal = ", FTotalProductRow = 1 ";
            }
            if (field.equals("FPeriodNumber")) {
                sql.append(" update " + tempTableNameSum + " set " + field + " = " + field + " || '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                sql.append(whichTotal);
                sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sql.append("\n\n;");
                continue;
            }
            sql.append(" update " + tempTableNameSum + " set " + fieldName + " = ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
            sql.append(whichTotal);
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" DELETE " + tempTableNameSum + " WHERE FTOTALROW > 0 AND  (FCostCenterNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' OR FCostObjectNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' OR FProductNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' OR FCostItemNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "') ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n,FPriceDecimal= (SELECT MAX(FPriceDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum).append(" as S SET (FCurUnitPrice)= (SELECT  ").append(" CASE WHEN FTotalRow = ").append(7).append(" or FTotalRow = ").append(8).append(" THEN 0 ").append(" WHEN FTotalRow >0 and FTotalRow <= ").append(6).append(" THEN  ");
        NCMReportHelper.AppendCaseSQLClause(sql, "FCurAllAmount", "FCurCompQty", " ", "FPriceDecimal");
        sql.append("  ELSE FCurUnitPrice END ").append(" ) ; \n ");
        return sql;
    }

    private String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException {
        int periodFrom = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
        int periodTo = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        String[] physicalTblNames = new String[3];
        try {
            physicalTblNames[0] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_CostCalPrdDetailResult", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            physicalTblNames[1] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_DataByProduct", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            physicalTblNames[2] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_DataByCostObj", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String createTmpTable() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append("FOrgName varchar(255) default(' ') ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) default(' ') ");
        createTable.append(",FCostCenterID varchar(44) default(' ') ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44)  default(' ') ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FProductID varchar(44)  default(' ') ");
        createTable.append(",FProductNumber varchar(255) default(' ') ");
        createTable.append(",FProductName varchar(255) default(' ') ");
        createTable.append(",FModel nvarchar(255) default(' ') ");
        createTable.append(",FUnitName varchar(255) default(' ') ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCostItemID varchar(44) default(' ')");
        createTable.append(",FCostItemNumber varchar(255) default(' ')");
        createTable.append(",FCostItemName varchar(255) default(' ')");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FTotalRow decimal(5,2) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(5,2) not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String getSQL(String companyName, RptParams filter, String[] physicalTblNames, String tmpTblName) {
        Context ctx = this.getContext();
        StringBuffer insert = new StringBuffer();
        insert.append(" Insert Into ").append(tmpTblName).append("(FOrgName,FPeriodID,FPeriodName,FPeriodNumber,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostObjectID,FCostObjectNumber ").append(",FCostObjectName,FProductID,FProductNumber,FProductName,FModel,FUnitName,FCurCompQty,FCostItemID ").append(",FCostItemNumber,FCostItemName,FCurAllAmount,FCurUnitPrice,FQtyDecimal,FPriceDecimal,FIsTotalRow) \n").append(" SELECT distinct '").append(companyName).append("',prd.Fid,to_char(prd.FPeriodYear) || to_char(prd.FPeriodNumber),to_char(prd.FNumber),cc.FID,cc.FNumber,cc.FName_l2,co.FID,co.FNumber").append(" ,co.FName_l2,mat.FID,mat.FNumber,mat.FName_l2,mat.FModel,mu.FName_l2,isnull(s.FFinishedQty,0)").append(" ,ci.FID,ci.FNumber,ci.FName_l2,isnull(cpr.FFinishedAmount,0) , ");
        NCMReportHelper.AppendCaseSQLClause(insert, "cpr.FFinishedAmount", "s.FFinishedQty", "FCurUnitPrice", "mat.FPricePrecision");
        insert.append(" , mmu.FQtyPrecision,mat.FPricePrecision").append(" , 0 AS FIsTotalRow ").append(" FROM ").append(physicalTblNames[0]).append(" AS cpr ").append("INNER JOIN ").append(physicalTblNames[1]).append(" s \n").append(" ON S.FCompanyID = cpr.FCompanyID and S.FCalculatePeriodID = cpr.FCalculatePeriodID and S.FCostCenterID =cpr.FCostCenterID ").append("  and S.FCostObjectID = cpr.FCostObjectID and S.FProductID =cpr.FProductID \n").append(" INNER JOIN T_BD_Period prd on cpr.FCalculatePeriodID = prd.FID                                    \n ").append(" INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID            \t\t\t\t\t\t    \n ").append(" INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID=ci.FID \n\t").append(" INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID)   \n").append(" INNER JOIN T_BD_Material mat on cpr.FProductID = mat.FID                                          \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu on mat.fid = mmu.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu on mmu.FMeasureUnitID = mu.FID    and mat.FBaseUnit=mu.fid          \n");
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append(" WHERE cpr.FCompanyID = ? \n").append(" \tAND co.FCalculateMode = ").append(3);
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, true, "prd.FNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "mat.FNumber", ">=", "prmtProductFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "mat.FNumber", "<=", "prmtProductTo");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "ci.FNumber", ">=", "prmtCostItemFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, "ci.FNumber", "<=", "prmtCostItemTo");
        NCMReportHelper.AppendPredicateForOnePage(whereSQL, filter, "FCostObjectID", "co.FID");
        String sql = insert.append(whereSQL).toString();
        return sql;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"36_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"37_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostCenterFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostCenterTo"))) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"4_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString(ctx, filter, "prmtCostCenterFrom") + "\u2014" + CalSeverUtils.getParamString(ctx, filter, "prmtCostCenterTo"));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"38_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostObjectFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostObjectTo"))) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"8_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString(ctx, filter, "prmtCostObjectFrom") + "\u2014" + CalSeverUtils.getParamString(ctx, filter, "prmtCostObjectTo"));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"39_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostItemFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtCostItemTo"))) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"12_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString(ctx, filter, "prmtCostItemFrom") + "\u2014" + CalSeverUtils.getParamString(ctx, filter, "prmtCostItemTo"));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"40_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (UIRuleUtil.isNotNull((Object)filter.getObject("prmtProductFrom")) || UIRuleUtil.isNotNull((Object)filter.getObject("prmtProductTo"))) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"41_ByClassCostCalReport", (Locale)ctx.getLocale()) + CalSeverUtils.getParamString(ctx, filter, "prmtProductFrom") + "\u2014" + CalSeverUtils.getParamString(ctx, filter, "prmtProductTo"));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"42_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        ArrayList tblData = (ArrayList)filter.getObject("table");
        ArrayList childs = header.getChilds();
        HashMap<String, ReportHeader> headerMap = new HashMap<String, ReportHeader>();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            ReportHeader child = (ReportHeader)childs.get(i2);
            String fieldName = child.getFieldName().toLowerCase();
            headerMap.put(fieldName.toLowerCase(), child);
        }
        ArrayList temp = new ArrayList(childs.size());
        temp.addAll(childs);
        childs.clear();
        ArrayList<String> sortedCols = new ArrayList<String>();
        sortedCols.add("FOrgName");
        int qtyCounter = 0;
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodNumber".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FPeriodNumber");
                ++qtyCounter;
            }
            if ("FCostobjectID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostObjectNumber");
                sortedCols.add("FCostObjectName");
            }
            if ("FProductID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FProduct");
                ++qtyCounter;
            }
            if ("FCostcenterID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostCenterNumber");
                sortedCols.add("FCostCenterName");
                ++qtyCounter;
            }
            if (!"FCostItemID".equalsIgnoreCase(fieldID)) continue;
            sortedCols.add("FCostItemNumber");
            sortedCols.add("FCostItemName");
            ++qtyCounter;
        }
        for (i = 0; i < sortedCols.size(); ++i) {
            String field = (String)sortedCols.get(i);
            ReportHeader child = (ReportHeader)headerMap.get(field.toLowerCase());
            if (child == null) continue;
            childs.add(child);
            temp.remove(child);
        }
        childs.addAll(temp);
        for (i = 0; i < childs.size(); ++i) {
            ReportHeader child = (ReportHeader)childs.get(i);
            if (!child.getFieldName().equalsIgnoreCase("FCurAllAmount")) continue;
            child.setDecimalField(null);
            child.setDecimal(this.getAmountPrecision(filter));
            break;
        }
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        ReportHeader childChildHeader = null;
        String childFieldName = null;
        ArrayList childChildList = null;
        for (int i3 = 0; i3 < childList.size(); ++i3) {
            childHeader = (ReportHeader)childList.get(i3);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCurUnitPrice")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"82_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProduct")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"181_ByClassCostCalReportFilter2UI", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (int j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FProductNumber")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ProductNumber_2", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FProductName")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ProductName_2", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FModel")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitName")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"UnitName", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FCurCompQty")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CurCompQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCurAllAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CurAllAmount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FOrgName")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CompanyOrgName", (Locale)ctx.getLocale()));
        }
        return header;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FTotalRow", 7, (Object)new BigDecimal(4), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(2), a);
        return conditions;
    }

    public String getSortString(Context ctx, RptParams filter, String sortMode) {
        ArrayList tableList = (ArrayList)filter.getObject("table");
        if (tableList == null) {
            tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FProductID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"181_ByClassCostCalReportFilter2UI", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
        }
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < tableList.size(); ++i) {
            HashMap map = (HashMap)tableList.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodNumber")) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortMode;
                fieldNumber = "FPeriodName";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                orderByWhichTotal = ", FTotalProductRow " + sortMode;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                sbChecked.append(fieldNumber);
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked.toString();
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (field.equalsIgnoreCase("FPeriodNumber") || field.equalsIgnoreCase("FPeriodName")) {
            sb.append("FPeriodNumber");
        } else {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        }
        return sb;
    }

    private int getAmountPrecision(RptParams rptFilter) throws BOSException {
        String companyID = ((CompanyOrgUnitInfo)rptFilter.getObject("prmtCompanyOrg")).getId().toString();
        if (this.amountPrecision < 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyID));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("baseCurrency.precision");
            view.setSelector(selector);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitCollection(view);
            if (coll.size() > 0 && coll.get(0).getBaseCurrency() != null) {
                this.amountPrecision = coll.get(0).getBaseCurrency().getPrecision();
            }
            if (this.amountPrecision < 0) {
                this.amountPrecision = 2;
            }
        }
        return this.amountPrecision;
    }
}

