/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.ncm.cal.report.app.AbstractCMPeriodFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMPeriodFacadeControllerBean
extends AbstractCMPeriodFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CMPeriodFacadeControllerBean");

    protected PeriodInfo _getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected PeriodInfo _getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected Map _getPeriodRange(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        Map map = null;
        map = this._getPeriodRangeNormal(ctx, 3, this._getStartPeriod(ctx, company), this._getCurrentPeriod(ctx, company), company);
        int maxYear = 0;
        int maxPeriod = 0;
        for (Object key : map.keySet()) {
            if (!(key instanceof Integer)) continue;
            int buf = (Integer)key;
            maxYear = maxYear < buf ? buf : maxYear;
        }
        int[] value = (int[])map.get(maxYear);
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            maxPeriod = maxPeriod < value[i] ? value[i] : maxPeriod;
        }
        HashMap<Integer, int[]> map2 = new HashMap<Integer, int[]>();
        map2.putAll(map);
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map2);
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        String periodType = company.getAccountPeriodType().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select A.c, A.FPeriodYear, B.FPeriodNumber from").append("\n (select count(1) c, FPeriodYear from t_bd_period where FTypeID=? and FPeriodYear*100+FPeriodNumber>? group by FPeriodYear) A").append("\n inner join t_bd_period B on B.FPeriodYear=A.FPeriodYear and B.FPeriodYear*100+B.FPeriodNumber>? and B.FTypeID=?").append("\n order by A.FPeriodYear, B.FPeriodNumber");
        RptRowSet rs = this.executeQuery(sb.toString(), new SqlParams().addString(periodType).addInt(maxYear * 100 + maxPeriod).addInt(maxYear * 100 + maxPeriod).addString(periodType), ctx);
        int i = 0;
        while (rs.next()) {
            int n2 = rs.getInt("c");
            if (n2 == 0) continue;
            int year = rs.getInt("FPeriodYear");
            int[] p = new int[n2];
            p[0] = rs.getInt("FPeriodNumber");
            i = 0;
            while (i++ < n2 - 1) {
                rs.next();
                p[i] = rs.getInt("FPeriodNumber");
            }
            Integer kk = year;
            if (map2.containsKey(kk)) {
                int[] op = (int[])map2.get(kk);
                int[] np = new int[op.length + p.length];
                System.arraycopy(op, 0, np, 0, op.length);
                System.arraycopy(p, 0, np, op.length, p.length);
                p = np;
            }
            int max = 0;
            int min = Integer.MAX_VALUE;
            for (int m = 0; m < p.length; ++m) {
                max = max < p[m] ? p[m] : max;
                min = min > p[m] ? p[m] : min;
            }
            map2.put(kk, new int[]{min, max});
        }
        return allMap;
    }

    protected Map _getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Integer, int[]> hashMap;
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParams parameter = new SqlParams();
        parameter.addString(company.getAccountPeriodType().getId().toString());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(year, periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        return this.executeQuery(sql, parameters, 0, -1, ctx);
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }
}

