/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.scm.cal.app.CostComputeSumRptServer;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;

public class CalcOutLogReport
extends CostComputeSumRptServer {
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private String calType = null;

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        StringBuffer buffer = new StringBuffer();
        buffer.append(SCMUtils.getResource((String)this.res, (String)"FCOMPANYNUMBER", (Context)this.getContext()));
        buffer.append(":");
        buffer.append(filter.getString("companyNumber") == null ? "" : filter.getString("companyNumber"));
        titles.AddTitle(0, buffer.toString());
        return titles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        String tmpeTableName = DBUtil.createTempTable((Context)this.getContext(), (String)"temp", (String[][])this.getcretateTmpeTableSql());
        DBUtil.createTempTableIndex((Context)this.getContext(), (String)tmpeTableName, (String)"fwarehouseNumber,FMaterialNumber", (boolean)false);
        DBUtil.execute((Context)this.getContext(), (String)this.getInsertSql(filter, tmpeTableName));
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            DBUtil.AnalyseTable((Context)this.getContext(), (Connection)conn, (String)tmpeTableName);
            DBUtil.execute((Context)this.getContext(), (String)this.getUpdateSql(filter, tmpeTableName));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return tmpeTableName;
    }

    private String getUpdateSql(RptParams filter, String tmpeTableName) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer();
        String strCalType = this.getCalType(filter, true);
        buffer.append("UPDATE ").append(tmpeTableName).append(" AS T1 ");
        buffer.append(" SET (FStatus,FStatusName)=(");
        buffer.append("\n SELECT 0,N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEFAIL", (Context)this.getContext())).append("' FROM (");
        buffer.append("\n SELECT T2.FCOMPANYORGUNITID,T2.FMATERIALID ");
        buffer.append(this.getFieldByCalType(strCalType));
        buffer.append("\n FROM ");
        buffer.append(tmpeTableName).append(" T2 ");
        buffer.append("\n WHERE (Fstatus = 0 OR Fstatus=2) ");
        buffer.append("\n GROUP BY T2.FCOMPANYORGUNITID,T2.FMATERIALID");
        buffer.append(this.getFieldByCalType(strCalType));
        buffer.append(") temp ");
        buffer.append("\n WHERE T1.FCOMPANYORGUNITID= temp.FCOMPANYORGUNITID AND T1.FMATERIALID = temp.FMATERIALID ");
        if ("2".equals(strCalType)) {
            buffer.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid AND T1.fwarehouseid =temp.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append("AND T1.fstorageorgunitid=temp.fstorageorgunitid ");
        }
        buffer.append(" AND T1.Fstatus =1");
        buffer.append(")");
        return buffer.toString();
    }

    private String getFieldByCalType(String strCalType) {
        StringBuffer buffer = new StringBuffer();
        if ("2".equals(strCalType)) {
            buffer.append(",T2.fstorageorgunitid,T2.fwarehouseid");
        } else if ("1".equals(strCalType)) {
            buffer.append(",T2.fstorageorgunitid");
        }
        return buffer.toString();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FYear,FPERIOD,");
        buffer.append(this.getFieldForCalType(filter));
        buffer.append("\n,FMaterialNumber,FMaterialName,FMaterialModel");
        buffer.append("\n,FStatus,FStatusName,FCompanyOrgUnitID");
        buffer.append("\n FROM ").append(tableName);
        buffer.append("\n GROUP BY FYear,FPERIOD,");
        buffer.append(this.getFieldForCalType(filter));
        buffer.append("\n,FMaterialNumber,FMaterialName,FMaterialModel");
        buffer.append("\n,FStatus,FStatusName,FCompanyOrgUnitID");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)buffer.toString(), (int)start, (int)rows);
        return rs;
    }

    private String getFieldForCalType(RptParams filter) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        try {
            String strCalType = this.getCalType(filter, false);
            buffer.append(" FCompanyNumber,FCompanyName");
            if ("2".equals(strCalType)) {
                buffer.append(",fstorageNumber,fstorageName,fwarehouseNumber,fwarehouseName");
            } else if ("1".equals(strCalType)) {
                buffer.append(",fstorageNumber,fstorageName ");
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return buffer.toString();
    }

    private String getInsertSql(RptParams filter, String tmpTableName) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(tmpTableName).append("(");
        buffer.append("FID,FYear,FPERIOD,FCompanyOrgUnitID,FCompanyNumber,FCompanyName");
        buffer.append("\n,fstorageorgunitid,fstorageNumber,fstorageName");
        buffer.append("\n,fwarehouseid,fwarehouseNumber,fwarehouseName");
        buffer.append("\n,FMaterialid,FMaterialNumber,FMaterialName");
        buffer.append("\n,FMaterialModel,FMatertialShortName,FAccountType");
        buffer.append("\n,FAccountTypeName,FStatus,FStatusName");
        buffer.append(")");
        buffer.append(this.getSelectDataSql(filter));
        return buffer.toString();
    }

    private String getSelectDataSql(RptParams filter) throws BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyInfo");
        String periodID = (String)filter.getObject("periodID");
        String maxRank = filter.getString("maxCalRank");
        boolean isOutsourcCalc = NCMUtils.isDoOutSourcCalc((Context)this.getContext(), (String)companyInfo.getId().toString());
        String calResutlTabl = null;
        try {
            calResutlTabl = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyInfo.getId().toString(), (String)"T_NCM_CostCalResult", (int)1);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT COSTCOMPUTEREPORT.fid AS CostComputerRptFID,COSTCOMPUTEREPORT.FYear AS FYEAR, COSTCOMPUTEREPORT.FPeriod AS FPERIOD, ");
        buffer.append("\n FINANCEORG.fid AS fcompanyOrgUnitid,FINANCEORG.FNumber AS FcompanyNumber,FINANCEORG.FName_l2 AS FcompanyName,");
        buffer.append("\n STORAGEORG.FID AS FSTORAGEORGUnitid,");
        buffer.append("\n STORAGEORG.FNumber AS FStorageOrgNumber,STORAGEORG.FName_l2 AS FstorageName,");
        buffer.append("\n WAREHOUSE.FID AS FwarehouseId,");
        buffer.append("\n WAREHOUSE.FNumber AS FwarehouseNumber,WAREHOUSE.FName_l2 AS FWarehouseName,");
        buffer.append("\n MATERIAL.FID AS FMaterialId,");
        buffer.append("\n MATERIAL.FNumber AS FMaterialNumber,MATERIAL.FName_l2 AS FMaterialName,");
        buffer.append("\n MATERIAL.Fmodel AS FmaterialModel,MATERIAL.fshortname AS FMaterialShortName,");
        buffer.append("\n MATERIALCOMPANY.FAccountType as FAccountType,");
        buffer.append("\n CASE WHEN MATERIALCOMPANY.FAccountType=1 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"MOVEAVERAGEKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=2 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"STANDARDKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=3 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"AVERAGEKIND", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN MATERIALCOMPANY.FAccountType=4 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"FIFOKIND", (Context)this.getContext())).append("'");
        buffer.append("\n ELSE  N'").append(SCMUtils.getResource((String)this.res, (String)"LOTAVERAGEKIND", (Context)this.getContext())).append("' END AS accountName,");
        buffer.append("\n COSTCOMPUTEREPORT.FIsSusccessed as FIsSusccessed,");
        buffer.append("\n CASE WHEN COSTCOMPUTEREPORT.FIsSusccessed=0 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEFAIL", (Context)this.getContext())).append("'");
        buffer.append("\n WHEN COSTCOMPUTEREPORT.FIsSusccessed=1 THEN N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTESUCESS", (Context)this.getContext())).append("'");
        buffer.append("\n ELSE  N'").append(SCMUtils.getResource((String)this.res, (String)"COMPUTEEXCEPTION", (Context)this.getContext())).append("' END AS statusName");
        buffer.append("\n FROM T_CL_CostComputeReport AS COSTCOMPUTEREPORT");
        buffer.append("\n LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON COSTCOMPUTEREPORT.FWarehouseID = WAREHOUSE.FID");
        buffer.append("\n LEFT OUTER JOIN T_ORG_Storage AS STORAGEORG ON COSTCOMPUTEREPORT.FStorageOrgUnitID = STORAGEORG.FID");
        buffer.append("\n LEFT OUTER JOIN T_BD_Material AS MATERIAL ON COSTCOMPUTEREPORT.FMaterialID = MATERIAL.FID");
        buffer.append("\n LEFT OUTER JOIN T_ORG_Company AS FINANCEORG ON COSTCOMPUTEREPORT.FCompanyOrgUnitID = FINANCEORG.FID");
        buffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS MATERIALCOMPANY ON COSTCOMPUTEREPORT.FMaterialID = MATERIALCOMPANY.FMaterialID AND COSTCOMPUTEREPORT.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID");
        buffer.append("\n AND COSTCOMPUTEREPORT.FAccountType = MATERIALCOMPANY.FAccountType");
        if (isOutsourcCalc) {
            buffer.append("\n INNER JOIN ( select  distinct entry.FCostObjectID AS FMaterialID From  T_CAL_CostObjectRank bill ");
            buffer.append("\n               inner join T_CAL_CostObjectRankEntry entry on bill.FID = entry.FParentID ");
            buffer.append("\n              where bill.FCOMPANYORG = '").append(companyInfo.getId().toString()).append("' AND bill.FCALCULATEPERIOD").append(" = '").append(periodID).append("'");
            if (!StringUtil.isEmpty((String)filter.getString("calRank"))) {
                buffer.append("\n AND          entry.FRank ='").append(Integer.valueOf(maxRank) - Integer.valueOf(filter.getString("calRank"))).append("'");
            }
        } else {
            buffer.append("\n INNER JOIN ( select  distinct coentry.FRelatedID AS FMaterialID From ").append(calResutlTabl).append(" calrs ");
            buffer.append("\n INNER JOIN T_BD_CostObjectEntry coentry on calrs.FCostObjectID = coentry.FParentID ");
            buffer.append("\n              where 1=1 ");
            if (!StringUtil.isEmpty((String)filter.getString("calRank"))) {
                buffer.append("\n AND          calrs.FCalcLevel ='").append(Integer.valueOf(maxRank) - Integer.valueOf(filter.getString("calRank"))).append("'");
            }
        }
        buffer.append("\n ) calData on calData.FMaterialID = MATERIAL.FID ");
        buffer.append("\n WHERE  1=1 ");
        if (!StringUtil.isEmpty((String)filter.getString("companyNumber"))) {
            buffer.append("\n AND FINANCEORG.FNUMBER='").append(filter.getString("companyNumber")).append("'");
        }
        if (!StringUtil.isEmpty((String)filter.getString("stroageNumber"))) {
            buffer.append("\n AND STORAGEORG.FNUMBER='").append(filter.getString("stroageNumber")).append("'");
        }
        if (!StringUtil.isEmpty((String)filter.getString("year"))) {
            buffer.append("\n AND COSTCOMPUTEREPORT.FYear = '").append(filter.getString("year")).append("'");
        }
        if (!StringUtil.isEmpty((String)filter.getString("period"))) {
            buffer.append("\n AND COSTCOMPUTEREPORT.FPeriod='").append(filter.getString("period")).append("'");
        }
        if (filter.getBoolean("chk_OnlyVisibleErrorRpt")) {
            buffer.append("\n AND (COSTCOMPUTEREPORT.FIsSusccessed=0 OR COSTCOMPUTEREPORT.FIsSusccessed=2)");
        }
        return buffer.toString();
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", header);
        this.getCalType(filter, true);
        ReportHeader hd = header.addChild();
        hd.setFieldName("FYear");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)this.getContext()));
        hd.setWidth(60);
        hd.setIndex(1);
        hd = header.addChild();
        hd.setFieldName("FPERIOD");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)this.getContext()));
        hd.setWidth(50);
        hd.setIndex(2);
        hd = header.addChild();
        hd.setFieldName("FCompanyNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FCOMPANYNUMBER", (Context)this.getContext()));
        hd.setWidth(80);
        hd.setIndex(3);
        hd = header.addChild();
        hd.setFieldName("FCompanyName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FICU", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(4);
        if (this.isCreateColFromCalType(this.calType, 1)) {
            hd = header.addChild();
            hd.setFieldName("fstorageNumber");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)this.getContext()));
            hd.setWidth(100);
            hd.setIndex(5);
            hd = header.addChild();
            hd.setFieldName("fstorageName");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"StorageName", (Context)this.getContext()));
            hd.setWidth(100);
            hd.setIndex(6);
        }
        if (this.isCreateColFromCalType(this.calType, 2)) {
            hd = header.addChild();
            hd.setFieldName("fwarehouseNumber");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"WAREHOUSENUM", (Context)this.getContext()));
            hd.setWidth(100);
            hd.setIndex(7);
            hd = header.addChild();
            hd.setFieldName("fwarehouseName");
            hd.setCaption(SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)this.getContext()));
            hd.setWidth(150);
            hd.setIndex(9);
        }
        hd = header.addChild();
        hd.setFieldName("FMaterialNumber");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)this.getContext()));
        hd.setWidth(80);
        hd.setIndex(9);
        hd = header.addChild();
        hd.setFieldName("FMaterialName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)this.getContext()));
        hd.setWidth(150);
        hd.setIndex(10);
        hd = header.addChild();
        hd.setFieldName("FMaterialModel");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)this.getContext()));
        hd.setWidth(150);
        hd.setIndex(11);
        hd = header.addChild();
        hd.setFieldName("FStatusName");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FISCUCCESSED", (Context)this.getContext()));
        hd.setWidth(100);
        hd.setIndex(12);
        hd = header.addChild();
        hd.setFieldName("FStatus");
        hd.setCaption(SCMUtils.getResource((String)this.res, (String)"FISCUCCESSED", (Context)this.getContext()));
        hd.setWidth(150);
        hd.setIndex(13);
        hd.setVisible(false);
        hd = header.addChild();
        hd.setFieldName("FCompanyOrgUnitID");
        hd.setWidth(150);
        hd.setIndex(14);
        hd.setVisible(false);
        return header;
    }

    private boolean isCreateColFromCalType(String calType, int colIndex) {
        boolean ret = false;
        if ("0".equals(calType)) {
            ret = false;
        } else if ("1".equals(calType)) {
            ret = colIndex == 1;
        }
        if ("2".equals(calType)) {
            ret = true;
        }
        return ret;
    }

    private String[][] getcretateTmpeTableSql() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL PRIMARY KEY"}, {"FYear", "int DEFAULT 0 "}, {"FPERIOD", "int DEFAULT 0  "}, {"FCompanyOrgUnitID", "VARCHAR(44) "}, {"FCompanyNumber", "NVARCHAR(80) "}, {"FCompanyName", "NVARCHAR(250) "}, {"fstorageorgunitid", "VARCHAR(44)"}, {"fstorageNumber", "NVARCHAR(80)"}, {"fstorageName", "NVARCHAR(250)"}, {"fwarehouseid", "VARCHAR(44)"}, {"fwarehouseNumber", "NVARCHAR(80)"}, {"fwarehouseName", "NVARCHAR(250)"}, {"FMaterialid", "VARCHAR(44)"}, {"FMaterialNumber", "NVARCHAR(80)"}, {"FMaterialName", "NVARCHAR(250)"}, {"FMaterialModel", "NVARCHAR(250)"}, {"FMatertialShortName", "NVARCHAR(250)"}, {"FAccountType", "int"}, {"FAccountTypeName", "NVARCHAR(250)"}, {"FStatus", "int default 0 "}, {"FStatusName", "VARCHAR(250)"}};
        return fields;
    }

    private String getCalType(RptParams filter, boolean isRefresh) throws BOSException, EASBizException {
        String companyNumber;
        if ((isRefresh || this.calType == null) && !StringUtil.isEmpty((String)(companyNumber = filter.getString("companyNumber"))) && companyNumber != null) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
            if (companyColl != null && companyColl.size() > 0) {
                IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.getContext());
                this.calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyColl.get(0).getId()), "SCM_CAL_002");
            }
        }
        return this.calType;
    }
}

