/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CalcYearSum {
    private static Logger logger = Logger.getLogger((String)CalcYearSum.class.getName());
    private String costCalResultTbl = null;
    private String costCalResultHisTbl = null;
    private String allDataByCostObjTbl = null;
    private String allDataByCostObjHisTbl = null;
    private String yearSumAmountData = null;
    private String yearSumQtyData = null;
    private String balanceTbl = null;
    private String balanceHisTbl = null;
    private String balanceEntryTbl = null;
    private String balanceEntryHisTbl = null;
    private String preTreatStateTbl = null;

    public CalcYearSum(Context ctx, boolean isReCalSum, String periodFrom, String periodTo, String companyId) throws BOSException, EASBizException {
        this.doCalcYearSum(ctx, isReCalSum, companyId, periodFrom, periodTo);
    }

    private void doCalcYearSum(Context ctx, boolean isReCalSum, String companyId, String periodFrom, String periodTo) throws EASBizException, BOSException {
        this.initDynamicTblName(ctx, companyId);
        String[][] periods = this.getPeriodsInfo(ctx, companyId, periodFrom, periodTo);
        if (periods == null) {
            return;
        }
        for (int i = 0; i < periods.length; ++i) {
            if (!this.isNeedReCalc(ctx, isReCalSum, companyId, periods[i][0])) continue;
            this.doSum(ctx, companyId, periods[i]);
        }
    }

    private void doSum(Context ctx, String companyId, String[] periodInfo) throws BOSException, EASBizException {
        String calStarPeriodNumber = periodInfo[2] + "01";
        String calEndPeriodNumber = periodInfo[1];
        String calPeriodID = periodInfo[0];
        String currPeriodNumber = String.valueOf(NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId).getNumber());
        String initPeriodNUmber = String.valueOf(NCMUtils.GetStartPeriod((Context)ctx, (String)companyId).getNumber());
        boolean isUnion = false;
        StringBuffer calSql = new StringBuffer();
        calSql.append(" delete from " + this.yearSumAmountData).append(" Where FCalculatePeriodID = '" + calPeriodID + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)calSql.toString());
        calSql.setLength(0);
        calSql.append(" Insert Into " + this.yearSumAmountData);
        calSql.append(" (FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID,FYearSumInAmount,FYearSumComAmount) \n");
        calSql.append(" select '" + calPeriodID + "',FCostCenterID,FCostObjectID,FCostItemID,Sum(FYearSumInAmount),Sum(FYearSumComAmount) \n");
        calSql.append(" From ( \n");
        if (initPeriodNUmber.compareTo(calStarPeriodNumber) >= 0) {
            calSql.append("       Select FCostCenterID,FCostObjectID,FCostItemID,isnull(FYTDInputAmount,0) as FYearSumInAmount,isnull(FYTDFinishAmount,0) as FYearSumComAmount \n");
            if (initPeriodNUmber.equals(currPeriodNumber)) {
                calSql.append("       From " + this.balanceTbl + " bala \n");
                calSql.append("       Inner join " + this.balanceEntryTbl + " balaEntry on bala.FID = balaEntry.FParentID \n");
                calSql.append("       Where FYTDInputAmount <> 0 or FYTDFinishAmount <> 0 \n");
            } else {
                calSql.append("       From " + this.balanceHisTbl + " bala \n");
                calSql.append("       Inner join " + this.balanceEntryHisTbl + " balaEntry on bala.FID = balaEntry.FParentID \n");
                calSql.append("       Inner join T_BD_Period per ON per.FID = bala.FCalculatePeriodID \n");
                calSql.append("       Where per.FNumber = " + initPeriodNUmber + " And FYTDInputAmount <> 0 or FYTDFinishAmount <> 0 \n");
            }
            calSql.append("       Union All \n");
        }
        if (currPeriodNumber.equals(calEndPeriodNumber)) {
            isUnion = true;
            calSql.append("           Select calRs.FCostCenterID,calRs.FCostObjectID,calRs.FCostItemID, \n");
            calSql.append("                  isnull(calRs.FFinishedAmount,0) + isnull(calRs.FEoPWipAmount,0) - isnull(calRs.FAdjEoPWipAmount,0) - isnull(balData.FBoPWipAmount,0) as FYearSumInAmount, \n");
            calSql.append("                  FFinishedAmount as FYearSumComAmount \n");
            calSql.append("               From " + this.costCalResultTbl + " calRs \n");
            calSql.append("               Left join ( \n");
            calSql.append("                            select FCostCenterID,FCostObjectID,FCostItemID,FBoPWipAmount \n");
            calSql.append("                                From " + this.balanceTbl + " bal \n");
            calSql.append("                                Inner join " + this.balanceEntryTbl + " balentry on bal.FID = balEntry.FParentID \n");
            calSql.append("                           ) balData \n");
            calSql.append("               on balData.FCostCenterID = calRs.FCostCenterID And balData.FCostObjectID = calRs.FCostObjectID \n");
            calSql.append("                   And balData.FCostItemID = calRs.FCostItemID \n");
        }
        if (!currPeriodNumber.equals(calStarPeriodNumber)) {
            if (isUnion) {
                calSql.append("       Union All \n");
            }
            isUnion = false;
            calSql.append("           Select calRs.FCostCenterID,calRs.FCostObjectID,calRs.FCostItemID, \n");
            calSql.append("                  isnull(calRs.FFinishedAmount,0) + isnull(calRs.FEoPWipAmount,0) - isnull(calRs.FAdjEoPWipAmount,0) - isnull(balData.FBoPWipAmount,0) as FYearSumInAmount, \n");
            calSql.append("                  FFinishedAmount as FYearSumComAmount \n");
            calSql.append("               From " + this.costCalResultHisTbl + " calRs \n");
            calSql.append("               Left join ( \n");
            calSql.append("                            select FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID,isnull(FBoPWipAmount,0) as FBoPWipAmount \n");
            calSql.append("                                From " + this.balanceHisTbl + " bal \n");
            calSql.append("                                Inner join " + this.balanceEntryHisTbl + " balentry on bal.FID = balEntry.FParentID \n");
            calSql.append("                                Inner join T_BD_Period per on per.FID = bal.FCalculatePeriodID \n");
            calSql.append("                                where FNumber >= " + calStarPeriodNumber + " AND FNumber <= " + calEndPeriodNumber + " \n");
            calSql.append("                                --Group by FCostCenterID,FCostObjectID,FCostItemID \n");
            calSql.append("                           ) balData \n");
            calSql.append("               on balData.FCalculatePeriodID = calRs.FCalculatePeriodID and balData.FCostCenterID = calRs.FCostCenterID And balData.FCostObjectID = calRs.FCostObjectID \n");
            calSql.append("                   And balData.FCostItemID = calRs.FCostItemID \n");
            calSql.append("               Inner join T_BD_Period per on per.FID = calRs.FCalculatePeriodID \n");
            calSql.append("               where FNumber >= " + calStarPeriodNumber + " AND FNumber <= " + calEndPeriodNumber + " \n");
        }
        calSql.append("      ) data \n");
        calSql.append(" Group by FCostCenterID,FCostObjectID,FCostItemID \n");
        NCMDbUtil.execute((Context)ctx, (String)calSql.toString());
        calSql.setLength(0);
        calSql.append(" delete from " + this.yearSumQtyData).append(" Where FCalculatePeriodID = '" + calPeriodID + "' \n");
        NCMDbUtil.execute((Context)ctx, (String)calSql.toString());
        calSql.setLength(0);
        calSql.append(" Insert Into " + this.yearSumQtyData);
        calSql.append(" (FCalculatePeriodID,FCostCenterID,FCostObjectID,FYearSumInQty, FYearSumComQty) \n");
        calSql.append(" select '" + calPeriodID + "',FCostCenterID,FCostObjectID,Sum(FYearSumInQty), Sum(FYearSumComQty) \n");
        calSql.append(" From ( \n");
        if (initPeriodNUmber.compareTo(calStarPeriodNumber) >= 0) {
            calSql.append("       Select FCostCenterID,FCostObjectID,0 FYearSumInQty,isnull(FYTDFinishedQty,0) as FYearSumComQty \n");
            if (initPeriodNUmber.equals(currPeriodNumber)) {
                calSql.append("       From " + this.balanceTbl + " bala \n");
                calSql.append("       Where FYTDFinishedQty <> 0 \n");
            } else {
                calSql.append("       From " + this.balanceHisTbl + " bala \n");
                calSql.append("       Inner join T_BD_Period per ON per.FID = bala.FCalculatePeriodID \n");
                calSql.append("       Where per.FNumber = " + initPeriodNUmber + "And FYTDFinishedQty <> 0 \n");
            }
            calSql.append("       Union All \n");
        }
        calSql.append("           Select bill.FCostCenterOrgUnitID as FCostCenterID,entry.FCostObjectID as FCostObjectID, \n");
        calSql.append("               entry.FQty as FYearSumInQty, 0 as FYearSumComQty \n");
        calSql.append("               From T_NCM_InputQtyBill bill \n");
        calSql.append("               Inner join T_NCM_InputQtyBillEntry entry on entry.FParentID = bill.FID \n");
        calSql.append("               Inner join T_BD_Period period on period.FID = bill.FCalculatePeriod \n");
        calSql.append("               Where period.Fnumber >= " + calStarPeriodNumber + " AND period.FNumber <= " + calEndPeriodNumber + " \n");
        calSql.append("                   And bill.FCompanyOrg = '").append(companyId).append("' And bill.FBillStatus = 4 \n");
        calSql.append("       Union All \n");
        if (currPeriodNumber.equals(calEndPeriodNumber)) {
            isUnion = true;
            calSql.append("           Select FCostCenterID,FCostObjectID, \n");
            calSql.append("                  0 as FYearSumInQty, \n");
            calSql.append("                  isnull(FFinishedQty,0) as FYearSumComQty \n");
            calSql.append("               From " + this.allDataByCostObjTbl + " calRs \n");
        }
        if (!currPeriodNumber.equals(calStarPeriodNumber)) {
            if (isUnion) {
                calSql.append("       Union All \n");
            }
            isUnion = false;
            calSql.append("           Select FCostCenterID,FCostObjectID, \n");
            calSql.append("                  0 as FYearSumInQty, \n");
            calSql.append("                  isnull(FFinishedQty,0) as FYearSumComQty \n");
            calSql.append("               From " + this.allDataByCostObjHisTbl + " calRs \n");
            calSql.append("               Inner join T_BD_Period per on per.FID = calRs.FCalculatePeriodID \n");
            calSql.append("               where FNumber >= " + calStarPeriodNumber + " AND FNumber <= " + calEndPeriodNumber + " \n");
        }
        calSql.append("      ) data \n");
        calSql.append(" Group by FCostCenterID,FCostObjectID \n");
        NCMDbUtil.execute((Context)ctx, (String)calSql.toString());
        calSql.setLength(0);
        calSql.append(" update " + this.preTreatStateTbl);
        calSql.append(" set FIsPreTreatYearSum=1 where FPeriodId = '" + calPeriodID + "';\n\n");
        NCMDbUtil.execute((Context)ctx, (String)calSql.toString());
    }

    private void initDynamicTblName(Context ctx, String companyId) throws BOSException, EASBizException {
        try {
            this.costCalResultTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult");
            this.costCalResultHisTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult_History");
            this.allDataByCostObjTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj");
            this.allDataByCostObjHisTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj_History");
            this.yearSumAmountData = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_YearSumAmountData");
            this.yearSumQtyData = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_YearSumQtyData");
            this.balanceTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
            this.balanceHisTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance_History");
            this.balanceEntryTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry");
            this.balanceEntryHisTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry_History");
            this.preTreatStateTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalReportPreTreatState");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String[][] getPeriodsInfo(Context ctx, String companyId, String periodFrom, String periodTo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        StringBuffer getPeriodSql = new StringBuffer();
        getPeriodSql.append(" SELECT FID, FNumber, FPeriodYear FROM T_BD_Period \n");
        getPeriodSql.append(" WHERE FTypeID ='").append(companyInfo.getAccountPeriodType().getId().toString()).append("' \n");
        getPeriodSql.append("   AND FNumber >= ").append(periodFrom).append(" \n");
        getPeriodSql.append("   AND FNumber <= ").append(periodTo).append(" \n");
        getPeriodSql.append(" Order by FNumber \n");
        IRowSet data = DbUtil.executeQuery((Context)ctx, (String)getPeriodSql.toString());
        if (data != null && data.size() > 0) {
            String[][] periodIds = new String[data.size()][3];
            int i = 0;
            try {
                data.first();
                while (data.getRow() > 0 && !data.isAfterLast()) {
                    periodIds[i][0] = data.getString("FID");
                    periodIds[i][1] = data.getString("FNumber");
                    periodIds[i++][2] = data.getString("FPeriodYear");
                    data.next();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return periodIds;
        }
        return null;
    }

    private boolean isNeedReCalc(Context ctx, boolean isReCalSum, String companyId, String periodID) throws BOSException {
        String sql = "select FIsPreTreatYearSum from " + this.preTreatStateTbl + " Where FPeriodId = '" + periodID + "' order by FPeriodNumber ";
        IRowSet data = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String isRecal = "";
        try {
            if (data != null && data.next()) {
                isRecal = data.getString("FIsPreTreatYearSum");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isReCalSum || "0".equals(isRecal);
    }
}

