/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostBatchTotalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CostBatchTotalReport");
    private String tempTableNameSum = new String();

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        String tempTableNameMain;
        String tableName;
        StringBuffer sqlAll = new StringBuffer();
        Locale locale = this.getContext().getLocale();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String cuID = DefaultCU.getId().toString();
        StringBuffer filterContent = this.buildFilter(filter);
        String[] tableNames = new String[2];
        int periodFrom = Integer.parseInt(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        int periodTo = Integer.parseInt(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_DataByCostObj", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[0] = tableName;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_CostCalResult", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[1] = tableName;
        StringBuffer createTableMain = this.getTempTableMain();
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer createTableSum = this.getTempTableSum();
        String tempTableNameSum = "";
        try {
            tempTableNameSum = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSum.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sqlAll.append(this.insertDataToTableMain(tempTableNameMain, companyID, cuID, filterContent, tableNames));
        sqlAll.append(this.insertDataToTableSum(tempTableNameMain, tempTableNameSum, locale, companyID));
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableNameMain);
        return tempTableNameSum;
    }

    protected StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getMain ( ");
        createTable.append(" FPeriodID varchar(80) ");
        createTable.append(" ,FPeriodNumber varchar(20) ");
        createTable.append(",FCostCenterID varchar(44) DEFAULT(' ')");
        createTable.append(",FProductID varchar(44)  DEFAULT(' ')");
        createTable.append(",FBatchNumber nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FQty decimal(21,8)  default(0)");
        createTable.append(",FCostObjectID varchar(44)  DEFAULT(' ')");
        createTable.append(",FCostItemID varchar(44)  DEFAULT(' ')");
        createTable.append(",FAmount decimal(21,8) default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer getTempTableSum() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append(" FPeriodNumber varchar(20) ");
        createTable.append(",FCostCenterID varchar(44)  DEFAULT(' ')");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FProductID varchar(44)  DEFAULT(' ')");
        createTable.append(",FProductNumber varchar(255)  DEFAULT(' ')");
        createTable.append(",FProductName varchar(255)  DEFAULT(' ')");
        createTable.append(",FModel nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FBatchNumber nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FQty decimal(21,8)  default(0)");
        createTable.append(",FCostObjectID varchar(44)  DEFAULT(' ')");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FOrderNumber varchar(255) default(' ')");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FCostItemID varchar(44)  DEFAULT(' ')");
        createTable.append(",FCostItemNumber varchar(255)  DEFAULT(' ')");
        createTable.append(",FCostItemName varchar(255)  DEFAULT(' ')");
        createTable.append(",FAmount decimal(21,8) default(0) ");
        createTable.append(",FUnitAmount decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FUnitPriceDecimal int default(0) ");
        createTable.append(",FTotal1 int default(0) ");
        createTable.append(",FTotal2 int default(0) ");
        createTable.append(",FTotal3 int default(0) ");
        createTable.append(",FColour decimal(21,8) default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer insertDataToTableMain(String tempTableNameMain, String companyID, String cuID, StringBuffer filter, String[] tableNames) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into " + tempTableNameMain + " (FCostCenterID,FProductID,FBatchNumber,FPeriodID,FPeriodNumber,FCostObjectID,FQty) \n");
        sql.append(" SELECT T1.FCostCenterID, t6.FID,t4.FBatchNumber \n,t1.FCalculatePeriodID , t5.FNumber,T1.FCostObjectID,T1.FFinishedQty \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" AND T1.FCompanyID = t4.FCompanyID  \n");
        sql.append(" AND t4.FCalculateMode=4 \n");
        sql.append(" left join T_MM_ManufactureOrder od on t4.FOrderID = od.FID \n");
        sql.append(" inner join t_bd_period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" inner join t_bd_Material t6 on t4.FStdProductIDID = t6.FID \n ");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filter);
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FCostCenterID,FProductID,FBatchNumber,FPeriodID,FPeriodNumber,FCostObjectID,FCostItemID,FAmount) \n");
        sql.append(" SELECT T1.FCostCenterID, t6.FID,t4.FBatchNumber \n,t1.FCalculatePeriodID , t5.FNumber,T1.FCostObjectID,T1.FCostItemID,T1.FFinishedAmount \n");
        sql.append(" FROM " + tableNames[1] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" AND t4.FCalculateMode=4 \n");
        sql.append(" left join T_MM_ManufactureOrder od on t4.FOrderID = od.FID \n");
        sql.append(" inner join t_bd_period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" inner join t_bd_Material t6 on t4.FStdProductIDID = t6.FID \n ");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filter);
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameMain + "\n");
        sql.append(" SET FBatchNumber = ' ' \n");
        sql.append(" WHERE FBatchNumber IS NULL ");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer insertDataToTableSum(String tempTableNameMain, String tempTableNameSum, Locale locale, String companyID) {
        Context ctx = this.getContext();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO " + tempTableNameSum + "\n");
        sql.append("(FCostCenterID,FProductID,FBatchNumber, \nFPeriodNumber,FCostObjectID,FCostItemID,FQty,FAmount) \n");
        sql.append(" SELECT FCostCenterID,FProductID,FBatchNumber,FPeriodNumber, \n");
        sql.append(" FCostObjectID,FCostItemID,FQty,FAmount \n");
        sql.append(" FROM " + tempTableNameMain + "\n");
        sql.append("\n\n;");
        sql.append(" INSERT INTO " + tempTableNameSum + "\n");
        sql.append("(FCostCenterID,FProductID,FBatchNumber,FPeriodNumber,\nFCostObjectID,FAmount,FQty,FTOTAL1,FTOTAL2,FTOTAL3,FColour) \n");
        sql.append(" SELECT FCostCenterID,FProductID,FBatchNumber,FPeriodNumber, \n");
        sql.append(" FCostObjectID,sum(FAmount),sum(FQty),1,0,0,101 \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" group by FPeriodNumber,FCostCenterID,FProductID,FBatchNumber,FCostObjectID \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n SET FQty=0 \n WHERE FQty IS NULL \n");
        sql.append("\n\n;");
        sql.append(" INSERT INTO " + tempTableNameSum + "\n");
        sql.append("(FCostCenterID,FProductID,FQty, FPeriodNumber, \nFCostItemID,FAmount,FTOTAL1,FTOTAL2,FTOTAL3,FColour) \n");
        sql.append(" SELECT TT.FCostCenterID,TT.FProductID,sum(TT.FQty),FPeriodNumber,\n");
        sql.append(" TT.FCostItemID,sum(TT.FAmount),1,1,0,102 \n");
        sql.append(" FROM " + tempTableNameSum + " AS TT \n");
        sql.append(" INNER JOIN \n");
        sql.append(" (SELECT COUNT(1) AS GNUMBER,T1.FCostCenterID,T1.FProductID FROM \n");
        sql.append("  (SELECT DISTINCT FCostCenterID,FProductID,FBatchNumber,FCostObjectID \n  FROM " + tempTableNameSum + "\n");
        sql.append("  WHERE FTOTAL1=0 AND FTOTAL2=0 AND FTOTAL3=0) AS T1 \n");
        sql.append("  GROUP BY T1.FCostCenterID,T1.FProductID) AS T2 \n");
        sql.append("  ON TT.FCostCenterID=T2.FCostCenterID AND TT.FProductID=T2.FProductID \n");
        sql.append("  where TT.FTOTAL1=0 and TT.FTOTAL2=0 AND T2.GNUMBER>1 \n");
        sql.append(" group by TT.FPeriodNumber,TT.FCostCenterID,TT.FProductID,TT.FCostItemID\n");
        sql.append("\n\n;");
        sql.append(" INSERT INTO " + tempTableNameSum + "\n");
        sql.append("(FCostCenterID,FProductID,FQty,FPeriodNumber,\nFAmount,FTOTAL1,FTOTAL2,FTOTAL3,FColour) \n");
        sql.append(" SELECT TT.FCostCenterID,TT.FProductID,sum(TT.FQty),TT.FPeriodNumber, \n");
        sql.append(" sum(TT.FAmount),2,1,0,102 \n");
        sql.append(" FROM " + tempTableNameSum + " AS TT \n");
        sql.append(" INNER JOIN \n");
        sql.append(" (SELECT COUNT(1) AS GNUMBER,T1.FCostCenterID,T1.FProductID FROM \n");
        sql.append("  (SELECT DISTINCT FCostCenterID,FProductID,FBatchNumber,FCostObjectID \n  FROM " + tempTableNameSum + "\n");
        sql.append("  WHERE FTOTAL1=0 AND FTOTAL2=0 AND FTOTAL3=0) AS T1 \n");
        sql.append("  GROUP BY T1.FCostCenterID,T1.FProductID) AS T2 \n");
        sql.append("  ON TT.FCostCenterID=T2.FCostCenterID AND TT.FProductID=T2.FProductID \n");
        sql.append("  where TT.FTOTAL1=1 and TT.FTOTAL2=0 AND T2.GNUMBER>1 \n");
        sql.append(" group by TT.FPeriodNumber,TT.FCostCenterID,TT.FProductID \n");
        sql.append("\n\n;");
        sql.append(" INSERT INTO " + tempTableNameSum + "\n");
        sql.append("(FCostItemID,FQty,\nFAmount,FTOTAL1,FTOTAL2,FTOTAL3,FColour) \n");
        sql.append(" SELECT FCostItemID,sum(FQty), \n");
        sql.append(" sum(FAmount),1,1,1,103 \n");
        sql.append(" FROM " + tempTableNameSum + " \n");
        sql.append(" WHERE FTOTAL1=0 and FTOTAL2=0 \n");
        sql.append(" group by FCostItemID \n");
        sql.append("\n\n;");
        sql.append(" DELETE FROM " + tempTableNameSum + " \n");
        sql.append(" WHERE FTOTAL3 = 1 AND FTOTAL2 = 1 AND FTOTAL1 = 2 \nAND FQTY IS NULL AND FAMOUNT IS NULL");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FQTY) = \n");
        sql.append(" ( SELECT T2.FQTY \n");
        sql.append(" FROM   (SELECT FPeriodNumber,FCostCenterID,FProductID,FBatchNumber,FCostObjectID,MAX(FQTY) AS FQTY \n FROM " + tempTableNameSum + " \n");
        sql.append(" GROUP BY FPeriodNumber,FCostCenterID,FProductID,FBatchNumber,FCostObjectID ) AS T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FPeriodNumber=T2.FPeriodNumber \n AND " + tempTableNameSum + ".FCostCenterID=T2.FCostCenterID \n AND " + tempTableNameSum + ".FProductID=T2.FProductID \n");
        sql.append(" AND " + tempTableNameSum + ".FBatchNumber=T2.FBatchNumber \n AND " + tempTableNameSum + ".FCostObjectID = T2.FCostObjectID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
        sql.append(" SET (FTOTAL1) = (SELECT 200 FROM ( \n");
        sql.append(" SELECT FCostCenterID,FProductID,FBatchNumber,FCostObjectID \n");
        sql.append(" FROM " + tempTableNameSum + " \n");
        sql.append(" WHERE FTotal1=0 \n");
        sql.append(" GROUP BY FCostCenterID,FProductID,FBatchNumber,FCostObjectID \n");
        sql.append(" having count(1)>1) T2 \n");
        sql.append(" WHERE T2.fcostcenterid=T1.FCostCenterID \n");
        sql.append(" AND T2.FProductID=T1.FProductID \n");
        sql.append(" AND T2.FBatchNumber=T1.FBatchNumber \n");
        sql.append(" AND T2.fcostobjectid = T1.FCostObjectID \n");
        sql.append(" AND T1.FCOSTITEMID= ' ' \n");
        sql.append(" AND T1.FTOTAL1= 0) \n");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + " WHERE FTOTAL1=200 ");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + " \n where FAmount=0 AND FCostItemID=' ' AND (FTOTAL1 = 1 AND FTOTAL2=1) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FUnitAmount= (CASE WHEN FQTY <>0 THEN  to_decimal(FAmount)/to_decimal(FQTY) ELSE 0 END) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FQTY = NULL,FUNITAMOUNT = NULL  \n");
        sql.append(" WHERE FQTY=0 AND FTOTAL2=1 AND FTOTAL3 = 1\n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + locale + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostItemNumber,FCostItemName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + locale + " \n");
        sql.append(" FROM T_NCM_COSTITEM T2 WHERE " + tempTableNameSum + ".FCostItemID = T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName,FOrderNumber)= \n");
        sql.append(" (SELECT T2.FNumber,T2.FName_" + locale + " ,od.FNumber \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" left join T_MM_ManufactureOrder od on T2.FOrderID = od.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FProductNumber,FProductName, \nFModel)= \n");
        sql.append(" (SELECT T3.FNumber,T3.FName_" + locale + " \n,T3.FModel \n");
        sql.append(" FROM t_bd_Material T3 ");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID=T3.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal= \n");
        sql.append(" (SELECT MAX(T4.FqtyPrecision) \n");
        sql.append(" FROM t_bd_Material T3 ");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FProductID=T3.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FUnitPriceDecimal= \n");
        sql.append(" (SELECT MAX(T3.FPricePrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append("UPDATE ").append(tempTableNameSum).append(" SET (FPriceDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FUnitPriceDecimal = (SELECT MAX(FUnitPriceDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FCostItemName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'  \n");
        sql.append(" WHERE FCOLOUR=101  \n  OR (FTOTAL1 = 2 AND FCOLOUR=102) \n OR (FTOTAL1=2 AND FCOLOUR=103) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FBatchNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'  \n");
        sql.append(" WHERE FCOLOUR=102  \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FProductName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'  \n");
        sql.append(" WHERE FCOLOUR=103  \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FUnitAmount = ROUND(FUnitAmount,FUnitPriceDecimal) \n");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer buildFilter(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(" and t5.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        sb.append(" \n");
        sb.append(" and t5.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        sb.append(" \n");
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("' \n");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("' \n");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("' \n");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("' \n");
        }
        if (filter.getString("productFrom") != null && !"".equals(filter.getString("productFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("productFrom")).append("' \n");
        }
        if (filter.getString("productTo") != null && !"".equals(filter.getString("productTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("productTo")).append("' \n");
        }
        if (filter.getString("batchFrom") != null && !"".equals(filter.getString("batchFrom"))) {
            sb.append(" and t4.FBatchNumber >='").append(filter.getString("batchFrom")).append("' \n");
        }
        if (filter.getString("batchTo") != null && !"".equals(filter.getString("batchTo"))) {
            sb.append(" and t4.FBatchNumber <='").append(filter.getString("batchTo")).append("' \n");
        }
        if (filter.getString("orderNumberFrom") != null && !"".equals(filter.getString("orderNumberFrom"))) {
            sb.append(" and od.FNumber >='").append(filter.getString("orderNumberFrom")).append("' \n");
        }
        if (filter.getString("orderNumberTo") != null && !"".equals(filter.getString("orderNumberTo"))) {
            sb.append(" and od.FNumber <='").append(filter.getString("orderNumberTo")).append("' \n");
        }
        return sb;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"36_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"37_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        if (filter.getString("costcenterFrom") != null || filter.getString("costcenterTo") != null) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"4_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costcenterFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costcenterTo")));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"38_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("productFrom") != null || filter.getString("productTo") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"50_CostBatchTotalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("productFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("productTo")));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"51_CostBatchTotalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("batchFrom") != null || filter.getString("batchTo") != null) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"52_CostBatchTotalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("batchFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("batchTo")));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"53_CostBatchTotalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("costobjectFrom") != null || filter.getString("costobjectTo") != null) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"8_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costobjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costobjectTo")));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"39_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("orderNumberFrom") != null || filter.getString("orderNumberTo") != null) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"223_OrderNumber", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("orderNumberFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("orderNumberTo")));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"224_OrderNumber", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FCOLOUR", 1, (Object)new BigDecimal(101), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FCOLOUR", 1, (Object)new BigDecimal(102), a);
        a = new Appearance();
        a.backColor = new Color(255, 255, 206);
        conditions.add("FCOLOUR", 1, (Object)new BigDecimal(103), a);
        return conditions;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPeriodNumber,FCostCenterID,FCostCenterNumber,FCostCenterName,FProductID \n");
        sql.append(" ,FProductNumber,FProductName,FModel,FBatchNumber,FQty,FCostObjectID \n");
        sql.append(" ,FCostObjectNumber,FCostObjectName,FCostItemID,FCostItemNumber,FOrderNumber \n");
        sql.append(" ,FCostItemName,FAmount,FUnitAmount,FQtyDecimal,FPriceDecimal,FUnitPriceDecimal \n");
        sql.append(" ,FTOTAL1,FTOTAL2,FTOTAL3,FCOLOUR \n");
        sql.append(" FROM " + tableName + " \n");
        sql.append(" where FQty > 0 ");
        sql.append(" ORDER BY FPeriodNumber,FTotal3,FCostCenterNumber,FProductNumber \n");
        sql.append(" ,FTotal2,FBatchNumber,FCostObjectNumber,FTotal1,FCostItemNumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)start, (int)rows);
        return rs;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 8).setMergeable(true);
        header.addChild("FPeriodNumber", "\u6838\u7b97\u671f\u95f4", 0).setAlign(1).setMergeable(true);
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBatchNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"65_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FUnitAmount")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"224_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return header;
    }
}

