/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CostCalReportPreTreatMent {
    private static Logger logger = Logger.getLogger((String)CostCalReportPreTreatMent.class.getName());
    private CompanyOrgUnitInfo companyInfo;
    private String controlUnitId;
    private int startPeriodNumber;
    private String currentPeriodId;
    private String tblPreTreatState;
    private String tblPreTreatData;
    private String periodIdInFilter;

    public boolean isNeedPreTreatMent(String periodFrom, String periodTo, String companyId, boolean isYearSum) {
        return false;
    }

    public String getPeriodIdInFilter() {
        return this.periodIdInFilter;
    }

    public String getTblPreTreatData() {
        return this.tblPreTreatData;
    }

    public CostCalReportPreTreatMent(Context ctx, String periodFrom, String periodTo, String companyId, boolean isYearSum) throws BOSException {
        this.preTreatMent(ctx, periodFrom, periodTo, companyId, true);
    }

    public void preTreatMent(Context ctx, String periodFrom, String periodTo, String companyId, boolean isYearSum) throws BOSException {
        boolean isRecalYearSum = false;
        StringBuffer sql = new StringBuffer();
        try {
            this.initParam(ctx, companyId);
            String[][] periodIds = this.getPeriodIds(ctx, periodFrom, periodFrom, periodTo, companyId, isYearSum);
            if (periodIds == null || periodIds.length <= 0) {
                return;
            }
            String[][] periodDataState = this.getPeriodDataState(ctx, periodIds, periodIds[0][1], periodTo, companyId, isYearSum);
            for (int i = 0; i < periodDataState.length; ++i) {
                if (!"0".equals(periodDataState[i][1]) && !"0".equals(periodDataState[i][2])) continue;
                isRecalYearSum = true;
            }
            if (periodDataState == null || periodDataState.length <= 0) {
                return;
            }
            if (isRecalYearSum && "0".equals(periodDataState[periodDataState.length - 1][2])) {
                sql.append(" update " + this.tblPreTreatState);
                sql.append(" set FIsPreTreatreportData = 0,FIsPreTreatYearSum=0 where fperiodNUmber >= " + periodIds[0][1] + ";\n\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            periodDataState = this.getPeriodDataState(ctx, periodIds, periodIds[0][1], periodTo, companyId, isYearSum);
            this.preTreatReportDataCommon(ctx, periodIds, periodDataState, companyId);
            List selectPeriodDataState = this.getSelectPeriodDataState(ctx, periodIds[0][1], periodFrom, periodTo, companyId, periodDataState);
            this.preTreatReportDataYearSum(ctx, periodIds, selectPeriodDataState, companyId);
            if (isRecalYearSum) {
                sql.setLength(0);
                sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
                sql.append("SET  (FYearSumCompQty) = (\n");
                sql.append(" Select s.FYearSumCompQty + isnull(init.FYTDFinishedQty,0) \n");
                sql.append("  FROM ").append(this.tblPreTreatData).append(" S \n");
                sql.append("  left join T_ncm_initBalance init on init.FCompanyOrg = '" + this.companyInfo.getId().toString() + "' and init.FcostCenterID = s.FCostCenterID and init.FcostobjectID = s.FCostObjectID \n");
                sql.append(" WHERE S.FCostCenterID=D.FCostCenterID \n");
                sql.append("   AND S.FCostObjectID=D.FCostObjectID and S.FPeriodID = D.FPeriodID and S.FCostItemID is null and S.FIsHistoryData = D.FIsHistoryData) \n");
                sql.append("where      D.FCostItemID is null \n");
                sql.append("\n;");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
                sql.append("SET  (FYearSumCompAmount) = (\n");
                sql.append(" Select s.FYearSumCompAmount + isnull(initentry.FYTDFinishAmount,0) \n");
                sql.append("  FROM ").append(this.tblPreTreatData).append(" S \n");
                sql.append("  left join T_ncm_initBalance init on init.FCompanyOrg = '" + this.companyInfo.getId().toString() + "' and init.FcostCenterID = s.FCostCenterID and init.FcostobjectID = s.FCostObjectID \n");
                sql.append("  left join T_ncm_initBalanceEntry initentry on initEntry.FparentID = init.fid and initEntry.fCostItemID = s.FCostItemID \n");
                sql.append(" WHERE S.FCostCenterID=D.FCostCenterID \n");
                sql.append("   AND S.FCostObjectID=D.FCostObjectID and S.FPeriodID = D.FPeriodID and S.FCostItemID = D.FCostItemID and S.FIsHistoryData = D.FIsHistoryData) \n");
                sql.append("where      D.FCostItemID is not null \n");
                sql.append("\n;");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
                sql.append("SET  (FYearSumInAmount) = (\n");
                sql.append(" Select s.FYearSumInAmount + isnull(initentry.FYTDInputAmount,0) \n");
                sql.append("  FROM ").append(this.tblPreTreatData).append(" S \n");
                sql.append("  left join T_ncm_initBalance init on init.FCompanyOrg = '" + this.companyInfo.getId().toString() + "' and init.FcostCenterID = s.FCostCenterID and init.FcostobjectID = s.FCostObjectID \n");
                sql.append("  left join T_ncm_initBalanceEntry initentry on initEntry.FparentID = init.fid and initEntry.fCostItemID = s.FCostItemID \n");
                sql.append(" WHERE S.FCostCenterID=D.FCostCenterID \n");
                sql.append("   AND S.FCostObjectID=D.FCostObjectID and S.FPeriodID = D.FPeriodID and S.FCostItemID = D.FCostItemID and S.FIsHistoryData = D.FIsHistoryData) \n");
                sql.append("where      D.FCostItemID is not null \n");
                sql.append("\n;");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
                sql.append("SET FIsHistoryData = 0 \n");
                sql.append("where  exists (select 1 from " + this.tblPreTreatData + " S where S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID and S.FPeriodID = D.FPeriodID and FIsHistoryData = 0 )\n");
                sql.append("\n;");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append(" update " + this.tblPreTreatState);
                sql.append(" set FIsPreTreatreportData = 1,FIsPreTreatYearSum=1 where fperiodNUmber >= " + periodIds[0][1] + ";\n\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private List getSelectPeriodDataState(Context ctx, String periodFrom, String periodFromFilter, String periodTo, String companyId, String[][] periodDataState) throws EASBizException, BOSException, SQLException {
        String[][] periodNeedPreTreatIds = this.getPeriodIds(ctx, periodFrom, periodFromFilter, periodTo, companyId, false);
        ArrayList<String[]> periodDataStateList = new ArrayList<String[]>();
        for (int i = 0; i < periodNeedPreTreatIds.length; ++i) {
            for (int j = 0; j < periodDataState.length; ++j) {
                if (!periodNeedPreTreatIds[i][0].equals(periodDataState[j][0])) continue;
                periodDataStateList.add(periodDataState[j]);
            }
        }
        return periodDataStateList;
    }

    private void initParam(Context ctx, String companyId) throws EASBizException, BOSException, SQLException {
        this.companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        this.controlUnitId = DefaultCU.getId().toString();
        PeriodInfo startPeriod = NCMUtils.GetStartPeriod((Context)ctx, (String)companyId);
        this.startPeriodNumber = startPeriod.getNumber();
        PeriodInfo currentPeriod = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        this.currentPeriodId = currentPeriod.getId().toString();
        this.tblPreTreatState = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalReportPreTreatState");
        this.tblPreTreatData = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_CostCalReportPreTreatData");
    }

    private String[][] getPeriodIds(Context ctx, String periodFrom, String periodFromFilter, String periodTo, String companyId, boolean isYearSum) throws EASBizException, BOSException, SQLException {
        String sql;
        IRowSet _Data;
        String where = "";
        String periodFromSpecial = null;
        if (periodFrom != null && periodFrom.length() > 0) {
            periodFromSpecial = isYearSum ? periodFrom.substring(0, 4) + "01" : periodFrom;
        }
        if (periodFromSpecial == null || Integer.valueOf(periodFromSpecial) < this.startPeriodNumber) {
            periodFromSpecial = Integer.valueOf(this.startPeriodNumber).toString();
        }
        where = where + " and FNumber>=" + periodFromSpecial;
        if (periodTo != null && periodTo.length() > 0) {
            where = where + " and FNumber<=" + periodTo;
        }
        if ((_Data = DbUtil.executeQuery((Context)ctx, (String)(sql = " SELECT FID, FNumber, FPeriodYear FROM T_BD_Period  WHERE FTypeID ='" + this.companyInfo.getAccountPeriodType().getId().toString() + "'" + where + " order by FNumber "))) != null && _Data.size() > 0) {
            String[][] periodIds = new String[_Data.size()][3];
            ArrayList<String> periodIdList = new ArrayList<String>();
            int i = 0;
            _Data.first();
            while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                if (periodFromFilter.compareTo(_Data.getString("FNumber")) <= 0 && periodTo.compareTo(_Data.getString("FNumber")) >= 0) {
                    periodIdList.add(_Data.getString("FID"));
                }
                periodIds[i][0] = _Data.getString("FID");
                periodIds[i][1] = _Data.getString("FNumber");
                periodIds[i++][2] = _Data.getString("FPeriodYear");
                _Data.next();
            }
            if (!isYearSum && periodIdList.size() > 0) {
                this.periodIdInFilter = this.getIdsInFromIdList(periodIdList).toString();
            }
            return periodIds;
        }
        return null;
    }

    private String[][] getPeriodDataState(Context ctx, String[][] periodIds, String periodFrom, String periodTo, String companyId, boolean isYearSum) throws EASBizException, BOSException, SQLException {
        String[][] periodStates = new String[periodIds.length][4];
        ArrayList<String> idList = new ArrayList<String>();
        int i = 0;
        IRowSet _Data = this.getSelectPeriodStates(ctx, periodIds, companyId);
        if (_Data != null && _Data.size() > 0) {
            _Data.first();
            while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                idList.add(_Data.getString("FPeriodId"));
                periodStates[i][0] = _Data.getString("FPeriodId");
                periodStates[i][1] = _Data.getString("FPeriodNumber");
                periodStates[i][2] = _Data.getString("FIsPreTreatReportData");
                periodStates[i++][3] = _Data.getString("FIsPreTreatYearSum");
                _Data.next();
            }
        }
        if (idList.size() < periodIds.length) {
            ArrayList<Object[]> idPreTreatList = new ArrayList<Object[]>();
            for (int j = 0; j < periodIds.length; ++j) {
                if (idList.contains(periodIds[j][0])) continue;
                periodStates[i][0] = periodIds[j][0];
                periodStates[i][1] = periodIds[j][1];
                periodStates[i][2] = "0";
                periodStates[i++][3] = "0";
                idPreTreatList.add(new Object[]{periodIds[j][0], periodIds[j][1], "0", "0"});
            }
            if (idPreTreatList.size() > 0) {
                StringBuffer sb = new StringBuffer();
                String sqlInsert = "insert into " + this.tblPreTreatState + "(FID, FPeriodId, FPeriodNumber, FIsPreTreatReportData, FIsPreTreatYearSum) values (newbosid(''2640287C''), ''{0}'', ''{1}'', {2}, {3});";
                for (int k = 0; k < idPreTreatList.size(); ++k) {
                    sb.append(MessageFormat.format(sqlInsert, (Object[])idPreTreatList.get(k)));
                }
                NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString());
            }
        }
        return periodStates;
    }

    private IRowSet getSelectPeriodStates(Context ctx, String[][] periodIds, String companyId) throws EASBizException, BOSException, SQLException {
        String where = "";
        if (periodIds != null && periodIds.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < periodIds.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("'").append(periodIds[i][0]).append("'");
            }
            if (sb.length() > 0) {
                where = where + " where FPeriodId in (" + sb.toString() + ")";
            }
        }
        String sql = "select FPeriodId, FPeriodNumber, FIsPreTreatReportData, FIsPreTreatYearSum from " + this.tblPreTreatState + where + " order by FPeriodNumber ";
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    private void preTreatReportDataCommon(Context ctx, String[][] periodIds, String[][] periodDataState, String companyId) throws BOSException, EASBizException, SQLException {
        ArrayList<String> preTreatPeriodIdList = new ArrayList<String>();
        for (int i = 0; i < periodDataState.length; ++i) {
            String[] ov = periodDataState[i];
            if (Integer.valueOf(ov[2]) != 0) continue;
            String periodId = ov[0];
            preTreatPeriodIdList.add(periodId);
        }
        if (preTreatPeriodIdList.size() > 0) {
            this.preTreatReportDataForCommon(ctx, periodIds, companyId, preTreatPeriodIdList);
        }
    }

    private void preTreatReportDataForCommon(Context ctx, String[][] periodIds, String companyId, List preTreatPeriodIdList) throws EASBizException, BOSException, SQLException {
        String[] dataSourceTables = this.getDataSourceTables(ctx, companyId, preTreatPeriodIdList);
        StringBuffer preiodIdsFilter = this.getIdsInFromIdList(preTreatPeriodIdList);
        String tempTableOfSoureData = null;
        try {
            tempTableOfSoureData = this.createTempTableBySql(ctx, this.getTempTableOfSoureData(), "FPeriodId, FCostCenterID, FCostObjectID, FCostItemID");
            StringBuffer preTreatDataForCommon = new StringBuffer();
            preTreatDataForCommon.append(this.insertDataTempTableOfSoureData(ctx, tempTableOfSoureData, companyId, this.controlUnitId, preiodIdsFilter, dataSourceTables, periodIds));
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)preTreatDataForCommon.toString());
            preTreatDataForCommon.setLength(0);
            preTreatDataForCommon.append(this.insertDataToPreTreatData(tempTableOfSoureData, this.tblPreTreatData, preiodIdsFilter));
            if (preTreatDataForCommon.length() > 0) {
                NCMServerUtils.BatchSqlExecute((Context)ctx, (String)preTreatDataForCommon.toString());
            }
        }
        catch (BOSException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            if (tempTableOfSoureData != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableOfSoureData);
            }
        }
    }

    private String[] getDataSourceTables(Context ctx, String companyId, List preTreatPeriodIdList) throws EASBizException, BOSException, SQLException {
        boolean containCurrentPeriod = preTreatPeriodIdList.contains(this.currentPeriodId);
        boolean dataMoreThanOnePeriod = preTreatPeriodIdList.size() > 1;
        int flag = 0;
        if (containCurrentPeriod && !dataMoreThanOnePeriod) {
            flag = 1;
        } else if (!containCurrentPeriod) {
            flag = 2;
        } else if (containCurrentPeriod && dataMoreThanOnePeriod) {
            flag = 3;
        }
        String[] dataSourceTables = new String[]{NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_Balance", (int)flag), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry", (int)flag), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult", (int)flag), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_DataByCostObj", (int)flag), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj", (int)flag), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_CostCalResult", (int)3), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry", (int)3), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_DataByCostObj", (int)3), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_Balance", (int)3), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_AllDataByCostObj", (int)3)};
        return dataSourceTables;
    }

    protected StringBuffer getTempTableOfSoureData() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempTableOfSoureData ( ");
        createTable.append("FPeriodId varchar(44) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FBegProQty decimal(21,8) default(0) ");
        createTable.append(",FAdjBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FBegProAmount decimal(21,8) default(0) ");
        createTable.append(",FAdjBegProAmount decimal(21,8) default(0) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FInputHour decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FFinishHour decimal(21,8) default(0) ");
        createTable.append(",FCurCompAmount decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FAdjEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FAdjEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FBalanceYearCompQty   decimal(21,8) default(0) ");
        createTable.append(",FBalanceYearCompAmount   decimal(21,8) default(0) ");
        createTable.append(",FBalanceYearInAmount   decimal(21,8) default(0) ");
        createTable.append(",FIsHistoryData   int  default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer insertDataTempTableOfSoureData(Context ctx, String tempTableNameMain, String companyID, String cuID, StringBuffer filter, String[] tableNames, String[][] periodIds) throws EASBizException, BOSException, SQLException {
        String yearStatPeirodNumer;
        String periodNumber;
        String periodID;
        int i;
        StringBuffer sql = new StringBuffer();
        String tblAllDataByCostObj = tableNames[4];
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID, FBegProQty,FAdjBegProQty,FBalanceYearCompQty ) \n");
        sql.append("SELECT distinct t1.FCalculatePeriodID as FPeriodId, T1.FCostCenterID,T1.FCostObjectID,isnull(T1.FBopWIPQty,0),isnull(T1.FAdjBopWipQty,0), \n");
        sql.append(" (case when T1.FYTDFinishedQty is null then 0 else isnull(T1.FYTDFinishedQty,0) end) as FBalanceYearCompQty \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId,FCostCenterID,FCostObjectID,FBopWIPHour ) \n");
        sql.append("SELECT t1.FCalculatePeriodID,T1.FCostCenterID,T1.FCostObjectID,\n");
        sql.append(" T1.FBopWIPHour \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID,FCostItemID, FBegProAmount,FAdjBegProAmount,FBalanceYearCompAmount,FBalanceYearInAmount ) \n");
        sql.append("SELECT  t1.FCalculatePeriodID as FPeriodId, T1.FCostCenterID,T1.FCostObjectID,T2.FCostItemID,isnull(T2.FBoPWIPAmount,0),isnull(T2.FAdjBoPWipAmount,0), \n");
        sql.append(" isnull(T2.FYTDFinishAmount,0),isnull(T2.FYTDInputAmount,0) \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n INNER JOIN " + tableNames[1] + " T2 ON T1.FID=T2.FParentID \n");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS COSTITEM ON COSTITEM.FID = T2.FCostItemID \n");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID,FCurInQty ) \n");
        sql.append(" SELECT t1.FCalculatePeriod as FPeriodId, T1.FCostCenterOrgUnitID,T2.FCostObjectID,isnull(T2.FQty,0) ");
        sql.append(" FROM T_NCM_InputQtyBill T1 ");
        sql.append(" INNER JOIN T_NCM_InputQtyBillEntry T2 ON T1.FID=T2.FParentID ");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append("  and t1.FBillStatus=4 ");
        sql.append("  and t1.FCalculatePeriod in (").append(filter).append(")");
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " \n");
        sql.append("   (FPeriodID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FInputHour) \n");
        sql.append("   SELECT t1.FCalculatePeriodID , \n");
        sql.append("          T1.Fcostcenterid, \n");
        sql.append("          T1.FCostObjectID, \n");
        sql.append("          sum(isnull(T1.FInputHour,0)) \n");
        sql.append("     FROM " + tblAllDataByCostObj + " T1 \n");
        sql.append("    where t1.FCompanyID = '" + companyID + "' \n");
        sql.append("      and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("    group by T1.FCompanyID, \n");
        sql.append("             t1.FCalculatePeriodID , \n");
        sql.append("             t1.Fcostcenterid, \n");
        sql.append("             T1.FCostObjectID \n;");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId,FCostCenterID, FCostObjectID,FCostItemID,FCurCompAmount,FEndProAmount,FAdjEndProAmount) \n");
        sql.append(" SELECT t1.FCalculatePeriodID as FPeriodId, T1.FCostCenterID, T1.FCostObjectID,T1.FCostItemID,isnull(T1.FFinishedAmount,0),isnull(T1.FEoPWIPAmount,0),isnull(T1.FAdjEoPWipAmount,0) \n");
        sql.append(" FROM " + tableNames[2] + " T1 \n");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID, FCostObjectID, FCurCompQty) \n");
        sql.append(" SELECT t1.FCalculatePeriodID as FPeriodId, T1.FCostCenterID, T1.FCostObjectID, T1.FFinishedQty \n");
        sql.append(" FROM " + tableNames[3] + " T1 \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID, FCostObjectID, FEndProQty,FAdjEndProQty) \n");
        sql.append(" SELECT t1.FCalculatePeriodID as FPeriodId, T1.FCostCenterID, T1.FCostObjectID, isnull(T1.FEopWipQty,0),isnull(T1.FAdjEopWipQty,0) \n");
        sql.append(" FROM " + tblAllDataByCostObj + " T1 \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append("  and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into " + tempTableNameMain + " \n");
        sql.append("   (FPeriodID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FFinishHour) \n");
        sql.append("   SELECT t1.FCalculatePeriodID, \n");
        sql.append("          T1.Fcostcenterid, \n");
        sql.append("          T1.FCostObjectID, \n");
        sql.append("          sum(T1.FFinishedHour) \n");
        sql.append("     FROM " + tblAllDataByCostObj + " T1 \n");
        sql.append("    where t1.FCompanyID = '" + companyID + "' \n");
        sql.append("      and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("    group by T1.FCompanyID, \n");
        sql.append("             t1.FCalculatePeriodID, \n");
        sql.append("             t1.Fcostcenterid, \n");
        sql.append("             T1.FCostObjectID \n;");
        sql.append(" Insert Into " + tempTableNameMain + " \n");
        sql.append("   (FPeriodID, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FEopWIPHour) \n");
        sql.append("   SELECT t1.FCalculatePeriodID, \n");
        sql.append("          T1.Fcostcenterid, \n");
        sql.append("          T1.FCostObjectID, \n");
        sql.append("          sum(isnull(T1.FEopWIPHour,0)) \n");
        sql.append("     FROM " + tblAllDataByCostObj + " T1 \n");
        sql.append("    where t1.FCompanyID = '" + companyID + "' \n");
        sql.append("      and t1.FCalculatePeriodID in (").append(filter).append(")");
        sql.append("    group by T1.FCompanyID, \n");
        sql.append("             t1.FCalculatePeriodID, \n");
        sql.append("             t1.Fcostcenterid, \n");
        sql.append("             T1.FCostObjectID \n;");
        PeriodInfo currPeirod = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyID);
        boolean isCal = false;
        String calResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_CostCalResult");
        String calSql1 = "select 1 from " + calResult;
        IRowSet calData = DbUtil.executeQuery((Context)ctx, (String)calSql1);
        if (calData != null && calData.size() > 1) {
            isCal = true;
        }
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        for (i = 0; i < periodIds.length; ++i) {
            periodID = periodIds[i][0];
            periodNumber = periodIds[i][1];
            yearStatPeirodNumer = periodNumber.substring(0, 4) + "01";
            if (currPeirod.getId().toString().equals(periodID) && !isCal) continue;
            sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID,FCostItemID,FBalanceYearCompQty, FBegProAmount, FBalanceYearCompAmount,FBalanceYearInAmount,FIsHistoryData ) \n");
            sql.append("SELECT  '" + periodID + "' as FPeriodId, T1.FCostCenterID,T1.FCostObjectID,T1.FCostItemID,0,max(balEntryHis.FBoPWIPAmount),\n");
            sql.append(" sum(isnull(T1.FFinishedAmount,0)),max(isnull(T1.FFinishedAmount,0) + isnull(T1.FEoPWIPQty, 0) - isnull(balEntryHis.FBoPWIPAmount,0)),1 \n");
            sql.append(" FROM " + tableNames[5] + " T1 \n");
            sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
            sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
            sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
            sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
            sql.append(" UNION \n");
            sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
            sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
            sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
            sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
            sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
            sql.append(" INNER JOIN T_BD_Period period on period.FID = t1.FCalculatePeriodID");
            sql.append(" left join " + tableNames[8] + " balHis on balHis.FCalculatePeriodID = period.FID and t1.FCostCenterID = balHis.FCostCenterID  and t1.FCostObjectID = balHis.FCostObjectID  \n");
            sql.append(" left join " + tableNames[6] + " balEntryHis on balHis.FID = balEntryHis.FParentID and t1.FCostItemID = balEntryHis.FCostItemID \n");
            sql.append(" where t1.FCompanyid = '" + companyID + "' \n");
            sql.append("  and period.Fnumber < " + periodNumber);
            sql.append("  AND period.Fnumber >= " + yearStatPeirodNumer);
            sql.append("  and not exists (select 1 from " + tableNames[5] + " bala\n");
            sql.append("                    where bala.FCalculateperiodID = '" + periodID + "' and t1.FCostCenterID = bala.FCostCenterID and t1.FCostObjectID = bala.FCostObjectID ) \n");
            sql.append("  and (balEntryHis.FBoPWIPAmount<>0 or isnull(T1.FFinishedAmount,0) <> 0 or isnull(T1.FFinishedAmount,0) + isnull(T1.FEoPWIPQty, 0) - isnull(balEntryHis.FBoPWIPAmount,0) <> 0 ) \n");
            sql.append(" group by t1.FCostCenterID, t1.FCostObjectID, T1.FCostItemID");
            sql.append("\n\n;");
            sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID,FBalanceYearCompQty,FIsHistoryData) \n");
            sql.append("SELECT  '" + periodID + "' as FPeriodId, data1.FCostCenterID,data1.FCostObjectID,isnull(data1.FFinishedQty,0),1  from (\n");
            sql.append("SELECT Distinct T1.FCostCenterID as FCostCenterID,T1.FCostObjectID as FCostObjectID,T1.FFinishedQty as FFinishedQty \n");
            sql.append(" FROM " + tableNames[7] + " T1 \n");
            sql.append(" INNER JOIN T_BD_Period period on period.FID = t1.FCalculatePeriodID");
            sql.append(" where t1.FCompanyid = '" + companyID + "' \n");
            sql.append("  and period.Fnumber < " + periodNumber);
            sql.append("  AND period.Fnumber >= " + yearStatPeirodNumer);
            sql.append("  and not exists (select 1 from " + tableNames[5] + " bala\n");
            sql.append("                    where bala.FCalculateperiodID = '" + periodID + "' and t1.FCostCenterID = bala.FCostCenterID and t1.FCostObjectID = bala.FCostObjectID )  \n");
            sql.append("  and not exists (select 1 from " + tableNames[9] + " coData \n");
            sql.append("                    where coData.FCalculateperiodID = '" + periodID + "' and t1.FCostCenterID = coData.FCostCenterID and t1.FCostObjectID = coData.FCostObjectID ) \n");
            sql.append("  and isnull(T1.FFinishedQty,0) <> 0 \n");
            sql.append("  ) as data1 \n");
            sql.append("\n\n;");
        }
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        for (i = 0; i < periodIds.length; ++i) {
            periodID = periodIds[i][0];
            periodNumber = periodIds[i][1];
            yearStatPeirodNumer = periodNumber.substring(0, 4) + "01";
            if (currPeirod.getId().toString().equals(periodID) && !isCal) continue;
            sql.append(" Insert Into " + tempTableNameMain + " (FPeriodId, FCostCenterID,FCostObjectID,FCostItemID,FBalanceYearCompQty, FBegProAmount, FBalanceYearCompAmount,FBalanceYearInAmount,FIsHistoryData ) \n");
            sql.append("SELECT  '" + periodID + "' as FPeriodId, T1.FCostCenterID,T1.FCostObjectID,T1.FCostItemID,0,max(balEntryHis.FBoPWIPAmount),\n");
            sql.append(" max(isnull(T1.FFinishedAmount,0)),max(isnull(T1.FFinishedAmount,0)),2 \n");
            sql.append(" FROM " + tableNames[5] + " T1 \n");
            sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
            sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
            sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
            sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
            sql.append(" UNION \n");
            sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
            sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
            sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
            sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
            sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
            sql.append(" INNER JOIN T_BD_Period period on period.FID = t1.FCalculatePeriodID");
            sql.append(" left join " + tableNames[8] + " balHis on balHis.FCalculatePeriodID = period.FID and t1.FCostCenterID = balHis.FCostCenterID  and t1.FCostObjectID = balHis.FCostObjectID  \n");
            sql.append(" left join " + tableNames[6] + " balEntryHis on balHis.FID = balEntryHis.FParentID and t1.FCostItemID = balEntryHis.FCostItemID \n");
            sql.append(" where t1.FCompanyid = '" + companyID + "' \n");
            sql.append("  and period.Fnumber < " + periodNumber);
            sql.append("  AND period.Fnumber >= " + yearStatPeirodNumer);
            sql.append("  and not exists (select 1 from " + tableNames[5] + " bala\n");
            sql.append("                    where bala.FCalculateperiodID = '" + periodID + "' and t1.FCostCenterID = bala.FCostCenterID and t1.FCostObjectID = bala.FCostObjectID and t1.FCostItemID =bala.FCostItemID ) \n");
            sql.append("  and exists (select 1 from " + tableNames[5] + " bala\n");
            sql.append("                    where bala.FCalculateperiodID = '" + periodID + "' and t1.FCostCenterID = bala.FCostCenterID and t1.FCostObjectID = bala.FCostObjectID ) \n");
            sql.append("  and balEntryHis.FBoPWIPAmount <> 0 ");
            sql.append(" group by t1.FCostCenterID, t1.FCostObjectID, T1.FCostItemID");
            sql.append("\n\n;");
        }
        return sql;
    }

    private StringBuffer insertDataToPreTreatData(String tempTableOfSoureData, String tblPreTreatData, StringBuffer preiodIds) {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from " + tblPreTreatData + " where FPeriodId in (" + preiodIds + ") \n\n;");
        sql.append(" INSERT INTO " + tblPreTreatData + "(");
        sql.append(" FPeriodId,FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" FBegProQty, FBegProAmount, \n");
        sql.append(" FAdjBopWipQty, FAdjBopWipAmount, \n");
        sql.append(" FCurInQty, FCurInAmount, FCurCompQty, FCurCompAmount, \n");
        sql.append(" FEndProQty, FEndProAmount, FMakeSum, \n");
        sql.append(" FAdjEopWipQty, FAdjEopWipAmount, \n");
        sql.append(" FBalanceYearCompQty, FBalanceYearCompAmount, FBalanceYearInAmount) \n");
        sql.append(" SELECT FPeriodId, FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" Sum(FBegProQty) as FBegProQty, \n");
        sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
        sql.append(" Sum(FAdjBegProQty) as FAdjBegProQty, \n");
        sql.append(" Sum(FAdjBegProAmount) as FAdjBegProAmount, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurCompAmount)+Sum(FEndProAmount)-Sum(FAdjEndProAmount)-Sum(FBegProAmount) as FCurInAmount, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FCurCompAmount) as FCurCompAmount, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" Sum(FCurCompAmount)+Sum(FEndProAmount)-Sum(FAdjEndProAmount) as FMakeSum, \n");
        sql.append(" Sum(FAdjEndProQty) as FAdjEndProQty, \n");
        sql.append(" Sum(FAdjEndProAmount) as FAdjEndProAmount, \n");
        sql.append(" SUM(FBalanceYearCompQty) as FBalanceYearCompQty, \n");
        sql.append(" Sum(FBalanceYearCompAmount) as FBalanceYearCompAmount, \n");
        sql.append(" Sum(FBalanceYearInAmount) as FBalanceYearInAmount \n");
        sql.append(" FROM " + tempTableOfSoureData);
        sql.append(" Where FIsHistoryData = 0 \n");
        sql.append(" GROUP BY FPeriodId, FCostCenterID, FCostObjectID, FCostItemID \n");
        sql.append("\n;");
        sql.append(" INSERT INTO " + tblPreTreatData + "(");
        sql.append(" FPeriodId,FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" FBegProQty, FBegProAmount, \n");
        sql.append(" FCurInQty, FCurInAmount, FCurCompQty, FCurCompAmount, \n");
        sql.append(" FEndProQty, FEndProAmount, FMakeSum, \n");
        sql.append(" FBalanceYearCompQty, FBalanceYearCompAmount, FBalanceYearInAmount,FIsHistoryData) \n");
        sql.append(" SELECT FPeriodId, FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" max(FBegProQty) as FBegProQty, \n");
        sql.append(" max(FBegProAmount) as FBegProAmount, \n");
        sql.append(" 0 as FCurInQty, \n");
        sql.append(" 0 as FCurInAmount, \n");
        sql.append(" max(FCurCompQty) as FCurCompQty, \n");
        sql.append(" max(FCurCompAmount) as FCurCompAmount, \n");
        sql.append(" max(FEndProQty) as FEndProQty, \n");
        sql.append(" max(FEndProAmount) as FEndProAmount, \n");
        sql.append(" max(FCurCompAmount)+max(FEndProAmount) as FMakeSum, \n");
        sql.append(" max(FBalanceYearCompQty) as FBalanceYearCompQty, \n");
        sql.append(" max(FBalanceYearCompAmount) as FBalanceYearCompAmount, \n");
        sql.append(" max(FBalanceYearInAmount) as FBalanceYearInAmount,3 \n");
        sql.append(" FROM " + tempTableOfSoureData);
        sql.append(" Where FIsHistoryData = 2 \n");
        sql.append(" GROUP BY FPeriodId, FCostCenterID, FCostObjectID, FCostItemID \n");
        sql.append("\n;");
        sql.append(" INSERT INTO " + tblPreTreatData + "(");
        sql.append(" FPeriodId,FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" FBegProQty, FBegProAmount, \n");
        sql.append(" FCurInQty, FCurInAmount, FCurCompQty, FCurCompAmount, \n");
        sql.append(" FEndProQty, FEndProAmount, FMakeSum, \n");
        sql.append(" FBalanceYearCompQty, FBalanceYearCompAmount, FBalanceYearInAmount,FIsHistoryData) \n");
        sql.append(" SELECT FPeriodId, FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" 0 as FBegProQty, \n");
        sql.append(" 0 as FBegProAmount, \n");
        sql.append(" 0 as FCurInQty, \n");
        sql.append(" 0 as FCurInAmount, \n");
        sql.append(" 0 as FCurCompQty, \n");
        sql.append(" 0 as FCurCompAmount, \n");
        sql.append(" 0 as FEndProQty, \n");
        sql.append(" 0 as FEndProAmount, \n");
        sql.append(" 0 as FMakeSum, \n");
        sql.append(" sum(FBalanceYearCompQty) as FBalanceYearCompQty, \n");
        sql.append(" Sum(FBalanceYearCompAmount) as FBalanceYearCompAmount, \n");
        sql.append(" Sum(FBalanceYearInAmount) as FBalanceYearInAmount, \n");
        sql.append(" 1 as FIsHistorydata \n");
        sql.append(" FROM " + tempTableOfSoureData);
        sql.append(" Where FIsHistoryData = 1 \n");
        sql.append(" GROUP BY FPeriodId, FCostCenterID, FCostObjectID, FCostItemID \n");
        sql.append("\n;");
        sql.append(" update " + tblPreTreatData + " \n");
        sql.append(" set FIsHistoryData = 1 \n");
        sql.append(" where FIsHistoryData = 2 \n");
        sql.append("\n;");
        sql.append(" delete from " + tblPreTreatData + " \n");
        sql.append(" where FPeriodId in (" + preiodIds + ") \n");
        sql.append("   and FBegProQty=0 and FBegProAmount=0 and FCurInQty=0 and FCurInAmount=0 \n");
        sql.append("   and FCurCompQty=0 and FCurCompAmount=0 and FEndProQty=0 and FEndProAmount=0 and FisHistoryData = 0 \n");
        sql.append("   and FAdjBopWipQty = 0 and FAdjBopWipAmount = 0 \n\n;");
        return sql;
    }

    private void preTreatReportDataYearSum(Context ctx, String[][] periodIds, List periodDataState, String companyId) throws BOSException, EASBizException, SQLException {
        ArrayList<String> preTreatPeriodIdList = new ArrayList<String>();
        String tempTableOfYearSum = null;
        try {
            StringBuffer preTreatYearSumSql = new StringBuffer();
            for (int i = 0; i < periodDataState.size(); ++i) {
                String[] ov = (String[])periodDataState.get(i);
                if (Integer.valueOf(ov[3]) != 0) continue;
                String periodId = ov[0];
                preTreatPeriodIdList.add(periodId);
                if (tempTableOfYearSum == null) {
                    tempTableOfYearSum = this.createTempTableBySql(ctx, this.getTempTableOfYearSum(), "FCostCenterID, FCostObjectID, FCostItemID");
                }
                preTreatYearSumSql.append(this.preTreatReportDataForYearSum(ctx, companyId, periodId, periodIds, tempTableOfYearSum));
            }
            if (preTreatYearSumSql.length() > 0) {
                NCMServerUtils.BatchSqlExecute((Context)ctx, (String)preTreatYearSumSql.toString());
            }
        }
        catch (BOSException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            if (tempTableOfYearSum != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableOfYearSum);
            }
        }
    }

    protected StringBuffer getTempTableOfYearSum() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempTableOfYearSum ( ");
        createTable.append("FCostCenterID varchar(44) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FYearSumCompQty  decimal(21,8) default(0) ");
        createTable.append(",FYearSumCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearSumInQty  decimal(21,8) default(0) ");
        createTable.append(",FYearSumInAmount  decimal(21,8) default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    private StringBuffer preTreatReportDataForYearSum(Context ctx, String companyId, String periodId, String[][] periodIds, String tempTableOfYearSum) throws BOSException {
        String yearSumPeriodFilter = this.getYearSumPeriodFilter(periodId, periodIds);
        StringBuffer selectPeriodYearSumSql = this.getSelectPeriodYearSumSql(tempTableOfYearSum, yearSumPeriodFilter, periodId);
        return selectPeriodYearSumSql;
    }

    private String getYearSumPeriodFilter(String periodId, String[][] periodIds) {
        List periodIdList = this.getYearSumPeriodIdList(periodId, periodIds);
        StringBuffer sb = this.getIdsInFromIdList(periodIdList);
        return sb.toString();
    }

    private List getYearSumPeriodIdList(String periodId, String[][] periodIds) {
        int periodIdIndex;
        ArrayList<String> periodIdList = new ArrayList<String>();
        for (periodIdIndex = 0; periodIdIndex < periodIds.length && !periodId.equals(periodIds[periodIdIndex][0]); ++periodIdIndex) {
        }
        String[] periodInfos = periodIds[periodIdIndex];
        for (int i = 0; i <= periodIdIndex; ++i) {
            if (!periodInfos[2].equals(periodIds[i][2]) || periodInfos[1].compareTo(periodIds[i][1]) < 0) continue;
            periodIdList.add(periodIds[i][0]);
        }
        return periodIdList;
    }

    private StringBuffer getSelectPeriodYearSumSql(String tempTableOfYearSum, String yearSumPeriodFilter, String periodId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM " + tempTableOfYearSum + " \n\n;");
        sql.append(" INSERT INTO " + tempTableOfYearSum + "(");
        sql.append(" FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" FYearSumCompQty, FYearSumCompAmount, FYearSumInQty, FYearSumInAmount) \n");
        sql.append(" SELECT FCostCenterID,FCostObjectID,FCostItemID, \n");
        sql.append(" Sum(FCurCompQty) as FYearSumCompQty, \n");
        sql.append(" Sum(FCurCompAmount)  as FYearSumCompAmount, \n");
        sql.append(" Sum(FCurInQty) as FYearSumInQty, \n");
        sql.append(" Sum(FCurInAmount) as FYearSumInAmount \n");
        sql.append(" FROM " + this.tblPreTreatData);
        sql.append(" WHERE FPeriodId in (").append(yearSumPeriodFilter).append(") \n");
        sql.append("  and FCostItemID is not null \n");
        sql.append("  and (FIsHistoryData = 0 or FIsHistoryData = 3)");
        sql.append(" GROUP BY FCostCenterID, FCostObjectID, FCostItemID \n");
        sql.append("\n;");
        sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
        sql.append("SET (FYearSumCompQty, FYearSumCompAmount, FYearSumInQty, FYearSumInAmount)= \n");
        sql.append("( \n");
        sql.append("Select S.FYearSumCompQty, S.FYearSumCompAmount, S.FYearSumInQty, S.FYearSumInAmount \n");
        sql.append("  FROM ").append(tempTableOfYearSum).append(" S \n");
        sql.append(" WHERE S.FCostCenterID=D.FCostCenterID \n");
        sql.append("   AND S.FCostObjectID=D.FCostObjectID \n");
        sql.append("   AND S.FCostItemID=D.FCostItemID \n");
        sql.append("   AND D.FCostItemID is not null \n");
        sql.append(") \n");
        sql.append("WHERE D.FPeriodId='").append(periodId).append("'\n");
        sql.append("  AND D.FCostItemID is not null \n");
        sql.append("\n;");
        sql.append(" DELETE FROM " + tempTableOfYearSum + " \n\n;");
        sql.append(" INSERT INTO " + tempTableOfYearSum + "(");
        sql.append(" FCostCenterID,FCostObjectID, \n");
        sql.append(" FYearSumCompQty, FYearSumCompAmount, FYearSumInQty, FYearSumInAmount) \n");
        sql.append(" SELECT FCostCenterID,FCostObjectID, \n");
        sql.append(" Sum(FCurCompQty) as FYearSumCompQty, \n");
        sql.append(" Sum(FCurCompAmount)  as FYearSumCompAmount, \n");
        sql.append(" Sum(FCurInQty) as FYearSumInQty, \n");
        sql.append(" Sum(FCurInAmount) as FYearSumInAmount \n");
        sql.append(" FROM " + this.tblPreTreatData);
        sql.append(" WHERE FPeriodId in (").append(yearSumPeriodFilter).append(") \n");
        sql.append("   AND FCostItemID is null \n");
        sql.append(" and (FIsHistoryData = 0 or FIsHistoryData = 3)");
        sql.append(" GROUP BY FCostCenterID, FCostObjectID \n");
        sql.append("\n;");
        sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
        sql.append("SET (FYearSumCompQty, FYearSumCompAmount, FYearSumInQty, FYearSumInAmount)= \n");
        sql.append("( \n");
        sql.append("Select S.FYearSumCompQty, S.FYearSumCompAmount, S.FYearSumInQty, S.FYearSumInAmount \n");
        sql.append("  FROM ").append(tempTableOfYearSum).append(" S \n");
        sql.append(" WHERE S.FCostCenterID=D.FCostCenterID \n");
        sql.append("   AND S.FCostObjectID=D.FCostObjectID \n");
        sql.append("   AND D.FCostItemID is null \n");
        sql.append(") \n");
        sql.append("WHERE D.FPeriodId='").append(periodId).append("' \n");
        sql.append("  AND D.FCostItemID is null \n");
        sql.append(" and (FIsHistoryData = 0 or FIsHistoryData = 3)");
        sql.append("\n;");
        sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
        sql.append("SET FYearSumCompQty = FBalanceYearCompQty,  FYearSumCompAmount = FBalanceYearCompAmount,FBegProQty = 0,FBegProAmount= 0 \n");
        sql.append("WHERE D.FPeriodId='").append(periodId).append("' \n");
        sql.append(" and FIsHistoryData = 1");
        sql.append("\n;");
        sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
        sql.append("SET FBegProQty = 0,FBegProAmount= 0,FIsHistoryData = 0\n");
        sql.append("WHERE D.FPeriodId='").append(periodId).append("' \n");
        sql.append(" and FIsHistoryData = 3");
        sql.append("\n;");
        sql.append("UPDATE ").append(this.tblPreTreatData).append(" AS D \n");
        sql.append("SET  FYearSumInQty = (\n");
        sql.append("select data.FCurInQty from (\n");
        sql.append(" Select sum(isnull(S.FCurInQty,0)) as FCurInQty , FCostCenterID,FCostObjectID,FCostItemID \n");
        sql.append("  FROM ").append(this.tblPreTreatData).append(" S \n");
        sql.append(" group by S.FCostCenterID,S.FCostObjectID,S.FCostItemID ) as Data");
        sql.append(" WHERE data.FCostCenterID=D.FCostCenterID \n");
        sql.append("   AND data.FCostObjectID=D.FCostObjectID and data.FCostItemID is null) \n");
        sql.append("WHERE D.FPeriodId='").append(periodId).append("' \n");
        sql.append("  AND D.FCostItemID is null \n");
        sql.append(" and FIsHistoryData = 1");
        sql.append("\n;");
        return sql;
    }

    private StringBuffer getIdsInFromIdList(List preTreatPeriodIdList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < preTreatPeriodIdList.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'").append(preTreatPeriodIdList.get(i)).append("'");
        }
        return sb;
    }

    private String createTempTableBySql(Context ctx, StringBuffer tempTblSql, String index) throws BOSException {
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(tempTblSql.toString());
            if (index != null && index.length() > 0) {
                TempTablePool.getInstance((Context)ctx).createIndex(tempTable, index, false, false);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }
}

