/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.app.CostCalReportPreTreatMent;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostCalTotalDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CostCalTotalDetailReport");
    private String tempTableNameSum = new String();

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        Object[] ss = this.preTreatDataTblAndFilter(filter);
        String tblPreTreatData = (String)ss[0];
        StringBuffer filterContent = (StringBuffer)ss[1];
        String companyId = (String)ss[2];
        this.filterCostObjectInThisPage(filterContent, filter);
        this.tempTableNameSum = this.getTempTableNameSum(filter);
        Locale locale = this.getContext().getLocale();
        StringBuffer sqlAll = new StringBuffer();
        sqlAll.append(this.insertDataToTableSum(tblPreTreatData, this.tempTableNameSum, filterContent, companyId, locale, filter));
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        sqlAll.setLength(0);
        String ksql = "select max(FPeriodNumber) FNumber from " + this.tempTableNameSum;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        String maxPeriod = "";
        try {
            if (rs.next()) {
                maxPeriod = rs.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sqlAll.append(this.makeDataSumBySelect(this.tempTableNameSum, filter, locale, companyId, maxPeriod));
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        sqlAll.delete(0, sqlAll.length());
        return this.tempTableNameSum;
    }

    private Object[] preTreatDataTblAndFilter(RptParams filter) throws BOSException {
        String tblPreTreatData = null;
        StringBuffer filterContent = null;
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        String companyId = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        boolean isYearSum = false;
        if (filter.getObject("isYearSum") != null) {
            isYearSum = (Boolean)filter.getObject("isYearSum");
        }
        if (isYearSum) {
            CostCalReportPreTreatMent test = new CostCalReportPreTreatMent(this.getContext(), periodFromStr, periodToStr, companyId, isYearSum);
            tblPreTreatData = test.getTblPreTreatData();
            filterContent = this.buildFilter(filter, test.getPeriodIdInFilter());
        } else {
            try {
                tblPreTreatData = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalResult", (int)Integer.valueOf(periodFromStr), (int)Integer.valueOf(periodToStr));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            filterContent = this.buildFilter(filter, this.getPeriodIDsList(filter).toString());
        }
        return new Object[]{tblPreTreatData, filterContent, companyId};
    }

    private void filterCostObjectInThisPage(StringBuffer filterContent, RptParams filter) {
        HashMap objMap = (HashMap)filter.getObject("position");
        String filterObject = (String)objMap.get("costobjectid");
        if (filterObject != null && filterObject.length() > 0) {
            filterContent.append(" and co.FID in (" + filterObject + ") \n");
        }
    }

    private String getTempTableNameSum(RptParams filter) throws BOSException {
        String tempTableSum = null;
        StringBuffer createTableSum = this.getTempTableSum(filter);
        try {
            tempTableSum = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSum.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableSum;
    }

    private StringBuffer getTempTableSum(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append(" FPeriodID varchar(44), ");
        createTable.append(" FPeriodName varchar(50) default(' ') ");
        createTable.append(",FPeriodNumber varchar(255) default(' ') ");
        createTable.append(",FCostCenterID varchar(44) default(' ') ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44)  default(' ') ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FOrderNumber varchar(255) default('') ");
        createTable.append(",FProjectNumber varchar(255) default('') ");
        createTable.append(",FTrackNumber varchar(255) default('') ");
        createTable.append(",FMaterialNumber varchar(255) default('') ");
        createTable.append(",FMaterialName varchar(255) default('') ");
        createTable.append(",FOrderID varchar(255) default(' ') ");
        createTable.append(",FBatchID varchar(255) default(' ') ");
        createTable.append(",FProjectID varchar(255) default(' ') ");
        createTable.append(",FTrackID varchar(255) default(' ') ");
        createTable.append(",FMaterialID varchar(255) default(' ') ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FBatchNumber nvarchar(255) default(' ')");
        createTable.append(",FUnitName varchar(255) default(' ') ");
        createTable.append(",FModel nvarchar(255) default(' ') ");
        createTable.append(",FShortName nvarchar(80) default(' ') ");
        createTable.append(",FCostItemID varchar(44) default(' ')");
        createTable.append(",FCostItemNumber varchar(255) default(' ')");
        createTable.append(",FCostItemName varchar(255) default(' ')");
        createTable.append(",FCostItemType varchar(255) default(' ')");
        createTable.append(",FBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBefAdjBopWipQty decimal(21,8) default(0) ");
        createTable.append(",FAdjBopWipQty decimal(21,8) default(0) ");
        createTable.append(",FBegProAmount decimal(21,8)  default(0) ");
        createTable.append(",FBefAdjBoPWipAmount decimal(21,8)  default(0) ");
        createTable.append(",FAdjBoPWipAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FBefAdjEoPWipQty  decimal(21,8) default(0) ");
        createTable.append(",FAdjEoPWipQty  decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FBefAdjEoPWipAmount  decimal(21,8) default(0) ");
        createTable.append(",FAdjEoPWipAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInQty   decimal(21,8) default(0) ");
        createTable.append(",FYearInAmount   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(28,10) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearCompPrice  decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FUnitPriceDecimal int default(0) ");
        createTable.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalOrderRow int not null default(0) ");
        createTable.append(" ,FTotalBatchRow int not null default(0) ");
        createTable.append(" ,FTotalProjectRow int not null default(0) ");
        createTable.append(" ,FTotalTrackRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialRow int not null default(0) ");
        createTable.append(" ,FIsHistoryData int not null default(0) ");
        if (this.isShowStatUnit(filter)) {
            createTable.append(",FStatUnitName varchar(255) default(' ') ");
            createTable.append(",FStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FBefAdjStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FAdjStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FStatCurInQty  decimal(21,8) default(0) ");
            createTable.append(",FStatCurCompQty  decimal(21,8) default(0) ");
            createTable.append(",FStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FBefAdjStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FAdjStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FStatYearInQty   decimal(21,8) default(0) ");
            createTable.append(",FStatYearCompQty  decimal(28,10) default(0) ");
            createTable.append(",FStatCurUnitPrice   decimal(21,8) default(0) ");
            createTable.append(",FStatYearCompPrice  decimal(21,8) default(0) ");
            createTable.append(",FStatQtyDecimal int default(0) ");
        }
        createTable.append(" ) ");
        return createTable;
    }

    private StringBuffer insertDataToTableSum(String tempTableNameMain, String tempTableNameSum, StringBuffer filterContent, String companyId, Locale locale, RptParams filter) throws BOSException {
        boolean isYearSum = false;
        if (filter.getObject("isYearSum") != null) {
            isYearSum = (Boolean)filter.getObject("isYearSum");
        }
        String initbalance = null;
        String initbalanceEntry = null;
        String tblAllDataByCostObj = null;
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        String tblInputQty = null;
        if (!isYearSum) {
            try {
                initbalance = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_Balance", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
                initbalanceEntry = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_BalanceEntry", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
                tblAllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_AllDataByCostObj", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
                StringBuffer ksql = new StringBuffer();
                ksql.append("create table T ( \n");
                ksql.append("    FCalculatePeriodId varchar(44), \n");
                ksql.append("    FCostCenterID varchar(44), \n");
                ksql.append("    FCostObjectID varchar(44), \n");
                ksql.append("    FQty NUMERIC(21,8) \n");
                ksql.append(") \n");
                tblInputQty = NCMDbUtil.createTempTableByPool((TempTablePool)TempTablePool.getInstance((Context)this.getContext()), (String)ksql.toString());
                ksql.setLength(0);
                ksql.append("insert /*+ append*/ into ").append(tblInputQty).append(" (FCalculatePeriodId,FCostCenterID,FCostObjectID,FQty) \n");
                ksql.append("select p.fid,inBill.FCOSTCENTERORGUNITID,inEntry.FCostObjectID,sum(FQty) from T_NCM_InputQtyBill inBill \n");
                ksql.append(" left join T_NCM_InputQtyBillEntry inEntry on inEntry.FParentID = inBill.FID \n");
                ksql.append(" left join T_BD_Period p on inBill.FCALCULATEPERIOD = p.FID \n");
                ksql.append(" where inBill.FCompanyOrg = '" + companyId + "' and p.FNumber >= " + periodFromStr + " and p.FNumber <= " + periodToStr);
                ksql.append(" and inBill.FBillStatus = 4");
                ksql.append(" group by p.fid,inBill.FCOSTCENTERORGUNITID,inEntry.FCostObjectID \n");
                NCMDbUtil.execute((Context)this.getContext(), (String)ksql.toString());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        if (isYearSum) {
            sql.append(" INSERT /*+ append*/ INTO " + tempTableNameSum + "( \n");
            sql.append(" FPeriodID,FPeriodName,FPeriodNumber, \n");
            sql.append(" FCostCenterID, FCostCenterNumber, FCostCenterName, \n");
            sql.append(" FCostObjectID, FCostObjectNumber, FCostObjectName,  FOrderNumber,\n");
            sql.append(" FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName, \n");
            sql.append(" FOrderID,FBatchID,FProjectID,FTrackID,FMaterialID, \n");
            sql.append(" FCostItemID, FCostItemNumber, FCostItemName, FCostItemType, \n");
            sql.append(" FBegProQty, FBegProAmount, \n");
            sql.append(" FBefAdjBopWipQty, FBefAdjBoPWipAmount, \n");
            sql.append(" FAdjBopWipQty, FAdjBoPWipAmount, \n");
            sql.append(" FCurInQty, FCurInAmount, \n");
            sql.append(" FCurCompQty, FCurAllAmount, \n");
            sql.append(" FEndProQty, FEndProAmount, \n");
            sql.append(" FBefAdjEoPWipQty, FBefAdjEoPWipAmount, \n");
            sql.append(" FAdjEoPWipQty, FAdjEoPWipAmount, \n");
            sql.append(" FYearCompQty, FYearCompAmount, \n");
            sql.append(" FYearInQty, FYearInAmount, \n");
            sql.append(" FMakeSum, FTotalRow, FIsHistoryData, \n");
            sql.append(" FIsTotalRow) \n");
            sql.append(" SELECT perTreatData.FPeriodId FPeriodID,(LTRIM(TO_CHAR(period.FPeriodYear)) || '.' || RIGHT(('0' || TO_CHAR(period.FPeriodNumber)), 2)) as FPeriodName,TO_CHAR(period.FNumber), \n");
            sql.append(" perTreatData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  \n");
            sql.append(" perTreatData.FCostObjectID, co.FNumber,  co.FName_" + locale + ", co.FOrderNumber,  \n");
            sql.append(" po.FNumber,tr.FNumber,mat.FNumber,mat.FName_" + locale + ", \n");
            sql.append(" co.FOrderID,co.FBatchNumber,co.FProjectID,co.FTrackID,co.FStdProductIDID, \n");
            sql.append(" perTreatData.FCostItemID, ci.FNumber, ci.FName_" + locale + ", ci.FItemType, \n");
            sql.append(" FBegProQty, FBegProAmount, \n");
            sql.append(" isnull(FBegProQty,0)-isnull(FAdjBopWipQty,0) as FBefAdjBopWipQty, \n");
            sql.append(" isnull(FBegProAmount,0)-isnull(FAdjBoPWipAmount,0) as FBefAdjBoPWipAmount, \n");
            sql.append(" FAdjBopWipQty, FAdjBoPWipAmount, \n");
            sql.append(" FCurInQty, FCurInAmount, \n");
            sql.append(" FCurCompQty, FCurCompAmount as FCurAllAmount, \n");
            sql.append(" FEndProQty, FEndProAmount, \n");
            sql.append(" isnull(FEndProQty,0)-isnull(FAdjEoPWipQty,0) as FBefAdjEoPWipQty, \n");
            sql.append(" isnull(FEndProAmount,0)-isnull(FAdjEoPWipAmount,0) as FBefAdjEoPWipAmount, \n");
            sql.append(" FAdjEoPWipQty, FAdjEoPWipAmount, \n");
            sql.append(" FYearSumCompQty, FYearSumCompAmount, \n");
            sql.append(" FYearSumInQty, FYearSumInAmount, \n");
            sql.append(" FMakeSum, 0 ,FIsHistoryData, \n");
            sql.append(" 0 AS FIsTotalRow \n");
            sql.append(" FROM " + tempTableNameMain + " perTreatData \n");
            sql.append(" inner join t_bd_period period on perTreatData.FPeriodId = period.FID \n");
            sql.append(" inner join T_ORG_CostCenter cc on perTreatData.FCostCenterID = cc.FID  \n");
            sql.append(" inner join T_BD_CostObject co on perTreatData.FCostObjectID = co.FID \n");
            sql.append(" left join t_mm_project po on po.FID = co.FProjectID \n");
            sql.append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
            sql.append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
            sql.append(" left outer join T_NCM_CostItem ci on perTreatData.FCostItemID = ci.FID \n ");
            sql.append(" where co.FCompanyID = '" + companyId + "'" + filterContent);
            if (isYearSum) {
                sql.append(" and (perTreatData.FIsHistoryData = 0 or perTreatData.FIsHistoryData = 1)");
            } else {
                sql.append(" and  perTreatData.FIsHistoryData = 0 ");
            }
        } else {
            sql.append(" INSERT /*+ append*/ INTO " + tempTableNameSum + "( \n");
            sql.append(" FPeriodID,FPeriodName,FPeriodNumber, \n");
            sql.append(" FCostCenterID, FCostCenterNumber, FCostCenterName, \n");
            sql.append(" FCostObjectID, FCostObjectNumber, FCostObjectName,  FOrderNumber,\n");
            sql.append(" FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName, \n");
            sql.append(" FOrderID,FBatchID,FProjectID,FTrackID,FMaterialID, \n");
            sql.append(" FCostItemID, FCostItemNumber, FCostItemName, FCostItemType, \n");
            sql.append(" FBegProQty, FBegProAmount, \n");
            sql.append(" FBefAdjBopWipQty, FBefAdjBoPWipAmount, \n");
            sql.append(" FAdjBopWipQty, FAdjBoPWipAmount, \n");
            sql.append(" FCurInQty, FCurInAmount, \n");
            sql.append(" FCurCompQty, FCurAllAmount, \n");
            sql.append(" FEndProQty, FEndProAmount, \n");
            sql.append(" FBefAdjEoPWipQty, FBefAdjEoPWipAmount, \n");
            sql.append(" FAdjEoPWipQty, FAdjEoPWipAmount, \n");
            sql.append(" FMakeSum, \n");
            sql.append(" FIsTotalRow) \n");
            sql.append(" SELECT hourData.FCalculatePeriodId FPeriodID,(LTRIM(TO_CHAR(period.FPeriodYear)) || '.' || RIGHT(('0' || TO_CHAR(period.FPeriodNumber)), 2)) as FPeriodName,TO_CHAR(period.FNumber), \n");
            sql.append(" hourData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  \n");
            sql.append(" hourData.FCostObjectID, co.FNumber,  co.FName_" + locale + ", co.FOrderNumber,  \n");
            sql.append(" po.FNumber,tr.FNumber,mat.FNumber,mat.FName_" + locale + ", \n");
            sql.append(" co.FOrderID,co.FBatchNumber,co.FProjectID,co.FTrackID,co.FStdProductIDID, \n");
            sql.append(" perTreatData.FCostItemID, ci.FNumber, ci.FName_" + locale + ", ci.FItemType, \n");
            sql.append(" isnull(balaData.FBegProQty,0), isnull(balaData.FBopWipAmount,0), \n");
            sql.append(" isnull(balaData.FBegProQty,0)-isnull(balaData.FAjdBegProQty,0) as FBefAdjBoPWipQty, \n");
            sql.append(" isnull(balaData.FBopWipAmount,0) - isnull(balaData.FAdjBoPWipAmount,0) as  FBefAdjBoPWipAmount, \n");
            sql.append(" isnull(balaData.FAjdBegProQty,0), isnull(balaData.FAdjBoPWipAmount,0), \n");
            sql.append(" isnull(inBill.FQty,0) FCurInQty, \n");
            sql.append(" isnull(FFinishedAmount,0) + isnull(FEopWipAmount,0)-isnull(FAdjEoPWipAmount,0) - isnull(balaData.FBopWipAmount,0) FCurInAmount, \n");
            sql.append(" isnull(hourData.FFinishedQty,0), isnull(FFinishedAmount,0) as FCurAllAmount, \n");
            sql.append(" isnull(hourData.FEopWipQty,0), isnull(FEopWipAmount,0), \n");
            sql.append(" isnull(hourData.FEopWipQty,0)-isnull(hourData.FAdjEopWipQty,0) as FBefAdjEopWipQty, \n");
            sql.append(" isnull(FEopWipAmount,0)-isnull(FAdjEoPWipAmount,0) as FBefAdjEoPWipAmount, \n");
            sql.append(" isnull(hourData.FAdjEopWipQty,0), isnull(FAdjEoPWipAmount,0), \n");
            sql.append(" isnull(FEopWipAmount,0)- isnull(FAdjEopWipAmount,0) + isnull(FFinishedAmount,0) FMakeSum, \n");
            sql.append(" 0 AS FIsTotalRow \n");
            sql.append(" FROM " + tblAllDataByCostObj + " hourData \n");
            sql.append(" left outer join " + tempTableNameMain + " perTreatData \n");
            sql.append("      on hourData.FCostCenterID = perTreatData.FCostCenterID \n");
            sql.append("      and hourData.FCostObjectID = perTreatData.FCostObjectID \n");
            sql.append("      and hourData.FCalculatePeriodID = perTreatData.FCalculatePeriodId \n");
            sql.append(" left join ( select bala.FCalculatePeriodID FCalculatePeriodID,bala.FCostCenterID FCostCenterID,bala.FCostObjectID FCostObjectID,");
            sql.append("                    bala.FBopWIPQty FBegProQty, bala.FAdjBopWipQty FAjdBegProQty,\n");
            sql.append("                    balaEntry.FCostItemID FCostItemID,balaEntry.FBopWipQty FBopWipQty, balaEntry.FBopWipAmount FBopWipAmount, \n");
            sql.append("                    balaEntry.FAdjBoPWipAmount FAdjBoPWipAmount \n");
            sql.append("               from " + initbalance + " bala  \n");
            sql.append("                    inner join " + initbalanceEntry + " balaEntry on balaEntry.fParentID = bala.FID \n");
            sql.append("               where bala.FCalculatePeriodID in (" + this.getPeriodIDsList(filter).toString() + ") \n");
            sql.append("  ) balaData on balaData.FCalculatePeriodID = perTreatData.FCalculatePeriodID \n");
            sql.append("                and balaData.FCostCenterID = perTreatData.FCostCenterID \n");
            sql.append("                and balaData.FCostObjectID = perTreatData.FCostObjectID \n");
            sql.append("                And balaData.FCostItemID = perTreatData.FCostItemID \n");
            sql.append(" inner join t_bd_period period on hourData.FCalculatePeriodId = period.FID \n");
            sql.append(" inner join T_ORG_CostCenter cc on hourData.FCostCenterID = cc.FID  \n");
            sql.append(" inner join T_BD_CostObject co on hourData.FCostObjectID = co.FID \n");
            sql.append(" left join t_mm_project po on po.FID = co.FProjectID \n");
            sql.append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
            sql.append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
            sql.append(" left outer join T_NCM_CostItem ci on perTreatData.FCostItemID = ci.FID \n ");
            sql.append(" left join ").append(tblInputQty).append(" inBill \n");
            sql.append("                                             on inBill.FCostCenterID = perTreatData.FCostCenterID \n");
            sql.append("                                            and inBill.FCostObjectID = perTreatData.FCostObjectID \n");
            sql.append("                                            and inBill.FCalculatePeriodID = perTreatData.FCalculatePeriodId \n");
            sql.append(" where co.FCompanyID = '" + companyId + "'" + filterContent + this.buildFilter(filter, this.getPeriodIDsList(filter).toString()));
        }
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer makeDataSumBySelect(String tempTableNameSum, RptParams filter, Locale locale, String companyID, String maxPeriod) throws BOSException {
        Context ctx = this.getContext();
        int dbTypeCode = (Integer)ctx.get((Object)"dbTypeCode");
        StringBuffer sql = new StringBuffer();
        boolean isYearSum = false;
        if (filter.getObject("isYearSum") != null) {
            isYearSum = (Boolean)filter.getObject("isYearSum");
        }
        String baseCurrencySql = "select baseCurrency.FPrecision from T_ORG_Company company inner join T_BD_Currency baseCurrency on baseCurrency.FId = company.FBaseCurrencyId where company.FId = ?";
        int baseCurrencyPrecision = 2;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)baseCurrencySql, (Object[])new Object[]{companyID});
        try {
            if (iRowSet.next()) {
                baseCurrencyPrecision = iRowSet.getInt("FPrecision");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String tblAllDataByCostObj = null;
        String initbalance = null;
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        try {
            tblAllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_AllDataByCostObj", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
            initbalance = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_Balance", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (this.isShowStatUnit(filter)) {
            sql.append(" update " + tempTableNameSum + " as t \n");
            sql.append("set (FStatBegProQty, \n");
            sql.append("     FBefAdjStatBegProQty, \n");
            sql.append("     FAdjStatBegProQty, \n");
            sql.append("     FStatCurInQty, \n");
            sql.append("     FStatCurCompQty, \n");
            sql.append("     FStatEndProQty, \n");
            sql.append("     FBefAdjStatEndProQty, \n");
            sql.append("     FAdjStatEndProQty, \n");
            sql.append("     FStatYearInQty, \n");
            sql.append("     FStatYearCompQty) = ( \n");
            sql.append("select(case when mmu.FBaseConvsRate = 0 then FBegProQty else FBegProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FBefAdjBopWipQty else FBefAdjBopWipQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FAdjBopWipQty else FAdjBopWipQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FCurInQty else FCurInQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FCurCompQty else FCurCompQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FEndProQty else FEndProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FBefAdjEoPWipQty else FBefAdjEoPWipQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FAdjEoPWipQty else FAdjEoPWipQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FYearInQty else FYearInQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FYearCompQty else FYearCompQty / mmu.FBaseConvsRate end) \n");
            sql.append("from T_BD_CostObject co \n");
            sql.append("join T_BD_Material m \n");
            sql.append("    on m.FID = co.FStdProductIDID \n");
            sql.append("join T_BD_MultiMeasureUnit as mmu \n");
            sql.append("    on mmu.FMaterialID = m.FID and mmu.FIsStatUnit = 1 \n");
            sql.append("where co.FID = t.FCostObjectID \n");
            sql.append(") \n");
            sql.append("where t.FCostObjectID is not null \n");
            sql.append("\n\n;");
        }
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("insertby");
            fields = fields.replaceAll("FPeriodName", "FPeriodNumber,FPeriodName");
            sql.append(" INSERT  /*+ append*/ INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FBegProQty, FBegProAmount, \n");
            sql.append(" FBefAdjBopWipQty, FBefAdjBoPWipAmount, \n");
            sql.append(" FAdjBopWipQty, FAdjBoPWipAmount, \n");
            sql.append(" FCurInQty, FCurInAmount, \n");
            sql.append(" FCurCompQty, FCurAllAmount, \n");
            sql.append(" FEndProQty, FEndProAmount, \n");
            sql.append(" FBefAdjEoPWipQty,FBefAdjEoPWipAmount, \n");
            sql.append(" FAdjEoPWipQty,FAdjEoPWipAmount, \n");
            sql.append(" FYearCompQty, FYearCompAmount, \n");
            sql.append(" FYearInQty, FYearInAmount, \n");
            if (this.isShowStatUnit(filter)) {
                sql.append(" FStatBegProQty,FStatCurInQty, FStatCurCompQty, FStatEndProQty, FStatYearCompQty, FStatYearInQty,\n");
                sql.append("FBefAdjStatBegProQty,FAdjStatBegProQty, FBefAdjStatEndProQty,FAdjStatEndProQty,\n");
            }
            sql.append(" FMakeSum) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FBegProQty) as FBegProQty, Sum(FBegProAmount) as FBegProAmount, \n");
            sql.append(" Sum(FBefAdjBopWipQty) as FBefAdjBopWipQty, sum(FBefAdjBoPWipAmount) as FBefAdjBoPWipAmount, \n");
            sql.append(" sum(FAdjBopWipQty) as FAdjBopWipQty, sum(FAdjBoPWipAmount) as FAdjBopWipQty, \n");
            sql.append(" Sum(FCurInQty) as FCurInQty, Sum(FCurInAmount) as FCurInAmount, \n");
            sql.append(" Sum(FCurCompQty) as FCurCompQty, Sum(FCurAllAmount) as FCurAllAmount, \n");
            sql.append(" Sum(FEndProQty) as FEndProQty, Sum(FEndProAmount) as FEndProAmount, \n");
            sql.append(" Sum(FBefAdjEoPWipQty) as FBefAdjEoPWipQty,Sum(FBefAdjEoPWipAmount) as FBefAdjEoPWipAmount, \n");
            sql.append(" Sum(FAdjEoPWipQty) as FAdjEoPWipQty,Sum(FAdjEoPWipAmount) as FAdjEoPWipAmount, \n");
            sql.append(" Sum(FYearCompQty) as FYearCompQty, Sum(FYearCompAmount) as FYearCompAmount, \n");
            sql.append(" Sum(FYearInQty) as FYearInQty, Sum(FYearInAmount) as FYearInAmount, \n");
            if (this.isShowStatUnit(filter)) {
                sql.append(" Sum(FStatBegProQty) as FStatBegProQty, \n");
                sql.append(" Sum(FStatCurInQty) as FStatCurInQty, \n");
                sql.append(" Sum(FStatCurCompQty) as FStatCurCompQty, \n");
                sql.append(" Sum(FStatEndProQty) as FStatEndProQty, \n");
                sql.append(" Sum(FStatYearCompQty) as FStatYearCompQty, \n");
                sql.append(" Sum(FStatYearInQty) as FStatYearInQty, \n");
                sql.append(" Sum(FBefAdjStatBegProQty) as FBefAdjStatBegProQty, \n");
                sql.append(" Sum(FAdjStatBegProQty) as FAdjStatBegProQty, \n");
                sql.append(" Sum(FBefAdjStatEndProQty) as FBefAdjStatEndProQty, \n");
                sql.append(" Sum(FAdjStatEndProQty) as FAdjStatEndProQty, \n");
            }
            sql.append(" Sum(FMakeSum) as FMakeSum \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" WHERE FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
        }
        sql.append(" INSERT /*+ append*/ INTO " + tempTableNameSum + "( \n");
        sql.append(" FTotalRow2,FTotalRow, \n");
        sql.append(" FBegProQty, FBegProAmount,FBefAdjBoPWipAmount,FAdjBoPWipAmount, \n");
        sql.append(" FCurInQty, FCurInAmount, \n");
        sql.append(" FCurCompQty, FCurAllAmount, \n");
        sql.append(" FEndProQty, FEndProAmount, FBefAdjEoPWipAmount,FAdjEoPWipAmount, \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" FStatBegProQty,FStatCurInQty, FStatCurCompQty, FStatEndProQty, \n");
            sql.append(" FBefAdjStatBegProQty, FAdjStatBegProQty,FBefAdjStatEndProQty, FAdjStatEndProQty, \n");
        }
        sql.append(" FMakeSum) \n");
        sql.append(" SELECT 1,105,");
        sql.append(" Sum(FBegProQty) as FBegProQty, \n");
        sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
        sql.append(" sum(FBefAdjBoPWipAmount) as FBefAdjBoPWipAmount, \n");
        sql.append(" sum(FAdjBoPWipAmount) as FAdjBoPWipAmount, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurInAmount) as FCurInAmount, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" sum(FBefAdjEoPWipAmount) as FBefAdjEoPWipAmount, \n");
        sql.append(" sum(FAdjEoPWipAmount) as FAdjEoPWipAmount, \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" Sum(FStatBegProQty) as FStatBegProQty, \n");
            sql.append(" Sum(FStatCurInQty) as FStatCurInQty, \n");
            sql.append(" Sum(FStatCurCompQty) as FStatCurCompQty, \n");
            sql.append(" Sum(FStatEndProQty) as FStatEndProQty, \n");
            sql.append(" Sum(FBefAdjStatBegProQty) as FBefAdjStatBegProQty, \n");
            sql.append(" Sum(FAdjStatBegProQty) as FAdjStatBegProQty, \n");
            sql.append(" Sum(FBefAdjStatEndProQty) as FBefAdjStatEndProQty, \n");
            sql.append(" Sum(FAdjStatEndProQty) as FAdjStatEndProQty, \n");
        }
        sql.append(" Sum(FMakeSum) as FMakeSum \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        if (dbTypeCode == 5) {
            sql.append("/*dialect*/");
        }
        sql.append("update ").append(tempTableNameSum).append("\r\n").append("set (FYearInQty, FYearInAmount, FYearCompQty, FYearCompAmount) = \r\n").append("(select T.FYearInQty, T.FYearInAmount, T.FYearCompQty, T.FYearCompAmount from \r\n").append("(select sum(FYearInQty) FYearInQty, sum(FYearInAmount) FYearInAmount, sum(FYearCompQty) FYearCompQty, sum(FYearCompAmount) FYearCompAmount\r\n").append("from ").append(tempTableNameSum).append("\r\n").append("where FTotalRow = 0 and FPeriodNumber = '").append(maxPeriod).append("' ) T \r\n").append(") where FTotalRow2 = 1;\r\n");
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        String totalFieldNumber = orderStrings[0];
        sql.append("Update ");
        sql.append(tempTableNameSum);
        sql.append(" set ");
        sql.append(totalFieldNumber);
        sql.append(" = '");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()));
        sql.append("'  where Ftotalrow2 = 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET (FBegProQty, FBefAdjBopWipQty, FAdjBopWipQty, FCurInQty, FCurCompQty, FEndProQty, FBefAdjEoPWipQty, FAdjEoPWipQty, FYearInQty, FYearCompQty \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(",FStatBegProQty, FStatCurInQty, FStatCurCompQty, FStatEndProQty, FStatYearInQty, FStatYearCompQty,");
            sql.append(" FBefAdjStatBegProQty, FAdjStatBegProQty, FBefAdjStatEndProQty, FAdjStatEndProQty \n");
        }
        sql.append(") = ( \n");
        sql.append(" SELECT T1.FBegProQty, T1.FBefAdjBopWipQty, T1.FAdjBopWipQty, T1.FCurInQty, T1.FCurCompQty, T1.FEndProQty, \n");
        sql.append(" T1.FBefAdjEoPWipQty,T1.FAdjEoPWipQty, T1.FYearInQty, T1.FYearCompQty \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" ,T1.FStatBegProQty, T1.FStatCurInQty, T1.FStatCurCompQty, T1.FStatEndProQty, T1.FStatYearInQty, T1.FStatYearCompQty \n");
            sql.append(" ,T1.FBefAdjStatBegProQty,T1.FAdjStatBegProQty,T1.FBefAdjStatEndProQty,T1.FAdjStatEndProQty \n");
        }
        sql.append("   FROM (SELECT distinct (CASE WHEN FPeriodName is null then ' ' else FPeriodName end) as FPeriodName, \n");
        sql.append("                (CASE WHEN FCostCenterID is null then ' ' else FCostCenterID end) as FCostCenterID, \n");
        sql.append("                (CASE WHEN FCostObjectID is null then ' ' else FCostObjectID end) as FCostObjectID, \n");
        sql.append("                (CASE WHEN FOrderID is null then ' ' else FOrderID end) as FOrderID, \n");
        sql.append("                (CASE WHEN FBatchID is null then ' ' else FBatchID end) as FBatchID, \n");
        sql.append("                (CASE WHEN FProjectID is null then ' ' else FProjectID end) as FProjectID, \n");
        sql.append("                (CASE WHEN FTrackID is null then ' ' else FTrackID end) as FTrackID, \n");
        sql.append("                (CASE WHEN FMaterialID is null then ' ' else FMaterialID end) as FMaterialID, \n");
        sql.append("                sum(FBegProQty) AS FBegProQty, Sum(FBefAdjBopWipQty) as FBefAdjBopWipQty, \n");
        sql.append("                sum(FAdjBopWipQty) as FAdjBopWipQty, sum(FCurInQty) AS FCurInQty, \n");
        sql.append("                sum(FCurCompQty) AS FCurCompQty, sum(FEndProQty) AS FEndProQty, \n");
        sql.append("                sum(FBefAdjEoPWipQty) AS FBefAdjEoPWipQty,sum(FAdjEoPWipQty) AS FAdjEoPWipQty, \n");
        sql.append("                SUM(FYearInQty) AS FYearInQty, SUM(FYearCompQty) AS FYearCompQty \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("                ,sum(FStatBegProQty) AS FStatBegProQty, sum(FStatCurInQty) AS FStatCurInQty, \n");
            sql.append("                sum(FStatCurCompQty) AS FStatCurCompQty, sum(FStatEndProQty) AS FStatEndProQty, \n");
            sql.append("                SUM(FStatYearInQty) AS FStatYearInQty, SUM(FStatYearCompQty) AS FStatYearCompQty, \n");
            sql.append("                SUM(FBefAdjStatBegProQty) AS FBefAdjStatBegProQty, SUM(FAdjStatBegProQty) AS FAdjStatBegProQty, \n");
            sql.append("                SUM(FBefAdjStatEndProQty) AS FBefAdjStatEndProQty, SUM(FAdjStatEndProQty) AS FAdjStatEndProQty \n");
        }
        sql.append("           FROM ( \n");
        sql.append("                  select distinct rpdata.FPeriodName,rpdata.FCostCenterID, rpdata.FCostObjectID, rpdata.FOrderID, rpdata.FBatchID, rpdata.FProjectID, rpdata.FTrackID, rpdata.FMaterialID, \n");
        sql.append("                         isnull(initdata.FBopWipQty,0) FBEGPROQTY, isnull(initdata.FBopWipQty,0) - isnull(initdata.FAdjBopWipQty,0) FBefAdjBopWipQty, isnull(initdata.FAdjBopWipQty,0) FAdjBopWipQty, isnull(rpdata.FCurInQty,0) FCurInQty, isnull(codata.FFinishedQty,0) as FCurCompQty, isnull(codata.FEopWipQty,0) FEndProQty,FBefAdjEoPWipQty,isnull(codata.FAdjEopWipQty,0) FAdjEoPWipQty, FYearInQty, FYearCompQty, FTotalRow \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("                 ,(case when mmu.FBaseConvsRate = 0 then isnull(initdata.FBopWipQty,0) else isnull(initdata.FBopWipQty,0) / mmu.FBaseConvsRate end) FStatBegProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(initdata.FBopWipQty,0) - isnull(initdata.FAdjBopWipQty,0) else (isnull(initdata.FBopWipQty,0) - isnull(initdata.FAdjBopWipQty,0)) / mmu.FBaseConvsRate end) FBefAdjStatBegProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(initdata.FAdjBopWipQty,0) else isnull(initdata.FAdjBopWipQty,0) / mmu.FBaseConvsRate end) FAdjStatBegProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(rpdata.FCurInQty,0) else isnull(rpdata.FCurInQty,0) / mmu.FBaseConvsRate end) FStatCurInQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(codata.FFinishedQty,0) else isnull(codata.FFinishedQty,0) / mmu.FBaseConvsRate end) FStatCurCompQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(codata.FEopWipQty,0) else isnull(codata.FEopWipQty,0) / mmu.FBaseConvsRate end) FStatEndProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then FBefAdjEoPWipQty else FBefAdjEoPWipQty / mmu.FBaseConvsRate end) FBefAdjStatEndProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then isnull(codata.FAdjEopWipQty,0) else isnull(codata.FAdjEopWipQty,0) / mmu.FBaseConvsRate end) FAdjStatEndProQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then FYearInQty else FYearInQty / mmu.FBaseConvsRate end) FStatYearInQty, \n");
            sql.append("                 (case when mmu.FBaseConvsRate = 0 then FYearCompQty else FYearCompQty / mmu.FBaseConvsRate end) FStatYearCompQty \n");
        }
        sql.append("                  from " + tempTableNameSum + " rpdata \n");
        sql.append("                  left join " + tblAllDataByCostObj + " codata on rpdata.FPeriodID = codata.FCalculatePeriodID and rpdata.FCostCenterID = codata.FCostCenterID and rpdata.FCostObjectID = codata.FCostObjectID \n");
        sql.append("                  left join " + initbalance + " initdata on rpdata.FPeriodID = initdata.FCalculatePeriodID and rpdata.FCostCenterID = initdata.FCostCenterID and rpdata.FCostObjectID = initdata.FCostObjectID \n");
        sql.append("                  left join T_BD_MultiMeasureUnit as mmu on mmu.FMaterialID = rpdata.FMaterialID and mmu.FIsStatUnit = 1\n");
        if (isYearSum) {
            sql.append("                  where rpdata.FCostItemID is null \n");
        }
        sql.append("                  ) as Data \n");
        sql.append("          WHERE FTotalRow = 0  \n");
        sql.append("          GROUP BY FPeriodName,FCostCenterID,FCostObjectID,FOrderID,FBatchID,FProjectID,FTrackID,FMaterialID with rollup ) T1 \n");
        sql.append("  WHERE T1.FPeriodName = " + tempTableNameSum + ".FPeriodName \n");
        sql.append("    AND T1.FCostCenterID = " + tempTableNameSum + ".FCostCenterID \n");
        sql.append("    AND T1.FCostObjectID = " + tempTableNameSum + ".FCostObjectID \n");
        sql.append("    AND T1.FOrderID = " + tempTableNameSum + ".FOrderID \n");
        sql.append("    AND T1.FBatchID = " + tempTableNameSum + ".FBatchID \n");
        sql.append("    AND T1.FProjectID = " + tempTableNameSum + ".FProjectID \n");
        sql.append("    AND T1.FTrackID = " + tempTableNameSum + ".FTrackID \n");
        sql.append("    AND T1.FMaterialID = " + tempTableNameSum + ".FMaterialID \n");
        sql.append(" )");
        sql.append("\n\n;");
        sql.append(" DELETE from " + tempTableNameSum + " \n");
        sql.append("    WHERE FCOSTITEMID is null and FTOTALROW= 0 ");
        sql.append("      and exists (select 1 from " + tempTableNameSum + " data2 \n");
        sql.append("                  where " + tempTableNameSum + ".FPeriodNumber = data2.FPeriodNumber \n");
        sql.append("                    and " + tempTableNameSum + ".FCostCenterID = data2.FCostCenterID \n");
        sql.append("                    and " + tempTableNameSum + ".FCostObjectID = data2.FCostObjectID \n");
        sql.append("                    and exists (select fid from t_ncm_costitem ci where data2.FcostItemID = ci.fid) ) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + locale + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID \n");
        sql.append("   and (" + tempTableNameSum + ".FCostCenterNumber is null \n");
        sql.append("    or " + tempTableNameSum + ".FCostCenterNumber=' ')) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append(" FROM T_BD_CostObject T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID \n ");
        sql.append("   and (" + tempTableNameSum + ".FCostObjectNumber is null \n");
        sql.append("    or " + tempTableNameSum + ".FCostObjectNumber=' ')) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FMaterialNumber,FMaterialName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append(" FROM T_BD_Material T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FMaterialID =T2.FID \n ");
        sql.append("   and (" + tempTableNameSum + ".FMaterialNumber is null \n");
        sql.append("    or " + tempTableNameSum + ".FMaterialNumber=' ')) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostItemNumber) = \n");
        sql.append(" ( SELECT T2.FNumber \n");
        sql.append(" FROM T_NCM_CostItem T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostItemID =T2.FID \n ");
        sql.append("   and (" + tempTableNameSum + ".FCostItemNumber is null \n");
        sql.append("    or " + tempTableNameSum + ".FCostItemNumber=' ')) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (\n");
        sql.append(" FBatchNumber,FUnitName,FModel,FShortName \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" ,FStatUnitName");
        }
        sql.append(" ) = ( \n");
        sql.append(" SELECT T2.FBatchNumber,T4.FName_" + locale + ",T3.FModel,T3.FShortName \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" ,smu.FName_" + locale + " \n");
        }
        sql.append("   FROM T_BD_CostObject T2 \n");
        sql.append("  INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n");
        sql.append("  INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("       left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = T3.FID and mmu.FIsStatUnit = 1 ");
            sql.append("       left outer join T_BD_MeasureUnit smu on smu.FID = mmu.FMeasureUnitID \n");
        }
        sql.append("  WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        StringBuffer updateField = new StringBuffer("FQtyDecimal, FUnitPriceDecimal, FPriceDecimal ");
        if (this.isShowStatUnit(filter)) {
            updateField.append(", FStatQtyDecimal");
        }
        StringBuffer selectField = new StringBuffer("MAX(baseUnit.FqtyPrecision) FQtyDecimal, MAX(material.FPricePrecision) FUnitPriceDecimal, ").append(baseCurrencyPrecision).append(" FPriceDecimal");
        if (this.isShowStatUnit(filter)) {
            selectField.append(", MAX(statUnit.FqtyPrecision) FStatQtyDecimal");
        }
        if (dbTypeCode == 5) {
            sql.append("/*dialect*/");
        }
        sql.append("update ").append(tempTableNameSum).append("\r\n").append("set (").append(updateField).append(") = \r\n").append("(select ").append(updateField).append(" from \r\n").append("(select costObject.FId fid,").append(selectField).append(" \r\n").append("from T_BD_CostObject costObject\r\n").append("left join T_BD_Material material on material.FId = costObject.FStdProductIDId\r\n").append("left join T_BD_MultiMeasureUnit baseUnit on baseUnit.FMeasureUnitID = material.FBaseUnit and baseUnit.FMaterialId = material.FId\r\n");
        if (this.isShowStatUnit(filter)) {
            sql.append("left join T_BD_MultiMeasureUnit statUnit on statUnit.FIsStatUnit = 1 and statUnit.FMaterialId = material.FId\r\n");
        }
        sql.append(" group by costObject.FId) T\r\n");
        sql.append(" where ").append(tempTableNameSum).append(".FCostObjectId = T.FId);\r\n");
        sql.append("update ").append(tempTableNameSum).append("\r\n");
        sql.append("set FUnitPriceDecimal = null ,FPriceDecimal = ").append(baseCurrencyPrecision).append(" \r\n");
        if (this.isShowStatUnit(filter)) {
            sql.append(",FStatQtyDecimal = (select MAX(FStatQtyDecimal) from ").append(tempTableNameSum).append(") \r\n");
        }
        sql.append("where fcostobjectid =' '; \r\n");
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FOrderID")) {
                whichTotal = ", FTotalOrderRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchID")) {
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProjectID")) {
                whichTotal = ", FTotalProjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FTrackID")) {
                whichTotal = ", FTotalTrackRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialID")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            if (field.equals("FPeriodName")) {
                sql.append(" update " + tempTableNameSum + " set " + fieldNumber + " = " + fieldNumber + "|| ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n");
                sql.append(" FTotalPeriodrow = 1 \n");
            } else if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID")) {
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                sql.append(" update " + tempTableNameSum + " set " + fieldNumber + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                sql.append(whichTotal);
            } else {
                fieldName = field.substring(0, field.length() - 2) + "Name";
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                sql.append(" update " + tempTableNameSum + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n" + fieldNumber + " = " + fieldNumber + "\n");
                sql.append(whichTotal);
            }
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" DELETE " + tempTableNameSum + " \n");
        sql.append("  WHERE FTOTALROW > 0 \n");
        sql.append("    AND (FCostCenterNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' OR \n");
        sql.append("         FCostObjectNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' OR \n");
        sql.append("         FCostItemNumber = '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "') ");
        sql.append("\n\n;");
        sql.append(" DELETE " + tempTableNameSum + " \n");
        sql.append("  WHERE FTOTALROW > 0 \n");
        sql.append("    AND (\n");
        sql.append("         (FMaterialName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FMaterialNumber is null OR FMaterialNumber = '')) OR \n");
        sql.append("         (FOrderNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FOrderID is null OR FOrderID = '')) OR \n ");
        sql.append("         (FProjectNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FProjectID is null OR FProjectID = '')) OR \n ");
        sql.append("         (FBatchNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FBatchID is null OR FBatchID = '')) OR \n ");
        sql.append("         (FTrackNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FTrackID is null OR FTrackID = '')) )\n ");
        sql.append("    AND FTotalRow2 != 3 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("     ,FStatQtyDecimal= (SELECT MAX(FStatQtyDecimal) FROM " + tempTableNameSum + ") \n");
        }
        sql.append(" Where FTotalRow2 = 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " data1 \n");
        sql.append(" SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + " data2 Where data1.FCostCenterID = data2.FCostCenterID ) \n");
        sql.append(" Where FTotalCostCenterRow = 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " data1 \n");
        sql.append(" SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + " data2 Where data1.FPeriodNumber = data2.FPeriodNumber ) \n");
        sql.append(" Where FTotalPeriodRow = 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FYearCompPrice= ( \n");
        sql.append("      CASE WHEN FYearCompQty<>0 THEN to_decimal(FYearCompAmount,24,12)/to_decimal(FYearCompQty,24,12) ELSE 0 END), \n");
        sql.append("     FCurUnitPrice= ( \n");
        sql.append("      CASE WHEN FCurCompQty<>0 THEN to_decimal(FCurAllAmount,24,12)/to_decimal(FCurCompQty,24,12) ELSE 0 END) ");
        if (this.isShowStatUnit(filter)) {
            sql.append(" , FStatCurUnitPrice= ( \n");
            sql.append("      CASE WHEN FStatCurCompQty<>0 THEN to_decimal(FCurAllAmount,24,12)/to_decimal(FStatCurCompQty,24,12) ELSE 0 END) ");
            sql.append(", FStatYearCompPrice = ( \n");
            sql.append("  CASE WHEN FStatYearCompQty <> 0 THEN ");
            sql.append("      to_decimal(FYearCompAmount,24,12)/to_decimal(FStatYearCompQty,24,12) \n");
            sql.append("  ELSE 0 END \n");
            sql.append("  )");
        }
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + "\n");
        sql.append(" SET FBegProQty = NULL, FBefAdjBopWipQty = NULL, FAdjBopWipQty = NULL, FCurInQty = NULL, FCurCompQty = NULL, FEndProQty=NULL, FYearInQty=NULL, FYearCompQty=NULL, FBefAdjEoPWipQty = NULL,FAdjEoPWipQty = NULL \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(",FStatBegProQty = NULL, FStatCurInQty = NULL, FStatCurCompQty = NULL, FStatEndProQty=NULL, FStatYearInQty=NULL, ");
            sql.append("FStatYearCompQty=NULL,FBefAdjStatBegProQty = NULL,FAdjStatBegProQty = NULL,FBefAdjStatEndProQty = NULL,FAdjStatEndProQty = NULL \n");
        }
        sql.append(" WHERE FTotalRow=0 \n");
        sql.append("\n\n;");
        sql.append(" DELETE from " + tempTableNameSum + " \n");
        sql.append(" where FCOSTITEMID is null and FTotalCostItemRow = 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FCurUnitPrice = ROUND(FCurUnitPrice,FUnitPriceDecimal) \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("    ,FStatCurUnitPrice = ROUND(FStatCurUnitPrice,FUnitPriceDecimal) \n");
        }
        sql.append("\n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        StringBuffer setFieldSql = new StringBuffer();
        StringBuffer setFieldSelectSql = new StringBuffer();
        setFieldSql.append("FBegProQty, FBefAdjBopWipQty, FAdjBopWipQty, FCurInQty, FCurCompQty, FEndProQty, FBefAdjEoPWipQty, FAdjEoPWipQty");
        if (this.isShowStatUnit(filter)) {
            setFieldSql.append(", FStatBegProQty, FStatCurInQty, FStatCurCompQty, FStatEndProQty, FBefAdjStatBegProQty, FAdjStatBegProQty, ").append("FBefAdjStatEndProQty, FAdjStatEndProQty ");
        }
        setFieldSelectSql.append("SUM(data2.FBegProQty) FBegProQty, SUM(data2.FBefAdjBopWipQty) FBefAdjBopWipQty, SUM(data2.FAdjBopWipQty) FAdjBopWipQty, sum(data2.FCurInQty) FCurInQty").append(", sum(data2.FCurCompQty) FCurCompQty, sum(data2.FEndProQty) FEndProQty, sum(data2.FBefAdjEoPWipQty) FBefAdjEoPWipQty, sum(data2.FAdjEoPWipQty) FAdjEoPWipQty");
        if (this.isShowStatUnit(filter)) {
            setFieldSelectSql.append(", sum(data2.FStatBegProQty) FStatBegProQty, sum(data2.FStatCurInQty) FStatCurInQty, sum(data2.FStatCurCompQty) FStatCurCompQty, ").append("sum(data2.FStatEndProQty) FStatEndProQty, sum(data2.FBefAdjStatBegProQty) FBefAdjStatBegProQty, ").append("sum(data2.FAdjStatBegProQty) FAdjStatBegProQty, sum(data2.FBefAdjStatEndProQty) FBefAdjStatEndProQty, sum(data2.FAdjStatEndProQty) FAdjStatEndProQty ");
        }
        if (dbTypeCode == 5) {
            sql.append("/*dialect*/");
        }
        sql.append("update ").append(tempTableNameSum).append(" data1 set (\r\n").append(setFieldSql).append("\r\n").append(") = ").append("(select ").append(setFieldSql).append(" from ").append("(select \r\n").append(setFieldSelectSql).append("\r\n").append("from ").append(tempTableNameSum).append(" data2 \r\n").append("where data2.FTotalPeriodRow  = 1 \r\n group by data2.FTotalPeriodRow ) T\r\n").append(") \r\n").append("where data1.FTotalRow2 = 1;\r\n");
        if (dbTypeCode == 5) {
            sql.append("/*dialect*/");
        }
        sql.append(" update " + tempTableNameSum + " data1 set \n");
        sql.append(" FCurUnitPrice \n");
        sql.append(" = ( select  \n");
        sql.append("     FCurUnitPrice from " + tempTableNameSum + " data2 \n");
        sql.append("     where FTotalPeriodRow  = 1  and data1.FPeriodNumber = data2.FPeriodNumber)\n");
        sql.append(" where FTotalRow2 = 1 \n");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer buildFilter(RptParams filter, String periodIdInFilter) {
        StringBuffer sb = new StringBuffer();
        if (periodIdInFilter != null && periodIdInFilter.length() > 0) {
            sb.append(" and period.FID in (" + periodIdInFilter + ") \n");
        }
        if (filter.getString("prmtCostCenterFrom") != null && !"".equals(filter.getString("prmtCostCenterFrom"))) {
            sb.append(" and cc.FNumber >='").append(filter.getString("prmtCostCenterFrom")).append("' \n");
        }
        if (filter.getString("prmtCostCenterTo") != null && !"".equals(filter.getString("prmtCostCenterTo"))) {
            sb.append(" and cc.FNumber <='").append(filter.getString("prmtCostCenterTo")).append("' \n");
        }
        if (filter.getString("prmtCostObjectFrom") != null && !"".equals(filter.getString("prmtCostObjectFrom"))) {
            sb.append(" and co.FNumber >='").append(filter.getString("prmtCostObjectFrom")).append("' \n");
        }
        if (filter.getString("prmtCostObjectTo") != null && !"".equals(filter.getString("prmtCostObjectTo"))) {
            sb.append(" and co.FNumber <='").append(filter.getString("prmtCostObjectTo")).append("' \n");
        }
        if (filter.getString("prmtCostItemFrom") != null && !"".equals(filter.getString("prmtCostItemFrom"))) {
            sb.append(" and ci.FNumber >='").append(filter.getString("prmtCostItemFrom")).append("'");
        }
        if (filter.getString("prmtCostItemTo") != null && !"".equals(filter.getString("prmtCostItemTo"))) {
            sb.append(" and ci.FNumber <='").append(filter.getString("prmtCostItemTo")).append("'");
        }
        if (filter.getString("prmtOrderNumberFrom") != null && !"".equals(filter.getString("prmtOrderNumberFrom"))) {
            sb.append(" and co.FOrderNumber >='").append(filter.getString("prmtOrderNumberFrom")).append("'");
        }
        if (filter.getString("prmtOrderNumberTo") != null && !"".equals(filter.getString("prmtOrderNumberTo"))) {
            sb.append(" and co.FOrderNumber <='").append(filter.getString("prmtOrderNumberTo")).append("'");
        }
        if (filter.getString("txtBatchFrom") != null && !"".equals(filter.getString("txtBatchFrom"))) {
            sb.append(" and co.FBatchNumber >='").append(filter.getString("txtBatchFrom")).append("'");
        }
        if (filter.getString("txtBathcTo") != null && !"".equals(filter.getString("txtBathcTo"))) {
            sb.append(" and co.FBatchNumber <='").append(filter.getString("txtBathcTo")).append("'");
        }
        if (filter.getString("prmtProjectFrom") != null && !"".equals(filter.getString("prmtProjectFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("prmtProjectFrom")).append("'");
        }
        if (filter.getString("prmtProjectTo") != null && !"".equals(filter.getString("prmtProjectTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("prmtProjectTo")).append("'");
        }
        if (filter.getString("prmtTrackFrom") != null && !"".equals(filter.getString("prmtTrackFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("prmtTrackFrom")).append("'");
        }
        if (filter.getString("prmtTrackTo") != null && !"".equals(filter.getString("prmtTrackTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("prmtTrackTo")).append("'");
        }
        if (filter.getString("prmtMaterialFrom") != null && !"".equals(filter.getString("prmtMaterialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("prmtMaterialFrom")).append("'");
        }
        if (filter.getString("prmtMaterialTo") != null && !"".equals(filter.getString("prmtMaterialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("prmtMaterialTo")).append("'");
        }
        return sb;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"36_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"37_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        if (filter.getString("prmtCostCenterFrom") != null || filter.getString("prmtCostCenterTo") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"4_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("prmtCostCenterFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtCostCenterTo")));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"38_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtCostObjectFrom") != null || filter.getString("prmtCostObjectTo") != null) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"8_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("prmtCostObjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtCostObjectTo")));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"39_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtCostItemFrom") != null || filter.getString("prmtCostItemTo") != null) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"12_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("prmtCostItemFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtCostItemTo")));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"40_ByClassCostCalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtOrderNumberFrom") != null || filter.getString("prmtOrderNumberTo") != null) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtOrderNumberFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtOrderNumberTo")));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_OrderNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("txtBatchFrom") != null || filter.getString("txtBathcTo") != null) {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("txtBatchFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("txtBathcTo")));
        } else {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_BatchNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtProjectFrom") != null || filter.getString("prmtProjectTo") != null) {
            titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtProjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtProjectTo")));
        } else {
            titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_ProjectNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtTrackFrom") != null || filter.getString("prmtTrackTo") != null) {
            titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtTrackFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtTrackTo")));
        } else {
            titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_TrackNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtMaterialFrom") != null || filter.getString("prmtMaterialTo") != null) {
            titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtMaterialFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtMaterialTo")));
        } else {
            titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_MaterialAll", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    private boolean isShowBaseUnit(RptParams filter) {
        Object temp = filter.getObject("isShowBaseUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return !this.isShowStatUnit(filter);
    }

    private boolean isShowStatUnit(RptParams filter) {
        Object temp = filter.getObject("isShowStatUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return false;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        String resUrl = "com.kingdee.eas.ncm.cal.report.ReportResource";
        Locale locale = ctx.getLocale();
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        int index = 0;
        for (int i = 0; i < orderStrings.length; ++i) {
            if (orderStrings[i].equalsIgnoreCase("FPeriodName")) {
                reportHeader.addChild("FPeriodName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setWidth(82).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectName")) {
                reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                reportHeader.addChild("FShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
                if (this.isShowBaseUnit(filter)) {
                    reportHeader.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"66_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setWidth(84).setAlign(1).setIndex(index++);
                }
                if (this.isShowStatUnit(filter)) {
                    reportHeader.addChild("FStatUnitName", ResourceBase.getString((String)resUrl, (String)"Common_StatMeasureUnit", (Locale)locale)).setWidth(84).setAlign(1).setIndex(index++);
                }
            }
            if (orderStrings[i].equalsIgnoreCase("FCostItemNumber")) {
                reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostItemName")) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
        }
        ReportHeader bandAmount13 = reportHeader.addChild("QCZTZ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjBopWip", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount13.addChild("FBefAdjBopWipQty", "\u4ea7\u91cf").setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount13.addChild("FBefAdjStatBegProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount13.addChild("FBefAdjBoPWipAmount", "\u6210\u672c").setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount12 = reportHeader.addChild("QCZTZ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjBopWip", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount12.addChild("FAdjBopWipQty", "\u4ea7\u91cf").setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount12.addChild("FAdjStatBegProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount12.addChild("FAdjBoPWipAmount", "\u6210\u672c").setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount1 = reportHeader.addChild("QCZCP", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjBopWip", (Locale)ctx.getLocale()));
        bandAmount1.setVisible(false);
        bandAmount1.setWidth(-1);
        if (this.isShowBaseUnit(filter)) {
            bandAmount1.addChild("FBegProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount1.addChild("FStatBegProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount1.addChild("FBegProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        bandAmount1.setVisible(false);
        for (int i = 0; i < bandAmount1.getChildCount(); ++i) {
            ((ReportHeader)bandAmount1.getChilds().get(i)).setVisible(false);
        }
        ReportHeader bandAmount2 = reportHeader.addChild("BQTR", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"72_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount2.addChild("FCurInQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount2.addChild("FStatCurInQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount2.addChild("FCurInAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        reportHeader.addChild("FMakeSum", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"73_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount3 = reportHeader.addChild("BQWG", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"74_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount3.addChild("FCurCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount3.addChild("FStatCurCompQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount3.addChild("FCurAllAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"75_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        if (this.isShowBaseUnit(filter)) {
            bandAmount3.addChild("FCurUnitPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"16_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount3.addChild("FStatCurUnitPrice", ResourceBase.getString((String)resUrl, (String)"CostCalTotalDetailReport_StatUnitCost", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
        }
        ReportHeader bandAmount43 = reportHeader.addChild("QMZTZQ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjEopWip", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount43.addChild("FBefAdjEopWipQty", "\u4ea7\u91cf").setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount43.addChild("FBefAdjStatEndProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount43.addChild("FBefAdjEoPWipAmount", "\u6210\u672c").setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount42 = reportHeader.addChild("QMZTZ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjEopWip", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount42.addChild("FAdjEopWipQty", "\u4ea7\u91cf").setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount42.addChild("FAdjStatEndProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount42.addChild("FAdjEoPWipAmount", "\u6210\u672c").setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount4 = reportHeader.addChild("BQZC", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjEopWip", (Locale)ctx.getLocale()));
        if (this.isShowBaseUnit(filter)) {
            bandAmount4.addChild("FEndProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        }
        if (this.isShowStatUnit(filter)) {
            bandAmount4.addChild("FStatEndProQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
        }
        bandAmount4.addChild("FEndProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        bandAmount4.setVisible(false);
        for (int i = 0; i < bandAmount4.getChildCount(); ++i) {
            ((ReportHeader)bandAmount4.getChilds().get(i)).setVisible(false);
        }
        boolean isYearSum = (Boolean)filter.getObject("isYearSum");
        if (isYearSum) {
            ReportHeader bandAmount5 = reportHeader.addChild("BQLJTR", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"77_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount5.addChild("FYearInQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"78_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount5.addChild("FStatYearInQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalDetailReport_StatInputQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount5.addChild("FYearInAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"79_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            if (this.isShowBaseUnit(filter)) {
                bandAmount5.addChild("FYearCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"80_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount5.addChild("FStatYearCompQty", ResourceBase.getString((String)resUrl, (String)"Common_StatFinishedQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount5.addChild("FYearCompAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"81_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            if (this.isShowBaseUnit(filter)) {
                bandAmount5.addChild("FYearCompPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"82_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount5.addChild("FStatYearCompPrice", ResourceBase.getString((String)resUrl, (String)"CostCalTotalDetailReport_StatFinishedUnitCost", (Locale)locale)).setAlign(3).setType(2).setWidth(120).setDecimalField("FUnitPriceDecimal");
            }
        }
        return reportHeader;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("insertby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private StringBuffer getSortString(ArrayList list, String sortMode) {
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            Boolean isTotal = (Boolean)map.get("isTotal");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodName") && !isTotal.booleanValue()) {
                fieldNumber = "";
            } else if (field.equalsIgnoreCase("FPeriodName") && isTotal.booleanValue()) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortMode;
                fieldNumber = "FPeriodNumber";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                orderByWhichTotal = ", FTotalOrderRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                orderByWhichTotal = ", FTotalBatchRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                orderByWhichTotal = ", FTotalProjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                orderByWhichTotal = ", FTotalTrackRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                orderByWhichTotal = ", FTotalMaterialRow " + sortMode;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID") || field.equalsIgnoreCase("FMaterialID")) {
                    sbChecked.append(field);
                } else {
                    sbChecked.append(fieldNumber);
                }
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        Object[] ss = this.preTreatDataTblAndFilter(filter);
        String costcalResult = null;
        String tblPreTreatData = null;
        StringBuffer filterContent = (StringBuffer)ss[1];
        String companyId = (String)ss[2];
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        tblPreTreatData = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_AllDataByCostObj", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
        costcalResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalResult", (int)Integer.parseInt(periodFromStr), (int)Integer.parseInt(periodToStr));
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct perTreatData.FCostObjectID,co.FNumber \n");
        sql.append(" FROM " + tblPreTreatData + " perTreatData \n");
        sql.append(" left outer join " + costcalResult + " calRs \n");
        sql.append("      on calRs.FCostCenterID = perTreatData.FCostCenterID \n");
        sql.append("      and calRs.FCostObjectID = perTreatData.FCostObjectID \n");
        sql.append("      and calRs.FCalculatePeriodID = perTreatData.FCalculatePeriodId \n");
        sql.append(" inner join t_bd_period period on perTreatData.FCalCulatePeriodId = period.FID \n");
        sql.append(" inner join T_ORG_CostCenter cc on perTreatData.FCostCenterID = cc.FID  \n");
        sql.append(" inner join T_BD_CostObject co on perTreatData.FCostObjectID = co.FID \n");
        sql.append(" left join t_mm_project po on po.FID = co.FProjectID \n");
        sql.append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
        sql.append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
        sql.append(" left join T_NCM_CostItem ci on calRs.FCostItemID = ci.FID \n ");
        sql.append(" where co.FCompanyID = '" + companyId + "'" + filterContent);
        sql.append(" Order by co.FNumber \n");
        sql.append("\n\n;");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        Integer nObjCountPerPage = Integer.valueOf(filter.getString("costobjectPerPage"));
        if (nObjCountPerPage <= 0 || nObjCountPerPage > 1000) {
            nObjCountPerPage = 20;
        }
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, "costobjectid", "constobjectid", 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            sb.append("'").append(rs.getString("FCostObjectID")).append("',");
            if (i == rs.size() || i % nObjCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString("costobjectid", sb.substring(0, sb.length() - 1).toString());
                drs.insertRow();
                sb = new StringBuffer();
            }
            rs.next();
        }
        if (drs.size() == 0) {
            drs.moveToInsertRow();
            drs.updateString("costobjectid", "'" + BOSUuid.create((String)"39734A77").toString() + "'");
            drs.insertRow();
        }
        return drs;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(SysConstant.BIGZERO) == 0) {
            RptParams params = new RptParams();
            params.setObject("prmtCompanyOrg", totalFilter.getObject("prmtCompanyOrg"));
            ArrayList tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.FALSE);
            tableList.add(member);
            params.setObject("table", tableList);
            params.setObject("costobjectPerPage", (Object)new String("100"));
            String periodNumer = (String)rowData.get("FPERIODNAME");
            String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
            String period = "" + Integer.parseInt(periodNumer.substring(5));
            params.setString("spYearFrom", year);
            params.setString("spYearTo", year);
            params.setString("spPeriodFrom", period);
            params.setString("spPeriodTo", period);
            params.setString("prmtCostCenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("prmtCostCenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("prmtCostObjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("prmtCostObjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            RptParams totalfilter = (RptParams)filter.getObject("totalfilter");
            if (totalfilter.getObject("isShowYearSumIn") != null && totalfilter.getObject("isShowYearSumComp") != null) {
                boolean isYearSum = (Boolean)totalfilter.getObject("isShowYearSumIn") != false || (Boolean)totalfilter.getObject("isShowYearSumComp") != false;
                params.setObject("isYearSum", (Object)new Boolean(isYearSum));
            }
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        ArrayList tableList;
        Context ctx = this.getContext();
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        if ((tableList = (ArrayList)filter.getObject("table")) == null) {
            tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
        }
        String orderBy = this.getSortString(tableList, orderByMode).toString();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " Order by  FTotalRow2 " + orderByMode + "," + orderBy + " ,FTotalRow"), (int)start, (int)rows);
        return rs;
    }

    private boolean isDisplayYearSum(RptParams filter) {
        Object temp = filter.getObject("isDisplayYearSum");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return false;
    }

    private StringBuffer getPeriodIDsList(RptParams filter) throws BOSException {
        StringBuffer periodIDs = new StringBuffer();
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String sql = " SELECT FID, FNumber, FPeriodYear FROM T_BD_Period  WHERE FTypeID ='" + companyInfo.getAccountPeriodType().getId().toString() + "' and FNumber>=" + periodFromStr + " and FNumber <= " + periodToStr + " order by FNumber ";
        IRowSet _Data = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (_Data != null && _Data.size() > 0) {
            try {
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    if (periodFromStr.compareTo(_Data.getString("FNumber")) == 0) {
                        periodIDs.append("'" + _Data.getString("FID") + "'");
                    } else {
                        periodIDs.append(",'" + _Data.getString("FID") + "'");
                    }
                    _Data.next();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return periodIDs;
    }
}

