/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.WIPCountingBillFactory;
import com.kingdee.eas.ncm.cal.report.NCMReportHeader;
import com.kingdee.eas.ncm.cal.report.app.CostCalReportPreTreatMent;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostCalTotalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CostCalTotalReport");
    private String tempTableNameSum = new String();

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        Object[] ss = this.preTreatDataTblAndFilter(filter);
        String tblPreTreatData = (String)ss[0];
        StringBuffer filterContent = (StringBuffer)ss[1];
        String companyId = (String)ss[2];
        Locale locale = this.getContext().getLocale();
        IRowSet rsCostItems = this.getCostItems(companyId, locale, filterContent, tblPreTreatData, filter);
        StringBuffer rowToColumn = this.getRowToColumn(rsCostItems, locale);
        this.tempTableNameSum = this.createTempTableNameSum(rowToColumn, filter);
        this.insertDataToTableSum(tblPreTreatData, this.tempTableNameSum, filterContent, companyId, locale, filter);
        String TmpTbl_rowToCol = this.createTmpTbl_rowToCol(rowToColumn);
        StringBuffer[] rowToColumnForInsert = this.getRowToColumnForInsert(rsCostItems, locale, filter);
        StringBuffer[] rowToColumnForCalc = this.getRowToColumnForCalc(rsCostItems, locale, filter);
        String[] costItemForWhere = this.getCostItemForCalc(rsCostItems, locale);
        StringBuffer rowToColumnForDelete = this.getRowToColumnForDelete(rsCostItems, locale);
        StringBuffer sqlAll = new StringBuffer();
        sqlAll.append(this.dataStyleRowToColumn(tblPreTreatData, this.tempTableNameSum, TmpTbl_rowToCol, rowToColumnForInsert, rowToColumnForCalc, costItemForWhere, rowToColumnForDelete, filter, companyId));
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        sqlAll.setLength(0);
        String ksql = "select max(FPeriodNumber) FNumber from " + this.tempTableNameSum;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        String maxPeriod = "";
        try {
            if (rs.next()) {
                maxPeriod = rs.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer[] rowToColumnWithoutYearSum = this.getRowToColumnWithoutYearSum(rsCostItems, locale);
        StringBuffer[] rowToColumnForSum = this.getRowToColumnForSum(rsCostItems, locale);
        sqlAll.append(this.makeDataSumBySelect(this.tempTableNameSum, rowToColumnWithoutYearSum, rowToColumnForSum, filter, locale, companyId, maxPeriod, ss));
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(TmpTbl_rowToCol);
        return this.tempTableNameSum;
    }

    private void wipAccounting(RptParams filter) throws BOSException {
        try {
            String companyId = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
            if (!StringUtils.isEmpty((String)companyId)) {
                WIPCountingBillFactory.getLocalInstance((Context)this.getContext()).GenSettingData((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg"), NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId), null, null, null);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
    }

    private void insertDataToTableSum(String tempTableNameMain, String tempTableNameSum, StringBuffer filterContent, String companyId, Locale locale, RptParams filter) throws BOSException {
        boolean isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        String tblAllDataByCostObj = null;
        String tblBalance = null;
        String tblBalanceEntry = null;
        String tblBalanceCurr = null;
        String tblBalanceEntryCurr = null;
        String tblCalRestultCurr = null;
        String tblAllDataByCostObjCurr = null;
        String tblInputQty = null;
        try {
            int periodFrom = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            int periodTo = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
            tblAllDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_AllDataByCostObj", (int)periodFrom, (int)periodTo);
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_Balance", (int)periodFrom, (int)periodTo);
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_BalanceEntry", (int)periodFrom, (int)periodTo);
            tblBalanceCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_Balance");
            tblBalanceEntryCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_BalanceEntry");
            tblCalRestultCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalResult");
            tblAllDataByCostObjCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_AllDataByCostObj");
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("    FCalculatePeriodId varchar(44), \n");
            ksql.append("    FCostCenterID varchar(44), \n");
            ksql.append("    FCostObjectID varchar(44), \n");
            ksql.append("    FQty NUMERIC(21,8) \n");
            ksql.append(") \n");
            tblInputQty = NCMDbUtil.createTempTableByPool((TempTablePool)TempTablePool.getInstance((Context)this.getContext()), (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into ").append(tblInputQty).append(" (FCalculatePeriodId,FCostCenterID,FCostObjectID,FQty) \n");
            ksql.append("select p.fid,inBill.FCOSTCENTERORGUNITID,inEntry.FCostObjectID,sum(FQty) from T_NCM_InputQtyBill inBill \n");
            ksql.append(" left join T_NCM_InputQtyBillEntry inEntry on inEntry.FParentID = inBill.FID \n");
            ksql.append(" left join T_BD_Period p on inBill.FCALCULATEPERIOD = p.FID \n");
            ksql.append(" where inBill.FCompanyOrg = '" + companyId + "' and p.FNumber >= " + periodFrom + " and p.FNumber <= " + periodTo);
            ksql.append(" and inBill.FBillStatus = 4");
            ksql.append(" group by p.fid,inBill.FCOSTCENTERORGUNITID,inEntry.FCostObjectID \n");
            NCMDbUtil.execute((Context)this.getContext(), (String)ksql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        if (isYearSum) {
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FPeriodId, FPeriodName,FPeriodNumber, \n");
            sql.append(" FCostCenterID, FCostCenterNumber, FCostCenterName, \n");
            sql.append(" FCostObjectID, FCostObjectNumber, FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName, FCostObjectName, \n");
            sql.append(" FOrderID,FBatchID,FProjectID,FTrackID,FMaterialID, \n");
            sql.append(" FBegProQty,FBopWIPHour, FBegProAmount,\n");
            sql.append(" FAdjBegProQty,FBefAdjBegProQty,FAdjBopWIPHour,FBefAdjBopWIPHour,FAdjBegProAmount,FBefAdjBegProAmount, \n");
            sql.append(" FCurInQty,FInputHour, FCurInAmount, \n");
            sql.append(" FCurCompQty,FFinishHour, FCurAllAmount, \n");
            sql.append(" FEndProQty, FEopWIPHour,FEndProAmount, \n");
            sql.append(" FAdjEndProQty,FBefAdjEndProQty,FAdjEopWIPHour,FBefAdjEopWIPHour,FAdjEndProAmount,FBefAdjEndProAmount, \n");
            sql.append(" FYearCompQty, FYearCompAmount, \n");
            sql.append(" FYearInQty, FYearInAmount, \n");
            sql.append(" FMakeSum, FCurUnitPrice, \n");
            sql.append(" FIsTotalRow,FIsHistoryData) \n");
            sql.append(" SELECT distinct FPeriodId, (LTRIM(TO_CHAR(period.FPeriodYear)) || '.' || RIGHT(('0' || TO_CHAR(period.FPeriodNumber)), 2))  as FPeriodName,TO_CHAR(period.Fnumber), \n");
            sql.append(" perTreatData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  \n");
            sql.append(" perTreatData.FCostObjectID, co.FNumber, \t co.FOrderNumber,co.FBatchNumber,po.FNumber,tr.FNumber,mat.FNumber,mat.FName_" + locale + ", co.FName_" + locale + ",  \n");
            sql.append(" co.FOrderID,co.FBatchNumber,co.FProjectID,co.FTrackID,co.FStdProductIDID, \n");
            sql.append(" Sum(FBegProQty) as FBegProQty, AVG(bal.FBopWIPHour) as FBopWIPHour,Sum(FBegProAmount) as FBegProAmount, \n");
            sql.append(" AVG(isnull(bal.FAdjBopWipQty,0)) as FAdjBegProQty,Sum(isnull(FBegProQty,0)) - AVG(isnull(bal.FAdjBopWipQty,0)) as FBefAdjBegProQty, \n");
            sql.append(" AVG(isnull(bal.FAdjBopWipHour,0)) as FAdjBopWIPHour,AVG(bal.FBopWIPHour)- AVG(isnull(bal.FAdjBopWipHour,0)) as FBefAdjBopWIPHour, \n");
            sql.append(" sum(isnull(perTreatData.FAdjBopWipAmount,0)) as FAdjBegProAmount,sum(isnull(FBegProAmount,0)) - sum(isnull(perTreatData.FAdjBopWipAmount,0)) as FBefAdjBegProAmount, \n");
            sql.append(" Sum(FCurInQty) as FCurInQty, AVG(hourData.FInputHour) as FInputHour,Sum(FCurInAmount) as FCurInAmount, \n");
            sql.append(" Sum(FCurCompQty) as FCurCompQty, AVG(hourData.FFinishedHour) as FFinishHour,Sum(FCurCompAmount)  as FCurAllAmount, \n");
            sql.append(" Sum(FEndProQty) as FEndProQty, AVG(hourData.FEopWIPHour) as FEopWIPHour,Sum(FEndProAmount) as FEndProAmount, \n");
            sql.append(" AVG(isnull(hourData.FAdjEopWipQty,0)) as FAdjEndProQty, sum(isnull(FEndProQty,0)) - AVG(isnull(hourData.FAdjEopWipQty,0)) as FBefAdjEndProQty ,\n");
            sql.append(" AVG(isnull(hourData.FAdjEopWipHour,0)) as FAdjEopWIPHour, AVG(hourData.FEopWIPHour) - AVG(isnull(hourData.FAdjEopWipHour,0)) as FBefAdjEopWIPHour, \n");
            sql.append(" sum(isnull(FAdjEopWipAmount,0)) as FAdjEndProAmount, sum(isnull(FEndProAmount,0)) - sum(isnull(FAdjEopWipAmount,0)) as FBefAdjEndProAmount, \n");
            sql.append(" Sum(FYearSumCompQty) as FYearSumCompQty, Sum(FYearSumCompAmount) as FYearSumCompAmount, \n");
            sql.append(" Sum(FYearSumInQty) as FYearSumInQty, Sum(FYearSumInAmount) as FYearSumInAmount, \n");
            sql.append(" Sum(FMakeSum) as FMakeSum, \n");
            sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurCompAmount),24,12)/  to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice,  \n");
            sql.append(" 0 AS FIsTotalRow, perTreatData.FIsHistoryData \n");
            sql.append(" FROM " + tempTableNameMain + " perTreatData \n");
            sql.append(" inner join t_bd_period period on perTreatData.FPeriodId = period.FID \n");
            sql.append(" inner join T_ORG_CostCenter cc on perTreatData.FCostCenterID = cc.FID  \n");
            sql.append(" inner join T_BD_CostObject co on perTreatData.FCostObjectID = co.FID \n");
            sql.append(" left join t_mm_project po on po.FID = co.FProjectID \n");
            sql.append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
            sql.append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
            sql.append(" left outer join T_NCM_CostItem ci on perTreatData.FCostItemID = ci.FID \n ");
            sql.append(" left outer join " + tblAllDataByCostObj + " hourData \n");
            sql.append("      on hourData.FCostCenterID = cc.FID \n");
            sql.append("      and hourData.FCostObjectID = co.FID \n");
            sql.append("      and hourData.FCalculatePeriodID = period.FID \n");
            sql.append(" left outer join " + tblBalance + " bal \n");
            sql.append("      on bal.FCostCenterID = cc.FID \n");
            sql.append("      and bal.FCostObjectID = co.FID \n");
            sql.append("      and bal.FCalculatePeriodID = period.FID \n");
            sql.append(" where co.FCompanyID = '" + companyId + "'" + filterContent);
            if (isYearSum) {
                sql.append(" and (perTreatData.FIsHistoryData = 0 or perTreatData.FIsHistoryData = 1)");
            } else {
                sql.append(" and  perTreatData.FIsHistoryData = 0 ");
            }
            sql.append(" GROUP BY FPeriodId, period.FPeriodYear,period.FPeriodNumber,  perTreatData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  perTreatData.FCostObjectID, co.FNumber,co.FOrderID, co.FOrderNumber, co.FBatchNumber,co.FProjectID,po.FNumber,co.FTrackID,tr.FNumber,co.FStdProductIDID,mat.FNumber,mat.FName_" + locale + ", co.FName_" + locale + ",period.Fnumber,perTreatData.FIsHistoryData");
            sql.append("\n\n;");
        } else {
            boolean iscal = true;
            try {
                PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
                iscal = AllocatorFacadeFactory.getLocalInstance((Context)this.getContext()).isCalculated(companyId, periodInfo.getId().toString());
                if (!iscal) {
                    HashSet<String> busiTblNames = new HashSet<String>();
                    busiTblNames.add("T_NCM_CostCalResult");
                    busiTblNames.add("T_NCM_AllDataByCostObj");
                    NCMDynamicTableManager.clearIndexsOfBusiTbls((Context)this.getContext(), (String)companyId, busiTblNames);
                    sql.setLength(0);
                    sql.append("Insert Into ").append(tblAllDataByCostObjCurr);
                    sql.append(" (FID,FCompanyID ,FCalculatePeriodID , \n");
                    sql.append(" FCostCenterID ,FCostObjectID ,FBopWIPQty,FInputQty,FFinishedQty,FEopWIPQty, \n");
                    sql.append("FBopWIPHour ,FInputHour ,FFinishedHour,FEopWIPHour,FCoef, \n");
                    sql.append("FAdjEopWipQty, FAdjBoPWipQty, FAdjBopWipHour, FAdjEopWipHour) \n");
                    sql.append(" select newbosid('C4774737'),FCompanyOrg ,FCalculatePeriodID,FcostCenterID,FCostObjectID,FBopWIPQty,0 FInputQty,0 FFinishedQty,0 FEopWIPQty, \n");
                    sql.append("        FBopWIPHour,0 FInputHour,0 FFinishedHour,0 FEopWIPHour,0 FCoef ,\n");
                    sql.append("        0 FAdjEopWipQty, FAdjBopWipQty, FAdjBopWipHour, 0 FAdjEopWipHour \n");
                    sql.append(" from ").append(tblBalanceCurr).append("; \n");
                    sql.append("Insert Into ").append(tblCalRestultCurr);
                    sql.append(" (FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID , \n");
                    sql.append(" FCostObjectID ,FCostItemID ,FAllocStdID , \n");
                    sql.append("FAllocStdData ,FFinishedAmount ,FEoPWIPAmount ,FRecvAmount , \n");
                    sql.append("FFinishedQty , FEoPWIPQty ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty,  \n");
                    sql.append(" FAdjEoPWipQty, FAdjEoPWipAmount) \n");
                    sql.append(" select newbosid('C4774737'),FCompanyOrg ,FCalculatePeriodID,FcostCenterID,\n");
                    sql.append("        FCostObjectID,FCostItemID, null,\n");
                    sql.append("        0 FAllocStdData , 0 FFinishedAmount ,0 FEoPWIPAmount ,0 FRecvAmount , \n");
                    sql.append("        0 FFinishedQty , 0 FEoPWIPQty , 0 FCalcLevel, 0 FFinishedAssistQty,0 FFinishedAddqty,0 FEoPWIPAssistQty,0 FEoPWIPAddqty, \n ");
                    sql.append("        0 FAdjEoPWipQty, 0 FAdjEoPWipAmount \n");
                    sql.append(" from ").append(tblBalanceCurr).append(" bala \n");
                    sql.append(" inner join ").append(tblBalanceEntryCurr).append(" entry on entry.FParentID = bala.fid ;\n");
                    NCMDynamicTableManager.buildIndexsOfBusiTbls((Context)this.getContext(), (String)companyId, busiTblNames);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FPeriodId, FPeriodName,FPeriodNumber, \n");
            sql.append(" FCostCenterID, FCostCenterNumber, FCostCenterName, \n");
            sql.append(" FCostObjectID, FCostObjectNumber, FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName, FCostObjectName, \n");
            sql.append(" FOrderID,FBatchID,FProjectID,FTrackID,FMaterialID, \n");
            sql.append(" FBegProQty,FBopWIPHour, FBegProAmount,\n");
            sql.append(" FAdjBegProQty,FBefAdjBegProQty, FAdjBopWIPHour,FBefAdjBopWIPHour,FAdjBegProAmount, FBefAdjBegProAmount,\n");
            sql.append(" FCurInQty,FInputHour, FCurInAmount, \n");
            sql.append(" FCurCompQty,FFinishHour, FCurAllAmount, \n");
            sql.append(" FEndProQty, FEopWIPHour,FEndProAmount, \n");
            sql.append(" FAdjEndProQty, FBefAdjEndProQty,FAdjEopWIPHour,FBefAdjEopWIPHour,FAdjEndProAmount,FBefAdjEndProAmount,\n");
            sql.append(" FCurUnitPrice,FMakeSum, \n");
            sql.append(" FIsTotalRow) \n");
            sql.append(" SELECT hourData.FCalculatePeriodID, (LTRIM(TO_CHAR(period.FPeriodYear)) || '.' || RIGHT(('0' || TO_CHAR(period.FPeriodNumber)), 2))  as FPeriodName,TO_CHAR(period.Fnumber), \n");
            sql.append(" hourData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  \n");
            sql.append(" hourData.FCostObjectID, co.FNumber, \t co.FOrderNumber,co.FBatchNumber,po.FNumber,tr.FNumber,mat.FNumber,mat.FName_" + locale + ", co.FName_" + locale + ",  \n");
            sql.append(" co.FOrderID,co.FBatchNumber,co.FProjectID,co.FTrackID,co.FStdProductIDID, \n");
            sql.append(" AVG(isnull(hourData.FBopWipQty,0)) as FBegProQty, AVG(bal.FBopWIPHour) as FBopWIPHour,sum(isnull(FBopWipAmount,0)) as FBegProAmount, \n");
            sql.append(" AVG(isnull(bal.FAdjBopWipQty,0)) as FAdjBegProQty, AVG(isnull(bal.FBopWipQty,0)) - AVG(isnull(bal.FAdjBopWipQty,0)) as FBefAdjBegProQty, \n");
            sql.append(" max(isnull(bal.FAdjBopWipHour,0)) as FAdjBopWIPHour, AVG(bal.FBopWIPHour) - AVG(isnull(bal.FAdjBopWipHour,0)) as FBefAdjBopWIPHour, \n");
            sql.append(" Sum(isnull(balaData.FAdjBoPWipAmount,0)) as FAdjBegProAmount, sum(isnull(FBopWipAmount,0)) - Sum(isnull(balaData.FAdjBoPWipAmount,0)) as FBefAdjBegProAmount, \n");
            sql.append(" AVG(isnull(inBill.FQty,0)) as FCurInQty,  AVG(hourData.FInputHour) as FInputHour,\n sum(isnull(FFinishedAmount,0)) + sum(isnull(FEopWipAmount,0)) - sum(isnull(FAdjEoPWipAmount,0)) - sum(isnull(FBopWipAmount,0))  as FCurInAmount, \n");
            sql.append(" AVG(isnull(hourData.FFinishedQty,0)) as FCurCompQty, AVG(hourData.FFinishedHour) as FFinishHour,sum(isnull(FFinishedAmount,0))  as FCurAllAmount, \n");
            sql.append(" AVG(isnull(hourData.FEopWipQty,0)) as FEndProQty, AVG(hourData.FEopWIPHour) as FEopWIPHour,sum(FEopWipAmount) as FEndProAmount, \n");
            sql.append(" AVG(isnull(hourData.FAdjEopWipQty,0)) as FAdjEndProQty,AVG(isnull(hourData.FEopWipQty,0)) - AVG(isnull(hourData.FAdjEopWipQty,0)) as FBefAdjEndProQty, \n");
            sql.append(" AVG(isnull(hourData.FAdjEopWipHour,0)) as FAdjEopWIPHour,AVG(hourData.FEopWIPHour) - AVG(isnull(hourData.FAdjEopWipHour,0)) as FBefAdjEopWIPHour, \n");
            sql.append(" sum(isnull(FAdjEoPWipAmount,0)) as FAdjEndProAmount,sum(isnull(FEopWipAmount,0)) - sum(isnull(FAdjEoPWipAmount,0)) as FBefAdjEndProAmount, \n");
            sql.append(" (CASE WHEN AVG(hourData.FFinishedQty)<>0 THEN  to_decimal(sum(FFinishedAmount),24,12)/  to_decimal(AVG(hourData.FFinishedQty),24,12) ELSE 0 END) as FCurUnitPrice,  \n");
            sql.append(" sum(isnull(FFinishedAmount,0)) + sum(isnull(FEopWipAmount,0)) - sum(isnull(FAdjEoPWipAmount,0)) as FMakeSum, \n");
            sql.append(" 0 AS FIsTotalRow \n");
            sql.append(" FROM " + tblAllDataByCostObj + " hourData \n");
            sql.append(" left outer join " + tempTableNameMain + " perTreatData \n");
            sql.append("      on hourData.FCostCenterID = perTreatData.FCostCenterID \n");
            sql.append("      and hourData.FCostObjectID = perTreatData.FCostObjectID \n");
            sql.append("      and hourData.FCalculatePeriodID = perTreatData.FCalculatePeriodId \n");
            sql.append(" inner join t_bd_period period on hourData.FCalculatePeriodId = period.FID \n");
            sql.append(" inner join T_ORG_CostCenter cc on hourData.FCostCenterID = cc.FID  \n");
            sql.append(" inner join T_BD_CostObject co on hourData.FCostObjectID = co.FID \n");
            sql.append(" left join t_mm_project po on po.FID = co.FProjectID \n");
            sql.append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
            sql.append(" left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
            sql.append(" left outer join T_NCM_CostItem ci on perTreatData.FCostItemID = ci.FID \n ");
            sql.append(" left join ( select bala.FCalculatePeriodID FCalculatePeriodID,bala.FCostCenterID FCostCenterID,bala.FCostObjectID FCostObjectID,");
            sql.append("                    balaEntry.FCostItemID FCostItemID,balaEntry.FBopWipQty FBopWipQty, balaEntry.FBopWipAmount FBopWipAmount,  \n");
            sql.append("                    FBopWIPHour,balaEntry.FAdjBoPWipAmount FAdjBoPWipAmount,FAdjBopWipHour,bala.FAdjBopWipQty FAdjBopWipQty \n");
            sql.append("               from " + tblBalance + " bala  \n");
            sql.append("                    inner join " + tblBalanceEntry + " balaEntry on balaEntry.fParentID = bala.FID \n");
            sql.append("               where bala.FCalculatePeriodID in (" + this.getPeriodIDsList(filter).toString() + ") \n");
            sql.append("  ) balaData on balaData.FCalculatePeriodID = perTreatData.FCalculatePeriodID \n");
            sql.append("                and balaData.FCostCenterID = perTreatData.FCostCenterID \n");
            sql.append("                and balaData.FCostObjectID = perTreatData.FCostObjectID \n");
            sql.append("                And balaData.FCostItemID = perTreatData.FCostItemID \n");
            sql.append(" left outer join " + tblBalance + " bal \n");
            sql.append("      on bal.FCostCenterID = cc.FID \n");
            sql.append("      and bal.FCostObjectID = co.FID \n");
            sql.append("      and bal.FCalculatePeriodID = period.FID \n");
            sql.append(" left join " + tblInputQty + " inBill on inBill.FCostCenterID = hourData.FCostCenterID \n");
            sql.append("                             and inBill.FCalculatePeriodId = hourData.FCalculatePeriodID \n");
            sql.append("                             and inBill.FCostObjectID = hourData.FCostObjectID \n");
            sql.append(" where co.FCompanyID = '" + companyId + "'" + filterContent);
            sql.append(" GROUP BY hourData.FCalculatePeriodID, period.FPeriodYear,period.FPeriodNumber,  hourData.FCostCenterID, cc.FNumber, cc.FName_" + locale + ",  hourData.FCostObjectID, co.FNumber,co.FOrderID, co.FOrderNumber, co.FBatchNumber,co.FProjectID,po.FNumber,co.FTrackID,tr.FNumber,co.FStdProductIDID,mat.FNumber,mat.FName_" + locale + ", co.FName_" + locale + ",period.Fnumber");
            sql.append("\n\n;");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
    }

    private Object[] preTreatDataTblAndFilter(RptParams filter) throws BOSException {
        boolean isYearSum;
        String tblPreTreatData = null;
        StringBuffer filterContent = null;
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        String companyId = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        boolean bl = isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        if (isYearSum) {
            CostCalReportPreTreatMent test = new CostCalReportPreTreatMent(this.getContext(), periodFromStr, periodToStr, companyId, isYearSum);
            tblPreTreatData = test.getTblPreTreatData();
            filterContent = this.buildFilter(filter, test.getPeriodIdInFilter());
        } else {
            try {
                tblPreTreatData = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_CostCalResult", (int)Integer.valueOf(periodFromStr), (int)Integer.valueOf(periodToStr));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            filterContent = this.buildFilter(filter, this.getPeriodIDsList(filter).toString());
        }
        return new Object[]{tblPreTreatData, filterContent, companyId};
    }

    private StringBuffer buildFilter(RptParams filter, String periodIdInFilter) {
        StringBuffer sb = new StringBuffer();
        if (periodIdInFilter != null && periodIdInFilter.length() > 0) {
            sb.append(" and period.FID in (" + periodIdInFilter + ") \n");
        }
        if (filter.getString("prmtCostCenterFrom") != null && !"".equals(filter.getString("prmtCostCenterFrom"))) {
            sb.append(" and cc.FNumber >='").append(filter.getString("prmtCostCenterFrom")).append("' \n");
        }
        if (filter.getString("prmtCostCenterTo") != null && !"".equals(filter.getString("prmtCostCenterTo"))) {
            sb.append(" and cc.FNumber <='").append(filter.getString("prmtCostCenterTo")).append("' \n");
        }
        if (filter.getString("prmtCostObjectFrom") != null && !"".equals(filter.getString("prmtCostObjectFrom"))) {
            sb.append(" and co.FNumber >='").append(filter.getString("prmtCostObjectFrom")).append("' \n");
        }
        if (filter.getString("prmtCostObjectTo") != null && !"".equals(filter.getString("prmtCostObjectTo"))) {
            sb.append(" and co.FNumber <='").append(filter.getString("prmtCostObjectTo")).append("' \n");
        }
        if (filter.getString("prmtOrderNumberFrom") != null && !"".equals(filter.getString("prmtOrderNumberFrom"))) {
            sb.append(" and co.FOrderNumber >='").append(filter.getString("prmtOrderNumberFrom")).append("'");
        }
        if (filter.getString("prmtOrderNumberTo") != null && !"".equals(filter.getString("prmtOrderNumberTo"))) {
            sb.append(" and co.FOrderNumber <='").append(filter.getString("prmtOrderNumberTo")).append("'");
        }
        if (filter.getString("kDTextBatchFrom") != null && !"".equals(filter.getString("kDTextBatchFrom"))) {
            sb.append(" and co.FBatchNumber >='").append(filter.getString("kDTextBatchFrom")).append("'");
        }
        if (filter.getString("kDTextBatchTo") != null && !"".equals(filter.getString("kDTextBatchTo"))) {
            sb.append(" and co.FBatchNumber <='").append(filter.getString("kDTextBatchTo")).append("'");
        }
        if (filter.getString("prmtProjectFrom") != null && !"".equals(filter.getString("prmtProjectFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("prmtProjectFrom")).append("'");
        }
        if (filter.getString("prmtProjectTo") != null && !"".equals(filter.getString("prmtProjectTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("prmtProjectTo")).append("'");
        }
        if (filter.getString("prmtTrackFrom") != null && !"".equals(filter.getString("prmtTrackFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("prmtTrackFrom")).append("'");
        }
        if (filter.getString("prmtTrackTo") != null && !"".equals(filter.getString("prmtTrackTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("prmtTrackTo")).append("'");
        }
        if (filter.getString("prmtMaterialFrom") != null && !"".equals(filter.getString("prmtMaterialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("prmtMaterialFrom")).append("'");
        }
        if (filter.getString("prmtMaterialTo") != null && !"".equals(filter.getString("prmtMaterialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("prmtMaterialTo")).append("'");
        }
        return sb;
    }

    private String createTempTableNameSum(StringBuffer rowToColumn, RptParams filter) throws BOSException {
        StringBuffer createTableSum = this.getTempTableSum(filter);
        createTableSum.append(rowToColumn);
        createTableSum.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTableSum.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTableSum.append(" ,FIsTotalRow int not null default(1) ");
        createTableSum.append(" ,FTotalPeriodRow int not null default(0) ");
        createTableSum.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTableSum.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTableSum.append(" ,FTotalOrderRow int not null default(0) ");
        createTableSum.append(" ,FTotalBatchRow int not null default(0) ");
        createTableSum.append(" ,FTotalProjectRow int not null default(0) ");
        createTableSum.append(" ,FTotalTrackRow int not null default(0) ");
        createTableSum.append(" ,FTotalMaterialRow int not null default(0) ");
        createTableSum.append(" ) ");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSum.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    private String createTmpTbl_rowToCol(StringBuffer rowToColumn) throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE rowToTotalTemp ");
        createTableSql.append("\t(");
        createTableSql.append(" FPeriodId       VARCHAR(44) \n");
        createTableSql.append(",FCostCenterID   VARCHAR(44) \n");
        createTableSql.append(",FCostObjectID   VARCHAR(44) \n");
        createTableSql.append(rowToColumn);
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tblName, "FPeriodId, FCostCenterID, FCostObjectID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    protected StringBuffer getTempTableSum(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append(" FPeriodId varchar(44) ");
        createTable.append(",FPeriodName varchar(50) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FOrderNumber varchar(255) default('')");
        createTable.append(",FProjectNumber varchar(255) default('')");
        createTable.append(",FTrackNumber varchar(255) default('')");
        createTable.append(",FMaterialNumber varchar(255) default('')");
        createTable.append(",FMaterialName varchar(255) default('')");
        createTable.append(",FOrderID varchar(255) ");
        createTable.append(",FBatchID varchar(255) ");
        createTable.append(",FProjectID varchar(255) ");
        createTable.append(",FTrackID varchar(255) ");
        createTable.append(",FMaterialID varchar(255) ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FBatchNumber nvarchar(255)");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FModel nvarchar(255) ");
        createTable.append(",FShortName nvarchar(80) ");
        createTable.append(",FBegProQty decimal(21,8) default(0) ");
        createTable.append(",FAdjBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBefAdjBegProQty decimal(21,8) default(0) ");
        createTable.append(",FBopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FAdjBopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FBefAdjBopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FBegProAmount decimal(21,8)  default(0) ");
        createTable.append(",FAdjBegProAmount decimal(21,8)  default(0) ");
        createTable.append(",FBefAdjBegProAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FInputHour decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FFinishHour decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FAdjEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FBefAdjEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FAdjEopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FBefAdjEopWIPHour decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FAdjEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FBefAdjEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInQty   decimal(21,8) default(0) ");
        createTable.append(",FYearInAmount   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(28,10) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearCompPrice  decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FUnitPriceDecimal int default(0) ");
        createTable.append(",FIsHistoryData int default(0) ");
        if (this.isShowStatUnit(filter)) {
            createTable.append(",FStatUnitName varchar(255) ");
            createTable.append(",FStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FAdjStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FBefAdjStatBegProQty decimal(21,8) default(0) ");
            createTable.append(",FStatCurInQty  decimal(21,8) default(0) ");
            createTable.append(",FStatCurCompQty  decimal(21,8) default(0) ");
            createTable.append(",FStatCurUnitPrice   decimal(21,8) default(0) ");
            createTable.append(",FStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FAdjStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FBefAdjStatEndProQty  decimal(21,8) default(0) ");
            createTable.append(",FStatYearInQty   decimal(21,8) default(0) ");
            createTable.append(",FStatYearCompQty  decimal(28,10) default(0) ");
            createTable.append(",FStatYearCompPrice  decimal(21,8) default(0) ");
            createTable.append(",FStatQtyDecimal int default(0) ");
        }
        return createTable;
    }

    private StringBuffer dataStyleRowToColumn(String tblPreTreatData, String tempTableNameSum, String TmpTbl_rowToCol, StringBuffer[] rowToColumnForInsert, StringBuffer[] rowToColumnForCalc, String[] costItemForWhere, StringBuffer rowToColumnForDelete, RptParams filter, String companyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        String tblBalance = null;
        String tblBalanceEntry = null;
        boolean isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        try {
            int periodFrom = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            int periodTo = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_Balance", (int)periodFrom, (int)periodTo);
            tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_BalanceEntry", (int)periodFrom, (int)periodTo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            if (rowToColumnForInsert != null && rowToColumnForInsert.length > 0) {
                int count = rowToColumnForInsert.length;
                for (int i = 0; i < count; ++i) {
                    sql.append("truncate table " + TmpTbl_rowToCol + "\n;");
                    sql.append("insert into " + TmpTbl_rowToCol);
                    sql.append("(FPeriodId, FCostCenterID, FCostObjectID, " + rowToColumnForInsert[i] + ")");
                    if (isYearSum) {
                        sql.append("SELECT distinct FPeriodId, FCostCenterID, FCostObjectID, \n");
                        sql.append(rowToColumnForCalc[i]);
                        sql.append(" FROM " + tblPreTreatData + " perTreatData \n");
                    } else {
                        sql.append("SELECT distinct perTreatData.FCalculatePeriodId, perTreatData.FCostCenterID, perTreatData.FCostObjectID, \n");
                        sql.append(rowToColumnForCalc[i]);
                        sql.append(" FROM " + tblPreTreatData + " perTreatData \n");
                        sql.append(" left join ( select bala.FCalculatePeriodID FCalculatePeriodID,bala.FCostCenterID FCostCenterID,bala.FCostObjectID FCostObjectID,");
                        sql.append("                    balaEntry.FCostItemID FCostItemID,balaEntry.FBopWipQty FBopWipQty, balaEntry.FBopWipAmount FBopWipAmount, FBopWIPHour,balaEntry.FAdjBopWipQty FAdjBopWipQty,balaEntry.FAdjBoPWipAmount FAdjBoPWipAmount \n");
                        sql.append("               from " + tblBalance + " bala  \n");
                        sql.append("                    inner join " + tblBalanceEntry + " balaEntry on balaEntry.fParentID = bala.FID \n");
                        sql.append("               where bala.FCalculatePeriodID in (" + this.getPeriodIDsList(filter) + ")  \n");
                        sql.append("  ) balaData on balaData.FCalculatePeriodID = perTreatData.FCalculatePeriodID \n");
                        sql.append("                and balaData.FCostCenterID = perTreatData.FCostCenterID \n");
                        sql.append("                and balaData.FCostObjectID = perTreatData.FCostObjectID \n");
                        sql.append("                And balaData.FCostItemID = perTreatData.FCostItemID \n");
                    }
                    sql.append(" where perTreatData.FCostItemID = '" + costItemForWhere[i] + "' \n;");
                    NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
                    sql.delete(0, sql.length());
                    TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TmpTbl_rowToCol);
                    sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                    sql.append(" SET (" + rowToColumnForInsert[i] + ")= \n");
                    sql.append("( SELECT top 1 " + rowToColumnForInsert[i] + " \n");
                    sql.append(" FROM ").append(TmpTbl_rowToCol).append(" T2 \n");
                    sql.append(" WHERE T1.FPeriodId=T2.FPeriodId \n");
                    sql.append("   AND T1.FCostCenterID=T2.FCostCenterID \n");
                    sql.append("   AND T1.FCostObjectID=T2.FCostObjectID \n");
                    sql.append(" )");
                    sql.append("\n\n;");
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.append(" DELETE " + tempTableNameSum);
        sql.append(" WHERE FBegProQty=0 AND FBegProAmount=0 AND FCurInQty=0 AND FCurInAmount=0 \n");
        sql.append(" AND FCurCompQty=0 AND FCurAllAmount=0 AND FCurUnitPrice=0  \n");
        sql.append(" AND FEndProQty=0 AND FEndProAmount=0 \n");
        sql.append(" AND FMakeSum=0 And FIsHistoryData = 0 \n");
        sql.append(" AND FAdjBegProQty = 0 AND FAdjBegProAmount = 0 \n");
        sql.append(rowToColumnForDelete);
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer makeDataSumBySelect(String tempTableNameSum, StringBuffer[] rowToColumnForInsert, StringBuffer[] rowToColumnForSum, RptParams filter, Locale locale, String companyID, String maxPeriod, Object[] ss) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer sql = new StringBuffer();
        String tblPreTreatData = (String)ss[0];
        if (this.isShowStatUnit(filter)) {
            sql.append(" update " + tempTableNameSum + " as t \n");
            sql.append("set (FStatBegProQty, \n");
            sql.append("     FAdjStatBegProQty, \n");
            sql.append("     FBefAdjStatBegProQty, \n");
            sql.append("     FStatCurInQty, \n");
            sql.append("     FStatCurCompQty, \n");
            sql.append("     FStatEndProQty, \n");
            sql.append("     FAdjStatEndProQty, \n");
            sql.append("     FBefAdjStatEndProQty, \n");
            sql.append("     FStatYearInQty, \n");
            sql.append("     FStatYearCompQty, \n");
            sql.append("     FStatCurUnitPrice \n");
            sql.append("     ) = ( \n");
            sql.append("select(case when mmu.FBaseConvsRate = 0 then FBegProQty else FBegProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FAdjBegProQty else FAdjBegProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FBefAdjBegProQty else FBefAdjBegProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FCurInQty else FCurInQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FCurCompQty else FCurCompQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FEndProQty else FEndProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FAdjEndProQty else FAdjEndProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FBefAdjEndProQty else FBefAdjEndProQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FYearInQty else FYearInQty / mmu.FBaseConvsRate end), \n");
            sql.append("(case when mmu.FBaseConvsRate = 0 then FYearCompQty else FYearCompQty / mmu.FBaseConvsRate end), \n");
            sql.append(" (CASE WHEN FCurCompQty = 0 \n");
            sql.append(" THEN 0 \n");
            sql.append(" ELSE to_decimal(FCurAllAmount * mmu.FBaseConvsRate,24,12)/to_decimal(FCurCompQty,24,12) END) as FStatCurUnitPrice \n");
            sql.append("from T_BD_CostObject co \n");
            sql.append("join T_BD_Material m \n");
            sql.append("    on m.FID = co.FStdProductIDID \n");
            sql.append("join T_BD_MultiMeasureUnit as mmu \n");
            sql.append("    on mmu.FMaterialID = m.FID and mmu.FIsStatUnit = 1 \n");
            sql.append("where co.FID = t.FCostObjectID \n");
            sql.append(") \n");
            sql.append("where t.FCostObjectID is not null \n");
            sql.append("\n\n;");
        }
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET \n");
        sql.append(" FQtyDecimal = ( \n");
        sql.append("      SELECT \n");
        sql.append("      MAX(T4.FqtyPrecision) \n");
        sql.append("        FROM T_BD_CostObject T2 ");
        sql.append("       INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append("       INNER JOIN t_bd_multimeasureunit T4 ON T4.FMaterialID = t3.FID AND T3.FBaseUnit = T4.FMeasureUnitID \n");
        sql.append("       WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID \n");
        sql.append(" ) \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(",FStatQtyDecimal = (\n");
            sql.append("    SELECT \n");
            sql.append("    MAX(mmu.FqtyPrecision) \n");
            sql.append("    FROM T_BD_CostObject T2 ");
            sql.append("    left join T_BD_MultiMeasureUnit mmu ");
            sql.append("        on mmu.FMaterialID = T2.FStdProductIDID and mmu.FIsStatUnit = 1 ");
            sql.append("    WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID \n");
            sql.append(") \n");
        }
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FUnitPriceDecimal= ( \n");
        sql.append("      SELECT MAX(T3.FPricePrecision) \n");
        sql.append("        FROM T_BD_CostObject T2 ");
        sql.append("       INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append("       WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID \n");
        sql.append(" ) \n");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("groupby");
            String compares = (String)map.get("compare");
            fields = fields.replaceAll("FPeriodName", "FPeriodNumber,FPeriodName");
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FBegProQty,FBopWIPHour, FBegProAmount, \n");
            sql.append(" FAdjBegProQty,FBefAdjBegProQty, \n");
            sql.append(" FAdjBegProAmount,FBefAdjBegProAmount, \n");
            sql.append(" FAdjBopWIPHour, FBefAdjBopWIPHour, \n");
            sql.append(" FCurInQty,FInputHour, FCurInAmount, \n");
            sql.append(" FCurCompQty,FFinishHour, FCurAllAmount, \n");
            sql.append(" FEndProQty,FEOPWipHour, FEndProAmount, \n");
            sql.append(" FAdjEndProQty,FBefAdjEndProQty, \n");
            sql.append(" FAdjEndProAmount,FBefAdjEndProAmount, \n");
            sql.append(" FAdjEOPWipHour,FBefAdjEOPWipHour, \n");
            sql.append(" FYearInQty,FYearInAmount, FYearCompQty, FYearCompAmount, \n");
            if (this.isShowStatUnit(filter)) {
                sql.append(" FStatBegProQty,FAdjStatBegProQty,FBefAdjStatBegProQty,FStatCurInQty, FStatCurCompQty,  \n");
                sql.append(" FStatEndProQty,FAdjStatEndProQty,FBefAdjStatEndProQty, FStatCurUnitPrice,FStatQtyDecimal,FStatYearInQty,FStatYearCompQty, \n");
            }
            sql.append(" FMakeSum, FCurUnitPrice,FQtyDecimal,FUnitPriceDecimal,FPriceDecimal) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FBegProQty) as FBegProQty, Sum(FBopWIPHour) as FBopWIPHour,Sum(FBegProAmount) as FBegProAmount, \n");
            sql.append(" Sum(FAdjBegProQty) as FAdjBegProQty,Sum(FBefAdjBegProQty) as FBefAdjBegProQty, \n");
            sql.append(" Sum(FAdjBegProAmount) as FAdjBegProAmount,Sum(FBefAdjBegProAmount) as FBefAdjBegProAmount, \n");
            sql.append(" Sum(FAdjBopWIPHour) as FAdjBopWIPHour,sum(FBefAdjBopWIPHour) as FBefAdjBopWIPHour, \n");
            sql.append(" Sum(FCurInQty) as FCurInQty,Sum(FInputHour) as FInputHour, Sum(FCurInAmount) as FCurInAmount, \n");
            sql.append(" Sum(FCurCompQty) as FCurCompQty, Sum(FFinishHour) as FFinishHour,Sum(FCurAllAmount) as FCurAllAmount, \n");
            sql.append(" Sum(FEndProQty) as FEndProQty, Sum(FEOPWIPHour) as FEOPWIPHour,Sum(FEndProAmount) as FEndProAmount, \n");
            sql.append(" Sum(FAdjEndProQty) as FAdjEndProQty,Sum(FBefAdjEndProQty) as FBefAdjEndProQty, \n");
            sql.append(" Sum(FAdjEndProAmount) as FAdjEndProAmount,Sum(FBefAdjEndProAmount) as FBefAdjEndProAmount, \n");
            sql.append(" Sum(FAdjEOPWIPHour) as FAdjEOPWIPHour,Sum(FBefAdjEOPWIPHour) as FBefAdjEOPWIPHour, \n");
            sql.append(" sum(FYearInQty) as FYearInQty,sum(FYearInAmount) as FYearInAmount, sum(FYearCompQty) as FYearCompQty, sum(FYearCompAmount) as FYearCompAmount, \n");
            if (this.isShowStatUnit(filter)) {
                sql.append(" Sum(FStatBegProQty) as FStatBegProQty, \n");
                sql.append(" Sum(FAdjStatBegProQty) as FAdjStatBegProQty, \n");
                sql.append(" Sum(FBefAdjStatBegProQty) as FBefAdjStatBegProQty, \n");
                sql.append(" Sum(FStatCurInQty) as FStatCurInQty, \n");
                sql.append(" Sum(FStatCurCompQty) as FStatCurCompQty, \n");
                sql.append(" Sum(FStatEndProQty) as FStatEndProQty, \n");
                sql.append(" Sum(FAdjStatEndProQty) as FAdjStatEndProQty, \n");
                sql.append(" Sum(FBefAdjStatEndProQty) as FBefAdjStatEndProQty, \n");
                sql.append(" (CASE WHEN Sum(FStatCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FStatCurCompQty),24,12) ELSE 0 END) as FStatCurUnitPrice,max(FStatQtyDecimal), \n");
                sql.append(" Sum(FStatYearInQty) FStatYearInQty,Sum(FStatYearCompQty) FStatYearCompQty, \n");
            }
            sql.append(" Sum(FMakeSum) as FMakeSum, \n");
            sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice,  \n  \n");
            sql.append(" max(FQtyDecimal),max(FUnitPriceDecimal),max(FPriceDecimal) \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" WHERE FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
            if (rowToColumnForInsert == null || rowToColumnForInsert.length <= 0) continue;
            int count = rowToColumnForInsert.length;
            for (int n = 0; n < count; ++n) {
                sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                sql.append(" SET (" + rowToColumnForInsert[n] + ")= ( \n");
                sql.append("     SELECT " + rowToColumnForInsert[n] + " \n");
                sql.append("       FROM (SELECT " + fields + "," + rowToColumnForSum[n] + " \n");
                sql.append("               FROM " + tempTableNameSum + " \n");
                sql.append("              WHERE FTOTALROW = 0 ");
                sql.append("              GROUP BY " + fields + " ) T2 \n");
                sql.append("      WHERE " + compares + " \n");
                sql.append("        AND T1.FTotalRow= " + map.get("totalrow").toString() + ") \n");
                sql.append("\n\n;");
            }
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
        sql.append(" FTotalRow2,FTotalRow, \n");
        sql.append(" FBegProQty, FBOPWIPHour,FBegProAmount, \n");
        sql.append(" FAdjBegProQty, FBefAdjBegProQty, \n");
        sql.append(" FAdjBegProAmount,FBefAdjBegProAmount, \n");
        sql.append(" FAdjBOPWIPHour, FBefAdjBOPWIPHour, \n");
        sql.append(" FCurInQty, FInputHour,FCurInAmount, \n");
        sql.append(" FCurCompQty, FFinishHour,FCurAllAmount, \n");
        sql.append(" FEndProQty, FEOPWIPHour,FEndProAmount, \n");
        sql.append(" FAdjEndProQty, FBefAdjEndProQty, \n");
        sql.append(" FAdjEndProAmount,FBefAdjEndProAmount, \n");
        sql.append(" FAdjEOPWIPHour, FBefAdjEOPWIPHour, \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" FStatBegProQty,FAdjStatBegProQty,FBefAdjStatBegProQty,FStatCurInQty, FStatCurCompQty, FStatEndProQty, FAdjStatEndProQty, FBefAdjStatEndProQty, FStatCurUnitPrice, \n");
        }
        sql.append(" FMakeSum, FCurUnitPrice) \n");
        sql.append(" SELECT 1,105,");
        sql.append(" Sum(FBegProQty) as FBegProQty,Sum(FBopWIPHOur) as FBopWIPHOur, \n");
        sql.append(" Sum(FBegProAmount) as FBegProAmount, \n");
        sql.append(" Sum(FAdjBegProQty) as FAdjBegProQty,Sum(FBefAdjBegProQty) as FBefAdjBegProQty, \n");
        sql.append(" Sum(FAdjBegProAmount) as FAdjBegProAmount,Sum(FBefAdjBegProAmount) as FBefAdjBegProAmount, \n");
        sql.append(" Sum(FAdjBopWIPHOur) as FAdjBopWIPHOur, Sum(FBefAdjBopWIPHOur) as FBefAdjBopWIPHOur, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, Sum(FInputHour) as FInputHour,\n");
        sql.append(" Sum(FCurInAmount) as FCurInAmount, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, Sum(FFinishHour) as FFinishHour,\n");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty,\n");
        sql.append(" Sum(FEOPWIPHour) as FEOPWIPHour, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" Sum(FAdjEndProQty) as FAdjEndProQty,Sum(FBefAdjEndProQty) as FBefAdjEndProQty, \n");
        sql.append(" Sum(FAdjEndProAmount) as FAdjEndProAmount,Sum(FBefAdjEndProAmount) as FBefAdjEndProAmount, \n");
        sql.append(" Sum(FAdjEOPWIPHour) as FAdjEOPWIPHour,Sum(FBefAdjEOPWIPHour) as FBefAdjEOPWIPHour, \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" Sum(FStatBegProQty) as FStatBegProQty, \n");
            sql.append(" Sum(FAdjStatBegProQty) as FAdjStatBegProQty, \n");
            sql.append(" Sum(FBefAdjStatBegProQty) as FBefAdjStatBegProQty, \n");
            sql.append(" Sum(FStatCurInQty) as FStatCurInQty, \n");
            sql.append(" Sum(FStatCurCompQty) as FStatCurCompQty, \n");
            sql.append(" Sum(FStatEndProQty) as FStatEndProQty, \n");
            sql.append(" Sum(FAdjStatEndProQty) as FAdjStatEndProQty, \n");
            sql.append(" Sum(FBefAdjStatEndProQty) as FBefAdjStatEndProQty, \n");
            sql.append(" (CASE WHEN Sum(FStatCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FStatCurCompQty),24,12) ELSE 0 END) as FStatCurUnitPrice  \n  \n,");
        }
        sql.append(" Sum(FMakeSum) as FMakeSum, \n");
        sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice  \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        sql.append("Update " + tempTableNameSum + " \n");
        sql.append("set \n");
        sql.append("    FYearInQty \n");
        sql.append("= ( \n");
        sql.append("    select sum(FYearInQty) \n");
        sql.append("    from " + tempTableNameSum + " \n");
        sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
        sql.append(") \n");
        sql.append("where FTotalRow2 = 1 \n");
        sql.append("; \n");
        sql.append("Update " + tempTableNameSum + " \n");
        sql.append("set \n");
        sql.append("    FYearInAmount \n");
        sql.append("= ( \n");
        sql.append("    select sum(FYearInAmount) \n");
        sql.append("    from " + tempTableNameSum + " \n");
        sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
        sql.append(") \n");
        sql.append("where FTotalRow2 = 1 \n");
        sql.append("; \n");
        sql.append("Update " + tempTableNameSum + " \n");
        sql.append("set \n");
        sql.append("    FYearCompQty \n");
        sql.append("= ( \n");
        sql.append("    select sum(FYearCompQty) \n");
        sql.append("    from " + tempTableNameSum + " \n");
        sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
        sql.append(") \n");
        sql.append("where FTotalRow2 = 1 \n");
        sql.append("; \n");
        sql.append("Update " + tempTableNameSum + " \n");
        sql.append("set \n");
        sql.append("    FYearCompAmount \n");
        sql.append("= ( \n");
        sql.append("    select sum(FYearCompAmount) \n");
        sql.append("    from " + tempTableNameSum + " \n");
        sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
        sql.append(") \n");
        sql.append("where FTotalRow2 = 1 \n");
        sql.append("; \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("Update " + tempTableNameSum + " \n");
            sql.append("set \n");
            sql.append("    FStatYearInQty \n");
            sql.append("= ( \n");
            sql.append("    select sum(FStatYearInQty) \n");
            sql.append("    from " + tempTableNameSum + " \n");
            sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
            sql.append(") \n");
            sql.append("where FTotalRow2 = 1 \n");
            sql.append("; \n");
            sql.append("Update " + tempTableNameSum + " \n");
            sql.append("set \n");
            sql.append("    FStatYearCompQty \n");
            sql.append("= ( \n");
            sql.append("    select sum(FStatYearCompQty) \n");
            sql.append("    from " + tempTableNameSum + " \n");
            sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "' \n");
            sql.append(") \n");
            sql.append("where FTotalRow2 = 1 \n");
            sql.append("; \n");
        }
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        String totalFieldNumber = orderStrings[0];
        sql.append("Update ");
        sql.append(tempTableNameSum);
        sql.append(" set ");
        sql.append(totalFieldNumber);
        sql.append(" = '");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()));
        sql.append("'  where Ftotalrow2 = 1 \n");
        sql.append("\n\n;");
        if (rowToColumnForInsert != null && rowToColumnForInsert.length > 0) {
            int count = rowToColumnForInsert.length;
            for (int n = 0; n < count; ++n) {
                sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                sql.append(" SET (" + rowToColumnForInsert[n] + ")= ( \n");
                sql.append("     SELECT " + rowToColumnForInsert[n] + " \n");
                sql.append("       FROM (SELECT " + rowToColumnForSum[n] + " \n");
                sql.append("               FROM " + tempTableNameSum + " \n");
                sql.append("              WHERE FTOTALROW = 0 ) T2 \n");
                sql.append("      WHERE T1.FTotalRow= 105 ) \n");
                sql.append("\n\n;");
            }
        }
        StringBuffer ColumnNames = new StringBuffer();
        StringBuffer ColumnSumNames = new StringBuffer();
        for (int i = 0; i < rowToColumnForInsert.length; ++i) {
            String colName = "F" + Integer.toString(i);
            ColumnNames.append("FAmount5" + colName + ", \n");
            ColumnSumNames.append("sum(FAmount5" + colName + ") as FAmount5" + colName + ", \n");
            if (i == rowToColumnForInsert.length - 1) {
                ColumnNames.append("FAmount6" + colName + " \n");
                ColumnSumNames.append("sum(FAmount6" + colName + ") as FAmount6" + colName + " \n");
                continue;
            }
            ColumnNames.append("FAmount6" + colName + ", \n");
            ColumnSumNames.append("sum(FAmount6" + colName + ") as FAmount6" + colName + ", \n");
        }
        if (ColumnNames != null && ColumnNames.length() > 0) {
            sql.append("Update " + tempTableNameSum + " \n");
            sql.append("set (\n");
            sql.append(ColumnNames);
            sql.append(" )= ( \n");
            sql.append(" select " + ColumnNames + " from ");
            sql.append("    (select " + ColumnSumNames + " \n");
            sql.append("    from " + tempTableNameSum + " \n");
            sql.append("    where FTotalRow = 0 and FPeriodNumber = '" + maxPeriod + "') T1 \n");
            sql.append(" ) \n");
            sql.append("where FTotalRow2 = 1 \n");
            sql.append("; \n");
        }
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= ( \n");
        sql.append("      SELECT T2.FNumber, T2.FName_" + locale + " \n");
        sql.append("        FROM T_ORG_CostCenter T2 \n");
        sql.append("       WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) =( \n");
        sql.append("      SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append("        FROM T_BD_CostObject T2 \n");
        sql.append("       WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID ) \n ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FMaterialNumber,FMaterialName) =( \n");
        sql.append("      SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append("        FROM T_BD_Material T2 \n");
        sql.append("       WHERE " + tempTableNameSum + ".FMaterialID =T2.FID ) \n ");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (\n");
        sql.append(" FBatchNumber,FUnitName,FModel,FShortName \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(" ,FStatUnitName");
        }
        sql.append(" ) = ( \n");
        sql.append("      SELECT T2.FBatchNumber,T4.FName_" + locale + ",T3.FModel,T3.FShortName ");
        if (this.isShowStatUnit(filter)) {
            sql.append(" ,smu.FName_" + locale + " \n");
        }
        sql.append("        FROM T_BD_CostObject T2 ");
        sql.append("       INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n");
        sql.append("       INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("       left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = T3.FID and mmu.FIsStatUnit = 1 ");
            sql.append("       left outer join T_BD_MeasureUnit smu on smu.FID = mmu.FMeasureUnitID \n");
        }
        sql.append("       WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID \n");
        sql.append(" ) \n");
        sql.append("\n\n;");
        sql.append("\n\n;");
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FOrderID")) {
                whichTotal = ", FTotalOrderRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchID")) {
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProjectID")) {
                whichTotal = ", FTotalProjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FTrackID")) {
                whichTotal = ", FTotalTrackRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialID")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            if (field.equals("FPeriodName")) {
                sql.append(" update " + tempTableNameSum + " set " + fieldNumber + " = " + fieldNumber + "|| ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n");
                sql.append(" FTotalPeriodrow = 1 \n");
            } else if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID")) {
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                sql.append(" update " + tempTableNameSum + " set " + fieldNumber + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                sql.append(whichTotal);
            } else {
                fieldName = field.substring(0, field.length() - 2) + "Name";
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                sql.append(" update " + tempTableNameSum + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n" + fieldNumber + " = " + fieldNumber + "\n");
                sql.append(whichTotal);
            }
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FQtyDecimal = ( \n");
        sql.append("      SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ")  \n");
        sql.append("     ,FUnitPriceDecimal= (SELECT MAX(FUnitPriceDecimal) FROM " + tempTableNameSum + ") \n");
        if (this.isShowStatUnit(filter)) {
            sql.append("     ,FStatQtyDecimal= (SELECT MAX(FStatQtyDecimal) FROM " + tempTableNameSum + ") \n");
        }
        sql.append(" where FTotalRow2 = 1 \n\n;");
        sql.append("UPDATE ").append(tempTableNameSum);
        sql.append(" SET FPriceDecimal=( \n");
        sql.append("\t  SELECT CY.FPrecision As FAmountPrecision \n");
        sql.append("\t    FROM T_BD_Currency CY \n");
        sql.append("\t   INNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID \n");
        sql.append("\t  WHERE CP.FID='").append(companyID).append("') \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FYearCompPrice= (CASE WHEN FYearCompQty<>0 THEN  round(to_decimal(FYearCompAmount,24,12)/to_decimal(FYearCompQty,24,12),FUnitPriceDecimal) ELSE 0 END) \n");
        if (this.isShowStatUnit(filter)) {
            sql.append(", FStatYearCompPrice = ( \n");
            sql.append("  CASE WHEN FStatYearCompQty <> 0 THEN ");
            sql.append("      round(to_decimal(FYearCompAmount,24,12)/to_decimal(FStatYearCompQty,24,12),FUnitPriceDecimal) \n");
            sql.append("  ELSE 0 END \n");
            sql.append("  )");
        }
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " \n");
        sql.append(" SET FCurUnitPrice = ROUND(FCurUnitPrice,FUnitPriceDecimal) \n");
        sql.append("    ,FBopWIPHour = ROUND(FBopWIPHour,2) \n");
        sql.append("    ,FAdjBopWIPHour = ROUND(FAdjBopWIPHour,2) \n");
        sql.append("    ,FBefAdjBopWIPHour = ROUND(FBefAdjBopWIPHour,2) \n");
        sql.append("    ,FInputHour = ROUND(FInputHour,2) \n");
        sql.append("    ,FFinishHour = ROUND(FFinishHour,2) \n");
        sql.append("    ,FEopWIPHour = ROUND(FEopWIPHour,2) \n");
        sql.append("\n\n;");
        return sql;
    }

    private IRowSet getCostItems(String companyId, Locale locale, StringBuffer filterContent, String tblPreTreatData, RptParams filter) throws BOSException {
        boolean isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        boolean iscal = true;
        String tblBalanceCurr = null;
        String tblBalanceEntryCurr = null;
        try {
            PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            iscal = AllocatorFacadeFactory.getLocalInstance((Context)this.getContext()).isCalculated(companyId, periodInfo.getId().toString());
            tblBalanceCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_Balance");
            tblBalanceEntryCurr = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_BalanceEntry");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select distinct ci.FID,ci.FNumber,ci.FName_" + locale + ",ci.FItemType \n");
        sql.append(" From ( \n");
        sql.append("     SELECT ci.FID FID,ci.FNumber FNumber,ci.FName_" + locale + " FName_" + locale + ",ci.FItemType FItemType \n");
        sql.append("     FROM " + tblPreTreatData + " perTreatData \n");
        if (isYearSum) {
            sql.append("     inner join t_bd_period period on perTreatData.FPeriodId = period.FID \n");
        } else {
            sql.append("     inner join t_bd_period period on perTreatData.FCalculatePeriodId = period.FID \n");
        }
        sql.append("     inner join T_ORG_CostCenter cc on perTreatData.FCostCenterID = cc.FID  \n");
        sql.append("     inner join T_BD_CostObject co on perTreatData.FCostObjectID = co.FID \n");
        sql.append("     left join t_mm_project po on po.FID = co.FProjectID \n");
        sql.append("     left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
        sql.append("     left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
        sql.append("     inner join T_NCM_CostItem ci on perTreatData.FCostItemID = ci.FID \n ");
        sql.append("     where co.FCompanyID = '" + companyId + "'" + filterContent);
        if (!iscal) {
            sql.append("    Union \n");
            sql.append("     SELECT distinct ci.FID FID,ci.FNumber FNumber,ci.FName_" + locale + " FName_" + locale + ",ci.FItemType FItemType \n");
            sql.append("     FROM " + tblBalanceCurr + " bala \n");
            sql.append("     inner join ").append(tblBalanceEntryCurr).append(" entry on entry.FParentID = bala.FID \n");
            sql.append("     inner join t_bd_period period on bala.FCalculatePeriodId = period.FID \n");
            sql.append("     inner join T_ORG_CostCenter cc on bala.FCostCenterID = cc.FID  \n");
            sql.append("     inner join T_BD_CostObject co on bala.FCostObjectID = co.FID \n");
            sql.append("     left join t_mm_project po on po.FID = co.FProjectID \n");
            sql.append("     left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
            sql.append("     left join t_bd_material mat on mat.FID = co.FStdProductIDID \n");
            sql.append("     inner join T_NCM_CostItem ci on entry.FCostItemID = ci.FID \n ");
            sql.append("     where co.FCompanyID = '" + companyId + "'" + filterContent);
        }
        sql.append(" ) as ci \n");
        sql.append(" order by ci.FItemType, ci.FNumber \n");
        sql.append("\n\n;");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    private int GetGreaterZeroRowCount(String columnName) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COUNT(1) as thisCount FROM ").append(this.tempTableNameSum + " \n").append(" WHERE " + columnName + " != 0 \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        rs.first();
        int count = rs.getInt("thisCount");
        return count;
    }

    private StringBuffer getRowToColumn(IRowSet rsCostItem, Locale locale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            rsCostItem.first();
            rsCostItem.previous();
            int i = 0;
            String colName = null;
            while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                colName = "F" + Integer.toString(i);
                sql.append(",FAmount1" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAdjAmount1" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FBefAdjAmount1" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount2" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount3" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount4" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAdjAmount4" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FBefAdjAmount4" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount5" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount6" + colName + " Decimal(21,8) Default(0) \n");
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    private StringBuffer[] getRowToColumnForInsert(IRowSet rsCostItem, Locale locale, RptParams filter) throws BOSException {
        boolean isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                rsCostItem.beforeFirst();
                int i = 0;
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    StringBuffer sql = new StringBuffer();
                    String colName = "F" + Integer.toString(i);
                    if (isYearSum) {
                        sql.append("FAmount1" + colName + ", \n");
                        sql.append("FAdjAmount1" + colName + ", \n");
                        sql.append("FBefAdjAmount1" + colName + ", \n");
                        sql.append("FAmount2" + colName + ", \n");
                        sql.append("FAmount3" + colName + ", \n");
                        sql.append("FAmount4" + colName + ", \n");
                        sql.append("FAdjAmount4" + colName + ", \n");
                        sql.append("FBefAdjAmount4" + colName + ", \n");
                        sql.append("FAmount5" + colName + ", \n");
                        sql.append("FAmount6" + colName + " \n");
                    } else {
                        sql.append("FAmount1" + colName + ", \n");
                        sql.append("FAdjAmount1" + colName + ", \n");
                        sql.append("FBefAdjAmount1" + colName + ", \n");
                        sql.append("FAmount2" + colName + ", \n");
                        sql.append("FAmount3" + colName + ", \n");
                        sql.append("FAmount4" + colName + ", \n");
                        sql.append("FAdjAmount4" + colName + ", \n");
                        sql.append("FBefAdjAmount4" + colName + " \n");
                    }
                    sqls[i++] = sql;
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer[] getRowToColumnWithoutYearSum(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                rsCostItem.beforeFirst();
                int i = 0;
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    StringBuffer sql = new StringBuffer();
                    String colName = "F" + Integer.toString(i);
                    sql.append("FAmount1" + colName + ", \n");
                    sql.append("FAdjAmount1" + colName + ", \n");
                    sql.append("FBefAdjAmount1" + colName + ", \n");
                    sql.append("FAmount2" + colName + ", \n");
                    sql.append("FAmount3" + colName + ", \n");
                    sql.append("FAmount4" + colName + ", \n");
                    sql.append("FAdjAmount4" + colName + ", \n");
                    sql.append("FBefAdjAmount4" + colName + ", \n");
                    sql.append("FAmount5" + colName + ", \n");
                    sql.append("FAmount6" + colName + " \n");
                    sqls[i++] = sql;
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer[] getRowToColumnForCalc(IRowSet rsCostItem, Locale locale, RptParams filter) throws BOSException {
        boolean isYearSum = (Boolean)filter.getObject("isShowYearSumIn") != false || (Boolean)filter.getObject("isShowYearSumComp") != false;
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                rsCostItem.beforeFirst();
                int i = 0;
                String colName = null;
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    colName = "F" + Integer.toString(i);
                    StringBuffer sql = new StringBuffer();
                    if (isYearSum) {
                        sql.append("FBegProAmount AS FAmount1" + colName + ", \n");
                        sql.append("FAdjBopWipAmount AS FAdjAmount1" + colName + ", \n");
                        sql.append("isnull(FBegProAmount,0)-isnull(FAdjBopWipAmount,0) AS FBefAdjAmount1" + colName + ", \n");
                        sql.append("FCurInAmount AS FAmount2" + colName + ", \n");
                        sql.append("FCurCompAmount AS FAmount3" + colName + ", \n");
                        sql.append("FEndProAmount AS FAmount4" + colName + ", \n");
                        sql.append("FAdjEopWipAmount AS FAdjAmount4" + colName + ", \n");
                        sql.append("isnull(FEndProAmount,0)-isnull(FAdjEopWipAmount,0) AS FBefAdjAmount4" + colName + ", \n");
                        sql.append("FYearSumInAmount AS FAmount5" + colName + ", \n");
                        sql.append("FYearSumCompAmount AS FAmount6" + colName + " \n");
                    } else {
                        sql.append("isnull(FBopWipAmount,0) AS FAmount1" + colName + ", \n");
                        sql.append("isnull(FAdjBoPWipAmount,0) AS FAdjAmount1" + colName + ", \n");
                        sql.append("isnull(FBopWipAmount,0)-isnull(FAdjBoPWipAmount,0) AS FBefAdjAmount1" + colName + ", \n");
                        sql.append("isnull(FFinishedAmount,0) + isnull(FEopWipAmount,0) - isnull(FAdjEoPWipAmount,0) - isnull(FBopWipAmount,0) AS FAmount2" + colName + ", \n");
                        sql.append("isnull(FFinishedAmount,0) AS FAmount3" + colName + ", \n");
                        sql.append("isnull(FEopWipAmount,0) AS FAmount4" + colName + ", \n");
                        sql.append("isnull(FAdjEoPWipAmount,0) AS FAdjAmount4" + colName + ", \n");
                        sql.append("isnull(FEopWipAmount,0) - isnull(FAdjEoPWipAmount,0) AS FBefAdjAmount4" + colName + " \n");
                    }
                    sqls[i++] = sql;
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String[] getCostItemForCalc(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            String[] costItems = new String[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                int i = 0;
                rsCostItem.beforeFirst();
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    costItems[i] = rsCostItem.getString("FID");
                    ++i;
                }
            }
            return costItems;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer getRowToColumnForDelete(IRowSet rsCostItem, Locale locale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            rsCostItem.beforeFirst();
            String colName = null;
            int i = 0;
            while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                colName = "F" + Integer.toString(i);
                sql.append(" AND FAmount1" + colName + "=0 \n");
                sql.append(" AND FAdjAmount1" + colName + "=0 \n");
                sql.append(" AND FBefAdjAmount1" + colName + "=0 \n");
                sql.append(" AND FAmount2" + colName + "=0 \n");
                sql.append(" AND FAmount3" + colName + "=0 \n");
                sql.append(" AND FAmount4" + colName + "=0 \n");
                sql.append(" AND FAdjAmount4" + colName + "=0 \n");
                sql.append(" AND FBefAdjAmount4" + colName + "=0 \n");
                sql.append(" AND FAmount5" + colName + "=0 \n");
                sql.append(" AND FAmount6" + colName + "=0 \n");
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    private StringBuffer[] getRowToColumnForSum(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                rsCostItem.beforeFirst();
                int i = 0;
                String colName = null;
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    colName = "F" + Integer.toString(i);
                    StringBuffer sql = new StringBuffer();
                    sql.append("SUM(FAmount1" + colName + ") as FAmount1" + colName + ", \n");
                    sql.append("SUM(FAdjAmount1" + colName + ") as FAdjAmount1" + colName + ", \n");
                    sql.append("SUM(FBefAdjAmount1" + colName + ") as FBefAdjAmount1" + colName + ", \n");
                    sql.append("SUM(FAmount2" + colName + ") as FAmount2" + colName + ", \n");
                    sql.append("SUM(FAmount3" + colName + ") as FAmount3" + colName + ", \n");
                    sql.append("SUM(FAmount4" + colName + ") as FAmount4" + colName + ", \n");
                    sql.append("SUM(FAdjAmount4" + colName + ") as FAdjAmount4" + colName + ", \n");
                    sql.append("SUM(FBefAdjAmount4" + colName + ") as FBefAdjAmount4" + colName + ", \n");
                    sql.append("SUM(FAmount5" + colName + ") as FAmount5" + colName + ", \n");
                    sql.append("SUM(FAmount6" + colName + ") as FAmount6" + colName + " \n");
                    sqls[i++] = sql;
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isDisplayYearSum(RptParams filter) {
        Object temp = filter.getObject("isDisplayYearSum");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return false;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"36_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"37_ByClassCostCalReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        if (filter.getString("prmtCostCenterFrom") != null || filter.getString("prmtCostCenterTo") != null) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"4_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("prmtCostCenterFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtCostCenterTo")));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"5_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtCostObjectFrom") != null || filter.getString("prmtCostObjectTo") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"8_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("prmtCostObjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtCostObjectTo")));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"9_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtOrderNumberFrom") != null || filter.getString("prmtOrderNumberTo") != null) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtOrderNumberFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtOrderNumberTo")));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("kDTextBatchFrom") != null || filter.getString("kDTextBatchTo") != null) {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("kDTextBatchFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("kDTextBatchTo")));
        } else {
            titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtProjectFrom") != null || filter.getString("prmtProjectTo") != null) {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtProjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtProjectTo")));
        } else {
            titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtTrackFrom") != null || filter.getString("prmtTrackTo") != null) {
            titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtTrackFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtTrackTo")));
        } else {
            titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumberAll", (Locale)ctx.getLocale()));
        }
        if (filter.getString("prmtMaterialFrom") != null || filter.getString("prmtMaterialTo") != null) {
            titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + "\uff1a" + StringUtils.cnulls((String)filter.getString("prmtMaterialFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("prmtMaterialTo")));
        } else {
            titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_MaterialAll", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    private boolean isShowBaseUnit(RptParams filter) {
        Object temp = filter.getObject("isShowBaseUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return !this.isShowStatUnit(filter);
    }

    private boolean isShowStatUnit(RptParams filter) {
        Object temp = filter.getObject("isShowStatUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return false;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        NCMReportHeader reportHeader = new NCMReportHeader();
        Context ctx = this.getContext();
        String resUrl = "com.kingdee.eas.ncm.cal.report.ReportResource";
        Locale locale = ctx.getLocale();
        int index = 0;
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        for (int i = 0; i < orderStrings.length; ++i) {
            if (orderStrings[i].equalsIgnoreCase("FPeriodName")) {
                reportHeader.addChild("FPeriodName", ResourceBase.getString((String)resUrl, (String)"Common_Period", (Locale)locale)).setAlign(1).setWidth(82).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)resUrl, (String)"Common_CostCenter_Number", (Locale)locale)).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)resUrl, (String)"Common_CostCenter_Name", (Locale)locale)).setAlign(1).setIndex(index++);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)resUrl, (String)"Common_CostObject_Number", (Locale)locale)).setAlign(1).setIndex(index++);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostobjectName")) continue;
            reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)resUrl, (String)"Common_CostObject_Name", (Locale)locale)).setAlign(1).setIndex(index++);
            reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
            reportHeader.addChild("FModel", ResourceBase.getString((String)resUrl, (String)"Common_Product_Model", (Locale)locale)).setAlign(1).setIndex(index++);
            reportHeader.addChild("FShortName", ResourceBase.getString((String)resUrl, (String)"Common_Product_SimpleName", (Locale)locale)).setAlign(1).setIndex(index++);
            if (this.isShowBaseUnit(filter)) {
                reportHeader.addChild("FUnitName", ResourceBase.getString((String)resUrl, (String)"Common_BaseMeasureUnit", (Locale)locale)).setAlign(1).setWidth(50).setIndex(index++);
            }
            if (!this.isShowStatUnit(filter)) continue;
            reportHeader.addChild("FStatUnitName", ResourceBase.getString((String)resUrl, (String)"Common_StatMeasureUnit", (Locale)locale)).setAlign(1).setIndex(index++);
        }
        boolean isShowBegPro = (Boolean)filter.getObject("isShowBegPro");
        boolean isShowCurIn = (Boolean)filter.getObject("isShowCurIn");
        boolean isShowCurComp = (Boolean)filter.getObject("isShowCurComp");
        boolean isShowEndPro = (Boolean)filter.getObject("isShowEndPro");
        boolean isShowYearSumIn = (Boolean)filter.getObject("isShowYearSumIn");
        boolean isShowYearSumComp = (Boolean)filter.getObject("isShowYearSumComp");
        ReportHeader bandAmount12 = null;
        if (isShowBegPro) {
            bandAmount12 = reportHeader.addChild("QCZCPTZQ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjBopWip", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount12.addChild("FBefAdjBegProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount12.addChild("FBefAdjStatBegProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount12.addChild("FBefAdjBopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount11 = null;
        if (isShowBegPro) {
            bandAmount11 = reportHeader.addChild("QCZCPTZ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjBopWip", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount11.addChild("FAdjBegProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount11.addChild("FAdjStatBegProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount11.addChild("FAdjBopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount1 = null;
        if (isShowBegPro) {
            bandAmount1 = reportHeader.addChild("QCZCP", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjBopWip", (Locale)ctx.getLocale()));
            bandAmount1.setVisible(false);
            if (this.isShowBaseUnit(filter)) {
                bandAmount1.addChild("FBegProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount1.addChild("FStatBegProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount1.addChild("FBopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
            for (int i = 0; i < bandAmount1.getChildCount(); ++i) {
                ((ReportHeader)bandAmount1.getChilds().get(i)).setVisible(false);
            }
        }
        ReportHeader bandAmount2 = null;
        if (isShowCurIn) {
            bandAmount2 = reportHeader.addChild("BQTR", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"72_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount2.addChild("FCurInQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount2.addChild("FStatCurInQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount2.addChild("FInputHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        reportHeader.addChild("FMakeSum", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"73_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount3 = null;
        if (isShowCurComp) {
            bandAmount3 = reportHeader.addChild("BQWG", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"74_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount3.addChild("FCurCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount3.addChild("FStatCurCompQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount3.addChild("FFinishHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount42 = null;
        if (isShowEndPro) {
            bandAmount42 = reportHeader.addChild("BQZCTZQ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjEopWip", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount42.addChild("FBefAdjEndProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount42.addChild("FBefAdjStatEndProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount42.addChild("FBefAdjEopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount41 = null;
        if (isShowEndPro) {
            bandAmount41 = reportHeader.addChild("BQZCTZ", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjEopWip", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount41.addChild("FAdjEndProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount41.addChild("FAdjStatEndProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount41.addChild("FAdjEopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount4 = null;
        if (isShowEndPro) {
            bandAmount4 = reportHeader.addChild("BQZC", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjEopWip", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount4.addChild("FEndProQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount4.addChild("FStatEndProQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
            bandAmount4.addChild("FEopWIPHour", ResourceBase.getString((String)resUrl, (String)"Commmon_Hour", (Locale)locale)).setAlign(3).setType(2).setDecimal(2);
        }
        ReportHeader bandAmount5 = null;
        if (isShowYearSumIn) {
            bandAmount5 = reportHeader.addChild("BQLJTR", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"88_CostCalTotalReport", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount5.addChild("FYearInQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount5.addChild("FStatYearInQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
        }
        ReportHeader bandAmount6 = null;
        if (isShowYearSumComp) {
            bandAmount6 = reportHeader.addChild("BQLJWG", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"89_CostCalTotalReport", (Locale)ctx.getLocale()));
            if (this.isShowBaseUnit(filter)) {
                bandAmount6.addChild("FYearCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount6.addChild("FStatYearCompQty", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatQty", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FStatQtyDecimal");
            }
        }
        Object[] ss = this.preTreatDataTblAndFilter(filter);
        String tblPreTreatData = (String)ss[0];
        StringBuffer filterContent = (StringBuffer)ss[1];
        String companyId = (String)ss[2];
        IRowSet rsCostItems = this.getCostItems(companyId, locale, filterContent, tblPreTreatData, filter);
        try {
            rsCostItems.beforeFirst();
            String nameInRs = "FName_" + locale;
            int i = 0;
            ReportHeader bandTemp = bandAmount1;
            while (rsCostItems.next() && rsCostItems.getString(nameInRs) != null && rsCostItems.getString("FNumber") != null) {
                String colName = "F" + Integer.toString(i++);
                if (isShowBegPro) {
                    bandTemp = bandAmount1;
                    this.addCostItemOnReportHeader(1, colName, nameInRs, bandTemp, rsCostItems);
                    bandTemp = bandAmount11;
                    this.addCostItemOnReportAdjHeader(1, colName, nameInRs, bandTemp, rsCostItems);
                    bandTemp = bandAmount12;
                    this.addCostItemOnReportBefAdjHeader(1, colName, nameInRs, bandTemp, rsCostItems);
                }
                if (isShowCurIn) {
                    bandTemp = bandAmount2;
                    this.addCostItemOnReportHeader(2, colName, nameInRs, bandTemp, rsCostItems);
                }
                if (isShowCurComp) {
                    bandTemp = bandAmount3;
                    this.addCostItemOnReportHeader(3, colName, nameInRs, bandTemp, rsCostItems);
                }
                if (isShowEndPro) {
                    bandTemp = bandAmount4;
                    this.addCostItemOnReportHeader(4, colName, nameInRs, bandTemp, rsCostItems);
                    bandTemp = bandAmount41;
                    this.addCostItemOnReportAdjHeader(4, colName, nameInRs, bandTemp, rsCostItems);
                    bandTemp = bandAmount42;
                    this.addCostItemOnReportBefAdjHeader(4, colName, nameInRs, bandTemp, rsCostItems);
                }
                if (isShowYearSumIn) {
                    bandTemp = bandAmount5;
                    this.addCostItemOnReportHeader(5, colName, nameInRs, bandTemp, rsCostItems);
                }
                if (!isShowYearSumComp) continue;
                bandTemp = bandAmount6;
                this.addCostItemOnReportHeader(6, colName, nameInRs, bandTemp, rsCostItems);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (isShowBegPro) {
            bandAmount1.addChild("FBegProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount11.addChild("FAdjBegProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount12.addChild("FBefAdjBegProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount1.setVisible(false);
            for (int j = 0; j < bandAmount1.getChildCount(); ++j) {
                ((ReportHeader)bandAmount1.getChilds().get(j)).setVisible(false);
            }
        }
        if (isShowCurIn) {
            bandAmount2.addChild("FCurInAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        }
        if (isShowCurComp) {
            bandAmount3.addChild("FCurAllAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"75_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            if (this.isShowBaseUnit(filter)) {
                bandAmount3.addChild("FCurUnitPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"16_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount3.addChild("FStatCurUnitPrice", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatUnitCost", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
            }
        }
        if (isShowEndPro) {
            bandAmount4.addChild("FEndProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount41.addChild("FAdjEndProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount42.addChild("FBefAdjEndProAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount4.setVisible(false);
            for (int j = 0; j < bandAmount4.getChildCount(); ++j) {
                ((ReportHeader)bandAmount4.getChilds().get(j)).setVisible(false);
            }
        }
        if (isShowYearSumIn) {
            bandAmount5.addChild("FYearInAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"71_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        }
        if (isShowYearSumComp) {
            bandAmount6.addChild("FYearCompAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"75_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            if (this.isShowBaseUnit(filter)) {
                bandAmount6.addChild("FYearCompPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"16_AuxFeeCostCalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
            }
            if (this.isShowStatUnit(filter)) {
                bandAmount6.addChild("FStatYearCompPrice", ResourceBase.getString((String)resUrl, (String)"CostCalTotalReport_StatUnitCost", (Locale)locale)).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
            }
        }
        return reportHeader;
    }

    private void addCostItemOnReportHeader(int itemIndex, String colName, String nameInRs, ReportHeader bandTemp, IRowSet rsCostItems) throws SQLException, BOSException {
        String realColName = "FAmount" + String.valueOf(itemIndex) + colName;
        int rowCount = this.GetGreaterZeroRowCount(realColName);
        if (rowCount > 0) {
            bandTemp.addChild(realColName, rsCostItems.getString(nameInRs)).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        }
    }

    private void addCostItemOnReportAdjHeader(int itemIndex, String colName, String nameInRs, ReportHeader bandTemp, IRowSet rsCostItems) throws SQLException, BOSException {
        String realColName = "FAdjAmount" + String.valueOf(itemIndex) + colName;
        int rowCount = this.GetGreaterZeroRowCount(realColName);
        if (rowCount > 0) {
            bandTemp.addChild(realColName, rsCostItems.getString(nameInRs)).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        }
    }

    private void addCostItemOnReportBefAdjHeader(int itemIndex, String colName, String nameInRs, ReportHeader bandTemp, IRowSet rsCostItems) throws SQLException, BOSException {
        String realColName = "FBefAdjAmount" + String.valueOf(itemIndex) + colName;
        int rowCount = this.GetGreaterZeroRowCount(realColName);
        if (rowCount > 0) {
            bandTemp.addChild(realColName, rsCostItems.getString(nameInRs)).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        }
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        StringBuffer compare = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (compare.length() > 0) {
                compare.append(" AND ");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            compare.append("T1." + fieldID + " = T2." + fieldID);
            map.put("groupby", sb.toString());
            map.put("compare", compare.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private StringBuffer getSortString(ArrayList list, String sortMode) {
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodName")) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortMode;
                fieldNumber = "FPeriodNumber";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                orderByWhichTotal = ", FTotalOrderRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                orderByWhichTotal = ", FTotalBatchRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                orderByWhichTotal = ", FTotalProjectRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                orderByWhichTotal = ", FTotalTrackRow " + sortMode;
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                orderByWhichTotal = ", FTotalMaterialRow " + sortMode;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID") || field.equalsIgnoreCase("FMaterialID")) {
                    sbChecked.append(field);
                } else {
                    sbChecked.append(fieldNumber);
                }
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderBy = this.getSortString((ArrayList)filter.getObject("table"), orderByMode).toString();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " Order by  FTotalRow2 " + orderByMode + ", " + orderBy + " ,FTotalRow"), (int)start, (int)rows);
        return rs;
    }

    private StringBuffer getPeriodIDsList(RptParams filter) throws BOSException {
        StringBuffer periodIDs = new StringBuffer();
        String periodFromStr = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodToStr = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String sql = " SELECT FID, FNumber, FPeriodYear FROM T_BD_Period  WHERE FTypeID ='" + companyInfo.getAccountPeriodType().getId().toString() + "' and FNumber>=" + periodFromStr + " and FNumber <= " + periodToStr + " order by FNumber ";
        IRowSet _Data = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (_Data != null && _Data.size() > 0) {
            try {
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    if (periodFromStr.compareTo(_Data.getString("FNumber")) == 0) {
                        periodIDs.append("'" + _Data.getString("FID") + "'");
                    } else {
                        periodIDs.append(",'" + _Data.getString("FID") + "'");
                    }
                    _Data.next();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return periodIDs;
    }
}

