/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostRestorationDetailReport
extends ReportServerBase {
    final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CostRestorationDetailReport");
    private String tempTableName;
    private HashMap costItemNumber2Fields;

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        PeriodInfo curPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)Integer.parseInt(filter.getString("yearfrom")), (int)Integer.parseInt(filter.getString("periodfrom")), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)filter.getObject("companyorg")));
        int periodNumberFrom = 0;
        periodNumberFrom = curPeriod.getNumber();
        String tableCBCalInfo = null;
        String tableCalRevertinfo = null;
        try {
            tableCBCalInfo = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalResult", (int)periodNumberFrom, (int)periodNumberFrom);
            tableCalRevertinfo = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalRevertInfo", (int)periodNumberFrom, (int)periodNumberFrom);
        }
        catch (EASBizException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("SELECT T_BD_CostObject.FID,T_BD_CostObject.FNumber,T_BD_CostObject.FName_" + locale + " as FName FROM T_BD_CostObject  WHERE ((Exists(SELECT 1 FROM " + tableCBCalInfo + " INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCBCalInfo + ".FCostCenterID WHERE " + tableCBCalInfo + ".FCOMPANYID = '" + companyID + "' AND T_BD_CostObject.FID = " + tableCBCalInfo + ".FCostObjectID AND " + tableCBCalInfo + ".FCalculatePeriodID = '" + curPeriod.getId().toString() + "'" + this.getCostCenterFilters(filter) + ")) OR (Exists(SELECT 1 FROM " + tableCalRevertinfo + " INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCalRevertinfo + ".FCostCenterID WHERE " + tableCalRevertinfo + ".FCOMPANYID = '" + companyID + "' AND T_BD_CostObject.FID = " + tableCalRevertinfo + ".FCostObjectID AND " + tableCalRevertinfo + ".FCalculatePeriodID = '" + curPeriod.getId().toString() + "'" + this.getCostCenterFilters(filter) + ")))" + this.getCostObjectFilters(filter) + " ORDER BY T_BD_CostObject.FNumber; ");
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
            if (rs.size() == 0) {
                rs = new DynamicRowSet(1);
                rs.getRowSetMetaData().setColumnName(1, "FID");
                rs.moveToInsertRow();
                rs.updateString("FID", "" + BOSUuid.create((String)"39734A77").toString() + "");
                rs.insertRow();
            }
            return rs;
        }
        catch (BOSException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        try {
            IRowSet rs;
            this.initReportData(reportID, filter);
            if (this.getTablename() == null || this.getTablename().length() < 1) {
                IRowSet iRowSet = null;
                return iRowSet;
            }
            IRowSet iRowSet = rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + this.getTablename() + " Order BY FCostCenterNumber,FCostObjectNumber,FSumSort,FSemiCostNumber,FDesType; "));
            return iRowSet;
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.getTablename());
        }
    }

    private String initReportData(String reportID, RptParams filter) throws Exception {
        String resultTableName;
        IRowSet rsCostItem;
        if (filter == null || filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        HashMap map = (HashMap)filter.getObject("position");
        String cbID = (String)map.get("fid");
        String cuId = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getCU().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.FID,a.FNumber From T_NCM_CostItem a ,T_BD_DataBaseDAssign b \n").append("\twhere b.FDataBaseDID= a.fid and b.FAssignCUID = ? and b.FBOSObjectType='548C5A91' \n").append("UNION \n").append("SELECT FID,FNumber from T_NCM_CostItem where FAdminCUID = ? \n").append("\torder by FNumber \n");
        try {
            rsCostItem = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{cuId, cuId});
            if (rsCostItem.size() <= 0) {
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName();
        if (filter.getString("yearfrom") == null || filter.getString("periodfrom") == null) {
            return null;
        }
        PeriodInfo curPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)Integer.parseInt(filter.getString("yearfrom")), (int)Integer.parseInt(filter.getString("periodfrom")), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)filter.getObject("companyorg")));
        String periodID = curPeriod.getId().toString();
        String periodNumber = String.valueOf(curPeriod.getNumber());
        String tableCBCalInfo = null;
        String tableCalRevertinfo = null;
        String tableCompleteQty = null;
        String tableCalinfoDetail = null;
        int periodNumberFrom = 0;
        periodNumberFrom = curPeriod.getNumber();
        try {
            tableCBCalInfo = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalResult", (int)periodNumberFrom, (int)periodNumberFrom);
            tableCalinfoDetail = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalMatDetailResult", (int)periodNumberFrom, (int)periodNumberFrom);
            tableCalRevertinfo = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalRevertInfo", (int)periodNumberFrom, (int)periodNumberFrom);
            tableCompleteQty = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_DataByCostObj", (int)periodNumberFrom, (int)periodNumberFrom);
        }
        catch (EASBizException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append(" create table t2 ( ");
        createTable.append(" FCompanyID varchar(44) ");
        createTable.append(" , FPeriodID varchar(44) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FSpendCostObjID varchar(44) not null default(' ')");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostItemID varchar(44) ");
        createTable.append(" , FSumSort int not null default(0) ");
        createTable.append(" , FType int not null default(0) ");
        createTable.append(" , FAmount decimal(21,10) ");
        createTable.append(" , FQty decimal(21,8) ");
        createTable.append(" ); ");
        try {
            this.tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        createTable = new StringBuffer();
        createTable.append(" create table t2 ( ");
        createTable.append(" FPeriodNumber varchar(20) ");
        createTable.append(" , FCompanyName varchar(255) ");
        createTable.append(" , FCostCenterNumber varchar(80) ");
        createTable.append(" , FCostCenterName varchar(255) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber varchar(80) ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FSemiCostNumber varchar(80) ");
        createTable.append(" , FSemiCostName varchar(255) ");
        createTable.append(" , FType varchar(255) ");
        createTable.append(" , FDesType int not null default(0) ");
        createTable.append(" , FSumSort int not null default(0) ");
        createTable.append(" , FAmount decimal(21,10) ");
        createTable.append(" , FQty decimal(21,8) ");
        createTable.append(" , FQtyDecimal int not null default(4) ");
        createTable.append(" , FAmountDecimal int not null default(4) ");
        rsCostItem.beforeFirst();
        int j = 0;
        if (this.costItemNumber2Fields == null) {
            this.costItemNumber2Fields = new HashMap();
        } else {
            this.costItemNumber2Fields.clear();
        }
        while (rsCostItem.next()) {
            createTable.append(" , FCostItem_" + j + " decimal(21,10)");
            this.costItemNumber2Fields.put((String)rsCostItem.getObject("FNumber"), "" + j);
            ++j;
        }
        createTable.append(" ); ");
        try {
            resultTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        Statement st = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n");
            sb.append(" SELECT '" + companyID + "','" + periodID + "',cb.FID,' '," + tableCBCalInfo + ".FCostCenterID," + tableCBCalInfo + ".FCostItemID,  1,1," + tableCBCalInfo + ".FFinishedAmount,0 FROM T_BD_CostObject cb \n");
            sb.append(" INNER JOIN " + tableCBCalInfo + " ON " + tableCBCalInfo + ".FCOSTOBJECTID = cb.FID ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCBCalInfo + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCBCalInfo + ".FCOMPANYID = '" + companyID + "' AND " + tableCBCalInfo + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "',cb.FID,' '," + tableCompleteQty + ".FCostCenterID,' ',  1,1,0," + tableCompleteQty + ".FFinishedQty FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCompleteQty + " ON " + tableCompleteQty + ".FCOSTOBJECTID = cb.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCompleteQty + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCompleteQty + ".FCOMPANYID = '" + companyID + "' AND " + tableCompleteQty + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "','" + cbID + "',cb.FID," + tableCalinfoDetail + ".FCostCenterID," + tableCalinfoDetail + ".FCostItemID,  2,2," + tableCalinfoDetail + ".FFinishedAmount," + tableCalinfoDetail + ".FFinishedQty FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCalinfoDetail + " ON " + tableCalinfoDetail + ".FMaterialID = cb.FStdProductIDID AND isnull(" + tableCalinfoDetail + ".FLot,' ')=isnull(cb.FBatchNumber, ' ')  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCalinfoDetail + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCalinfoDetail + ".FCOMPANYID = '" + companyID + "' AND " + tableCalinfoDetail + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND " + tableCalinfoDetail + ".FCostObjectID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "','" + cbID + "'," + tableCalRevertinfo + ".FSpendCostObjectID," + tableCalRevertinfo + ".FCostCenterID," + tableCalRevertinfo + ".FSpendCostItemID,  2,5," + tableCalRevertinfo + ".FAmount,0 FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCalRevertinfo + " ON " + tableCalRevertinfo + ".FCOSTOBJECTID = cb.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCalRevertinfo + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCalRevertinfo + ".FCOMPANYID = '" + companyID + "' AND " + tableCalRevertinfo + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND " + tableCalRevertinfo + ".FSpendCostObjectID<>" + tableCalRevertinfo + ".FCostObjectID AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "','" + cbID + "'," + tableCalRevertinfo + ".FSpendCostObjectID," + tableCalRevertinfo + ".FCostCenterID," + tableCalRevertinfo + ".FSpendCostItemID,  2,4," + tableCalRevertinfo + ".FCOEF,0 FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCalRevertinfo + " ON " + tableCalRevertinfo + ".FCOSTOBJECTID = cb.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCalRevertinfo + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCalRevertinfo + ".FCOMPANYID = '" + companyID + "' AND " + tableCalRevertinfo + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND " + tableCalRevertinfo + ".FSpendCostObjectID <>'0' AND " + tableCalRevertinfo + ".FSpendCostObjectID<>" + tableCalRevertinfo + ".FCostObjectID AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "',t.FPeriodID,t.FCostObjectID,t.FSpendCostObjID,t.FCostCenterID," + tableCBCalInfo + ".FCostItemID,  2,3," + tableCBCalInfo + ".FFinishedAmount,0 FROM " + this.tempTableName + " t  \n ");
            sb.append(" INNER JOIN " + tableCBCalInfo + " ON " + tableCBCalInfo + ".FCOSTOBJECTID = t.FSpendCostObjID AND " + tableCBCalInfo + ".FCalculatePeriodID = t.FPeriodID \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCBCalInfo + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCBCalInfo + ".FCOMPANYID = '" + companyID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND t.FSpendCostObjID <> t.FCostObjectID AND t.FType =2;  \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "',t.FPeriodID,t.FCostObjectID,t.FSpendCostObjID,t.FCostCenterID, ' ',  2,3,0," + tableCompleteQty + ".FFinishedQty FROM " + this.tempTableName + " t  \n ");
            sb.append(" INNER JOIN " + tableCompleteQty + " ON " + tableCompleteQty + ".FCOSTOBJECTID = t.FSpendCostObjID AND " + tableCompleteQty + ".FCalculatePeriodID = t.FPeriodID \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCompleteQty + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCompleteQty + ".FCOMPANYID = '" + companyID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND t.FSpendCostObjID <> t.FCostObjectID AND t.FType =2;  \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "',cb.FID,' '," + tableCBCalInfo + ".FCostCenterID," + tableCBCalInfo + ".FCostItemID,  101,6," + tableCBCalInfo + ".FRecvAmount,0 FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCBCalInfo + " ON " + tableCBCalInfo + ".FCOSTOBJECTID = cb.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCBCalInfo + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCBCalInfo + ".FCOMPANYID = '" + companyID + "' AND " + tableCBCalInfo + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" INSERT INTO " + this.tempTableName + "(FCompanyID,FPeriodID,FCostObjectID,FSpendCostObjID,FCostCenterID,FCostItemID, FSumSort,FType,FAmount,FQty) \n ");
            sb.append(" SELECT '" + companyID + "','" + periodID + "',cb.FID,' '," + tableCompleteQty + ".FCostCenterID,' ',  101,6,0," + tableCompleteQty + ".FFinishedQty FROM T_BD_CostObject cb  \n ");
            sb.append(" INNER JOIN " + tableCompleteQty + " ON " + tableCompleteQty + ".FCOSTOBJECTID = cb.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID =  " + tableCompleteQty + ".FCostCenterID \n ");
            sb.append(" WHERE " + tableCompleteQty + ".FCOMPANYID = '" + companyID + "' AND " + tableCompleteQty + ".FCalculatePeriodID ='" + periodID + "'" + this.getCostCenterFilters(filter));
            sb.append(" AND cb.FID = '" + cbID + "'; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            st.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, this.tempTableName);
            st.clearBatch();
            sb.append(" INSERT INTO " + resultTableName + "(FPeriodNumber,FCompanyName, FCostCenterNumber, FCostCenterName , FCostObjectID, FCostObjectNumber, FCostObjectName, FSemiCostNumber, FSemiCostName, FSumSort, FDesType, FType, FQty, FAmount  \n ");
            rsCostItem.beforeFirst();
            int i = 0;
            while (rsCostItem.next()) {
                sb.append(" , FCostItem_" + i);
                ++i;
            }
            sb.append(") \n ");
            sb.append(" SELECT '" + periodNumber + "','" + companyName + "',T_ORG_CostCenter.FNumber,T_ORG_CostCenter.FName_" + locale);
            sb.append(" , t.FCostObjectID, cb.FNumber,cb.FName_" + locale + ",cb1.FNumber,cb1.FName_" + locale + ",t.FSumSort \n ");
            sb.append(" ,FType as FDesType,CASE FType WHEN 1 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"181_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "'  WHEN 2 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"182_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "'  WHEN 3 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "'  WHEN 4 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "'  WHEN 5 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"185_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "'   WHEN 6 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"186_CostRestorationDetailReport", (Locale)ctx.getLocale()) + "' END  as FType \n ");
            sb.append(" ,SUM(t.FQty) as FQty,sum(t.FAmount) as FAmount  \n ");
            rsCostItem.beforeFirst();
            i = 0;
            while (rsCostItem.next()) {
                sb.append(" ,SUM(CASE WHEN t.FCostItemID='" + (String)rsCostItem.getObject("FID") + "' THEN t.FAmount Else 0 END) as FAmount_" + i);
                ++i;
            }
            sb.append(" FROM " + this.tempTableName + " t INNER JOIN T_BD_CostObject cb ON t.FCostObjectID = cb.FID  \n ");
            sb.append(" LEFT OUTER JOIN T_BD_CostObject cb1 ON t.FSpendCostObjID=cb1.FID  \n ");
            sb.append(" INNER JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID = t.FCostCenterID \n ");
            sb.append(" GROUP BY t.FPeriodID,T_ORG_CostCenter.FNumber,T_ORG_CostCenter.FName_" + locale + ", t.FSumSort, t.FCostObjectID, cb.FNumber,cb.FName_" + locale + ",cb1.FNumber,cb1.FName_" + locale + ", t.FType  \n ");
            sb.append(" ORDER BY t.FType,T_ORG_CostCenter.FNumber,cb1.FNumber; \n ");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" UPDATE " + resultTableName);
            sb.append(" SET FQtyDecimal= \n");
            sb.append(" (SELECT MAX(T4.FqtyPrecision) \n");
            sb.append(" FROM T_BD_CostObject T2 ");
            sb.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
            sb.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
            sb.append(" WHERE " + resultTableName + ".FCostObjectID=T2.FID ); \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append("UPDATE ").append(resultTableName).append(" SET FAmountDecimal=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(");").append(" \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append("UPDATE ").append(resultTableName).append(" SET FAmountDecimal=12,FQtyDecimal=12").append(" WHERE FDesType=4; ").append(" \n");
            st.addBatch(sb.toString());
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        this.setTablename(resultTableName);
        return this.tempTableName;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        RptParams params = new RptParams();
        String bissum = (String)rowData.get("FCOSTOBJECTID");
        if (bissum.trim().length() > 0) {
            params.setObject("companyorg", totalFilter.getObject("companyorg"));
            String stemp = (String)rowData.get("FCOSTCENTERNUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costcenterfrom", stemp);
            params.setString("costcenterto", stemp);
            stemp = (String)rowData.get("FCOSTOBJECTNUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costobjectfrom", stemp);
            params.setString("costobjectto", stemp);
            params.setString("yearfrom", totalFilter.getString("yearfrom"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = reportHeader.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FSemiCostNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"SemiCostNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FSemiCostName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"SemiCostName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FType")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Type", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCompanyName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CompanyOrgName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FAmount")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
        }
        IRowSet rsCostItem = null;
        try {
            StringBuffer sb = new StringBuffer();
            String cuId = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getCU().getId().toString();
            sb.append(" SELECT distinct a.FID as FCostItemID,a.FNumber,a.FName_l2 ").append("\tFrom ").append(this.tempTableName).append(" u,T_NCM_CostItem a ,T_BD_DataBaseDAssign b ").append("\twhere u.FCostItemID=a.FID and b.FDataBaseDID= a.fid and b.FAssignCUID = ? ").append(" \t\tand b.FBOSObjectType='548C5A91' ").append("UNION ").append("SELECT distinct a.FID as FCostItemID,a.FNumber,a.FName_l2  ").append("\tFrom ").append(this.tempTableName).append(" u,T_NCM_CostItem a ").append("\twhere u.FCostItemID=a.FID ").append("\t\tand a.FAdminCUID = ? ").append(" group by a.FID,FCostCenterID,FCostObjectID,FSpendCostObjid,FCostItemID,a.FNumber,a.FName_l2").append("\t,FType  order by FNumber ");
            if (this.tempTableName != null) {
                rsCostItem = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString(), (Object[])new Object[]{cuId, cuId});
            }
            if (rsCostItem == null || rsCostItem.size() <= 0) {
                ReportHeader reportHeader2 = reportHeader;
                return reportHeader2;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.tempTableName);
        }
        rsCostItem.beforeFirst();
        String ciFieldName = null;
        ReportHeader child = null;
        while (rsCostItem.next()) {
            ciFieldName = (String)rsCostItem.getObject("FName_l2");
            String field = (String)this.costItemNumber2Fields.get((String)rsCostItem.getObject("FNumber"));
            if (ciFieldName.equals("\u539f\u6750\u6599")) {
                child = reportHeader.addChild("FCostItem_" + field, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BMat", (Locale)ctx.getLocale()));
                child.setAlign(3);
                child.setType(2);
                child.setDecimalField("FAmountDecimal");
                child.setVisible(true);
                continue;
            }
            if (ciFieldName.equals("\u5de5\u8d44")) {
                child = reportHeader.addChild("FCostItem_" + field, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Salary", (Locale)ctx.getLocale()));
                child.setAlign(3);
                child.setType(2);
                child.setDecimalField("FAmountDecimal");
                child.setVisible(true);
                continue;
            }
            if (ciFieldName.equals("\u5176\u4ed6")) {
                child = reportHeader.addChild("FCostItem_" + field, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Other", (Locale)ctx.getLocale()));
                child.setAlign(3);
                child.setType(2);
                child.setDecimalField("FAmountDecimal");
                child.setVisible(true);
                continue;
            }
            if (!ciFieldName.equals("\u6298\u65e7\u8d39\u7528")) continue;
            child = reportHeader.addChild("FCostItem_" + field, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CostRestorationDetailReport_0", (Locale)ctx.getLocale()));
            child.setAlign(3);
            child.setType(2);
            child.setDecimalField("FAmountDecimal");
            child.setVisible(true);
        }
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"91_CostRestorationDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        HashMap map = (HashMap)filter.getObject("position");
        if (map.get("fnumber") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"92_CostRestorationDetailReport", (Locale)ctx.getLocale()) + (String)map.get("fnumber") + "]" + (String)map.get("fname"));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"9_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        }
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterfrom"), filter.getString("costcenterto")));
        return titles;
    }

    private String getCostCenterFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("costcenterfrom") != null && !"".equals(filter.getString("costcenterfrom"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER >='").append(filter.getString("costcenterfrom")).append("'");
        }
        if (filter.getString("costcenterto") != null && !"".equals(filter.getString("costcenterto"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER <='").append(filter.getString("costcenterto")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getCostObjectFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("costobjectfrom") != null && !"".equals(filter.getString("costobjectfrom"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER >='").append(filter.getString("costobjectfrom")).append("'");
        }
        if (filter.getString("costobjectto") != null && !"".equals(filter.getString("costobjectto"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER <='").append(filter.getString("costobjectto")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }
}

