/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.CalCostGroupByEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostRestorationTotalReport
extends ReportServerBase {
    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTableName;
        Context ctx = this.getContext();
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.CostRestorationDetailReport");
        Locale locale = ctx.getLocale();
        if (filter == null || filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName();
        int rptGroupBy = ((CalCostGroupByEnum)((Object)filter.getObject("kdcbgroupBy"))).getValue();
        String firstField = null;
        String secondField = null;
        if (rptGroupBy == 2) {
            firstField = "FCostObject";
            secondField = "FCostCenter";
        } else if (rptGroupBy == 1) {
            firstField = "FCostCenter";
            secondField = "FCostObject";
        }
        if (filter.getString("yearfrom") == null || filter.getString("periodfrom") == null) {
            return null;
        }
        PeriodInfo curPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)Integer.parseInt(filter.getString("yearfrom")), (int)Integer.parseInt(filter.getString("periodfrom")), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)filter.getObject("companyorg")));
        String periodID = curPeriod.getId().toString();
        String periodNumber = String.valueOf(curPeriod.getNumber());
        String tableCBProductQty = null;
        String tableCBProductCalInfo = null;
        int periodNumberFrom = 0;
        periodNumberFrom = curPeriod.getNumber();
        try {
            tableCBProductQty = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_DataByProduct", (int)periodNumberFrom, (int)periodNumberFrom);
            tableCBProductCalInfo = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalPrdDetailResult", (int)periodNumberFrom, (int)periodNumberFrom);
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append(" Create Table t2 ( ");
        createTable.append(" FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber varchar(80) ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostCenterNumber varchar(80) ");
        createTable.append(" , FCostCenterName varchar(255) ");
        createTable.append(" , FCostItemID varchar(44) ");
        createTable.append(" , FCostItemNumber varchar(44) ");
        createTable.append(" , FCostItemName varchar(44) ");
        createTable.append(" , FSumSort int not null default(0) ");
        createTable.append(" , FQty decimal(21,8) ");
        createTable.append(" , FBeforeAmount decimal(17,4) ");
        createTable.append(" , FUnitAmout decimal(17,4) ");
        createTable.append(" , FAfterAmount decimal(17,4) ");
        createTable.append(" , FQtyDecimal int not null default(4)");
        createTable.append(" , FAmountDecimal int not null default(4)");
        createTable.append(" , FPriceDecimal int not null default(4)");
        createTable.append(" );");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        Statement st = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            sb.append(" INSERT INTO " + tempTableName + "(FCostObjectID,FCostObjectNumber,FCostObjectName");
            sb.append(" ,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostItemID,FCostItemNumber,FCostItemName,FSumSort,FQty ");
            sb.append(" ,FBeforeAmount,FUnitAmout,FAfterAmount) \n");
            sb.append(" SELECT u.FCostObjectID,T_BD_CostObject.FNumber,T_BD_CostObject.FName_" + locale + ",u.FCostCenterID \n");
            sb.append(" ,T_ORG_CostCenter.FNumber,T_ORG_CostCenter.FName_" + locale + ",u.FCostItemID,T_NCM_CostItem.FNumber,T_NCM_CostItem.FName_" + locale + ",0,v.FFinishedQty \n");
            sb.append(" ,u.FFinishedAmount,Case When ISNUll(v.FFinishedQty,0)<>0 THEN to_number(u.FRecvAmount)/to_number(v.FFinishedQty) ELSE 0 END,u.FRecvAmount");
            sb.append(" FROM " + tableCBProductCalInfo + " u ");
            sb.append(" LEFT JOIN " + tableCBProductQty + " v ON u.FCostCenterID = v.FCostCenterID AND u.FCompanyID = v.FCompanyID AND u.FCostObjectID = v.FCostObjectID \n");
            sb.append(" LEFT JOIN T_ORG_CostCenter ON T_ORG_CostCenter.FID= u.FCostCenterID \n");
            sb.append(" LEFT JOIN T_BD_CostObject ON T_BD_CostObject.FID = u.FCostObjectID \n");
            sb.append(" LEFT JOIN T_NCM_CostItem ON T_NCM_CostItem.FID = u.FCostItemID \n");
            sb.append(" WHERE u.FCalculatePeriodID = '" + periodID + "' AND v.FCalculatePeriodID = '" + periodID + "'  \n ");
            sb.append(" AND u.FCompanyID = '" + companyID + "'" + this.getCostCenterFilters(filter) + this.getCostObjectFilters(filter) + " \n");
            sb.append(" and T_BD_CostObject.FCalculateMode <> 3");
            sb.append(" ORDER BY T_BD_CostObject.FNumber,T_ORG_CostCenter.FNumber,u.FCostItemID; \n\n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" INSERT INTO " + tempTableName + "(" + firstField + "ID," + firstField + "Number," + firstField + "Name");
            sb.append(" ," + secondField + "ID," + secondField + "Number," + secondField + "Name,FCostItemID,FCostItemNumber,FCostItemName,FSumSort,FQty ");
            sb.append(" ,FBeforeAmount,FUnitAmout,FAfterAmount) \n");
            sb.append(" SELECT Max(" + firstField + "ID),CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN ' ' WHEN GROUPING(t." + secondField + "Number)=1 THEN t." + firstField + "Number || '(" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + ")' ELSE t." + firstField + "Number END ,Case WHEN GROUPING(t." + firstField + "Number) =0 THEN MAX(t." + firstField + "Name) END \n");
            sb.append(" ,MAX(t." + secondField + "ID),CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN ' ' WHEN GROUPING(t." + secondField + "Number)=1 THEN ' ' ELSE t." + secondField + "Number || '(" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + ")' END,CASE WHEN GROUPING(t." + firstField + "Number) =0 AND GROUPING(t." + secondField + "Number)=0 THEN MAX(t." + secondField + "Name) ELSE ' ' END,' ' \n");
            sb.append(" ,CASE WHEN GROUPING(t." + firstField + "Number) =0 AND GROUPING(t." + secondField + "Number)=1 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' ELSE ' ' END,' ',CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN 103 WHEN GROUPING(t." + secondField + "Number)=1 THEN 102 ELSE 100 END \n");
            sb.append(" ,Case WHEN GROUPING(t." + firstField + "Number) =1 THEN Sum(FQty) ELSE MAX(FQty) END,Sum(FBeforeAmount),Sum(FUnitAmout),Sum(FAfterAmount) \n");
            sb.append(" FROM " + tempTableName + " t WHERE FSumSort=0 \n");
            sb.append(" GROUP BY t." + firstField + "Number,t." + secondField + "Number WITH ROLLUP; \n\n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" INSERT INTO " + tempTableName + "(" + firstField + "ID," + firstField + "Number," + firstField + "Name");
            sb.append(" ," + secondField + "ID," + secondField + "Number," + secondField + "Name,FCostItemID,FCostItemNumber,FCostItemName,FSumSort,FQty ");
            sb.append(" ,FBeforeAmount,FUnitAmout,FAfterAmount) \n");
            sb.append(" SELECT Max(" + firstField + "ID),CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN '-1' ELSE t." + firstField + "Number || '(" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + ")' END , MAX(t." + firstField + "Name) \n");
            sb.append(" ,' ',' ',' ',CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN ' ' WHEN GROUPING(t.FCostItemID)=1 THEN '-2' ELSE t.FCostItemID END,MAX(FCostItemNumber),MAX(FCostItemName),CASE WHEN GROUPING(t." + firstField + "Number) =1 THEN 103 ELSE 101 END ,MAX(FQty),Sum(FBeforeAmount),Sum(FUnitAmout),Sum(FAfterAmount) \n");
            sb.append(" FROM " + tempTableName + " t WHERE FSumSort=0 \n");
            sb.append(" GROUP BY t." + firstField + "Number,t.FCostItemID WITH ROLLUP HAVING GROUPING(t.FCostItemID)=0 AND GROUPING(t." + firstField + "Number) =0; \n\n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            st.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, tempTableName);
            st.clearBatch();
            sb.append(" UPDATE " + tempTableName);
            sb.append(" SET FQtyDecimal= ");
            sb.append(" (SELECT ISNull(MAX(T4.FqtyPrecision),4) \n");
            sb.append(" FROM T_BD_CostObject T2 ");
            sb.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
            sb.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
            sb.append(" WHERE " + tempTableName + ".FCostObjectID=T2.FID ); \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" UPDATE " + tempTableName);
            sb.append(" SET FPriceDecimal= \n");
            sb.append(" (SELECT ISNUll(MAX(T3.FPricePrecision),4) \n");
            sb.append(" FROM T_BD_CostObject T2 ");
            sb.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
            sb.append(" WHERE " + tempTableName + ".FCostObjectID=T2.FID ); \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append("UPDATE ").append(tempTableName).append(" SET FAmountDecimal=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(");").append(" \n");
            sb.append("\n\n");
            DbUtil.execute((Context)this.getContext(), (String)sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" UPDATE ").append(tempTableName).append(" as u ").append(" SET (FQty,FAmountDecimal,FPriceDecimal,FQtyDecimal)=(SELECT t.FQty,t.FAmountDecimal,t.FPriceDecimal,t.FQtyDecimal FROM \n").append(" (SELECT SUM(v.FQty) as FQty,Max(v.FAmountDecimal) as FAmountDecimal,Max(v.FPriceDecimal) as FPriceDecimal,Max(v.FQtyDecimal) as FQtyDecimal,v." + firstField + "ID FROM ").append(tempTableName).append(" v WHERE v.FSumSort =100 Group By v." + firstField + "ID) t ").append(" WHERE t." + firstField + "ID=u." + firstField + "ID AND (u.FSumSort=102 or u.FSumSort=101));  \n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" UPDATE ").append(tempTableName).append(" SET FQty=(SELECT SUM(FQty) as FQty FROM ").append(tempTableName).append(" WHERE FSumSort =102)").append(" WHERE FSumSort =103;").append(" \n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            sb.append(" UPDATE ").append(tempTableName).append(" SET FUnitAmout = Case WHEN ISNull(FQty,0)<>0 THEN to_number(FAfterAmount)/to_number(FQty) ELSE 0 END WHERE FSumSort=103;").append(" \n");
            st.addBatch(sb.toString());
            sb.delete(1, sb.toString().length());
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        sb.append(" SELECT CASE WHEN FSumSort=103 THEN ' ' ELSE '" + companyName + "' END as FCompanyName,CASE WHEN FSumSort=103 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"187_CostRestorationTotalReport", (Locale)ctx.getLocale()) + "' ELSE '" + periodNumber + "' END as FPeriodNumber");
        sb.append(" ,t.* FROM " + tempTableName + " t ");
        sb.append(" Where FBeforeAmount+FAfterAmount<>0 ");
        sb.append(" Order by FCompanyName DESC," + firstField + "Number," + secondField + "Number,FSumSort,FCostItemNumber; ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableName);
        return rs;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = super.getReportHeader(reportID, filter);
        ArrayList childList = reportHeader.getChilds();
        ArrayList childChildList = null;
        ReportHeader childHeader = null;
        String fieldName = null;
        ReportHeader childChildHeader = null;
        String childFieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBeforeAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BeforeAmount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"80_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAmout")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterRestore", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (int j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FUnitAmout")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"224_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FAfterAmount")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"75_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fieldName.equals("FCompanyName")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CompanyOrgName", (Locale)ctx.getLocale()));
        }
        int rptGroupBy = ((CalCostGroupByEnum)((Object)filter.getObject("kdcbgroupBy"))).getValue();
        HashMap childs = reportHeader.getAllChilds();
        if (rptGroupBy == 1) {
            ReportHeader costObjectHeader = (ReportHeader)childs.get("FCostObjectNumber");
            ReportHeader costCenterHeader = (ReportHeader)childs.get("FCostCenterNumber");
            costObjectHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            costObjectHeader.setFieldName("FCostCenterNumber");
            costCenterHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            costCenterHeader.setFieldName("FCostObjectNumber");
            costObjectHeader = (ReportHeader)childs.get("FCostObjectName");
            costCenterHeader = (ReportHeader)childs.get("FCostCenterName");
            costObjectHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            costObjectHeader.setFieldName("FCostCenterName");
            costCenterHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            costCenterHeader.setFieldName("FCostObjectName");
        }
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"91_CostRestorationDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectfrom"), filter.getString("costobjectto")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterfrom"), filter.getString("costcenterto")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"99_CostRestorationTotalReport", (Locale)ctx.getLocale()) + ((CalCostGroupByEnum)((Object)filter.getObject("kdcbgroupBy"))).getAlias());
        return titles;
    }

    private String getCostCenterFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("costcenterfrom") != null && !"".equals(filter.getString("costcenterfrom"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER >='").append(filter.getString("costcenterfrom")).append("'");
        }
        if (filter.getString("costcenterto") != null && !"".equals(filter.getString("costcenterto"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER <='").append(filter.getString("costcenterto")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getCostObjectFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("costobjectfrom") != null && !"".equals(filter.getString("costobjectfrom"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER >='").append(filter.getString("costobjectfrom")).append("'");
        }
        if (filter.getString("costobjectto") != null && !"".equals(filter.getString("costobjectto"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER <='").append(filter.getString("costobjectto")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }
}

