/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeFactory;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTreeFactory;
import com.kingdee.eas.basedata.ncm.ExpenseTreeInfo;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.NCMReportHeader;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinishedProductCostDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)FinishedProductCostDetailReport.class.getName());
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private static final double COSTITEMGROUP_MOVE = 500.0;
    private static final double COSTITEM_MOVE = 0.5;
    private static final double MATGROUP_MOVE = 0.001;
    private double globalSeq = 1.0E-4;
    private double totalSeq = 1.0E-4;
    private String t_ExpenseFactor = null;
    private int amtprecision = 2;
    private String CcCoTmpTblName = null;

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        this.globalSeq = 1.0E-4;
        this.totalSeq = 1.0E-4;
        String sTableName = this.buildReportDataTableName(filter);
        boolean isTotalCostItem = filter.getBoolean("chkIsTotalCostItem");
        boolean isTotalExpnese = filter.getBoolean("chkIsTotalExpense");
        boolean isTotalMaterial = filter.getBoolean("chkIsTotalMaterial");
        boolean isDisplayTotalRowsOnly = filter.getBoolean("chkIsDisplayTotalRowsOnly");
        StringBuffer select = new StringBuffer();
        select.append("SELECT * ").append(" FROM ").append(sTableName).append(" WHERE  FWhichGroupTotal in (");
        StringBuffer totalType = new StringBuffer();
        if (isTotalCostItem) {
            totalType.append(",3");
        }
        if (isTotalExpnese) {
            totalType.append(",2");
        }
        if (isTotalMaterial) {
            totalType.append(",1");
        }
        totalType.append(",4");
        if (!isDisplayTotalRowsOnly) {
            totalType.append(",0");
        }
        totalType.append(",5,6");
        select.append(totalType.substring(1, totalType.length())).append(" )");
        if (isTotalCostItem || isTotalExpnese || isTotalMaterial) {
            select.append(this.getORDERBY());
        } else {
            select.append(" ORDER BY fistotalrow, FPeriodID,FIsPeriodTotal,FCostCenterNumber,FIsCostCenterTotal,FCostObjNumber,FIsCostObjectTotal,FCostItemNumber,FProductID,FIsTotal,FMatNumber");
        }
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)select.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        this.globalSeq = 1.0E-4;
        this.totalSeq = 1.0E-4;
        String sTableName = this.buildReportDataTableName(filter);
        this.setTablename(sTableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        boolean isTotalCostItem = filter.getBoolean("chkIsTotalCostItem");
        boolean isTotalExpnese = filter.getBoolean("chkIsTotalExpense");
        boolean isTotalMaterial = filter.getBoolean("chkIsTotalMaterial");
        boolean isDisplayTotalRowsOnly = filter.getBoolean("chkIsDisplayTotalRowsOnly");
        StringBuffer select = new StringBuffer();
        select.append("SELECT * ").append(" FROM ").append(tableName);
        StringBuffer totalType = new StringBuffer();
        if (isTotalCostItem) {
            totalType.append(",3");
        }
        if (isTotalExpnese) {
            totalType.append(",2");
        }
        if (isTotalMaterial) {
            totalType.append(",1");
        }
        totalType.append(",4");
        if (!isDisplayTotalRowsOnly) {
            totalType.append(",0");
        }
        totalType.append(",5,6");
        if (isTotalCostItem || isTotalExpnese || isTotalMaterial) {
            select.append(this.getORDERBY());
        } else {
            select.append(" ORDER BY fistotalrow, FPeriodID,FIsPeriodTotal,FCostCenterNumber,FIsCostCenterTotal,FCostObjNumber,FProductNumber,FIsCostObjectTotal,FCostItemNumber,FIsTotal,FMatNumber");
        }
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)select.toString(), (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String[] physicalTblNames;
        Context ctx = this.getContext();
        String companyID = null;
        if (filter.getObject("companyorg") != null) {
            companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        } else if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        } else {
            return null;
        }
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct cpr.FCostCenterID FCostCenterID ,cpr.FCostObjectID FCostObjectID,cc.FNumber FCostCenterNumber,co.FNumber FCostObjectNumber FROM ").append(physicalTblNames[1]).append(" cpr ").append("INNER JOIN T_BD_Period prd on cpr.FcalculatePeriodID = prd.FID\n").append("INNER JOIN T_ORG_CostCenter cc on cpr.FCostCenterID = cc.FID\n").append("INNER JOIN T_NCM_CostItem ci on cpr.FCostItemID = ci.FID ").append("INNER JOIN T_BD_CostObject co on (cpr.FCompanyID = co.FCompanyID and cpr.FCostObjectID = co.FID) \n").append("left join t_mm_project po on po.FID = co.FProjectID \n").append("left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n").append("left join t_bd_material pro on pro.FID = co.FStdProductIDID \n").append(" WHERE cpr.FCompanyID = ? and cpr.FTotalFinishedQty <> 0 \n");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, true, "prd.FNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "cc.FNumber", ">=", "costCenterFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "cc.FNumber", "<=", "costCenterTo");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "ci.FNumber", ">=", "costItemFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "ci.FNumber", "<=", "costItemTo");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FNumber", ">=", "costObjectFrom");
        NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FNumber", "<=", "costObjectTo");
        if (filter.getObject("prmtOrderNumberFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FOrderNumber", ">=", "prmtOrderNumberFrom");
        } else if (filter.getString("orderNumberFrom") != null) {
            sbSQL.append(" and co.FOrderNumber >= '" + filter.getString("orderNumberFrom") + "'");
        }
        if (filter.getObject("prmtOrderNumberTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FOrderNumber", "<=", "prmtOrderNumberTo");
        } else if (filter.getString("orderNumberTo") != null) {
            sbSQL.append(" and co.FOrderNumber <= '" + filter.getString("orderNumberTo") + "'");
        }
        if (filter.getObject("txtBatchFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        } else if (filter.getString("batchNumberFrom") != null) {
            sbSQL.append(" and co.FBatchNumber >= '" + filter.getString("batchNumberFrom") + "'");
        }
        if (filter.getObject("txtBatchTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        } else if (filter.getString("batchNumberTo") != null) {
            sbSQL.append(" and co.FBatchNumber <= '" + filter.getString("batchNumberTo") + "'");
        }
        if (filter.getObject("prmtProjectFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "po.FNumber", ">=", "prmtProjectFrom");
        } else if (filter.getString("projectNumberFrom") != null) {
            sbSQL.append(" and po.FNumber >= '" + filter.getString("projectNumberFrom") + "'");
        }
        if (filter.getObject("prmtProjectTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "po.FNumber", "<=", "prmtProjectTo");
        } else if (filter.getString("projectNumberTo") != null) {
            sbSQL.append(" and po.FNumber <= '" + filter.getString("projectNumberTo") + "'");
        }
        if (filter.getObject("prmtTrackFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "tr.FNumber", ">=", "prmtTrackFrom");
        } else if (filter.getString("trackNumberFrom") != null) {
            sbSQL.append(" and tr.FNumber >= '" + filter.getString("trackNumberFrom") + "'");
        }
        if (filter.getObject("prmtTrackTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "tr.FNumber", "<=", "prmtTrackTo");
        } else if (filter.getString("trackNumberTo") != null) {
            sbSQL.append(" and tr.FNumber <= '" + filter.getString("trackNumberTo") + "'");
        }
        if (filter.getObject("prmtProductFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "pro.FNumber", ">=", "prmtProductFrom");
        } else if (filter.getString("productFrom") != null) {
            sbSQL.append(" and pro.FNumber >= '" + filter.getString("productFrom") + "'");
        }
        if (filter.getObject("prmtProductTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, sbSQL, filter, false, "pro.FNumber", "<=", "prmtProductTo");
        } else if (filter.getString("productTo") != null) {
            sbSQL.append(" and pro.FNumber <= '" + filter.getString("productTo") + "'");
        }
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)(sbSQL.toString() + " ORDER BY cc.FNumber,co.FNumber "), (Object[])new String[]{companyID});
        if (rs.size() == 0) {
            DynamicRowSet drs = new DynamicRowSet(1);
            drs.setColInfo(1, "FCostCenterID_FCostObjectID", "constobjectid", 12, null);
            drs.moveToInsertRow();
            drs.updateString("FCostCenterID_FCostObjectID", "" + BOSUuid.create((String)"7FAFDF41").toString() + "_" + BOSUuid.create((String)"39734A77").toString() + "");
            drs.insertRow();
            return drs;
        }
        Integer nCountPerPage = Integer.valueOf(filter.getString("spCostObjectNum"));
        return NCMReportHelper.getListWithDynamicRowSet(ctx, nCountPerPage, rs, "FCostCenterID_FCostObjectID");
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        int amtPrecision = 2;
        if (companyID != null) {
            try {
                CompanyOrgUnitInfo comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                CurrencyInfo baseCurr = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrg.getBaseCurrency().getId()));
                amtPrecision = baseCurr.getPrecision();
            }
            catch (EASBizException e) {
                throw new BOSException(e.getCause());
            }
        }
        this.amtprecision = NCMUtils.getCurrencyPrecision((Context)this.getContext(), (String)companyID);
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        String mainTmpTblName = this.createTmpTableSQL(filter);
        String sTmpTblName = this.createTmpTableSQL(filter);
        String sTmpTblName2 = this.createTmpTableSQL2();
        this.buildDataOfReport(filter, companyID, amtPrecision, physicalTblNames, sTmpTblName, sTmpTblName2, null, mainTmpTblName);
        this.insertCostCenterTotalRow(sTmpTblName, filter);
        StringBuffer sb = new StringBuffer();
        sb.append(" update " + sTmpTblName + " as t1  set (FConsumeCommonQtyPrecision)   =(select  isnull(mmu.FqtyPrecision,4) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FBaseUnit = mmu.FMeasureUnitID \n");
        sb.append("  where t1.FMaterialID = t2.FID  ) where t1.FMaterialID is not null ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + sTmpTblName + " as t1  set (FConsumeAssistQtyPrecision)   =(select  isnull(mmu.FqtyPrecision,4) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FAssistUnit=mmu.FMeasureUnitID ");
        sb.append("  where t1.FMaterialID = t2.FID  )  where t1.FMaterialID is not null ");
        sb.append("\n\n");
        sb.append(";");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
        super.setTablename(sTmpTblName);
        return sTmpTblName;
    }

    private void mergeToMainTmpTbl(String mainTmpTblName, String sTmpTblName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(mainTmpTblName).append(" SELECT * FROM ").append(sTmpTblName);
        NCMDbUtil.execute((Context)this.getContext(), (String)sql.toString());
        NCMDbUtil.execute((Context)this.getContext(), (String)(" Truncate Table " + sTmpTblName));
    }

    private void buildDataOfReport(RptParams filter, String companyID, int amtPrecision, String[] physicalTblNames, String sTmpTblName, String sTmpTblName2, String wheres, String mainTmpTblName) throws BOSException {
        String sql = this.getInittempTblData(filter, physicalTblNames, sTmpTblName, amtPrecision, wheres);
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sql);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName2);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.updateNumericFeilds(filter, sTmpTblName);
        this.insertCostObjectTotalRow(filter);
        this.calUnitPercent();
    }

    private void insertPartialData(String tmpTblName, String[] physicalTblNames, RptParams filter, String companyID, int amtPrecision, String wheres) throws BOSException {
        String sql = this.getInittempTblData(filter, physicalTblNames, tmpTblName, amtPrecision, wheres);
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sql);
        StringBuffer sbSQL = new StringBuffer();
        String table = "T_IM_MaterialReqBillEntry";
        sbSQL.append(" update " + tmpTblName + " as t1  set FMatCommonUnitName   = (select  top 1 t3.FName_" + this.getContext().getLocale() + " \n");
        sbSQL.append(" from  " + table + " t2  \n");
        sbSQL.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sbSQL.append(" where t2.FMaterialID=t1.FMaterialID group by t2.FMaterialID,t3.FName_" + this.getContext().getLocale() + " )");
        sbSQL.append("\n\n");
        sbSQL.append(";");
    }

    private void updateNumericFeilds(RptParams filter, String tmpTblName) throws BOSException {
        String qtyFeild = this.isShowStatUnit(filter) ? "t1.FStatObjQty" : "t1.FObjQty";
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" UPDATE ").append(tmpTblName).append(" as mar \n").append("    SET (FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt)= \n").append(" (SELECT  \n");
        NCMReportHelper.AppendCaseSQLClause(updateSQL, "t1.FTotalConsumeCommonQty", qtyFeild, "FUnitConsumeCommonQty", "t1.FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause(updateSQL, "t1.FTotalConsumeQty", "t1.FObjQty", "FUnitConsumeQty", "t1.FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause(updateSQL, "t1.FTotalConsumeAssistQty", qtyFeild, "FUnitConsumeAssistQty", "t1.FQtyPrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause(updateSQL, "t1.FTotalCostAmt", "t1.FTotalConsumeQty", "FUnitCostPrice", "t1.FPricePrecision");
        updateSQL.append(" ,\n ");
        NCMReportHelper.AppendCaseSQLClause(updateSQL, "t1.FTotalCostAmt", qtyFeild, "FUnitCostAmt", "t1.FPricePrecision");
        updateSQL.append(" from ").append(tmpTblName).append(" t1 where mar.fid = t1.fid");
        updateSQL.append(" ); \n");
        StringBuffer updateSQL2 = new StringBuffer();
        updateSQL2.append("UPDATE ").append(tmpTblName).append(" AS TMP SET (FTotalUnitCostAmt) =     \t\t ").append('\n').append(" ( SELECT T.V FROM (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ").append('\n').append("    select FCostCenterID , FCostObjectID ,FProductID, sum( FUnitCostAmt) V                     ").append('\n').append("    from ").append(tmpTblName).append('\n').append("    where FTotalRow in (0,-1)                                                            ").append('\n').append("    group by FCostCenterID ,FCostObjectID,FProductID                                          ").append('\n').append("    ) AS T                                                                         ").append('\n').append("  WHERE Tmp.FCostCenterID = T.FCostCenterID AND TMP.FCostObjectID = T.FCostObjectID AND TMP.FProductID = T.FProductID ").append('\n').append(" ) ;                                                                                ").append('\n');
        StringBuffer updateSQL3 = new StringBuffer();
        updateSQL3.append(" UPDATE ").append(tmpTblName).append(" as mar \n").append("    SET (FUnitPercent)= \n").append(" (SELECT  \n");
        NCMReportHelper.AppendCaseSQLClause(updateSQL3, "FUnitCostAmt *100", "FTotalUnitCostAmt", "FUnitPercent", "FAmountPrecision");
        updateSQL3.append(" ) ");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)updateSQL.append(updateSQL2).append(updateSQL3).toString());
    }

    private void insertGroupTreeTotal(String tmpTblName, RptParams filter, String mainTmpTblName) throws BOSException, EASBizException, SQLException {
        boolean isTotalCostItem = filter.getBoolean("chkIsTotalCostItem");
        boolean isTotalExpnese = filter.getBoolean("chkIsTotalExpense");
        boolean isTotalMaterial = filter.getBoolean("chkIsTotalMaterial");
        if (isTotalMaterial) {
            this.insertTotalRowsForMaterialGroupTree(tmpTblName, filter, mainTmpTblName);
        }
        if (isTotalExpnese) {
            this.insertTotalRowsForExpenseGroupTree(tmpTblName, filter, mainTmpTblName);
        }
        if (isTotalCostItem) {
            this.insertTotalRowsForCostItemGroupTree(tmpTblName, filter, mainTmpTblName);
        }
    }

    private void updateTempTableForInsertTotalRows(RptParams filter, int groupLevel, Set databaseIDs, IDataBase iDataBase, int whichGroupTotal, StringBuffer updateSeqSQL, StringBuffer insertTotalSQL, StringBuffer sumSQL) throws BOSException, EASBizException {
        String groupTreeID = null;
        DataBaseInfo groupInfo = null;
        HashSet dbIDinGroup = new HashSet();
        Connection conn = null;
        PreparedStatement psUpdateSeq = null;
        PreparedStatement psSum = null;
        PreparedStatement psInsertTotal = null;
        Map trees2 = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            psUpdateSeq = conn.prepareStatement(updateSeqSQL.toString());
            psSum = conn.prepareStatement(sumSQL.toString());
            psInsertTotal = conn.prepareStatement(insertTotalSQL.toString());
            this.globalSeq += (double)(groupLevel * 2);
            int color = 0;
            boolean isLowerGroup = false;
            HashSet<Map> tree = new HashSet<Map>();
            for (int level = groupLevel; level >= 0; --level) {
                boolean bl = isLowerGroup = level < groupLevel;
                if (whichGroupTotal == 1) {
                    ICostItem iCostItem = (ICostItem)iDataBase;
                    trees2 = iCostItem.transformToTree(databaseIDs, level);
                } else if (whichGroupTotal == -1) {
                    IMaterial iMaterail = (IMaterial)iDataBase;
                    trees2 = iMaterail.transformToTree(databaseIDs, level);
                } else if (whichGroupTotal == 0) {
                    IExpense iExpense = (IExpense)iDataBase;
                    trees2 = iExpense.transformToTree(databaseIDs, level);
                }
                tree.add(trees2);
                color = (color + 1) % NCMConst.reportColors20.length;
                if (whichGroupTotal != 1) continue;
                psInsertTotal.setDouble(25, this.globalSeq += 1.0);
                this.globalSeq += 1.0;
                this.globalSeq = Math.ceil(this.globalSeq);
                if (!(this.globalSeq > this.totalSeq)) continue;
                this.totalSeq = this.globalSeq;
            }
            trees2.remove("RootID");
            Set groupSet = null;
            ArrayList<String> groupIDList = new ArrayList<String>();
            ArrayList groupIDListTmp = new ArrayList();
            ArrayList groupIDListRoot = new ArrayList();
            for (Map trees2 : tree) {
                groupSet = trees2.keySet();
                for (Object groupKeyID : groupSet) {
                    if (groupIDListTmp.contains(groupKeyID)) {
                        groupIDListTmp.remove(groupKeyID);
                    }
                    groupIDListTmp.add(groupKeyID);
                }
                if (!groupSet.contains("RootID")) continue;
                HashSet rootID = (HashSet)trees2.get("RootID");
                for (Object keyID : rootID) {
                    if (groupIDListRoot.contains(keyID)) continue;
                    groupIDListRoot.add(keyID);
                }
                groupIDListRoot.remove("RootID");
            }
            StringBuffer getGroupIDs = new StringBuffer();
            if (getGroupIDs.length() > 0) {
                getGroupIDs.delete(0, getGroupIDs.length() - 1);
            }
            if (whichGroupTotal == 1) {
                getGroupIDs.append("select FID From T_NCM_CostItemTypeTree ").append(" order by FLevel desc");
            }
            if (whichGroupTotal == 0) {
                getGroupIDs.append("select FID From T_NCM_ExpenseTree ").append(" order by FLevel desc");
            }
            if (whichGroupTotal == -1) {
                getGroupIDs.append("select FID From T_BD_MaterialGroup ").append(" order by FLevel desc");
            }
            IRowSet ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getGroupIDs.toString());
            groupIDList.clear();
            if (ciIDs.size() == 0) {
                groupIDList = groupIDListTmp;
                groupIDList.remove("RootID");
            } else {
                while (ciIDs.next()) {
                    if (!groupIDListTmp.contains(ciIDs.getString(1))) continue;
                    groupIDList.add(ciIDs.getString(1));
                }
            }
            for (int i = 0; i < groupIDList.size(); ++i) {
                ExpenseTreeInfo info;
                groupTreeID = (String)groupIDList.get(i);
                groupInfo = (DataBaseInfo)BDCMUtils.getObjectValue((Context)this.getContext(), (String)groupTreeID);
                String GroupIDParent = null;
                if (groupInfo instanceof ExpenseTreeInfo) {
                    try {
                        info = ExpenseTreeFactory.getLocalInstance((Context)this.getContext()).getExpenseTreeInfo((IObjectPK)new ObjectUuidPK(groupTreeID));
                        GroupIDParent = info != null && info.getLevel() > 1 ? info.getParent().getId().toString() : groupInfo.getId().toString();
                    }
                    catch (ObjectNotFoundException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (groupInfo instanceof MaterialGroupInfo) {
                    try {
                        info = MaterialGroupFactory.getLocalInstance((Context)this.getContext()).getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(groupTreeID));
                        GroupIDParent = info != null && info.getLevel() > 1 ? info.getParent().getId().toString() : groupInfo.getId().toString();
                    }
                    catch (ObjectNotFoundException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (groupInfo instanceof CostItemTypeTreeInfo) {
                    try {
                        info = CostItemTypeTreeFactory.getLocalInstance((Context)this.getContext()).getCostItemTypeTreeInfo((IObjectPK)new ObjectUuidPK(groupTreeID));
                        GroupIDParent = info != null && info.getLevel() > 1 ? info.getParent().getId().toString() : groupInfo.getId().toString();
                    }
                    catch (ObjectNotFoundException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                double originalSeq = 0.0;
                if (isLowerGroup && whichGroupTotal == 1) {
                    if (groupInfo.get("parent") != null) {
                        String parentID = ((DataBaseInfo)groupInfo.get("parent")).getId().toString();
                        originalSeq = this.getUpperGroupSeq(groupLevel, 1, parentID);
                        this.globalSeq = originalSeq + 1.0 - 0.5;
                    }
                } else {
                    this.globalSeq += 500.0;
                }
                dbIDinGroup.clear();
                for (Map trees2 : tree) {
                    Set tmp = (Set)trees2.get(groupTreeID);
                    if (tmp != null) {
                        for (Object groupID : tmp) {
                            if (dbIDinGroup.contains(groupID)) continue;
                            dbIDinGroup.add(groupID);
                        }
                    }
                    if (trees2.get(groupTreeID) != null) continue;
                    HashSet<String> rootIDset = new HashSet<String>();
                    rootIDset.add(groupTreeID);
                    if (dbIDinGroup.size() != 0) continue;
                    dbIDinGroup = rootIDset;
                }
                List rsList = null;
                rsList = whichGroupTotal == 1 ? NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)sumSQL.toString(), (Object[])new Integer[]{whichGroupTotal - 1}, dbIDinGroup) : NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)sumSQL.toString(), (Object[])new Integer[]{whichGroupTotal}, dbIDinGroup);
                IRowSet sumResult = null;
                int rsSize = rsList.size();
                for (int rsNum = 0; rsNum < rsSize; ++rsNum) {
                    sumResult = (IRowSet)rsList.get(rsNum);
                    while (sumResult.next()) {
                        double matGroupSeq;
                        String[] condations;
                        int sIndex = 0;
                        int gIndex = 0;
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        if (this.isShowStatUnit(filter)) {
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        }
                        psInsertTotal.setString(++sIndex, groupInfo.getNumber() + " ");
                        ++gIndex;
                        psInsertTotal.setString(++sIndex, groupInfo.getName() + " ");
                        ++gIndex;
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        psInsertTotal.setBigDecimal(++sIndex, sumResult.getBigDecimal(++gIndex));
                        if (whichGroupTotal == 1) {
                            psInsertTotal.setInt(++sIndex, 0);
                            ++gIndex;
                            condations = new String[]{sumResult.getString("FPeriodNumber"), sumResult.getString("FCostCenterNumber"), sumResult.getString("FCostObjNumber")};
                            matGroupSeq = this.adjustFSeqOfTotalCostItemGroup(condations, dbIDinGroup, groupTreeID);
                            psInsertTotal.setDouble(++sIndex, matGroupSeq);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, groupTreeID);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, groupTreeID);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            if (this.isShowStatUnit(filter)) {
                                psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            }
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        }
                        if (whichGroupTotal == -1) {
                            psInsertTotal.setInt(++sIndex, 0);
                            ++gIndex;
                            condations = new String[]{sumResult.getString("FCostItemID"), sumResult.getString("FPeriodNumber"), sumResult.getString("FCostCenterNumber"), sumResult.getString("FCostObjNumber")};
                            matGroupSeq = this.adjustFSeqOfTotalMatGroup(condations, dbIDinGroup, groupTreeID);
                            psInsertTotal.setDouble(++sIndex, matGroupSeq);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, null);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            String materialExpenseID = this.getMaterialExpense().getId().toString();
                            psInsertTotal.setString(++sIndex, materialExpenseID);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            if (this.isShowStatUnit(filter)) {
                                psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            }
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, groupTreeID);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        }
                        if (whichGroupTotal == 0) {
                            psInsertTotal.setInt(++sIndex, 1);
                            ++gIndex;
                            condations = new String[]{sumResult.getString("FCostItemID"), sumResult.getString("FPeriodNumber"), sumResult.getString("FCostCenterNumber"), sumResult.getString("FCostObjNumber")};
                            matGroupSeq = this.adjustFSeqOfTotalExpenseGroup(condations, dbIDinGroup, groupTreeID);
                            psInsertTotal.setDouble(++sIndex, matGroupSeq);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, GroupIDParent);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            if (this.isShowStatUnit(filter)) {
                                psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            }
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                            psInsertTotal.setString(++sIndex, groupTreeID);
                            ++gIndex;
                            psInsertTotal.setString(++sIndex, sumResult.getString(++gIndex));
                        }
                        psInsertTotal.execute();
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdateSeq);
                SQLUtils.cleanup(psSum);
                SQLUtils.cleanup(psInsertTotal, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdateSeq);
        SQLUtils.cleanup((Statement)psSum);
        SQLUtils.cleanup((Statement)psInsertTotal, (Connection)conn);
    }

    private double getUpperGroupSeq(int groupLevel, int level, String groupTreeID) throws BOSException, SQLException {
        IRowSet seqRS = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("select FSeq from " + this.getTablename() + " where fcostItemID = '" + groupTreeID + "'"));
        if (seqRS.next()) {
            return seqRS.getDouble(1);
        }
        return this.globalSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCIseqByGroup(Set groupSet, Set ciUnderRootID, String mainTmpTblName) throws BOSException, SQLException, EASBizException, UuidException {
        Connection conn = null;
        PreparedStatement psUpdateLongMatID = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            this.updateCIseq(conn, groupSet, ciUnderRootID, mainTmpTblName);
            StringBuffer updateLongMatID = new StringBuffer();
            updateLongMatID.append(" update ").append(this.getTablename()).append(" set FLongMaterialID = ? where Fid = ? ");
            psUpdateLongMatID = conn.prepareStatement(updateLongMatID.toString());
            StringBuffer getMatRowsSQL = new StringBuffer();
            getMatRowsSQL.append("select FID , FMaterialGroupID from ").append(this.getTablename()).append(" where FTotalRow = -1  ").append(this.getORDERBY());
            IRowSet matRowsRS = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getMatRowsSQL.toString());
            IMaterialGroup img = MaterialGroupFactory.getLocalInstance((Context)this.getContext());
            StringBuffer longMaterialIDs = new StringBuffer();
            while (matRowsRS.next()) {
                MaterialGroupInfo matGroupInfo;
                String rowID = matRowsRS.getString(1);
                longMaterialIDs.setLength(0);
                String materialGroupID = matRowsRS.getString(2);
                String treeID = null;
                for (MaterialGroupInfo parentInfo = matGroupInfo = img.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialGroupID))); parentInfo != null; parentInfo = parentInfo.getParent()) {
                    treeID = parentInfo.getId().toString();
                    parentInfo = img.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)treeID)));
                    longMaterialIDs.append(treeID).append("!");
                }
                psUpdateLongMatID.setString(1, longMaterialIDs.toString());
                psUpdateLongMatID.setString(2, rowID);
                psUpdateLongMatID.addBatch();
            }
            psUpdateLongMatID.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(psUpdateLongMatID, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)psUpdateLongMatID, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCIseq(Connection conn, Set groupSet, Set ciUnderRootID, String mainTmpTblName) throws BOSException, SQLException, EASBizException, UuidException {
        StringBuffer selectFSeqOfCostItem = new StringBuffer();
        selectFSeqOfCostItem.append("SELECT Fid From ").append(this.getTablename()).append(" ORDER BY FCostCenterNumber,FCostObjNumber,FSEQ,FPeriodNumber,FCostItemNumber,FProductID,FIsTotal,FMatNumber ");
        StringBuffer updateFSeqOfCostItem = new StringBuffer();
        updateFSeqOfCostItem.append("UPDATE ").append(this.getTablename()).append(" SET FSeq = FSeq + ?  where  FID = ? ");
        PreparedStatement psupdateFSeqOfCostItem = conn.prepareStatement(updateFSeqOfCostItem.toString());
        double ciSeqAdjust1 = 1.0;
        StringBuffer getMaxSeq = new StringBuffer();
        getMaxSeq.append("Select MAX(FSEQ) From ").append(mainTmpTblName).append(" where FWhichGroupTotal <> 4");
        IRowSet ciByGroup = NCMDbUtil.executeQuery((Context)this.getContext(), (String)selectFSeqOfCostItem.toString());
        IRowSet maxSeqRs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getMaxSeq.toString());
        while (maxSeqRs.next()) {
            ciSeqAdjust1 = maxSeqRs.getDouble(1);
        }
        while (ciByGroup.next()) {
            psupdateFSeqOfCostItem.setBigDecimal(1, new BigDecimal("" + (ciSeqAdjust1 += 1.0)));
            psupdateFSeqOfCostItem.setObject(2, ciByGroup.getString(1));
            psupdateFSeqOfCostItem.addBatch();
        }
        try {
            psupdateFSeqOfCostItem.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)psupdateFSeqOfCostItem);
        }
    }

    private double adjustFSeqOfTotalMatGroup(String[] condations, Set matGroupTotalRowID, String groupID) throws BOSException, SQLException, EASBizException, UuidException {
        Context ctx = this.getContext();
        double CIseq = 0.0;
        double groupSeq = 0.0;
        String fid = null;
        Object ciRowID = null;
        DecimalFormat format = new DecimalFormat("###0.00000000");
        StringBuffer getFSeqOfTotalMaterial = new StringBuffer();
        matGroupTotalRowID.add(groupID);
        getFSeqOfTotalMaterial.append("select max(Fseq) FROM ").append(this.getTablename()).append(" where FcostItemID = ? AND FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ?  AND (FMaterialID IN (?) or FMaterialGroupID IN (?) ) ");
        List rsList = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getFSeqOfTotalMaterial.toString(), (Object[])condations, (Collection)matGroupTotalRowID, (int)2);
        if (rsList.size() > 0) {
            IRowSet sumResult = (IRowSet)rsList.get(0);
            while (sumResult.next()) {
                CIseq = sumResult.getDouble(1) + 0.001;
            }
        } else {
            return CIseq;
        }
        StringBuffer getExpense = new StringBuffer();
        getExpense.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FPeriodNumber = '").append(condations[1]).append("' and FCostCenterNumber = '").append(condations[2]).append("' and FCostObjNumber = '").append(condations[3]).append("' and FIsTotal = 0 AND FcostItemID = '").append(condations[0]).append("' And FMaterialGroupID ='").append(groupID + "' ").append(this.getORDERBY());
        IRowSet seqResult = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getExpense.toString());
        while (seqResult.next()) {
            fid = seqResult.getString(1);
            groupSeq = CIseq - 1.0E-6;
            StringBuffer updateSeq1 = new StringBuffer();
            updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = ").append(format.format(groupSeq)).append("    where FDataFromTbl =1 and FID = '").append(fid).append("'").append(" and FCostItemID = '").append(condations[0]).append("'");
            NCMDbUtil.execute((Context)ctx, (String)updateSeq1.toString());
        }
        StringBuffer getBigSeqOfMaterial = new StringBuffer();
        Set allChildIDs = this.getAllChildIDs(groupID, -1);
        getBigSeqOfMaterial.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FcostItemID = ? AND FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ? And (FMaterialID IN (?) or FMaterialGroupID IN (?) ) ").append(this.getORDERBY());
        List rsListBigSeq = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getBigSeqOfMaterial.toString(), (Object[])condations, (Collection)allChildIDs, (int)2);
        if (rsListBigSeq.size() > 0) {
            IRowSet bigSeqResult = (IRowSet)rsListBigSeq.get(0);
            while (bigSeqResult.next()) {
                fid = bigSeqResult.getString(1);
                StringBuffer updateSeq1 = new StringBuffer();
                updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = ").append(format.format(groupSeq -= 1.0E-6)).append("    where FDataFromTbl <>1 and FIsUpdateSeq = 0 and FID = '").append(fid).append("'").append(" and FCostItemID = '").append(condations[0]).append("'");
                NCMDbUtil.execute((Context)ctx, (String)updateSeq1.toString());
            }
        }
        return CIseq;
    }

    private double adjustFSeqOfTotalExpenseGroup(String[] conditions, Set matGroupTotalRowID, String groupID) throws BOSException, SQLException, EASBizException, UuidException {
        Context ctx = this.getContext();
        double CIseq = 0.0;
        double groupSeq = 0.0;
        String fid = null;
        DecimalFormat format = new DecimalFormat("###0.00000000");
        StringBuffer getFSeqOfExpense = new StringBuffer();
        matGroupTotalRowID.add(groupID);
        getFSeqOfExpense.append("select max(Fseq) FROM ").append(this.getTablename()).append(" where FcostItemID = ? AND FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ? AND  (FExpenseID IN (?) or FExpenseGroupID = '").append(groupID).append("') ");
        List rsList = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getFSeqOfExpense.toString(), (Object[])conditions, (Collection)matGroupTotalRowID);
        if (rsList.size() > 0) {
            IRowSet sumResult = (IRowSet)rsList.get(0);
            while (sumResult.next()) {
                CIseq = sumResult.getDouble(1) + 0.001;
            }
        } else {
            return CIseq;
        }
        StringBuffer getBigSeqOfExpense = new StringBuffer();
        StringBuffer getExpense = new StringBuffer();
        getExpense.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FPeriodNumber = '").append(conditions[1]).append("' and FCostCenterNumber = '").append(conditions[2]).append("' and FCostObjNumber = '").append(conditions[3]).append("' and FIsTotal = 0 AND FcostItemID = '").append(conditions[0]).append("' And FExpenseGroupID ='").append(groupID + "' ").append("ORDER BY FIsTotalRow desc , FSEQ desc,FPeriodID desc,FIsPeriodTotal desc,FCostCenterNumber desc,FIsCostCenterTotal desc,FCostObjNumber desc,FIsCostObjectTotal desc,FCostItemNumber desc,FProductID desc,FIsTotal desc,FExpenseNumber desc,FMatNumber desc");
        IRowSet seqResult = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getExpense.toString());
        groupSeq = CIseq;
        while (seqResult.next()) {
            fid = seqResult.getString(1);
            groupSeq = CIseq - 1.0E-6;
            StringBuffer updateSeq1 = new StringBuffer();
            updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = ").append(format.format(groupSeq)).append("    where FDataFromTbl <>1 and FID = '").append(fid).append("'").append(" and FCostItemID = '").append(conditions[0]).append("' and FExpenseGroupID is not null and FExpenseGroupID <> ''");
            NCMDbUtil.execute((Context)ctx, (String)updateSeq1.toString());
        }
        Set allChildIDs = this.getAllChildIDs(groupID, 0);
        getBigSeqOfExpense.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FcostItemID = ? AND FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ? And (FExpenseID IN (?) or FExpensegroupID IN (?) ) ").append("ORDER BY FIsTotalRow desc , FSEQ desc,FPeriodID desc,FIsPeriodTotal desc,FCostCenterNumber desc,FIsCostCenterTotal desc,FCostObjNumber desc,FIsCostObjectTotal desc,FCostItemNumber desc,FProductID desc,FIsTotal desc,FExpenseNumber desc,FMatNumber desc");
        List rsListBigSeq = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getBigSeqOfExpense.toString(), (Object[])conditions, (Collection)allChildIDs, (int)2);
        if (rsListBigSeq.size() > 0) {
            IRowSet bigSeqResult = (IRowSet)rsListBigSeq.get(0);
            while (bigSeqResult.next()) {
                fid = bigSeqResult.getString(1);
                StringBuffer updateSeq1 = new StringBuffer();
                updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = ").append(format.format(groupSeq -= 1.0E-6)).append("    where FDataFromTbl <>1 and FIsUpdateSeq = 0 and FID = '").append(fid).append("'").append(" and FCostItemID = '").append(conditions[0]).append("' and FExpenseGroupID is not null and FExpenseGroupID <> ''");
                NCMDbUtil.execute((Context)ctx, (String)updateSeq1.toString());
            }
        }
        return CIseq;
    }

    private double adjustFSeqOfTotalCostItemGroup(String[] condations, Set costItemIDs, String groupID) throws BOSException, SQLException, EASBizException, UuidException {
        Context ctx = this.getContext();
        double CIseq = 0.0;
        double groupSeq = 0.0;
        String fid = null;
        DecimalFormat format = new DecimalFormat("###0.00000000");
        StringBuffer getFSeqOfTotalCostItem = new StringBuffer();
        getFSeqOfTotalCostItem.append("select max(Fseq) FROM ").append(this.getTablename()).append(" where FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ? and FCostItemID in (?)");
        List rsList = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getFSeqOfTotalCostItem.toString(), (Object[])condations, (Collection)costItemIDs);
        if (rsList.size() > 0) {
            IRowSet sumResult = (IRowSet)rsList.get(0);
            while (sumResult.next()) {
                CIseq = sumResult.getDouble(1) + 0.001;
            }
        } else {
            return CIseq;
        }
        StringBuffer getBigSeqOfExpense = new StringBuffer();
        StringBuffer getItems = new StringBuffer();
        getItems.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FPeriodNumber = '").append(condations[0]).append("' and FCostCenterNumber = '").append(condations[1]).append("' and FCostObjNumber = '").append(condations[2]).append("' and FIsTotal = 0 ").append(" And FCostItemGroupID ='").append(groupID + "' ").append("ORDER BY FIsTotalRow desc , FSEQ desc,FPeriodID desc,FIsPeriodTotal desc,FCostCenterNumber desc,FIsCostCenterTotal desc,FCostObjNumber desc,FIsCostObjectTotal desc,FCostItemNumber desc,FProductID desc,FIsTotal desc,FExpenseNumber desc,FMatNumber desc");
        IRowSet seqResult = NCMDbUtil.executeQuery((Context)this.getContext(), (String)getItems.toString());
        groupSeq = CIseq;
        while (seqResult.next()) {
            fid = seqResult.getString(1);
            groupSeq = CIseq - 1.0E-4;
            StringBuffer updateSeq1 = new StringBuffer();
            updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = '").append(format.format(groupSeq)).append("'    where FDataFromTbl <>1 and FID = '").append(fid).append("'");
        }
        Set allChildIDs = this.getAllChildIDs(groupID, 0);
        getBigSeqOfExpense.append("select Fid,Fseq FROM ").append(this.getTablename()).append(" where FPeriodNumber = ? and FCostCenterNumber = ? and FCostObjNumber = ? And (FCostItemID IN (?) or FCostItemGroupID IN (?) ) ").append("ORDER BY FIsTotalRow desc , FSEQ desc,FPeriodID desc,FIsPeriodTotal desc,FCostCenterNumber desc,FIsCostCenterTotal desc,FCostObjNumber desc,FIsCostObjectTotal desc,FCostItemNumber desc,FProductID desc,FIsTotal desc,FExpenseNumber desc,FMatNumber desc");
        List rsListBigSeq = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getBigSeqOfExpense.toString(), (Object[])condations, (Collection)allChildIDs, (int)2);
        if (rsListBigSeq.size() > 0) {
            IRowSet bigSeqResult = (IRowSet)rsListBigSeq.get(0);
            while (bigSeqResult.next()) {
                fid = bigSeqResult.getString(1);
                StringBuffer updateSeq1 = new StringBuffer();
                updateSeq1.append(" update ").append(this.getTablename()).append("    set FIsUpdateSeq = 1, FIsTotaled = 1, FSeq = ").append(format.format(groupSeq -= 1.0E-4)).append("    where FID = '").append(fid).append("'");
                NCMDbUtil.execute((Context)ctx, (String)updateSeq1.toString());
            }
        }
        return CIseq;
    }

    private Set getAllChildIDs(String groupID, int whichGroupTotal) throws BOSException, SQLException {
        HashSet<String> allChildIDs = new HashSet<String>();
        Set allChildGroupIDs = this.getAllChildGroupIDs(groupID, whichGroupTotal);
        Set allChildDetailIDs = this.getAllDetailIDs(allChildGroupIDs, whichGroupTotal);
        allChildIDs.add(groupID);
        if (allChildGroupIDs != null && allChildGroupIDs.size() > 0) {
            for (String allChildGroupID : allChildGroupIDs) {
                allChildIDs.add(allChildGroupID);
            }
        }
        if (allChildDetailIDs != null && allChildDetailIDs.size() > 0) {
            for (String allChildDetailID : allChildDetailIDs) {
                allChildIDs.add(allChildDetailID);
            }
        }
        return allChildIDs;
    }

    private Set getAllChildGroupIDs(String groupID, int whichGroupTotal) {
        Iterator iter;
        TreeBaseCollection coll;
        Context ctx = this.getContext();
        HashSet<String> allChildIDs = new HashSet<String>();
        String sql = "select *  where ID = '" + groupID + "'";
        if (whichGroupTotal == 1) {
            try {
                CostItemTypeTreeInfo costItemTreeInfo = CostItemTypeTreeFactory.getLocalInstance((Context)ctx).getCostItemTypeTreeInfo(sql);
                if (costItemTreeInfo != null) {
                    coll = CostItemTypeTreeFactory.getLocalInstance((Context)ctx).getAllChildren((TreeBaseInfo)costItemTreeInfo);
                    iter = coll.iterator();
                    while (iter.hasNext()) {
                        String costItemTreeID = ((CostItemTypeTreeInfo)iter.next()).getId().toString();
                        allChildIDs.add(costItemTreeID);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        if (whichGroupTotal == 0) {
            try {
                ExpenseTreeInfo expenseTreeInfo = ExpenseTreeFactory.getLocalInstance((Context)ctx).getExpenseTreeInfo(sql);
                if (expenseTreeInfo != null) {
                    coll = ExpenseTreeFactory.getLocalInstance((Context)ctx).getAllChildren((TreeBaseInfo)expenseTreeInfo);
                    iter = coll.iterator();
                    while (iter.hasNext()) {
                        String expenseTreeID = ((ExpenseTreeInfo)iter.next()).getId().toString();
                        allChildIDs.add(expenseTreeID);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        if (whichGroupTotal == -1) {
            try {
                MaterialGroupInfo materialGroupInfo = MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(groupID));
                if (materialGroupInfo != null) {
                    coll = ExpenseTreeFactory.getLocalInstance((Context)ctx).getAllChildren((TreeBaseInfo)materialGroupInfo);
                    iter = coll.iterator();
                    while (iter.hasNext()) {
                        String materialGroupID = ((MaterialGroupInfo)iter.next()).getId().toString();
                        allChildIDs.add(materialGroupID);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return allChildIDs;
    }

    private Set getAllDetailIDs(Set groupIDs, int whichGroupTotal) throws BOSException, SQLException {
        List rsList;
        HashSet<String> allDetailIDs = new HashSet<String>();
        if (groupIDs == null || groupIDs.size() <= 0) {
            return null;
        }
        StringBuffer getAllDetailIDs = new StringBuffer();
        if (whichGroupTotal == 1) {
            getAllDetailIDs.append("select FID From T_NCM_CostItem where FTypeTreeID IN (?)");
        }
        if (whichGroupTotal == 0) {
            getAllDetailIDs.append("select FID From T_NCM_Expense where FTreeID IN (?)");
        }
        if (whichGroupTotal == -1) {
            getAllDetailIDs.append("select FID From T_BD_Material where FMaterialGroupID IN (?)");
        }
        if ((rsList = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getAllDetailIDs.toString(), null, (Collection)groupIDs)).size() > 0) {
            IRowSet rs = (IRowSet)rsList.get(0);
            while (rs.next()) {
                String detailID = rs.getString(1);
                allDetailIDs.add(detailID);
            }
        }
        return allDetailIDs;
    }

    private Set getAllCIid(String tmpTblName) throws BOSException, SQLException {
        IRowSet ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FCostItemID FROM " + tmpTblName + " WHERE FCostItemID is not null "));
        if (ciIDs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        return databaseIDs;
    }

    private void insertTotalRowsForCostItemGroupTree(String tmpTblName, RptParams filter, String wheres) throws EASBizException, BOSException, SQLException {
        int groupLevel = Integer.parseInt(filter.getString("spCostItemLevel") == null ? "1" : filter.getString("spCostItemLevel"));
        Set databaseIDs = this.getAllCIid(tmpTblName);
        if (databaseIDs == null) {
            return;
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK((Collection)databaseIDs);
        IRowSet oneRow = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_NCM_CostItemTypeTree a LEFT JOIN T_NCM_CostItem b  ON a.FID = b.FTypeTreeID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = FSeq + ?").append(" WHERE FCostItemID IN (?) ");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append("SELECT newbosid('12345678') as FID,").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(",FStatUnitName,FStatObjQty");
        }
        sumSQL.append(",null,null");
        sumSQL.append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),Sum(isnull(FUnitPercent,0)),0,0,0,0 \n ").append(", max(FQtyPrecision)");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(", max(FStatQtyPrecision)");
        }
        sumSQL.append(",max(FConsumeCommonQtyPrecision),max(FConsumeQtyPrecision),max(FConsumeAssistQtyPrecision),max(FPricePrecision),max(FAmountPrecision),''FProductID,FPeriodID \n").append(" FROM ").append(tmpTblName).append(" WHERE FIsTotal = ? AND FCostItemID IN (?) \n ").append(" GROUP BY FCompanyOrg,FPeriodNumber,FPeriodID,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName, FProductModel,FProductShortName").append(" ,FProductLot,FUnitName,FObjQty");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(",FStatUnitName,FStatObjQty");
        }
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" (FID, FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append("FStatUnitName,FStatObjQty,");
        }
        insertTotalSQL.append(" FCostItemNumber,FCostItemName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq,FCostItemGroupID,FCostItemID, ").append(" FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(", FStatQtyPrecision");
        }
        insertTotalSQL.append(",FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision,FProductID,FPeriodID,").append(" FWhichGroupTotal, FRowBgColor, FIsTotal ) \n").append(" VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?,?,?");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?,?");
        }
        insertTotalSQL.append(",?,?,?, ?,   ?,?,   ?,?,   ?,?,?,?,?, ?,?,?");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?");
        }
        insertTotalSQL.append(", ?,?,?,?,?, ?,?,3,1,-1) ");
        this.updateTempTableForInsertTotalRows(filter, groupLevel, databaseIDs, (IDataBase)iCostItem, 1, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertTotalRowsForMaterialGroupTree(String tmpTblName, RptParams filter, String mainTmpTblName) throws BOSException, SQLException, EASBizException {
        int groupLevel = Integer.parseInt(filter.getString("spMaterialLevel"));
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)this.getContext());
        Set allCostItemIDs = this.getAllCIid(tmpTblName);
        if (allCostItemIDs == null) {
            return;
        }
        Map trees = iCostItem.transformToTree(allCostItemIDs, 1);
        Set groupSet = trees.keySet();
        this.updateCIseqByGroup(groupSet, (Set)trees.get("RootID"), mainTmpTblName);
        IRowSet ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FMaterialID FROM " + tmpTblName + " WHERE FMaterialID <> ' ' AND  FMaterialID is not null  "));
        if (ciIDs.size() == 0) {
            return;
        }
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK(databaseIDs);
        IRowSet oneRow = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_BD_MaterialGroup a LEFT JOIN T_BD_material b  ON a.FID = b.FMaterialGroupID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = FSeq + ?").append(" where  (FMaterialID <> ' ' AND FMaterialID is not null) and FMaterialID IN (?)");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append(" SELECT newbosid('12345678') as FID,").append(" FCompanyOrg,cmr.FPeriodNumber,cmr.FCostCenterNumber ,cmr.FCostCenterName,cmr.FCostObjNumber,cmr.FOrderNumber,cmr.FProjectNumber,cmr.FTrackNumber,cmr.FProductNumber,cmr.FProductName,cmr.FCostObjName,cmr.FProductModel,cmr.FProductShortName,cmr.FProductLot,cmr.FUnitName,cmr.FObjQty");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(",cmr.FStatUnitName,cmr.FStatObjQty");
        }
        sumSQL.append(",null,null");
        sumSQL.append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),Sum(isnull(FUnitPercent,0)), 0, 0,cmr.FCostItemID \n ").append(", cmr.FCostItemNumber,cmr.FCostItemName, ci.FTypeTreeID, cmr.FExpenseID,cmr.FExpenseNumber,cmr.FExpenseName, cmr.FCostItemID FCI2,null  \n").append(", max(FQtyPrecision) ");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(", max(FStatQtyPrecision) ");
        }
        sumSQL.append(", max(FConsumeCommonQtyPrecision),max(FConsumeQtyPrecision),max(FConsumeAssistQtyPrecision),max(cmr.FPricePrecision),max(FAmountPrecision) ").append(",cmr.FProductID,null,cmr.FPeriodID,cmr.FDataFromTbl \n").append(" FROM ").append(tmpTblName).append(" AS cmr INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID = ci.FID ").append(" \n WHERE FTotalRow = ? AND FMaterialID IN (?)").append(" GROUP BY FCompanyOrg,cmr.FPeriodNumber,cmr.FCostCenterNumber,cmr.FCostCenterName,cmr.FCostObjNumber,cmr.FOrderNumber,cmr.FProjectNumber,cmr.FTrackNumber,cmr.FProductNumber,cmr.FProductName,cmr.FCostObjName,cmr.FProductModel,cmr.FProductShortName,cmr.FProductLot,cmr.FUnitName,cmr.FObjQty,");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append("cmr.FStatUnitName,cmr.FStatObjQty,");
        }
        sumSQL.append(" cmr.FCostItemID ,cmr.FCostItemNumber,cmr.FCostItemName,ci.FTypeTreeID,cmr.FDataFromTbl,cmr.FExpenseID,cmr.FExpenseNumber,cmr.FExpenseName, cmr.FProductID,cmr.FPeriodID \n");
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" (FID, FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append("FStatUnitName,FStatObjQty,");
        }
        insertTotalSQL.append(" FMatNumber,FMatName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq,FMaterialGroupID , \n").append(" FCostItemNumber,FCostItemName,FCostItemGroupID,FDataFromTbl,FExpenseID,FExpenseNumber,FExpenseName,FCostItemID,FExpenseGroupID,FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",FStatQtyPrecision");
        }
        insertTotalSQL.append(",FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision, FProductID,FMaterialID,FPeriodID,FWhichGroupTotal, FRowBgColor,FIsTotal ) \n").append(" VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?,?,? ");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?,?");
        }
        insertTotalSQL.append(",?,?,?, ?,   ?,?,   ?,?,   ?,?,?,?,?, ?,   ?,?,?,1,?,?,?,?,?, ?,?");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?");
        }
        insertTotalSQL.append(",?,?,?,?, ?,?,?,1,1,-1 )");
        this.updateTempTableForInsertTotalRows(filter, groupLevel, databaseIDs, (IDataBase)iMaterial, -1, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertTotalRowsForExpenseGroupTree(String tmpTblName, RptParams filter, String wheres) throws BOSException, SQLException, EASBizException {
        int groupLevel = Integer.parseInt(filter.getString("spExpenseLevel"));
        IRowSet ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FExpenseID FROM " + tmpTblName + " WHERE FExpenseID is not null and FExpenseID <>' ' "));
        if (ciIDs.size() == 0) {
            return;
        }
        LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
        while (ciIDs.next()) {
            if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
            databaseIDs.add(ciIDs.getString(1));
        }
        int maxLevel = 0;
        StringBuffer allDataIDs = BDCMUtils.splitPK(databaseIDs);
        IRowSet oneRow = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT Max(a.Flevel) FROM T_NCM_ExpenseTree a LEFT JOIN T_NCM_Expense b  ON a.FID = b.FTreeID WHERE b.FID IN (" + allDataIDs.toString() + ")"));
        if (oneRow.next()) {
            maxLevel = oneRow.getInt(1);
        }
        if (maxLevel < groupLevel) {
            groupLevel = maxLevel;
        }
        IExpense iExpense = ExpenseFactory.getLocalInstance((Context)this.getContext());
        StringBuffer updateSeqSQL = new StringBuffer();
        updateSeqSQL.append("UPDATE ").append(tmpTblName).append(" SET FSeq = ?").append(" WHERE FExpenseID IN (?)");
        StringBuffer sumSQL = new StringBuffer();
        sumSQL.append(" SELECT newbosid('12345678') as FID,").append(" FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(",FStatUnitName,FStatObjQty");
        }
        sumSQL.append(",null,null");
        sumSQL.append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),Sum(isnull(FUnitCostAmt,0)),Sum(isnull(FUnitPercent,0)), 0, 0, tmp.FCostItemID \n ").append(", tmp.FCostItemNumber,tmp.FCostItemName,tmp.FCostItemID as FCI2, tmp.FCostItemGroupID, tmp.FDataFromTbl  \n").append(", max(tmp.FQtyPrecision)");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append(", max(tmp.FStatQtyPrecision)");
        }
        sumSQL.append(", max(tmp.FConsumeCommonQtyPrecision),max(tmp.FConsumeQtyPrecision),max(tmp.FConsumeAssistQtyPrecision),max(tmp.FPricePrecision),max(tmp.FAmountPrecision),tmp.FProductID,null,tmp.FPeriodID,tmp.FCostCenterID FROM \n").append(tmpTblName).append(" tmp INNER JOIN T_NCM_Expense ex  ON ex.FID = tmp.FExpenseID").append(" left JOIN T_NCM_ExpenseTree tree  ON tree.FID = ex.FTreeID").append(" WHERE FIsTotal = ? AND tmp.FExpenseID IN (?)").append(" GROUP BY FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,");
        if (this.isShowStatUnit(filter)) {
            sumSQL.append("FStatUnitName,FStatObjQty,");
        }
        sumSQL.append(" tmp.FCostItemID ,tmp.FCostItemNumber,tmp.FCostItemName,tmp.FCostCenterID, tmp.FCostItemGroupID,tmp.FDataFromTbl,tmp.FProductID,tmp.FPeriodID \n");
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(tmpTblName).append(" ( FID,FCompanyOrg,FPeriodNumber,FCostCenterNumber,FCostCenterName,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductModel,FProductShortName,FProductLot,FUnitName,FObjQty,");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append("FStatUnitName,FStatObjQty,");
        }
        insertTotalSQL.append(" FExpenseNumber,FExpenseName,\n").append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FSeq, FExpenseGroupID, \n").append(" FCostItemNumber,FCostItemName, FCostItemID, FCostItemGroupID, FDataFromTbl, FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",FStatQtyPrecision");
        }
        insertTotalSQL.append(",FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision, FProductID,FExpenseID,FPeriodID,FWhichGroupTotal, FRowBgColor, FIsTotal ) \n").append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?,?");
        }
        insertTotalSQL.append(",?,?,?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",?");
        }
        insertTotalSQL.append(", ?,?,?,?,?, ?,?,?,2,1,-1)");
        this.updateTempTableForInsertTotalRows(filter, groupLevel, databaseIDs, (IDataBase)iExpense, 0, updateSeqSQL, insertTotalSQL, sumSQL);
    }

    private void insertCostObjectTotalRow(RptParams filter) throws BOSException {
        StringBuffer insertTotalSQL = new StringBuffer();
        insertTotalSQL.append("INSERT INTO ").append(this.getTablename()).append(" ( FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostObjectID,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductLot,FUnitName,FObjQty,");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append("FStatUnitName,FStatObjQty,");
        }
        insertTotalSQL.append(" FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostAmt,FUnitPercent,FTotalRow,FRowBgColor, FSeq, FDataFromTbl,FWhichGroupTotal,FIsTotal,FIsCostObjectTotal,FPricePrecision ) \n").append("SELECT ").append(" FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostObjectID,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,'").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)this.getContext().getLocale())).append("',FProductLot|| ' ','' FUnitName,max(isnull(FObjQty,0))");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",'' FUnitName,FStatObjQty");
        }
        insertTotalSQL.append(",Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0))").append(",Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)), ").append(" CASE WHEN max(isnull(FObjQty,0))<>0 THEN to_decimal(Sum(isnull(FTotalCostAmt,0)),24,12)/to_decimal(max(isnull(FObjQty,0)),24,12) ELSE 0 END ").append(" ,100 ,20,1,max(FSeq)+ 0.001").append(" , 3, 4,1,1,max(FPricePrecision) \n FROM ").append(this.getTablename()).append(" \n WHERE FIstotal = 0 \n ").append(" GROUP BY ").append(" FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterID,FCostCenterNumber,FCostCenterName,FCostObjectID,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,FCostObjName,FProductLot");
        if (this.isShowStatUnit(filter)) {
            insertTotalSQL.append(",FStatObjQty");
        }
        NCMDbUtil.execute((Context)this.getContext(), (String)insertTotalSQL.toString());
        StringBuffer precision = new StringBuffer();
        precision.append(" UPDATE ").append(this.getTablename()).append("  SET (FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            precision.append(",FStatQtyPrecision");
        }
        precision.append(",FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FAmountPrecision) = ").append(" (SELECT FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            precision.append(",FStatQtyPrecision");
        }
        precision.append(",a,b,c,e FROM ( (SELECT MAX(FQtyPrecision) FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            precision.append(",MAX(FStatQtyPrecision) FStatQtyPrecision");
        }
        precision.append(",MAX(FConsumeCommonQtyPrecision) a,MAX(FConsumeQtyPrecision) b ,MAX(FConsumeAssistQtyPrecision) c  ,MAX(FAmountPrecision) e FROM  \n").append(this.getTablename()).append("   WHERE FTotalRow =-1 or FTotalRow =0) ) as T )\t\t\t\t\t                      \n").append(" WHERE FWhichGroupTotal = 4                                            \t\t\t\t\t  \n");
        NCMDbUtil.execute((Context)this.getContext(), (String)precision.toString());
        StringBuffer update = new StringBuffer();
        update.append(" UPDATE ").append(this.getTablename()).append(" SET FUnitCostAmt").append(" = Round(FUnitCostAmt,FPricePrecision) ");
        NCMDbUtil.execute((Context)this.getContext(), (String)update.toString());
        StringBuffer difference = new StringBuffer();
        difference.append("    (select 100 - Sum(FUnitPercent) from ").append(this.getTablename()).append("      where FTotalRow = 0 or FTotalRow = -1 group by FCostCenterID,FCostObjectID ) ");
        BigDecimal diff = SysConstant.BIGZERO;
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)difference.toString());
        try {
            if (rs.next()) {
                diff = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer adjust = new StringBuffer();
        adjust.append(" UPDATE ").append(this.getTablename()).append(" SET FUnitPercent = FUnitPercent + ?  \n ").append(" WHERE FID =                                                                \n").append(" (select top 1 FID from ").append(this.getTablename()).append("                  \n").append(" where FTotalRow = 0  order by FUnitPercent desc )                          \n");
        NCMDbUtil.execute((Context)this.getContext(), (String)adjust.toString(), (Object[])new BigDecimal[]{diff});
    }

    private void insertCostCenterTotalRow(String tableName, RptParams filter) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO ");
        sb.append(tableName);
        sb.append("   ( FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterNumber,FCostCenterName,\n");
        sb.append("   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ");
        sb.append("   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitPercent, \n");
        sb.append("   FTotalRow,FRowBgColor, FSeq, FDataFromTbl,FWhichGroupTotal,FIsTotal,FIsCostCenterTotal, \n");
        sb.append("   FQtyPrecision,");
        if (this.isShowStatUnit(filter)) {
            sb.append("FStatQtyPrecision,");
        }
        sb.append(" FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision)");
        sb.append(" SELECT FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterNumber,'");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)this.getContext().getLocale()));
        sb.append("  ',Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0)) \n");
        sb.append("  ,Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),");
        sb.append(" 100 ,20,1,max(FSeq)+ 0.001, 3, 5, 1, 1, \n ");
        sb.append("   max(FQtyPrecision),");
        if (this.isShowStatUnit(filter)) {
            sb.append("max(FStatQtyPrecision),");
        }
        sb.append(" max(FConsumeCommonQtyPrecision),max(FConsumeQtyPrecision),max(FConsumeAssistQtyPrecision),max(FPricePrecision),max(FAmountPrecision) From \n");
        sb.append(tableName);
        sb.append(" \n WHERE FIstotal = 0 \n ");
        sb.append(" GROUP BY ");
        sb.append(" FCompanyOrg,FPeriodID,FPeriodNumber,FCostCenterNumber \n\n;");
        sb.append(" INSERT INTO ");
        sb.append(tableName);
        sb.append("   ( FCompanyOrg,FPeriodID,FPeriodNumber, \n");
        sb.append("   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ");
        sb.append("   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitPercent, \n");
        sb.append("   FTotalRow,FRowBgColor, FSeq, FDataFromTbl,FWhichGroupTotal, FIsTotal, FIsPeriodTotal, \n");
        sb.append("   FQtyPrecision,");
        if (this.isShowStatUnit(filter)) {
            sb.append("FStatQtyPrecision,");
        }
        sb.append(" FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision)");
        sb.append(" SELECT FCompanyOrg,FPeriodID,FPeriodNumber || '  ");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)this.getContext().getLocale()));
        sb.append("  ',Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0)) \n");
        sb.append("  ,Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),");
        sb.append(" 100 ,20,1,max(FSeq)+ 0.001, 3, 6, 1, 1, \n");
        sb.append("   max(FQtyPrecision),");
        if (this.isShowStatUnit(filter)) {
            sb.append("max(FStatQtyPrecision),");
        }
        sb.append(" max(FConsumeCommonQtyPrecision),max(FConsumeQtyPrecision),max(FConsumeAssistQtyPrecision),max(FPricePrecision),max(FAmountPrecision) From \n");
        sb.append(tableName);
        sb.append(" \n WHERE FIstotal = 0 \n ");
        sb.append(" GROUP BY ");
        sb.append(" FCompanyOrg,FPeriodID,FPeriodNumber \n\n;");
        sb.append(" INSERT INTO ");
        sb.append(tableName);
        sb.append("   ( FCompanyOrg,FPeriodNumber, \n");
        sb.append("   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ");
        sb.append("   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitPercent, \n");
        sb.append("   FTotalRow,FRowBgColor, FSeq, FDataFromTbl,FWhichGroupTotal, FIsTotal, FIsPeriodTotal,FIsTotalRow, \n");
        sb.append("   FQtyPrecision,");
        if (this.isShowStatUnit(filter)) {
            sb.append("FStatQtyPrecision,");
        }
        sb.append(" FConsumeCommonQtyPrecision,FConsumeQtyPrecision,FConsumeAssistQtyPrecision,FPricePrecision,FAmountPrecision)");
        sb.append(" SELECT FCompanyOrg, '");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)this.getContext().getLocale()));
        sb.append("  ',Sum(isnull(FTotalConsumeCommonQty,0)),Sum(isnull(FTotalConsumeQty,0)),Sum(isnull(FTotalConsumeAssistQty,0)),Sum(isnull(FTotalCostAmt,0)) \n");
        sb.append("  ,Sum(isnull(FUnitConsumeCommonQty,0)),Sum(isnull(FUnitConsumeQty,0)),Sum(isnull(FUnitConsumeAssistQty,0)),");
        sb.append(" 100 ,20,5,max(FSeq)+ 0.001, 3, 4, 1, 1, 1, \n");
        sb.append("   max(FQtyPrecision),");
        if (this.isShowStatUnit(filter)) {
            sb.append("max(FStatQtyPrecision),");
        }
        sb.append(" max(FConsumeCommonQtyPrecision),max(FConsumeQtyPrecision),max(FConsumeAssistQtyPrecision),max(FPricePrecision),max(FAmountPrecision) From \n");
        sb.append(tableName);
        sb.append(" \n WHERE FIstotal = 0 \n ");
        sb.append(" GROUP BY ");
        sb.append(" FCompanyOrg \n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException, SQLException {
        int fromPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
        int toPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        String[] physicalTblNames = new String[]{NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_CostCalMatDetailResult", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_CostCalResult", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_Balance", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_BalanceEntry", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_OtherAllocResult", (int)fromPeriod, (int)toPeriod), NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_AllDataByCostObj", (int)fromPeriod, (int)toPeriod)};
        return physicalTblNames;
    }

    private String createTmpTableSQL(RptParams filter) throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FID varchar(44) ");
        createTable.append(",FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FOrderNumber varchar(80) default(' ')");
        createTable.append(",FProjectNumber varchar(80) default(' ')");
        createTable.append(",FTrackNumber varchar(80) default(' ')");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductID varchar(44) ");
        createTable.append(",FProductNumber varchar(80) default(' ')");
        createTable.append(",FProductName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(255) ");
        createTable.append(",FProductLot nvarchar(255) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FObjQty NUMERIC(21,8) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FCostItemType varchar(44)");
        createTable.append(",FMaterialID varchar(44) ");
        createTable.append(",FMatNumber varchar(80)  default(' ') ");
        createTable.append(",FMatName varchar(255) ");
        createTable.append(",FMatModel nvarchar(255) ");
        createTable.append(",FMatShortName nvarchar(255) ");
        createTable.append(",FMatLot nvarchar(80) ");
        createTable.append(",FMatCommonUnitName varchar(255) ");
        createTable.append(",FMatUnitName varchar(255) ");
        createTable.append(",FMatAssistUnitName varchar(255) ");
        createTable.append(",FExpenseID varchar(44) ");
        createTable.append(",FExpenseNumber nvarchar(80)  ");
        createTable.append(",FExpenseName nvarchar(255) ");
        createTable.append(",FTotalConsumeCommonQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalConsumeQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalConsumeAssistQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeCommonQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitConsumeAssistQty NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitCostPrice NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FTotalUnitCostAmt NUMERIC(23,10) DEFAULT 0");
        createTable.append(",FUnitPercent NUMERIC(23,2) DEFAULT 0");
        createTable.append(",FTotalRow decimal(5,3) DEFAULT 0 ");
        createTable.append(",FRowBgColor decimal(5,3) DEFAULT 0 ");
        createTable.append(",FSeq NUMERIC(23,10) NOT NULL DEFAULT 0 ");
        createTable.append(",FCostItemGroupID varchar(44) ");
        createTable.append(",FMaterialGroupID varchar(44) ");
        createTable.append(",FExpenseGroupID varchar(44) ");
        createTable.append(",FQtyPrecision int default(0) ");
        createTable.append(",FConsumeCommonQtyPrecision int default(4) ");
        createTable.append(",FConsumeQtyPrecision int default(4) ");
        createTable.append(",FConsumeAssistQtyPrecision int default(4) ");
        createTable.append(",FPricePrecision int default(2) ");
        createTable.append(",FAmountPrecision int default(3) ");
        createTable.append(",FLongMaterialID varchar(440) ");
        createTable.append(",FDataFromTbl int default(0) ");
        createTable.append(",FWhichGroupTotal int default(0) ");
        createTable.append(",FIsTotal int default(0) ");
        createTable.append(",FIsTotaled int default(0) ");
        createTable.append(",FIsUpdateSeq int default(0) ");
        createTable.append(",FIsCostObjectTotal int default(0) ");
        createTable.append(",FIsCostCenterTotal int default(0) ");
        createTable.append(",FIsPeriodTotal int default(0) ");
        createTable.append(",FIsTotalRow int default(0) ");
        createTable.append(",FAllocStdData NUMERIC(24,12) default(0)");
        if (this.isShowStatUnit(filter)) {
            createTable.append(",FStatUnitName varchar(255) ");
            createTable.append(",FStatObjQty NUMERIC(21,8) ");
            createTable.append(",FStatQtyPrecision int default(0) ");
        }
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(sTmpTblName, "FCostCenterID ,FCostObjectID,FProductID", false, false);
            TempTablePool.getInstance((Context)this.getContext()).createIndex(sTmpTblName, "FID", false, false);
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String createTmpTableSQL2() throws BOSException {
        if (this.t_ExpenseFactor != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '").append(this.t_ExpenseFactor).append("'");
            IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
            try {
                if (rs.next()) {
                    sql = new StringBuffer();
                    sql.append("Truncate Table ").append(this.t_ExpenseFactor);
                    NCMDbUtil.execute((Context)this.getContext(), (String)sql.toString());
                    return this.t_ExpenseFactor;
                }
                this.t_ExpenseFactor = null;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer createTable2 = new StringBuffer();
        createTable2.append("create table tmp_MatCostCalcReport( ");
        createTable2.append(" FID varchar(44) ");
        createTable2.append(",FCostCenterID varchar(44) ");
        createTable2.append(",FCostObjectID varchar(44) ");
        createTable2.append(",FCostItemID varchar(44) ");
        createTable2.append(",FExpenseID varchar(44) ");
        createTable2.append(",FExpenseNumber varchar(80) ");
        createTable2.append(",FExpenseName varchar(255) ");
        createTable2.append(",FAmount NUMERIC(24,12) Default(0),FQty NUMERIC(24,12) Default(0) ");
        createTable2.append(",FRatio NUMERIC(24,12) Default(0),FRatioSum NUMERIC(24,12) Default(0) ");
        createTable2.append(",FAllocStdData NUMERIC(24,12) Default(0),FPeriodID varchar(44) ) ");
        try {
            String sTmpTblName;
            this.t_ExpenseFactor = sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable2.toString());
            this.getContext().put((Object)"createTable2", (Object)sTmpTblName);
            return sTmpTblName;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void dropTempTable(String reportID, RptParams filter, String tableName) throws BaseException {
        super.dropTempTable(reportID, filter, tableName);
        if (this.t_ExpenseFactor != null) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.t_ExpenseFactor);
        }
    }

    private String getSQL(RptParams filter, String[] physicalTblNames, String tmpTblName, int amtPrecision, String wheres) {
        Context ctx = this.getContext();
        StringBuffer insert1 = new StringBuffer();
        insert1.append(" INSERT INTO ").append(tmpTblName).append(" \t  (FID, FCompanyOrg,FPeriodID,FPeriodNumber,\n").append("\t   FCostCenterID,FCostCenterNumber,FCostCenterName,\n").append("\t   FCostObjectID,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,\t   FCostObjName,FProductID,FProductModel,FProductShortName,FProductLot,\n");
        insert1.append("\t   FUnitName,FObjQty,\n");
        if (this.isShowStatUnit(filter)) {
            insert1.append("\t   FStatUnitName,FStatObjQty,\n");
        }
        insert1.append("\t   FCostItemID,FCostItemNumber,FCostItemName,FCostItemType,\n").append("\t   FMaterialID,FMatNumber,FMatName,FMatLot,FMatModel,FMatShortName,FMatUnitName,FMatAssistUnitName,\n").append("\t   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" \t   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt,FUnitPercent  \n").append("\t   ,FTotalRow,FSeq,FCostItemGroupID,FMaterialGroupID  ").append("\t   ,FQtyPrecision ");
        if (this.isShowStatUnit(filter)) {
            insert1.append("\t   ,FStatQtyPrecision ");
        }
        insert1.append("\t   ,FConsumeQtyPrecision,FPricePrecision ,FAmountPrecision ,FLongMaterialID ,      FDataFromTbl, FAllocStdData ) \n");
        StringBuffer insert2 = new StringBuffer();
        insert2.append(" INSERT INTO ").append(tmpTblName).append(" \t  (FID, FCompanyOrg,FPeriodID,FPeriodNumber,\n").append("\t   FCostCenterID,FCostCenterNumber,FCostCenterName,\n").append("\t   FCostObjectID,FCostObjNumber,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName,\t   FCostObjName,FProductID,FProductModel,FProductShortName,FProductLot,\n");
        insert2.append("\t   FUnitName,FObjQty,\n");
        if (this.isShowStatUnit(filter)) {
            insert2.append("\t   FStatUnitName,FStatObjQty,\n");
        }
        insert2.append("\t   FCostItemID,FCostItemNumber,FCostItemName,FCostItemType,\n").append("\t   FMaterialID,FMatNumber,FMatName,FMatLot,FMatModel,FMatShortName,FMatUnitName,FMatAssistUnitName,\n").append("\t   FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ").append(" \t   FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,FUnitCostAmt,FUnitPercent  \n").append("\t   ,FTotalRow,FSeq,FCostItemGroupID,FMaterialGroupID  ").append("\t   ,FQtyPrecision ");
        if (this.isShowStatUnit(filter)) {
            insert2.append("\t   ,FStatQtyPrecision ");
        }
        insert2.append("\t   ,FConsumeQtyPrecision,FPricePrecision ,FAmountPrecision ,FLongMaterialID ,      FDataFromTbl, FAllocStdData ) \n");
        StringBuffer calMaterialResult = new StringBuffer();
        calMaterialResult.append(" SELECT newbosid('12345678') FID, cpr.FCompanyID FCompanyOrg,cpr.FCalculatePeriodID FPeriodID \n").append("\t\t\t\t ,to_char(prd.FNumber)  FPeriodNumber,                       \n").append("       cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_" + ctx.getLocale() + " FCostCenterName,        \n  ").append("       co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FOrderNumber FOrderNumber,\t\tpo.FNumber as FProjectNumber,tr.FNumber as FTrackNumber,pro.FNumber as FProductNumber,pro.FName_" + ctx.getLocale() + " as FProductName, co.FName_" + ctx.getLocale() + " FCostObjName,mat2.FID FProductID,       mat2.FModel FProductModel,mat2.FShortName FProductShortName,co.FBatchNumber FProductLot, \n  ").append("\t    mu2.FName_" + ctx.getLocale() + " FUnitName,isnull(cpr.FTotalFinishedQty,0) FObjQty,           \n");
        if (this.isShowStatUnit(filter)) {
            calMaterialResult.append("\t    smu.FName_" + ctx.getLocale() + " FStatUnitName, (case when mmu.FBaseConvsRate = 0 then isnull(cpr.FTotalFinishedQty,0) else (isnull(cpr.FTotalFinishedQty,0) / smmu.FBaseConvsRate) end)  FStatObjQty,    \n");
        }
        calMaterialResult.append("       ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_" + ctx.getLocale() + " FCostItemName,ci.FItemType FCostItemType,                                     \n  ").append("       cmr.FMaterialID FMaterialID,mat.FNumber FMatNumber,mat.FName_" + ctx.getLocale() + " FMatName,                          \n  ").append("       cmr.FLot FMatLot,mat.FModel FMatModel,mat.FShortName FMatShortName,mu.FName_" + ctx.getLocale() + " FMatUnitName,        assmu.FName_" + ctx.getLocale() + " FMatAssistUnitName,                                   \n  ").append("       isnull(cmr.FFinishedAddqty,0) FTotalConsumeCommonQty,                           \n  ").append("       isnull(cmr.FFinishedQty,0) FTotalConsumeQty,                           \n  ").append("       isnull(cmr.FFinishedAssistQty,0) FTotalConsumeAssistQty,                           \n  ").append("       isnull(cmr.FFinishedAmount,0) FTotalCostAmt,                     \n  ").append("       0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice,0 FUnitCostAmt,       0 FUnitPercent, -1 FTotalRow,0 FSeq,                                           \n ").append("\t\t\t ci.FTypeTreeID FCostItemGroupID,mat.FMaterialGroupID FMaterialGroupID,                        \n  ").append("\t\t\t mmu2.FQtyPrecision FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            calMaterialResult.append("\t   ,smmu.FQtyPrecision FStatQtyPrecision");
        }
        calMaterialResult.append(",mmu.FQtyPrecision FConsumeQtyPrecision,mat2.FPricePrecision FPricePrecision, \t\t\t\t\t\t\t   ").append(amtPrecision).append(" FAmountPrecision , ' ' FLongMaterialID, 1 FDataFromTbl, 1 FAllocStdData  \n ").append(" FROM ").append(physicalTblNames[0]).append(" cmr \n");
        StringBuffer join1 = new StringBuffer();
        join1.append(" INNER JOIN ").append(physicalTblNames[1]).append(" cpr \n").append(" ON cmr.FCompanyID = cpr.FCompanyID and cmr.FCalculatePeriodID = cpr.FCalculatePeriodID and ").append(" cmr.FCostCenterID =cpr.FCostCenterID and cmr.FCostItemID = cpr.FCostItemID and cmr.FCostObjectID = cpr.FCostObjectID ").append(" INNER JOIN T_BD_Period prd on cmr.FCalculatePeriodID = prd.FID                                    \n ").append(" INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID            \t\t\t\t\t\t    \n ").append(" INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID                                               \n").append(" INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID)   \n").append(" left join t_mm_project po on po.FID = co.FProjectID \n").append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n").append(" left join t_bd_material pro on pro.FID = co.FStdProductIDID \n").append(" INNER JOIN T_BD_Material mat on cmr.FMaterialID = mat.FID                                          \n ").append(" INNER JOIN t_bd_multiMeasureUnit mmu on mat.fid = mmu.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu on mmu.FMeasureUnitID = mu.FID    and mat.FBaseUnit=mu.fid          \n").append(" left JOIN T_BD_MeasureUnit mu3 on mmu.FMeasureUnitID = mu3.FID   and mat.FAssistUnit=mu.fid     \n").append(" INNER JOIN T_BD_Material mat2 on cpr.FProductID = mat2.FID  and cpr.fproductid = co.frelatedid                  \n ");
        if (this.isShowStatUnit(filter)) {
            join1.append(" left join t_bd_multiMeasureUnit smmu on smmu.FMaterialID = mat2.FID and smmu.FIsStatUnit = 1 \n");
            join1.append(" left join T_BD_MeasureUnit smu on smu.FID = smmu.FMeasureUnitID \n");
        }
        join1.append(" INNER JOIN t_bd_multiMeasureUnit mmu2 on mat2.fid = mmu2.FMaterialID   \n ").append(" INNER JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID and mat2.FBaseUnit=mu2.fid        \n");
        StringBuffer Where = new StringBuffer();
        NCMReportHelper.AppendPredicate(ctx, Where, filter, true, "prd.FNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "cc.FNumber", ">=", "costCenterFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "cc.FNumber", "<=", "costCenterTo");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "ci.FNumber", ">=", "costItemFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "ci.FNumber", "<=", "costItemTo");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FNumber", ">=", "costObjectFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FNumber", "<=", "costObjectTo");
        if (filter.getObject("prmtOrderNumberFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FOrderNumber", ">=", "prmtOrderNumberFrom");
        } else if (filter.getString("orderNumberFrom") != null) {
            Where.append(" and co.FOrderNumber >= '" + filter.getString("orderNumberFrom") + "'");
        }
        if (filter.getObject("prmtOrderNumberTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FOrderNumber", "<=", "prmtOrderNumberTo");
        } else if (filter.getString("orderNumberTo") != null) {
            Where.append(" and co.FOrderNumber <= '" + filter.getString("orderNumberTo") + "'");
        }
        if (filter.getObject("txtBatchFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        } else if (filter.getString("batchNumberFrom") != null) {
            Where.append(" and co.FBatchNumber >= '" + filter.getString("batchNumberFrom") + "'");
        }
        if (filter.getObject("txtBatchTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        } else if (filter.getString("batchNumberTo") != null) {
            Where.append(" and co.FBatchNumber <= '" + filter.getString("batchNumberTo") + "'");
        }
        if (filter.getObject("prmtProjectFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "po.FNumber", ">=", "prmtProjectFrom");
        } else if (filter.getString("projectNumberFrom") != null) {
            Where.append(" and po.FNumber >= '" + filter.getString("projectNumberFrom") + "'");
        }
        if (filter.getObject("prmtProjectTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "po.FNumber", "<=", "prmtProjectTo");
        } else if (filter.getString("projectNumberTo") != null) {
            Where.append(" and po.FNumber <= '" + filter.getString("projectNumberTo") + "'");
        }
        if (filter.getObject("prmtTrackFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "tr.FNumber", ">=", "prmtTrackFrom");
        } else if (filter.getString("trackNumberFrom") != null) {
            Where.append(" and tr.FNumber >= '" + filter.getString("trackNumberFrom") + "'");
        }
        if (filter.getObject("prmtTrackTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "tr.FNumber", "<=", "prmtTrackTo");
        } else if (filter.getString("trackNumberTo") != null) {
            Where.append(" and tr.FNumber <= '" + filter.getString("trackNumberTo") + "'");
        }
        if (filter.getObject("prmtProductFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "pro.FNumber", ">=", "prmtProductFrom");
        } else if (filter.getString("productFrom") != null) {
            Where.append(" and pro.FNumber >= '" + filter.getString("productFrom") + "'");
        }
        if (filter.getObject("prmtProductTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "pro.FNumber", "<=", "prmtProductTo");
        } else if (filter.getString("productTo") != null) {
            Where.append(" and pro.FNumber <= '" + filter.getString("productTo") + "'");
        }
        StringBuffer calProductResult = new StringBuffer();
        calProductResult.append(" SELECT newbosid('12345678')  FID, cmr.FCompanyID FCompanyOrg,cmr.FCalculatePeriodID FPeriodID  \n").append("\t\t\t\t ,to_char(prd.FNumber) FPeriodNumber,                          \n").append("       cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_" + ctx.getLocale() + " FCostCenterName,          \n").append("       co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FOrderNumber FOrderNumber, \n").append("       po.FNumber as FProjectNumber, \n").append("       tr.FNumber as FTrackNumber, \n").append("       pro.FNumber FProductNumber,pro.FName_" + ctx.getLocale() + " FProductName, co.FName_" + ctx.getLocale() + " FCostObjName,cmr.FProductID FProductID,       mat.FModel FProductModel,mat.FShortName FProductShortName,co.FBatchNumber FProductLot, mu2.FName_" + ctx.getLocale() + " FUnitName, \n").append("       isnull(cmr.FTotalFinishedQty,0) FObjQty,                          \n");
        if (this.isShowStatUnit(filter)) {
            calProductResult.append("\t    smu.FName_" + ctx.getLocale() + " FStatUnitName, (case when smmu.FBaseConvsRate = 0 then isnull(cmr.FTotalFinishedQty,0) else (isnull(cmr.FTotalFinishedQty,0) / smmu.FBaseConvsRate) end) FStatObjQty,    \n");
        }
        calProductResult.append("       ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_" + ctx.getLocale() + " FCostItemName,ci.FItemType FCostItemType,                               \n").append("      ' ' FMaterialID,N' ' FMatNumber,N' ' FMatName, N' ' FMatLot,N' ' FMatModel,N' ' FMatShortName,      N' ' FMatUnitName, N' ' FMatAssistUnitName,                                                     \n").append("       0 FTotalConsumeCommonQty,                               \n").append("       isnull(cmr.FFinishedQty,0) FTotalConsumeQty,                               \n").append("       0 FTotalConsumeAssistQty,                               \n").append("       isnull(cmr.FFinishedAmount,0) FTotalCostAmt,                         \n").append("       0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice,       0 FUnitCostAmt,0 FUnitPercent,0 FTotalRow,0 FSeq,                                                              \n").append("\t\t\t ci.FTypeTreeID FCostItemGroupID ,mat.FMaterialGroupID FMaterialGroupID,                            \n").append("\t   mmu2.FQtyPrecision FQtyPrecision");
        if (this.isShowStatUnit(filter)) {
            calProductResult.append("\t   ,smmu.FQtyPrecision FStatQtyPrecision");
        }
        calProductResult.append(",CASE WHEN ci.FUnitID is null THEN mmu2.FQtyPrecision       ELSE mu.FQtyPrecision END FConsumeQtyPrecision,").append("\t  CASE WHEN isnull(mat.FPricePrecision,0) =0 THEN ci.FPricePrecision ELSE mat.FPricePrecision      END FPricePrecision,").append(amtPrecision).append(" FAmountPrecision  , ' ' FLongMaterialID ,-1 FDataFromTbl, cmr.FAllocStdData  \n ").append(" FROM ").append(physicalTblNames[1]).append(" cmr \n");
        StringBuffer join2 = new StringBuffer();
        join2.append(" INNER JOIN T_BD_Period prd on cmr.FCalculatePeriodID = prd.FID                                   \n ").append(" INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID            \t\t\t\t\t\t   \n ").append(" INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID and ci.FItemType <> '1' ").append(" LEFT OUTER JOIN T_BD_MeasureUnit mu on ci.FUnitID = mu.FID                                       \n").append(" INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID) \n").append(" left join t_mm_project po on po.FID = co.FProjectID \n").append(" left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n").append(" left join t_bd_material pro on pro.FID = co.FStdProductIDID \n").append(" INNER JOIN T_BD_Material mat on cmr.FProductID = mat.FID and cmr.fproductid = co.frelatedid                         \n ");
        if (this.isShowStatUnit(filter)) {
            join2.append(" left join t_bd_multiMeasureUnit smmu on smmu.FMaterialID = mat.FID and smmu.FIsStatUnit = 1 \n");
            join2.append(" left join T_BD_MeasureUnit smu on smu.FID = smmu.FMeasureUnitID \n");
        }
        join2.append(" INNER JOIN t_bd_multiMeasureUnit mmu2 on mat.fid = mmu2.FMaterialID   \t\t\t\t\t\t   \n ").append(" INNER JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID   and mat.FBaseUnit=mu2.fid     \n");
        String sql = insert1.append(calProductResult).append(join2).append(Where).append("; \n").append(insert2).append(calMaterialResult).append(join1).append(Where).append(" AND cmr.FMaterialID is not null; \n").toString();
        return sql;
    }

    private String getInittempTblData(RptParams filter, String[] physicalTblNames, String tmpTblName, int amtPrecision, String wheres) {
        Context ctx = this.getContext();
        StringBuffer insertPrdData = new StringBuffer();
        insertPrdData.append(" INSERT INTO ").append(tmpTblName).append(" \n");
        insertPrdData.append("       (FID, FCompanyOrg,FPeriodID,FPeriodNumber,\n");
        insertPrdData.append("        FCostCenterID,FCostCenterNumber,FCostCenterName,\n");
        insertPrdData.append("        FCostObjectID,FCostObjNumber,FCostObjName, \n");
        insertPrdData.append("        FProductID,FProductNumber,FProductName, \n");
        insertPrdData.append("        FProductModel,FProductShortName,FProductLot, \n");
        insertPrdData.append("        FOrderNumber,FProjectNumber,FTrackNumber,\n");
        insertPrdData.append("        FCostItemID,FCostItemNumber,FCostItemName,FCostItemType,\n");
        insertPrdData.append("        FMaterialID,FMatNumber,FMatName,FMatLot,\n");
        insertPrdData.append("        FMatModel,FMatShortName,FMatUnitName,FMatAssistUnitName, ");
        insertPrdData.append("        FUnitName,FObjQty,\n");
        if (this.isShowStatUnit(filter)) {
            insertPrdData.append("         FStatUnitName,FStatObjQty,\n");
        }
        insertPrdData.append("        FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ");
        insertPrdData.append("        FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,  \n");
        insertPrdData.append("        FUnitCostAmt,FUnitPercent,FTotalRow,FSeq, \n");
        insertPrdData.append("        FCostItemGroupID,FMaterialGroupID,FQtyPrecision, ");
        if (this.isShowStatUnit(filter)) {
            insertPrdData.append("        FStatQtyPrecision, ");
        }
        insertPrdData.append("        FConsumeQtyPrecision, \n");
        insertPrdData.append("        FPricePrecision , \n");
        insertPrdData.append("        FAmountPrecision ,FLongMaterialID ,FDataFromTbl ) \n");
        insertPrdData.append(" SELECT newbosid('12345678')  FID, cmr.FCompanyID FCompanyOrg, cmr.FCalculatePeriodID FPeriodID,to_char(prd.FNumber) FPeriodNumber, \n");
        insertPrdData.append("        cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_" + ctx.getLocale() + " FCostCenterName,          \n");
        insertPrdData.append("        co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FName_" + ctx.getLocale() + " FCostObjName,\n");
        insertPrdData.append("        co.FStdProductIDID FProductID,pro.FNumber FProductNumber,pro.FName_" + ctx.getLocale() + " FProductName,");
        insertPrdData.append("        pro.FModel FProductModel,pro.FShortName FProductShortName,co.FBatchNumber FProductLot, ");
        insertPrdData.append("        co.FOrderNumber FOrderNumber, po.FNumber as FProjectNumber,tr.FNumber as FTrackNumber,  \n");
        insertPrdData.append("        ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_" + ctx.getLocale() + " FCostItemName,ci.FItemType FCostItemType, \n");
        insertPrdData.append("        ' ' FMaterialID,N' ' FMatNumber,N' ' FMatName, N' ' FMatLot, \n");
        insertPrdData.append("        N' ' FMatModel,N' ' FMatShortName,N' ' FMatUnitName, N' ' FMatAssistUnitName,\n");
        insertPrdData.append("        mu2.FName_" + ctx.getLocale() + " FUnitName,isnull(coData.FFinishedQty,0) FObjQty, \n");
        if (this.isShowStatUnit(filter)) {
            insertPrdData.append("       smu.FName_" + ctx.getLocale() + " FStatUnitName, (case when smmu.FBaseConvsRate = 0 then isnull(coData.FFinishedQty,0) else (isnull(coData.FFinishedQty,0) / smmu.FBaseConvsRate) end) FStatObjQty,    \n");
        }
        insertPrdData.append("        0 FTotalConsumeCommonQty,isnull(cmr.FFinishedQty,0)-isnull(matData.FFinishedQty,0) FTotalConsumeQty, 0 FTotalConsumeAssistQty,isnull(cmr.FFinishedAmount,0)-isnull(matData.FFinishedAmount,0) FTotalCostAmt, \n");
        insertPrdData.append("        0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice, \n");
        insertPrdData.append("        0 FUnitCostAmt,0 FUnitPercent,0 FTotalRow,0 FSeq, \n");
        insertPrdData.append("        ci.FTypeTreeID FCostItemGroupID ,pro.FMaterialGroupID FMaterialGroupID, mmu2.FQtyPrecision FQtyPrecision, \n");
        if (this.isShowStatUnit(filter)) {
            insertPrdData.append("        smmu.FQtyPrecision FStatQtyPrecision, \n");
        }
        insertPrdData.append("        CASE WHEN ci.FUnitID is null THEN mmu2.FQtyPrecision ELSE mu.FQtyPrecision END FConsumeQtyPrecision, \n");
        insertPrdData.append("        CASE WHEN isnull(pro.FPricePrecision,0) =0 THEN ci.FPricePrecision ELSE pro.FPricePrecision END FPricePrecision, \n");
        insertPrdData.append("        " + amtPrecision + " FAmountPrecision  , ' ' FLongMaterialID ,-1 FDataFromTbl  \n ");
        insertPrdData.append(" FROM ").append(physicalTblNames[1]).append(" cmr \n");
        insertPrdData.append("   INNER Join ").append(physicalTblNames[6]).append(" coData \n");
        insertPrdData.append("      ON cmr.FCalculatePeriodID = coData.FCalculatePeriodID AND cmr.FCostCenterID = coData.FCostCenterID AND cmr.FCostObjectID = coData.FCostObjectID \n");
        insertPrdData.append("   LEFT JOIN (SELECT FCalculatePeriodID,FCOSTCENTERID,FCOSTOBJECTID,FCOSTITEMID, \n");
        insertPrdData.append("                     SUM(ISNULL(FFinishedQty,0)) FFinishedQty, \n");
        insertPrdData.append("                     SUM(ISNULL(FFinishedAmount,0)) FFinishedAmount \n");
        insertPrdData.append("              From ").append(physicalTblNames[0]).append(" \n");
        insertPrdData.append("              Group by FCalculatePeriodID,FCOSTCENTERID,FCOSTOBJECTID,FCOSTITEMID \n");
        insertPrdData.append("              ) matData on matData.FCalculatePeriodID = cmr.FCalculatePeriodID \n");
        insertPrdData.append("                          and matData.FCostCenterID = cmr.FCostCenterID \n");
        insertPrdData.append("                          and matData.FCostObjectID = cmr.FCostObjectID \n");
        insertPrdData.append("                          and matData.FCostItemID = cmr.FCostItemID \n");
        insertPrdData.append("   INNER JOIN T_BD_Period prd on cmr.FCalculatePeriodID = prd.FID \n ");
        insertPrdData.append("   INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID \n ");
        insertPrdData.append("   INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID  ");
        insertPrdData.append("   Left OUTER JOIN T_BD_MeasureUnit mu on ci.FUnitID = mu.FID\n");
        insertPrdData.append("   INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID) \n");
        insertPrdData.append("   left join t_mm_project po on po.FID = co.FProjectID \n");
        insertPrdData.append("   left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
        insertPrdData.append("   left join t_bd_material pro on pro.FID = co.FStdProductIDID \n");
        if (this.isShowStatUnit(filter)) {
            insertPrdData.append("   left join t_bd_multiMeasureUnit smmu on smmu.FMaterialID = pro.FID and smmu.FIsStatUnit = 1 \n");
            insertPrdData.append("   left join T_BD_MeasureUnit smu on smu.FID = smmu.FMeasureUnitID \n");
        }
        insertPrdData.append("   Left JOIN t_bd_multiMeasureUnit mmu2 on pro.fid = mmu2.FMaterialID and pro.FBaseUnit=mmu2.FMeasureUnitID                        \n ");
        insertPrdData.append("   Left JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID   and pro.FBaseUnit=mu2.fid     \n");
        insertPrdData.append(" where (isnull(coData.FFinishedQty,0) <> 0 and (isnull(cmr.FFinishedQty,0)-isnull(matData.FFinishedQty,0) <> 0 or isnull(cmr.FFinishedAmount,0)-isnull(matData.FFinishedAmount,0) <> 0 )) " + this.getWhereSql(filter));
        insertPrdData.append("; \n\n");
        StringBuffer insertMatData = new StringBuffer();
        insertMatData.append(" INSERT INTO ").append(tmpTblName).append(" \n");
        insertMatData.append("     (FID, FCompanyOrg,FPeriodID,FPeriodNumber,\n");
        insertMatData.append("      FCostCenterID,FCostCenterNumber,FCostCenterName,\n");
        insertMatData.append("      FCostObjectID,FCostObjNumber,FCostObjName, \n");
        insertMatData.append("      FProductID,FProductNumber,FProductName,FProductModel,FProductShortName,FProductLot, \n");
        insertMatData.append("      FOrderNumber,FProjectNumber,FTrackNumber,\n");
        insertMatData.append("      FCostItemID,FCostItemNumber,FCostItemName,FCostItemType,\n");
        insertMatData.append("      FMaterialID,FMatNumber,FMatName,FMatLot,\n");
        insertMatData.append("      FMatModel,FMatShortName,FMatUnitName,FMatAssistUnitName, \n");
        insertMatData.append("      FUnitName,FObjQty,\n");
        if (this.isShowStatUnit(filter)) {
            insertMatData.append("       FStatUnitName,FStatObjQty,\n");
        }
        insertMatData.append("      FTotalConsumeCommonQty,FTotalConsumeQty,FTotalConsumeAssistQty,FTotalCostAmt, \n ");
        insertMatData.append("      FUnitConsumeCommonQty,FUnitConsumeQty,FUnitConsumeAssistQty,FUnitCostPrice,  \n");
        insertMatData.append("      FUnitCostAmt,FUnitPercent,FTotalRow,FSeq, \n");
        insertMatData.append("      FCostItemGroupID,FMaterialGroupID,FQtyPrecision, \n");
        if (this.isShowStatUnit(filter)) {
            insertMatData.append("       FStatQtyPrecision, \n");
        }
        insertMatData.append("      FConsumeQtyPrecision,FPricePrecision ,FAmountPrecision ,FLongMaterialID , \n");
        insertMatData.append("      FConsumeCommonQtyPrecision, FConsumeAssistQtyPrecision, \n");
        insertMatData.append("      FDataFromTbl, FAllocStdData ) \n");
        insertMatData.append(" SELECT \n");
        insertMatData.append("      newbosid('12345678') FID, cmr.FCompanyID FCompanyOrg,cmr.FCalculatePeriodID FPeriodID,to_char(prd.FNumber)  FPeriodNumber, \n");
        insertMatData.append("      cc.FID FCostCenterID,cc.FNumber FCostCenterNumber,cc.FName_" + ctx.getLocale() + " FCostCenterName, \n");
        insertMatData.append("      co.FID FCostObjectID,co.FNumber FCostObjNumber,co.FName_" + ctx.getLocale() + " FCostObjName, \n");
        insertMatData.append("      pro.FID FProductID,pro.FNumber as FProductNumber,pro.FName_" + ctx.getLocale() + " as FProductName,pro.FModel FProductModel,pro.FShortName FProductShortName,co.FBatchNumber FProductLot, \n");
        insertMatData.append("      co.FOrderNumber FOrderNumber,po.FNumber as FProjectNumber,tr.FNumber as FTrackNumber, \n  ");
        insertMatData.append("      ci.FID FCostItemID,ci.FNumber FCostItemNumber,ci.FName_" + ctx.getLocale() + " FCostItemName,ci.FItemType FCostItemType, \n");
        insertMatData.append("      cmr.FMaterialID FMaterialID,mat.FNumber FMatNumber,mat.FName_" + ctx.getLocale() + " FMatName,cmr.FLot FMatLot, \n  ");
        insertMatData.append("      mat.FModel FMatModel,mat.FShortName FMatShortName,mu.FName_" + ctx.getLocale() + " FMatUnitName,assmu.FName_" + ctx.getLocale() + " FMatAssistUnitName, \n");
        insertMatData.append("      mu2.FName_" + ctx.getLocale() + " FUnitName,isnull(coData.FFinishedQty,0) FObjQty,           \n");
        if (this.isShowStatUnit(filter)) {
            insertMatData.append("      smu.FName_" + ctx.getLocale() + " FStatUnitName, (case when basemmu.FBaseConvsRate = 0 then isnull(coData.FFinishedQty,0) else (isnull(coData.FFinishedQty,0) / smmu.FBaseConvsRate) end) FStatObjQty, \n");
        }
        insertMatData.append("       isnull(cmr.FFinishedAddqty,0) FTotalConsumeCommonQty, isnull(cmr.FFinishedqty,0) FTotalConsumeQty, isnull(cmr.FFinishedAssistQty,0) FTotalConsumeAssistQty,isnull(cmr.FFinishedAmount,0) FTotalCostAmt, \n");
        insertMatData.append("       0 FUnitConsumeCommonQty,0 FUnitConsumeQty,0 FUnitConsumeAssistQty,0 FUnitCostPrice, \n");
        insertMatData.append("       0 FUnitCostAmt,0 FUnitPercent, -1 FTotalRow,0 FSeq, \n ");
        insertMatData.append("       ci.FTypeTreeID FCostItemGroupID,mat.FMaterialGroupID FMaterialGroupID,mmu2.FQtyPrecision FQtyPrecision, \n");
        if (this.isShowStatUnit(filter)) {
            insertMatData.append("       smmu.FQtyPrecision FStatQtyPrecision, \n");
        }
        insertMatData.append("       basemmu.FQtyPrecision FConsumeQtyPrecision,pro.FPricePrecision FPricePrecision,").append(amtPrecision).append(" FAmountPrecision , ' ' FLongMaterialID, \n");
        insertMatData.append("       basemmu.FQtyPrecision FConsumeCommonQtyPrecision, assmmu.FQtyPrecision FConsumeAssistQtyPrecision, \n");
        insertMatData.append("       1 FDataFromTbl, 1 FAllocStdData  \n ");
        insertMatData.append(" FROM ").append(physicalTblNames[6]).append(" coData \n");
        insertMatData.append("   INNER JOIN ").append(physicalTblNames[0]).append(" cmr \n");
        insertMatData.append("     ON cmr.FCalculatePeriodID = coData.FCalculatePeriodID and ");
        insertMatData.append("        cmr.FCostCenterID =coData.FCostCenterID and cmr.FCostObjectID = coData.FCostObjectID ");
        insertMatData.append("   INNER JOIN T_BD_Period prd on cmr.FCalculatePeriodID = prd.FID                                    \n ");
        insertMatData.append("   INNER JOIN T_ORG_CostCenter cc on cmr.FCostCenterID = cc.FID                                      \n ");
        insertMatData.append("   INNER JOIN T_NCM_CostItem ci on cmr.FCostItemID=ci.FID                                               \n");
        insertMatData.append("   INNER JOIN T_BD_CostObject co on (cmr.FCompanyID = co.FCompanyID and cmr.FCostObjectID = co.FID)   \n");
        insertMatData.append("   left join t_mm_project po on po.FID = co.FProjectID \n");
        insertMatData.append("   left join t_mm_trackNumber tr on tr.FID = co.FTrackID \n");
        insertMatData.append("   left join t_bd_material pro on pro.FID = co.FStdProductIDID \n");
        insertMatData.append("   INNER JOIN T_BD_Material mat on cmr.FMaterialID = mat.FID \n ");
        insertMatData.append("   Left JOIN T_BD_MeasureUnit mu on  mat.FBaseUnit=mu.fid          \n");
        insertMatData.append("   Left JOIN t_bd_multiMeasureUnit basemmu on mat.fid = basemmu.FMaterialID and basemmu.FMeasureUnitID = mu.FID \n ");
        insertMatData.append("   Left JOIN T_BD_MeasureUnit assmu on mat.FAssistUnit=assmu.fid     \n");
        insertMatData.append("   Left JOIN t_bd_multiMeasureUnit assmmu on mat.fid = assmmu.FMaterialID and assmmu.FMeasureUnitID = assmu.FID \n ");
        if (this.isShowStatUnit(filter)) {
            insertMatData.append("   left join t_bd_multiMeasureUnit smmu on smmu.FMaterialID = pro.FID and smmu.FIsStatUnit = 1 \n");
            insertMatData.append("   left join T_BD_MeasureUnit smu on smu.FID = smmu.FMeasureUnitID \n");
        }
        insertMatData.append("   Left JOIN t_bd_multiMeasureUnit mmu2 on pro.fid = mmu2.FMaterialID and  pro.FBaseUnit = mmu2.FMeasureUnitID \n ");
        insertMatData.append("   Left JOIN T_BD_MeasureUnit mu2 on mmu2.FMeasureUnitID = mu2.FID and pro.FBaseUnit=mu2.fid        \n");
        insertMatData.append(" where (isnull(coData.FFinishedQty,0) <> 0 or isnull(cmr.FFinishedQty,0) <> 0 or isnull(cmr.FFinishedAmount,0) <> 0) " + this.getWhereSql(filter));
        insertMatData.append(" AND cmr.FMaterialID is not null; \n");
        return insertPrdData.toString() + insertMatData.toString();
    }

    private StringBuffer getWhereSql(RptParams filter) {
        Context ctx = this.getContext();
        StringBuffer Where = new StringBuffer();
        NCMReportHelper.AppendPredicate(ctx, Where, filter, true, "prd.FNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "cc.FNumber", ">=", "costCenterFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "cc.FNumber", "<=", "costCenterTo");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "ci.FNumber", ">=", "costItemFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "ci.FNumber", "<=", "costItemTo");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FNumber", ">=", "costObjectFrom");
        NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FNumber", "<=", "costObjectTo");
        if (filter.getObject("prmtOrderNumberFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FOrderNumber", ">=", "prmtOrderNumberFrom");
        } else if (filter.getString("orderNumberFrom") != null) {
            Where.append(" and co.FOrderNumber >= '" + filter.getString("orderNumberFrom") + "'");
        }
        if (filter.getObject("prmtOrderNumberTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FOrderNumber", "<=", "prmtOrderNumberTo");
        } else if (filter.getString("orderNumberTo") != null) {
            Where.append(" and co.FOrderNumber <= '" + filter.getString("orderNumberTo") + "'");
        }
        if (filter.getObject("txtBatchFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        } else if (filter.getString("batchNumberFrom") != null) {
            Where.append(" and co.FBatchNumber >= '" + filter.getString("batchNumberFrom") + "'");
        }
        if (filter.getObject("txtBatchTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        } else if (filter.getString("batchNumberTo") != null) {
            Where.append(" and co.FBatchNumber <= '" + filter.getString("batchNumberTo") + "'");
        }
        if (filter.getObject("prmtProjectFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "po.FNumber", ">=", "prmtProjectFrom");
        } else if (filter.getString("projectNumberFrom") != null) {
            Where.append(" and po.FNumber >= '" + filter.getString("projectNumberFrom") + "'");
        }
        if (filter.getObject("prmtProjectTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "po.FNumber", "<=", "prmtProjectTo");
        } else if (filter.getString("projectNumberTo") != null) {
            Where.append(" and po.FNumber <= '" + filter.getString("projectNumberTo") + "'");
        }
        if (filter.getObject("prmtTrackFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "tr.FNumber", ">=", "prmtTrackFrom");
        } else if (filter.getString("trackNumberFrom") != null) {
            Where.append(" and tr.FNumber >= '" + filter.getString("trackNumberFrom") + "'");
        }
        if (filter.getObject("prmtTrackTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "tr.FNumber", "<=", "prmtTrackTo");
        } else if (filter.getString("trackNumberTo") != null) {
            Where.append(" and tr.FNumber <= '" + filter.getString("trackNumberTo") + "'");
        }
        if (filter.getObject("prmtProductFrom") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "pro.FNumber", ">=", "prmtProductFrom");
        } else if (filter.getString("productFrom") != null) {
            Where.append(" and pro.FNumber >= '" + filter.getString("productFrom") + "'");
        }
        if (filter.getObject("prmtProductTo") != null) {
            NCMReportHelper.AppendPredicate(ctx, Where, filter, false, "pro.FNumber", "<=", "prmtProductTo");
        } else if (filter.getString("productTo") != null) {
            Where.append(" and pro.FNumber <= '" + filter.getString("productTo") + "'");
        }
        return Where;
    }

    protected String getORDERBY() {
        return " ORDER BY FIsTotalRow , FPeriodID,FIsPeriodTotal,FCostCenterNumber,FIsCostCenterTotal,FCostObjNumber,FIsCostObjectTotal,FCostItemNumber,FProductID,FSEQ,FIsTotal,FMatNumber";
    }

    private ExpenseInfo getMaterialExpense() throws BOSException {
        ExpenseInfo expenseInfo = null;
        Context ctx = this.getContext();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ExpenseType", (Object)"1", CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.getEntryFilters().add(filter);
        String sql = "select * where expenseType = '1'";
        ExpenseCollection collect = ExpenseFactory.getLocalInstance((Context)ctx).getExpenseCollection(sql);
        if (collect != null) {
            expenseInfo = collect.get(0);
        }
        return expenseInfo;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        String ccFrom = null;
        String ccTo = null;
        ccFrom = filter.getString("CostCenterFrom") != null ? ((CostCenterOrgUnitInfo)filter.getObject("prmtCostCenterFrom")).getName() : filter.getString("costCenterFrom");
        ccTo = filter.getObject("prmtCostCenterTo") != null ? ((CostCenterOrgUnitInfo)filter.getObject("prmtCostCenterTo")).getName() : filter.getString("costCenterTo");
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"112_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, ccFrom, ccTo));
        String coFrom = null;
        String coTo = null;
        coFrom = filter.getObject("prmtCostObjectFrom") != null ? ((CostObjectInfo)filter.getObject("prmtCostObjectFrom")).getName() : filter.getString("costObjectFrom");
        coTo = filter.getObject("prmtCostObjectTo") != null ? ((CostObjectInfo)filter.getObject("prmtCostObjectTo")).getName() : filter.getString("costObjectTo");
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"113_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, coFrom, coTo));
        String ciFrom = null;
        String ciTo = null;
        ciFrom = filter.getObject("prmtCostItemFrom") != null ? ((CostItemInfo)filter.getObject("prmtCostItemFrom")).getName() : filter.getString("costItemFrom");
        ciTo = filter.getObject("prmtCostItemFrom") != null ? ((CostItemInfo)filter.getObject("prmtCostItemTo")).getName() : filter.getString("costItemTo");
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"115_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, ciFrom, ciTo));
        String orderFrom = null;
        String orderTo = null;
        orderFrom = filter.getObject("prmtOrderNumberFrom") != null ? ((ManufactureOrderInfo)filter.getObject("prmtOrderNumberFrom")).getNumber() : filter.getString("orderNumberFrom");
        orderTo = filter.getObject("prmtOrderNumberTo") != null ? ((ManufactureOrderInfo)filter.getObject("prmtOrderNumberTo")).getNumber() : filter.getString("orderNumberTo");
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, orderFrom, orderTo));
        String batchFrom = null;
        String batchTo = null;
        batchFrom = filter.getObject("txtBatchFrom") != null ? filter.getObject("txtBatchFrom").toString() : filter.getString("batchNumberFrom");
        batchTo = filter.getObject("txtBatchTo") != null ? filter.getObject("txtBatchTo").toString() : filter.getString("batchNumberTo");
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, batchFrom, batchTo));
        String projectFrom = null;
        String projectTo = null;
        projectFrom = filter.getObject("prmtProjectFrom") != null ? ((ProjectInfo)filter.getObject("prmtProjectFrom")).getName() : filter.getString("projectNumberFrom");
        projectTo = filter.getObject("prmtProjectTo") != null ? ((ProjectInfo)filter.getObject("prmtProjectTo")).getName() : filter.getString("projectNumberTo");
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, projectFrom, projectTo));
        String trackFrom = null;
        String trackTo = null;
        trackFrom = filter.getObject("prmtTrackFrom") != null ? ((TrackNumberInfo)filter.getObject("prmtTrackFrom")).getName() : filter.getString("trackNumberFrom");
        trackTo = filter.getObject("prmtTrackTo") != null ? ((TrackNumberInfo)filter.getObject("prmtTrackTo")).getName() : filter.getString("trackNumberTo");
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, trackFrom, trackTo));
        String productFrom = null;
        String productTo = null;
        productFrom = filter.getObject("prmtProductFrom") != null ? ((MaterialInfo)filter.getObject("prmtProductFrom")).getName() : filter.getString("productFrom");
        productTo = filter.getObject("prmtProductTo") != null ? ((MaterialInfo)filter.getObject("prmtProductTo")).getName() : filter.getString("productTo");
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_Product", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, productFrom, productTo));
        return titles;
    }

    private void calUnitPercent() throws BOSException {
        Context ctx = this.getContext();
        StringBuffer calUnitPerDet = new StringBuffer();
        calUnitPerDet.append(" UPDATE ").append(this.getTablename()).append(" AS a  \n SET FUnitPercent = 100*FUnitCostAmt/").append("(Select  case when \n (max(FUnitCostAmt) = 0) \n").append("  then 1 \n ").append("else max(FUnitCostAmt) end From ").append(this.getTablename()).append(" temp where temp.FCostCenterID = a.FCostCenterID and temp.FCostObjectID = a.FCostObjectID \n").append(")where a.FWhichGroupTotal in (0,1,2,3)");
        try {
            NCMDbUtil.execute((Context)ctx, (String)calUnitPerDet.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void adjustError(RptParams filter, int whichGroupTotal) throws BOSException {
        int groupLevel;
        Context ctx = this.getContext();
        String groupTreeID = null;
        DataBaseInfo groupInfo = null;
        HashSet<String> dbIDinGroup = null;
        Iterator it = null;
        BigDecimal sumValue = null;
        BigDecimal sumRowValue = null;
        IRowSet ciIDs = null;
        for (int level = groupLevel = Integer.parseInt(filter.getString("spExpenseLevel")); level >= 0; --level) {
            if (whichGroupTotal == 1) {
                ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FCostItemID FROM " + this.getTablename() + " WHERE FCostItemID is not null "));
            }
            if (whichGroupTotal == 0) {
                ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FExpenseID FROM " + this.getTablename() + " WHERE FExpenseID is not null and FExpenseID <>' ' "));
            }
            if (whichGroupTotal == -1) {
                ciIDs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)("SELECT DISTINCT FMaterialID FROM " + this.getTablename() + " WHERE FMaterialID <> ' ' AND  FMaterialID is not null  "));
            }
            if (ciIDs.size() == 0) {
                return;
            }
            LinkedHashSet<String> databaseIDs = new LinkedHashSet<String>(ciIDs.size());
            try {
                while (ciIDs.next()) {
                    if (StringUtils.isEmpty((String)ciIDs.getString(1))) continue;
                    databaseIDs.add(ciIDs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            Map trees = null;
            try {
                if (whichGroupTotal == 1) {
                    ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)this.getContext());
                    trees = iCostItem.transformToTree(databaseIDs, level);
                }
                if (whichGroupTotal == 0) {
                    IExpense iExpense = ExpenseFactory.getLocalInstance((Context)this.getContext());
                    trees = iExpense.transformToTree(databaseIDs, level);
                }
                if (whichGroupTotal == -1) {
                    IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.getContext());
                    trees = iMaterial.transformToTree(databaseIDs, level);
                }
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            Set<Object> groupSet = trees == null ? new HashSet() : trees.keySet();
            HashSet<Object> groupIDSet = new HashSet<Object>();
            Iterator<Object> groupSetIterator = groupSet.iterator();
            while (groupSetIterator.hasNext()) {
                groupIDSet.add(groupSetIterator.next());
            }
            if (groupSet.contains("RootID")) {
                HashSet rootID = (HashSet)trees.get("RootID");
                Iterator rootIDIter = rootID.iterator();
                while (rootIDIter.hasNext()) {
                    groupIDSet.add(rootIDIter.next());
                }
                groupIDSet.remove("RootID");
            }
            it = groupIDSet.iterator();
            HashSet<String> rootIDset = new HashSet<String>();
            while (it.hasNext()) {
                groupTreeID = (String)it.next();
                groupInfo = (DataBaseInfo)BDCMUtils.getObjectValue((Context)this.getContext(), (String)groupTreeID);
                dbIDinGroup = (HashSet<String>)trees.get(groupTreeID);
                if (trees.get(groupTreeID) == null) {
                    rootIDset.clear();
                    rootIDset.add(groupTreeID);
                    dbIDinGroup = rootIDset;
                }
                StringBuffer getSumPercent = new StringBuffer();
                if (whichGroupTotal == 1) {
                    getSumPercent.append(" Select sum(FUnitPercent) from ").append(this.getTablename()).append(" where FTotalRow = 1 AND FCostItemID IN (?) ");
                }
                if (whichGroupTotal == 0) {
                    getSumPercent.append(" Select sum(FUnitPercent) from ").append(this.getTablename()).append(" where FTotalRow = 0 AND FExpenseID IN (?) ");
                }
                if (whichGroupTotal == -1) {
                    getSumPercent.append(" Select sum(FUnitPercent) from ").append(this.getTablename()).append(" where FTotalRow = -1 AND FMaterialID IN (?) ");
                }
                List rsList = NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)getSumPercent.toString(), null, dbIDinGroup);
                IRowSet sumResult = (IRowSet)rsList.get(0);
                try {
                    while (sumResult.next()) {
                        sumValue = sumResult.getBigDecimal(1);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                StringBuffer getSumRowPercent = new StringBuffer();
                if (whichGroupTotal == 1) {
                    getSumRowPercent.append(" select FUnitPercent from ").append(this.getTablename()).append(" where FwhichGrouptotal = 3 and FCostItemID = '").append(groupTreeID).append("'");
                }
                if (whichGroupTotal == 0) {
                    getSumRowPercent.append(" select FUnitPercent from ").append(this.getTablename()).append(" where FwhichGrouptotal = 2 and FExpenseID = '").append(groupTreeID).append("'");
                }
                if (whichGroupTotal == -1) {
                    getSumRowPercent.append(" select FUnitPercent from ").append(this.getTablename()).append(" where FwhichGrouptotal = 1 and FMaterialID = '").append(groupTreeID).append("'");
                }
                IRowSet value = NCMDbUtil.executeQuery((Context)ctx, (String)getSumRowPercent.toString());
                try {
                    while (value.next()) {
                        sumRowValue = value.getBigDecimal(1);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                StringBuffer update = new StringBuffer();
                if (whichGroupTotal == 1) {
                    update.append(" update ").append(this.getTablename()).append(" SET FUnitPercent = ").append(" FUnitPercent + ").append(sumRowValue).append(" - ").append(sumValue).append(" where FID = (Select top 1 FID from ").append(this.getTablename()).append(" where FTotalRow = 1 and FCostItemID in (?) order by FUnitPercent desc)");
                }
                if (whichGroupTotal == 0) {
                    update.append(" update ").append(this.getTablename()).append(" SET FUnitPercent = ").append(" FUnitPercent + ").append(sumRowValue).append(" - ").append(sumValue).append(" where FID = (Select top 1 FID from ").append(this.getTablename()).append(" where FTotalRow = 0 and FExpenseID in (?) order by FUnitPercent desc)");
                }
                if (whichGroupTotal == -1) {
                    update.append(" update ").append(this.getTablename()).append(" SET FUnitPercent = ").append(" FUnitPercent + ").append(sumRowValue).append(" - ").append(sumValue).append(" where FID = (Select top 1 FID from ").append(this.getTablename()).append(" where FTotalRow = -1 and FMaterialID in (?) order by FUnitPercent desc)");
                }
                NCMDbUtil.executeSQLByBatch((Context)this.getContext(), (String)update.toString(), null, dbIDinGroup);
            }
        }
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        return NCMUtils.formatConditions((String)"FRowBgColor");
    }

    private PeriodInfo getBeforPeriod(int period) throws BOSException {
        Context ctx = this.getContext();
        PeriodInfo beforPeriod2 = null;
        String getPeriod = "select * where Number = " + period;
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(getPeriod);
        for (PeriodInfo beforPeriod2 : periodColl) {
        }
        return beforPeriod2;
    }

    private boolean isShowBaseUnit(RptParams filter) {
        Object temp = filter.getObject("rbBaseUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return !this.isShowStatUnit(filter);
    }

    private boolean isShowStatUnit(RptParams filter) {
        Object temp = filter.getObject("rbStatUnit");
        if (temp != null) {
            if (temp instanceof Boolean) {
                return (Boolean)temp;
            }
            if (temp instanceof String) {
                return "true".equalsIgnoreCase((String)temp);
            }
        }
        return false;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        super.getReportHeader(reportID, filter);
        NCMReportHeader reportHeader = new NCMReportHeader();
        ReportHeader subHeader = null;
        Context ctx = this.getContext();
        String resUrl = "com.kingdee.eas.ncm.cal.report.ReportResource";
        Locale locale = ctx.getLocale();
        int index = 0;
        reportHeader.addChild("FPeriodNumber", ResourceBase.getString((String)resUrl, (String)"Common_Period", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostCenterNumber", ResourceBase.getString((String)resUrl, (String)"Common_CostCenter_Number", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)resUrl, (String)"Common_CostCenter_Name", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostObjNumber", ResourceBase.getString((String)resUrl, (String)"Common_CostObject_Number", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostObjName", ResourceBase.getString((String)resUrl, (String)"Common_CostObject_Name", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProductLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BatchNumber", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductNumber", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductName", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProductModel", ResourceBase.getString((String)resUrl, (String)"Common_Product_Model", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FProductShortName", ResourceBase.getString((String)resUrl, (String)"Common_Product_SimpleName", (Locale)locale), true).setAlign(1).setIndex(index++);
        if (this.isShowBaseUnit(filter)) {
            reportHeader.addChild("FUnitName", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_ProductMeasureUnit", (Locale)locale), true).setAlign(1).setWidth(60).setIndex(index++);
        }
        if (this.isShowStatUnit(filter)) {
            reportHeader.addChild("FStatUnitName", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_ProductStatMeasureUnit", (Locale)locale), true).setAlign(1).setIndex(index++);
        }
        if (this.isShowBaseUnit(filter)) {
            subHeader = reportHeader.addChild("FObjQty", ResourceBase.getString((String)resUrl, (String)"Common_Qty", (Locale)locale), true).setAlign(3).setType(2);
            subHeader.setDecimalField("FQtyPrecision");
            subHeader.setIndex(index++);
        }
        if (this.isShowStatUnit(filter)) {
            subHeader = reportHeader.addChild("FStatObjQty", ResourceBase.getString((String)resUrl, (String)"Common_StatQty", (Locale)locale), true).setAlign(3).setType(2);
            subHeader.setDecimalField("FStatQtyPrecision");
            subHeader.setIndex(index++);
        }
        reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)resUrl, (String)"Common_CostItem_Number", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FCostItemName", ResourceBase.getString((String)resUrl, (String)"Common_CostItem_Name", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMatNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMatName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMatModel", ResourceBase.getString((String)resUrl, (String)"Common_Model", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMatShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName_2", (Locale)locale), true).setAlign(1).setIndex(index++);
        reportHeader.addChild("FMatCommonUnitName", ResourceBase.getString((String)resUrl, (String)"Common_MeasureUnit", (Locale)locale), true).setAlign(1).setWidth(36).setIndex(index++);
        reportHeader.addChild("FMatUnitName", ResourceBase.getString((String)resUrl, (String)"Common_BaseMeasureUnit", (Locale)locale), true).setAlign(1).setWidth(52).setIndex(index++);
        reportHeader.addChild("FMatAssistUnitName", ResourceBase.getString((String)resUrl, (String)"Common_AssistMeasureUnit", (Locale)locale), true).setAlign(1).setWidth(48).setIndex(index++);
        reportHeader.addChild("FMatLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_MaterialLot", (Locale)locale), true).setAlign(1).setIndex(index++);
        ReportHeader totalCostHeader = reportHeader.addChild("FTotalCost", ResourceBase.getString((String)resUrl, (String)"Common_TotalCost", (Locale)locale), true).setType(2).setAlign(3);
        totalCostHeader.setIndex(index++);
        subHeader = totalCostHeader.addChild("FTotalConsumeCommonQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_TotalQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeCommonQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = totalCostHeader.addChild("FTotalConsumeQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_BaseTotalQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = totalCostHeader.addChild("FTotalConsumeAssistQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_AssistTotalQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeAssistQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = totalCostHeader.addChild("FTotalCostAmt", ResourceBase.getString((String)resUrl, (String)"Common_Amount", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FAmountPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        ReportHeader unitCostHeader = reportHeader.addChild("FUnitCost", ResourceBase.getString((String)resUrl, (String)"Common_UnitCost", (Locale)locale), true).setAlign(3).setType(2);
        unitCostHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitConsumeCommonQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_UnitQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeCommonQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitConsumeQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_BaseUnitQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitConsumeAssistQty", ResourceBase.getString((String)resUrl, (String)"FinishedProductCostDetailReport_AssistUnitQty", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FConsumeAssistQtyPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitCostPrice", ResourceBase.getString((String)resUrl, (String)"Common_UnitPrice", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FPricePrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitCostAmt", ResourceBase.getString((String)resUrl, (String)"Common_Amount", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FPricePrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        subHeader = unitCostHeader.addChild("FUnitPercent", ResourceBase.getString((String)resUrl, (String)"Common_Percent", (Locale)locale)).setType(2).setAlign(3);
        subHeader.setDecimalField("FAmountPrecision");
        subHeader.setMergeable(false);
        subHeader.setIndex(index++);
        return reportHeader;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        BigDecimal totalRow2 = (BigDecimal)rowData.get("FTOTALROW2");
        if (totalRow2.compareTo(SysConstant.BIGZERO) == 0) {
            RptParams params = new RptParams();
            Object companyorg = totalFilter.getObject("companyOrg");
            if (companyorg == null) {
                companyorg = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            params.setObject("companyorg", companyorg);
            String periodNumer = (String)rowData.get("FPERIODNUMBER");
            String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
            String period = "" + Integer.parseInt(periodNumer.substring(5));
            params.setString("spYearFrom", year);
            params.setString("spYearTo", year);
            params.setString("spPeriodFrom", period);
            params.setString("spPeriodTo", period);
            params.setString("costCenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costCenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costObjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costObjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costItemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costItemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("orderNumberFrom", (String)rowData.get("FOrderNumber"));
            params.setString("orderNumberTo", (String)rowData.get("FOrderNumber"));
            params.setBoolean("chkIsTotalCostItem", true);
            params.setString("spCostItemLevel", "1");
            params.setBoolean("chkIsTotalExpense", true);
            params.setString("spExpenseLevel", "1");
            params.setBoolean("chkIsTotalMaterial", true);
            params.setString("spMaterialLevel", "1");
            params.setBoolean("chkIsDisplayTotalRowsOnly", false);
            params.setString("spCostObjectNum", "1");
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }
}

