/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InitBalanceDetailReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.InitBalanceDetailReport");

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String companyID = info.getId().toString();
        String yearFrom = filter.getObject("spYearFrom").toString();
        String periodFrom = filter.getObject("spPeriodFrom").toString();
        String yearTo = filter.getObject("spYearTo").toString();
        String periodTo = filter.getObject("spPeriodTo").toString();
        String[] physicalTblNames = this.getPhysicalTableName(companyID, yearFrom, periodFrom, yearTo, periodTo);
        Integer nObjCountPerPage = Integer.valueOf(filter.getString("costobjectPerPage"));
        if (nObjCountPerPage <= 0) {
            nObjCountPerPage = 20;
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct t1.FCostObjectID,t5.FNumber FROM ").append(physicalTblNames[0]).append(" t1 ").append("LEFT JOIN ").append(physicalTblNames[1]).append(" t2 on t2.FParentID=t1.FID\n").append("LEFT JOIN ").append(physicalTblNames[2]).append(" t3 on t3.FParentID=t2.FID\n").append("INNER JOIN T_BD_CostObject t5 on t1.FCostObjectID=t5.FID\n").append("INNER JOIN T_ORG_CostCenter t6 on t1.FCostCenterID=t6.FID\n").append("INNER JOIN T_BD_Period t7 on t1.FCalculatePeriodID=t7.FID\n").append("LEFT JOIN T_NCM_CostItem t8 on t2.FCostItemID=t8.FID \n").append("LEFT JOIN T_BD_Material t9 on t3.FMaterialID=t9.FID\n").append("left join t_bd_material mat on mat.FID = t5.FStdProductIDID \n").append("left join t_mm_project po on po.FID = t5.FProjectID \n").append("left join t_mm_trackNumber tr on tr.FID = t5.FTrackID \n").append(" WHERE t1.FCompanyOrg=? \n");
        this.AppendPredicate(sbSQL, filter, true, "t7.FNumber", "", "");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "costobjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "costobjectTo");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(sbSQL, filter, false, "mat.FNumber", ">=", "materialIdFrom");
        this.AppendPredicate(sbSQL, filter, false, "mat.FNumber", "<=", "materialIdTo");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", ">=", "prmtProjectNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", "<=", "prmtProjectNumberTo");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", ">=", "prmtTrackNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", "<=", "prmtTrackNumberTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", ">=", "prmtOrderNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", "<=", "prmtOrderNumberTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", ">=", "txtBatchNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", "<=", "txtBatchNumberTo");
        sbSQL.append("\n ORDER BY t5.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, "costobjectid", "constobjectid", 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            sb.append("'").append(rs.getString("FCostObjectID")).append("',");
            if (i == rs.size() || i % nObjCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString("costobjectid", sb.substring(0, sb.length() - 1).toString());
                drs.insertRow();
                sb = new StringBuffer();
            }
            rs.next();
        }
        if (drs.size() == 0) {
            drs.moveToInsertRow();
            drs.updateString("costobjectid", "'" + BOSUuid.create((String)"39734A77").toString() + "'");
            drs.insertRow();
        }
        return drs;
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String sAlias) {
        sb.append("CASE ").append(sDenominator).append(" WHEN 0 THEN 0 ").append(" ELSE TO_Decimal(").append(sNumerator).append(",21,8)").append("     /TO_Decimal(").append(sDenominator).append(",21,8) END ").append(sAlias);
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String controlUnitId = DefaultCU.getId().toString();
        String lang = ctx.getLocale().getLanguage();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String companyID = info.getId().toString();
        String yearFrom = filter.getObject("spYearFrom").toString();
        String periodFrom = filter.getObject("spPeriodFrom").toString();
        String yearTo = filter.getObject("spYearTo").toString();
        String periodTo = filter.getObject("spPeriodTo").toString();
        String[] physicalTblNames = this.getPhysicalTableName(companyID, yearFrom, periodFrom, yearTo, periodTo);
        String TMP_NCM_InitBalanceDetailReport = null;
        int periodNumberFrom = 0;
        int periodNumberTo = 0;
        try {
            periodNumberFrom = this.getPeriodNumber(companyID, yearFrom, periodFrom);
            periodNumberTo = this.getPeriodNumber(companyID, yearTo, periodTo);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        HashMap objMap = (HashMap)filter.getObject("position");
        StringBuffer kSql = new StringBuffer();
        kSql.append("create table tmp_InitBalanceDetailReport ( ");
        kSql.append("\tFID VARCHAR(44),");
        kSql.append("\tFCompanyOrgID VARCHAR(44),");
        kSql.append("\tFCompanyOrgName VARCHAR(100),");
        kSql.append(" \tFPeriodID \t\t      varchar(44),");
        kSql.append(" \tFPeriodNumber         varchar(80),");
        kSql.append(" \tFPeriodNumber1         varchar(80),");
        kSql.append(" \tFPeriodName           varchar(255),");
        kSql.append(" \tFCostCenterID \t\t  varchar(44),");
        kSql.append(" \tFCostCenterNumber \t  varchar(80),");
        kSql.append(" \tFCostCenterName \t  varchar(255), ");
        kSql.append(" \tFCostObjectID\t\t  varchar(44),");
        kSql.append(" \tFCostObjectNumber \t  varchar(80),");
        kSql.append(" \tFCostObjectName \t  varchar(255),");
        kSql.append("   FModel         \t\t  nvarchar(255),");
        kSql.append("   FUnitName      \t\t  varchar(255),");
        kSql.append(" \tFLot \t  \t\t\t  nvarchar(80),");
        kSql.append("\tFWIPQty \t  \t\t  NUMERIC(21,8),");
        kSql.append("\tFBOPWIPHour \t  \t  NUMERIC(21,8),");
        kSql.append(" \tFCostItemID \t\t  varchar(44),");
        kSql.append(" \tFCostItemNumber \t  varchar(80),");
        kSql.append(" \tFCostItemName \t\t  varchar(255),");
        kSql.append("\tFMaterialID \t\t  \tvarchar(44),");
        kSql.append("\tFMaterialNumber\t\t\tvarchar(80),");
        kSql.append("\tFMaterialName \t\t\tvarchar(255),");
        kSql.append("\tFMaterialModel\t\t\tnvarchar(255),");
        kSql.append("   FBaseUnit      \t\t    varchar(255),");
        kSql.append("\tFBatchNo\t\t\t\tNVARCHAR(80),");
        kSql.append("\tFBOPWIPCostQ\t\t\tNUMERIC(21,8),");
        kSql.append("\tFBOPWIPCostA\t\t\tNUMERIC(21,8),");
        kSql.append("\tFUnitCostQ\t\t\t\tNUMERIC(21,8),");
        kSql.append("\tFUnitCostA\t\t\t\tNUMERIC(21,8),");
        kSql.append("\tFUnitCostRatio \t\t\tNUMERIC(21,8),");
        kSql.append(" \tFTotalRow \t\t      \tNUMERIC(21,8) not null default(0),");
        kSql.append(" \tFTotalRow2 \t\t      \tNUMERIC(21,8) not null default(0),");
        kSql.append("\tFIsTotalRow int not null default(1), ");
        kSql.append("\tFTotalPeriodRow int not null default(0), ");
        kSql.append("\tFTotalCostCenterRow int not null default(0), ");
        kSql.append("\tFTotalCostObjectRow int not null default(0), ");
        kSql.append("\tFTotalCostItemRow int not null default(0), ");
        kSql.append("\tFTotalMaterialRow int not null default(0), ");
        kSql.append("\tFTotalOrderRow int not null default(0), ");
        kSql.append("\tFTotalProjectRow int not null default(0), ");
        kSql.append("\tFTotalTrackRow int not null default(0), ");
        kSql.append("\tFTotalLotRow int not null default(0), ");
        kSql.append("\tFTotalMatRow int not null default(0), ");
        kSql.append("\tFQtyPrecision \t      \tint default(4),");
        kSql.append("\tFPricePrecision \t    int default(2),");
        kSql.append("\tFAmountPrecision \t    int default(2),");
        kSql.append("\tFOrderID \t\t  \tvarchar(44),");
        kSql.append("\tFTrackID \t\t  \tvarchar(44),");
        kSql.append("\tFProjectID \t\t  \tvarchar(44),");
        kSql.append("\tFMatID \t\t  \tvarchar(44),");
        kSql.append(" \tFMatNumber         varchar(80),");
        kSql.append(" \tFMatName         varchar(255),");
        kSql.append(" \tFOrderNumber         varchar(80),");
        kSql.append(" \tFProjectNumber         varchar(80),");
        kSql.append(" \tFTrackNumber         varchar(80)");
        kSql.append(" ) ");
        try {
            TMP_NCM_InitBalanceDetailReport = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + TMP_NCM_InitBalanceDetailReport + " \n");
        kSql.append("            (FID, \n");
        kSql.append("             FCompanyOrgID, \n");
        kSql.append("             FPeriodID, \n");
        kSql.append("             FPeriodNumber, \n");
        kSql.append("             FPeriodNumber1, \n");
        kSql.append("             FCostCenterID, \n");
        kSql.append("             FCostCenterNumber, \n");
        kSql.append("             FCostCenterName, \n");
        kSql.append("             FCostObjectID, \n");
        kSql.append("             FCostObjectNumber, \n");
        kSql.append("             FCostObjectName, \n");
        kSql.append("             FOrderID, \n");
        kSql.append("             FProjectID, \n");
        kSql.append("             FTrackID, \n");
        kSql.append("\t\t\t  FMatID, \n");
        kSql.append("\t\t\t  FMatNumber, \n");
        kSql.append("\t\t\t  FMatName, \n");
        kSql.append("\t\t\t  FOrderNumber, \n");
        kSql.append("\t\t\t  FProjectNumber, \n");
        kSql.append("\t\t\t  FTrackNumber, \n");
        kSql.append("   \t\t  FModel, \n");
        kSql.append("   \t\t  FUnitName, \n");
        kSql.append("\t\t\t  FLot, \n");
        kSql.append("\t\t\t  FWIPQty, \n");
        kSql.append("\t\t\t  FBOPWIPHour, \n");
        kSql.append(" \t\t\t  FCostItemID, \n");
        kSql.append("\t\t\t  FCostItemNumber, \n");
        kSql.append("\t\t\t  FCostItemName, \n");
        kSql.append("\t\t\t  FMaterialID, \n");
        kSql.append("\t\t\t  FMaterialNumber, \n");
        kSql.append("\t\t\t  FMaterialName, \n");
        kSql.append("\t\t\t  FMaterialModel, \n");
        kSql.append("\t\t\t  FBaseUnit, \n");
        kSql.append("\t\t\t  FBatchNo, \n");
        kSql.append("\t\t\t  FBOPWIPCostQ, \n");
        kSql.append("\t\t\t  FBOPWIPCostA, \n");
        kSql.append("\t\t\t  FUnitCostQ, \n");
        kSql.append("\t\t\t  FUnitCostA, \n");
        kSql.append("\t\t\t  FUnitCostRatio, \n");
        kSql.append(" \t\t\t  FTotalRow, \n");
        kSql.append(" \t\t\t  FTotalRow2, \n");
        kSql.append(" \t\t\t  FIsTotalRow, \n");
        kSql.append("\t\t\t  FQtyPrecision, \n");
        kSql.append("\t\t\t  FAmountPrecision) \n");
        kSql.append(" SELECT  newbosid('12345678'),\n").append("         t1.FCompanyOrg,\n").append("         t1.FCalculatePeriodID,\n").append("\t\t  to_char(t7.FNumber),\n").append("\t\t  to_char(t7.FNumber),\n").append("\t\t  t1.FCostCenterID,\n").append("\t\t  t6.FNumber,\n").append("\t\t  t6.FName_" + lang + ",\n").append("\t\t  t1.FCostObjectID,\n").append("\t\t  t5.FNumber,\n").append("\t\t  t5.FName_" + lang + ",\n").append("\t\t  t5.FOrderID, \n").append("\t\t  t5.FProjectID, \n").append("\t\t  t5.FTrackID, \n").append("\t\t  t5.FStdProductIDID, \n").append("\t\t  t9.FNumber, \n").append("\t\t  t9.FName_" + lang + ", \n").append("\t\t  t5.FOrderNumber, \n").append("\t\t  po.FNumber, \n").append("\t\t  tr.FNumber, \n").append("\t\t  t9.FModel,\n").append("\t\t  t10.FName_" + lang + ",\n").append("\t\t  t5.FBatchNumber,\n").append("\t\t  t1.FBopWIPQty,\n").append("\t\t  t1.FBopWIPHour,\n").append("\t\t  t2.FCostItemID,\n").append("\t\t  t8.FNumber,\n").append("\t\t  t8.FName_" + lang + ",\n").append("\t\t  t3.FMaterialID,\n").append("\t\t  t11.FNumber,\n").append("\t\t  t11.FName_" + lang + ",\n").append("\t\t  t11.FModel,\n").append("\t\t  t12.FName_" + lang + ",\n").append("\t\t  t3.FBatchNo,\n").append("\t\t  t3.FQty,\n").append("\t\t  isnull(t3.FAmount,t2.FBoPWIPAmount),\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0,\n").append("\t\t  0 \n").append(" from ").append(physicalTblNames[0]).append(" t1 LEFT JOIN \n").append(physicalTblNames[1]).append(" t2 on t2.FParentID=t1.FID LEFT JOIN \n").append(physicalTblNames[2]).append(" t3 on t3.FParentID=t2.FID \n").append(" INNER JOIN T_BD_CostObject t5 on t1.FCostObjectID=t5.FID\n").append(" left join t_mm_project po on t5.FProjectID = po.FID \n").append(" left join t_mm_trackNumber tr on t5.FTrackID = tr.FID \n").append(" INNER JOIN T_ORG_CostCenter t6 on t1.FCostCenterID=t6.FID\n").append(" INNER JOIN T_BD_Period t7 on t1.FCalculatePeriodID=t7.FID\n").append(" INNER JOIN T_NCM_CostItem t8 on t2.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append(" LEFT JOIN T_BD_Material t9 on t5.FStdProductIDID=t9.FID\n").append(" LEFT JOIN T_BD_MeasureUnit t10 on t9.FBaseUnit=t10.FID\n").append(" LEFT JOIN T_BD_Material t11 on t3.FMaterialID=t11.FID\n").append(" LEFT JOIN T_BD_MeasureUnit t12 on t11.FBaseUnit=t12.FID\n").append(" WHERE t1.FCompanyOrg = '" + companyID + "'\n").append("\tand t1.FCostObjectID in (").append((String)objMap.get("costobjectid")).append(")\n").append("\tand t7.FNumber >= " + periodNumberFrom).append("\tand t7.FNumber <= " + periodNumberTo);
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostCenterFrom"))) {
            kSql.append(" and t6.fnumber >= '").append(filter.getString("prmtCostCenterFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostCenterTo"))) {
            kSql.append(" and t6.fnumber <= '").append(filter.getString("prmtCostCenterTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("costobjectFrom"))) {
            kSql.append(" and t5.fnumber >= '").append(filter.getString("costobjectFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("costobjectTo"))) {
            kSql.append(" and t5.fnumber <= '").append(filter.getString("costobjectTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostItemFrom"))) {
            kSql.append(" and t8.fnumber >= '").append(filter.getString("prmtCostItemFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostItemTo"))) {
            kSql.append(" and t8.fnumber <= '").append(filter.getString("prmtCostItemTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtOrderNumberFrom"))) {
            kSql.append(" and t5.FOrdernumber >= '").append(filter.getString("prmtOrderNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtOrderNumberTo"))) {
            kSql.append(" and t5.FOrdernumber <= '").append(filter.getString("prmtOrderNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtProjectNumberFrom"))) {
            kSql.append(" and po.fnumber >= '").append(filter.getString("prmtProjectNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtProjectNumberTo"))) {
            kSql.append(" and po.fnumber <= '").append(filter.getString("prmtProjectNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtTrackNumberFrom"))) {
            kSql.append(" and tr.fnumber >= '").append(filter.getString("prmtTrackNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtTrackNumberTo"))) {
            kSql.append(" and tr.fnumber <= '").append(filter.getString("prmtTrackNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("txtBatchNumberFrom"))) {
            kSql.append(" and t5.FBatchNumber >= '").append(filter.getString("txtBatchNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("txtBatchNumberTo"))) {
            kSql.append(" and t5.FBatchNumber <= '").append(filter.getString("txtBatchNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("materialIdFrom"))) {
            kSql.append(" and t9.fnumber >= '").append(filter.getString("materialIdFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("materialIdTo"))) {
            kSql.append(" and t9.fnumber <= '").append(filter.getString("materialIdTo")).append("'");
        }
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" INSERT INTO " + TMP_NCM_InitBalanceDetailReport + " \n");
        kSql.append("\t(FID,FCompanyOrgID,FPeriodID,FPeriodNumber,FPeriodNumber1, \n");
        kSql.append("    FCostCenterID,FCostCenterNumber,FCostCenterName, \n");
        kSql.append("    FCostObjectID,FCostObjectNumber,FCostObjectName,FOrderNumber,FProjectNumber,FTrackNumber, \n");
        kSql.append("\t FOrderID,FProjectID,FTrackID,FMatID, \n");
        kSql.append("\t FMatNumber,FMatName, \n");
        kSql.append("    FModel,FUnitName,FLot, \n");
        kSql.append("    FWIPQty,FBOPWIPHour,\n");
        kSql.append(" \t FCostItemID,FCostItemNumber,FCostItemName,FBaseUnit, \n");
        kSql.append("\t FBOPWIPCostQ,FBOPWIPCostA, \n");
        kSql.append("\t FUnitCostQ,FUnitCostA,FUnitCostRatio, \n");
        kSql.append(" \t FTotalRow,FTotalRow2,FIsTotalRow, \n");
        kSql.append("\t FQtyPrecision,FAmountPrecision) \n");
        kSql.append(" select newbosid('12345678'),tt1.FCompanyOrg,tt1.FCalculatePeriodID,to_char(tt7.FNumber),to_char(tt7.FNumber),\n").append("\t\t tt1.FCostCenterID,tt6.FNumber,tt6.FName_" + lang + ",\n").append("\t\t tt1.FCostObjectID,tt5.FNumber,tt5.FName_" + lang + ",tt5.FOrderNumber,po.FNumber,tr.FNumber,\n").append("\t\t tt5.FOrderID,tt5.FProjectID,tt5.FTrackID,tt5.FStdProductIDID, \n").append("\t\t tt9.FNumber,tt9.FName_" + lang + ", \n").append("\t\t tt9.FModel,tt10.FName_" + lang + ",tt5.FBatchNumber,\n").append("\t\t tt1.FBopWIPQty,tt1.FBopWIPHour,\n").append("\t\t tt2.FCostItemID,tt8.FNumber,tt8.FName_" + lang + ",tt11.FName_" + lang + ", \n").append("\t\t tt2.FBopWIPQty,tt2.FBoPWIPAmount,\n").append("\t\t 0,\n").append("\t\t 0,\n").append("\t\t 0,\n").append("\t\t 0,\n").append("\t\t 0,\n").append("\t\t 0,\n").append("\t\t tt11.FQtyPrecision,\n").append("\t\t 0 \n").append(" from \n").append(physicalTblNames[0]).append(" tt1 LEFT JOIN \n").append(physicalTblNames[1]).append(" tt2 on tt2.FParentID=tt1.FID \n").append(" INNER JOIN T_BD_CostObject tt5 on tt1.FCostObjectID=tt5.FID\n").append(" left join t_mm_project po on po.FID = tt5.FProjectID \n").append(" left join t_mm_trackNumber tr on tr.FID = tt5.FTrackID \n").append(" INNER JOIN T_ORG_CostCenter tt6 on tt1.FCostCenterID=tt6.FID\n").append(" INNER JOIN T_BD_Period tt7 on tt1.FCalculatePeriodID=tt7.FID\n").append(" LEFT JOIN T_NCM_CostItem tt8 on tt2.FCostItemID=tt8.FID ").append(" INNER JOIN T_BD_Material tt9 on tt5.FStdProductIDID=tt9.FID\n").append(" LEFT  JOIN T_BD_MeasureUnit tt10 on tt9.FBaseUnit=tt10.FID\n").append(" LEFT  JOIN T_BD_MeasureUnit tt11 on tt8.FUnitID=tt11.FID\n").append(" WHERE tt1.FCompanyOrg = '" + companyID + "'\n").append("\tand tt1.FCostObjectID in (").append((String)objMap.get("costobjectid")).append(")\n").append("\tand tt7.FNumber >= " + periodNumberFrom).append("\tand tt7.FNumber <= " + periodNumberTo).append("\tand (tt8.FItemType<>'").append("1").append("' or tt8.FItemType is null)\n");
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostCenterFrom"))) {
            kSql.append(" and tt6.fnumber >= '").append(filter.getString("prmtCostCenterFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostCenterTo"))) {
            kSql.append(" and tt6.fnumber <= '").append(filter.getString("prmtCostCenterTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("costobjectFrom"))) {
            kSql.append(" and tt5.fnumber >= '").append(filter.getString("costobjectFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("costobjectTo"))) {
            kSql.append(" and tt5.fnumber <= '").append(filter.getString("costobjectTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostItemFrom"))) {
            kSql.append(" and tt8.fnumber >= '").append(filter.getString("prmtCostItemFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtCostItemTo"))) {
            kSql.append(" and tt8.fnumber <= '").append(filter.getString("prmtCostItemTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtOrderNumberFrom"))) {
            kSql.append(" and tt5.FOrderNumber >= '").append(filter.getString("prmtOrderNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtOrderNumberTo"))) {
            kSql.append(" and tt5.FOrderNumber <= '").append(filter.getString("prmtOrderNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtProjectNumberFrom"))) {
            kSql.append(" and po.fnumber >= '").append(filter.getString("prmtProjectNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtProjectNumberTo"))) {
            kSql.append(" and po.fnumber <= '").append(filter.getString("prmtProjectNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtTrackNumberFrom"))) {
            kSql.append(" and tr.fnumber >= '").append(filter.getString("prmtTrackNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("prmtTrackNumberTo"))) {
            kSql.append(" and tr.fnumber <= '").append(filter.getString("prmtTrackNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("txtBatchNumberFrom"))) {
            kSql.append(" and tt5.fBatchnumber >= '").append(filter.getString("txtBatchNumberFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("txtBatchNumberTo"))) {
            kSql.append(" and tt5.fBatchnumber <= '").append(filter.getString("txtBatchNumberTo")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("materialIdFrom"))) {
            kSql.append(" and tt9.fnumber >= '").append(filter.getString("materialIdFrom")).append("'");
        }
        if (!StringUtils.isEmpty((String)filter.getString("materialIdTo"))) {
            kSql.append(" and tt9.fnumber <= '").append(filter.getString("materialIdTo")).append("'");
        }
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TMP_NCM_InitBalanceDetailReport);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        kSql.setLength(0);
        kSql.append(" UPDATE " + TMP_NCM_InitBalanceDetailReport).append(" SET FQtyPrecision= \n").append(" (SELECT T4.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n").append(" WHERE " + TMP_NCM_InitBalanceDetailReport + ".FMaterialID=T3.FID ); \n\n");
        kSql.append("UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update ").append(TMP_NCM_InitBalanceDetailReport).append(" set FUnitCostQ=\n").append(" CASE isnull(FWIPQty,0) WHEN 0 THEN 0 ELSE round(TO_Decimal(FBOPWIPCostQ,21,8)/TO_Decimal(isnull(FWIPQty,0),21,8) ,isnull(FQtyPrecision,4)) END\n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update ").append(TMP_NCM_InitBalanceDetailReport).append(" set FUnitCostA=\n").append(" CASE isnull(FWIPQty,0) WHEN 0 THEN 0 ELSE round(TO_Decimal(FBOPWIPCostA,21,8)/TO_Decimal(isnull(FWIPQty,0),21,8),isnull(FAmountPrecision,4)) END\n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append(" as t1").append("    SET (FUnitCostRatio)= \n").append(" (SELECT FSum \n").append("    FROM (SELECT FPeriodNumber FP,FCostObjectID FC,SUM(FUnitCostA) FSum \n").append("            FROM  ").append(TMP_NCM_InitBalanceDetailReport).append("\n").append("            GROUP BY FPeriodNumber,FCostObjectID) as t2\n").append("   WHERE t1.FCostObjectID=t2.FC and t1.FPeriodNumber=t2.FP)");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append("    SET FUnitCostRatio= \n").append(" CASE FUnitCostRatio WHEN 0 THEN 0 ELSE round(TO_Decimal(FUnitCostA*100,21,8)/TO_Decimal(FUnitCostRatio,21,8),2) END\n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        StringBuffer difference = new StringBuffer();
        difference.append("    (select 100 - Sum(FUnitCostRatio), FCostCenterID,FCostObjectID,FPeriodID from  ").append(TMP_NCM_InitBalanceDetailReport).append("      where FTotalRow2 = 0 group by FCostCenterID,FCostObjectID,FPeriodID ) ");
        BigDecimal diff = SysConstant.BIGZERO;
        String costcenterID = "";
        String costObjectID = "";
        String preiodID = "";
        IRowSet rsPercent = DbUtil.executeQuery((Context)this.getContext(), (String)difference.toString());
        try {
            while (rsPercent.next()) {
                diff = rsPercent.getBigDecimal(1);
                costcenterID = rsPercent.getString(2);
                costObjectID = rsPercent.getString(3);
                preiodID = rsPercent.getString(4);
                StringBuffer adjust = new StringBuffer();
                adjust.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append(" SET FUnitCostRatio = FUnitCostRatio + ?  \n ").append(" WHERE FID =                                                                \n").append(" (select top 1 FID from ").append(TMP_NCM_InitBalanceDetailReport).append("                  \n").append(" where FTotalRow2 = 0 ").append("  and FCostCenterID = '").append(costcenterID).append("'").append("  and FCostObjectID = '").append(costObjectID).append("'").append("  and FPeriodID = '").append(preiodID).append("'").append(" order by FUnitCostRatio desc )                          \n");
                DbUtil.execute((Context)this.getContext(), (String)adjust.toString(), (Object[])new BigDecimal[]{diff});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        kSql.setLength(0);
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodNumber1,FTotalPeriodRow " + orderByMode + ",");
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumber,FTotalCostCenterRow " + orderByMode + ",");
            } else if ("FCostObjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjectNumber,FTotalCostObjectRow " + orderByMode + ",");
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumber,FTotalCostItemRow " + orderByMode + ",");
            } else if ("FMaterialID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMaterialNumber,FTotalMaterialRow " + orderByMode + ",");
            } else if ("FOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FOrderID,FTotalOrderRow " + orderByMode + ",");
            } else if ("FProjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProjectID,FTotalProjectRow " + orderByMode + ",");
            } else if ("FTrackID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FTrackID,FTotalTrackRow " + orderByMode + ",");
            } else if ("FLotID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjectID,FTotalLotRow " + orderByMode + ",");
            } else if ("FMatID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMatNumber,FTotalMatRow " + orderByMode + ",");
            }
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            totalrows.put(fieldID, totalrow--);
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                if ("FPeriodID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FPeriodID,FPeriodNumber,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostCenterID,FCostCenterNumber,FCostCenterName,");
                    continue;
                }
                if ("FCostObjectID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostObjectID,FCostObjectNumber,FCostObjectName,ForderNumber,");
                    fields.append("FModel,FUnitName,FLot,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostItemID,FCostItemNumber,FCostItemName,");
                    continue;
                }
                if ("FMaterialID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FMaterialID,FMaterialNumber,");
                    fields.append("FMaterialName,FMaterialModel,FBaseUnit,FBatchNo,");
                    continue;
                }
                if ("FOrderID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FOrderID,");
                    continue;
                }
                if ("FProjectID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FProjectID,FProjectNumber,");
                    continue;
                }
                if ("FTrackID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FTrackID,FTrackNumber,");
                    continue;
                }
                if (!"FMatID".equalsIgnoreCase(subFieldID)) continue;
                fields.append("FMatID,FMatNumber,FMatName,");
            }
            fields.deleteCharAt(fields.length() - 1);
            kSql.append(" INSERT INTO ").append(TMP_NCM_InitBalanceDetailReport).append("\n").append("  (FCompanyOrgID,FTotalRow,FTotalRow2,\n").append("  " + fields + ",\n");
            kSql.append("  FBOPWIPCostA,FUnitCostA,FUnitCostRatio)\n");
            kSql.append(" SELECT '" + companyID + "', 0,").append(totalrows.get(fieldID)).append("\n").append("  ," + fields + ",\n");
            if (fields.toString().endsWith("FCostObjectID") || fields.toString().indexOf("FCostObjectID") != -1) {
                kSql.append("  SUM(FBOPWIPCostA),SUM(FUnitCostA),SUM(FUnitCostRatio) \n");
            } else {
                kSql.append("  SUM(FBOPWIPCostA),SUM(FUnitCostA),0 \n");
            }
            kSql.append(" FROM " + TMP_NCM_InitBalanceDetailReport + "\n").append(" WHERE FTotalRow2 = 0 \n");
            kSql.append(" GROUP BY " + fields);
            kSql.append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" INSERT INTO ").append(TMP_NCM_InitBalanceDetailReport).append("  (FTotalRow,FTotalRow2,FCompanyOrgName,").append("\t\tFBOPWIPCostA,FUnitCostA,FUnitCostRatio)").append(" SELECT 1,105, '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',").append("  SUM(FBOPWIPCostA),SUM(FUnitCostA),0").append(" FROM " + TMP_NCM_InitBalanceDetailReport + "\n").append(" where FTotalRow2 = 0 \n").append(";\n\n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update ").append(TMP_NCM_InitBalanceDetailReport).append(" set (FWIPQty,FBOPWIPHour) = (select x.FWIPQty,x.FBOPWIPHour from (select SUM(S.FWIPQty)  as FWIPQty, sum(S.FBOPWIPHour) as FBOPWIPHour from (select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,data.FWIPQty,data.FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append(" data where  FTotalRow2 = 0 group by FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour) S  ) x ) where FTotalRow2 = 105");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        kSql.setLength(0);
        int whichTotalFlag = 104;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = null;
            fieldNumber = field.equalsIgnoreCase("FLotID") ? "FLot" : field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                whichTotal = ", FTotalOrderRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                whichTotal = ", FTotalProjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                whichTotal = ", FTotalTrackRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FLot")) {
                whichTotal = ", FTotalLotRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMatNumber")) {
                whichTotal = ", FTotalMatRow = 1 ";
            }
            if (!"FPeriodNumber".equals(fieldNumber)) {
                if (fieldName.equals("FOrderName") || fieldName.equals("FProjectName") || fieldName.equals("FTrackName") || fieldName.equals("FLotName")) {
                    kSql.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append("\n SET ").append(fieldNumber).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
                } else {
                    kSql.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append("\n SET ").append(fieldName).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append(fieldNumber).append(" = ").append(fieldNumber + "\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
                }
            } else if ("FPeriodNumber".equals(fieldNumber)) {
                kSql.append(" UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append("\n SET ").append(fieldNumber).append("=" + fieldNumber + " || '  " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append("FPeriodNumber1 = ").append(fieldNumber).append(" , ").append(fieldName).append(" = ").append(fieldName + "\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
            }
            StringBuffer fields = new StringBuffer();
            fields.append("detail.FPeriodID,detail.FCostCenterID,detail.FCostObjectID,");
            fields.deleteCharAt(fields.length() - 1);
            StringBuffer updateHour = new StringBuffer();
            if ("FPeriodNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select detail.FPeriodID, sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by detail.FPeriodID) s where s.FPeriodID = m.FPeriodID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FCostCenterNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select detail.FPeriodID,detail.FCostCenterID, sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by detail.FPeriodID,detail.FCostCenterID) s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FCostObjectNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FCostItemNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FMaterialNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FOrderNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FProjectNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FTrackNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FLot".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            if ("FMatNumber".equalsIgnoreCase(fieldNumber)) {
                updateHour.append("  update  " + TMP_NCM_InitBalanceDetailReport + " as m set (FbopWipHour,FWIPQTY) = (select s.FbopWipHour,s.FWIPQTY from  (select " + fields + ", sum(detail.FbopWipHour) FbopWipHour,sum(detail.FWIPQTY) FWIPQTY from ").append("(select distinct FCompanyOrgID,FPeriodID,FCostCenterID,FCostObjectID,FWIPQty,FBOPWIPHour from ").append(TMP_NCM_InitBalanceDetailReport).append("  data where data.FTotalRow2 = 0 ) as detail ").append("  group by " + fields + ") s where s.FPeriodID = m.FPeriodID AND s.FCostCenterID = m.FCostCenterID and s.FCostObjectID = m.FCostObjectID) where m.FTotalRow2 = " + whichTotalFlag-- + ";  \n\n ;");
            }
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)updateHour.toString());
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" Update ").append(TMP_NCM_InitBalanceDetailReport).append("\n Set FCompanyOrgName= '").append(info.getName()).append("'").append(" WHERE FTotalRow2<105;\n\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" UPDATE " + TMP_NCM_InitBalanceDetailReport).append(" SET FQtyPrecision= \n").append(" (SELECT T4.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n").append(" WHERE " + TMP_NCM_InitBalanceDetailReport + ".FMaterialID=T3.FID); \n\n");
        kSql.append(" UPDATE " + TMP_NCM_InitBalanceDetailReport + " T ").append(" SET FQtyPrecision= \n").append(" isnull(FQtyPrecision,(SELECT T4.FqtyPrecision \n").append(" FROM t_NCM_CostItem t3 \n").append(" left JOIN t_bd_MeasureUnit T4 ON T3.FUnitID = T4.FID \n").append(" WHERE T.FCostItemID=T3.FID and T3.FItemType <> '1')); \n\n");
        kSql.append("UPDATE ").append(TMP_NCM_InitBalanceDetailReport).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" UPDATE " + TMP_NCM_InitBalanceDetailReport).append(" SET FPeriodNumber1 = FPeriodNumber \n").append(" where FPeriodNumber1 is null ;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)kSql.toString());
        return TMP_NCM_InitBalanceDetailReport;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isDisplayTotalRowsOnly");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodNumber1,FTotalPeriodRow " + orderByMode + ",");
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumber,FTotalCostCenterRow " + orderByMode + ",");
            } else if ("FCostObjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjectNumber,FTotalCostObjectRow " + orderByMode + ",");
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumber,FTotalCostItemRow " + orderByMode + ",");
            } else if ("FMaterialID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMaterialNumber,FTotalMaterialRow " + orderByMode + ",");
            } else if ("FOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FOrderID,FTotalOrderRow " + orderByMode + ",");
            } else if ("FProjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProjectID,FTotalProjectRow " + orderByMode + ",");
            } else if ("FTrackID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FTrackID,FTotalTrackRow " + orderByMode + ",");
            } else if ("FLotID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjectID,FTotalLotRow " + orderByMode + ",");
            } else if ("FMatID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMatNumber,FTotalMatRow " + orderByMode + ",");
            }
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            totalrows.put(fieldID, totalrow--);
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                if ("FPeriodID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FPeriodID,FPeriodNumber,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostCenterID,FCostCenterNumber,FCostCenterName,");
                    continue;
                }
                if ("FCostObjectID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostObjectID,FCostObjectNumber,FCostObjectName,ForderNumber,");
                    fields.append("FModel,FUnitName,FLot,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostItemID,FCostItemNumber,FCostItemName,");
                    continue;
                }
                if ("FMaterialID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FMaterialID,FMaterialNumber,");
                    fields.append("FMaterialName,FMaterialModel,FBaseUnit,FBatchNo,");
                    continue;
                }
                if ("FOrderID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FOrderID,");
                    continue;
                }
                if ("FProjectID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FProjectID,FProjectNumber,");
                    continue;
                }
                if ("FTrackID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FTrackID,FTrackNumber,");
                    continue;
                }
                if (!"FMatID".equalsIgnoreCase(subFieldID)) continue;
                fields.append("FMatID,FMatNumber,FMatName,");
            }
            fields.deleteCharAt(fields.length() - 1);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " ORDER BY FTotalRow " + orderByMode + "," + orderBy.toString() + " FTotalRow2 "), (int)start, (int)rows);
        return rs;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String companyName = "";
        companyName = companyInfo == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : companyInfo.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + companyName);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"112_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtCostCenterFrom"), filter.getString("prmtCostCenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"113_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtOrderNumberFrom"), filter.getString("prmtOrderNumberTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtProjectNumberFrom"), filter.getString("prmtProjectNumberTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtTrackNumberFrom"), filter.getString("prmtTrackNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_Product", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("materialIdFrom"), filter.getString("materialIdTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("txtBatchNumberFrom"), filter.getString("txtBatchNumberTo")));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList list = header.getChilds();
        ArrayList childList = null;
        ReportHeader childHeader = null;
        ReportHeader childChildHeader = null;
        String fildName = null;
        String childFildName = null;
        for (int i = 0; i < list.size(); ++i) {
            int j;
            childHeader = (ReportHeader)list.get(i);
            fildName = childHeader.getFieldName();
            if (fildName.equals("FCompanyOrgName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CompanyOrgName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"66_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FLot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"65_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FWIPQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"WIPQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FBOPWIPHour")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BOPWIPHour", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FMaterialNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FMaterialName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FMaterialModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FBaseUnit")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_Funit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fildName.equals("FBatchNo")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"65_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                childHeader.setIndex(12);
                continue;
            }
            if (fildName.equals("FBOPWIPCost")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BOPWIPCost", (Locale)ctx.getLocale()));
                childList = childHeader.getChilds();
                for (j = 0; j < childList.size(); ++j) {
                    childChildHeader = (ReportHeader)childList.get(j);
                    childFildName = childChildHeader.getFieldName();
                    if (childFildName.equals("FBOPWIPCostQ")) {
                        childChildHeader.setType(2).setDecimalField("FQtyPrecision");
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFildName.equals("FBOPWIPCostA")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fildName.equals("FUnitCost")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"UnitCost", (Locale)ctx.getLocale()));
            childList = childHeader.getChilds();
            for (j = 0; j < childList.size(); ++j) {
                childChildHeader = (ReportHeader)childList.get(j);
                childFildName = childChildHeader.getFieldName();
                if (childFildName.equals("FUnitCostQ")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                    childChildHeader.setDecimalField("FQtyPrecision");
                    continue;
                }
                if (childFildName.equals("FUnitCostA")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                    childChildHeader.setDecimalField("FAmountPrecision");
                    continue;
                }
                if (!childFildName.equals("FUnitCostRatio")) continue;
                childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"225_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        }
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 6).setMergeable(true);
        header.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), 7).setMergeable(true);
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 8).setMergeable(true);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 9).setMergeable(true);
        header.addChild("FMatNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductNumber", (Locale)ctx.getLocale()), 10).setMergeable(true);
        header.addChild("FMatName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductName", (Locale)ctx.getLocale()), 11).setMergeable(true);
        return header;
    }

    private String[] getPhysicalTableName(String companyID, String yearFrom, String periodFrom, String yearTo, String periodTo) throws BOSException {
        String[] physicalTblNames = new String[5];
        String[] logicalTblNames = new String[]{"T_NCM_Balance", "T_NCM_BalanceEntry", "T_NCM_BalanceMatDetail", "T_NCM_CostCalResult", "T_NCM_CostCalMatDetailResult"};
        try {
            int periodFromNumber = this.getPeriodNumber(companyID, yearFrom, periodFrom);
            int periodToNumber = this.getPeriodNumber(companyID, yearTo, periodTo);
            for (int i = 0; i < logicalTblNames.length; ++i) {
                physicalTblNames[i] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)logicalTblNames[i], (int)periodFromNumber, (int)periodToNumber);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = Integer.valueOf(temp);
        return number;
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }
}

