/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;

public class MAAllocDetailReport
extends ReportServerBase {
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO);

    protected IRowSet getReportData(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTableName(filter);
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tableName);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTableName(filter);
        this.setTablename(tableName);
        String sql1 = this.buildDataSqlCount(filter, tableName);
        IRowSet totalRow = DbUtil.executeQuery((Context)this.getContext(), (String)sql1);
        try {
            if (totalRow.next()) {
                int count = 0;
                count = totalRow.getInt(1);
                this.setTotalRowCount(count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getTablename();
    }

    private String buildDataSqlCount(RptParams filter, String tempTableName) {
        return "SELECT count(1) FROM " + tempTableName;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        String tempTableName = this.getTempTable();
        this.initTempTblData(filter, tempTableName);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(tempTableName).append(" t2 SET (FpricePrecision)= \n").append("\t(SELECT t1.FPricePrecision \n").append("\tFROM T_BD_Material t1 \n").append("\tWHERE t1.FID= t2.FItemID); \n");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FTotalRow,FTotalRow2,FCompanyOrgName,FPeriodNumber,FNumber,FCommonQty,FQty,FAssistQty,FAmount,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision)\n");
        sb.append("SELECT 1, 100,FCompanyOrgName,FPeriodNumber,'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"188_MAAllocDetailReport", (Locale)ctx.getLocale()) + "'");
        sb.append(",SUM(FCommonQty),SUM(FQty),SUM(FAssistQty) ,SUM(FAmount)\n");
        sb.append(",isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),0),isnull(max(FAssistqtyPrecision),4),isnull(max(FPricePrecision),0)\n");
        sb.append(" FROM " + tempTableName + "\n");
        sb.append(" GROUP BY FCompanyOrgName,FPeriodNumber ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FTotalRow,FTotalRow2,FItemName,FCommonQty,FQty,FAssistQty,FAmount,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision)\n");
        sb.append("SELECT 105,105,'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'");
        sb.append(",SUM(FCommonQty),SUM(FQty),SUM(FAssistQty),SUM(FAmount)\n");
        sb.append(",isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),0),isnull(max(FAssistqtyPrecision),4),isnull(max(FPricePrecision),0)\n");
        sb.append(" FROM " + tempTableName);
        sb.append(" where FTotalRow2<>100");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyID = companyInfo.getId().toString();
        sb.append("UPDATE ").append(tempTableName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        return tempTableName;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        return "SELECT * FROM " + tempTableName + " Order by  FTotalRow,FCompanyOrgName,FPeriodNumber,FTotalRow2,FNumber,FCostCenterNumber,FItemNumber,FSeq";
    }

    protected String getTempTable() throws BOSException {
        String tempTableName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table t1 ( ");
        createTable.append(" FID varchar(44) ");
        createTable.append(" ,FCompanyOrgName nvarchar(255) ");
        createTable.append(" ,FPeriodNumber varchar(20) ");
        createTable.append(" ,FNumber nvarchar(80) ");
        createTable.append(",FCostCenterNumber nvarchar(80) not null default(' ')");
        createTable.append(",FCostCenterName nvarchar(255) ");
        createTable.append(",FSeq int null ");
        createTable.append(",FItemID varchar(44) ");
        createTable.append(",FItemNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FItemName nvarchar(255) ");
        createTable.append(",FItemModel nvarchar(255) ");
        createTable.append(",FItemShortName nvarchar(80) ");
        createTable.append(",FLot NVARCHAR(80) ");
        createTable.append(",FCostObjectNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FCostObjectName nvarchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(255) ");
        createTable.append(",FBatchNumber nvarchar(80) ");
        createTable.append(",FOrderNumber nvarchar(80)");
        createTable.append(",FProjectNumber nvarchar(80)");
        createTable.append(",FTrackNumber nvarchar(80)");
        createTable.append(",FProductNumber nvarchar(80)");
        createTable.append(",FProductName varchar(255)");
        createTable.append(",FUnitCommonName nvarchar(255) ");
        createTable.append(",FUnitName nvarchar(255) ");
        createTable.append(",FUnitAssistName nvarchar(255) ");
        createTable.append(",FCostItemNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FCostItemName nvarchar(255) ");
        createTable.append(",FCommonQty decimal(21,8) ");
        createTable.append(",FQty decimal(21,8) ");
        createTable.append(",FAssistQty decimal(21,8) ");
        createTable.append(",FCommonqtyPrecision int  default(4) ");
        createTable.append(",FqtyPrecision int not null default(4) ");
        createTable.append(",FAssistqtyPrecision int  default(4) ");
        createTable.append(",FPrice decimal(21,8) ");
        createTable.append(",FPricePrecision int not null default(2) ");
        createTable.append(",FAmountPrecision int not null default(2) ");
        createTable.append(",FAmount decimal(17,4) ");
        createTable.append(",FAllocStdName nvarchar(255) ");
        createTable.append(",FAllocStdData decimal(21,8) ");
        createTable.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTable.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTable.append(",FIsRework varchar(4) ");
        createTable.append(",FSourceType varchar(4) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber varchar(80) ");
        createTable.append(" , FExpenseName varchar(255) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private void initTempTblData(RptParams filter, String tempTableName) throws BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyID = companyInfo.getId().toString();
        String companyName = companyInfo.getName();
        int fromPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        int toPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        String currtableName = "";
        String histableName = "";
        String[] tables = new String[2];
        try {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyID);
            int iCurr = currPeriod.getNumber();
            if (iCurr == toPeriod && iCurr == fromPeriod) {
                currtableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)fromPeriod, (int)toPeriod);
            } else if (fromPeriod < iCurr && toPeriod < iCurr) {
                histableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)fromPeriod, (int)toPeriod);
            } else {
                currtableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)iCurr, (int)iCurr);
                histableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)(iCurr - 1), (int)(iCurr - 1));
            }
            tables[0] = currtableName;
            tables[1] = histableName;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String L2 = this.getContext().getLocale().getDisplayName();
        StringBuffer sb = new StringBuffer();
        this.getDataFromSpecialBill(companyID, companyName, L2, tables, tempTableName, "t_im_MaterialReqBill", "t_im_MaterialReqBillEntry", filter, sb);
        this.getDataFromSpecialBill(companyID, companyName, L2, tables, tempTableName, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", filter, sb);
        this.getDataFromSpecialBill(companyID, companyName, L2, tables, tempTableName, "T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry", filter, sb);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
    }

    private void getDataFromSpecialBill(String companyID, String companyName, String L2, String[] tableNames, String tempTableName, String phsicalTblBill, String phsicalTblEntry, RptParams filter, StringBuffer sb) throws BOSException {
        for (int i = 0; i < tableNames.length; ++i) {
            if (tableNames[i] == null || tableNames[i] == "") continue;
            sb.append("INSERT INTO " + tempTableName + "(FID,FCompanyOrgName,FPeriodNumber,FCostCenterNumber,FCostCenterName,FNumber \n");
            sb.append(",FSeq,FItemID,FItemNumber,FItemName,FItemModel,FItemShortName,FUnitCommonName,FUnitName,FUnitAssistName,FLot,FCostObjectNumber,FCostObjectName,FProductModel,FProductShortName,FBatchNumber");
            sb.append(",FCostItemNumber,FCostItemName,FCommonQty,FQty,FAssistQty,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPrice,FPricePrecision,FAmount,FAllocStdName");
            sb.append(",FAllocStdData,FIsRework,FOrderNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName ");
            sb.append(",FExpenseID, FExpenseNumber, FExpenseName,FSourceType) \n");
            sb.append("SELECT t1.FSourceBillID, '" + companyName + "',TO_CHAR(t2.FNumber),t3.FNumber,t3.FName_" + L2 + ",isnull(v.FNumber,' ') \n");
            sb.append(",isnull(u.FSeq,0),t6.Fid,t6.FNumber,t6.FName_" + L2 + ",t6.FModel,t6.FShortName,commonUnit.FName_" + L2 + ",unit.FName_" + L2 + " , assistUnit.FName_" + L2 + ",t1.FLot,t7.FNumber,t7.FName_" + L2 + ",t8.FModel,t8.FShortName,t7.FbatchNumber");
            sb.append(",t9.FNumber,t9.FName_" + L2 + ",round(t1.FCommonQty,mmu.FqtyPrecision),round(t1.FQty,mmu1.FqtyPrecision),round(t1.FAssistQty,mmu1.FqtyPrecision),ISNULL(mmu.FqtyPrecision,4),ISNULL(mmu1.FqtyPrecision,4),ISNULL(mmu2.FqtyPrecision,4),t1.FPrice,ISNULL(t8.FPricePrecision,2),t1.FAmount,t10.FName_" + L2 + ",t1.FAllocStdData,case when(t1.FIsRework = 1) then '\u662f' else '\u5426' end as FIsRework,t7.FOrderNumber,po.FNumber,tr.FNumber,pro.FNumber,pro.FName_" + L2 + " \n");
            sb.append(", isnull(texp.FID,'ml7t5QEaEADgAAwawKgRe0olWCc='),isnull(texp.FNumber,'5001'),isnull(texp.FName_" + L2 + ",'\u6750\u6599\u8d39\u7528') ,AllocBillType");
            sb.append(" from " + tableNames[i] + " t1 \n");
            sb.append(" inner join t_bd_Period t2 on t1.FCalculatePeriodID = t2.FID \n ");
            sb.append(" join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID \n");
            sb.append(" join ").append(phsicalTblBill).append(" v on t1.FSourceBillID = v.FID \n");
            sb.append(" join ").append(phsicalTblEntry).append(" u on t1.FSourceBillEntryID = u.FID  \n");
            sb.append(" join T_BD_CostObject t7 on t1.FCostObjectID = t7.FID  \n");
            sb.append(" left join t_mm_project po on po.FID = t7.FProjectID \n");
            sb.append(" left join t_mm_trackNumber tr on tr.FID = t7.FTrackID \n");
            sb.append(" left join t_bd_material pro on pro.FID = t7.FStdProductIDID \n");
            sb.append(" join t_bd_material t6 on t1.FMaterialID = t6.FID  \n");
            sb.append(" LEFT  JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t7.FStdProductIDID and t1.FCompanyID=T_BD_MaterialCompanyInfo.FCompanyID \n");
            sb.append(" LEFt  JOIN T_BD_Material t8 ON t8.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
            sb.append(" left join t_bd_MaterialCost tmacost on tmacost.FMaterialID = t1.FMaterialID and tmacost.FOrgUnit ='" + companyID + "' \n");
            sb.append(" inner join T_NCM_Expense texp on isnull(tmacost.FExpenseID,'ml7t5QEaEADgAAwawKgRe0olWCc=') = texp.FID  \n");
            sb.append(" Left  join t_bd_MeasureUnit commonUnit on u.FUnitID = commonUnit.FID \n");
            sb.append(" Left  join t_bd_MeasureUnit unit on t6.FBaseUnit = unit.FID \n");
            sb.append(" Left  join t_bd_MeasureUnit assistUnit on t6.FAssistUnit = assistUnit.FID \n");
            sb.append(" Left JOIN t_bd_multiMeasureUnit mmu on  t1.FMaterialID=mmu.FMaterialID and commonUnit.fid=mmu.FMeasureUnitID ");
            sb.append(" Left JOIN t_bd_multiMeasureUnit mmu1 on  t1.FMaterialID=mmu1.FMaterialID and unit.fid=mmu1.FMeasureUnitID   ");
            sb.append(" Left JOIN t_bd_multiMeasureUnit mmu2 on  t1.FMaterialID=mmu2.FMaterialID and assistUnit.fid=mmu2.FMeasureUnitID ");
            sb.append(" join t_Ncm_Costitem t9 on t1.FCostItemID = t9.FID  \n");
            sb.append(" left  join  T_NCM_AllocStd t10 on t1.FAllocStdID = t10.FID  ");
            sb.append(" where t1.FCompanyID = '" + companyID + "' \n");
            this.buildFilter(filter, sb);
        }
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(ZERO) == 0) {
            RptParams params = new RptParams();
            Object companyOrg = totalFilter.getObject("companyorg");
            if (companyOrg == null) {
                companyOrg = ContextUtil.getCurrentFIUnit((Context)this.getContext());
            }
            params.setObject("companyorg", companyOrg);
            String periodNumer = (String)rowData.get("FPERIODNUMBER");
            String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
            String period = "" + Integer.parseInt(periodNumer.substring(4));
            params.setString("yearFrom", year);
            params.setString("yearTo", year);
            params.setString("periodFrom", period);
            params.setString("periodTo", period);
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("itemFrom", (String)rowData.get("FITEMNUMBER"));
            params.setString("itemTo", (String)rowData.get("FITEMNUMBER"));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append(" and t2.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        sb.append(" and t2.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        sb.append("\n");
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("itemFrom") != null && !"".equals(filter.getString("itemFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("itemFrom")).append("'");
        }
        if (filter.getString("itemTo") != null && !"".equals(filter.getString("itemTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("itemTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t7.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t7.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t9.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t9.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
        if (filter.getString("orderNumberFrom") != null && !"".equals(filter.getString("orderNumberFrom"))) {
            sb.append(" and t7.FOrderNumber >='").append(filter.getString("orderNumberFrom")).append("'");
        }
        if (filter.getString("orderNumberTo") != null && !"".equals(filter.getString("orderNumberTo"))) {
            sb.append(" and t7.FOrderNumber <='").append(filter.getString("orderNumberTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t7.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t7.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("productFrom") != null && !"".equals(filter.getString("productFrom"))) {
            sb.append(" and pro.FNumber >='").append(filter.getString("productFrom")).append("'");
        }
        if (filter.getString("productTo") != null && !"".equals(filter.getString("productTo"))) {
            sb.append(" and pro.FNumber <='").append(filter.getString("productTo")).append("'");
        }
        if (filter.getString("prmtexpensefrom") != null && !"".equals(filter.getString("prmtexpensefrom"))) {
            sb.append(" and texp.FNumber >='").append(filter.getString("prmtexpensefrom")).append("'");
        }
        if (filter.getString("prmtexpenseto") != null && !"".equals(filter.getString("prmtexpenseto"))) {
            sb.append(" and texp.FNumber <='").append(filter.getString("prmtexpenseto")).append("'");
        }
        sb.append(" ;\n");
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"102_MAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"103_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("itemFrom"), filter.getString("itemTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"104_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"105_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costitemFrom"), filter.getString("costitemTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderNumberFrom"), filter.getString("orderNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductLot", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_Product", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"46_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtexpensefrom"), filter.getString("prmtexpenseto")));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        header.addChild("FPeriodNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostCenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FSeq", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Seq", (Locale)ctx.getLocale()), index++);
        header.addChild("FItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)ctx.getLocale()), index++);
        header.addChild("FItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)ctx.getLocale()), index++);
        header.addChild("FItemModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()), index++);
        header.addChild("FItemShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName_2", (Locale)ctx.getLocale()), index++);
        header.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_MaterialLot", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostObjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostObjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ProductNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductName", (Locale)ctx.getLocale()), index++);
        header.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FProductShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BatchNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale()), index++);
        header.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        header.addChild("FUnitCommonName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_Funit", (Locale)ctx.getLocale()), index++);
        header.addChild("FCommonQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FCommonqtyPrecision");
        header.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"217_FBaseUnit", (Locale)ctx.getLocale()), index++);
        header.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FqtyPrecision");
        header.addChild("FUnitAssistName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"219_FAssistUnit", (Locale)ctx.getLocale()), index++);
        header.addChild("FAssistQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAssistqtyPrecision");
        header.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        header.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        header.addChild("FAllocStdName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdName", (Locale)ctx.getLocale()), index++);
        header.addChild("FAllocStdData", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdData", (Locale)ctx.getLocale()), index++).setAlign(3);
        header.addChild("FIsRework", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"IsRework", (Locale)ctx.getLocale()), index++);
        return header;
    }
}

