/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MAAllocTotalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)MAAllocTotalReport.class.getName());
    private static final Object[] headerGroup = new Object[]{new String[]{"FCostCenterID", "FCostCenterNumber", "FCostCenterName"}, new String[]{"FItemID", "FItemNumber", "FItemName", "FItemModel", "FItemShortName"}, new String[]{"FCostObjectID", "FCostObjectNumber", "FOrderNumber", "FCostObjectName", "FProductModel", "FProductShortName"}, new String[]{"FCostItemID", "FCostItemNumber", "FCostItemName"}};

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String tableName = this.buildReportDataTableName(filter);
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tableName);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTableName(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        ArrayList tableList = (ArrayList)filter.getObject("table");
        if (tableList == null) {
            this.addSummaryAndSorterForConnect(filter);
        }
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        String tempTableName;
        String tableName;
        Context ctx = this.getContext();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        try {
            int fromPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
            int toPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_MatAllocResult", (int)fromPeriod, (int)toPeriod);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table t1 ( ");
        createTable.append(" FPeriodID varchar(80) ");
        createTable.append(" ,FPeriodNumber varchar(20) ");
        createTable.append(" ,FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber nvarchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FItemID varchar(44) ");
        createTable.append(",FItemNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FItemName nvarchar(255) ");
        createTable.append(",FItemModel nvarchar(255) ");
        createTable.append(",FItemShortName nvarchar(80) ");
        createTable.append(",FLot nvarchar(80) ");
        createTable.append(",FUnitCommonID varchar(255) ");
        createTable.append(",FUnitCommonName nvarchar(255) ");
        createTable.append(",FUnitName nvarchar(255) ");
        createTable.append(",FUnitAssistName nvarchar(255) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FCostObjectName nvarchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FOrderNumber nvarchar(80)");
        createTable.append(",FBatchNumber nvarchar(80)");
        createTable.append(",FProjectNumber nvarchar(80)");
        createTable.append(",FTrackNumber nvarchar(80)");
        createTable.append(",FProductNumber nvarchar(80)");
        createTable.append(",FProductName nvarchar(255)");
        createTable.append(",FOrderID varchar(44) ");
        createTable.append(",FProjectID varchar(44) ");
        createTable.append(",FTrackID varchar(44) ");
        createTable.append(",FProductID varchar(44) ");
        createTable.append(",FBatchID nvarchar(255) ");
        createTable.append(",FCostItemID varchar(80) ");
        createTable.append(",FCostItemNumber nvarchar(80) not null default(' ') ");
        createTable.append(",FCostItemName nvarchar(255) ");
        createTable.append(",FCommonQty decimal(21,8) ");
        createTable.append(",FQty decimal(21,8) ");
        createTable.append(",FAssistQty decimal(21,8) ");
        createTable.append(",FCommonqtyPrecision int  default(4) ");
        createTable.append(",FqtyPrecision int not null default(4) ");
        createTable.append(",FAssistqtyPrecision int  default(4) ");
        createTable.append(",FPrice decimal(21,8) ");
        createTable.append(",FPricePrecision int not null default(2) ");
        createTable.append(",FAmount decimal(17,4) ");
        createTable.append(",FAmountPrecision int not null default(2) ");
        createTable.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTable.append(",FTotalRow2 int not null default(0) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalOrderRow int not null default(0) ");
        createTable.append(" ,FTotalBatchRow int not null default(0) ");
        createTable.append(" ,FTotalProjectRow int not null default(0) ");
        createTable.append(" ,FTotalTrackRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalExpenseRow int not null default(0) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber nvarchar(80) ");
        createTable.append(" , FExpenseName nvarchar(255) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FPeriodNumber,FCostCenterID,FItemID,FLot,FCostObjectID,FCostItemID,FUnitCommonName,FUnitCommonID,FOrderID,FBatchID,FProjectID,FTrackID,FProductID,FUnitAssistName,FCommonQty,FQty,FAssistQty,FPrice,FAmount,FIsTotalRow ,FExpenseID, FExpenseNumber, FExpenseName) \n");
        sb.append("(SELECT TO_CHAR(t2.FNumber), t1.FCostCenterID as FCostCenterID, t1.FMaterialID as FItemID,t1.FLot as FLot, t1.FCostObjectID as FCostObjectID,");
        sb.append(" t1.FCostItemID as FCostItemID,unit.FName_L2,unit.FID,t4.FOrderID as FOrderID,t4.FBatchNumber as FBatchID,t4.FProjectID as FProjectID,t4.FTrackID as FTrackID,t4.FStdProductIDID as FProductID,assistUnit.FName_L2,SUM(t1.FCommonQty) as FCommonQty, SUM(t1.FQty) as FQty,SUM(t1.FAssistQty) as FAssistQty, ");
        sb.append(" case when SUM(t1.FQty) = 0 then 0 else round(to_decimal(SUM(t1.FAmount),24,12)/to_decimal(SUM(t1.FQty),24,12),t6.FPricePrecision) end as FPrice, \n");
        sb.append(" SUM(t1.FAmount) as FAmount, \n");
        sb.append(" 0 AS FIsTotalRow \n");
        sb.append(", isnull(texp.FID,'ml7t5QEaEADgAAwawKgRe0olWCc='),isnull(texp.FNumber,'5001'),isnull(texp.FName_L2,'\u6750\u6599\u8d39\u7528') ");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" left join t_mm_project po on po.FID = t4.FProjectID \n");
        sb.append(" left join t_mm_trackNumber tr on tr.FID = t4.FTrackID \n");
        sb.append(" left join t_bd_material mat on mat.FID = t4.FStdProductIDID \n");
        sb.append(" join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" left join t_bd_material t6 on t1.FMaterialID = t6.FID  \n");
        sb.append(" left join t_bd_MeasureUnit t7 on t6.FBaseUnit = t7.FID  \n");
        sb.append(" left join T_BD_MeasureUnit unit on t1.FCommonUnitID = unit.FID \n");
        sb.append(" left join T_BD_MeasureUnit assistUnit on t1.FAssistUnitID = assistUnit.FID \n");
        sb.append(" left join t_bd_MaterialCost tmacost on tmacost.FMaterialID = t1.FMaterialID and tmacost.FOrgUnit ='" + companyID + "' \n");
        sb.append(" inner join T_NCM_Expense texp on isnull(tmacost.FExpenseID,'ml7t5QEaEADgAAwawKgRe0olWCc=') = texp.FID  \n");
        sb.append(" left join T_BD_MaterialCompanyInfo t8 on t6.FID = t8.FMaterialID  \n");
        sb.append(" where t1.FCompanyID = ? and t1.FCompanyID=t8.FCompanyID  \n");
        this.buildFilter(filter, sb);
        sb.append(" GROUP BY TO_CHAR(t2.FNumber), t1.FCostCenterID,t1.FMaterialID,t1.FLot, t1.FCostObjectID, t1.FCostItemID ,t4.FOrderID,t4.FBatchNumber,t4.FProjectID,t4.FTrackID,t4.FStdProductIDID,t6.FPricePrecision,unit.FName_L2,unit.FID,assistUnit.FName_L2  \n");
        sb.append(" , texp.FID,texp.FNumber,texp.FName_L2 )\n");
        sb.append(";");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString(), (Object[])new String[]{companyID});
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, tempTableName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sb = new StringBuffer();
        sb.append("UPDATE ").append(tempTableName).append(" SET (FAmountPrecision)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sb.append("\n\n;");
        sb.append(" update " + tempTableName + " as t1  set FCommonqtyPrecision   =(select  max(mmu.FqtyPrecision) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID ");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FAssistqtyPrecision   =(select  isnull(mmu.FqtyPrecision,4) \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" INNER JOIN t_bd_multiMeasureUnit mmu on  t2.Fid=mmu.FMaterialID and t2.FAssistUnit=mmu.FMeasureUnitID ");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        String table1 = "T_IM_MaterialReqBillEntry";
        sb.append(" update " + tempTableName + " as t1  set (FUnitCommonName,FUnitCommonID)   = (select  top 1 t3.FName_L2,t2.FUnitID \n");
        sb.append(" from  " + table1 + " t2  \n");
        sb.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sb.append(" where t2.FMaterialID=t1.FItemID group by t2.FMaterialID,t3.FName_L2,t2.FUnitID )");
        sb.append("\n\n");
        sb.append(";");
        String table2 = "T_IM_OtherInWarehsBillEntry";
        sb.append(" update " + tempTableName + " as t1  set (FUnitCommonName,FUnitCommonID)   = (select  top 1 t3.FName_L2,t2.FUnitID \n");
        sb.append(" from  " + table2 + " t2  \n");
        sb.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sb.append(" where t2.FMaterialID=t1.FItemID group by t2.FMaterialID,t3.FName_L2,t2.FUnitID )");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FCommonqtyPrecision   =(select  max(mmu.FqtyPrecision) \n");
        sb.append(" from t_bd_multiMeasureUnit mmu ");
        sb.append("where t1.FItemID = mmu.FMaterialID and t1.FUnitCommonID = mmu.FMeasureUnitID  ) ");
        sb.append("\n\n");
        sb.append(";");
        String[] fields = this.getGroupByFields((ArrayList)filter.getObject("table"));
        sb.append(" insert into " + tempTableName + "(FTotalRow,FTotalRow2," + fields[0] + ",FAmountPrecision,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision,FCommonQty,FQty,FAssistQty,FAmount) \n");
        sb.append(" SELECT " + fields[1] + ",case when grouping(" + fields[2] + ") = 1 then 1 else 0 end," + fields[0] + " ,isnull(max(FAmountPrecision),2),isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),4),isnull(max(FAssistqtyPrecision),4),isnull(max(FPricePrecision),0),SUM(FCommonQty),SUM(FQty),SUM(FAssistQty),SUM(FAmount) \n");
        sb.append(" FROM " + tempTableName + "\n");
        sb.append(" where FTotalRow = 0 \n");
        sb.append(" group by " + fields[0]);
        sb.append(" with rollup ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1 set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_L2 \n");
        sb.append(" from T_ORG_CostCenter t2 \n");
        sb.append(" where t1.FCostCenterID = t2.FID) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set (FItemNumber,FItemName,FUnitName,FItemModel,FItemShortName,FPricePrecision)   =(select  t2.FNumber, t2.FName_L2, t3.FName_L2,t2.FModel,t2.FShortName,t2.FPricePrecision \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" inner join t_bd_MeasureUnit t3 on t2.FBaseUnit = t3.FID \n");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set FUnitAssistName   =(select  t3.FName_L2 \n");
        sb.append(" from  t_bd_Material t2  \n");
        sb.append(" left join t_bd_MeasureUnit t3 on t2.FAssistUnit = t3.FID \n");
        sb.append("where t1.FItemID = t2.FID  ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1 set (FCostObjectNumber,FCostObjectName,FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FProductNumber,FProductName) = (select t2.FNumber, t2.FName_L2, t2.FOrderNumber,t2.FBatchNumber,po.FNumber,tr.FNumber,pro.FNumber,pro.FName_l2 \n");
        sb.append(" from T_BD_CostObject t2 \n");
        sb.append(" left join t_mm_project po on po.FID = t2.FProjectID \n");
        sb.append(" left join t_mm_trackNumber tr on tr.FID = t2.FTrackID \n");
        sb.append(" left join t_bd_material pro on pro.FID = t2.FStdProductIDID \n");
        sb.append(" where t1.FCostObjectID = t2.FID) \n");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1 set (FProductModel,FProductShortName) = (select t3.FModel,t3.FShortName \n");
        sb.append(" from  T_BD_CostObject t2 ");
        sb.append(" JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t2.FStdProductIDID \n");
        sb.append(" JOIN T_BD_Material t3 ON t3.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
        sb.append(" where t1.FCostObjectID = t2.FID AND T_BD_MaterialCompanyInfo.FCompanyID='").append(companyID).append("'");
        sb.append(" AND T_BD_MaterialCompanyInfo.FStatus = 1 )");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_" + ctx.getLocale() + " \n");
        sb.append(" from t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ");
        sb.append("\n\n");
        sb.append(";");
        sb.append(" update " + tempTableName + " as t1  set (FProductNumber, FProductName )= (select  t2.FNumber,t2.FName_" + ctx.getLocale() + " \n");
        sb.append(" from t_bd_material t2 where  t1.FProductID = t2.FID ) ");
        sb.append("\n\n");
        sb.append(";");
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            if (field.equalsIgnoreCase("FOrderID")) {
                fieldName = "FOrderNumber";
            } else if (field.equalsIgnoreCase("FBatchID")) {
                fieldName = "FBatchNumber";
            } else if (field.equalsIgnoreCase("FProjectID")) {
                fieldName = "FProjectNumber";
            } else if (field.equalsIgnoreCase("FTrackID")) {
                fieldName = "FTrackNumber";
            } else if (field.equalsIgnoreCase("FPeriodID")) {
                fieldName = "FPeriodNumber";
            }
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FitemNumber")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                whichTotal = ", FTotalOrderRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                whichTotal = ", FTotalProjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                whichTotal = ", FTotalTrackRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                whichTotal = ", FTotalProductRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                whichTotal = ", FTotalExpenseRow = 1 ";
            }
            if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID") || fieldName.equalsIgnoreCase("FPeriodNumber") || fieldName.equalsIgnoreCase("FExpenseName")) {
                sb.append(" update " + tempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'");
                sb.append(whichTotal);
                sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sb.append("\n\n");
                sb.append(";");
                continue;
            }
            sb.append(" update " + tempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
            sb.append(whichTotal);
            sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sb.append("\n\n");
            sb.append(";");
        }
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        String totalFieldNumber = orderStrings[0];
        sb.append(" update " + tempTableName + "  set " + totalFieldNumber + " ='" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
        sb.append(" where FTotalRow2 = 1");
        sb.append("\n\n");
        sb.append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
        return tempTableName;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow2 ");
        sql.append(orderByMode);
        sql.append(",");
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FitemNumber")) {
                orderByWhichTotal = ", FTotalMaterialRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                orderByWhichTotal = ", FTotalOrderRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                orderByWhichTotal = ", FTotalBatchRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                orderByWhichTotal = ", FTotalProjectRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                orderByWhichTotal = ", FTotalTrackRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                orderByWhichTotal = ", FTotalProductRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                orderByWhichTotal = ", FTotalExpenseRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                orderByWhichTotal = ", FTotalPeriodRow " + orderByMode;
            }
            if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FExpenseID") || field.equalsIgnoreCase("FPeriodID") || field.equalsIgnoreCase("FTrackID")) {
                sql.append(field);
            } else {
                sql.append(fieldNumber);
            }
            sql.append(orderByWhichTotal);
            sql.append(",");
        }
        sql.append("FTotalRow");
        if (sql.indexOf("FItemNumber") > 0) {
            sql.append(" ,FItemNumber");
        }
        return sql.toString();
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append(" and t2.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        sb.append(" and t2.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        sb.append("\n");
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("itemFrom") != null && !"".equals(filter.getString("itemFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("itemFrom")).append("'");
        }
        if (filter.getString("itemTo") != null && !"".equals(filter.getString("itemTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("itemTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t5.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t5.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
        if (filter.getString("orderNumberFrom") != null && !"".equals(filter.getString("orderNumberFrom"))) {
            sb.append(" and t4.FOrderNumber >='").append(filter.getString("orderNumberFrom")).append("'");
        }
        if (filter.getString("orderNumberTo") != null && !"".equals(filter.getString("orderNumberTo"))) {
            sb.append(" and t4.FOrderNumber <='").append(filter.getString("orderNumberTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t4.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t4.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("productFrom") != null && !"".equals(filter.getString("productFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("productFrom")).append("'");
        }
        if (filter.getString("productTo") != null && !"".equals(filter.getString("productTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("productTo")).append("'");
        }
        if (filter.getString("prmtexpensefrom") != null && !"".equals(filter.getString("prmtexpensefrom"))) {
            sb.append(" and texp.FNumber >='").append(filter.getString("prmtexpensefrom")).append("'");
        }
        if (filter.getString("prmtexpenseto") != null && !"".equals(filter.getString("prmtexpenseto"))) {
            sb.append(" and texp.FNumber <='").append(filter.getString("prmtexpenseto")).append("'");
        }
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private String[] getGroupByFields(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sqlCase = new StringBuffer();
        String firstFields = null;
        sqlCase.append(" case ");
        int n = 105;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            sqlCase.append(" when grouping(" + fieldID + ") = 1 then " + n + " \n");
            if (firstFields == null) {
                firstFields = fieldID;
            }
            n = 104 - i;
        }
        sqlCase.append(" else " + n + " end ");
        return new String[]{sb.toString(), sqlCase.toString(), firstFields};
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"102_MAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"103_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("itemFrom"), filter.getString("itemTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"107_MAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costitemFrom"), filter.getString("costitemTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderNumberFrom"), filter.getString("orderNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_Product", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"46_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtexpensefrom"), filter.getString("prmtexpenseto")));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        Context ctx = this.getContext();
        ArrayList listFields = (ArrayList)filter.getObject("table");
        int index = 0;
        for (int i = 0; i < listFields.size(); ++i) {
            HashMap map = (HashMap)listFields.get(i);
            String fieldID = (String)map.get("id");
            if ("FPeriodID".equals(fieldID)) {
                header.addChild("FPeriodNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++).setMergeable(true);
            }
            if ("FCostCenterID".equals(fieldID)) {
                header.addChild("FCostCenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++).setMergeable(true);
            }
            if ("FitemID".equals(fieldID)) {
                header.addChild("FItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FItemModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FItemShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName_2", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_MaterialLot", (Locale)ctx.getLocale()), index++).setMergeable(true);
            }
            if ("FcostobjectID".equals(fieldID)) {
                header.addChild("FCostObjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++).setMergeable(true);
                header.addChild("FCostObjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++).setMergeable(true);
            }
            if ("FOrderID".equals(fieldID)) {
                header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), index++);
            }
            if ("FBatchID".equals(fieldID)) {
                header.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BatchNumber", (Locale)ctx.getLocale()), index++);
            }
            if ("FProjectID".equals(fieldID)) {
                header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), index++);
            }
            if ("FTrackID".equals(fieldID)) {
                header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), index++);
            }
            if ("FProductID".equals(fieldID)) {
                header.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ProductNumber", (Locale)ctx.getLocale()), index++);
                header.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductName", (Locale)ctx.getLocale()), index++);
                header.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
                header.addChild("FProductShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
            }
            if ("FExpenseID".equals(fieldID)) {
                header.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale()), index++);
                header.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale()), index++);
            }
            if (!"FcostitemID".equals(fieldID)) continue;
            header.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
            header.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        }
        header.addChild("FUnitCommonName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_Funit", (Locale)ctx.getLocale()), index++);
        header.addChild("FCommonQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FqtyPrecision");
        header.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"217_FBaseUnit", (Locale)ctx.getLocale()), index++);
        header.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FCommonqtyPrecision");
        header.addChild("FUnitAssistName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"219_FAssistUnit", (Locale)ctx.getLocale()), index++);
        header.addChild("FAssistQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAssistqtyPrecision");
        header.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        header.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        return header;
    }

    private String[] getHeaderGroups(String fieldID) {
        for (int i = 0; i < headerGroup.length; ++i) {
            String[] groups = (String[])headerGroup[i];
            if (!groups[0].equalsIgnoreCase(fieldID)) continue;
            return groups;
        }
        return null;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        BigDecimal totalRow2 = (BigDecimal)rowData.get("FTOTALROW2");
        if (totalRow2.compareTo(SysConstant.BIGZERO) == 0) {
            RptParams params = new RptParams();
            Object companyorg = totalFilter.getObject("companyorg");
            if (companyorg == null) {
                companyorg = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            params.setObject("companyorg", companyorg);
            String periodNumer = (String)rowData.get("FPERIODNUMBER");
            String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
            String period = "" + Integer.parseInt(periodNumer.substring(4));
            params.setString("yearFrom", year);
            params.setString("yearTo", year);
            params.setString("periodFrom", period);
            params.setString("periodTo", period);
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("itemFrom", (String)rowData.get("FMATNUMBER"));
            params.setString("itemTo", (String)rowData.get("FMATNUMBER"));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            this.addSummaryAndSorterForConnect(params);
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private RptParams addSummaryAndSorterForConnect(RptParams filter) {
        ArrayList tableList = new ArrayList();
        HashMap<String, Object> member = new HashMap<String, Object>();
        member.put("id", "FPeriodID");
        member.put("fieldName", "");
        member.put("isTotal", Boolean.TRUE);
        tableList.add(member);
        member = new HashMap();
        member.put("id", "FcostcenterID");
        member.put("fieldName", "");
        member.put("isTotal", Boolean.TRUE);
        tableList.add(member);
        member = new HashMap();
        member.put("id", "FitemID");
        member.put("fieldName", "");
        member.put("isTotal", Boolean.TRUE);
        tableList.add(member);
        member = new HashMap();
        member.put("id", "FcostobjectID");
        member.put("fieldName", "");
        member.put("isTotal", Boolean.TRUE);
        tableList.add(member);
        member = new HashMap();
        member.put("id", "FcostitemID");
        member.put("fieldName", "");
        member.put("isTotal", Boolean.TRUE);
        tableList.add(member);
        filter.setObject("table", tableList);
        return filter;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }
}

