/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportProperty;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialCostStatReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.MaterialCostStatReport");
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO);

    public HashMap getListAndReportData(String reportID, ReportProperty reportProperty, RptParams filter) throws Exception {
        HashMap result = super.getListAndReportData(reportID, reportProperty, filter);
        return result;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        String yearForm = filter.getObject("spYearFrom").toString();
        String periodFrom = filter.getObject("spPeriodFrom").toString();
        String yearTo = filter.getObject("spYearTo").toString();
        String periodTo = filter.getObject("spPeriodTo").toString();
        String[] physicalTblNames = this.getPhysicalTableName(companyID, yearForm, periodFrom, yearTo, periodTo);
        Integer nObjCountPerPage = Integer.valueOf(filter.getString("costobjectPerPage"));
        if (nObjCountPerPage <= 0) {
            nObjCountPerPage = 20;
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT  distinct t1.FCostObjectID,t5.FNumber FROM ").append(physicalTblNames[4]).append(" t1 ").append("INNER JOIN T_BD_CostObject t5 on t1.FCostObjectID=t5.FID\n").append("left join t_mm_project po on po.FID = t5.FProjectID \n").append("left join t_mm_trackNumber tr on tr.FID = t5.FTrackID \n").append("left join t_bd_material pro on pro.FID = t5.FStdProductIDID \n").append("INNER JOIN T_ORG_CostCenter t6 on t1.FCostCenterID=t6.FID\n").append("INNER JOIN T_BD_Period t7 on t1.FCalculatePeriodID=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t1.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t1.FMaterialID=t9.FID\n").append(" WHERE t1.FCompanyID=? \n");
        this.AppendPredicate(sbSQL, filter, true, "t7.FNumber", "", "");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", ">=", "prmtMaterialFrom");
        this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", "<=", "prmtMaterialTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", ">=", "prmtOrderNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", "<=", "prmtOrderNumberTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", "<=", "txtBathTo");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", ">=", "prmtProjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", "<=", "prmtProjectTo");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", ">=", "prmtTrackFrom");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", "<=", "prmtTrackTo");
        this.AppendPredicate(sbSQL, filter, false, "pro.FNumber", ">=", "prmtProductFrom");
        this.AppendPredicate(sbSQL, filter, false, "pro.FNumber", "<=", "prmtProductTo");
        sbSQL.append("\n ORDER BY t5.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, "costobjectid", "constobjectid", 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            sb.append("'").append(rs.getString("FCostObjectID")).append("',");
            if (i == rs.size() || i % nObjCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString("costobjectid", sb.substring(0, sb.length() - 1).toString());
                drs.insertRow();
                sb = new StringBuffer();
            }
            rs.next();
        }
        if (drs.size() == 0) {
            drs.moveToInsertRow();
            drs.updateString("costobjectid", "''");
            drs.insertRow();
        }
        return drs;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = Integer.valueOf(temp);
        return number;
    }

    private String buildReportData(String reportID, RptParams filter) throws BOSException {
        int i;
        Context ctx = this.getContext();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        String yearForm = filter.getObject("spYearFrom").toString();
        String periodFrom = filter.getObject("spPeriodFrom").toString();
        String yearTo = filter.getObject("spYearTo").toString();
        String periodTo = filter.getObject("spPeriodTo").toString();
        String[] physicalTblNames = this.getPhysicalTableName(companyID, yearForm, periodFrom, yearTo, periodTo);
        String sTmpTblName = this.createTmpTableSQL();
        HashMap objMap = (HashMap)filter.getObject("position");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("Create Table _tempTblCostObjectRange (").append('\n').append("FCostObjectID VARCHAR(44))").append('\n');
        String tempCostObjectRange = NCMDbUtil.createTempTable((Context)ctx, (String)sbSQL.toString());
        sbSQL.setLength(0);
        sbSQL.append("Insert Into " + tempCostObjectRange + " (FCostObjectID) values (?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        boolean isNewConn = false;
        String[] ids = ((String)objMap.get("costobjectid")).indexOf(",") > 0 ? ((String)objMap.get("costobjectid")).replace("'", "").split(",") : new String[]{((String)objMap.get("costobjectid")).replace("'", "")};
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sbSQL.toString());
            for (int i2 = 0; i2 < ids.length; ++i2) {
                pstmt.setString(1, ids[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        sbSQL.setLength(0);
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,FPeriodID,FPeriodNumber,\n").append("\t   FCostObjID,FCostObjNumber,FOrderNumber,FCostObjName,FProductLot,\n").append("\t   FProjectNumber,FTrackNumber,FProductNumber,FProductName,\n").append("\t   FOrderID,FBatchID,FProjectID,FTrackID,FProductID,\n").append("\t   FCostCenterID,FCostCenterNumber,FCostCenterName,\n").append("\t   FCostItemID,FCostItemNumber,FCostItemName,\n").append("\t   FMatID,FMatNumber,FMatName,FMatLot,FMatLotOrder,FMatModel,FMatShortName,\n").append("\t   FObjQ,FBoPCommonQty,FBoPQty,FBoPAssistQty,FBoPAmount,\n").append("      FBefAdjBoPQty,FAdjBoPQty,FBefAdjBoPAmount,FAdjBoPAmount,\n").append("\t   FWIPCommonQ,FWIPQ,FWIPAssistQ,FWIPA,\n").append("      FBefAdjWIPQ,FAdjWIPQ,FBefAdjWIPA,FAdjWIPA,\n").append("\t   FFinishedCommonQ,FFinishedQ,FFinishedAssistQ,FFinishedA,\n").append("\t   FCurInputCommonQ,FCurInputQ,FCurInputAssistQ,FCurInputA,\n").append("\t   FTotalInputCommonQ,FTotalInputQ,FTotalInputAssistQ,FTotalInputA,\n").append("      FYTDInputQ,FYTDInputA,\n").append("      FYTDFinishedQ,FYTDFinishedA,FIsTotalRow,FMaterialPrecision)\n").append("SELECT 0,0,t4.FCompanyID,t4.FCalculatePeriodID,to_char(t7.FNumber),\n").append("       t4.FCostObjectID,t5.FNumber,t5.FOrderNumber,t5.FName_l2,t5.FBatchNumber,\n").append("\t    po.FNumber,tr.FNumber,pro.FNumber,pro.FName_" + ctx.getLocale() + ",\n").append("\t\tt5.FOrderID,t5.FBatchNumber,t5.FProjectID,t5.FTrackID,t5.FStdProductIDID, \n").append("       t4.FCostCenterID,t6.FNumber,t6.FName_l2,\n").append("       t4.FCostItemID,t8.FNumber,t8.FName_l2,\n").append("       t4.FMaterialID,t9.FNumber,t9.FName_l2,\n").append("       t4.FLot,t4.FLot,t9.FModel,t9.FShortName,\n").append("       0, isnull(t3.FAddqty,0),isnull(t3.FQty,0),isnull(t3.FAssistQty,0),isnull(t3.FAmount,0),\n").append("       isnull(t3.FQty,0) - isnull(t3.FAdjQty,0) as FBefAdjQty,isnull(t3.FAdjQty,0), \n").append("       isnull(t3.FAmount,0) - isnull(t3.FAdjAmount,0) as FBefAdjAmount,isnull(t3.FAdjAmount,0),").append("\t\tt4.FEoPWIPAddQty,t4.FEoPWIPQty,t4.FEoPWIPAssistQty,t4.FEoPWIPAmount,\n").append("       isnull(t4.FEoPWIPQty,0) - isnull(t4.FAdjEoPWipQty,0) as FBefAdjEoPWipQty,isnull(t4.FAdjEoPWipQty,0),\n").append("       isnull(t4.FEoPWIPAmount,0) - isnull(t4.FAdjEoPWipAmount,0) as FBefAdjEoPWipAmount, isnull(t4.FAdjEoPWipAmount,0), \n").append("       t4.FFinishedAddQty,t4.FFinishedQty,t4.FFinishedAssistQty,t4.FFinishedAmount,\n").append("       isnull(t4.FEoPWIPAddQty,0) + isnull(t4.FFinishedAddQty,0)-isnull(t3.FAddqty,0),\t\tisnull(t4.FEoPWIPQty,0) - isnull(t4.FAdjEoPWIPQty,0)+isnull(t4.FFinishedQty,0)-isnull(t3.FQty,0),\t\tisnull(t4.FEoPWIPAssistQty,0) + isnull(t4.FFinishedAssistQty,0)-isnull(t3.FAssistQty,0),\t\tisnull(t4.FEoPWIPAmount,0) - isnull(t4.FAdjEoPWIPAmount,0)+isnull(t4.FFinishedAmount,0)-isnull(t3.FAmount,0),\n").append("       isnull(t4.FEoPWIPAddQty,0)+isnull(t4.FFinishedAddQty,0),\t\tisnull(t4.FEoPWIPQty,0) - isnull(t4.FAdjEoPWIPQty,0) + t4.FFinishedQty,\t\tisnull(t4.FEoPWIPAssistQty,0) + isnull(t4.FFinishedAssistQty,0),\t\tisnull(t4.FEoPWIPAmount,0) - isnull(t4.FAdjEoPWIPAmount,0) + t4.FFinishedAmount,\n").append("       isnull(t3.FYTDInputMatQty,0)+t4.FEoPWIPQty+t4.FFinishedQty-isnull(t3.FQty,0),\n").append("\t    isnull(t3.FYTDInputMatAmou,0)+t4.FEoPWIPAmount+t4.FFinishedAmount-isnull(t3.FAmount,0),\n").append("       isnull(t3.FYTDFinishedMatQ,0)+t4.FFinishedQty,isnull(t3.FYTDFinishedMatA,0)+t4.FFinishedAmount,       0 AS FIsTotalRow,pro.Fpriceprecision \n").append("FROM ").append(physicalTblNames[0]).append(" t1\n").append("INNER JOIN ").append(physicalTblNames[1]).append(" t2 on t2.FParentID=t1.FID\n").append("INNER JOIN ").append(physicalTblNames[2]).append(" t3 on t3.FParentID=t2.FID\n").append("RIGHT JOIN ").append(physicalTblNames[4]).append(" t4 on t1.FCompanyOrg=t4.FCompanyID\n").append("       AND t1.FCalculatePeriodID=t4.FCalculatePeriodID\n").append("       AND t4.FCostObjectID=t1.FCostObjectID\n").append("       AND t4.FCostCenterID=t1.FCostCenterID\n").append("       AND t4.FCostItemID=t2.FCostItemID\n").append("       AND t4.FMaterialID=t3.FMaterialID and isnull(t4.FLot,' ')=isnull(t3.FBatchNo, ' ') \n").append("       AND t4.FIsRework = t3.FIsRework \n").append("INNER JOIN T_BD_CostObject t5 on t4.FCostObjectID=t5.FID\n").append("left join t_mm_project po on po.FID = t5.FProjectID \n").append("left join t_mm_trackNumber tr on tr.FID = t5.FTrackID \n").append("left join t_bd_material pro on pro.FID = t5.FStdProductIDID \n").append("INNER JOIN T_ORG_CostCenter t6 on t4.FCostCenterID=t6.FID\n").append("INNER JOIN T_BD_Period t7 on t4.FCalculatePeriodID=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t4.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t4.FMaterialID=t9.FID\n").append(" WHERE t4.FCompanyID=? \n").append(" AND exists (select 1 from ").append(tempCostObjectRange).append(" co where co.FCostObjectID = t4.FCostObjectID) \n");
        this.AppendPredicate(sbSQL, filter, true, "t7.FNumber", "", "");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", ">=", "prmtMaterialFrom");
        this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", "<=", "prmtMaterialTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", ">=", "prmtOrderNumberFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FOrderNumber", "<=", "prmtOrderNumberTo");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(sbSQL, filter, false, "t5.FBatchNumber", "<=", "txtBatchTo");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", ">=", "prmtProjectFrom");
        this.AppendPredicate(sbSQL, filter, false, "po.FNumber", "<=", "prmtProjectTo");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", ">=", "prmtTrackFrom");
        this.AppendPredicate(sbSQL, filter, false, "tr.FNumber", "<=", "prmtTrackTo");
        this.AppendPredicate(sbSQL, filter, false, "pro.FNumber", ">=", "prmtProductFrom");
        this.AppendPredicate(sbSQL, filter, false, "pro.FNumber", "<=", "prmtProductTo");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FObjQ,FUnitCostCommonQ,FUnitCostQ,FUnitCostAssistQ,FUnitCostA)=\n").append("  (SELECT isnull(t2.FFinishedQty,0), \n");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedCommonQ", "isnull(t2.FFinishedQty,0)", ",");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedQ", "isnull(t2.FFinishedQty,0)", ",");
        this.AppendCaseSQLClause(sbSQL, "t1.FFinishedAssistQ", "isnull(t2.FFinishedQty,0)", ",");
        sbSQL.append(" case when isnull(t2.FFinishedQty,0) = 0 then 0 else Round(t1.FFinishedA/isnull(t2.FFinishedQty,0),t1.FMaterialPrecision) end \n");
        sbSQL.append("      FROM ").append(physicalTblNames[5]).append(" t2\n").append("    WHERE t1.FCompanyOrg=t2.FCompanyID \n").append("      AND t1.FPeriodID=t2.FCalculatePeriodID\n").append("      AND t1.FCostObjID=t2.FCostObjectID\n").append("      AND t1.FCostCenterID=t2.FCostCenterID);\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductModel,FProductShortName,FUnitName)=\n").append("  (SELECT t3.FModel,t3.FShortName,t4.FName_L2 FObjUnit \n");
        sbSQL.append("      FROM T_BD_CostObject t2 \n").append("      INNER JOIN T_BD_Material t3 on t2.FStdProductIDID=t3.FID\n").append("      LEFT  JOIN T_BD_MeasureUnit t4 on t3.FBaseUnit=t4.FID\n").append("      WHERE t1.FCostObjID=t2.FID);\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FMatUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FMatID=t2.FID);\n");
        String table = "T_IM_MaterialReqBillEntry";
        sbSQL.append(" update " + sTmpTblName + " as t1  set FMatUnitCommonName   = (select  top 1 t3.FName_L2 \n");
        sbSQL.append(" from  " + table + " t2  \n");
        sbSQL.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sbSQL.append(" where t2.FMaterialID=t1.FMatID group by t2.FMaterialID,t3.FName_L2 )");
        sbSQL.append("\n\n");
        sbSQL.append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FMatUnitAssistName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FAssistUnit=t3.FID\n").append("      WHERE t1.FMatID=t2.FID);\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1 \n").append("    SET (FUnitCostRatio)= \n").append(" (SELECT FSum \n").append("    FROM (SELECT FPeriodNumber FP,FCostObjID FC,SUM(FFinishedA) FSum \n").append("            FROM  ").append(sTmpTblName).append("\n").append("            GROUP BY FPeriodNumber,FCostObjID) as t2\n").append("   WHERE t1.FCostObjID=t2.FC and t1.FPeriodNumber=t2.FP)");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        sbSQL = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodName,FTotalPeriodRow " + orderByMode + ",");
            } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumber,FTotalCostCenterRow " + orderByMode + ",");
            } else if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjNumber,FTotalCostObjectRow " + orderByMode + ",");
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumber,FTotalCostItemRow " + orderByMode + ",");
            } else if ("FMatID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMatNumber,FTotalMaterialRow " + orderByMode + ",");
            } else if ("FOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FOrderID,FTotalOrderRow " + orderByMode + ",");
            } else if ("FBatchID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FBatchID,FTotalBatchRow " + orderByMode + ",");
            } else if ("FProjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProjectID,FTotalProjectRow " + orderByMode + ",");
            } else if ("FTrackID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FTrackID,FTotalTrackRow " + orderByMode + ",");
            } else if ("FProductID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProductID,FTotalProductRow " + orderByMode + ",");
            }
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            totalrows.put(fieldID, totalrow--);
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                if ("FPeriodID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FPeriodID,FPeriodNumber,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FCostObjID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostObjID,FProductModel,FProductShortName,FProductLot,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostItemID,");
                    continue;
                }
                if ("FMatID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FMatID,FMatNumber,FMatName,FMatModel,FMatShortName,FMatUnitCommonName,FMatUnitName,FMatUnitAssistName,");
                    continue;
                }
                if ("FMatID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FMatID,FMatNumber,FMatName,FMatModel,FMatShortName,FMatUnitCommonName,FMatUnitName,FMatUnitAssistName,");
                    continue;
                }
                if ("FBatch".equalsIgnoreCase(subFieldID)) {
                    fields.append("FMatLot,");
                    continue;
                }
                if ("FBatchID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FBatchID,");
                    continue;
                }
                if ("FProjectID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FProjectID,");
                    continue;
                }
                if ("FTrackID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FTrackID,");
                    continue;
                }
                if (!"FProductID".equalsIgnoreCase(subFieldID)) continue;
                fields.append("FProductID,");
            }
            fields.deleteCharAt(fields.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("\n").append("  (FCompanyOrg,FTotalRow,FTotalRow2,\n").append("  " + fields + ",\n");
            sbSQL.append("  FUnitCostRatio,FUnitCostCommonQ,FUnitCostQ,FUnitCostAssistQ,FUnitCostA,\n");
            sbSQL.append("\tFBoPAmount,FWIPA,\n").append("   FBefAdjBoPAmount,FAdjBoPAmount,\n").append("   FBefAdjWIPA,FAdjWIPA,\n").append("\tFFinishedA,FTotalInputA,\n").append("   FYTDFinishedA,FYTDInputA,\n");
            if (fields.indexOf("FMatID") > 0 || fields.indexOf("FMatLot") > 0) {
                sbSQL.append(" FBoPCommonQty, ");
                sbSQL.append(" FBoPQty, ");
                sbSQL.append(" FBefAdjBoPQty, ");
                sbSQL.append(" FAdjBoPQty, ");
                sbSQL.append(" FBoPAssistQty, ");
                sbSQL.append(" FCurInputCommonQ, ");
                sbSQL.append(" FCurInputQ, ");
                sbSQL.append(" FCurInputAssistQ, ");
                sbSQL.append(" FTotalInputCommonQ, ");
                sbSQL.append(" FTotalInputQ, ");
                sbSQL.append(" FTotalInputAssistQ, ");
                sbSQL.append(" FFinishedCommonQ, ");
                sbSQL.append(" FFinishedQ, ");
                sbSQL.append(" FFinishedAssistQ, ");
                sbSQL.append(" FWIPCommonQ, ");
                sbSQL.append(" FWIPQ, ");
                sbSQL.append(" FBefAdjWIPQ, ");
                sbSQL.append(" FAdjWIPQ, ");
                sbSQL.append(" FWIPAssistQ, ");
            }
            sbSQL.append("FCurInputA,FMaterialPrecision) SELECT '" + companyID + "', 0,").append(totalrows.get(fieldID)).append("\n").append("  ," + fields + ",\n");
            if ("FCostCenterID".equalsIgnoreCase(fieldID) || "FPeriodID".equalsIgnoreCase(fieldID)) {
                sbSQL.append(" 0, ");
                sbSQL.append(" 0, ");
                sbSQL.append(" 0, ");
                sbSQL.append(" 0, ");
                sbSQL.append(" 0, ");
            } else {
                sbSQL.append("  MAX(FUnitCostRatio),");
                this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedCommonQ)", "MAX(FObjQ)", ",\n");
                this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedQ)", "MAX(FObjQ)", ",\n");
                this.AppendCaseSQLClause(sbSQL, "SUM(FFinishedAssistQ)", "MAX(FObjQ)", ",\n");
                sbSQL.append(" SUM(FUnitCostA), \n");
            }
            sbSQL.append("  SUM(FBoPAmount),SUM(FWIPA),\n").append("  SUM(FBefAdjBoPAmount),SUM(FAdjBoPAmount),\n").append("  SUM(FBefAdjWIPA),SUM(FAdjWIPA),\n").append("  SUM(FFinishedA),SUM(FTotalInputA),\n").append("  SUM(FYTDFinishedA),SUM(FYTDInputA),\n");
            if (fields.indexOf("FMatID") > 0 || fields.indexOf("FMatLot") > 0) {
                sbSQL.append(" sum(FBoPCommonQty), ");
                sbSQL.append(" sum(FBoPQty), ");
                sbSQL.append(" sum(FBefAdjBoPQty), ");
                sbSQL.append(" sum(FAdjBoPQty), ");
                sbSQL.append(" sum(FBoPAssistQty), ");
                sbSQL.append(" sum(FCurInputCommonQ), ");
                sbSQL.append(" sum(FCurInputQ), ");
                sbSQL.append(" sum(FCurInputAssistQ), ");
                sbSQL.append(" sum(FTotalInputCommonQ), ");
                sbSQL.append(" sum(FTotalInputQ), ");
                sbSQL.append(" sum(FTotalInputAssistQ), ");
                sbSQL.append(" sum(FFinishedCommonQ), ");
                sbSQL.append(" sum(FFinishedQ), ");
                sbSQL.append(" sum(FFinishedAssistQ), ");
                sbSQL.append(" sum(FWIPCommonQ), ");
                sbSQL.append(" sum(FWIPQ), ");
                sbSQL.append(" sum(FBefAdjWIPQ), ");
                sbSQL.append(" sum(FAdjWIPQ), ");
                sbSQL.append(" sum(FWIPAssistQ), ");
            }
            sbSQL.append("  SUM(FCurInputA),max(FMaterialPrecision) \n").append(" FROM " + sTmpTblName + "\n").append(" WHERE FTotalRow2 = 0 \n");
            sbSQL.append(" GROUP BY " + fields);
            sbSQL.append("\n\n").append(";");
        }
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FObjQ)=\n").append("  (SELECT isnull(t2.FFinishedQty,0)\n");
        sbSQL.append("      FROM ").append(physicalTblNames[5]).append(" t2\n").append("    WHERE t1.FCompanyOrg=t2.FCompanyID \n").append("      AND t1.FPeriodID=t2.FCalculatePeriodID\n").append("      AND t1.FCostObjID=t2.FCostObjectID\n").append("      AND t1.FCostCenterID=t2.FCostCenterID)").append("  where FTotalRow2 <> 0;\n\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductModel,FProductShortName,FUnitName)=\n").append("  (SELECT t3.FModel,t3.FShortName,t4.FName_L2 FObjUnit \n");
        sbSQL.append("      FROM T_BD_CostObject t2 \n").append("      INNER JOIN T_BD_Material t3 on t2.FStdProductIDID=t3.FID\n").append("      LEFT  JOIN T_BD_MeasureUnit t4 on t3.FBaseUnit=t4.FID\n").append("      WHERE t1.FCostObjID=t2.FID)").append("  where FTotalRow2 <> 0;\n\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" Update ").append(sTmpTblName).append("\n Set FUnitCostRatio= 100* \n");
        this.AppendCaseSQLClause(sbSQL, "FFinishedA", "FUnitCostRatio", " \n\n;");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumber,FCostCenterName) =(select  t2.FNumber, t2.FName_L2 \n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FPeriodName) = (select to_char(t2.FNumber) \n").append(" FROM T_BD_Period t2 ").append(" WHERE t1.FPeriodID = t2.FID )").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostObjNumber ,FCostObjName,FProductModel,FProductShortName,FOrderNumber, FProjectNumber,FTrackNumber,FProductNumber,FProductName) = (select t2.FNumber, t2.FName_L2, t3.FModel,t3.FShortName,t2.FOrderNumber, po.FNumber,tr.FNumber,pro.FNumber,pro.FName_" + ctx.getLocale() + " \n").append(" FROM T_BD_CostObject t2 ").append(" INNER JOIN t_bd_Material t3 on t2.FRelatedID = t3.FID  \n").append(" left join t_mm_project po on po.FID = t2.FProjectID \n").append(" left join t_mm_trackNumber tr on tr.FID = t2.FTrackID \n").append(" left join t_bd_material pro on pro.FID = t2.FStdProductIDID \n").append(" WHERE t1.FCostObjID = t2.FID )").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append("\n\n").append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("  (FTotalRow,FTotalRow2,FCompanyOrg,").append("\t\t FBoPAmount,FWIPA,\n").append("         FAdjBoPAmount,FBefAdjBoPAmount,\n").append("         FAdjWIPA,FBefAdjWIPA,\n").append("\t\t FFinishedA,FTotalInputA,\n").append("        FYTDFinishedA,FYTDInputA,\n").append("        FCurInputA) ").append(" SELECT 1,105, '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',").append("  SUM(FBoPAmount),SUM(FWIPA),\n").append("  SUM(FAdjBoPAmount),SUM(FBefAdjBoPAmount),\n").append("  SUM(FAdjWIPA),SUM(FBefAdjWIPA),\n").append("  SUM(FFinishedA),SUM(FTotalInputA),\n").append("  SUM(FYTDFinishedA),SUM(FYTDInputA),\n").append("  SUM(FCurInputA)\n").append(" FROM " + sTmpTblName + "\n").append(" where FTotalRow2 = 0 \n").append(";\n\n");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        for (i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjNumber")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMatNumber")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                whichTotal = ", FTotalMaterialLotRow = 1 ";
            }
            if (field.equalsIgnoreCase("FOrderID")) {
                whichTotal = ", FTotalOrderRow = 1 ";
            }
            if (field.equalsIgnoreCase("FBatchID")) {
                fieldNumber = "FProductLot";
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (field.equalsIgnoreCase("FProjectID")) {
                whichTotal = ", FTotalProjectRow = 1 ";
            }
            if (field.equalsIgnoreCase("FTrackID")) {
                whichTotal = ", FTotalTrackRow = 1 ";
            }
            if (field.equalsIgnoreCase("FProductID")) {
                whichTotal = ", FTotalProductRow = 1 ";
            }
            if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID")) {
                sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldNumber).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append(" FMatLotOrder = FMatLot \n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
                continue;
            }
            if ("FPeriodNumber".equals(fieldNumber)) {
                sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldNumber).append("=" + fieldNumber + " || '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append(fieldName).append(" = ").append(fieldName + "\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
                continue;
            }
            if ("FBatNumber".equals(fieldNumber)) {
                sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET FMatLot").append(" = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append(" FMatLotOrder = FMatLot \n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
                continue;
            }
            sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldName).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',\n").append(fieldNumber).append(" = ").append(fieldNumber + "\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        sbSQL = new StringBuffer();
        sbSQL.append(" Update ").append(sTmpTblName).append("\n Set FCompanyOrg= '").append(info.getName()).append("'").append(" WHERE FTotalRow2<105;\n\n");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FUNITCOSTCommonQ=null,FUNITCOSTQ=null,FUNITCOSTAssistQ=null where FTotalRow2>0 and ftotalMaterialRow = 0 and FTotalBatchRow = 0; \n\n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FCoQtyPrecision= \n").append(" (SELECT T4.FqtyPrecision \n").append(" FROM T_BD_CostObject T2 \n").append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n").append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n").append(" WHERE " + sTmpTblName + ".FCostObjID=T2.FID ); \n\n");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatQtyPrecision= \n").append(" (SELECT mmu.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FBaseUnit=T4.fid\n").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FBaseUnit=T4.fid) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatAssistQtyPrecision= \n").append(" (SELECT mmu.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FAssistUnit=T4.fid\n").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatAssistQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FAssistUnit=T4.fid) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" SET FMatCommonQtyPrecision= \n").append(" (SELECT max(mmu.FqtyPrecision) \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID and mmu.FMeasureUnitID = T3.FBaseUnit ").append(" WHERE " + sTmpTblName + ".FMatID=T3.FID ) \n").append(" WHERE FTotalRow2=0 \n\n;");
        sbSQL.append(" UPDATE " + sTmpTblName).append(" \n").append(" SET FMatCommonQtyPrecision= \n").append(" (SELECT MAX(mmu.FqtyPrecision) \n").append("  FROM " + sTmpTblName).append(" t2\n").append("  INNER JOIN t_bd_Material T3 ON t2.FMatID=t3.FID \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID ").append("  INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID ) \n").append(" WHERE FTotalRow2>0 \n\n;");
        sbSQL.append("UPDATE ").append(sTmpTblName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        sbSQL.append(" DELETE " + sTmpTblName + " \n");
        sbSQL.append("  WHERE FTOTALROW2 > 0 \n");
        sbSQL.append("    AND ((FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostCenterNumber is null OR FCostCenterNumber = '')) OR \n");
        sbSQL.append("         (FCostObjName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostObjNumber is null OR FCostObjNumber = '')) OR \n");
        sbSQL.append("         (FProductName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FProductNumber is null OR FProductNumber = '')) OR \n");
        sbSQL.append("         (FOrderNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FOrderID is null OR FOrderID = '')) OR \n ");
        sbSQL.append("         (FProjectNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FProjectID is null OR FProjectID = '')) OR \n ");
        sbSQL.append("         (FProductLot = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FBatchID is null OR FBatchID = '')) OR \n ");
        sbSQL.append("         (FTrackNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FTrackID is null OR FTrackID = '')) OR\n ");
        sbSQL.append("         (FMatLot = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FMatLotOrder is null OR FMatLotOrder = '')) )\n ");
        sbSQL.append("    AND FTotalRow2 != 3 \n");
        sbSQL.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL.setLength(0);
        sbSQL.append(" UPDATE " + sTmpTblName + " \n");
        sbSQL.append(" SET FBoPCommonQty = ROUND(FBoPCommonQty,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FBoPQty = ROUND(FBoPQty,FMatQtyPrecision) \n");
        sbSQL.append("    ,FBoPAssistQty = ROUND(FBoPAssistQty,FMatAssistQtyPrecision) \n");
        sbSQL.append("    ,FCurInputCommonQ = ROUND(FCurInputCommonQ,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FCurInputQ = ROUND(FCurInputQ,FMatQtyPrecision) \n");
        sbSQL.append("    ,FCurInputAssistQ = ROUND(FCurInputAssistQ,FMatAssistQtyPrecision) \n");
        sbSQL.append("    ,FTotalInputCommonQ = ROUND(FTotalInputCommonQ,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FTotalInputQ = ROUND(FTotalInputQ,FMatQtyPrecision) \n");
        sbSQL.append("    ,FTotalInputAssistQ = ROUND(FTotalInputAssistQ,FMatAssistQtyPrecision) \n");
        sbSQL.append("    ,FFinishedCommonQ = ROUND(FFinishedCommonQ,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FFinishedQ = ROUND(FFinishedQ,FMatQtyPrecision) \n");
        sbSQL.append("    ,FFinishedAssistQ = ROUND(FFinishedAssistQ,FMatAssistQtyPrecision) \n");
        sbSQL.append("    ,FWIPCommonQ = ROUND(FWIPCommonQ,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FWIPQ = ROUND(FWIPQ,FMatQtyPrecision) \n");
        sbSQL.append("    ,FWIPAssistQ = ROUND(FWIPAssistQ,FMatAssistQtyPrecision) \n");
        sbSQL.append("    ,FUnitCostCommonQ = ROUND(FUnitCostCommonQ,FMatCommonQtyPrecision) \n");
        sbSQL.append("    ,FUnitCostQ = ROUND(FUnitCostQ,FMatQtyPrecision) \n");
        sbSQL.append("    ,FUnitCostAssistQ = ROUND(FUnitCostAssistQ,FMatAssistQtyPrecision) \n");
        sbSQL.append("\n\n;");
        sbSQL.append(" update " + sTmpTblName + " as t \n");
        sbSQL.append("set FAdjBoPCommonQty = case when FBoPQty = 0 then 0 else FAdjBoPQty*FBoPCommonQty/FBoPQty end, \n");
        sbSQL.append("     FBefAdjBoPCommonQty = case when FBoPQty = 0 then 0 else FBefAdjBoPQty*FBoPCommonQty/FBoPQty end , \n");
        sbSQL.append("     FAdjBoPAssistQty = case when FBoPQty = 0 then 0 else FAdjBoPQty*FBoPAssistQty/FBoPQty end , \n");
        sbSQL.append("     FBefAdjBoPAssistQty = case when FBoPQty = 0 then 0 else FBefAdjBoPQty*FBoPAssistQty/FBoPQty end, \n");
        sbSQL.append("     FAdjWIPCommonQ = case when FWIPQ = 0 then 0 else FAdjWIPQ*FWIPCommonQ/FWIPQ end, \n");
        sbSQL.append("     FBefAdjWIPCommonQ = case when FWIPQ = 0 then 0 else FBefAdjWIPQ*FWIPCommonQ/FWIPQ end, \n");
        sbSQL.append("     FAdjWIPAssistQ = case when FWIPQ = 0 then 0 else FAdjWIPQ*FWIPAssistQ/FWIPQ end, \n");
        sbSQL.append("     FBefAdjWIPAssistQ = case when FWIPQ = 0 then 0 else FBefAdjWIPQ*FWIPAssistQ/FWIPQ end \n");
        sbSQL.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        if (tempCostObjectRange != null) {
            NCMDbUtil.releaseTempTable((Context)ctx, (String)tempCostObjectRange);
        }
        return sTmpTblName;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        return this.buildReportData(reportID, filter);
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        if (tableName == null) {
            tableName = this.createTmpTableSQL();
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = " ";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        StringBuffer orderBy = this.getSortString((ArrayList)filter.getObject("table"), orderByMode);
        String sql = null;
        sql = orderBy != null ? "SELECT * FROM " + tableName + where + " Order by  FTotalRow " + orderByMode + ", " + orderBy.toString() + " FTotalRow2" : "SELECT * FROM " + tableName + where + " Order by  FTotalRow " + orderByMode + ", FTotalRow2";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String sTmpTblName = this.buildReportData(reportID, filter);
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = " ";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        ArrayList tblData = (ArrayList)filter.getObject("table");
        StringBuffer orderBy = this.getSortString(tblData, orderByMode);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT  * FROM " + sTmpTblName + where + " Order by  FTotalRow " + orderByMode + "," + orderBy.toString() + " FTotalRow2 "));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        return rs;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String sAlias) {
        sb.append("CASE ").append(sDenominator).append(" WHEN 0 THEN 0 ").append(" ELSE TO_Decimal(").append(sNumerator).append(",21,8)").append("     /TO_Decimal(").append(sDenominator).append(",21,8) END ").append(sAlias);
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", 104 - i);
            newList.add(map);
        }
        return newList;
    }

    private String[] getPhysicalTableName(String companyID, String yearFrom, String periodFrom, String yearTo, String periodTo) throws BOSException {
        String[] physicalTblNames = new String[6];
        String[] logicalTblNames = new String[]{"T_NCM_Balance", "T_NCM_BalanceEntry", "T_NCM_BalanceMatDetail", "T_NCM_CostCalResult", "T_NCM_CostCalMatDetailResult", "T_NCM_DataByCostObj"};
        try {
            int periodFromNumber = this.getPeriodNumber(companyID, yearFrom, periodFrom);
            int periodToNumber = this.getPeriodNumber(companyID, yearTo, periodTo);
            for (int i = 0; i < logicalTblNames.length; ++i) {
                physicalTblNames[i] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)logicalTblNames[i], (int)periodFromNumber, (int)periodToNumber);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return physicalTblNames;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostObjID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FOrderNumber varchar(80) default('')");
        createTable.append(",FProjectNumber varchar(80) default('')");
        createTable.append(",FTrackNumber varchar(80) default('')");
        createTable.append(",FProductName varchar(255) default('')");
        createTable.append(",FProductNumber varchar(80) default('')");
        createTable.append(",FOrderID varchar(44) ");
        createTable.append(",FBatchID varchar(255) ");
        createTable.append(",FProjectID varchar(44) ");
        createTable.append(",FTrackID varchar(44) ");
        createTable.append(",FProductID varchar(44) ");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FProductLot varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FObjQ NUMERIC(21,8) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FMatID varchar(44) ");
        createTable.append(",FMatNumber varchar(80) not null default(' ') ");
        createTable.append(",FMatName varchar(255) ");
        createTable.append(",FMatModel nvarchar(255) ");
        createTable.append(",FMatShortName nvarchar(80) ");
        createTable.append(",FMatUnitCommonName varchar(80) ");
        createTable.append(",FMatUnitName varchar(255) ");
        createTable.append(",FMatUnitAssistName varchar(80) ");
        createTable.append(",FMatLot nvarchar(80) ");
        createTable.append(",FMatLotOrder nvarchar(80) ");
        createTable.append(",FBoPCommonQty NUMERIC(21,8) ");
        createTable.append(",FAdjBoPCommonQty NUMERIC(21,8) ");
        createTable.append(",FBefAdjBoPCommonQty NUMERIC(21,8) ");
        createTable.append(",FBoPQty NUMERIC(21,8) ");
        createTable.append(",FBefAdjBoPQty NUMERIC(21,8) ");
        createTable.append(",FAdjBoPQty NUMERIC(21,8) ");
        createTable.append(",FBoPAssistQty NUMERIC(21,8) ");
        createTable.append(",FAdjBoPAssistQty NUMERIC(21,8) ");
        createTable.append(",FBefAdjBoPAssistQty NUMERIC(21,8) ");
        createTable.append(",FBoPAmount NUMERIC(17,4) ");
        createTable.append(",FBefAdjBoPAmount NUMERIC(17,4) ");
        createTable.append(",FAdjBoPAmount NUMERIC(17,4) ");
        createTable.append(",FCurInputCommonQ NUMERIC(21,8) ");
        createTable.append(",FCurInputQ NUMERIC(21,8) ");
        createTable.append(",FCurInputAssistQ NUMERIC(21,8) ");
        createTable.append(",FCurInputA NUMERIC(17,4) ");
        createTable.append(",FTotalInputCommonQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputAssistQ NUMERIC(21,8) ");
        createTable.append(",FTotalInputA NUMERIC(17,4) ");
        createTable.append(",FFinishedCommonQ NUMERIC(21,8) ");
        createTable.append(",FFinishedQ NUMERIC(21,8) ");
        createTable.append(",FFinishedAssistQ NUMERIC(21,8) ");
        createTable.append(",FFinishedA NUMERIC(17,4) ");
        createTable.append(",FWIPCommonQ NUMERIC(21,8) ");
        createTable.append(",FAdjWIPCommonQ NUMERIC(21,8) ");
        createTable.append(",FBefAdjWIPCommonQ NUMERIC(21,8) ");
        createTable.append(",FWIPQ NUMERIC(21,8) ");
        createTable.append(",FBefAdjWIPQ NUMERIC(21,8) ");
        createTable.append(",FAdjWIPQ NUMERIC(21,8) ");
        createTable.append(",FWIPAssistQ NUMERIC(21,8) ");
        createTable.append(",FAdjWIPAssistQ NUMERIC(21,8) ");
        createTable.append(",FBefAdjWIPAssistQ NUMERIC(21,8) ");
        createTable.append(",FWIPA NUMERIC(17,4) ");
        createTable.append(",FBefAdjWIPA NUMERIC(17,4) ");
        createTable.append(",FAdjWIPA NUMERIC(17,4) ");
        createTable.append(",FUnitCostCommonQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostAssistQ NUMERIC(21,8) ");
        createTable.append(",FUnitCostA NUMERIC(24,12) ");
        createTable.append(",FUnitCostRatio NUMERIC(17,4) ");
        createTable.append(",FYTDInputQ NUMERIC(21,8) ");
        createTable.append(",FYTDInputA NUMERIC(17,4) ");
        createTable.append(",FYTDFinishedQ NUMERIC(21,8) ");
        createTable.append(",FYTDFinishedA NUMERIC(17,4) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialLotRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalOrderRow int not null default(0) ");
        createTable.append(" ,FTotalBatchRow int not null default(0) ");
        createTable.append(" ,FTotalProjectRow int not null default(0) ");
        createTable.append(" ,FTotalTrackRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(",FCoQtyPrecision int default(0) ");
        createTable.append(",FMatCommonQtyPrecision int default(0) ");
        createTable.append(",FMatQtyPrecision int default(0) ");
        createTable.append(",FMatAssistQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(",FMaterialPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"3_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spYearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("spPeriodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"112_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtCostCenterFrom"), filter.getString("prmtCostCenterTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"113_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtCostObjectFrom"), filter.getString("prmtCostObjectTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"115_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtCostItemFrom"), filter.getString("prmtCostItemTo")));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtOrderNumberFrom"), filter.getString("prmtOrderNumberTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("txtBatchFrom"), filter.getString("txtBathTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtProjectFrom"), filter.getString("prmtProjectTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtTrackFrom"), filter.getString("prmtTrackTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_Product", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("prmtProductFrom"), filter.getString("prmtProductTo")));
        return titles;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        Context ctx = this.getContext();
        if (rowData.containsKey("FBEGPROAMOUNT") && rowData.containsKey("FCURINAMOUNT")) {
            BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
            String costItemType = (String)rowData.get("FCOSTITEMTYPE");
            if (totalRow != null && totalRow.compareTo(ZERO) == 0 && "1".equals(costItemType)) {
                RptParams params = new RptParams();
                Object companyOrg = totalFilter.getObject("prmtCompanyOrg");
                if (companyOrg == null) {
                    companyOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
                params.setObject("prmtCompanyOrg", companyOrg);
                ArrayList tableList = new ArrayList();
                HashMap<String, Object> member = new HashMap<String, Object>();
                member.put("id", "FPeriodID");
                member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostObjID");
                member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostCenterID");
                member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostItemID");
                member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                params.setObject("table", tableList);
                params.setObject("costobjectPerPage", (Object)new String("1"));
                String periodNumer = (String)rowData.get("FPERIODNAME");
                String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
                String period = "" + Integer.parseInt(periodNumer.substring(5));
                params.setString("spYearFrom", year);
                params.setString("spYearTo", year);
                params.setString("spPeriodFrom", period);
                params.setString("spPeriodTo", period);
                params.setString("prmtCostCenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
                params.setString("prmtCostCenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
                params.setString("prmtCostObjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
                params.setString("prmtCostObjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
                params.setString("prmtCostItemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
                params.setString("prmtCostItemTo", (String)rowData.get("FCOSTITEMNUMBER"));
                params.setString("showAssistQty", "false");
                params.setString("showQty", "false");
                return params;
            }
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        if (rowData.containsKey("FTOTALCOSTAMT") && rowData.containsKey("FUNITCOSTAMT")) {
            BigDecimal totalRow = null;
            Object temp = rowData.get("FISTOTAL");
            if (temp instanceof BigDecimal) {
                totalRow = (BigDecimal)temp;
            } else if (temp instanceof Integer) {
                totalRow = new BigDecimal((Integer)temp);
            }
            String costItemType = (String)rowData.get("FCOSTITEMTYPE");
            if (totalRow != null && totalRow.compareTo(ZERO) == 0 && "1".equals(costItemType)) {
                RptParams params = new RptParams();
                Object companyOrg = totalFilter.getObject("prmtCompanyOrg");
                if (companyOrg == null) {
                    companyOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
                params.setObject("prmtCompanyOrg", companyOrg);
                ArrayList tableList = new ArrayList();
                HashMap<String, Object> member = new HashMap<String, Object>();
                member.put("id", "FPeriodID");
                member.put("fieldName", "");
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostObjID");
                member.put("fieldName", "");
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostCenterID");
                member.put("fieldName", "");
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                member = new HashMap();
                member.put("id", "FCostItemID");
                member.put("fieldName", "");
                member.put("isTotal", Boolean.TRUE);
                tableList.add(member);
                params.setObject("table", tableList);
                params.setObject("costobjectPerPage", (Object)new String("1"));
                String periodNumer = (String)rowData.get("FPERIODNUMBER");
                String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
                String period = "" + Integer.parseInt(periodNumer.substring(4, 6));
                params.setString("spYearFrom", year);
                params.setString("spYearTo", year);
                params.setString("spPeriodFrom", period);
                params.setString("spPeriodTo", period);
                params.setString("prmtCostCenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
                params.setString("prmtCostCenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
                params.setString("prmtCostObjectFrom", (String)rowData.get("FCOSTOBJNUMBER"));
                params.setString("prmtCostObjectTo", (String)rowData.get("FCOSTOBJNUMBER"));
                params.setString("prmtCostItemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
                params.setString("prmtCostItemTo", (String)rowData.get("FCOSTITEMNUMBER"));
                params.setString("showAssistQty", "false");
                params.setString("showQty", "false");
                return params;
            }
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        boolean index = false;
        Context ctx = this.getContext();
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale())).setMergeable(true);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale())).setMergeable(true);
        header.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductNumber", (Locale)ctx.getLocale())).setMergeable(true);
        header.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProductName", (Locale)ctx.getLocale())).setMergeable(true);
        ArrayList tblData = (ArrayList)filter.getObject("table");
        ArrayList childs = header.getChilds();
        HashMap<String, ReportHeader> headerMap = new HashMap<String, ReportHeader>();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            ReportHeader child = (ReportHeader)childs.get(i2);
            String fieldName = child.getFieldName().toLowerCase();
            headerMap.put(fieldName.toLowerCase(), child);
        }
        ArrayList temp = new ArrayList(childs.size());
        temp.addAll(childs);
        childs.clear();
        ArrayList<String> sortedCols = new ArrayList<String>();
        sortedCols.add("FCompanyOrg");
        int qtyCounter = 0;
        for (i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FPeriodNumber");
                ++qtyCounter;
            }
            if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostObjNumber");
                sortedCols.add("FCostObjName");
                sortedCols.add("FOrderNumber");
                sortedCols.add("FProductLot");
                sortedCols.add("FProjectNumber");
                sortedCols.add("FTrackNumber");
                sortedCols.add("FProductNumber");
                sortedCols.add("FProductName");
                sortedCols.add("FProductModel");
                sortedCols.add("FProductShortName");
                sortedCols.add("FUnitName");
                ++qtyCounter;
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostCenterNumber");
                sortedCols.add("FCostCenterName");
                ++qtyCounter;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FCostItemNumber");
                sortedCols.add("FCostItemName");
            }
            if ("FMatID".equalsIgnoreCase(fieldID)) {
                sortedCols.add("FMatNumber");
                sortedCols.add("FMatName");
                sortedCols.add("FMatModel");
                sortedCols.add("FMatShortName");
                sortedCols.add("FMatUnitCommonName");
                sortedCols.add("FMatUnitName");
                sortedCols.add("FMatUnitAssistName");
                sortedCols.add("FMatLot");
            }
            if (qtyCounter != 3) continue;
            sortedCols.add("FObjQ");
            qtyCounter = 0;
        }
        for (i = 0; i < sortedCols.size(); ++i) {
            String field = (String)sortedCols.get(i);
            ReportHeader child = (ReportHeader)headerMap.get(field.toLowerCase());
            if (child == null) continue;
            childs.add(child);
            temp.remove(child);
        }
        childs.addAll(temp);
        HashSet<String> removes = new HashSet<String>();
        if (filter.getString("showQty") != null && filter.getString("showQty").equalsIgnoreCase("false")) {
            removes.add("FBoPCommonQty".toLowerCase());
            removes.add("FAdjBoPCommonQty".toLowerCase());
            removes.add("FBefAdjBoPCommonQty".toLowerCase());
            removes.add("FCurInputCommonQ".toLowerCase());
            removes.add("FTotalInputCommonQ".toLowerCase());
            removes.add("FFinishedCommonQ".toLowerCase());
            removes.add("FWIPCommonQ".toLowerCase());
            removes.add("FAdjWIPCommonQ".toLowerCase());
            removes.add("FBefAdjWIPCommonQ".toLowerCase());
            removes.add("FUnitCostCommonQ".toLowerCase());
        }
        if (filter.getString("showAssistQty") != null && filter.getString("showAssistQty").equalsIgnoreCase("false")) {
            removes.add("FBoPAssistQty".toLowerCase());
            removes.add("FAdjBoPAssistQty".toLowerCase());
            removes.add("FBefAdjBoPAssistQty".toLowerCase());
            removes.add("FCurInputAssistQ".toLowerCase());
            removes.add("FTotalInputAssistQ".toLowerCase());
            removes.add("FFinishedAssistQ".toLowerCase());
            removes.add("FWIPAssistQ".toLowerCase());
            removes.add("FAdjWIPAssistQ".toLowerCase());
            removes.add("FBefAdjWIPAssistQ".toLowerCase());
            removes.add("FUnitCostAssistQ".toLowerCase());
        }
        if (removes.size() > 0) {
            this.removeChildHeaders(header, removes);
        }
        ArrayList childList = header.getChilds();
        ArrayList childChildList = null;
        ReportHeader childHeader = null;
        ReportHeader childChildHeader = null;
        String fieldName = null;
        String childFieldName = null;
        for (int i3 = 0; i3 < childList.size(); ++i3) {
            int j;
            childHeader = (ReportHeader)childList.get(i3);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCurInput")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"72_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FCurInputA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FCurInputCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FCurInputQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FCurInputAssistQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FTotalInput")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"TotalInput", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FTotalInputCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FTotalInputQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FTotalInputAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FTotalInputA")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FFinished")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Finished", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FFinishedQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FFinishedAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FFinishedA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FFinishedCommonQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FCompanyOrg")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CompanyOrgName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FWIP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjEopWip", (Locale)ctx.getLocale()));
                childHeader.setVisible(false);
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childChildHeader.setVisible(false);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FWIPCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FWIPAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FWIPA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FWIPQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FAdjWIP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjEopWip", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FAdjWIPCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FAdjWIPAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FAdjWIPA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FAdjWIPQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FBefAdjWIP")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjEopWip", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FBefAdjWIPCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FBefAdjWIPAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FBefAdjWIPA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FBefAdjWIPQ")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FUnitCost")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"16_AuxFeeCostCalReport", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FUnitCostCommonQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitCostAssistQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitCostA")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FUnitCostQ")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FUnitCostRatio")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"225_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FCostObjNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"66_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductLot")) {
                childHeader.setCaption("\u4ea7\u54c1\u6279\u6b21");
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FObjQ")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"70_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatUnitCommonName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_Funit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"217_FBaseUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatUnitAssistName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"219_FAssistUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMatlot")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_MaterialLot", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FOrderNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBoPBalance")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AfterAdjBopWip", (Locale)ctx.getLocale()));
                childHeader.setVisible(false);
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childChildHeader.setVisible(false);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FBoPCommonQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FBoPAssistQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FBoPAmount")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FBoPQty")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (fieldName.equals("FAdjBoPBalance")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AdjBopWip", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FAdjBoPCommonQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FAdjBoPAssistQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (childFieldName.equals("FAdjBoPAmount")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FAdjBoPQty")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fieldName.equals("FBefAdjBoPBalance")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BefAdjBopWip", (Locale)ctx.getLocale()));
            childChildList = childHeader.getChilds();
            for (j = 0; j < childChildList.size(); ++j) {
                childChildHeader = (ReportHeader)childChildList.get(j);
                childFieldName = childChildHeader.getFieldName();
                if (childFieldName.equals("FBefAdjBoPCommonQty")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_FCommonQty", (Locale)ctx.getLocale()));
                    continue;
                }
                if (childFieldName.equals("FBefAdjBoPAssistQty")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                    continue;
                }
                if (childFieldName.equals("FBefAdjBoPAmount")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                    continue;
                }
                if (!childFieldName.equals("FBefAdjBoPQty")) continue;
                childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
            }
        }
        return header;
    }

    private void removeChildHeaders(ReportHeader header, Set removes) {
        ArrayList childs = header.getChilds();
        if (childs != null && childs.size() > 0) {
            for (int i = childs.size() - 1; i >= 0; --i) {
                ReportHeader child = (ReportHeader)childs.get(i);
                String fieldName = child.getFieldName().toLowerCase();
                if (removes.contains(fieldName)) {
                    childs.remove(child);
                    continue;
                }
                this.removeChildHeaders(child, removes);
            }
        }
    }

    private StringBuffer getSortString(ArrayList list, String sortMode) {
        if (list == null) {
            return null;
        }
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap row = (HashMap)list.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodName,FTotalPeriodRow " + sortMode + ",");
                continue;
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumber,FTotalCostCenterRow " + sortMode + ",");
                continue;
            }
            if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjNumber,FTotalCostObjectRow " + sortMode + ",");
                continue;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumber,FTotalCostItemRow " + sortMode + ",");
                continue;
            }
            if ("FMatID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMatNumber,FTotalMaterialRow " + sortMode + ",");
                continue;
            }
            if ("FBatch".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMatLotOrder,FTotalMaterialLotRow " + sortMode + ",");
                continue;
            }
            if ("FOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FOrderNumber,FTotalOrderRow " + sortMode + ",");
                continue;
            }
            if ("FBatchID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProductLot,FTotalBatchRow " + sortMode + ",");
                continue;
            }
            if ("FProjectID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProjectNumber,FTotalProjectRow " + sortMode + ",");
                continue;
            }
            if ("FTrackID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FTrackNumber,FTotalTrackRow " + sortMode + ",");
                continue;
            }
            if (!"FProductID".equalsIgnoreCase(fieldID)) continue;
            orderBy.append("FProductNumber,FTotalProductRow " + sortMode + ",");
        }
        return orderBy;
    }
}

