/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OtherCostAllocDetailReport
extends ReportServerBase {
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        String tempTableName;
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.OtherCostAllocTotalReport");
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        if (filter == null) {
            return null;
        }
        this.dealFilter(filter, logger, ctx);
        if (filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName();
        String tableName = null;
        int periodNumberFrom = 0;
        int periodNumberTo = 0;
        if (filter.getString("yearFrom") != null && filter.getString("periodFrom") != null) {
            periodNumberFrom = Integer.parseInt(filter.getString("yearFrom") + (filter.getString("periodFrom").length() == 1 ? "0" + filter.getString("periodFrom") : filter.getString("periodFrom")));
        }
        if (filter.getString("yearTo") != null && filter.getString("periodTo") != null) {
            periodNumberTo = Integer.parseInt(filter.getString("yearTo") + (filter.getString("periodTo").length() == 1 ? "0" + filter.getString("periodTo") : filter.getString("periodTo")));
        }
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_OtherAllocResult", (int)periodNumberFrom, (int)periodNumberTo);
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append(" create table t2 ( ");
        createTable.append(" FCompanyName varchar(255) ");
        createTable.append(" , FPeriodId varchar(44) ");
        createTable.append(" , FPeriodNumber varchar(80) ");
        createTable.append(" , FSourceBillId varchar(44) ");
        createTable.append(" , FSourceBillNumber varchar(80) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber nvarchar(80) ");
        createTable.append(" , FExpenseName nvarchar(255) ");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostCenterNumber nvarchar(80) ");
        createTable.append(" , FCostCenterName nvarchar(255) ");
        createTable.append(" , FdepartmentID varchar(44) ");
        createTable.append(" , FdepartmentNumber nvarchar(80) ");
        createTable.append(" , FdepartmentName nvarchar(255) ");
        createTable.append(" , FSourceCostCenterID varchar(44) ");
        createTable.append(" , FSourceCostCenterNumber nvarchar(80) ");
        createTable.append(" , FSourceCostCenterName nvarchar(255) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber nvarchar(80) ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FOrderNumber nvarchar(80)");
        createTable.append(" , FBatchNumber nvarchar(80)");
        createTable.append(" , FProjectNumber nvarchar(80)");
        createTable.append(" , FTrackNumber nvarchar(80)");
        createTable.append(" , FMaterialNumber nvarchar(80)");
        createTable.append(" , FMaterialName nvarchar(255)");
        createTable.append(" , FProductModel nvarchar(255) ");
        createTable.append(" , FProductShortName nvarchar(255) ");
        createTable.append(" , FCostItemID nvarchar(80) ");
        createTable.append(" , FCostItemNumber nvarchar(80) ");
        createTable.append(" , FCostItemName nvarchar(255) ");
        createTable.append(" , FQty decimal(19,4) ");
        createTable.append(" , FQtyPrecision int default(0) ");
        createTable.append(" , FPrice decimal(19,4) ");
        createTable.append(" , FPricePrecision int default(2) ");
        createTable.append(" , FAmount decimal(19,4) ");
        createTable.append(" ,FAmountPrecision int default(2) ");
        createTable.append(" , FDescription varchar(255) ");
        createTable.append(" , FAllocStdType varchar(255) ");
        createTable.append(" , FAllocStdData decimal(19,4) ");
        createTable.append(" , FTotalRow decimal(28,16) not null default(0) ");
        createTable.append(" , FTotalRow2 decimal(28,16) not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalExpenseRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + " ( FCompanyName ,  FPeriodId , FPeriodNumber,  FSourceBillId , FSourceBillNumber, FDescription ,  FExpenseID, FExpenseNumber, FExpenseName,  FCostCenterID, FCostCenterNumber, FCostCenterName,  FdepartmentID, FdepartmentNumber, FdepartmentName,  FSourceCostCenterID, FSourceCostCenterNumber, FSourceCostCenterName,  FCostObjectID, FCostObjectNumber, FCostObjectName,  FProductModel, FProductShortName,  FCostItemID, FCostItemNumber, FCostItemName,  FQty , FPrice , FAmount,  FAllocStdType, FAllocStdData, FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName ) \n");
        sb.append(" SELECT '" + companyName + "' ,  t2.FID, to_char(t2.fperiodyear) ||'.'|| to_char(t2.fperiodnumber) ,  v.FID, v.FNumber, v.FDescription ,  w.FID, w.FNumber, w.FName_" + locale + ",  t3.FID, t3.FNumber, t3.FName_" + locale + ",  dp.FID, dp.Fnumber, dp.Fname_" + locale + ",  sourCC.FID, sourCC.Fnumber, sourCC.Fname_" + locale + ",  t4.FID, t4.FNumber, t4.FName_" + locale + ",  t8.fmodel, t8.FShortName,  t5.FID, t5.FNumber, t5.FName_" + locale + ",  t1.FQty, case when ( t1.FQty=0 or t1.FQty is null ) then 0.00 else to_number(t1.FAmount)/to_number(t1.FQty) end ,t1.FAmount ,  t6.FName_l2 ,  t1.FAllocStdData, t4.FOrderNumber,t4.FBatchNumber,po.FNumber,tr.FNumber,t8.FNumber,t8.FName_" + locale + " \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" left outer join T_NCM_AllocStd t6 on t1.FAllocStdID = t6.FID \n ");
        sb.append(" inner join t_NCM_OtherFeeBill v on t1.FSourceBillID = v.FID \n");
        sb.append(" inner join t_NCM_OtherFeeBillEntry ve on ve.FParentID = v.FID and ve.FID = t1.FSourceBillEntryID \n");
        sb.append(" inner join T_NCM_Expense w on ve.FExpenseID = w.FID \n");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" left outer join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" left join t_mm_project po on po.FID = t4.FProjectID \n");
        sb.append(" left join t_mm_trackNumber tr on tr.FID = t4.FTrackID \n");
        sb.append(" left outer join t_bd_material t8 on t4.FStdProductIDID = t8.FID  \n");
        sb.append(" left outer join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" left outer join T_ORG_BaseUnit dp on t1.FdepartmentID=dp.FID \n");
        sb.append(" left outer join T_ORG_CostCenter sourCC on sourCC.fid = t1.FSourceCostCenterID \n");
        sb.append(" where t1.FCompanyID = ? \n");
        this.buildFilter(filter, sb);
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer(200);
        sb.append(" update " + tempTableName + " set FQtyPrecision = ( select isnull(unit.FQtyPrecision,0)  from T_NCM_Expense exp left outer join T_BD_MeasureUnit unit on exp.funitid = unit.fid  where " + tempTableName + ".FExpenseID = exp.fid  ) ,  FPricePrecision = ( select isnull(exp.FPricePrecision,0) from T_NCM_Expense exp  where " + tempTableName + ".FExpenseID = exp.fid )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer(200);
        sb.append("UPDATE ").append(tempTableName).append(" SET (FAmountPrecision)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sb.append("\n\n;");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        Connection cn = null;
        Statement st = null;
        String[] fields = new String[]{" FExpenseNumber,FExpenseName ,FPeriodNumber ,FCostCenterNumber  ", "  FExpenseNumber,FExpenseName ,FPeriodNumber "};
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[0] + ", FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision, FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 103, " + fields[0] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision), 0 as FTotalExpenseRow,1 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[0]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[1] + ", FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision, FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 104, " + fields[1] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision), 1 as FTotalExpenseRow,0 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[1]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + " (FCostCenterName, FTotalRow2, FTotalRow, FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision) \n");
            sb.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',1,105, SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision) \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', FExpenseNumber = FExpenseNumber , ").append(" FCostCenterNumber = FCostCenterNumber,FExpenseName = FExpenseName\n").append(" where FTotalRow = 103 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FExpenseNumber = FExpenseNumber , FSourceBillNumber = '    ' , ").append(" FExpenseName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' ").append(" where FTotalRow = 104 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCompanyName = '" + companyName + "'");
            st.addBatch(sb.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return tempTableName;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + " Order by  FTotalRow2 , FExpenseNumber , FTotalExpenseRow, FCostCenterNumber,FTotalCostCenterRow , FTotalRow, FSourceBillNumber,FAllocStdData,FcostObjectID "), (int)start, (int)rows);
        return rs;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String tempTableName;
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.OtherCostAllocTotalReport");
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        if (filter == null) {
            return null;
        }
        this.dealFilter(filter, logger, ctx);
        if (filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName();
        String tableName = null;
        int periodNumberFrom = 0;
        int periodNumberTo = 0;
        if (filter.getString("yearFrom") != null && filter.getString("periodFrom") != null) {
            periodNumberFrom = Integer.parseInt(filter.getString("yearFrom") + (filter.getString("periodFrom").length() == 1 ? "0" + filter.getString("periodFrom") : filter.getString("periodFrom")));
        }
        if (filter.getString("yearTo") != null && filter.getString("periodTo") != null) {
            periodNumberTo = Integer.parseInt(filter.getString("yearTo") + (filter.getString("periodTo").length() == 1 ? "0" + filter.getString("periodTo") : filter.getString("periodTo")));
        }
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_OtherAllocResult", (int)periodNumberFrom, (int)periodNumberTo);
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append(" create table t2 ( ");
        createTable.append(" FCompanyName varchar(255) ");
        createTable.append(" , FPeriodId varchar(44) ");
        createTable.append(" , FPeriodNumber varchar(80) ");
        createTable.append(" , FSourceBillId varchar(44) ");
        createTable.append(" , FSourceBillNumber varchar(80) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber varchar(80) ");
        createTable.append(" , FExpenseName varchar(255) ");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostCenterNumber varchar(80) ");
        createTable.append(" , FCostCenterName varchar(255) ");
        createTable.append(" , FdepartmentID varchar(44) ");
        createTable.append(" , FdepartmentNumber varchar(80) ");
        createTable.append(" , FdepartmentName varchar(255) ");
        createTable.append(" , FSourceCostCenterID varchar(44) ");
        createTable.append(" , FSourceCostCenterNumber varchar(80) ");
        createTable.append(" , FSourceCostCenterName varchar(255) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber varchar(80) ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FOrderNumber varchar(80)");
        createTable.append(" , FBatchNumber nvarchar(80)");
        createTable.append(" , FProjectNumber varchar(80)");
        createTable.append(" , FTrackNumber varchar(80)");
        createTable.append(" , FMaterialNumber varchar(80)");
        createTable.append(" , FMaterialName varchar(255)");
        createTable.append(" , FProductModel nvarchar(255) ");
        createTable.append(" , FProductShortName nvarchar(255) ");
        createTable.append(" , FCostItemID varchar(80) ");
        createTable.append(" , FCostItemNumber varchar(80) ");
        createTable.append(" , FCostItemName varchar(255) ");
        createTable.append(" , FQty decimal(19,4) ");
        createTable.append(" , FQtyPrecision int default(0) ");
        createTable.append(" , FPrice decimal(19,4) ");
        createTable.append(" , FPricePrecision int default(2) ");
        createTable.append(" , FAmount decimal(19,4) ");
        createTable.append(" ,FAmountPrecision int default(2) ");
        createTable.append(" , FDescription varchar(255) ");
        createTable.append(" , FAllocStdType varchar(255) ");
        createTable.append(" , FAllocStdData decimal(19,4) ");
        createTable.append(" , FTotalRow decimal(28,16) not null default(0) ");
        createTable.append(" , FTotalRow2 decimal(28,16) not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalExpenseRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + " ( FCompanyName ,  FPeriodId , FPeriodNumber,  FSourceBillId , FSourceBillNumber, FDescription ,  FExpenseID, FExpenseNumber, FExpenseName,  FCostCenterID, FCostCenterNumber, FCostCenterName,  FdepartmentID, FdepartmentNumber, FdepartmentName,  FSourceCostCenterID, FSourceCostCenterNumber, FSourceCostCenterName,  FCostObjectID, FCostObjectNumber, FCostObjectName,  FProductModel, FProductShortName,  FCostItemID, FCostItemNumber, FCostItemName,  FQty , FPrice , FAmount,  FAllocStdType, FAllocStdData, FOrderNumber,FBatchNumber,FProjectNumber,FTrackNumber,FMaterialNumber,FMaterialName ) \n");
        sb.append(" SELECT '" + companyName + "' ,  t2.FID, to_char(t2.fperiodyear) ||'.'|| to_char(t2.fperiodnumber) ,  v.FID, v.FNumber, v.FDescription ,  w.FID, w.FNumber, w.FName_" + locale + ",  t3.FID, t3.FNumber, t3.FName_" + locale + ",  dp.FID, dp.Fnumber, dp.Fname_" + locale + ",  sourCC.FID, sourCC.Fnumber, sourCC.Fname_" + locale + ",  t4.FID, t4.FNumber, t4.FName_" + locale + ",  t8.fmodel, t8.FShortName,  t5.FID, t5.FNumber, t5.FName_" + locale + ",  t1.FQty, case when ( t1.FQty=0 or t1.FQty is null ) then 0.00 else to_number(t1.FAmount)/to_number(t1.FQty) end ,t1.FAmount ,  t6.FName_l2 ,  t1.FAllocStdData, t4.FOrderNumber,t4.FBatchNumber,po.FNumber,tr.FNumber,t8.FNumber,t8.FName_" + locale + " \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" left outer join T_NCM_AllocStd t6 on t1.FAllocStdID = t6.FID \n ");
        sb.append(" inner join t_NCM_OtherFeeBill v on t1.FSourceBillID = v.FID \n");
        sb.append(" inner join t_NCM_OtherFeeBillEntry ve on ve.FParentID = v.FID and ve.FID = t1.FSourceBillEntryID \n");
        sb.append(" inner join T_NCM_Expense w on ve.FExpenseID = w.FID \n");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" left outer join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" left join t_mm_project po on po.FID = t4.FProjectID \n");
        sb.append(" left join t_mm_trackNumber tr on tr.FID = t4.FTrackID \n");
        sb.append(" left outer join t_bd_material t8 on t4.FStdProductIDID = t8.FID  \n");
        sb.append(" left outer join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" left outer join T_ORG_BaseUnit dp on t1.FdepartmentID=dp.FID \n");
        sb.append(" left outer join T_ORG_CostCenter sourCC on sourCC.fid = t1.FSourceCostCenterID \n");
        sb.append(" where t1.FCompanyID = ? \n");
        this.buildFilter(filter, sb);
        this.buildSorter(sb);
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer(200);
        sb.append(" update " + tempTableName + " set FQtyPrecision = ( select isnull(unit.FQtyPrecision,0)  from T_NCM_Expense exp left outer join T_BD_MeasureUnit unit on exp.funitid = unit.fid  where " + tempTableName + ".FExpenseID = exp.fid  ) ,  FPricePrecision = ( select isnull(exp.FPricePrecision,0) from T_NCM_Expense exp  where " + tempTableName + ".FExpenseID = exp.fid )");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer(200);
        sb.append("UPDATE ").append(tempTableName).append(" SET (FAmountPrecision)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sb.append("\n\n;");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        Connection cn = null;
        Statement st = null;
        IRowSet rs = null;
        String[] fields = new String[]{" FExpenseNumber,FExpenseName ,FPeriodNumber ,FCostCenterNumber  ", "  FExpenseNumber,FExpenseName ,FPeriodNumber "};
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[0] + ", FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision, FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 103, " + fields[0] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision), 0 as FTotalExpenseRow,1 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[0]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + "(FTotalRow," + fields[1] + ", FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision, FTotalExpenseRow,FTotalCostCenterRow) \n");
            sb.append(" SELECT 104, " + fields[1] + " , SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision), 1 as FTotalExpenseRow,0 as FTotalCostCenterRow \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append(" group by " + fields[1]);
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" insert into " + tempTableName + " (FCostCenterName, FTotalRow2, FTotalRow, FQty, FPrice, FAmount,FQtyPrecision,FPricePrecision,FAmountPrecision) \n");
            sb.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',1,105, SUM(FQty) \n");
            sb.append(" , case when ( sum(FQty)=0 or sum(FQty) is null ) then 0.00 else to_number(sum(FAmount))/to_number(sum(FQty)) end ");
            sb.append(" , SUM(FAmount),max(FQtyPrecision),max(FPricePrecision),max(FAmountPrecision) \n");
            sb.append(" FROM " + tempTableName + "\n");
            sb.append(" where FTotalRow = 0 \n");
            sb.append("\n\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', FExpenseNumber = FExpenseNumber , ").append(" FCostCenterNumber = FCostCenterNumber,FExpenseName = FExpenseName\n").append(" where FTotalRow = 103 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FExpenseNumber = FExpenseNumber , FSourceBillNumber = '    ' , ").append(" FExpenseName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' ").append(" where FTotalRow = 104 ").append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " set FCompanyName = '" + companyName + "'");
            st.addBatch(sb.toString());
            st.executeBatch();
            rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT * FROM " + tempTableName + " Order by  FTotalRow2 , FExpenseNumber , FTotalExpenseRow, FCostCenterNumber,FTotalCostCenterRow , FTotalRow, FSourceBillNumber "));
            if (rs.size() == 1) {
                rs = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            SQLUtils.cleanup((Statement)st, (Connection)cn);
        }
        return rs;
    }

    private void dealFilter(RptParams filter, Logger logger, Context ctx) throws BOSException {
        if (filter.getString("prmtCompanyOrg") != null) {
            String comNumber = filter.getString("prmtCompanyOrg");
            CompanyOrgUnitInfo company = null;
            try {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(" select id,name,number where number = '" + comNumber + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            filter.setObject("companyorg", (Object)company);
            filter.remove("prmtCompanyOrg");
        }
        if (filter.getObject("spYearFrom") != null) {
            filter.setObject("yearFrom", filter.getObject("spYearFrom"));
            filter.remove("spYearFrom");
        }
        if (filter.getObject("spPeriodFrom") != null) {
            filter.setObject("periodFrom", filter.getObject("spPeriodFrom"));
            filter.remove("spPeriodFrom");
        }
        if (filter.getObject("spYearTo") != null) {
            filter.setObject("yearTo", filter.getObject("spYearTo"));
            filter.remove("spYearTo");
        }
        if (filter.getObject("spPeriodTo") != null) {
            filter.setObject("periodTo", filter.getObject("spPeriodTo"));
            filter.remove("spPeriodTo");
        }
        if (filter.getObject("prmtExpenseFrom") != null) {
            filter.setObject("expenseFrom", filter.getObject("prmtExpenseFrom"));
            filter.remove("prmtExpenseFrom");
        }
        if (filter.getObject("prmtExpenseTo") != null) {
            filter.setObject("expenseTo", filter.getObject("prmtExpenseTo"));
            filter.remove("prmtExpenseTo");
        }
        if (filter.getObject("prmtCostCenterFrom") != null) {
            filter.setObject("costcenterFrom", filter.getObject("prmtCostCenterFrom"));
            filter.remove("prmtCostCenterFrom");
        }
        if (filter.getObject("prmtCostCenterTo") != null) {
            filter.setObject("costcenterTo", filter.getObject("prmtCostCenterTo"));
            filter.remove("prmtCostCenterTo");
        }
        if (filter.getObject("prmtCostObjectFrom") != null) {
            filter.setObject("costobjectFrom", filter.getObject("prmtCostObjectFrom"));
            filter.remove("prmtCostObjectFrom");
        }
        if (filter.getObject("prmtCostObjectTo") != null) {
            filter.setObject("costobjectTo", filter.getObject("prmtCostObjectTo"));
            filter.remove("prmtCostObjectTo");
        }
        if (filter.getObject("prmtCostItemFrom") != null) {
            filter.setObject("costitemFrom", filter.getObject("prmtCostItemFrom"));
            filter.remove("prmtCostItemFrom");
        }
        if (filter.getObject("prmtCostItemTo") != null) {
            filter.setObject("costitemTo", filter.getObject("prmtCostItemTo"));
            filter.remove("prmtCostItemTo");
        }
        if (filter.getObject("prmtOrderNumberFrom") != null) {
            filter.setObject("orderNumberFrom", filter.getObject("prmtOrderNumberFrom"));
            filter.remove("prmtOrderNumberFrom");
        }
        if (filter.getObject("prmtOrderNumberTo") != null) {
            filter.setObject("orderNumberTo", filter.getObject("prmtOrderNumberTo"));
            filter.remove("prmtOrderNumberTo");
        }
        if (filter.getObject("txtBatchNumberFrom") != null) {
            filter.setObject("batchNumberFrom", filter.getObject("txtBatchNumberFrom"));
            filter.remove("txtBatchNumberFrom");
        }
        if (filter.getObject("txtBatchNumberTo") != null) {
            filter.setObject("batchNumberTo", filter.getObject("txtBatchNumberTo"));
            filter.remove("txtBatchNumberTo");
        }
        if (filter.getObject("prmtProjectNumberFrom") != null) {
            filter.setObject("projectNumberFrom", filter.getObject("prmtProjectNumberFrom"));
            filter.remove("prmtProjectNumberFrom");
        }
        if (filter.getObject("prmtProjectNumberTo") != null) {
            filter.setObject("projectNumberTo", filter.getObject("prmtProjectNumberTo"));
            filter.remove("prmtProjectNumberTo");
        }
        if (filter.getObject("prmtTrackNumberFrom") != null) {
            filter.setObject("trackNumberFrom", filter.getObject("prmtTrackNumberFrom"));
            filter.remove("prmtTrackNumberFrom");
        }
        if (filter.getObject("prmtTrackNumberTo") != null) {
            filter.setObject("trackNumberTo", filter.getObject("prmtTrackNumberTo"));
            filter.remove("prmtTrackNumberTo");
        }
        if (filter.getObject("prmtMaterialFrom") != null) {
            filter.setObject("materialFrom", filter.getObject("prmtMaterialFrom"));
            filter.remove("prmtMaterialFrom");
        }
        if (filter.getObject("prmtMaterialTo") != null) {
            filter.setObject("materialTo", filter.getObject("prmtMaterialTo"));
            filter.remove("prmtMaterialTo");
        }
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        BigDecimal ZERO = new BigDecimal(BigInteger.ZERO);
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(ZERO) == 0) {
            RptParams params = new RptParams();
            Object companyOrg = totalFilter.getObject("companyorg");
            if (companyOrg == null) {
                companyOrg = ContextUtil.getCurrentFIUnit((Context)this.getContext());
            }
            params.setObject("companyorg", companyOrg);
            String periodNumer = rowData.get("FPERIODNUMBER").toString();
            String year = "" + Integer.parseInt(periodNumer.substring(0, 4));
            String period = "" + Integer.parseInt(periodNumer.substring(4));
            params.setString("yearFrom", year);
            params.setString("yearTo", year);
            params.setString("periodFrom", period);
            params.setString("periodTo", period);
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("expenseFrom", (String)rowData.get("FExpenseNumber".toUpperCase()));
            params.setString("expenseTo", (String)rowData.get("FExpenseNumber".toUpperCase()));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("sourceCostCenterFrom", (String)rowData.get("FSOURCECOSTCENTERNUMBER"));
            params.setString("sourceCostCenterTo", (String)rowData.get("FSOURCECOSTCENTERNUMBER"));
            params.setString("departmentFrom", (String)rowData.get("FDEPARTMENTNUMBER"));
            params.setString("departmentTo", (String)rowData.get("FDEPARTMENTNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append(" and v.fbillStatus = 4");
        sb.append(" and t2.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        sb.append(" and t2.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("expenseFrom") != null && !"".equals(filter.getString("expenseFrom").trim())) {
            sb.append(" and w.FNumber >='").append(filter.getString("expenseFrom")).append("'");
        }
        if (filter.getString("expenseTo") != null && !"".equals(filter.getString("expenseTo"))) {
            sb.append(" and w.FNumber <='").append(filter.getString("expenseTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t5.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t5.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
        if (filter.getString("orderNumberFrom") != null && !"".equals(filter.getString("orderNumberFrom"))) {
            sb.append(" and t4.FOrderNumber >='").append(filter.getString("orderNumberFrom")).append("'");
        }
        if (filter.getString("orderNumberTo") != null && !"".equals(filter.getString("orderNumberTo"))) {
            sb.append(" and t4.FOrderNumber <='").append(filter.getString("orderNumberTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t4.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t4.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("materialFrom") != null && !"".equals(filter.getString("materialFrom"))) {
            sb.append(" and t8.FNumber >='").append(filter.getString("materialFrom")).append("'");
        }
        if (filter.getString("materialTo") != null && !"".equals(filter.getString("materialTo"))) {
            sb.append(" and t8.FNumber <='").append(filter.getString("materialTo")).append("'");
        }
        if (filter.getString("sourceCostCenterFrom") != null && !"".equals(filter.getString("sourceCostCenterFrom"))) {
            sb.append(" and sourCC.FNumber >='").append(filter.getString("sourceCostCenterFrom")).append("'");
        }
        if (filter.getString("sourceCostCenterTo") != null && !"".equals(filter.getString("sourceCostCenterTo"))) {
            sb.append(" and sourCC.FNumber <='").append(filter.getString("sourceCostCenterTo")).append("'");
        }
        if (filter.getString("departmentFrom") != null && !"".equals(filter.getString("departmentFrom"))) {
            sb.append(" and dp.FNumber >='").append(filter.getString("departmentFrom")).append("'");
        }
        if (filter.getString("departmentTo") != null && !"".equals(filter.getString("departmentTo"))) {
            sb.append(" and dp.FNumber <='").append(filter.getString("departmentFrom")).append("'");
        }
    }

    protected void buildSorter(StringBuffer sb) {
        sb.append(" order by t2.fnumber, w.fnumber, t3.fnumber, t4.fnumber, t5.fnumber ");
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"24_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"46_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("expenseFrom"), filter.getString("expenseTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"107_MAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costitemFrom"), filter.getString("costitemTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderNumberFrom"), filter.getString("orderNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("materialFrom"), filter.getString("materialTo")));
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 9);
        header.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), 10);
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 11);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 12);
        header.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()), 13);
        header.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()), 14);
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FExpenseNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FExpenseName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FSourceBillNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("Fdepartmentname")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"departmentname_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FDescription")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Remark", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Model", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCompanyName")) {
                header.getChilds().remove(childHeader);
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPrice")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAllocStdType")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdName", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FAllocStdData")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdData", (Locale)ctx.getLocale()));
            childHeader.setDecimal(8);
            childHeader.setAlign(3);
        }
        return header;
    }
}

