/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OtherFeeDetailReport
extends ReportServerBase {
    private static final Logger logger = Logger.getLogger(OtherFeeDetailReport.class);

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        RptParams params = new RptParams();
        String bissum = (String)rowData.get("FEXPENSEID");
        if (bissum.trim().length() > 0) {
            params.setObject("companyorg", totalFilter.getObject("companyorg"));
            String stemp = (String)rowData.get("FEXPENSENUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("expensefrom", stemp);
            params.setString("expenseto", stemp);
            stemp = (String)rowData.get("FCOSTCENTERNUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costcenterfrom", stemp);
            params.setString("costcenterto", stemp);
            stemp = (String)rowData.get("FCOSTOBJECTNUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costobjectfrom", stemp);
            params.setString("costobjectto", stemp);
            stemp = (String)rowData.get("FCOSTOBJECTSUITENUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costobjectgroupfrom", stemp);
            params.setString("costobjectgroupto", stemp);
            stemp = (String)rowData.get("FCOSTITEMNUMBER");
            if (stemp != null) {
                stemp = stemp.trim();
            }
            params.setString("costitemfrom", stemp);
            params.setString("costitemto", stemp);
            params.setString("yearfrom", totalFilter.getString("yearfrom"));
            params.setString("yearto", totalFilter.getString("yearto"));
            params.setString("periodfrom", totalFilter.getString("periodfrom"));
            params.setString("periodto", totalFilter.getString("periodto"));
            params.setBoolean("labor", totalFilter.getBoolean("labor"));
            params.setBoolean("consign", totalFilter.getBoolean("consign"));
            params.setBoolean("equipment", totalFilter.getBoolean("equipment"));
            params.setBoolean("manufacture", totalFilter.getBoolean("manufacture"));
            params.setBoolean("other", totalFilter.getBoolean("other"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private String buildFilters(RptParams filter) throws BOSException {
        boolean isOther;
        Object other;
        boolean isEquipment;
        Object equipment;
        boolean isConsign;
        Object consign;
        boolean isManufacture;
        Object manufacture;
        boolean isLabor;
        filter = this.setDefualtQuerySolution(filter);
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        String scompanyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        if (!scompanyID.equals("")) {
            sb.append("where T_NCM_OTHERFEEBILL.FCompanyOrg='" + scompanyID + "'");
            sb.append(" and T_NCM_OTHERFEEBILL.FBillStatus=4 ");
        }
        sb.append(" and T_BD_PERIOD.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearfrom"), filter.getString("periodfrom")));
        sb.append("");
        sb.append(" and T_BD_PERIOD.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearto"), filter.getString("periodto")));
        sb.append("");
        if (filter.getString("costcenterfrom") != null && !"".equals(filter.getString("costcenterfrom"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER >='").append(filter.getString("costcenterfrom")).append("'");
        }
        if (filter.getString("costcenterto") != null && !"".equals(filter.getString("costcenterto"))) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER <='").append(filter.getString("costcenterto")).append("'");
        }
        if (filter.getString("costobjectfrom") != null && !"".equals(filter.getString("costobjectfrom"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER >='").append(filter.getString("costobjectfrom")).append("'");
        }
        if (filter.getString("costobjectto") != null && !"".equals(filter.getString("costobjectto"))) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER <='").append(filter.getString("costobjectto")).append("'");
        }
        if (filter.getString("costobjectgroupfrom") != null && !"".equals(filter.getString("costobjectgroupfrom"))) {
            sb.append(" and T_NCM_COSTOBJECTSUITE.FNumber >='").append(filter.getString("costobjectgroupfrom")).append("'");
        }
        if (filter.getString("costobjectgroupto") != null && !"".equals(filter.getString("costobjectgroupto"))) {
            sb.append(" and T_NCM_COSTOBJECTSUITE.FNumber <='").append(filter.getString("costobjectgroupto")).append("'");
        }
        ArrayList<ExpenseTypeEnum> expenseType = new ArrayList<ExpenseTypeEnum>();
        Object labor = filter.getObject("labor");
        if (labor != null && labor instanceof Boolean && (isLabor = ((Boolean)labor).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.LABOR);
        }
        if ((manufacture = filter.getObject("manufacture")) != null && manufacture instanceof Boolean && (isManufacture = ((Boolean)manufacture).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.MANUFACTURE);
        }
        if ((consign = filter.getObject("consign")) != null && consign instanceof Boolean && (isConsign = ((Boolean)consign).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.CONSIGN);
        }
        if ((equipment = filter.getObject("equipment")) != null && equipment instanceof Boolean && (isEquipment = ((Boolean)equipment).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.EQUIPMENT);
        }
        if ((other = filter.getObject("other")) != null && other instanceof Boolean && (isOther = ((Boolean)other).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.OTHER);
        }
        if (expenseType.size() > 0) {
            sb.append(" and FExpenseType in (");
            for (int i = 0; i < expenseType.size(); ++i) {
                sb.append(((ExpenseTypeEnum)expenseType.get(i)).getValue()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        } else {
            sb.append(" and FExpenseType is null \n");
        }
        if (filter.getString("expensefrom") != null && !"".equals(filter.getString("expensefrom"))) {
            sb.append(" and T_NCM_EXPENSE.FNumber >='").append(filter.getString("expensefrom")).append("'");
        }
        if (filter.getString("expenseto") != null && !"".equals(filter.getString("expenseto"))) {
            sb.append(" and T_NCM_EXPENSE.FNumber <='").append(filter.getString("expenseto")).append("'");
        }
        if (filter.getString("costitemfrom") != null && !"".equals(filter.getString("costitemfrom"))) {
            sb.append(" and t_ncm_costitem.FNumber >='").append(filter.getString("costitemfrom")).append("'");
        }
        if (filter.getString("costitemto") != null && !"".equals(filter.getString("costitemto"))) {
            sb.append(" and t_ncm_costitem.FNumber <='").append(filter.getString("costitemto")).append("'");
        }
        if (filter.getString("orderFrom") != null && !"".equals(filter.getString("orderFrom"))) {
            sb.append(" and t_bd_costObject.FOrderNumber >='").append(filter.getString("orderFrom")).append("'");
        }
        if (filter.getString("orderTo") != null && !"".equals(filter.getString("orderTo"))) {
            sb.append(" and t_bd_costObject.FOrderNumber <='").append(filter.getString("orderTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t_bd_costObject.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t_bd_costObject.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and t_mm_project.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and t_mm_project.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and t_mm_trackNumber.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and t_mm_trackNumber.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("materialFrom") != null && !"".equals(filter.getString("materialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("materialFrom")).append("'");
        }
        if (filter.getString("materialTo") != null && !"".equals(filter.getString("materialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("materialTo")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getReportDataTableName(RptParams filter) throws BOSException {
        String string;
        String stempTableName;
        filter = this.setDefualtQuerySolution(filter);
        StringBuffer screateTable = new StringBuffer();
        screateTable.append("Create Table t1( ");
        screateTable.append("fexpenseid varchar(44),");
        screateTable.append("fcostcenterid varchar(44),");
        screateTable.append("fexpensenumber nvarchar(80),");
        screateTable.append("fexpensename nvarchar(255),");
        screateTable.append("fcostcenternumber nvarchar(80),");
        screateTable.append("fcostcentername nvarchar(255),");
        screateTable.append("fcostobjectnumber nvarchar(80),");
        screateTable.append("fcostobjectname nvarchar(255),");
        screateTable.append("fcostobjectsuitenumber nvarchar(80),");
        screateTable.append("fcostobjectsuitename nvarchar(255),");
        screateTable.append("fmodel nvarchar(255),");
        screateTable.append("fproductshortname nvarchar(80),");
        screateTable.append("fcompanynumber  nvarchar(80),");
        screateTable.append("fcompanyname  nvarchar(255),");
        screateTable.append("fdepartmentnumber  nvarchar(80),");
        screateTable.append("fdepartmentname  nvarchar(255),");
        screateTable.append("fdepartmentID  varchar(44),");
        screateTable.append("fSourceCostCenternumber  nvarchar(80),");
        screateTable.append("fSourceCostCentername  nvarchar(255),");
        screateTable.append("fSourceCostCenterID  varchar(44),");
        screateTable.append("FOrderNumber  nvarchar(80),");
        screateTable.append("FBatchNumber  nvarchar(80),");
        screateTable.append("FTrackNumber  nvarchar(80),");
        screateTable.append("FProjectNumber  nvarchar(80),");
        screateTable.append("FMaterialNumber  nvarchar(80),");
        screateTable.append("FMaterialName  nvarchar(255),");
        screateTable.append("fcostitemnumber  nvarchar(80),");
        screateTable.append("fcostitemname  nvarchar(255),");
        screateTable.append("fperiod  varchar(6),");
        screateTable.append("fremark  nvarchar(255),");
        screateTable.append("fbillno  nvarchar(255),");
        screateTable.append("fbilldate  varchar(10),");
        screateTable.append("fid  varchar(44),");
        screateTable.append("famount decimal(28,10),");
        screateTable.append("FAmountPrecision int not null default(2), ");
        screateTable.append("fqty decimal(28,10),");
        screateTable.append("fprice decimal(28,10),");
        screateTable.append("funit nvarchar(255),");
        screateTable.append("fqtyprecision decimal(28,10),");
        screateTable.append("fpriceprecision decimal(28,10)");
        screateTable.append(")");
        try {
            stempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(screateTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Locale locale = this.getContext().getLocale();
        Context ctx = this.getContext();
        Connection cn = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            String swhere = this.buildFilters(filter);
            StringBuffer sb = new StringBuffer();
            sb.append("fexpenseid,fcostcenterid,fexpensenumber,fexpensename,fcostcenternumber,fcostcentername,");
            sb.append("fcostobjectnumber,fcostobjectname,fcostobjectsuitenumber,fcostobjectsuitename,");
            sb.append("FOrderNumber,FBatchNumber,FTrackNumber,FProjectNumber,FMaterialNumber,FMaterialName,");
            sb.append("fmodel,fproductshortname,fcompanynumber,fcompanyname,fdepartmentID,fdepartmentnumber,fdepartmentname,");
            sb.append("FSourceCostCenterID,FSourceCostCenterNumber,FSourceCostCenterName,fcostitemnumber,fcostitemname,");
            sb.append("fperiod,fremark,fbillno,fbilldate,fid,famount,fqty");
            String sfields = sb.toString();
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append(sfields);
            sb.append(")\n");
            String sinsert = sb.toString();
            sb = new StringBuffer();
            sb.append("\n FROM T_NCM_OTHERFEEBILL JOIN T_NCM_OTHERFEEBILLENTRY ON \n");
            sb.append(" T_NCM_OTHERFEEBILLENTRY.FPARENTID=T_NCM_OTHERFEEBILL.FID \n");
            sb.append(" JOIN T_ORG_COMPANY ON T_ORG_COMPANY.FID=T_NCM_OTHERFEEBILL.FCOMPANYORG \n");
            sb.append(" JOIN T_ORG_CTRLUNIT ON T_NCM_OTHERFEEBILL.FCONTROLUNITID=T_ORG_CTRLUNIT.FID \n");
            sb.append(" JOIN T_NCM_EXPENSE ON T_NCM_EXPENSE.FID=T_NCM_OTHERFEEBILLENTRY.FEXPENSEID \n");
            sb.append(" JOIN T_ORG_COSTCENTER ON T_ORG_COSTCENTER.FID=T_NCM_OTHERFEEBILL.FCOSTCENTERID \n");
            sb.append(" JOIN T_BD_PERIOD ON  T_BD_PERIOD.FID=T_NCM_OtherFeeBill.FCalculatePeriod \n");
            sb.append(" LEFT JOIN T_ORG_BaseUnit on T_ORG_BaseUnit.FID=T_NCM_OtherFeeBill.FDepartmentID \n");
            sb.append(" LEFT JOIN T_NCM_COSTOBJECTSUITE ON T_NCM_COSTOBJECTSUITE.FID=T_NCM_OTHERFEEBILLENTRY.FCOSTOBJECTSUITEID \n");
            sb.append(" LEFT JOIN  T_BD_COSTOBJECT ON T_BD_COSTOBJECT.FID=T_NCM_OTHERFEEBILLENTRY.FCOSTOBJECTID and T_BD_COSTOBJECT.FCOMPANYID = T_NCM_OTHERFEEBILL.FCompanyOrg \n");
            sb.append(" LEFT JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=T_BD_COSTOBJECT.FStdProductIDID and T_BD_MaterialCompanyInfo.FCOMPANYID = T_NCM_OTHERFEEBILL.FCompanyOrg \n");
            sb.append(" LEFT JOIN T_BD_Material ON T_BD_Material.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
            sb.append(" LEFT JOIN t_ncm_costitem ON t_ncm_costitem.FID=T_NCM_OTHERFEEBILLENTRY.FCostItemID \n");
            sb.append(" left join t_mm_project on t_mm_project.FID = t_bd_costObject.FProjectID \n");
            sb.append(" left join t_mm_trackNumber on t_mm_trackNumber.FID = t_bd_costObject.FTrackID \n");
            sb.append(" left join t_bd_material mat on mat.FID = t_bd_costObject.FStdProductIDID \n");
            sb.append(" LEFT JOIN T_ORG_CostCenter sourCC on sourCC.Fid = T_NCM_OTHERFEEBILL.FSourceCostCenterID \n");
            sb.append(swhere + "\n");
            String sfrom = sb.toString();
            sb = new StringBuffer();
            sb.append(sinsert);
            sb.append("select " + sfields + " from \n");
            sb.append("(");
            sb.append("SELECT T_NCM_OTHERFEEBILLENTRY.FEXPENSEID as fexpenseid,T_NCM_OTHERFEEBILL.FCOSTCENTERID as fcostcenterid,");
            sb.append("T_NCM_EXPENSE.FNUMBER as fexpensenumber,T_NCM_EXPENSE.FName_" + locale + " as fexpensename,");
            sb.append("T_ORG_COSTCENTER.FNUMBER as fcostcenternumber,T_ORG_COSTCENTER.FName_" + locale + " as fcostcentername,");
            sb.append("isnull(T_BD_COSTOBJECT.FNUMBER,N' ') as fcostobjectnumber,T_BD_COSTOBJECT.FName_" + locale + " as fcostobjectname,");
            sb.append("T_NCM_COSTOBJECTSUITE.FNumber as fcostobjectsuitenumber,T_NCM_COSTOBJECTSUITE.FName_" + locale + " as fcostobjectsuitename,");
            sb.append("T_BD_CostObject.FOrderNumber as FOrderNumber, T_BD_CostObject.FBatchNumber as FBatchNumber, T_MM_TrackNumber.FNumber as FTrackNumber,");
            sb.append("T_MM_Project.FNumber as FProjectNumber, mat.FNumber as FMaterialNumber, mat.FName_" + locale + " as FMaterialName,");
            sb.append("T_BD_Material.FModel as fmodel,T_BD_Material.FShortname as fproductshortname,");
            sb.append("T_ORG_COMPANY.FNUMBER as fcompanynumber,");
            sb.append("T_ORG_COMPANY.FName_" + locale + " as fcompanyname,");
            sb.append("T_NCM_OTHERFEEBILL.FDepartmentID as FDepartmentID,T_ORG_BaseUnit.Fnumber as fdepartmentnumber,T_ORG_BaseUnit.Fname_" + locale + " as fdepartmentname,");
            sb.append("T_NCM_OTHERFEEBILL.FSourceCostCenterID as FSourceCostCenterID,sourCC.Fnumber as fSourceCostCenternumber,sourCC.Fname_" + locale + " as fSourceCostCentername,");
            sb.append("t_ncm_costitem.FNUMBER as fcostitemnumber,");
            sb.append("t_ncm_costitem.FName_" + locale + " as fcostitemname,");
            sb.append("to_char(T_BD_PERIOD.FNUMBER) as fperiod,");
            sb.append(" T_NCM_OTHERFEEBILLENTRY.FRemark_" + locale + " as fremark,");
            sb.append(" T_NCM_OTHERFEEBILL.FNumber as fbillno,");
            sb.append(" to_char(T_NCM_OTHERFEEBILL.FBizDate,'yyyy-mm-dd') as fbilldate,");
            sb.append(" T_NCM_OTHERFEEBILL.FID as fid,");
            sb.append("T_NCM_OTHERFEEBILLENTRY.FAMOUNT as famount,");
            sb.append("T_NCM_OTHERFEEBILLENTRY.FQty as fqty,");
            sb.append("1 as ftype ,");
            sb.append("0 as FCostCenterTotalRow,0 as FExpenseTotalRow \n");
            sb.append(sfrom);
            sb.append("union all \n");
            sb.append("SELECT ");
            sb.append("' ' as fexpenseid,'' as fcostcenterid,");
            sb.append("T_NCM_EXPENSE.FNUMBER as fexpensenumber,N'' as fexpensename,");
            sb.append("T_ORG_COSTCENTER.FNUMBER as fcostcenternumber,N'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' as fcostcentername,");
            sb.append("N'' as fcostobjectnumber,N'' as fcostobjectname,");
            sb.append("N'' as fcostobjectsuitenumber,N'' as fcostobjectsuitename,");
            sb.append("N'' as FOrderNumber, N'' as FBatchNumber, N'' as FTrackNumber, N'' as FProjectNumber, ");
            sb.append("N'' as FMaterialNumber, N'' as FMaterialName, ");
            sb.append("N'' as fmodel,N'' as fproductshortname,N'' as fcompanynumber,N'' as fcompanyname,");
            sb.append("'' as FDepartmentID, N'' as fdepartmentnumber, N'' as fdepartmentname,");
            sb.append("'' as FSourceCostCenterID, N'' as fSourceCostCenternumber, N'' as fSourceCostCentername,");
            sb.append("N'' as fcostitemnumber,N'' as fcostitemname,'z' as fperiod,N'' as fremark,");
            sb.append(" N'' as fbillno,");
            sb.append(" '' as fbilldate,");
            sb.append(" '' as fid,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FAMOUNT) as famount,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FQty) as fqty, ");
            sb.append("2 as ftype ,");
            sb.append("1 as FCostCenterTotalRow,0 as FExpenseTotalRow \n");
            sb.append(sfrom);
            sb.append(" group by T_NCM_EXPENSE.FNUMBER,T_ORG_COSTCENTER.FNUMBER \n");
            sb.append("union all \n");
            sb.append("SELECT ");
            sb.append("' ' as fexpenseid,'' as fcostcenterid,");
            sb.append("T_NCM_EXPENSE.FNUMBER as fexpensenumber,N'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' as fexpensename,");
            sb.append("N'' as fcostcenternumber,N'' as fcostcentername,");
            sb.append("N'' as fcostobjectnumber,N'' as fcostobjectname,");
            sb.append("N'' as fcostobjectsuitenumber,N'' as fcostobjectsuitename,");
            sb.append("N'' as FOrderNumber, N'' as FBatchNumber, N'' as FTrackNumber, N'' as FProjectNumber, ");
            sb.append("N'' as FMaterialNumber, N'' as FMaterialName, ");
            sb.append("N'' as fmodel,N'' as fproductshortname,N'' as fcompanynumber,N'' as fcompanyname,");
            sb.append("'' as FDepartmentID, N'' as fdepartmentnumber, N'' as fdepartmentname,");
            sb.append("'' as FSourceCostCenterID, N'' as fSourceCostCenternumber, N'' as fSourceCostCentername,");
            sb.append("N'' as fcostitemnumber,N'' as fcostitemname,'z' as fperiod,N'' as fremark,");
            sb.append(" N'' as fbillno,");
            sb.append(" '' as fbilldate,");
            sb.append(" '' as fid,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FAMOUNT) as famount ,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FQty) as fqty, ");
            sb.append("3 as ftype ,");
            sb.append("0 as FCostCenterTotalRow,1 as FExpenseTotalRow \n");
            sb.append(sfrom);
            sb.append("   group by T_NCM_EXPENSE.FNUMBER \n");
            sb.append(") as a ");
            sb.append("  order by  fexpensenumber asc,FExpenseTotalRow asc,fcostcenternumber asc,FCostCenterTotalRow asc,fcostobjectnumber");
            sb.append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(sinsert);
            sb.append("SELECT ");
            sb.append("' ' as fexpenseid,'' as fcostcenterid,");
            sb.append("N'' as fexpensenumber,N'' as fexpensename,");
            sb.append("N'' as fcostcenternumber,N'' as fcostcentername,");
            sb.append("N'' as fcostobjectnumber,N'' as fcostobjectname,");
            sb.append("N'' as fcostobjectsuitenumber,N'' as fcostobjectsuitename,");
            sb.append("N'' as FOrderNumber, N'' as FBatchNumber, N'' as FTrackNumber, N'' as FProjectNumber, ");
            sb.append("N'' as FMaterialNumber, N'' as FMaterialName, ");
            sb.append("N'' as fmodel,N'' as fproductshortname,N'' as fcompanynumber,N'' as fcompanyname,");
            sb.append("N'' as FDepartmentID, N'' as fdepartmentnumber, N'' as fdepartmentname,");
            sb.append("N'' as FSourceCostCenterID, N'' as fSourceCostCenternumber, N'' as fSourceCostCentername,");
            sb.append("N'' as fcostitemnumber,N'' as fcostitemname,'' as fperiod,N'' as fremark,");
            sb.append(" N'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' as fbillno,");
            sb.append(" '' as fbilldate,");
            sb.append(" '' as fid,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FAMOUNT) as famount ,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FQty) as fqty \n");
            sb.append(sfrom);
            sb.append("  and exists(select 1 from " + stempTableName + ")");
            sb.append("\n");
            st.addBatch(sb.toString());
            st.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, stempTableName);
            st.clearBatch();
            CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String CUid = DefaultCU.getId().toString();
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1 \n");
            sb.append(" set (FqtyPrecision,FPricePrecision,funit)=\n");
            sb.append("(select t_bd_MeasureUnit.FqtyPrecision,T_NCM_EXPENSE.FPricePrecision,t_bd_MeasureUnit.Fname_" + locale + " as funit  \n");
            sb.append("\n FROM T_NCM_EXPENSE \n");
            sb.append(" LEFT JOIN t_bd_MeasureUnit on T_NCM_EXPENSE.FUnitID = t_bd_MeasureUnit.FID \n");
            sb.append("where T_NCM_EXPENSE.FNUMBER=t1.fexpensenumber and t1.fexpenseid!=' ' ");
            sb.append(" AND T_NCM_EXPENSE.FControlUnitID = '" + CUid + "' )");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1 \n");
            sb.append(" set (FqtyPrecision,FPricePrecision)=\n");
            sb.append("(select top 1 t2.FqtyPrecision,t2.FPricePrecision from " + stempTableName + " AS T2 \n");
            sb.append("where T2.fexpensenumber=t1.fexpensenumber) where t1.fexpenseid=' '");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set FqtyPrecision=select max(FqtyPrecision) as FqtyPrecision from " + stempTableName + " where fexpenseid=' ' \n");
            sb.append(" ,FPricePrecision=select max(FPricePrecision) as FqtyPrecision from " + stempTableName + " where fexpenseid=' ' \n");
            sb.append(" where fexpensenumber=' '");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set fprice=round(famount/fqty,FPricePrecision) \n");
            sb.append(" where fexpenseid!=' ' and fqty<>0");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set fprice=0 \n");
            sb.append(" where fexpenseid!=' ' and fqty=0");
            st.addBatch(sb.toString());
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyorg");
            String companyID = companyInfo.getId().toString();
            sb = new StringBuffer();
            sb.append("UPDATE ").append(stempTableName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName);
            sb.append(" set fexpensenumber=N'' ,fcostcenternumber=N'',fcostitemnumber=N'',fperiod='',fcostobjectnumber=N''");
            sb.append(" where fexpenseid=' '");
            st.addBatch(sb.toString());
            st.executeBatch();
            string = stempTableName;
        }
        catch (SQLException e1) {
            try {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(stempTableName);
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return string;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        try {
            String sTableName = this.getReportDataTableName(filter);
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName));
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTableName);
            return rs;
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        try {
            String sTableName = this.getReportDataTableName(filter);
            return sTableName;
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName), (int)start, (int)rows);
        return rs;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        filter = this.setDefualtQuerySolution(filter);
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"102_MAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearto") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodto") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterfrom"), filter.getString("costcenterto")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectfrom"), filter.getString("costobjectto")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"136_OtherFeeDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectgroupfrom"), filter.getString("costobjectgroupto")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"46_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("expensefrom"), filter.getString("expenseto")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"107_MAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costitemfrom"), filter.getString("costitemto")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        titles.AddTitle(12, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("materialFrom"), filter.getString("materialTo")));
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ExpenseType", (Locale)ctx.getLocale()) + "\uff1a" + this.titleForExpenseTypes(filter));
        return titles;
    }

    protected String titleForExpenseTypes(RptParams filter) {
        boolean isOther;
        boolean isConsign;
        boolean isManufacture;
        boolean isLabor;
        boolean isEquipment;
        String title = "";
        Object equipmentTemp = filter.getObject("equipment");
        String equipment = "";
        if (equipmentTemp != null && equipmentTemp instanceof Boolean && (isEquipment = ((Boolean)equipmentTemp).booleanValue())) {
            equipment = " " + ExpenseTypeEnum.EQUIPMENT.toString();
        }
        Object laborTemp = filter.getObject("labor");
        String labor = "";
        if (laborTemp != null && laborTemp instanceof Boolean && (isLabor = ((Boolean)laborTemp).booleanValue())) {
            labor = " " + ExpenseTypeEnum.LABOR.toString();
        }
        Object manufactureTemp = filter.getObject("manufacture");
        String manufacture = "";
        if (manufactureTemp != null && manufactureTemp instanceof Boolean && (isManufacture = ((Boolean)manufactureTemp).booleanValue())) {
            manufacture = " " + ExpenseTypeEnum.MANUFACTURE.toString();
        }
        Object consignTemp = filter.getObject("consign");
        String consign = "";
        if (consignTemp != null && consignTemp instanceof Boolean && (isConsign = ((Boolean)consignTemp).booleanValue())) {
            consign = " " + ExpenseTypeEnum.CONSIGN.toString();
        }
        Object otherTemp = filter.getObject("other");
        String other = "";
        if (otherTemp != null && otherTemp instanceof Boolean && (isOther = ((Boolean)otherTemp).booleanValue())) {
            other = " " + ExpenseTypeEnum.OTHER.toString();
        }
        if ((title = labor + manufacture + consign + equipment + other).equals("")) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Null", (Locale)this.getContext().getLocale());
        }
        return title;
    }

    private RptParams setDefualtQuerySolution(RptParams filter) throws BOSException {
        HashMap<String, Object> map;
        PeriodInfo period;
        if (filter.size() != 0) {
            return filter;
        }
        RptParams defualtFilter = new RptParams();
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        try {
            period = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyInfo.getId().toString());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (filter.getObject("companyorg") == null) {
            map = new HashMap<String, Object>();
            map.put("companyorg", companyInfo);
            defualtFilter.putAll(map);
        }
        if (filter.getObject("yearfrom") == null) {
            map = new HashMap();
            map.put("yearfrom", String.valueOf(period.getPeriodYear()));
            defualtFilter.putAll(map);
        }
        if (filter.getObject("yearfrom") == null) {
            HashMap<String, String> yearfrom = new HashMap<String, String>();
            HashMap<String, String> yearto = new HashMap<String, String>();
            yearfrom.put("yearfrom", String.valueOf(period.getPeriodYear()));
            yearto.put("yearto", String.valueOf(period.getPeriodYear()));
            defualtFilter.putAll(yearfrom);
            defualtFilter.putAll(yearto);
        }
        if (filter.getObject("periodfrom") == null) {
            HashMap<String, String> periodfrom = new HashMap<String, String>();
            HashMap<String, String> periodto = new HashMap<String, String>();
            periodfrom.put("periodfrom", String.valueOf(period.getNumber() % 100));
            periodto.put("periodto", String.valueOf(period.getNumber() % 100));
            defualtFilter.putAll(periodfrom);
            defualtFilter.putAll(periodto);
        }
        return defualtFilter;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        reportHeader.addChild("FPeriod", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FBilldate", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BizDate", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("fbillno", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BillNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FExpensenumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FExpensename", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostcenternumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostcentername", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostitemnumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostitemname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FDepartmentname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"departmentname_2", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FSourceCostCentername", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_SourceCostCenterName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostobjectnumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostobjectname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Model", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FProductshortname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostobjectsuitenumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CostObjectSuiteNumber", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FCostobjectsuitename", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CostObjectSuiteName", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FUnit", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Unit", (Locale)ctx.getLocale()), index++);
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("fqtyprecision");
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2);
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("fpriceprecision");
        reportHeader.addChild("FRemark", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Remark", (Locale)ctx.getLocale()), index++);
        if (reportHeader != null && reportHeader.getChilds() != null) {
            int amtPrecision = 2;
            try {
                String currencyId = ContextUtil.getCurrentFIUnit((Context)this.getContext()).getBaseCurrency().getId().toString();
                amtPrecision = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)).getPrecision();
            }
            catch (Exception exc) {
                logger.error((Object)"", (Throwable)exc);
            }
            ArrayList headers = reportHeader.getChilds();
            for (int i = 0; i < headers.size(); ++i) {
                ReportHeader rh;
                Object header = headers.get(i);
                if (!(header instanceof ReportHeader) || !(rh = (ReportHeader)header).getFieldName().equalsIgnoreCase("famount")) continue;
                rh.setDecimal(amtPrecision);
            }
        }
        return reportHeader;
    }
}

