/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OtherFeeTotalReport
extends ReportServerBase {
    private static final Logger logger = Logger.getLogger(OtherFeeTotalReport.class);

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private String buildFilters(RptParams filter) throws BOSException {
        boolean isOther;
        Object other;
        boolean isEquipment;
        Object equipment;
        boolean isConsign;
        Object consign;
        boolean isManufacture;
        Object manufacture;
        boolean isLabor;
        filter = this.setDefualtQuerySolution(filter);
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        String scompanyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        if (!scompanyID.equals("")) {
            sb.append("where T_NCM_OTHERFEEBILL.FCompanyOrg='" + scompanyID + "'");
            sb.append(" and T_NCM_OTHERFEEBILL.FBillStatus=4 ");
        }
        sb.append(" and T_BD_PERIOD.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearfrom"), filter.getString("periodfrom")));
        sb.append("");
        sb.append(" and T_BD_PERIOD.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearto"), filter.getString("periodto")));
        sb.append("");
        if (filter.getString("costcenterfrom") != null && !"".equals(filter.getString("costcenterfrom").trim())) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER >='").append(filter.getString("costcenterfrom")).append("'");
        }
        if (filter.getString("costcenterto") != null && !"".equals(filter.getString("costcenterto").trim())) {
            sb.append(" and T_ORG_COSTCENTER.FNUMBER <='").append(filter.getString("costcenterto")).append("'");
        }
        if (filter.getString("costobjectfrom") != null && !"".equals(filter.getString("costobjectfrom").trim())) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER >='").append(filter.getString("costobjectfrom")).append("'");
        }
        if (filter.getString("costobjectto") != null && !"".equals(filter.getString("costobjectto").trim())) {
            sb.append(" and T_BD_COSTOBJECT.FNUMBER <='").append(filter.getString("costobjectto")).append("'");
        }
        if (filter.getString("costobjectgroupfrom") != null && !"".equals(filter.getString("costobjectgroupfrom").trim())) {
            sb.append(" and T_NCM_COSTOBJECTSUITE.FNumber >='").append(filter.getString("costobjectgroupfrom")).append("'");
        }
        if (filter.getString("costobjectgroupto") != null && !"".equals(filter.getString("costobjectgroupto").trim())) {
            sb.append(" and T_NCM_COSTOBJECTSUITE.FNumber <='").append(filter.getString("costobjectgroupto")).append("'");
        }
        ArrayList<ExpenseTypeEnum> expenseType = new ArrayList<ExpenseTypeEnum>();
        Object labor = filter.getObject("labor");
        if (labor != null && labor instanceof Boolean && (isLabor = ((Boolean)labor).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.LABOR);
        }
        if ((manufacture = filter.getObject("manufacture")) != null && manufacture instanceof Boolean && (isManufacture = ((Boolean)manufacture).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.MANUFACTURE);
        }
        if ((consign = filter.getObject("consign")) != null && consign instanceof Boolean && (isConsign = ((Boolean)consign).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.CONSIGN);
        }
        if ((equipment = filter.getObject("equipment")) != null && equipment instanceof Boolean && (isEquipment = ((Boolean)equipment).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.EQUIPMENT);
        }
        if ((other = filter.getObject("other")) != null && other instanceof Boolean && (isOther = ((Boolean)other).booleanValue())) {
            expenseType.add(ExpenseTypeEnum.OTHER);
        }
        if (expenseType.size() > 0) {
            sb.append(" and FExpenseType in (");
            for (int i = 0; i < expenseType.size(); ++i) {
                sb.append(((ExpenseTypeEnum)expenseType.get(i)).getValue()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        } else {
            sb.append(" and FExpenseType is null \n");
        }
        if (filter.getString("expensefrom") != null && !"".equals(filter.getString("expensefrom"))) {
            sb.append(" and T_NCM_Expense.FNumber >='").append(filter.getString("expensefrom")).append("'");
        }
        if (filter.getString("expenseto") != null && !"".equals(filter.getString("expenseto"))) {
            sb.append(" and T_NCM_Expense.FNumber <='").append(filter.getString("expenseto")).append("'");
        }
        if (filter.getString("orderFrom") != null && !"".equals(filter.getString("orderFrom"))) {
            sb.append(" and t_bd_costObject.FOrderNumber >='").append(filter.getString("orderFrom")).append("'");
        }
        if (filter.getString("orderTo") != null && !"".equals(filter.getString("orderTo"))) {
            sb.append(" and t_bd_costObject.FOrderNumber <='").append(filter.getString("orderTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t_bd_costObject.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t_bd_costObject.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and t_mm_project.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and t_mm_project.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and t_mm_trackNumber.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and t_mm_trackNumber.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("materialFrom") != null && !"".equals(filter.getString("materialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("materialFrom")).append("'");
        }
        if (filter.getString("materialTo") != null && !"".equals(filter.getString("materialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("materialTo")).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getReportDataTableName(RptParams filter) throws BOSException {
        String string;
        String stempTableName;
        filter = this.setDefualtQuerySolution(filter);
        StringBuffer screateTable = new StringBuffer();
        screateTable.append("Create Table t1( ");
        screateTable.append("fexpenseid varchar(44),");
        screateTable.append("fcostcenterid varchar(44),");
        screateTable.append("fexpensenumber nvarchar(80),");
        screateTable.append("fexpensename nvarchar(255),");
        screateTable.append("fcostcenternumber nvarchar(80),");
        screateTable.append("fcostcentername nvarchar(255),");
        screateTable.append("fcostobjectnumber nvarchar(80),");
        screateTable.append("fcostobjectname nvarchar(255),");
        screateTable.append("fcostobjectID varchar(44),");
        screateTable.append("fcostobjectsuitenumber nvarchar(80),");
        screateTable.append("fcostobjectsuitename nvarchar(255),");
        screateTable.append("fcostobjectsuiteID varchar(44),");
        screateTable.append("fmodel nvarchar(255),");
        screateTable.append("fproductshortname nvarchar(80),");
        screateTable.append("fcompanynumber  nvarchar(80),");
        screateTable.append("fcompanyname  nvarchar(255),");
        screateTable.append("fdepartmentnumber  nvarchar(80),");
        screateTable.append("fdepartmentname  nvarchar(255),");
        screateTable.append("fdepartmentID  varchar(44),");
        screateTable.append("fsourceCostCenterNumber  nvarchar(80),");
        screateTable.append("fsourceCostCenterName  nvarchar(255),");
        screateTable.append("fsourceCostCenterID  varchar(44),");
        screateTable.append("FOrderNumber  nvarchar(80),");
        screateTable.append("FBatchNumber  nvarchar(80),");
        screateTable.append("FLot  nvarchar(80),");
        screateTable.append("FTrackNumber  nvarchar(80),");
        screateTable.append("FProjectNumber  nvarchar(80),");
        screateTable.append("FMaterialNumber  nvarchar(80),");
        screateTable.append("FMaterialName  nvarchar(255),");
        screateTable.append("FOrderID  varchar(44),");
        screateTable.append("FProjectID  varchar(44),");
        screateTable.append("FTrackID  varchar(44),");
        screateTable.append("FMaterialID  varchar(44),");
        screateTable.append("fcostitemnumber  nvarchar(80),");
        screateTable.append("fcostitemname  nvarchar(255),");
        screateTable.append("fcostitemID  varchar(44),");
        screateTable.append("famount decimal(28,10),");
        screateTable.append("fqty decimal(28,10),");
        screateTable.append("fprice decimal(28,10),");
        screateTable.append("funit nvarchar(255),");
        screateTable.append("fqtyprecision decimal(28,10),");
        screateTable.append("fpriceprecision decimal(28,10),");
        screateTable.append("FTotalRow decimal(21,8) not null default(0), ");
        screateTable.append("FTotalRow2 decimal(21,8) not null default(0) ");
        screateTable.append(" ,FIsTotalRow int not null default(1) ");
        screateTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        screateTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        screateTable.append(" ,FTotalExpenseRow int not null default(0) ");
        screateTable.append(" ,FTotalCostItemRow int not null default(0) ");
        screateTable.append(" ,FTotalCostObjectSuiteRow int not null default(0) ");
        screateTable.append(" ,FTotalOrderRow int not null default(0) ");
        screateTable.append(" ,FTotalTrackRow int not null default(0) ");
        screateTable.append(" ,FTotalProjectRow int not null default(0) ");
        screateTable.append(" ,FTotalMaterialRow int not null default(0) ");
        screateTable.append(" ,FTotalBatchRow int not null default(0) ");
        screateTable.append(")");
        try {
            stempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(screateTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Locale locale = this.getContext().getLocale();
        Context ctx = this.getContext();
        Connection cn = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            String swhere = this.buildFilters(filter);
            StringBuffer sb = new StringBuffer();
            sb.append("fexpenseid,fcostcenterid,fcostItemid,fexpensenumber,fexpensename,fcostcenternumber,fcostcentername,");
            sb.append("fcostobjectid,fcostobjectnumber,fcostobjectname,fcostobjectsuiteID,fcostobjectsuitenumber,fcostobjectsuitename,");
            sb.append("FOrderNumber,FBatchNumber,FLot,FTrackNumber,FProjectNumber,FMaterialNumber,FMaterialName,");
            sb.append("FOrderID,FTrackID,FProjectID,FMaterialID,");
            sb.append("fmodel,fproductshortname,fcompanynumber,fcompanyname,fdepartmentID,fdepartmentnumber,fdepartmentname,FsourceCostCenterNumber,FsourceCostCenterName,FsourceCostCenterID,fcostitemnumber,fcostitemname,");
            sb.append("famount,fqty,fistotalrow");
            String sfields = sb.toString();
            sb = new StringBuffer();
            sb.append("insert into " + stempTableName + "(\n");
            sb.append(sfields);
            sb.append(")\n");
            String sinsert = sb.toString();
            sb = new StringBuffer();
            sb.append("\n FROM T_NCM_OTHERFEEBILL JOIN T_NCM_OTHERFEEBILLENTRY ON \n");
            sb.append(" T_NCM_OTHERFEEBILLENTRY.FPARENTID=T_NCM_OTHERFEEBILL.FID \n");
            sb.append(" JOIN T_ORG_COMPANY ON T_ORG_COMPANY.FID=T_NCM_OTHERFEEBILL.FCOMPANYORG \n");
            sb.append(" JOIN T_ORG_CTRLUNIT ON T_NCM_OTHERFEEBILL.FCONTROLUNITID=T_ORG_CTRLUNIT.FID \n");
            sb.append(" JOIN T_NCM_EXPENSE ON T_NCM_EXPENSE.FID=T_NCM_OTHERFEEBILLENTRY.FEXPENSEID \n");
            sb.append(" JOIN T_ORG_COSTCENTER ON T_ORG_COSTCENTER.FID=T_NCM_OTHERFEEBILL.FCOSTCENTERID \n");
            sb.append(" JOIN T_BD_PERIOD ON  T_BD_PERIOD.FID=T_NCM_OtherFeeBill.FCalculatePeriod \n");
            sb.append(" LEFT JOIN T_ORG_BaseUnit on T_ORG_BaseUnit.FID=T_NCM_OtherFeeBill.FDepartmentID \n");
            sb.append(" LEFT JOIN T_NCM_COSTOBJECTSUITE ON T_NCM_COSTOBJECTSUITE.FID=T_NCM_OTHERFEEBILLENTRY.FCOSTOBJECTSUITEID \n");
            sb.append(" LEFT JOIN  T_BD_COSTOBJECT ON T_BD_COSTOBJECT.FID=T_NCM_OTHERFEEBILLENTRY.FCOSTOBJECTID and T_BD_COSTOBJECT.FCOMPANYID = T_NCM_OTHERFEEBILL.FCompanyOrg \n");
            sb.append(" LEFT JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=T_BD_COSTOBJECT.FStdProductIDID and T_BD_MaterialCompanyInfo.FCOMPANYID = T_NCM_OTHERFEEBILL.FCompanyOrg \n");
            sb.append(" LEFT JOIN T_BD_Material ON T_BD_Material.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
            sb.append(" LEFT JOIN t_ncm_costitem ON t_ncm_costitem.FID=T_NCM_OTHERFEEBILLENTRY.FCostItemID \n");
            sb.append(" left join t_mm_project on t_mm_project.FID = t_bd_costObject.FProjectID \n");
            sb.append(" left join t_mm_trackNumber on t_mm_trackNumber.FID = t_bd_costObject.FTrackID \n");
            sb.append(" left join t_bd_material mat on mat.FID = t_bd_costObject.FStdProductIDID \n");
            sb.append(" LEFT JOIN T_ORG_COSTCENTER sourCC on sourCC.Fid = T_NCM_OtherFeeBill.FSourceCostCenterID \n");
            sb.append(swhere + "\n");
            String sfrom = sb.toString();
            sb = new StringBuffer();
            sb.append(sinsert);
            sb.append("select " + sfields + " from \n");
            sb.append("(");
            sb.append("SELECT ");
            sb.append("T_NCM_OTHERFEEBILLENTRY.fexpenseid as fexpenseid,T_NCM_OTHERFEEBILL.FCOSTCENTERID as fcostcenterid,t_ncm_costitem.fid as fcostItemID,");
            sb.append("T_NCM_EXPENSE.FNUMBER as fexpensenumber,T_NCM_EXPENSE.FName_" + locale + " as fexpensename,");
            sb.append("T_ORG_COSTCENTER.FNUMBER as fcostcenternumber,T_ORG_COSTCENTER.FName_" + locale + "  as fcostcentername,");
            sb.append("T_BD_COSTOBJECT.FID as fcostobjectid,isnull(T_BD_COSTOBJECT.FNUMBER,N' ') as fcostobjectnumber,T_BD_COSTOBJECT.FName_" + locale + " as fcostobjectname,");
            sb.append("T_NCM_COSTOBJECTSUITE.FID as fcostobjectsuiteID,T_NCM_COSTOBJECTSUITE.FNumber as fcostobjectsuitenumber,T_NCM_COSTOBJECTSUITE.FName_" + locale + " as fcostobjectsuitename,");
            sb.append("T_BD_CostObject.FOrderNumber as FOrderNumber, T_BD_CostObject.FBatchNumber as FBatchNumber, T_BD_CostObject.FBatchNumber as FLot, T_MM_TrackNumber.FNumber as FTrackNumber,");
            sb.append("T_MM_Project.FNumber as FProjectNumber, mat.FNumber as FMaterialNumber, mat.FName_" + locale + " as FMaterialName,");
            sb.append("T_BD_CostObject.FOrderID as FOrderID, T_BD_CostObject.FTrackID as FTrackID, T_BD_CostObject.FProjectID as FProjectID,");
            sb.append("T_BD_CostObject.FStdProductIDID as FMaterialID,");
            sb.append("T_BD_Material.FModel as fmodel,T_BD_Material.FShortName as fproductshortname,N'' as fcompanynumber,N'' as fcompanyname,");
            sb.append("T_NCM_OTHERFEEBILL.FDepartmentID as FDepartmentID,T_ORG_BaseUnit.Fnumber as fdepartmentnumber,T_ORG_BaseUnit.Fname_" + locale + " as fdepartmentname,");
            sb.append("T_NCM_OTHERFEEBILL.FSourceCostCenterID as FSourceCostCenterID,sourCC.Fnumber as fSourceCostCenterNumber,sourCC.Fname_" + locale + " as fSourceCostCenterName,");
            sb.append("t_ncm_costitem.FNUMBER as fcostitemnumber,t_ncm_costitem.FName_" + locale + " as fcostitemname,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FAMOUNT) as famount,");
            sb.append("sum(T_NCM_OTHERFEEBILLENTRY.FQty) as fqty,");
            sb.append("0 as fistotalrow \n");
            sb.append(sfrom);
            sb.append(" group by T_NCM_EXPENSE.FNUMBER,T_NCM_EXPENSE.FName_" + locale + ",T_NCM_OTHERFEEBILLENTRY.fexpenseid,");
            sb.append(" T_ORG_COSTCENTER.FNUMBER,T_ORG_COSTCENTER.FName_" + locale + ",T_NCM_OTHERFEEBILL.FCOSTCENTERID,");
            sb.append(" T_ORG_BaseUnit.Fnumber,T_ORG_BaseUnit.Fname_" + locale + ",T_NCM_OTHERFEEBILL.FDepartmentID,");
            sb.append(" T_NCM_OTHERFEEBILL.FSourceCostCenterID ,sourCC.Fnumber ,sourCC.Fname_" + locale + ",");
            sb.append(" T_BD_COSTOBJECT.FNUMBER,T_BD_COSTOBJECT.FName_" + locale + ",T_BD_COSTOBJECT.FID,");
            sb.append(" T_NCM_COSTOBJECTSUITE.FNumber,T_NCM_COSTOBJECTSUITE.FName_" + locale + ",T_NCM_COSTOBJECTSUITE.FID,");
            sb.append("T_BD_CostObject.FOrderNumber , T_BD_CostObject.FBatchNumber , T_MM_TrackNumber.FNumber ,");
            sb.append("T_MM_Project.FNumber , mat.FNumber , mat.FName_" + locale + " ,");
            sb.append("T_BD_CostObject.FOrderID, T_BD_CostObject.FTrackID, T_BD_CostObject.FProjectID, T_BD_CostObject.FStdProductIDID, ");
            sb.append(" T_BD_Material.FModel,T_BD_Material.FShortName,");
            sb.append(" t_ncm_costitem.FNUMBER,t_ncm_costitem.FName_" + locale + ",t_ncm_costitem.fid \n");
            sb.append(") as a ");
            sb.append("\n");
            st.addBatch(sb.toString());
            CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String CUid = DefaultCU.getId().toString();
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1 \n");
            sb.append(" set (FqtyPrecision,FPricePrecision,funit)=\n");
            sb.append("(select t_bd_MeasureUnit.FqtyPrecision,T_NCM_EXPENSE.FPricePrecision,t_bd_MeasureUnit.Fname_" + locale + " as funit  \n");
            sb.append("\n FROM T_NCM_EXPENSE \n");
            sb.append(" LEFT JOIN t_bd_MeasureUnit on T_NCM_EXPENSE.FUnitID = t_bd_MeasureUnit.FID \n");
            sb.append("where T_NCM_EXPENSE.FNUMBER=t1.fexpensenumber and t1.fexpenseid!=' ' ");
            sb.append(" AND T_NCM_EXPENSE.FControlUnitID = '" + CUid + "' )");
            st.addBatch(sb.toString());
            st.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, stempTableName);
            st.clearBatch();
            StringBuffer sbUpdate = new StringBuffer();
            ArrayList list = this.getGroupByList(this.doPerQuerySolution(filter));
            String groupInsertStr = "";
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(list.size() - i - 1);
                String fields = (String)map.get("groupby");
                groupInsertStr = " insert into " + stempTableName + "(FqtyPrecision,FPricePrecision,FTotalRow,FTotalRow2," + fields + ",Famount,Fqty) \n SELECT max(FqtyPrecision),max(FPricePrecision), " + map.get("totalrow").toString() + ",0," + fields + " ,sum(famount),SUM(fqty)\n FROM " + stempTableName + "\n where FTotalRow = 0 \n";
                sbUpdate.append(groupInsertStr);
                sbUpdate.append(" group by " + fields);
                sbUpdate.append("\n\n");
                sbUpdate.append(";");
            }
            String strSum1 = sbUpdate.toString();
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)strSum1);
            sb = new StringBuffer();
            sb.append(sinsert.replaceAll("fistotalrow", "fistotalrow,FTotalRow2,FTotalRow,FqtyPrecision,FPricePrecision "));
            sb.append("SELECT ");
            sb.append("' ' as fexpenseid,'' as fcostcenterid,'' as FCostItemID,'' as FcostObjectID,");
            sb.append("N'' as fexpensenumber,'' as fexpensename,");
            sb.append("N'' as fcostcenternumber,N'' as fcostcentername,");
            sb.append("N'' as fcostobjectnumber,N'' as fcostobjectname,");
            sb.append("N'' as fcostobjectsuitenumber,N'' as fcostobjectsuitename,'' as fcostobjectsuiteid,");
            sb.append("N'' as FOrderNumber, N'' as FBatchNumber, N'' as FLot, N'' as FTrackNumber, N'' as FProjectNumber, ");
            sb.append("N'' as FMaterialNumber, N'' as FMaterialName, ");
            sb.append("'' as FOrderID, '' as FTrackID, '' as FProjectID, '' as FMaterialID, ");
            sb.append("N'' as fmodel,N'' as fproductshortname,N'' as fcompanynumber,N'' as fcompanyname,");
            sb.append("N'' as fdepartmentID,N'' as fdepartmentnumber,N'' as fdepartmentname,");
            sb.append("N'' as fSourceCostCenterID,N'' as FSourceCostCenterNumber,N'' as fSourceCostCenterName,");
            sb.append("N'' as fcostitemnumber,N'' as fcostitemname,");
            sb.append("sum(FAMOUNT) as famount,");
            sb.append("sum(FQty) as fqty, \n");
            sb.append("1 as fistotalrow,3 as FTotalRow2,200 as FTotalRow,max(FqtyPrecision),max(FPricePrecision) \n");
            sb.append("from " + stempTableName + " \n");
            sb.append("where FTotalRow = 0");
            sb.append("\n");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1 set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_L2 \n");
            sb.append(" from T_ORG_CostCenter t2 \n");
            sb.append(" where t1.FCostCenterID = t2.FID) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
            sb.append(" update " + stempTableName + " as t1 set (FCostObjectNumber ,FCostObjectName,FModel,FProductShortName) = (select t2.FNumber,t2.FName_L2, t3.FModel,t3.FShortName \n");
            sb.append(" from  T_BD_CostObject t2 ");
            sb.append(" JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t2.FStdProductIDID \n");
            sb.append(" JOIN T_BD_Material t3 ON t3.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
            sb.append(" where t1.FCostObjectID = t2.FID AND T_BD_MaterialCompanyInfo.FCompanyID='").append(companyID).append("'");
            sb.append(" AND T_BD_MaterialCompanyInfo.FStatus = 1 )");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update ");
            sb.append(stempTableName);
            sb.append(" set FCostObjectNumber = '' \n");
            sb.append(" Where FCostObjectNumber is null \n\n;");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update ");
            sb.append(stempTableName);
            sb.append(" set fcostobjectsuitenumber = '' \n");
            sb.append(" Where fcostobjectsuitenumber is null \n\n;");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n");
            sb.append(" from t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FExpenseNumber, FExpenseName )= (select  t2.FNumber,t2.FName_L2 \n");
            sb.append(" from t_Ncm_Expense t2 where  t1.FExpenseID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FOrderNumber )= (select  t2.FOrderNumber \n");
            sb.append(" from t_Bd_CostObject t2 where  t1.FCostObjectID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FBatchNumber,FLot )= (select  t2.FBatchNumber,t2.FBatchNumber \n");
            sb.append(" from t_Bd_CostObject t2 where  t1.FCostObjectID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FProjectNumber )= (select  t2.FNumber \n");
            sb.append(" from t_mm_project t2 where  t1.FProjectID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FTrackNumber )= (select  t2.FNumber \n");
            sb.append(" from t_mm_trackNumber t2 where  t1.FTrackID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1  set (FMaterialNumber, FMaterialName )= (select  t2.FNumber,t2.FName_L2 \n");
            sb.append(" from t_bd_material t2 where  t1.FMaterialID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + " as t1 \n");
            sb.append(" set (FqtyPrecision,FPricePrecision)=\n");
            sb.append("(select top 1 t2.FqtyPrecision,t2.FPricePrecision from " + stempTableName + " AS T2 \n");
            sb.append("where T2.fexpensenumber=t1.fexpensenumber) where t1.fexpenseid=' '");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set FqtyPrecision=select max(FqtyPrecision) as FqtyPrecision from " + stempTableName + " where fexpenseid=' ' \n");
            sb.append(" ,FPricePrecision=select max(FPricePrecision) as FqtyPrecision from " + stempTableName + " where fexpenseid=' ' \n");
            sb.append(" where fexpensenumber=' '");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set fprice=round(famount/fqty,fpriceprecision) \n");
            sb.append(" where fexpenseid!=' ' and fqty<>0 and FIsTotalRow = 0");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName + "  \n");
            sb.append(" set fprice=0 \n");
            sb.append(" where fexpenseid!=' ' and fqty=0");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + stempTableName);
            sb.append(" set fexpensenumber=N'' ,fcostcenternumber=N'',fcostitemnumber=N'',fcostobjectnumber=N''");
            sb.append(" where fexpenseid=' '");
            st.addBatch(sb.toString());
            String orderBy = this.getShowString(this.doPerQuerySolution(filter)).toString();
            String[] orderStrings = orderBy.split(",");
            String totalFieldNumber = orderStrings[0];
            sb = new StringBuffer();
            sb.append("Update ");
            sb.append(stempTableName);
            sb.append(" set ");
            sb.append(totalFieldNumber);
            sb.append(" = '");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()));
            sb.append("'  where Ftotalrow2 = 3 \n");
            st.addBatch(sb.toString());
            st.executeBatch();
            sb = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                String field = (String)map.get("id");
                String fieldName = field.substring(0, field.length() - 2) + "Name";
                String fieldNumber = field.substring(0, field.length() - 2) + "Number";
                if (field.equalsIgnoreCase("FOrderID")) {
                    fieldName = "FOrderNumber";
                } else if (field.equalsIgnoreCase("FTrackID")) {
                    fieldName = "FTrackNumber";
                } else if (field.equalsIgnoreCase("FProjectID")) {
                    fieldName = "FProjectNumber";
                } else if (field.equalsIgnoreCase("FLot")) {
                    fieldName = "FBatchNumber";
                    fieldNumber = "FBatchNumber";
                }
                String whichTotal = "";
                if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                    whichTotal = ", FTotalCostCenterRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                    whichTotal = ", FTotalCostObjectRow = 1 ";
                    fieldNumber = "FCostObjectNumber";
                    fieldName = "FCostObjectName";
                }
                if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                    whichTotal = ", FTotalCostItemRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                    whichTotal = ", FTotalExpenseRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FCostObjectSuiteNumber")) {
                    whichTotal = ", FTotalCostObjectSuiteRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                    whichTotal = ", FTotalOrderRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                    whichTotal = ", FTotalTrackRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                    whichTotal = ", FTotalProjectRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                    whichTotal = ", FTotalMaterialRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                    whichTotal = ", FTotalBatchRow = 1 ";
                }
                if (fieldName.equalsIgnoreCase("FOrderNumber") || fieldName.equalsIgnoreCase("FTrackNumber") || fieldName.equalsIgnoreCase("FProjectNumber") || fieldName.equalsIgnoreCase("FBatchNumber")) {
                    sb.append(" update " + stempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'");
                    sb.append(whichTotal);
                    sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                    sb.append("\n\n");
                    sb.append(";");
                    continue;
                }
                sb.append(" update " + stempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
                sb.append(whichTotal);
                sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sb.append("\n\n");
                sb.append(";");
            }
            sb.append(" DELETE " + stempTableName + " \n");
            sb.append("  WHERE FTOTALROW > 0 \n");
            sb.append("    AND ((FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostCenterNumber is null OR FCostCenterNumber = '' OR FCostCenterNumber = ' ')) OR \n");
            sb.append("         (FCostObjectName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostObjectNumber is null OR FCostObjectNumber = '' OR FCostObjectNumber = ' ')) OR \n");
            sb.append("         (FCostObjectSuiteName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostObjectSuiteNumber is null OR FCostObjectSuiteNumber = '' OR FCostObjectSuiteNumber = ' ')) OR \n");
            sb.append("         (FExpenseName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FExpenseNumber is null OR FExpenseNumber = '' OR FExpenseNumber = ' ')) OR \n");
            sb.append("         (FOrderNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FOrderID is null OR FOrderID = '' OR FOrderID = ' ')) OR \n");
            sb.append("         (FProjectNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FProjectID is null OR FProjectID = '' OR FProjectID = ' ')) OR \n");
            sb.append("         (FTrackNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FTrackID is null OR FTrackID = '' OR FTrackID = ' ')) OR \n");
            sb.append("         (FMaterialName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FMaterialNumber is null OR FMaterialNumber = '' OR FMaterialNumber = ' ')) OR \n");
            sb.append("         (FBatchNumber = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FLot is null OR FLot = '' OR FLot = ' ')) OR \n");
            sb.append("         (FCostItemName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostItemNumber is null OR FCostItemNumber = '' OR FCostItemNumber = ' ')) ) ");
            sb.append("    AND FTotalRow2 != 3 \n");
            sb.append("\n\n;");
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, stempTableName);
            string = stempTableName;
        }
        catch (SQLException e1) {
            try {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(stempTableName);
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return string;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        try {
            this.doPerQuerySolution(filter);
            String sTableName = this.getReportDataTableName(filter);
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + sTableName));
            return rs;
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        String sql = this.buildDataSql(filter, tableName);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        try {
            this.doPerQuerySolution(filter);
            String sTableName = this.getReportDataTableName(filter);
            return sTableName;
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        filter = this.setDefualtQuerySolution(filter);
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"102_MAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodfrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + "\u81f3" + filter.getString("yearto") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodto") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterfrom"), filter.getString("costcenterto")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectfrom"), filter.getString("costobjectto")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"114_MaterialCostDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectgroupfrom"), filter.getString("costobjectgroupto")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"138_OtherFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("expensefrom"), filter.getString("expenseto")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("materialFrom"), filter.getString("materialTo")));
        titles.AddTitle(11, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ExpenseType", (Locale)ctx.getLocale()) + "\uff1a" + this.titleForExpenseTypes(filter));
        return titles;
    }

    protected String titleForExpenseTypes(RptParams filter) {
        boolean isOther;
        boolean isConsign;
        boolean isManufacture;
        boolean isLabor;
        boolean isEquipment;
        String title = "";
        Object equipmentTemp = filter.getObject("equipment");
        String equipment = "";
        if (equipmentTemp != null && equipmentTemp instanceof Boolean && (isEquipment = ((Boolean)equipmentTemp).booleanValue())) {
            equipment = " " + ExpenseTypeEnum.EQUIPMENT.toString();
        }
        Object laborTemp = filter.getObject("labor");
        String labor = "";
        if (laborTemp != null && laborTemp instanceof Boolean && (isLabor = ((Boolean)laborTemp).booleanValue())) {
            labor = " " + ExpenseTypeEnum.LABOR.toString();
        }
        Object manufactureTemp = filter.getObject("manufacture");
        String manufacture = "";
        if (manufactureTemp != null && manufactureTemp instanceof Boolean && (isManufacture = ((Boolean)manufactureTemp).booleanValue())) {
            manufacture = " " + ExpenseTypeEnum.MANUFACTURE.toString();
        }
        Object consignTemp = filter.getObject("consign");
        String consign = "";
        if (consignTemp != null && consignTemp instanceof Boolean && (isConsign = ((Boolean)consignTemp).booleanValue())) {
            consign = " " + ExpenseTypeEnum.CONSIGN.toString();
        }
        Object otherTemp = filter.getObject("other");
        String other = "";
        if (otherTemp != null && otherTemp instanceof Boolean && (isOther = ((Boolean)otherTemp).booleanValue())) {
            other = " " + ExpenseTypeEnum.OTHER.toString();
        }
        if ((title = labor + manufacture + consign + equipment + other).equals("")) {
            return "\u65e0";
        }
        return title;
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String fieldID = (String)map.get("id");
                sb.append(fieldID);
                map.put("groupby", sb.toString());
                map.put("totalrow", 104 - i);
                newList.add(map);
            }
        }
        return newList;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow2 ");
        sql.append(orderByMode);
        sql.append(", ");
        ArrayList list = this.getGroupByList(this.doPerQuerySolution(filter));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            if (field.equalsIgnoreCase("FLot")) {
                fieldNumber = "FBatchNumber";
            }
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + orderByMode;
                fieldNumber = "FCostObjectNumber";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                orderByWhichTotal = ", FTotalExpenseRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectSuiteNumber")) {
                orderByWhichTotal = ", FTotalCostObjectSuiteRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                orderByWhichTotal = ", FTotalOrderRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                orderByWhichTotal = ", FTotalBatchRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                orderByWhichTotal = ", FTotalProjectRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                orderByWhichTotal = ", FTotalTrackRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                orderByWhichTotal = ", FTotalMaterialRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FOrderNumber")) {
                sql.append("FOrderID");
            } else if (fieldNumber.equalsIgnoreCase("FBatchNumber")) {
                sql.append("FLot");
            } else if (fieldNumber.equalsIgnoreCase("FProjectNumber")) {
                sql.append("FProjectID");
            } else if (fieldNumber.equalsIgnoreCase("FTrackNumber")) {
                sql.append("FTrackID");
            } else {
                sql.append(fieldNumber);
            }
            sql.append(orderByWhichTotal);
            sql.append(",");
        }
        sql.append("FTotalRow");
        return sql.toString();
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = new ReportHeader();
        String orderBy = this.getShowString(this.doPerQuerySolution(filter)).toString();
        String[] orderStrings = orderBy.split(",");
        boolean isItem = false;
        int index = 0;
        for (int i = 0; i < orderStrings.length; ++i) {
            index = isItem ? i + 2 : i + 1;
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("fcostobjectname")) {
                isItem = true;
                reportHeader.addChild("fcostobjectname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
                reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Model", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 1);
                reportHeader.addChild("fproductshortname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 2);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostObjectSuiteNumber")) {
                reportHeader.addChild("FCostObjectSuiteNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CostObjectSuiteNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostObjectSuiteName")) {
                reportHeader.addChild("FCostObjectSuiteName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"CostObjectSuiteName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FExpenseNumber")) {
                reportHeader.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FExpenseName")) {
                reportHeader.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostItemNumber")) {
                reportHeader.addChild("Fdepartmentname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"departmentname_2", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 4);
                reportHeader.addChild("FSourceCostCenterName", "\u6765\u6e90\u6210\u672c\u4e2d\u5fc3").setAlign(1).setIndex(index + 4);
                reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 4);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostItemName")) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
        }
        reportHeader.addChild("FUnit", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Unit", (Locale)ctx.getLocale())).setAlign(1);
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("fpriceprecision");
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("fqtyprecision");
        int amtPrecision = 2;
        try {
            String currencyId = ContextUtil.getCurrentFIUnit((Context)this.getContext()).getBaseCurrency().getId().toString();
            amtPrecision = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)).getPrecision();
        }
        catch (Exception exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(amtPrecision);
        reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 6);
        reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"batchName", (Locale)ctx.getLocale()), 7);
        reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 8);
        reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 9);
        reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()), 10);
        reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()), 11);
        return reportHeader;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    private ArrayList doPerQuerySolution(RptParams filter) {
        ArrayList tableMain = (ArrayList)filter.getObject("table");
        if (tableMain == null) {
            tableMain = new ArrayList();
            HashMap<String, Object> mapExpense = new HashMap<String, Object>();
            mapExpense.put("groupby", "FExpenseID");
            mapExpense.put("totalrow", "104");
            mapExpense.put("isTotal", Boolean.TRUE);
            mapExpense.put("id", "FExpenseID");
            tableMain.add(mapExpense);
            HashMap<String, Object> mapCostCenter = new HashMap<String, Object>();
            mapCostCenter.put("groupby", "FExpenseID,FCostCenterID");
            mapCostCenter.put("totalrow", "103");
            mapCostCenter.put("isTotal", Boolean.TRUE);
            mapCostCenter.put("id", "FCostCenterID");
            tableMain.add(mapCostCenter);
            HashMap<String, Object> mapCostObject = new HashMap<String, Object>();
            mapCostObject.put("isTotal", Boolean.FALSE);
            mapCostObject.put("id", "FCostObjectID");
            tableMain.add(mapCostObject);
            HashMap<String, Object> mapCostItem = new HashMap<String, Object>();
            mapCostItem.put("isTotal", Boolean.FALSE);
            mapCostItem.put("id", "FCostItemID");
            tableMain.add(mapCostItem);
            HashMap<String, Object> mapCostObjSuite = new HashMap<String, Object>();
            mapCostObjSuite.put("isTotal", Boolean.FALSE);
            mapCostObjSuite.put("id", "FCostObjectSuiteID");
            tableMain.add(mapCostObjSuite);
        }
        return tableMain;
    }

    private RptParams setDefualtQuerySolution(RptParams filter) throws BOSException {
        HashMap<String, Object> map;
        PeriodInfo period;
        if (filter.size() != 0 && filter.getObject("companyorg") != null) {
            return filter;
        }
        RptParams defualtFilter = new RptParams();
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        try {
            period = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyInfo.getId().toString());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (filter.getObject("companyorg") == null) {
            map = new HashMap<String, Object>();
            map.put("companyorg", companyInfo);
            defualtFilter.putAll(map);
        }
        if (filter.getObject("yearfrom") == null) {
            map = new HashMap();
            map.put("yearfrom", String.valueOf(period.getPeriodYear()));
            defualtFilter.putAll(map);
        }
        if (filter.getObject("yearfrom") == null) {
            HashMap<String, String> yearfrom = new HashMap<String, String>();
            HashMap<String, String> yearto = new HashMap<String, String>();
            yearfrom.put("yearfrom", String.valueOf(period.getPeriodYear()));
            yearto.put("yearto", String.valueOf(period.getPeriodYear()));
            defualtFilter.putAll(yearfrom);
            defualtFilter.putAll(yearto);
        }
        if (filter.getObject("periodfrom") == null) {
            HashMap<String, String> periodfrom = new HashMap<String, String>();
            HashMap<String, String> periodto = new HashMap<String, String>();
            periodfrom.put("periodfrom", String.valueOf(period.getNumber() % 100));
            periodto.put("periodto", String.valueOf(period.getNumber() % 100));
            defualtFilter.putAll(periodfrom);
            defualtFilter.putAll(periodto);
        }
        return defualtFilter;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(90), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(200), a);
        return conditions;
    }
}

