/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class ProductIOReport
extends ReportServerBase {
    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        String tempTableName;
        String tempTable;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        StringBuffer sbfilter = this.buildFilter(filter);
        String tableName = null;
        try {
            int periodFrom = Integer.parseInt(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_Balance", (int)periodFrom, (int)periodFrom);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table temp_productIO ( ");
        createTable.append(" FCostCenterID varchar(44) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FQty decimal(21,8) ");
        createTable.append(",Ftype int ");
        createTable.append(" ) ");
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean a = false;
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTable + "(FCostCenterID,FCostObjectID,FQty,Ftype) \n");
        sb.append("SELECT t3.FID,t4.FID,t1.FbopwipQty,0  \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID \n ");
        sb.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID \n ");
        sb.append(" left join t_mm_manufactureOrder od on t4.FOrderID = od.FID \n");
        sb.append(" left join t_mm_project po on t4.FProjectID = po.FID \n");
        sb.append(" left join t_mm_trackNumber tr on t4.FTrackID = tr.FID \n");
        sb.append(" left join t_bd_material mat on t4.FStdProductIDID = mat.FID \n");
        sb.append(" where t1.FCompanyOrg = ? \n");
        sb.append(sbfilter);
        DbUtil.execute((Context)this.getContext(), (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTable + "(FCostCenterID,FCostObjectID,FQty,Ftype) \n");
        sb.append("SELECT t3.FID,t4.FID,t1.FQty,4  \n");
        sb.append(" from T_NCM_WIPCountingBill  t1 \n");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriod = t2.FID \n ");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID \n ");
        sb.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID \n ");
        sb.append(" left join t_mm_manufactureOrder od on t4.FOrderID = od.FID \n");
        sb.append(" left join t_mm_project po on od.FProjectID = po.FID \n");
        sb.append(" left join t_mm_trackNumber tr on od.FTrackID = tr.FID \n");
        sb.append(" left join t_bd_material mat on t4.FStdProductIDID = mat.FID \n");
        sb.append(" where t1.FBillStatus=4 and t1.FCompanyOrg = ? \n");
        sb.append(sbfilter);
        DbUtil.execute((Context)this.getContext(), (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTable + "(FCostCenterID,FCostObjectID,FQty,Ftype) \n");
        sb.append("SELECT t3.FID,t4.FID,t11.FQty,1  \n");
        sb.append(" from t_ncm_inputqtybill  t1 \n");
        sb.append(" inner join t_ncm_inputqtybillentry t11 on t1.fid=t11.fparentid \n ");
        sb.append(" inner join t_bd_period t2 on t1.FCalculatePeriod = t2.FID \n ");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterOrgUnitID = t3.FID \n ");
        sb.append(" inner join T_BD_CostObject t4 on t11.FCostObjectID = t4.FID \n ");
        sb.append(" left join t_mm_manufactureOrder od on t4.FOrderID = od.FID \n");
        sb.append(" left join t_mm_project po on od.FProjectID = po.FID \n");
        sb.append(" left join t_mm_trackNumber tr on od.FTrackID = tr.FID \n");
        sb.append(" left join t_bd_material mat on t4.FStdProductIDID = mat.FID \n");
        sb.append(" where t1.FBillStatus=4 and t1.FCompanyOrg = ? \n");
        sb.append(sbfilter);
        DbUtil.execute((Context)this.getContext(), (String)sb.toString(), (Object[])new String[]{companyID});
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTable + "(FCostCenterID,FCostObjectID,FQty,Ftype) \n");
        sb.append("SELECT t3.FID,t4.FID,SUM(t11.FBaseQty * costObjectEntry.FQuotiety ),2  \n");
        sb.append(" from T_IM_ManufactureRecBill  t1 \n");
        sb.append(" INNER JOIN T_SCM_TransactionType TRANSTYPE  \n");
        sb.append(" ON t1.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1 \n");
        sb.append(" inner join T_IM_ManufactureRecBillEntry t11 on t1.fid=t11.fparentid \n ");
        sb.append(" inner join T_IM_InvUpdateType ut on t11.FINVUPDATETYPEID = ut.fid \n");
        sb.append(" inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \n");
        sb.append(" inner join T_ORG_CostCenter t3 on t11.FCostCenterOrgUnitID = t3.FID \n ");
        sb.append("    inner join T_BD_CostObjectEntry costObjectEntry  ");
        sb.append("          on t11.FMaterialID = costObjectEntry.FRelatedID ");
        sb.append(" inner join T_BD_CostObject t4 on t4.FID = costObjectEntry.FParentID ");
        sb.append(" and  t11.FCompanyOrgUnitID = t4.FCompanyID ");
        sb.append(" left join t_mm_manufactureOrder od on t4.FOrderID = od.FID ");
        sb.append(" left join t_mm_project po on od.FProjectID = po.FID \n");
        sb.append(" left join t_mm_trackNumber tr on od.FTrackID = tr.FID \n");
        sb.append(" left join t_bd_material mat on t4.FStdProductIDID = mat.FID \n");
        sb.append(" where t1.FBaseStatus=4 and t11.FCompanyOrgUnitID = ? \n");
        sb.append("\t\t\t   and ").append("\n");
        sb.append("\t\t\t   ( ").append("\n");
        sb.append("\t\t\t       (t4.FCalculateMode = 4 and Isnull(t11.FLot,' ') = Isnull(t4.FBatchNumber,' ')) ").append("\n");
        sb.append("\t\t\t\t   or ").append("\n");
        sb.append("\t\t\t\t   (t4.FCalculateMode = 7 and t4.FOrderID = t11.FManuBillID) ").append("\n");
        sb.append("\t\t\t\t   or ").append("\n");
        sb.append("\t\t\t\t   (t4.FCalculateMode in (1, 3)) ").append("\n");
        sb.append("\t\t\t   )").append("\n");
        sb.append(" and t4.FIsForbiden = 0 \n");
        sb.append(this.buildFilter1(filter));
        sb.append(" group by  t3.FID,t4.FID \n");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString(), (Object[])new String[]{companyID});
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, tempTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        createTable = new StringBuffer();
        createTable.append("create table t1 ( ");
        createTable.append(" FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostObjectName varchar(255) ");
        createTable.append(",FProductID varchar(44) ");
        createTable.append(",FProductNumber varchar(80) not null default(' ') ");
        createTable.append(",FProductName varchar(255) ");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FProjectNumber varchar(80) ");
        createTable.append(",FTrackNumber varchar(80) ");
        createTable.append(",FqtyPrecision int not null default(4) ");
        createTable.append(",FQty0 decimal(21,8) default(0) ");
        createTable.append(",FQty1 decimal(21,8) default(0)");
        createTable.append(",FQty2 decimal(21,8) default(0)");
        createTable.append(",FQty3 decimal(21,8) default(0)");
        createTable.append(",FQty4 decimal(21,8) default(0)");
        createTable.append(",FQty5 decimal(21,8) default(0)");
        createTable.append(",FOrderNumber varchar(80)");
        createTable.append(",FLot nvarchar(80)");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FCostCenterID,FCostObjectID,FProductID) \n");
        sb.append("SELECT DISTINCT t1.FCostCenterID,t1.FCostObjectID,costObjectEntry.FRelatedID \n");
        sb.append(" from " + tempTable + " t1 \n");
        sb.append(" inner join T_BD_CostObjectEntry costObjectEntry \n");
        sb.append(" \ton costObjectEntry.FParentID = t1.FCostObjectID \n");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        Locale locale = this.getContext().getLocale();
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + " set fqty0= \n ");
        sb.append(" isnull((select sum(fqty) from " + tempTable + " as t2 \n ");
        sb.append(" where t2.FCostCenterID=" + tempTableName + ".FCostCenterID and t2.FCostObjectID=" + tempTableName + ".FCostObjectID  and t2.ftype = 0 ),0) \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "   set fqty1= \n ");
        sb.append(" isnull((select sum(fqty) from " + tempTable + " as t2 \n ");
        sb.append(" where t2.FCostCenterID=" + tempTableName + ".FCostCenterID and t2.FCostObjectID=" + tempTableName + ".FCostObjectID  and t2.ftype = 1 ),0) \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "   set fqty2= \n ");
        sb.append(" isnull((select sum(fqty) from " + tempTable + " as t2 \n ");
        sb.append(" where t2.FCostCenterID=" + tempTableName + ".FCostCenterID and t2.FCostObjectID=" + tempTableName + ".FCostObjectID  and t2.ftype = 2 ),0) \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "   set fqty4= \n ");
        sb.append(" isnull((select sum(fqty) from " + tempTable + " as t2 \n ");
        sb.append(" where t2.FCostCenterID=" + tempTableName + ".FCostCenterID and t2.FCostObjectID=" + tempTableName + ".FCostObjectID  and t2.ftype = 4 ),0) \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + " set fqty3=fqty0+fqty1-fqty2 \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "  set fqty5=fqty4-fqty3 \n ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "  set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_" + locale + " \n");
        sb.append(" from T_ORG_CostCenter t2 \n");
        sb.append(" where FCostCenterID = t2.FID) ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + " as t set (FCostObjectNumber ,FCostObjectName ,FOrderNumber ,FLot ,FProjectNumber ,FTrackNumber)  = (select t2.FNumber,t2.FName_" + locale + " ,od.FNumber,t2.FBatchNumber,po.FNumber,tr.FNumber\n");
        sb.append(" from  T_BD_CostObject t2 ");
        sb.append(" left join t_mm_manufactureOrder od on t2.FOrderID = od.FID ");
        sb.append(" left join t_mm_project po on od.FProjectID = po.FID ");
        sb.append(" left join t_mm_trackNumber tr on od.FTrackID = tr.FID ");
        sb.append(" where t.FCostObjectID = t2.FID )");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + "  set (FProductNumber,FProductName,FProductModel,FProductShortName,FqtyPrecision)  = (select t3.FNumber,t3.FName_" + locale + ", t3.FModel,t3.FShortName,unit.FqtyPrecision \n");
        sb.append(" from  t_bd_Material t3 ");
        sb.append(" inner join t_bd_MeasureUnit unit on t3.FBaseUnit = unit.FID \n");
        sb.append(" where FProductID = t3.FID )");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append(" update " + tempTableName + " set FqtyPrecision =(select max(FqtyPrecision) from  \n");
        sb.append(tempTableName);
        sb.append(") \n\n");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return tempTableName;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + " Order by FCostCenterNumber,FCostObjectNumber,FProductNumber "), (int)start, (int)rows);
        return rs;
    }

    private StringBuffer buildFilter(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(" and t2.FNumber =");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("orderFrom") != null && !"".equals(filter.getString("orderFrom"))) {
            sb.append(" and od.FNumber >='").append(filter.getString("orderFrom")).append("'");
        }
        if (filter.getString("orderTo") != null && !"".equals(filter.getString("orderTo"))) {
            sb.append(" and od.FNumber <='").append(filter.getString("orderTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t4.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t4.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("materialFrom") != null && !"".equals(filter.getString("materialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("materialFrom")).append("'");
        }
        if (filter.getString("materialTo") != null && !"".equals(filter.getString("materialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("materialTo")).append("'");
        }
        return sb;
    }

    private StringBuffer buildFilter1(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(" and t1.Fyear =");
        sb.append(filter.getString("yearFrom"));
        sb.append(" and t1.Fperiod =");
        sb.append(filter.getString("periodFrom"));
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("orderFrom") != null && !"".equals(filter.getString("orderFrom"))) {
            sb.append(" and od.FNumber >='").append(filter.getString("orderFrom")).append("'");
        }
        if (filter.getString("orderTo") != null && !"".equals(filter.getString("orderTo"))) {
            sb.append(" and od.FNumber <='").append(filter.getString("orderTo")).append("'");
        }
        if (filter.getString("batchNumberFrom") != null && !"".equals(filter.getString("batchNumberFrom"))) {
            sb.append(" and t4.FBatchNumber >='").append(filter.getString("batchNumberFrom")).append("'");
        }
        if (filter.getString("batchNumberTo") != null && !"".equals(filter.getString("batchNumberTo"))) {
            sb.append(" and t4.FBatchNumber <='").append(filter.getString("batchNumberTo")).append("'");
        }
        if (filter.getString("projectNumberFrom") != null && !"".equals(filter.getString("projectNumberFrom"))) {
            sb.append(" and po.FNumber >='").append(filter.getString("projectNumberFrom")).append("'");
        }
        if (filter.getString("projectNumberTo") != null && !"".equals(filter.getString("projectNumberTo"))) {
            sb.append(" and po.FNumber <='").append(filter.getString("projectNumberTo")).append("'");
        }
        if (filter.getString("trackNumberFrom") != null && !"".equals(filter.getString("trackNumberFrom"))) {
            sb.append(" and tr.FNumber >='").append(filter.getString("trackNumberFrom")).append("'");
        }
        if (filter.getString("trackNumberTo") != null && !"".equals(filter.getString("trackNumberTo"))) {
            sb.append(" and tr.FNumber <='").append(filter.getString("trackNumberTo")).append("'");
        }
        if (filter.getString("materialFrom") != null && !"".equals(filter.getString("materialFrom"))) {
            sb.append(" and mat.FNumber >='").append(filter.getString("materialFrom")).append("'");
        }
        if (filter.getString("materialTo") != null && !"".equals(filter.getString("materialTo"))) {
            sb.append(" and mat.FNumber <='").append(filter.getString("materialTo")).append("'");
        }
        return sb;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"91_CostRestorationDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"139_ProductIOReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"98_CostRestorationTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"226_OrderNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_ProjectNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_TrackNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(7, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_Material", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("materialFrom"), filter.getString("materialTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_BatchNumber", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchNumberFrom"), filter.getString("batchNumberTo")));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        header.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_OrderNumber", (Locale)ctx.getLocale()), 4);
        header.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"65_CostCalTotalDetailReport", (Locale)ctx.getLocale()), 5);
        header.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_ProjectNumber", (Locale)ctx.getLocale()), 6);
        header.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"2_TrackNumber", (Locale)ctx.getLocale()), 7);
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FProductNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty0")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty0", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty1")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty1", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty2")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty3")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty3", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FProductShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FQty4")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty4", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FQty5")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty5", (Locale)ctx.getLocale()));
        }
        return header;
    }
}

