/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.report.app.RecoveryByEndlReport;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class RecoveryByStepReport
extends RecoveryByEndlReport {
    @Override
    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        String[] physicalTblNames;
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("prmtCompanyOrg")).getId().toString();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (NumberFormatException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        String sTmpTblName = this.createTmpTable();
        String sqlAll = this.getSQL(filter, physicalTblNames, sTmpTblName);
        DbUtil.execute((Context)this.getContext(), (String)sqlAll, (Object[])new String[]{companyID});
        StringBuffer processSumSql = new StringBuffer();
        this.updateFTotalRow(processSumSql, sTmpTblName, filter);
        this.insertDataToTableSum(processSumSql, sTmpTblName, filter);
        this.updateSEQ(processSumSql, physicalTblNames, sTmpTblName);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)processSumSql.toString());
        try {
            StringBuffer s = new StringBuffer();
            s.append("select MAX(FDispLayer) as FDispLayer from ").append(sTmpTblName);
            Context ctx = this.getContext();
            IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)s.toString());
            int totalLevel = 0;
            if (rs.size() >= 0) {
                while (rs.next()) {
                    totalLevel = rs.getInt("FDispLayer");
                }
            }
            StringBuffer str = null;
            StringBuffer sqlTemp = null;
            for (int i = totalLevel; i > 0; --i) {
                str = new StringBuffer();
                for (int j = i; j > 0; --j) {
                    str.append("*");
                }
                str.append(i);
                sqlTemp = new StringBuffer();
                sqlTemp.append("update ").append(sTmpTblName).append(" set FDisplayLayerStr='").append(str).append("' where FDispLayer=").append(i);
                NCMDbUtil.execute((Context)ctx, (String)sqlTemp.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        super.setTablename(sTmpTblName);
        return sTmpTblName;
    }

    @Override
    protected String[] getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException, SQLException {
        int fromPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
        int toPeriod = Integer.parseInt(NCMReportHelper.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        String[] physicalTblNames = new String[2];
        physicalTblNames[0] = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyID, (String)"T_NCM_CostRecoveryReportByStep", (int)fromPeriod, (int)toPeriod);
        return physicalTblNames;
    }

    @Override
    protected String createTmpTable() throws BOSException {
        String sTmpTblName;
        String sql = MessageFormat.format("Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FCostItemGroupID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FPeriodDispNumber INT,FProductNumber NVARCHAR(80),FProductName NVARCHAR(255),FProdBatchNo NVARCHAR(80),FProductModel NVARCHAR(255),FProductUnitName NVARCHAR(255),FCostItemGroupNumber NVARCHAR(80),FCostItemGroupName NVARCHAR(255),FCostItemNumber NVARCHAR(80),FCostItemName NVARCHAR(255),FMaterialNumber NVARCHAR(80),FMaterialName NVARCHAR(255),FMatBatchNo NVARCHAR(80),FMaterielModel NVARCHAR(255),FMaterielUnitName NVARCHAR(255),FFinishedQty NUMERIC(21,8) DEFAULT 0,FFinishedAmount NUMERIC(17,4) DEFAULT 0,FFinishedUnitQty NUMERIC(21,8) DEFAULT 0,FFinishedUnitAmount NUMERIC(21,8) DEFAULT 0,FFinishedUnitRatio NUMERIC(21,8) DEFAULT 0,FQtyDecimal smallint,FPriceDecimal smallint,FAmountDecimal smallint,FTotalRow Decimal(5,2) not null DEFAULT 0, FSort NUMERIC(21,0) Default 0,FLayer smallint DEFAULT 0,FDispLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FBranch varchar(1020) NOT NULL DEFAULT ('' ''),FDisplayLayerStr VARCHAR(255),FParentID VARCHAR(44),CONSTRAINT {1} PRIMARY KEY NONCLUSTERED (FID))", "T_SUN_BYSTEP", "T_SUN_BYSTEP_KF");
        sql = sql.substring(0, sql.lastIndexOf(44)) + ")";
        sql = sql.replaceFirst("FProductID VARCHAR\\(44\\),", "FProductID VARCHAR(44),FManufacturerOrderID VARCHAR(44),FTranceID VARCHAR(44),FTranceNumber VARCHAR(88),FSaleOrderNumber VARCHAR(44),FContractOrderNumber VARCHAR(44),");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(sql);
            super.setTablename(sTmpTblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    @Override
    protected String getSQL(RptParams filter, String[] physicalTblNames, String tmpTblName) {
        Context ctx = this.getContext();
        String select = "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FFinishedQty,FFinishedAmount,FFinishedUnitQty,FFinishedUnitAmount,FFinishedUnitRatio,FQtyDecimal,FPriceDecimal,FAmountDecimal,FTotalRow, FSort, FLayer, FDispLayer, FIsLeaf, FBranch, FParentID";
        StringBuffer insert = new StringBuffer();
        insert.append(" INSERT INTO ").append(tmpTblName).append(" ( ").append(select).append(" ) \n SELECT ").append(select).append(" \t\n ").append(" FROM ").append(physicalTblNames[0]);
        HashMap map = (HashMap)filter.getObject("position");
        String productIDs = (String)map.get("productid");
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append(" WHERE FCompanyID = ? \n");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, true, " FPeriodDispNumber", "", "");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, " FProductNumber", ">=", "prmtProductFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, " FProductNumber", "<=", "prmtProductFromTo");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, " FProdBatchNo", ">=", "txtLotFrom");
        NCMReportHelper.AppendPredicate(ctx, whereSQL, filter, false, " FProdBatchNo", "<=", "txtLotTo");
        if (!StringUtils.isEmpty((String)productIDs)) {
            whereSQL.append(" and FProductID in (").append(productIDs).append(" ) \n");
        }
        whereSQL.append(this.getORDERBY());
        String sql = insert.append(whereSQL).toString();
        return sql;
    }

    @Override
    protected StringBuffer insertDataToTableSum(StringBuffer sql, String tempTableNameSum, RptParams filter) {
        sql.append('\n').append("INSERT INTO ").append(tempTableNameSum).append('\n').append(" ( FID, FProductId,FPeriodDispNumber,FProductNumber ,FProductName,FProdBatchNo, FProductUnitName, FDispLayer, FCostItemGroupID,FTotalRow,FCostItemNumber,FCostItemName\t").append('\n').append(" ,FFinishedQty ,FFinishedAmount ").append('\n').append(" ,FQtyDecimal,FPriceDecimal,FAmountDecimal  )                                        \t\t\t\t").append('\n').append(" SELECT newbosid('43218765'),FProductId,FPeriodDispNumber,FProductNumber, FProductName,FProdBatchNo, FProductUnitName, FDispLayer, FCostItemGroupID,       ").append(4).append('\n').append("  ,FCostItemGroupNumber,FCostItemGroupName,sum(FFinishedQty ) ,sum(FFinishedAmount)               ").append('\n').append(" ,max(FQtyDecimal),max(FPriceDecimal),FAmountDecimal                                          \t\t\t\t").append('\n').append(" FROM   ").append(tempTableNameSum).append('\n').append(" WHERE FTotalRow =   ").append(3).append('\n').append(" AND FCostItemGroupID is NOT null").append(" GROUP BY FProductId,FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo, FProductUnitName, FDispLayer, FCostItemGroupID                             ").append('\n').append(" ,FCostItemGroupNumber,FCostItemGroupName,FAmountDecimal                                          \t\t\t\t").append('\n').append(" ; ");
        return sql;
    }

    @Override
    protected void updateSEQ(StringBuffer processSumSql, String[] physicalTblNames, String sTmpTblName) {
        super.updateSEQ(processSumSql, physicalTblNames, sTmpTblName);
    }

    @Override
    protected String getSEQField() {
        return " FSort ";
    }

    @Override
    protected String getSELECT() {
        return "SELECT distinct FSort,FProductID, FPeriodDispNumber,FProductNumber,FCostItemNumber, FMaterialNumber,FMatBatchNo FROM ";
    }

    @Override
    protected String getORDERBY() {
        return " ORDER BY FProductNumber,FProdBatchNo,FBranch,FisLeaf desc,FDisPLayer,FPeriodDispNumber,FCostItemNumber,FMaterialNumber ";
    }

    @Override
    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ArrayList childChildList = null;
        ReportHeader childChildHeader = null;
        ReportHeader childHeader = null;
        String fieldName = null;
        String childFieldName = null;
        for (int i = 0; i < childList.size(); ++i) {
            int j;
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setMergeable(false);
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setMergeable(false);
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FDisplayLayerStr")) {
                childHeader.setMergeable(false);
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"DispLayer", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FFinished")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Finished_2", (Locale)ctx.getLocale()));
                childChildList = childHeader.getChilds();
                for (j = 0; j < childChildList.size(); ++j) {
                    childChildHeader = (ReportHeader)childChildList.get(j);
                    childFieldName = childChildHeader.getFieldName();
                    if (childFieldName.equals("FFinishedQty")) {
                        childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!childFieldName.equals("FFinishedAmount")) continue;
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                }
                continue;
            }
            if (!fieldName.equals("FFinishedUnit")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"FinishedUnit", (Locale)ctx.getLocale()));
            childChildList = childHeader.getChilds();
            for (j = 0; j < childChildList.size(); ++j) {
                childChildHeader = (ReportHeader)childChildList.get(j);
                childFieldName = childChildHeader.getFieldName();
                if (childFieldName.equals("FFinishedUnitQty")) {
                    childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale()));
                    continue;
                }
                if (!childFieldName.equals("FFinishedUnitAmount")) continue;
                childChildHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                childChildHeader.setDecimalField("FPriceDecimal");
            }
        }
        return header;
    }

    @Override
    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(3), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(5), a);
        return conditions;
    }

    @Override
    protected void updateFTotalRow(StringBuffer sql, String tempTableNameSum, RptParams filter) {
        sql.append('\n').append(" UPDATE ").append(tempTableNameSum).append(" SET FTotalRow = ( ").append('\n').append(" CASE ").append('\n').append(" WHEN  FCostItemID is NOT null AND FMaterialID is null THEN ").append(3).append('\n').append(" WHEN  FCostItemGroupID is null AND FCostItemID is null THEN ").append(5).append('\n').append(" WHEN FCostItemGroupID is not null AND FCostItemID is null AND FMaterialID is null THEN  ").append(4).append('\n').append(" ELSE ").append(0).append('\n').append(" END ").append('\n').append(" ) ; ");
        Context ctx = this.getContext();
        sql.append(" update " + tempTableNameSum + "  set FDisplayLayerStr ='" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
        sql.append(" where FTotalRow = 5");
        sql.append("\n\n");
        sql.append(";");
    }
}

