/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Set;

public class SaleOrderCostDetailReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.report.SaleOrderCostDetailReportResource";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = "where FIsTotalRow = 1 or FIsSubTotalRow = 1 \n";
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append("where 1=1 \n");
        ksql.append("and FDataType <> 2 ");
        if (!filter.getBoolean("isShowMatDetail")) {
            ksql.append("and FDataType <> 1 ");
        }
        if (!filter.getBoolean("isShowExpenseDetail")) {
            ksql.append("and FIsExpenseTotalRow <> -1 ");
        }
        ksql.append(" order by FIsTotalRow, \n");
        ksql.append(" FSaleOrderNumber, FIsSaleOrderTotalRow, FProdNumber,\n");
        if (!this.isShowOnlyOrderSum(filter)) {
            ksql.append(" FManuOrderNumber, FIsManuOrderTotalRow, \n");
        }
        ksql.append(" FCostItemNumber, FIsCostItemTotalRow, \n");
        if (this.isShowExpenseDetail(filter)) {
            ksql.append(" FExpenseNumber, FIsExpenseTotalRow, \n");
        }
        ksql.append(" FMatNumber, FIsMaterialTotalRow \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    private boolean isShowMatDetail(RptParams filter) {
        return filter.getBoolean("isShowMatDetail");
    }

    private boolean isShowExpenseDetail(RptParams filter) {
        return filter.getBoolean("isShowExpenseDetail");
    }

    private boolean isShowExcludeSemi(RptParams filter) {
        return filter.getBoolean("isShowExcludeSemi");
    }

    private boolean isShowOnlyOrderSum(RptParams filter) {
        return filter.getBoolean("isShowOnlyOrderSum");
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FSaleOrderID varchar(44), \n");
        ksql.append("    FSaleOrderNumber varchar(80), \n");
        ksql.append("    FSaleOrderName nvarchar(80), \n");
        ksql.append("    FSaleOrderEntryID varchar(44), \n");
        ksql.append("\t FSaleOrderQty decimal(21,8) default(0),");
        ksql.append("    FSaleOrderUnitName nvarchar(256), \n");
        ksql.append("    FProdID varchar(44), \n");
        ksql.append("    FProdNumber varchar(80), \n");
        ksql.append("    FProdName nvarchar(256), \n");
        ksql.append("    FProdModel nvarchar(256), \n");
        ksql.append("    FManuOrderID varchar(44), \n");
        ksql.append("    FManuOrderNumber varchar(80), \n");
        ksql.append("    FManuOrderName nvarchar(80), \n");
        ksql.append("    FManuOrderStatus nvarchar(80), \n");
        ksql.append("\t FToStroreQty decimal(21,8) default(0), \n");
        ksql.append("\t FProjectNumber varchar(80), \n");
        ksql.append("\t FTrackNumber varchar(80), \n");
        ksql.append("    FCostObjectID varchar(44), \n");
        ksql.append("    FCostObjectNumber varchar(80), \n");
        ksql.append("    FCostObjectName nvarchar(256), \n");
        ksql.append("    FProdUnitID varchar(44), \n");
        ksql.append("    FProdUnitName nvarchar(256), \n");
        ksql.append("    FPlanQty decimal(21,8) default(0), \n");
        ksql.append("    FCostItemID varchar(44), \n");
        ksql.append("    FCostItemNumber varchar(80), \n");
        ksql.append("    FCostItemName nvarchar(256), \n");
        ksql.append("    FExpenseID varchar(44), \n");
        ksql.append("    FExpenseNumber varchar(80), \n");
        ksql.append("    FExpenseName nvarchar(256), \n");
        ksql.append("    FMatID varchar(44), \n");
        ksql.append("    FMatNumber varchar(80), \n");
        ksql.append("    FMatName nvarchar(256), \n");
        ksql.append("    FMatModel nvarchar(256), \n");
        ksql.append("    FSourceBillID varchar(44), \n");
        ksql.append("    FSourceBillNumber varchar(80), \n");
        ksql.append("    FSourceBillEntryID varchar(44), \n");
        ksql.append("    FSourceBillEntrySeq int, \n");
        ksql.append("    FSourceBillEntryEntryID varchar(44), \n");
        ksql.append("    FMatUnitID varchar(44), \n");
        ksql.append("    FMatUnitName nvarchar(256), \n");
        ksql.append("    FMatBatch nvarchar(256), \n");
        ksql.append("    FQty decimal(21,8) default(0), \n");
        ksql.append("    FPrice decimal(21,8) default(0), \n");
        ksql.append("    FAmount decimal(21,8) default(0), \n");
        ksql.append("    FQtyPrecision int not null default(2), \n");
        ksql.append("    FPricePrecision int not null default(2), \n");
        ksql.append("    FAmountPrecision int not null default(2), \n");
        ksql.append("    FMatCalculateType int default(0), \n");
        ksql.append("    FMatCalculateTypeName nvarchar(256), \n");
        ksql.append("    FDataType int not null default(0), \n");
        ksql.append("    FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsSaleOrderTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsManuOrderTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsCostItemTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsExpenseTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsMaterialTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("    FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String createCostObjectRangeTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FSaleOrderID varchar(44), \n");
        ksql.append("     FSaleOrderEntryID varchar(44), \n");
        ksql.append("     FManuOrderID varchar(44), \n");
        ksql.append("     FCostObjectID varchar(44), \n");
        ksql.append("     FMaterialID varchar(44), \n");
        ksql.append("     FLot nvarchar(256) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String createTempTable1() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FSaleOrderID varchar(44), \n");
        ksql.append("     FQty decimal(21,8) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String createTempTable2() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FSaleOrderID varchar(44), \n");
        ksql.append("     FManuOrderID varchar(44), \n");
        ksql.append("     FToStroreQty decimal(21,8) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        String T_NCM_AuxAllocResult;
        String T_NCM_OtherAllocResult;
        String T_NCM_MatAllocResult;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        }
        String companyId = company.getId().toString();
        String tempTable = this.createReportDataTempTable();
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)this.getContext(), (String)companyId);
        if (storageOrgUnitIds == null || storageOrgUnitIds.size() == 0) {
            return tempTable;
        }
        Set saleOrgUnitIds = BDCMUtils.getSaleOrgUnitIdsOfCompany((Context)this.getContext(), (String)companyId);
        if (saleOrgUnitIds == null || saleOrgUnitIds.size() == 0) {
            return tempTable;
        }
        String loc = this.getContext().getLocale().getLanguage();
        try {
            T_NCM_MatAllocResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_MatAllocResult", (int)3);
            T_NCM_OtherAllocResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_OtherAllocResult", (int)3);
            T_NCM_AuxAllocResult = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)companyId, (String)"T_NCM_AuxAllocResult", (int)3);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer ksql = new StringBuffer();
        String stempTableName = this.createCostObjectRangeTempTable();
        ksql.append("insert into " + stempTableName + " \n");
        ksql.append("( \n");
        ksql.append("     FSaleOrderID, \n");
        ksql.append("     FSaleOrderEntryID, \n");
        ksql.append("     FManuOrderID, \n");
        ksql.append("     FCostObjectID, \n");
        ksql.append("     FMaterialID, \n");
        ksql.append("     FLot \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    so.FID FSaleOrderID, \n");
        ksql.append("    soe.FID FSaleOrderEntryID, \n");
        ksql.append("    mo.FID FManuOrderID, \n");
        ksql.append("    mo.FCostObjectID FCostObjectID, \n");
        ksql.append("    mo.FMaterialID FMaterialID, \n");
        ksql.append("    mo.FLot FLot \n");
        ksql.append("from T_MM_ManufactureOrder mo \n");
        ksql.append("left join t_mm_project pro on mo.FProjectID = pro.FID \n");
        ksql.append("left join t_mm_trackNumber tr on mo.FTrackID = tr.FID \n");
        ksql.append("join T_SD_SaleOrder so on so.FID = mo.FSaleOrderId \n");
        ksql.append("join T_SD_SaleOrderEntry soe on soe.FParentID = so.FID and soe.FID = mo.FSaleOrderEntryId \n");
        ksql.append("where 1=1 \n");
        ksql.append("and mo.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
        ksql.append("and so.FSaleOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)saleOrgUnitIds) + " \n");
        ksql.append("and mo.FBaseStatus not in (0, 1, 2) \n");
        ksql.append("and so.FBaseStatus not in (0, 1, 2) \n");
        String temp = filter.getString("saleOrderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and so.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("saleOrderTo")))) {
            ksql.append(" and so.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberFrom")))) {
            ksql.append(" and pro.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberTo")))) {
            ksql.append(" and pro.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberFrom")))) {
            ksql.append(" and tr.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberTo")))) {
            ksql.append(" and tr.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderFrom")))) {
            ksql.append(" and mo.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and mo.FNumber <= '").append(temp).append("'");
        }
        ksql.append("; \n");
        ksql.append("insert into " + stempTableName + " \n");
        ksql.append("( \n");
        ksql.append("     FSaleOrderID, \n");
        ksql.append("     FSaleOrderEntryID, \n");
        ksql.append("     FManuOrderID, \n");
        ksql.append("     FCostObjectID, \n");
        ksql.append("     FMaterialID, \n");
        ksql.append("     FLot \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    so.FID FSaleOrderID, \n");
        ksql.append("    soe.FID FSaleOrderEntryID, \n");
        ksql.append("    mo.FID FManuOrderID, \n");
        ksql.append("    mo.FCostObjectID FCostObjectID, \n");
        ksql.append("    mo.FMaterialID FMaterialID, \n");
        ksql.append("    mo.FLot FLot \n");
        ksql.append("from T_MM_ManufactureOrder mo \n");
        ksql.append("left join t_mm_project pro on mo.FProjectID = pro.FID \n");
        ksql.append("left join t_mm_trackNumber tr on mo.FTrackID = tr.FID \n");
        ksql.append("join T_SD_SaleOrder so on so.FID = mo.FSourceBillID \n");
        ksql.append("join T_SD_SaleOrderEntry soe on soe.FParentID = so.FID and soe.FID = mo.FSrcBillEntryID \n");
        ksql.append("where 1=1 \n");
        ksql.append("and mo.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
        ksql.append("and so.FSaleOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)saleOrgUnitIds) + " \n");
        ksql.append("and mo.FBaseStatus not in (0, 1, 2) \n");
        ksql.append("and so.FBaseStatus not in (0, 1, 2) \n");
        temp = filter.getString("saleOrderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and so.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("saleOrderTo")))) {
            ksql.append(" and so.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberFrom")))) {
            ksql.append(" and pro.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberTo")))) {
            ksql.append(" and pro.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberFrom")))) {
            ksql.append(" and tr.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberTo")))) {
            ksql.append(" and tr.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderFrom")))) {
            ksql.append(" and mo.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and mo.FNumber <= '").append(temp).append("'");
        }
        ksql.append("; \n");
        ksql.append("insert into " + stempTableName + " \n");
        ksql.append("( \n");
        ksql.append("     FSaleOrderID, \n");
        ksql.append("     FSaleOrderEntryID, \n");
        ksql.append("     FManuOrderID, \n");
        ksql.append("     FCostObjectID, \n");
        ksql.append("     FMaterialID, \n");
        ksql.append("     FLot \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    so.FID FSaleOrderID, \n");
        ksql.append("    soe.FID FSaleOrderEntryID, \n");
        ksql.append("    mo.FID FManuOrderID, \n");
        ksql.append("    mo.FCostObjectID FCostObjectID, \n");
        ksql.append("    mo.FMaterialID FMaterialID, \n");
        ksql.append("    mo.FLot FLot \n");
        ksql.append("from T_MM_ManufactureOrder mo \n");
        ksql.append("left join t_mm_project pro on mo.FProjectID = pro.FID \n");
        ksql.append("left join t_mm_trackNumber tr on mo.FTrackID = tr.FID \n");
        ksql.append("join T_MM_PlannedOrder po on po.FID = mo.FSourceBillID \n");
        ksql.append("join T_MM_RequirementPlan rp on rp.FID = po.FSourceBillID \n");
        ksql.append("join T_SD_SaleOrder so on so.FID = rp.FSourceBillID \n");
        ksql.append("join T_SD_SaleOrderEntry soe on soe.FParentID = so.FID and soe.FID = rp.FSourceEntryID \n");
        ksql.append("where 1=1 \n");
        ksql.append("and mo.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
        ksql.append("and so.FSaleOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)saleOrgUnitIds) + " \n");
        ksql.append("and mo.FBaseStatus not in (0, 1, 2) \n");
        ksql.append("and so.FBaseStatus not in (0, 1, 2) \n");
        temp = filter.getString("saleOrderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and so.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("saleOrderTo")))) {
            ksql.append(" and so.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberFrom")))) {
            ksql.append(" and pro.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("projectNumberTo")))) {
            ksql.append(" and pro.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberFrom")))) {
            ksql.append(" and tr.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("trackNumberTo")))) {
            ksql.append(" and tr.FNumber <= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderFrom")))) {
            ksql.append(" and mo.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and mo.FNumber <= '").append(temp).append("'");
        }
        ksql.append("; \n");
        ksql.append("update " + stempTableName + " \n");
        ksql.append("set FCostObjectID = ( \n");
        ksql.append("    select top 1 FID from T_BD_CostObject co \n");
        ksql.append("    where co.FCompanyID = '" + companyId + "' \n");
        ksql.append("    and co.FIsForbiden = 0 \n");
        ksql.append("    and ( \n");
        ksql.append("        co.FCalculateMode = 7 \n");
        ksql.append("        and co.FOrderID = " + stempTableName + ".FManuOrderID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode in (1, 3) \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 4 \n");
        ksql.append("        and co.FStdProductIDID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        and ( \n");
        ksql.append("            co.FBatchNumber = " + stempTableName + ".FLot \n");
        ksql.append("            or \n");
        ksql.append("            co.FBatchNumber is null and " + stempTableName + ".FLot is null \n");
        ksql.append("        ) \n");
        ksql.append("        or \n");
        ksql.append("        co.FCalculateMode = 3 \n");
        ksql.append("        and co.FID in ( \n");
        ksql.append("            select ");
        ksql.append("                coe.FParentID ");
        ksql.append("            from T_BD_CostObjectEntry coe ");
        ksql.append("            where coe.FParentID = co.FID \n");
        ksql.append("            and FRelatedID = " + stempTableName + ".FMaterialID \n");
        ksql.append("        ) \n");
        ksql.append("    ) \n");
        ksql.append(") \n");
        ksql.append("where FCostObjectID is null \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        String T_TMP_CostObjectRange = this.createCostObjectRangeTempTable();
        ksql.append("insert into " + T_TMP_CostObjectRange + " \n");
        ksql.append("( \n");
        ksql.append("     FSaleOrderID, \n");
        ksql.append("     FSaleOrderEntryID, \n");
        ksql.append("     FManuOrderID, \n");
        ksql.append("     FCostObjectID \n");
        ksql.append(") \n");
        ksql.append("select distinct \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID \n");
        ksql.append("from " + stempTableName + " \n");
        ksql.append("where FCostObjectID is not null \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FCostObjectID, \n");
        ksql.append("    be.FCostItemID FCostItemID, \n");
        ksql.append("    'qichu' FExpenseID, \n");
        ksql.append("    bem.FMaterialID FMatID, \n");
        ksql.append("    bem.FBatchNo FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    bem.FQty FQty, \n");
        ksql.append("    bem.FPrice FPrice, \n");
        ksql.append("    bem.FAmount FAmount, \n");
        ksql.append("    isnull(MUltMU.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(mat.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    1, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from T_NCM_InitBalance b \n");
        ksql.append("join T_NCM_InitBalanceEntry be \n");
        ksql.append("    on be.FParentID = b.FID \n");
        ksql.append("join T_NCM_CostItem ci \n");
        ksql.append("    on ci.FID = be.FCostItemID and FItemType = '1' \n");
        ksql.append("join T_NCM_InitBalanceMatDetail bem \n");
        ksql.append("    on bem.FParentID = be.FID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = b.FCostObjectID \n");
        ksql.append("join T_BD_Material mat on mat.FID = bem.FMaterialID \n");
        ksql.append("join T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID = mat.FBaseUnit and MUltMU.FMaterialID = mat.FID \n");
        ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("and b.FBillStatus = 4 \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    be.FCostItemID FCostItemID, \n");
        ksql.append("    'qichu' FExpenseID, \n");
        ksql.append("    null FMatID, \n");
        ksql.append("    null FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    0 FQty, \n");
        ksql.append("    0 FPrice, \n");
        ksql.append("    be.FBoPWIPAmount FAmount, \n");
        ksql.append("    isnull(unit.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(ci.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    2, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from T_NCM_InitBalance b \n");
        ksql.append("join T_NCM_InitBalanceEntry be \n");
        ksql.append("    on be.FParentID = b.FID \n");
        ksql.append("join T_NCM_CostItem ci \n");
        ksql.append("    on ci.FID = be.FCostItemID and FItemType = '2' \n");
        ksql.append("left join T_BD_MeasureUnit unit on unit.FID = ci.FUnitID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = b.FCostObjectID \n");
        ksql.append("where b.FCompanyOrg = '" + companyId + "' \n");
        ksql.append("and b.FBillStatus = 4 \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    r.FCostItemID FCostItemID, \n");
        ksql.append("    'ml7t5QEaEADgAAwawKgRe0olWCc=' FExpenseID, \n");
        ksql.append("    r.FMaterialID FMatID, \n");
        ksql.append("    r.FLot FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    r.FQty FQty, \n");
        ksql.append("    r.FPrice FPrice, \n");
        ksql.append("    r.FAmount FAmount, \n");
        ksql.append("    isnull(MUltMU.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(mat.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    1, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_MatAllocResult + " r \n");
        ksql.append("join T_IM_MaterialReqBill b \n");
        ksql.append("    on b.FID = r.FSourceBillID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = r.FCostObjectID \n");
        ksql.append("join T_BD_Material mat on mat.FID = r.FMaterialID \n");
        ksql.append("join T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID = mat.FBaseUnit and MUltMU.FMaterialID = mat.FID \n");
        ksql.append("where 1=1 \n");
        ksql.append("and AllocBillType = 'MF' \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    r.FCostItemID FCostItemID, \n");
        ksql.append("    'ml7t5QEaEADgAAwawKgRe0olWCc=' FExpenseID, \n");
        ksql.append("    r.FMaterialID FMatID, \n");
        ksql.append("    r.FLot FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    r.FQty FQty, \n");
        ksql.append("    r.FPrice FPrice, \n");
        ksql.append("    r.FAmount FAmount, \n");
        ksql.append("    isnull(MUltMU.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(mat.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    1, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_MatAllocResult + " r \n");
        ksql.append("join T_IM_OtherInWarehsBill b \n");
        ksql.append("    on b.FID = r.FSourceBillID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = r.FCostObjectID \n");
        ksql.append("join T_BD_Material mat on mat.FID = r.FMaterialID \n");
        ksql.append("join T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID = mat.FBaseUnit and MUltMU.FMaterialID = mat.FID \n");
        ksql.append("where 1=1 \n");
        ksql.append("and AllocBillType = 'OI' \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    r.FCostItemID FCostItemID, \n");
        ksql.append("    'ml7t5QEaEADgAAwawKgRe0olWCc=' FExpenseID, \n");
        ksql.append("    r.FMaterialID FMatID, \n");
        ksql.append("    r.FLot FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    r.FQty FQty, \n");
        ksql.append("    r.FPrice FPrice, \n");
        ksql.append("    r.FAmount FAmount, \n");
        ksql.append("    isnull(MUltMU.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(mat.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    1, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_MatAllocResult + " r \n");
        ksql.append("join T_CL_CostAdjustBill b \n");
        ksql.append("    on b.FID = r.FSourceBillID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = r.FCostObjectID \n");
        ksql.append("join T_BD_Material mat on mat.FID = r.FMaterialID \n");
        ksql.append("join T_BD_MultiMeasureUnit MUltMU ON MUltMU.FMeasureUnitID = mat.FBaseUnit and MUltMU.FMaterialID = mat.FID \n");
        ksql.append("where 1=1 \n");
        ksql.append("and AllocBillType = 'CA' \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    r.FCostItemID FCostItemID, \n");
        ksql.append("    be.FExpenseID FExpenseID, \n");
        ksql.append("    null FMatID, \n");
        ksql.append("    null FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    r.FQty FQty, \n");
        ksql.append("    r.FPrice FPrice, \n");
        ksql.append("    r.FAmount FAmount, \n");
        ksql.append("    isnull(unit.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(ci.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    2, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_OtherAllocResult + " r \n");
        ksql.append("join T_NCM_OtherFeeBill b \n");
        ksql.append("    on b.FID = r.FSourceBillID \n");
        ksql.append("join T_NCM_OtherFeeBillEntry be \n");
        ksql.append("    on b.FID = be.FParentID and be.FID = R.FSourceBillEntryID \n");
        ksql.append("    and r.FCostItemID = be.FCostItemID \n");
        ksql.append("join T_NCM_CostItem ci \n");
        ksql.append("    on ci.FID = r.FCostItemID \n");
        ksql.append("left join T_BD_MeasureUnit unit on unit.FID = ci.FUnitID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = r.FCostObjectID \n");
        ksql.append("where 1=1 \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FManuOrderID, \n");
        ksql.append("    FCostObjectID, \n");
        ksql.append("    FCostItemID, \n");
        ksql.append("    FExpenseID, \n");
        ksql.append("    FMatID, \n");
        ksql.append("    FMatBatch, \n");
        ksql.append("    FSourceBillID, \n");
        ksql.append("    FSourceBillNumber, \n");
        ksql.append("    FQty, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FMatCalculateTypeName, \n");
        ksql.append("    FDataType, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, \n");
        ksql.append("    cor.FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    cor.FManuOrderID FManuOrderID, \n");
        ksql.append("    cor.FCostObjectID FProdID, \n");
        ksql.append("    r.FCostItemID FCostItemID, \n");
        ksql.append("    r.FExpenseID FExpenseID, \n");
        ksql.append("    null FMatID, \n");
        ksql.append("    null FMatBatch, \n");
        ksql.append("    b.FID FSourceBillID, \n");
        ksql.append("    b.FNumber FSourceBillNumber, \n");
        ksql.append("    r.FTotalQty FQty, \n");
        ksql.append("    r.FPrice FPrice, \n");
        ksql.append("    r.FAmount FAmount, \n");
        ksql.append("    isnull(unit.FQtyPrecision,2) FQtyPrecision, \n");
        ksql.append("    isnull(ci.FPricePrecision,2) FPricePrecision, \n");
        ksql.append("    2 FAmountPrecision, \n");
        ksql.append("    '' FMatCalculateTypeName, \n");
        ksql.append("    2, \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_AuxAllocResult + " r \n");
        ksql.append("join T_NCM_InnerOverheadBill b \n");
        ksql.append("    on b.FID = r.FSourceBillID \n");
        ksql.append("join " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    on cor.FCostObjectID = r.FCostObjectID \n");
        ksql.append("join T_NCM_CostItem ci \n");
        ksql.append("    on ci.FID = r.FCostItemID \n");
        ksql.append("left join T_BD_MeasureUnit unit on unit.FID = ci.FUnitID \n");
        ksql.append("where 1=1 \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        if (this.isShowExcludeSemi(filter)) {
            ksql.append("delete from " + tempTable + " \n");
            ksql.append("where exists ( \n");
            ksql.append("    select 1 from T_BD_Material m \n");
            ksql.append("    join T_BD_MaterialCompanyInfo mc \n");
            ksql.append("    on mc.FMaterialID = m.FID and mc.FCompanyID = '" + companyId + "' \n");
            ksql.append("    and mc.FCalculateType = 2 \n");
            ksql.append("    where m.FID = " + tempTable + ".FMatID \n");
            ksql.append(") \n");
            ksql.append("; \n");
        }
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FProdID \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        m.FID \n");
        ksql.append("    from T_MM_ManufactureOrder mo \n");
        ksql.append("    join T_BD_Material m on m.FID = mo.FMaterialID \n");
        ksql.append("    where mo.FID = r.FManuOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        if (this.isShowExpenseDetail(filter)) {
            ksql.append("insert into " + tempTable + " \n");
            ksql.append("( \n");
            ksql.append("    FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID, \n");
            ksql.append("    FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID, \n");
            }
            ksql.append("    FCostItemID, \n");
            ksql.append("    FExpenseID, \n");
            ksql.append("    FAmount, \n");
            ksql.append("    FQtyPrecision, \n");
            ksql.append("    FPricePrecision, \n");
            ksql.append("    FIsExpenseTotalRow, \n");
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FSaleOrderID FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID FSaleOrderEntryID, \n");
            ksql.append("    FProdID FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID FManuOrderID, \n");
            }
            ksql.append("    FCostItemID FCostItemID, \n");
            ksql.append("    FExpenseID FExpenseID, \n");
            ksql.append("    sum(FAmount) FAmount, \n");
            ksql.append("    max(FQtyPrecision), \n");
            ksql.append("    max(FPricePrecision), \n");
            ksql.append("    -1 FIsExpenseTotalRow, \n");
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " r \n");
            ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
            ksql.append("group by FSaleOrderID, FSaleOrderEntryID, FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID, \n");
            }
            ksql.append("    FCostItemID, FExpenseID \n");
            ksql.append("; \n");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        if (this.isShowOnlyOrderSum(filter)) {
            ksql.append("insert into " + tempTable + " \n");
            ksql.append("( \n");
            ksql.append("    FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID, \n");
            ksql.append("    FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID, \n");
            }
            ksql.append("    FCostItemID, \n");
            if (this.isShowExpenseDetail(filter)) {
                ksql.append("FExpenseID, \n");
            }
            ksql.append("    FMatID, \n");
            ksql.append("    FQty, \n");
            ksql.append("    FAmount, \n");
            ksql.append("    FQtyPrecision, \n");
            ksql.append("    FPricePrecision, \n");
            ksql.append("    FIsMaterialTotalRow, \n");
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FSaleOrderID FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID FSaleOrderEntryID, \n");
            ksql.append("    FProdID FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID FManuOrderID, \n");
            }
            ksql.append("    FCostItemID FCostItemID, \n");
            if (this.isShowExpenseDetail(filter)) {
                ksql.append("FExpenseID, \n");
            }
            ksql.append("    FMatID FMatID, \n");
            ksql.append("    sum(FQty) FQty, \n");
            ksql.append("    sum(FAmount) FAmount, \n");
            ksql.append("    max(FQtyPrecision), \n");
            ksql.append("    max(FPricePrecision), \n");
            ksql.append("    -1 FIsMaterialTotalRow, \n");
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " r \n");
            ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 and FDataType = 1\n");
            ksql.append("group by FSaleOrderID, FSaleOrderEntryID, FProdID, \n");
            if (!this.isShowOnlyOrderSum(filter)) {
                ksql.append("    FManuOrderID, \n");
            }
            ksql.append("    FCostItemID, \n");
            if (this.isShowExpenseDetail(filter)) {
                ksql.append("FExpenseID, \n");
            }
            ksql.append("FMatID \n");
            ksql.append("; \n");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID, \n");
        ksql.append("    FProdID, \n");
        if (!this.isShowOnlyOrderSum(filter)) {
            ksql.append("    FManuOrderID, \n");
        }
        ksql.append("    FCostItemID, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FIsCostItemTotalRow, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    FSaleOrderID FSaleOrderID, \n");
        ksql.append("    FSaleOrderEntryID FSaleOrderEntryID, \n");
        ksql.append("    FProdID FProdID, \n");
        if (!this.isShowOnlyOrderSum(filter)) {
            ksql.append("    FManuOrderID FManuOrderID, \n");
        }
        ksql.append("    FCostItemID FCostItemID, \n");
        ksql.append("    sum(FAmount) FAmount, \n");
        ksql.append("    max(FQtyPrecision), \n");
        ksql.append("    max(FPricePrecision), \n");
        ksql.append("    -1 FIsCostItemTotalRow, \n");
        ksql.append("    1 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + tempTable + " r \n");
        ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
        ksql.append("group by FSaleOrderID, FSaleOrderEntryID, FProdID, \n");
        if (!this.isShowOnlyOrderSum(filter)) {
            ksql.append("    FManuOrderID, \n");
        }
        ksql.append("    FCostItemID \n");
        ksql.append("; \n");
        if (!this.isShowOnlyOrderSum(filter)) {
            ksql.append("insert into " + tempTable + " \n");
            ksql.append("( \n");
            ksql.append("    FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID, \n");
            ksql.append("    FProdID, \n");
            ksql.append("    FManuOrderID, \n");
            ksql.append("    FAmount, \n");
            ksql.append("    FQtyPrecision, \n");
            ksql.append("    FPricePrecision, \n");
            ksql.append("    FIsManuOrderTotalRow, \n");
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    FSaleOrderID FSaleOrderID, \n");
            ksql.append("    FSaleOrderEntryID FSaleOrderEntryID, \n");
            ksql.append("    FProdID FProdID, \n");
            ksql.append("    FManuOrderID FManuOrderID, \n");
            ksql.append("    sum(FAmount) FAmount, \n");
            ksql.append("    max(FQtyPrecision), \n");
            ksql.append("    max(FPricePrecision), \n");
            ksql.append("    1 FIsManuOrderTotalRow, \n");
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " r \n");
            ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
            ksql.append("group by FSaleOrderID, FSaleOrderEntryID, FProdID, FManuOrderID \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderID, \n");
        ksql.append("\t FSaleOrderQty, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FIsSaleOrderTotalRow, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    FSaleOrderID FSaleOrderID, \n");
        ksql.append("\t sum(FSaleOrderQty) FSaleOrderQty, \n");
        ksql.append("    sum(FAmount) FAmount, \n");
        ksql.append("    max(FQtyPrecision), \n");
        ksql.append("    max(FPricePrecision), \n");
        ksql.append("    1 FIsSaleOrderTotalRow, \n");
        ksql.append("    1 FIsSubTotalRow, \n");
        ksql.append("    0 FIsTotalRow \n");
        ksql.append("from " + tempTable + " r \n");
        ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
        ksql.append("group by FSaleOrderID \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " \n");
        ksql.append("( \n");
        ksql.append("    FSaleOrderNumber, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FIsSubTotalRow, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    '" + this.getResource("sum") + "' FSaleOrderNumber, \n");
        ksql.append("    isnull(sum(FAmount), 0) FAmount, \n");
        ksql.append("    isnull(max(FQtyPrecision),2), \n");
        ksql.append("    isnull(max(FPricePrecision),2), \n");
        ksql.append("    0 FIsSubTotalRow, \n");
        ksql.append("    1 FIsTotalRow \n");
        ksql.append("from " + tempTable + " r \n");
        ksql.append("where FIsSubTotalRow = 0 and FIsTotalRow = 0 \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FSaleOrderNumber \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        so.FNumber \n");
        ksql.append("    from T_SD_SaleOrder so \n");
        ksql.append("    where so.FID = r.FSaleOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FSaleOrderQty, FSaleOrderUnitName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        soe.FQty,mu.FName_" + loc + " \n");
        ksql.append("    from T_SD_SaleOrder so \n");
        ksql.append("\t left join t_SD_SaleOrderEntry soe on soe.FParentID = so.FID \n");
        ksql.append("\t left join T_BD_MeasureUnit mu on mu.FID = soe.FUnitID ");
        ksql.append("    where so.FID = r.FSaleOrderID \n");
        ksql.append("\t     and soe.FID = r.FSaleOrderEntryID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        String temp1 = this.createTempTable1();
        ksql.append(" insert into " + temp1 + " \n");
        ksql.append(" (FSaleOrderID,FQty) \n");
        ksql.append(" select \n");
        ksql.append("    cor.FSaleOrderID FSaleOrderID, sum(soe.FQty) FQty \n");
        ksql.append("    from ( \n");
        ksql.append("        select distinct FSaleOrderID, FSaleOrderEntryID from " + T_TMP_CostObjectRange + " \n");
        ksql.append("    ) cor \n");
        ksql.append("    join T_SD_SaleOrder so on so.FID = cor.FSaleOrderID \n");
        ksql.append("\t join T_SD_SaleOrderEntry soe on soe.FParentID = so.FID and soe.FID = cor.FSaleOrderEntryID \n");
        ksql.append(" group by cor.FSaleOrderID \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FSaleOrderQty \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        cor.FQty FSaleOrderQty \n");
        ksql.append("    from " + temp1 + " cor \n");
        ksql.append("    where cor.FSaleOrderID = r.FSaleOrderID \n");
        ksql.append(") \n");
        ksql.append("where FIsSaleOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FManuOrderNumber, \n");
        ksql.append("    FManuOrderStatus, \n");
        ksql.append("\t FToStroreQty \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        mo.FNumber FManuOrderNumber, \n");
        ksql.append("        case \n");
        ksql.append("            when mo.FBaseStatus = 4 then '" + BillBaseStatusEnum.AUDITED + "' \n");
        ksql.append("            when mo.FBaseStatus = 5 then '" + BillBaseStatusEnum.RELEASED + "' \n");
        ksql.append("            when mo.FBaseStatus = 7 then '" + BillBaseStatusEnum.CLOSED + "' \n");
        ksql.append("            when mo.FBaseStatus = 8 then '" + BillBaseStatusEnum.COMPLETE + "' \n");
        ksql.append("            when mo.FBaseStatus = 90 then '" + BillBaseStatusEnum.FINISH + "' \n");
        ksql.append("            when mo.FBaseStatus = 10 then '" + BillBaseStatusEnum.PUBLISHED + "' \n");
        ksql.append("            when mo.FBaseStatus = 11 then '" + BillBaseStatusEnum.FINCLOSED + "' \n");
        ksql.append("            else '' \n");
        ksql.append("        end FManuOrderStatus, \n");
        ksql.append("\t  \t\t mo.FToStroreQty FToStroreQty \n");
        ksql.append("    from T_MM_ManufactureOrder mo \n");
        ksql.append("    join T_BD_Material m on m.FID = mo.FMaterialID \n");
        ksql.append("    where mo.FID = r.FManuOrderID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        String temp2 = this.createTempTable2();
        ksql.append(" insert into " + temp2 + " \n");
        ksql.append(" (FSaleOrderID,FToStroreQty) \n");
        ksql.append("    select \n");
        ksql.append("\t     cor.FSaleOrderID FSaleOrderID,sum(mo.FToStroreQty) FToStroreQty \n");
        ksql.append("    from " + T_TMP_CostObjectRange + " cor \n");
        ksql.append("    join T_MM_ManufactureOrder mo on mo.FID = cor.FManuOrderID \n");
        ksql.append("    and exists (select 1 from " + tempTable + " t where t.FManuOrderID = cor.FManuOrderID) \n");
        ksql.append("    group by cor.FSaleOrderID \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FToStroreQty \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("\t      cor.FToStroreQty FToStroreQty \n");
        ksql.append("    from " + temp2 + " cor \n");
        ksql.append("    join T_MM_ManufactureOrder mo on mo.FID = cor.FManuOrderID \n");
        ksql.append("    where cor.FSaleOrderID = r.FSaleOrderID \n");
        ksql.append(") \n");
        ksql.append("where FIsSaleOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set FPrice = ( \n");
        ksql.append("    case when FToStroreQty = 0 then 0 else FAmount/FToStroreQty end \n");
        ksql.append(") \n");
        ksql.append("where FIsManuOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("\n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FPrice = ( \n");
        ksql.append("    case when FSaleOrderQty = 0 then 0 else FAmount/FSaleOrderQty end \n");
        ksql.append(") \n");
        ksql.append("where FIsSaleOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("\n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FProdNumber, \n");
        ksql.append("    FProdName, \n");
        ksql.append("    FProdModel \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        m.FNumber, \n");
        ksql.append("        m.FName_" + loc + ", \n");
        ksql.append("        m.FModel \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    where m.FID = r.FProdID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append(" set ( \n");
        ksql.append(" FTrackNumber, FProjectNumber \n");
        ksql.append(" ) = ( \n");
        ksql.append(" select \n");
        ksql.append(" tr.FNumber, pro.FNumber \n");
        ksql.append(" from t_mm_manufactureOrder mo \n");
        ksql.append(" left join t_mm_trackNumber tr on tr.FID = mo.FTrackID \n");
        ksql.append(" left join t_mm_project pro on pro.FID = mo.FProjectID \n");
        ksql.append(" where mo.FID = r.FManuOrderID");
        ksql.append(" ); \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FCostItemNumber, \n");
        ksql.append("    FCostItemName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        ci.FNumber, \n");
        ksql.append("        ci.FName_" + loc + " \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = r.FCostItemID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FExpenseNumber, \n");
        ksql.append("    FExpenseName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        ci.FNumber, \n");
        ksql.append("        ci.FName_" + loc + " \n");
        ksql.append("    from T_NCM_Expense ci \n");
        ksql.append("    where ci.FID = r.FExpenseID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set FExpenseNumber = 'begin', FExpenseName = '" + this.getResource("begin") + "' \n");
        ksql.append("where FExpenseID = 'qichu' \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " r \n");
        ksql.append("set (\n");
        ksql.append("    FMatNumber, \n");
        ksql.append("    FMatName, \n");
        ksql.append("    FMatModel, \n");
        ksql.append("    FMatUnitName, \n");
        ksql.append("    FMatCalculateType, \n");
        ksql.append("    FMatCalculateTypeName \n");
        ksql.append(") = ( \n");
        ksql.append("    select \n");
        ksql.append("        m.FNumber, \n");
        ksql.append("        m.FName_" + loc + ", \n");
        ksql.append("        m.FModel, \n");
        ksql.append("        mu.FName_" + loc + ", \n");
        ksql.append("        mc.FCalculateType, \n");
        ksql.append("        case \n");
        ksql.append("            when mc.FCalculateType = 0 then '" + CalculateTypeEnum.PURCHASE + "' \n");
        ksql.append("            when mc.FCalculateType = 1 then '" + CalculateTypeEnum.CONSIGN + "' \n");
        ksql.append("            when mc.FCalculateType = 2 then '" + CalculateTypeEnum.SELFMANUFACTURE + "' \n");
        ksql.append("            else '' \n");
        ksql.append("        end FMatCalculateTypeName \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    left join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        ksql.append("    left join T_BD_MaterialCompanyInfo mc on mc.FMaterialID = m.FID and mc.FCompanyID = '" + companyId + "' \n");
        ksql.append("    where m.FID = r.FMatID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FMatName = FMatName || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsMaterialTotalRow = -1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FExpenseName = FExpenseName || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsExpenseTotalRow = -1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FCostItemName = FCostItemName || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsCostItemTotalRow = -1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FManuOrderNumber = FManuOrderNumber || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsManuOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " \n");
        ksql.append("set FSaleOrderNumber = FSaleOrderNumber || ' " + this.getResource("subSum") + "' \n");
        ksql.append("where FIsSaleOrderTotalRow = 1 \n");
        ksql.append("; \n");
        ksql.append("UPDATE " + tempTable + " \n");
        ksql.append(" SET FAmountPrecision=( \n");
        ksql.append("\t  SELECT CY.FPrecision As FAmountPrecision \n");
        ksql.append("\t    FROM T_BD_Currency CY \n");
        ksql.append("\t   INNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID \n");
        ksql.append("\t  WHERE CP.FID='").append(companyId).append("') \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(stempTableName);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(T_TMP_CostObjectRange);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(temp1);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(temp2);
        return tempTable;
    }

    public boolean isOnlyDisplayTotal(RptParams filter) {
        return filter.getBoolean("isOnlyDisPalyTotal");
    }

    public boolean isTotalRowTop(RptParams filter) {
        return filter.getBoolean("isTotalRowTop");
    }

    private String buildSaleOrderFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("saleOrderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and o.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("saleOrderTo")))) {
            ksql.append(" and o.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        }
        titles.AddTitle(0, ResourceBase.getString((String)RES_CLASSNAME, (String)"company", (Locale)ctx.getLocale()) + company.getName());
        titles.AddTitle(2, ResourceBase.getString((String)RES_CLASSNAME, (String)"saleOrderNumber", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("saleOrderFrom"), filter.getString("saleOrderTo")));
        titles.AddTitle(3, ResourceBase.getString((String)RES_CLASSNAME, (String)"projectNumber", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("projectNumberFrom"), filter.getString("projectNumberTo")));
        titles.AddTitle(5, ResourceBase.getString((String)RES_CLASSNAME, (String)"trackNumber", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("trackNumberFrom"), filter.getString("trackNumberTo")));
        titles.AddTitle(6, ResourceBase.getString((String)RES_CLASSNAME, (String)"orderNumber", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("orderFrom"), filter.getString("orderTo")));
        return titles;
    }

    private String buildFilterRange(String from, String to) {
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"all", (Locale)this.getContext().getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"fromFirstTo", (Locale)this.getContext().getLocale()) + " " + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)RES_CLASSNAME, (String)"from", (Locale)this.getContext().getLocale()) + " " + from + " " + ResourceBase.getString((String)RES_CLASSNAME, (String)"toLast", (Locale)this.getContext().getLocale());
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)"from", (Locale)this.getContext().getLocale()) + " " + from + " " + ResourceBase.getString((String)RES_CLASSNAME, (String)"to", (Locale)this.getContext().getLocale()) + " " + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        int amountPrecision = 2;
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
            amountPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        ReportHeader reportHeader = new ReportHeader();
        int index = 0;
        reportHeader.addChild("FSaleOrderNumber", this.getResource("FSaleOrderNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProdNumber", this.getResource("FProdNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProdName", this.getResource("FProdName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProdModel", this.getResource("FProdModel"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FSaleOrderUnitName", this.getResource("FSaleOrderUnitName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FSaleOrderQty", this.getResource("FSaleOrderQty"), index++).setAlign(3).setType(2).setMergeable(true);
        if (!this.isShowOnlyOrderSum(filter)) {
            reportHeader.addChild("FManuOrderNumber", this.getResource("FManuOrderNumber"), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FProjectNumber", this.getResource("FProjectNumber"), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FTrackNumber", this.getResource("FTrackNumber"), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FManuOrderStatus", this.getResource("FManuOrderStatus"), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FToStroreQty", this.getResource("FToStroreQty"), index++).setAlign(3).setType(2).setMergeable(true);
        }
        reportHeader.addChild("FCostItemNumber", this.getResource("FCostItemNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FCostItemName", this.getResource("FCostItemName"), index++).setAlign(1).setMergeable(true);
        if (this.isShowExpenseDetail(filter)) {
            reportHeader.addChild("FExpenseNumber", this.getResource("FExpenseNumber"), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FExpenseName", this.getResource("FExpenseName"), index++).setAlign(1).setMergeable(true);
        }
        reportHeader.addChild("FMatNumber", this.getResource("FMatNumber"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FMatName", this.getResource("FMatName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FMatModel", this.getResource("FMatModel"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FMatUnitName", this.getResource("FMatUnitName"), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FMatBatch", this.getResource("FMatBatch"), index++).setAlign(1).setMergeable(true);
        if (this.isShowMatDetail(filter)) {
            reportHeader.addChild("FSourceBillNumber", this.getResource("FSourceBillNumber"), index++).setAlign(1).setMergeable(true);
        }
        reportHeader.addChild("FQty", this.getResource("FQty"), index++).setAlign(3).setType(2).setDecimalField("FQtyPrecision");
        reportHeader.addChild("FPrice", this.getResource("FPrice"), index++).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        reportHeader.addChild("FAmount", this.getResource("FAmount"), index++).setAlign(3).setType(2).setDecimal(amountPrecision);
        reportHeader.addChild("FMatCalculateTypeName", this.getResource("FMatCalculateTypeName"), index++).setAlign(1).setMergeable(true);
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

