/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WIPCountingAllocReport
extends ReportServerBase {
    private static final char CLF = '\n';
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.WIPCountingAllocReport");

    protected IRowSet getReportData(String reportID, RptParams filter) throws BaseException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        this.setTablename(this.buildVirtualReportDataTbl(filter));
        return super.getTablename();
    }

    private String buildVirtualReportDataTbl(RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        String tempTableName = this.createVirtualReportDataTbl(ctx);
        StringBuffer sb = new StringBuffer();
        this.fillVirtualReportDataTbl(sb, ctx, tempTableName, filter);
        this.sumVirtualReportDataTbl(sb, ctx, tempTableName);
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString());
        return tempTableName;
    }

    private String createVirtualReportDataTbl(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table t_tempVirtualReportDataTbl ( ").append("FPeriodNumber VARCHAR(80), ").append("FCostCenterNumber VARCHAR(80), FCostCenterName nvarchar(255), ").append("FMaterialNumber VARCHAR(80), FMaterialName nvarchar(255), ").append("FMaterialModel nvarchar(255), FMaterialShortName nvarchar(80), FLot nvarchar(80), ").append("FCostObjectNumber VARCHAR(80), FCostObjectName nvarchar(255), ").append("FMainPrdModel nvarchar(255), FMainPrdShortName nvarchar(255), FBatchNumber nvarchar(256), ").append("FOrderNumber varchar(80), ").append("FProjectNumber varchar(80), ").append("FTrackNumber varchar(80), ").append("FProductNumber varchar(80), ").append("FProductName varchar(80), ").append("FCostItemNumber VARCHAR(80), FCostItemName nvarchar(255), ").append("FCommonUnitName nvarchar(255), FCommonQty decimal(21,8), FCommonQtyPrec int not null default(4), ").append("FBaseUnitName nvarchar(255), FBaseQty decimal(21,8), FBaseQtyPrec int not null default(4), ").append("FAssistUnitName nvarchar(255), FAssistQty decimal(21,8), FAssistQtyPrec int not null default(4), ").append("FPrice decimal(21,8), FPricePrec int not null default(4), ").append("FAmount decimal(21,8), FAmountPrec int not null default(4), ").append("FAllocCoefficient decimal(21,8), ").append("FTotalRow decimal(21,8) not null default(0), FTotalRow2 decimal(21,8) not null default(0)").append(")");
        return NCMServerUtils.createTempTable((Context)ctx, (String)sb.toString(), null);
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private void fillVirtualReportDataTbl(StringBuffer sb, Context ctx, String tempTableName, RptParams filter) throws BOSException {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyId = companyOrg.getId().toString();
        String sourceTbl = this.getSourceTbl(ctx, companyId, filter);
        String L2 = ctx.getLocale().getDisplayName();
        int aomountPrecision = this.getAomountPrecision(ctx, companyOrg);
        sb.append("INSERT INTO " + tempTableName).append('\n').append("(FPeriodNumber, FCostCenterNumber, FCostCenterName, ").append('\n').append(" FMaterialNumber, FMaterialName, FMaterialModel, FMaterialShortName, FLot, ").append('\n').append(" FCostObjectNumber, FCostObjectName, ").append('\n').append(" FOrderNumber, FProjectNumber, FTrackNumber, FProductNumber, FProductName, ").append('\n').append(" FMainPrdModel, FMainPrdShortName, FBatchNumber, ").append('\n').append(" FCostItemNumber, FCostItemName, ").append('\n').append(" FBaseUnitName, FBaseQty, FBaseQtyPrec, ").append('\n').append(" FAssistUnitName,FAssistQty, FAssistQtyPrec, ").append('\n').append(" FPrice, FPricePrec, FAmount, ").append('\n').append(" FAmountPrec, FAllocCoefficient )").append('\n').append("SELECT ").append('\n').append("    TO_CHAR(p.FNumber), cc.FNumber, cc.FName_" + L2 + ", ").append('\n').append("       mat.FNumber, mat.FName_" + L2 + ", mat.FModel, mat.FShortName, s.FLot, ").append('\n').append("       co.FNumber, co.FName_" + L2 + ", ").append('\n').append("       od.FNumber, project.FNumber, track.FNumber, mainPrd.FNumber, mainPrd.FName_" + L2 + ", ").append('\n').append("       mainPrd.FModel, mainPrd.FShortName, co.FbatchNumber, ").append('\n').append("       ci.FNumber, ci.FName_" + L2 + ", ").append('\n').append("       baseUnit.FName_" + L2 + ", s.FBaseQty, ISNULL(mmu1.FqtyPrecision,4), ").append('\n').append("       assistUnit.FName_" + L2 + ", s.FAssistQty, ISNULL(mmu2.FqtyPrecision,4), ").append('\n').append("       s.FBasePrice, ISNULL(mainPrd.FPricePrecision, 2), s.FAllocAmount, ").append("       ").append(aomountPrecision).append(" as FAmountPrec, s.FAllocCoefficient ").append('\n').append("  from " + sourceTbl + " s ").append('\n').append(" inner join t_bd_Period p on s.FCalculatePeriodID = p.FID ").append('\n').append(" inner join T_ORG_CostCenter cc on s.FCostCenterID = cc.FID ").append('\n').append(" inner join T_BD_material mat on s.FMaterialID = mat.FID ").append('\n').append(" inner join T_BD_CostObject co on s.FCostObjectID = co.FID ").append('\n').append(" left join T_MM_ManufactureOrder od on co.FOrderID = od.FID ").append('\n').append(" left join T_MM_Project project on project.FID = co.FProjectID ").append('\n').append(" left join T_MM_TrackNumber track on track.FID = co.FTrackID ").append('\n').append("  left outer join T_BD_MaterialCompanyInfo mcoinfo ").append('\n').append("    on mcoinfo.FMaterialID=co.FStdProductIDID and s.FCompanyID=mcoinfo.FCompanyID ").append('\n').append("  left outer join T_BD_Material mainPrd ON mainPrd.FID=mcoinfo.FMaterialID ").append('\n').append(" inner join T_Ncm_Costitem ci on s.FCostItemID = ci.FID ").append('\n').append(" left outer join t_bd_MeasureUnit baseUnit on mat.FBaseUnit = baseUnit.FID ").append('\n').append(" left outer join t_bd_MeasureUnit assistUnit on mat.FAssistUnit = assistUnit.FID ").append('\n').append(" left outer join t_bd_multiMeasureUnit mmu1 ").append('\n').append("   on s.FMaterialID=mmu1.FMaterialID and baseUnit.fid=mmu1.FMeasureUnitID ").append('\n').append(" left outer join t_bd_multiMeasureUnit mmu2 ").append('\n').append("   on s.FMaterialID=mmu2.FMaterialID and assistUnit.fid=mmu2.FMeasureUnitID ").append('\n').append("where s.FCompanyID = '" + companyId + "' ").append('\n');
        this.buildFilter(filter, sb);
    }

    private int getAomountPrecision(Context ctx, CompanyOrgUnitInfo companyOrg) throws BOSException {
        CurrencyInfo currency;
        try {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrg.getBaseCurrency().getId()));
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        int curPrecision = currency == null ? 4 : currency.getPrecision();
        return curPrecision;
    }

    private String getSourceTbl(Context ctx, String companyId, RptParams filter) throws BOSException {
        int fromPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        int toPeriod = Integer.parseInt(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        String tableName = null;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_WIPCountingAllocResult", (int)fromPeriod, (int)toPeriod);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append("  and p.FNumber >=");
        sb.append(this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
        sb.append(" and p.FNumber <=");
        sb.append(this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        sb.append('\n');
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append("  and cc.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append("  and cc.FNumber <='").append(filter.getString("costcenterTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("itemFrom") != null && !"".equals(filter.getString("itemFrom"))) {
            sb.append("  and mat.FNumber >='").append(filter.getString("itemFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("itemTo") != null && !"".equals(filter.getString("itemTo"))) {
            sb.append("  and mat.FNumber <='").append(filter.getString("itemTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append("  and co.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append("  and co.FNumber <='").append(filter.getString("costobjectTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append("  and ci.FNumber >='").append(filter.getString("costitemFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append("  and ci.FNumber <='").append(filter.getString("costitemTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("orderFrom") != null && !"".equals(filter.getString("orderFrom"))) {
            sb.append("  and od.FNumber >='").append(filter.getString("orderFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("orderTo") != null && !"".equals(filter.getString("orderTo"))) {
            sb.append("  and od.FNumber <='").append(filter.getString("orderTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("projectFrom") != null && !"".equals(filter.getString("projectFrom"))) {
            sb.append(" and project.FNumber >='").append(filter.getString("projectFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("projectTo") != null && !"".equals(filter.getString("projectTo"))) {
            sb.append(" and project.FNumber <='").append(filter.getString("projectTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("trackFrom") != null && !"".equals(filter.getString("trackFrom"))) {
            sb.append(" and track.FNumber >='").append(filter.getString("trackFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("trackTo") != null && !"".equals(filter.getString("trackTo"))) {
            sb.append(" and track.FNumber <='").append(filter.getString("trackTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("batchFrom") != null && !"".equals(filter.getString("batchFrom"))) {
            sb.append(" and co.FBatchNumber >='").append(filter.getString("batchFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("batchTo") != null && !"".equals(filter.getString("batchTo"))) {
            sb.append(" and co.FBatchNumber <='").append(filter.getString("batchTo")).append("'");
            sb.append('\n');
        }
        if (filter.getString("productFrom") != null && !"".equals(filter.getString("productFrom"))) {
            sb.append(" and mainPrd.FNumber >='").append(filter.getString("productFrom")).append("'");
            sb.append('\n');
        }
        if (filter.getString("productTo") != null && !"".equals(filter.getString("productTo"))) {
            sb.append(" and mainPrd.FNumber <='").append(filter.getString("productTo")).append("'");
            sb.append('\n');
        }
        sb.append(";").append('\n');
    }

    private void sumVirtualReportDataTbl(StringBuffer sql, Context ctx, String tempTableName) {
        ArrayList totalList = new ArrayList();
        HashMap<String, String> costObjectMap = new HashMap<String, String>();
        costObjectMap.put("totalRow", "1");
        costObjectMap.put("groupByFeilds", "FPeriodNumber, FCostCenterNumber, FCostCenterName, FMaterialNumber, FMaterialName, FCostObjectNumber");
        costObjectMap.put("lessSumFeild", "FCostObjectNumber");
        costObjectMap.put("lessSumSign", "FCostObjectName");
        totalList.add(costObjectMap);
        HashMap<String, String> materialMap = new HashMap<String, String>();
        materialMap.put("totalRow", "2");
        materialMap.put("groupByFeilds", "FPeriodNumber, FCostCenterNumber, FCostCenterName, FMaterialNumber");
        materialMap.put("lessSumFeild", "FMaterialNumber");
        materialMap.put("lessSumSign", "FMaterialName");
        totalList.add(materialMap);
        HashMap<String, String> costCenterMap = new HashMap<String, String>();
        costCenterMap.put("totalRow", "3");
        costCenterMap.put("groupByFeilds", "FPeriodNumber, FCostCenterNumber");
        costCenterMap.put("lessSumFeild", "FCostCenterNumber");
        costCenterMap.put("lessSumSign", "FCostCenterName");
        totalList.add(costCenterMap);
        HashMap<String, String> periodMap = new HashMap<String, String>();
        periodMap.put("totalRow", "4");
        periodMap.put("groupByFeilds", "FPeriodNumber");
        periodMap.put("lessSumFeild", "FPeriodNumber");
        periodMap.put("lessSumSign", "FCostCenterNumber");
        totalList.add(periodMap);
        for (int i = 0; i < totalList.size(); ++i) {
            HashMap map = (HashMap)totalList.get(i);
            String totalRowNum = map.get("totalRow").toString();
            String groupByFeilds = (String)map.get("groupByFeilds");
            String lessSumFeild = (String)map.get("lessSumFeild");
            String lessSumSign = (String)map.get("lessSumSign");
            sql.append("INSERT INTO ").append(tempTableName).append('\n');
            sql.append("(FTotalRow,").append(groupByFeilds).append(", ").append('\n').append(" FCommonQty, FCommonQtyPrec, ").append('\n').append(" FBaseQty, FBaseQtyPrec, ").append('\n').append(" FAssistQty, FAssistQtyPrec, ").append('\n').append(" FPrice, FPricePrec, ").append('\n').append(" FAmount, FAmountPrec )").append('\n').append("SELECT ").append(totalRowNum).append(", ").append(groupByFeilds).append(",").append('\n').append("       Sum(FCommonQty) as FCommonQty, isnull(max(FCommonQtyPrec), 4) as FCommonQtyPrec, ").append('\n').append("       Sum(FBaseQty) as FBaseQty, isnull(max(FBaseQtyPrec), 4) as FBaseQtyPrec, ").append('\n').append("       Sum(FAssistQty) as FAssistQty, isnull(max(FAssistQtyPrec), 4) as FAssistQtyPrec, ").append('\n').append("       (CASE WHEN Sum(FBaseQty)<>0 THEN to_decimal(Sum(FAmount),24,12)/to_decimal(Sum(FBaseQty),24,12) ELSE 0 END) as FPrice, ").append("       isnull(max(FPricePrec), 4) as FPricePrec, ").append('\n').append("       Sum(FAmount) as FAmount, isnull(max(FAmountPrec), 4) as FAmountPrec ").append('\n').append(" FROM ").append(tempTableName).append('\n').append(" WHERE FTotalRow = 0 ").append('\n').append(" group by ").append(groupByFeilds).append('\n').append(";").append('\n');
            sql.append("update ").append(tempTableName).append('\n').append("   set ").append(lessSumFeild).append("= CONCAT(").append(lessSumFeild).append(", ' '), ").append('\n').append("       ").append(lessSumSign).append("='\u5c0f\u8ba1'").append('\n').append(" WHERE FTotalRow=").append(totalRowNum).append('\n').append(";").append('\n');
        }
        sql.append("INSERT INTO ").append(tempTableName).append('\n').append("(FPeriodNumber, FTotalRow2, FTotalRow, ").append('\n').append(" FCommonQty, FCommonQtyPrec, ").append('\n').append(" FBaseQty, FBaseQtyPrec, ").append('\n').append(" FAssistQty, FAssistQtyPrec, ").append('\n').append(" FPrice, FPricePrec, ").append('\n').append(" FAmount, FAmountPrec )").append("SELECT '\u5408\u8ba1', 1 as FTotalRow2, 5 as FTotalRow, ").append('\n').append("       Sum(FCommonQty) as FCommonQty, isnull(max(FCommonQtyPrec), 4) as FCommonQtyPrec, ").append('\n').append("       Sum(FBaseQty) as FBaseQty, isnull(max(FBaseQtyPrec), 4) as FBaseQtyPrec, ").append('\n').append("       Sum(FAssistQty) as FAssistQty, isnull(max(FAssistQtyPrec), 4) as FAssistQtyPrec, ").append('\n').append("       (CASE WHEN Sum(FBaseQty)<>0 THEN to_decimal(Sum(FAmount),24,12)/to_decimal(Sum(FBaseQty),24,12) ELSE 0 END) as FPrice, ").append("       isnull(max(FPricePrec), 4) as FPricePrec, ").append('\n').append("       Sum(FAmount) as FAmount, isnull(max(FAmountPrec), 4) as FAmountPrec ").append('\n').append(" FROM ").append(tempTableName).append('\n').append(" WHERE FTotalRow = 0 ").append('\n');
        sql.append(";").append('\n');
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String sql = "SELECT * FROM " + tableName + " Order by FTotalRow2, FPeriodNumber, FCostCenterNumber, FMaterialNumber, FLot, FCostObjectNumber, FCostItemNumber, FTotalRow";
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
    }

    protected ReportTitles getReportTitles(String arg0, RptParams filter) throws BaseException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"1_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"102_MAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"25_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"221_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"222_AuxFeeAllocResultReport", (Locale)ctx.getLocale()));
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"45_CCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"103_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("itemFrom"), filter.getString("itemTo")));
        titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"104_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costobjectFrom"), filter.getString("costobjectTo")));
        titles.AddTitle(5, "\u751f\u4ea7\u8ba2\u5355\u8303\u56f4" + CReportViewHandle.HandleTitleString(ctx, filter.getString("orderFrom"), filter.getString("orderTo")));
        titles.AddTitle(6, "\u9879\u76ee\u53f7\u8303\u56f4" + CReportViewHandle.HandleTitleString(ctx, filter.getString("projectFrom"), filter.getString("projectTo")));
        titles.AddTitle(7, "\u8ddf\u8e2a\u53f7\u8303\u56f4" + CReportViewHandle.HandleTitleString(ctx, filter.getString("trackFrom"), filter.getString("trackTo")));
        titles.AddTitle(8, "\u4ea7\u54c1\u8303\u56f4" + CReportViewHandle.HandleTitleString(ctx, filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(9, "\u6279\u6b21\u8303\u56f4" + CReportViewHandle.HandleTitleString(ctx, filter.getString("batchFrom"), filter.getString("batchTo")));
        titles.AddTitle(10, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"105_MAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString(ctx, filter.getString("costitemFrom"), filter.getString("costitemTo")));
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(1), (Object)new BigDecimal(4), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(5), a);
        return conditions;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader header = super.getReportHeader(reportID, filter);
        Context ctx = this.getContext();
        ArrayList childList = header.getChilds();
        ReportHeader childHeader = null;
        String fieldName = null;
        for (i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (!fieldName.equals("FCostObjectName")) continue;
            int index = i + 1;
            header.addChild("FOrderNumber", "\u751f\u4ea7\u8ba2\u5355", index++);
            header.addChild("FProjectNumber", "\u9879\u76ee\u53f7", index++).setAlign(1).setMergeable(true);
            header.addChild("FTrackNumber", "\u8ddf\u8e2a\u53f7", index++).setAlign(1).setMergeable(true);
            header.addChild("FProductNumber", "\u4ea7\u54c1\u7f16\u7801", index++).setAlign(1).setMergeable(true);
            header.addChild("FProductName", "\u4ea7\u54c1\u540d\u79f0", index++).setAlign(1).setMergeable(true);
            break;
        }
        childList = header.getChilds();
        for (i = 0; i < childList.size(); ++i) {
            childHeader = (ReportHeader)childList.get(i);
            fieldName = childHeader.getFieldName();
            if (fieldName.equals("FMainPrdModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"63_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMainPrdShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPeriodNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMaterialModel")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialModel", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostCenterName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBaseUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"217_FBaseUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostObjectName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMaterialShortName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialShortName_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBatchNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"BatchNumber", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAssistUnitName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"219_FAssistUnit", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FLot")) {
                childHeader.setCaption("\u6750\u6599\u6279\u6b21");
                continue;
            }
            if (fieldName.equals("FCostItemNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FCostItemName")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FBaseQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_FQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FPrice")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAmount")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAssistQty")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_FAssistQty", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FAllocCoefficient")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"AllocStdData", (Locale)ctx.getLocale()));
                continue;
            }
            if (fieldName.equals("FMaterialNumber")) {
                childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialNumber_2", (Locale)ctx.getLocale()));
                continue;
            }
            if (!fieldName.equals("FMaterialName")) continue;
            childHeader.setCaption(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"MaterialName_2", (Locale)ctx.getLocale()));
        }
        return header;
    }
}

