/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.app.AbstractCompareAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.app.StructureAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.util.app.BIRptCommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CompareAnalyseFacadeControllerBean
extends AbstractCompareAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 6927685395954317557L;
    private static Logger logger = Logger.getLogger((String)CompareAnalyseFacadeControllerBean.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource schemaSource = super.readySchemaSource(params, ctx);
        schemaSource.setCaller(StructureAnalyseFacadeControllerBean.class);
        schemaSource.setFilename("CostCompareAnalyse.xml");
        String companyId = ((CompanyOrgUnitInfo)params.getObjectElement("prmtCompany.value")).getId().toString();
        String costCenterIds = BIRptCommonUtil.buildSqlIds(ctx, params, "prmtCostCenter.value");
        if (costCenterIds == null) {
            costCenterIds = BIRptCommonUtil.buildDefaultCostCenterIds(ctx, companyId);
        }
        Set coIds = BIRptCommonUtil.getCostObjectIds(ctx, companyId, params);
        String costItemIds = BIRptCommonUtil.buildSqlIds(ctx, params, "prmtCostItem.value");
        if (costItemIds == null) {
            costItemIds = BIRptCommonUtil.buildDefaultCostItemIds(ctx, companyId);
        }
        String basePeriodIds = BIRptCommonUtil.buildPeriodIds(ctx, params, "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "BASE_PERIODS_KEY");
        String comparePeriodIds = BIRptCommonUtil.buildPeriodIds(ctx, params, "spinnerYearFrom2.value", "spinnerMonthFrom2.value", "spinnerYearTo2.value", "spinnerMonthTo2.value", "COMPARE_PERIODS_KEY");
        CostTypeEnum baseCostType = (CostTypeEnum)((Object)params.getObjectElement("combCostType.value"));
        CostTypeEnum compareCostType = (CostTypeEnum)((Object)params.getObjectElement("combCostType2.value"));
        CostAnalyseTypeEnum baseAnalyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
        CostAnalyseTypeEnum compareAnalyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
        if (params.getObjectElement("tblType.value") instanceof Object[][]) {
            Object[][] analyseTypes = (Object[][])params.getObjectElement("tblType.value");
            for (int i = 0; i < analyseTypes.length; ++i) {
                Object[] analyse = analyseTypes[i];
                if (!Boolean.TRUE.equals(analyse[4])) continue;
                if ("base".equals(analyse[0])) {
                    baseAnalyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[1]);
                    continue;
                }
                compareAnalyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[1]);
            }
        }
        String locale = CompareAnalyseFacadeControllerBean.getLoc((Context)ctx);
        StringBuffer kSql = new StringBuffer();
        String T_TMP_FactData = null;
        String T_NCM_CostCalResult_Base = null;
        String T_NCM_CostRecoveryReportByEnd_Base = null;
        String T_NCM_DataByCostObj_Base = null;
        String T_NCM_CostCalResult_Compare = null;
        String T_NCM_CostRecoveryReportByEnd_Compare = null;
        String T_NCM_DataByCostObj_Compare = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            kSql.setLength(0);
            kSql.append(" CREATE TABLE T_TMP_FactData ( \n");
            kSql.append("   FCompanyID    \t VARCHAR(44), \n");
            kSql.append("   FCostCenterID \t VARCHAR(44), \n");
            kSql.append("   FCostObjectID \t VARCHAR(44), \n");
            kSql.append("   FCostItemID      VARCHAR(44), \n");
            kSql.append("   FBaseUnitCost    NUMERIC(21,8), \n");
            kSql.append("   FCompareUnitCost NUMERIC(21,8), \n");
            kSql.append("   FDiffCost        NUMERIC(21,8), \n");
            kSql.append("   FDiffCostRate    NUMERIC(21,8) \n");
            kSql.append("   ) \n");
            T_TMP_FactData = this.createTempTable(ctx, schemaSource, kSql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostCenterID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostObjectID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostItemID", false, false);
            T_NCM_CostCalResult_Base = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostCalResult", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "BASE_PERIODS_KEY");
            T_NCM_CostRecoveryReportByEnd_Base = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostRecoveryReportByEnd", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "BASE_PERIODS_KEY");
            T_NCM_DataByCostObj_Base = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_DataByCostObj", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "BASE_PERIODS_KEY");
            T_NCM_CostCalResult_Compare = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostCalResult", "spinnerYearFrom2.value", "spinnerMonthFrom2.value", "spinnerYearTo2.value", "spinnerMonthTo2.value", "COMPARE_PERIODS_KEY");
            T_NCM_CostRecoveryReportByEnd_Compare = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostRecoveryReportByEnd", "spinnerYearFrom2.value", "spinnerMonthFrom2.value", "spinnerYearTo2.value", "spinnerMonthTo2.value", "COMPARE_PERIODS_KEY");
            T_NCM_DataByCostObj_Compare = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_DataByCostObj", "spinnerYearFrom2.value", "spinnerMonthFrom2.value", "spinnerYearTo2.value", "spinnerMonthTo2.value", "COMPARE_PERIODS_KEY");
            String baseColumnTitle = "";
            String compareColumnTitle = "";
            if (CostTypeEnum.factCost.equals((Object)baseCostType)) {
                baseColumnTitle = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"142_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale());
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)baseAnalyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FBaseUnitCost, \n");
                    kSql.append("             FCompareUnitCost) \n");
                    kSql.append(" SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          AVG( \n");
                    kSql.append("          \t\tCASE WHEN\u3000dataByCostObj.FFinishedQty = 0 THEN 0 \n");
                    kSql.append("               \t ELSE costCalResult.FFinishedAmount / dataByCostObj.FFinishedQty \n");
                    kSql.append("          \t\tEND \n");
                    kSql.append("              ) \n");
                    kSql.append("          AS FBaseUnitCost, \n");
                    kSql.append("          0 AS FCompareUnitCost \n");
                    kSql.append(" FROM     " + T_NCM_CostCalResult_Base + " costCalResult \n");
                    kSql.append("          INNER JOIN " + T_NCM_DataByCostObj_Base + " dataByCostObj \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    kSql.append(" WHERE  costCalResult.FCompanyID = '" + companyId + "' \n");
                    if (basePeriodIds != null) {
                        kSql.append("   AND  costCalResult.FCalculatePeriodID in " + basePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("   AND " + BIRptCommonUtil.buildSQLWhereIn("costCalResult.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" GROUP BY costCalResult.FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)baseAnalyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FBaseUnitCost, \n");
                    kSql.append("             FCompareUnitCost) \n");
                    kSql.append(" SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          CASE  \n");
                    kSql.append("            WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("            ELSE SUM(costCalResult.FFinishedAmount) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("          END AS FBaseUnitCost, \n");
                    kSql.append("          0 AS FCompareUnitCost \n");
                    kSql.append(" FROM     " + T_NCM_CostCalResult_Base + " costCalResult \n");
                    kSql.append("          INNER JOIN " + T_NCM_DataByCostObj_Base + " dataByCostObj \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    if (basePeriodIds != null) {
                        kSql.append("   AND  costCalResult.FCalculatePeriodID in " + basePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("   AND  " + BIRptCommonUtil.buildSQLWhereIn("costCalResult.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("   WHERE  costCalResult.FCompanyID = '" + companyId + "' \n");
                    kSql.append(" GROUP BY costCalResult.FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            } else {
                if (!CostTypeEnum.factCostAfterRec.equals((Object)baseCostType)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"145_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                baseColumnTitle = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"144_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale());
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)baseAnalyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FBaseUnitCost, \n");
                    kSql.append("             FCompareUnitCost) \n");
                    kSql.append(" SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("          AVG(recoveryData.FAfterUnitAmount) AS FBaseUnitCost, \n");
                    kSql.append("          0 AS FCompareUnitCost \n");
                    kSql.append(" FROM     " + T_NCM_DataByCostObj_Base + " dataByCostObj \n");
                    kSql.append("          INNER JOIN T_BD_CostObject co \n");
                    kSql.append("            ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("              AND co.FCalculateMode <> 3\n");
                    kSql.append("          INNER JOIN " + T_NCM_CostRecoveryReportByEnd_Base + " recoveryData \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("               AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("               AND recoveryData.FMaterialID IS NULL \n");
                    kSql.append(" WHERE  dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    if (basePeriodIds != null) {
                        kSql.append("   AND  dataByCostObj.FCalculatePeriodID in " + basePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("   AND  " + BIRptCommonUtil.buildSQLWhereIn("dataByCostObj.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" GROUP BY dataByCostObj.FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)baseAnalyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FBaseUnitCost, \n");
                    kSql.append("             FCompareUnitCost) \n");
                    kSql.append(" SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("          CASE  \n");
                    kSql.append("            WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("            ELSE SUM(recoveryData.FAfterUnitAmount * dataByCostObj.FFinishedQty) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("          END AS FBaseUnitCost, \n");
                    kSql.append("          0 AS FCompareUnitCost \n");
                    kSql.append(" FROM     " + T_NCM_DataByCostObj_Base + " dataByCostObj \n");
                    kSql.append("          INNER JOIN T_BD_CostObject co \n");
                    kSql.append("            ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("              AND co.FCalculateMode <> 3\n");
                    kSql.append("          INNER JOIN " + T_NCM_CostRecoveryReportByEnd_Base + " recoveryData \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("               AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("               AND recoveryData.FMaterialID IS NULL \n");
                    if (basePeriodIds != null) {
                        kSql.append("   AND  dataByCostObj.FCalculatePeriodID in " + basePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("   AND " + BIRptCommonUtil.buildSQLWhereIn("dataByCostObj.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" WHERE  dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    kSql.append(" GROUP BY dataByCostObj.FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            }
            if (CostTypeEnum.factCost.equals((Object)compareCostType)) {
                compareColumnTitle = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"146_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale());
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)compareAnalyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" UPDATE " + T_TMP_FactData + " \n");
                    kSql.append(" SET    FCompareUnitCost = (SELECT compareData.FCompareUnitCost \n");
                    kSql.append("                            FROM   (SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("                                             costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("                                             costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("                                             costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          \t\t\t\t\t\t\t\t\t  AVG( \n");
                    kSql.append("          \t\t\t\t\t\t\t\t\t\t\tCASE WHEN\u3000dataByCostObj.FFinishedQty = 0 THEN 0 \n");
                    kSql.append("               \t \t\t\t\t\t\t\t\t\t ELSE costCalResult.FFinishedAmount / dataByCostObj.FFinishedQty \n");
                    kSql.append("          \t\t\t\t\t\t\t\t\t\t\tEND \n");
                    kSql.append("              \t\t\t\t\t\t\t\t\t  ) AS FCompareUnitCost \n");
                    kSql.append("                                    FROM     " + T_NCM_CostCalResult_Compare + " costCalResult \n");
                    kSql.append("                                             INNER JOIN " + T_NCM_DataByCostObj_Compare + " dataByCostObj \n");
                    kSql.append("                                               ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("                                                  AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t WHERE   costCalResult.FCompanyID = '" + companyId + "' \n");
                    if (comparePeriodIds != null) {
                        kSql.append("   \t\t\t\t\t\t           AND  costCalResult.FCalculatePeriodID in " + comparePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("                                      AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("                                      AND  " + BIRptCommonUtil.buildSQLWhereIn("costCalResult.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("                                      AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("                                    GROUP BY costCalResult.FCompanyID,costCalResult.FCostCenterID,costCalResult.FCostObjectID,costCalResult.FCostItemID) compareData \n");
                    kSql.append("                            WHERE  compareData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
                    kSql.append("                                   AND compareData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
                    kSql.append("                                   AND compareData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
                    kSql.append("                                   AND compareData.FCostItemID = " + T_TMP_FactData + ".FCostItemID) \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)compareAnalyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" UPDATE " + T_TMP_FactData + " \n");
                    kSql.append(" SET    FCompareUnitCost = (SELECT compareData.FCompareUnitCost \n");
                    kSql.append("                            FROM   (SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("                                             costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("                                             costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("                                             costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          \t\t\t\t\t\t\t\t\t  CASE  \n");
                    kSql.append("            \t\t\t\t\t\t\t\t\t  WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("            \t\t\t\t\t\t\t\t\t  ELSE SUM(costCalResult.FFinishedAmount) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("          \t\t\t\t\t\t\t\t\t  END AS FCompareUnitCost \n");
                    kSql.append("                                    FROM     " + T_NCM_CostCalResult_Compare + " costCalResult \n");
                    kSql.append("                                             INNER JOIN " + T_NCM_DataByCostObj_Compare + " dataByCostObj \n");
                    kSql.append("                                               ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("                                                  AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t WHERE   costCalResult.FCompanyID = '" + companyId + "' \n");
                    if (comparePeriodIds != null) {
                        kSql.append("   \t\t\t\t\t\t           AND  costCalResult.FCalculatePeriodID in " + comparePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("                                      AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("                                      AND " + BIRptCommonUtil.buildSQLWhereIn("costCalResult.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("                                      AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("                                    GROUP BY costCalResult.FCompanyID,costCalResult.FCostCenterID,costCalResult.FCostObjectID,costCalResult.FCostItemID) compareData \n");
                    kSql.append("                            WHERE  compareData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
                    kSql.append("                                   AND compareData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
                    kSql.append("                                   AND compareData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
                    kSql.append("                                   AND compareData.FCostItemID = " + T_TMP_FactData + ".FCostItemID) \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            } else {
                if (!CostTypeEnum.factCostAfterRec.equals((Object)compareCostType)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"145_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                compareColumnTitle = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"147_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale());
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)compareAnalyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" UPDATE " + T_TMP_FactData + " \n");
                    kSql.append(" SET    FCompareUnitCost = (SELECT compareData.FCompareUnitCost \n");
                    kSql.append("                            FROM   (SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("                                             dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("                                             dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("                                             recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("                                             AVG(recoveryData.FAfterUnitAmount) AS FCompareUnitCost \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t   FROM   " + T_NCM_DataByCostObj_Compare + " dataByCostObj \n");
                    kSql.append("                                             INNER JOIN T_BD_CostObject co \n");
                    kSql.append("                                               ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("                                                   AND co.FCalculateMode <> 3\n");
                    kSql.append("                                             INNER JOIN " + T_NCM_CostRecoveryReportByEnd_Compare + " recoveryData \n");
                    kSql.append("                                               ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("                                                  AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("                                                  AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("                                                  AND recoveryData.FMaterialID IS NULL \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t WHERE   dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    if (comparePeriodIds != null) {
                        kSql.append("   \t\t\t\t\t\t           AND  dataByCostObj.FCalculatePeriodID in " + comparePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("                                      AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("                                      AND  " + BIRptCommonUtil.buildSQLWhereIn("dataByCostObj.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("                                      AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("                                    GROUP BY dataByCostObj.FCompanyID,dataByCostObj.FCostCenterID,dataByCostObj.FCostObjectID,recoveryData.FCostItemID) compareData \n");
                    kSql.append("                            WHERE  compareData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
                    kSql.append("                                   AND compareData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
                    kSql.append("                                   AND compareData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
                    kSql.append("                                   AND compareData.FCostItemID = " + T_TMP_FactData + ".FCostItemID) \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)compareAnalyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" UPDATE " + T_TMP_FactData + " \n");
                    kSql.append(" SET    FCompareUnitCost = (SELECT compareData.FCompareUnitCost \n");
                    kSql.append("                            FROM   (SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("                                             dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("                                             dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("                                             recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("                                             CASE  \n");
                    kSql.append("                                               WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("                                               ELSE SUM(recoveryData.FAfterUnitAmount * dataByCostObj.FFinishedQty) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("                                             END AS FCompareUnitCost \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t   FROM   " + T_NCM_DataByCostObj_Compare + " dataByCostObj \n");
                    kSql.append("                                             INNER JOIN T_BD_CostObject co \n");
                    kSql.append("                                               ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("                                                   AND co.FCalculateMode <> 3\n");
                    kSql.append("                                             INNER JOIN " + T_NCM_CostRecoveryReportByEnd_Compare + " recoveryData \n");
                    kSql.append("                                               ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("                                                  AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("                                                  AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("                                                  AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("                                                  AND recoveryData.FMaterialID IS NULL \n");
                    kSql.append(" \t\t\t\t\t\t\t\t\t WHERE   dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    if (comparePeriodIds != null) {
                        kSql.append("   \t\t\t\t\t\t           AND  dataByCostObj.FCalculatePeriodID in " + comparePeriodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("                                      AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (coIds.size() > 0) {
                        kSql.append("                                      AND  dataByCostObj.FCostObjectID" + BIRptCommonUtil.buildSQLWhereIn("dataByCostObj.FCostObjectID", coIds) + " \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("                                      AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("                                    GROUP BY dataByCostObj.FCompanyID,dataByCostObj.FCostCenterID,dataByCostObj.FCostObjectID,recoveryData.FCostItemID) compareData \n");
                    kSql.append("                            WHERE  compareData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
                    kSql.append("                                   AND compareData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
                    kSql.append("                                   AND compareData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
                    kSql.append("                                   AND compareData.FCostItemID = " + T_TMP_FactData + ".FCostItemID) \n");
                    if (coIds.size() > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            }
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, T_TMP_FactData);
            kSql.setLength(0);
            kSql.append(" UPDATE " + T_TMP_FactData + " \n");
            kSql.append(" SET    FDiffCost = FCompareUnitCost - FBaseUnitCost \n");
            kSql.append(" WHERE  FCompareUnitCost IS NOT NULL AND FBaseUnitCost IS NOT NULL \n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            StringBuffer sqlCompany = new StringBuffer();
            sqlCompany.append(" SELECT A.FID,");
            sqlCompany.append("        A.FNumber,");
            sqlCompany.append("        A.FName_" + locale + " FName,");
            sqlCompany.append("        A.FParentID");
            sqlCompany.append("  FROM T_ORG_Company A");
            sqlCompany.append(" WHERE A.FID = '" + companyId + "'");
            schemaSource.setDataItem("Company", sqlCompany.toString(), null);
            StringBuffer sqlCostCenter = new StringBuffer();
            sqlCostCenter.append(" SELECT A.FID,");
            sqlCostCenter.append("        A.FNumber,");
            sqlCostCenter.append("        A.FNumber ||' '|| A.FName_" + locale + " FName,");
            sqlCostCenter.append("        A.FParentID");
            sqlCostCenter.append("  FROM T_ORG_CostCenter A ");
            sqlCostCenter.append(" WHERE A.FID in (SELECT FCostCenterID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostCenter", sqlCostCenter.toString(), null);
            StringBuffer sqlCostObject = new StringBuffer();
            sqlCostObject.append(" SELECT DISTINCT");
            sqlCostObject.append("        A.FID,");
            sqlCostObject.append("        A.FNumber || ' ' || A.FName_" + locale + " FName, ");
            sqlCostObject.append("        A.FNumber,");
            sqlCostObject.append("        M.FModel FModel, ");
            sqlCostObject.append("        A.FBatchNumber FBatchNumber, ");
            sqlCostObject.append("ISNULL(A.FOrderNumber, ' ') as FOrderNumber,");
            sqlCostObject.append("ISNULL(M.FNumber, ' ') as FMaterialNumber,");
            sqlCostObject.append("ISNULL(M.FName_" + locale + ", ' ') as FMaterialName,");
            sqlCostObject.append("ISNULL(p.FNumber, ' ') as FProjectNumber,");
            sqlCostObject.append("ISNULL(t.FNumber, ' ') as FTrackNumber,");
            sqlCostObject.append("        LEFT('#,##0.000000000000000000000', M.FPricePrecision + 6) FPricePrecision ");
            sqlCostObject.append("   FROM T_BD_CostObject A");
            sqlCostObject.append("   \t  INNER JOIN T_BD_Material M ");
            sqlCostObject.append("           ON A.FStdProductIDID = M.FID ");
            sqlCostObject.append("left join T_MM_Project p ");
            sqlCostObject.append("on p.FID = A.FProjectID ");
            sqlCostObject.append("left join T_MM_TrackNumber t ");
            sqlCostObject.append("on t.FID = A.FTrackID ");
            sqlCostObject.append(" WHERE A.FID in (SELECT FCostObjectID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostObject", sqlCostObject.toString(), null);
            StringBuffer sqlCostItem = new StringBuffer();
            sqlCostItem.append(" SELECT A.FID,");
            sqlCostItem.append("        A.FNumber,");
            sqlCostItem.append("        A.FNumber ||' '|| A.FName_" + locale + " FName");
            sqlCostItem.append("   FROM T_NCM_CostItem A ");
            sqlCostItem.append(" WHERE A.FID in (SELECT FCostItemID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostItem", sqlCostItem.toString(), null);
            StringBuffer factSql = new StringBuffer();
            factSql.append(" SELECT * FROM " + T_TMP_FactData);
            schemaSource.setDataItem("Fact", factSql.toString(), null);
            StringBuffer measure = new StringBuffer();
            measure.append("<Measure name=\"BaseUnitCost\" caption=\"" + baseColumnTitle + "\" column=\"FBaseUnitCost\" aggregator=\"sum\" formatString=\"mdx:[CostObject].currentmember.Properties('matPrecision')\"/>\r\n");
            measure.append("<Measure name=\"CompareUnitCost\" caption=\"" + compareColumnTitle + "\" column=\"FCompareUnitCost\" aggregator=\"sum\" formatString=\"mdx:[CostObject].currentmember.Properties('matPrecision')\"/>\r\n");
            measure.append("<Measure name=\"DiffCost\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"223_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()) + "\" column=\"FDiffCost\" aggregator=\"sum\" formatString=\"mdx:[CostObject].currentmember.Properties('matPrecision')\"/>\r\n");
            schemaSource.setMacroValue("Measure", measure.toString());
            StringBuffer mdx = new StringBuffer();
            mdx.append(" with ");
            mdx.append(" member [Measures].[DiffCostRate] as '(iif(([Measures].[BaseUnitCost] = 0),null,100*[Measures].[DiffCost]/[Measures].[BaseUnitCost] ))',formatString='#,##0.00',solve_order=2,caption='" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"189_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()) + "' ");
            mdx.append(" member [CostItem].[" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "] as 'sum([CostItem].members)' ");
            mdx.append(" select Non Empty {[Company].members}*{[CostCenter].members}*{[CostObject].members} \n");
            mdx.append(" Dimension properties [CostObject].[BatchNumber],[CostObject].[Model], \n");
            mdx.append("    [CostObject].[MaterialName], ");
            mdx.append("    [CostObject].[MaterialNumber], ");
            mdx.append("    [CostObject].[TrackNumber], ");
            mdx.append("    [CostObject].[ProjectNumber], ");
            mdx.append("    [CostObject].[OrderNumber] ");
            mdx.append(" on rows, \n");
            mdx.append("                  {[CostItem].members,[CostItem].[" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "]}*{{[Measures].[BaseUnitCost]},{[Measures].[CompareUnitCost]},{[Measures].[DiffCost]},{[Measures].[DiffCostRate]}} on columns \n");
            mdx.append("  from Fact \n");
            schemaSource.setMdx(mdx.toString());
            return schemaSource;
        }
        catch (Exception exc) {
            super.releaseTables(ctx, schemaSource);
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

