/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseException;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostPropertyAnalyseEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.app.AbstractProductCostPerfAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.app.TrendAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.util.app.BIRptCommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductCostPerfAnalyseFacadeControllerBean
extends AbstractProductCostPerfAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.birpt.app.ProductCostPerfAnalyseFacadeControllerBean");
    private static final String COST_ANALYSE_RESOURCE_PATH = "com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource";
    private static final String CRLF = "\r\n";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource schemaSource;
        SchemaSource ss = null;
        Connection conn = null;
        try {
            ss = super.readySchemaSource(params, ctx);
            Object temp = null;
            String loc = ProductCostPerfAnalyseFacadeControllerBean.getLoc((Context)ctx);
            Set companyIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCompany.value");
            if (companyIds.size() != 1) {
                throw new CostAnalyseException(CostAnalyseException.TREND_ORG_ERROR);
            }
            String companyId = (String)companyIds.iterator().next();
            List anaPeriods = BIRptCommonUtil.getPeriods(params, "spYearFrom.value", "spMonthFrom.value", "spYearTo.value", "spMonthTo.value", "RPT_PERIODS_KEY");
            Set periodIds = BIRptCommonUtil.getPeriodIds(ctx, anaPeriods);
            if (periodIds.size() == 0) {
                throw new CostAnalyseException(CostAnalyseException.TREND_PERIOD_ERROR);
            }
            CostTypeEnum costType = CostTypeEnum.factCost;
            temp = params.getObjectElement("combCostType.value");
            if (temp != null && temp instanceof CostTypeEnum) {
                costType = (CostTypeEnum)((Object)temp);
            }
            if (costType == null) {
                throw new CostAnalyseException(CostAnalyseException.TREND_COSTTYPE_ERROR);
            }
            Set ccIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostCenter.value");
            if (ccIds.size() == 0) {
                ccIds = BIRptCommonUtil.getDefaultCostCenterIds(ctx, companyId);
            }
            Set coIds = BIRptCommonUtil.getCostObjectIds(ctx, companyId, params);
            Set ciIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostItem.value");
            if (ciIds.size() == 0) {
                ciIds = BIRptCommonUtil.getDefaultCostItemIds(ctx, companyId);
            }
            CostPropertyAnalyseEnum costProperty = null;
            temp = params.getObjectElement("combCostPerf.value");
            if (temp != null && temp instanceof CostPropertyAnalyseEnum && (costProperty = (CostPropertyAnalyseEnum)((Object)temp)) == CostPropertyAnalyseEnum.ALL) {
                costProperty = null;
            }
            CostAnalyseTypeEnum analyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
            if (params.getObjectElement("tblType.value") instanceof Object[][]) {
                Object[][] analyseTypes = (Object[][])params.getObjectElement("tblType.value");
                for (int i = 0; i < analyseTypes.length; ++i) {
                    Object[] analyse = analyseTypes[i];
                    if (!Boolean.TRUE.equals(analyse[3])) continue;
                    analyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[1]);
                    break;
                }
            }
            String T_NCM_DataByCostObj = null;
            String T_NCM_CostCalResult = null;
            String T_NCM_CostRecoveryReportByEnd = null;
            T_NCM_DataByCostObj = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_DataByCostObj", anaPeriods);
            if (costType == CostTypeEnum.factCost) {
                T_NCM_CostCalResult = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostCalResult", anaPeriods);
            } else if (costType == CostTypeEnum.factCostAfterRec) {
                T_NCM_CostRecoveryReportByEnd = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostRecoveryReportByEnd", anaPeriods);
            }
            ss.setCaller(TrendAnalyseFacadeControllerBean.class);
            ss.setFilename("ProductCostPerfAnalyseOLAPSchema.xml");
            StringBuffer ksql = null;
            String where = null;
            ksql = new StringBuffer();
            if (costType == CostTypeEnum.factCost) {
                ksql.append("select").append(CRLF);
                ksql.append("dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("dataResult.FCOSTCENTERID,").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("dataResult.FCOSTITEMID,").append(CRLF);
                ksql.append("sum(dataResult.FFinishedAmount) as FTotalCost,").append(CRLF);
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)analyseTypeEnum)) {
                    ksql.append("AVG(").append(CRLF);
                    ksql.append("CASE").append(CRLF);
                    ksql.append("WHEN dataByCo.FFinishedQty = 0 THEN 0").append(CRLF);
                    ksql.append("ELSE dataResult.FFinishedAmount/dataByCo.FFinishedQty").append(CRLF);
                    ksql.append("END").append(CRLF);
                    ksql.append(")").append(CRLF);
                    ksql.append("as FUnitCost").append(CRLF);
                } else {
                    ksql.append("(").append(CRLF);
                    ksql.append("CASE").append(CRLF);
                    ksql.append("WHEN sum(dataByCo.FFinishedQty) = 0 THEN 0").append(CRLF);
                    ksql.append("ELSE sum(dataResult.FFinishedAmount)/sum(dataByCo.FFinishedQty)").append(CRLF);
                    ksql.append("END").append(CRLF);
                    ksql.append(")").append(CRLF);
                    ksql.append("as FUnitCost").append(CRLF);
                }
                ksql.append("from").append(CRLF);
                ksql.append(T_NCM_CostCalResult).append(" dataResult").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTCENTERID = dataByCo.FCOSTCENTERID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
                ksql.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", periodIds);
                ksql.append("    ").append(where).append(CRLF);
                if (ccIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTCENTERID", ccIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (coIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (ciIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                ksql.append("group by").append(CRLF);
                ksql.append("    dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("    dataResult.FCOSTCENTERID,").append(CRLF);
                ksql.append("    dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("    dataResult.FCOSTITEMID");
            } else {
                ksql.append("select").append(CRLF);
                ksql.append("dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("dataByCo.FCOSTCENTERID,").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("dataResult.FCOSTITEMID,").append(CRLF);
                ksql.append("sum(dataResult.FAfterAmount) as FTotalCost,").append(CRLF);
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)analyseTypeEnum)) {
                    ksql.append("AVG(dataResult.FAfterUnitAmount)").append(CRLF);
                    ksql.append("as FUnitCost").append(CRLF);
                } else {
                    ksql.append("(").append(CRLF);
                    ksql.append("CASE").append(CRLF);
                    ksql.append("WHEN sum(dataByCo.FFinishedQty) = 0 THEN 0").append(CRLF);
                    ksql.append("ELSE sum(dataResult.FAfterUnitAmount * dataByCo.FFinishedQty)/sum(dataByCo.FFinishedQty)").append(CRLF);
                    ksql.append("END").append(CRLF);
                    ksql.append(")").append(CRLF);
                    ksql.append("as FUnitCost").append(CRLF);
                }
                ksql.append("from").append(CRLF);
                ksql.append(T_NCM_CostRecoveryReportByEnd).append(" dataResult").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append("T_BD_CostObject co").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = co.FID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("co.FCalculateMode <> ").append(3).append(CRLF);
                ksql.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", periodIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("    ").append("dataResult.FMaterialID IS NULL").append(CRLF);
                if (ccIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataByCo.FCOSTCENTERID", ccIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (coIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (ciIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                ksql.append("group by").append(CRLF);
                ksql.append("    dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("    dataByCo.FCOSTCENTERID,").append(CRLF);
                ksql.append("    dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("    dataResult.FCOSTITEMID");
            }
            String dataResult = ksql.toString();
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("dataResult.*, ci.FCostProperty").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append(dataResult).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("dataResult").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_NCM_CostItem ci").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("dataResult.FCOSTITEMID = ci.FID").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("dataResult.FTotalCost > 0").append(CRLF);
            if (ciIds.size() > 0) {
                ksql.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("ci.FID", ciIds);
                ksql.append("    ").append(where).append(CRLF);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            String insertSelect = ksql.toString();
            String T_NCM_FACT = null;
            ksql = new StringBuffer();
            ksql.append("CREATE TABLE T_TMP_FactData ( \n");
            ksql.append("    FCompanyID    \t          VARCHAR(44), \n");
            ksql.append("    FCostCenterID \t          VARCHAR(44), \n");
            ksql.append("    FCostObjectID \t          VARCHAR(44), \n");
            ksql.append("    FCostItemID              VARCHAR(44), \n");
            ksql.append("    FTotalCost               NUMERIC(21,8), \n");
            ksql.append("    FUnitCost                NUMERIC(21,8), \n");
            ksql.append("    FCostProperty            VARCHAR(44) \n");
            ksql.append(") \n");
            T_NCM_FACT = this.createTempTable(ctx, ss, ksql.toString());
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, T_NCM_FACT);
            ksql = new StringBuffer();
            ksql.append("insert into " + T_NCM_FACT).append(CRLF);
            ksql.append(insertSelect).append(CRLF);
            if (coIds.size() > 0) {
                DbUtil.execute((Context)ctx, (String)ksql.toString());
            }
            ksql = new StringBuffer();
            ksql.append("select * from ").append(T_NCM_FACT);
            ss.setDataItem("T_NCM_FACT", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("FID, FNumber,").append(CRLF);
            ksql.append("FNAME_").append(loc).append(" as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_ORG_Company").append(CRLF);
            ksql.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FID", companyIds);
            ksql.append(where).append(CRLF);
            ss.setDataItem("T_ORG_Company", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("cc.FID, cc.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(cc.FNumber, ' '),").append(CRLF);
            ksql.append("cc.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_ORG_CostCenter cc").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("cc.FID in (select distinct FCostCenterID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_ORG_CostCenter", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("co.FID, co.FNumber, co.FName, ").append(CRLF);
            ksql.append("co.FOrderNumber, co.FMaterialNumber, co.FMaterialName, co.FProjectNumber, co.FTrackNumber, ").append(CRLF);
            ksql.append("co.FModel, co.Fbatchnumber, co.FPricePrecision,").append(CRLF);
            ksql.append("CASE").append(CRLF);
            for (int i = 1; i < 21; ++i) {
                ksql.append("WHEN co.FQtyPrecision = " + i + " THEN TOCHAR(dco.FFINISHEDQTY, 'NUMBER', " + i + ")").append(CRLF);
            }
            ksql.append("ELSE TOCHAR(dco.FFINISHEDQTY)").append(CRLF);
            ksql.append("END").append(CRLF);
            ksql.append("as FFINISHEDQTY").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append("    select").append(CRLF);
            ksql.append("    co.FID,").append(CRLF);
            ksql.append("    co.FNumber,").append(CRLF);
            ksql.append("    CONCAT(").append(CRLF);
            ksql.append("    CONCAT(co.FNumber, ' '),").append(CRLF);
            ksql.append("    co.FNAME_").append(loc).append(CRLF);
            ksql.append("    )").append(CRLF);
            ksql.append("    as FName,").append(CRLF);
            ksql.append("ISNULL(co.FOrderNumber, ' ') as FOrderNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FNumber, ' ') as FMaterialNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FName_" + loc + ", ' ') as FMaterialName,").append(CRLF);
            ksql.append("ISNULL(p.FNumber, ' ') as FProjectNumber,").append(CRLF);
            ksql.append("ISNULL(t.FNumber, ' ') as FTrackNumber,").append(CRLF);
            ksql.append("    ISNULL(ma.Fmodel, ' ') as Fmodel,").append(CRLF);
            ksql.append("    LEFT('#,##0.000000000000000000000', ma.FPricePrecision+6) as FPricePrecision,").append(CRLF);
            ksql.append("    mu.FQtyPrecision as FQtyPrecision,").append(CRLF);
            ksql.append("    ISNULL(co.Fbatchnumber, ' ') as Fbatchnumber").append(CRLF);
            ksql.append("    from").append(CRLF);
            ksql.append("    T_BD_CostObject co").append(CRLF);
            ksql.append("    join").append(CRLF);
            ksql.append("    T_BD_Material ma").append(CRLF);
            ksql.append("    on").append(CRLF);
            ksql.append("    co.FStdProductIDID = ma.FID").append(CRLF);
            ksql.append("    join").append(CRLF);
            ksql.append("    T_BD_MeasureUnit mu").append(CRLF);
            ksql.append("    on").append(CRLF);
            ksql.append("    ma.FBaseUnit = mu.FID").append(CRLF);
            ksql.append("left join T_MM_Project p ").append(CRLF);
            ksql.append("on p.FID = co.FProjectID ").append(CRLF);
            ksql.append("left join T_MM_TrackNumber t ").append(CRLF);
            ksql.append("on t.FID = co.FTrackID ").append(CRLF);
            ksql.append("    where").append(CRLF);
            ksql.append("    co.FID in (select distinct FCostObjectID from " + T_NCM_FACT + ")");
            ksql.append(")").append(CRLF);
            ksql.append("co").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append("    select").append(CRLF);
            ksql.append("    FCOSTOBJECTID,").append(CRLF);
            ksql.append("    sum(FFINISHEDQTY) as FFINISHEDQTY").append(CRLF);
            ksql.append("    from").append(CRLF);
            ksql.append(T_NCM_DataByCostObj).append(CRLF);
            ksql.append("    where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCOMPANYID", companyIds);
            ksql.append(where).append(CRLF);
            ksql.append("    and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCALCULATEPERIODID", periodIds);
            ksql.append(where).append(CRLF);
            if (ccIds.size() > 0) {
                ksql.append("    and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTCENTERID", ccIds);
                ksql.append(where).append(CRLF);
            }
            if (coIds.size() > 0) {
                ksql.append("    and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTOBJECTID", coIds);
                ksql.append(where).append(CRLF);
            }
            ksql.append("    group by").append(CRLF);
            ksql.append("    FCOMPANYID,").append(CRLF);
            ksql.append("    FCOSTCENTERID,").append(CRLF);
            ksql.append("    FCOSTOBJECTID").append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("dco").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("co.FID = dco.FCOSTOBJECTID").append(CRLF);
            ss.setDataItem("T_BD_CostObject", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("distinct FCostProperty as FID,").append(CRLF);
            ksql.append("CASE").append(CRLF);
            ksql.append("WHEN FCostProperty = '1' THEN '").append(ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"PCP_VER", (Locale)ctx.getLocale())).append("' ").append(CRLF);
            ksql.append("ELSE '").append(ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"PCP_NOVER", (Locale)ctx.getLocale())).append("'").append(CRLF);
            ksql.append("END").append(CRLF);
            ksql.append("AS FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_NCM_CostItem").append(CRLF);
            if (ciIds.size() > 0) {
                ksql.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("FID", ciIds);
                ksql.append(where).append(CRLF);
            }
            ss.setDataItem("T_NCM_CostProperty", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("ci.FID, ci.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(ci.FNumber, ' '),").append(CRLF);
            ksql.append("ci.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_NCM_CostItem ci").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("1=1").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("ci.FID in (select distinct FCostItemID from " + T_NCM_FACT + ")");
            if (costProperty != null) {
                ksql.append("and").append(CRLF);
                ksql.append("ci.FCostProperty = '" + costProperty.getValue() + "'").append(CRLF);
            }
            ss.setDataItem("T_NCM_CostItem", ksql.toString(), null);
            StringBuffer mdx = new StringBuffer();
            mdx.append("select").append(CRLF);
            mdx.append("non empty {").append(CRLF);
            mdx.append("    {[Measures].[TotalCost], [Measures].[UnitCost]}").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("ON COLUMNS,").append(CRLF);
            mdx.append("non empty {").append(CRLF);
            mdx.append("    {[Company].members} *").append(CRLF);
            mdx.append("    {[CostCenter].members} *").append(CRLF);
            mdx.append("    {[CostObject].members} *").append(CRLF);
            mdx.append("    {[CostProperty].members} *").append(CRLF);
            mdx.append("    {[CostItem].members, [CostItem].total}").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("Dimension properties").append(CRLF);
            mdx.append("    [CostObject].[FinishedQty],").append(CRLF);
            mdx.append("    [CostObject].[CostBatch],").append(CRLF);
            mdx.append("    [CostObject].[CostModel],").append(CRLF);
            mdx.append("    [CostObject].[MaterialName],").append(CRLF);
            mdx.append("    [CostObject].[MaterialNumber],").append(CRLF);
            mdx.append("    [CostObject].[TrackNumber],").append(CRLF);
            mdx.append("    [CostObject].[ProjectNumber],").append(CRLF);
            mdx.append("    [CostObject].[OrderNumber]").append(CRLF);
            mdx.append("ON ROWS").append(CRLF);
            mdx.append("from CostCube");
            ss.setMdx(mdx.toString());
            schemaSource = ss;
        }
        catch (BOSException e) {
            try {
                super.releaseTables(ctx, ss);
                throw e;
                catch (EASBizException e2) {
                    super.releaseTables(ctx, ss);
                    throw e2;
                }
                catch (Exception e3) {
                    super.releaseTables(ctx, ss);
                    logger.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return schemaSource;
    }
}

