/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseException;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostSingleTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.app.AbstractProductUseOfMatAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.app.TrendAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.util.app.BIRptCommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductUseOfMatAnalyseFacadeControllerBean
extends AbstractProductUseOfMatAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.birpt.app.ProductUseOfMatAnalyseFacadeControllerBean");
    private static final String COST_ANALYSE_RESOURCE_PATH = "com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource";
    private static final String CRLF = "\r\n";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource schemaSource;
        SchemaSource ss = null;
        Connection conn = null;
        try {
            int groupAmount;
            int totalAmount;
            String compCostTypeTitle;
            String baseCostTypeTitle;
            ss = super.readySchemaSource(params, ctx);
            Object temp = null;
            String loc = ProductUseOfMatAnalyseFacadeControllerBean.getLoc((Context)ctx);
            Set companyIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCompany.value");
            if (companyIds.size() != 1) {
                throw new CostAnalyseException(CostAnalyseException.TREND_ORG_ERROR);
            }
            String companyId = (String)companyIds.iterator().next();
            List anaBasePeriods = BIRptCommonUtil.getPeriods(params, "spBaseYearFrom.value", "spBaseMonthFrom.value", "spBaseYearTo.value", "spBaseMonthTo.value", "BASE_PERIODS_KEY");
            Set basePeriodIds = BIRptCommonUtil.getPeriodIds(ctx, anaBasePeriods);
            List anaCompPeriods = BIRptCommonUtil.getPeriods(params, "spCompYearFrom.value", "spCompMonthFrom.value", "spCompYearTo.value", "spCompMonthTo.value", "COMPARE_PERIODS_KEY");
            Set compPeriodIds = BIRptCommonUtil.getPeriodIds(ctx, anaCompPeriods);
            if (basePeriodIds.size() == 0 || compPeriodIds.size() == 0) {
                throw new CostAnalyseException(CostAnalyseException.TREND_PERIOD_ERROR);
            }
            CostTypeEnum baseCostType = null;
            CostTypeEnum compCostType = null;
            temp = params.getObjectElement("combBaseCostType.value");
            if (temp != null && temp instanceof CostTypeEnum) {
                baseCostType = (CostTypeEnum)((Object)temp);
            }
            if ((temp = params.getObjectElement("combCompCostType.value")) != null && temp instanceof CostTypeEnum) {
                compCostType = (CostTypeEnum)((Object)temp);
            }
            if (baseCostType == null || compCostType == null) {
                throw new CostAnalyseException(CostAnalyseException.TREND_COSTTYPE_ERROR);
            }
            Set ccIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostCenter.value");
            if (ccIds.size() == 0) {
                ccIds = BIRptCommonUtil.getDefaultCostCenterIds(ctx, companyId);
            }
            Set coIds = BIRptCommonUtil.getCostObjectIds(ctx, companyId, params);
            Set ciIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostItem.value");
            if (ciIds.size() == 0) {
                ciIds = BIRptCommonUtil.getDefaultCostItemIds(ctx, companyId);
            }
            CostAnalyseTypeEnum baseAnalyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
            CostAnalyseTypeEnum compAnalyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
            if (params.getObjectElement("tblType.value") instanceof Object[][]) {
                Object[][] analyseTypes = (Object[][])params.getObjectElement("tblType.value");
                for (int i = 0; i < analyseTypes.length; ++i) {
                    Object[] analyse = analyseTypes[i];
                    if (CostSingleTypeEnum.CostBase.equals(analyse[0])) {
                        if (!Boolean.TRUE.equals(analyse[4])) continue;
                        baseAnalyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[2]);
                        continue;
                    }
                    if (!CostSingleTypeEnum.CostComp.equals(analyse[0]) || !Boolean.TRUE.equals(analyse[4])) continue;
                    compAnalyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[2]);
                }
            }
            String baseT_NCM_DataByCostObj = null;
            String compT_NCM_DataByCostObj = null;
            String baseT_NCM_CostCalMatDetailResult = null;
            String compT_NCM_CostCalMatDetailResult = null;
            String baseT_NCM_CostRecoveryReportByEnd = null;
            String compT_NCM_CostRecoveryReportByEnd = null;
            baseT_NCM_DataByCostObj = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_DataByCostObj", anaBasePeriods);
            if (baseCostType == CostTypeEnum.factCost) {
                baseT_NCM_CostCalMatDetailResult = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostCalMatDetailResult", anaBasePeriods);
            } else if (baseCostType == CostTypeEnum.factCostAfterRec) {
                baseT_NCM_CostRecoveryReportByEnd = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostRecoveryReportByEnd", anaBasePeriods);
            }
            compT_NCM_DataByCostObj = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_DataByCostObj", anaCompPeriods);
            if (compCostType == CostTypeEnum.factCost) {
                compT_NCM_CostCalMatDetailResult = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostCalMatDetailResult", anaCompPeriods);
            } else if (compCostType == CostTypeEnum.factCostAfterRec) {
                compT_NCM_CostRecoveryReportByEnd = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostRecoveryReportByEnd", anaCompPeriods);
            }
            ss.setCaller(TrendAnalyseFacadeControllerBean.class);
            ss.setFilename("ProductUseOfMatAnalyseOLAPSchema.xml");
            StringBuffer ksql = null;
            String where = null;
            ksql = new StringBuffer();
            String baseKsql = null;
            String compKsql = null;
            if (CostTypeEnum.factCost.equals((Object)baseCostType)) {
                baseKsql = this.getFactSQL(companyIds, basePeriodIds, ccIds, coIds, ciIds, true, baseAnalyseTypeEnum, baseT_NCM_CostCalMatDetailResult, baseT_NCM_DataByCostObj);
                baseCostTypeTitle = ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_CostType_Fact_Base", (Locale)ctx.getLocale());
            } else {
                baseKsql = this.getRecvSQL(companyIds, basePeriodIds, ccIds, coIds, ciIds, true, baseAnalyseTypeEnum, baseT_NCM_CostRecoveryReportByEnd, baseT_NCM_DataByCostObj);
                baseCostTypeTitle = ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_CostType_Recv_Base", (Locale)ctx.getLocale());
            }
            if (CostTypeEnum.factCost.equals((Object)compCostType)) {
                compKsql = this.getFactSQL(companyIds, compPeriodIds, ccIds, coIds, ciIds, false, compAnalyseTypeEnum, compT_NCM_CostCalMatDetailResult, compT_NCM_DataByCostObj);
                compCostTypeTitle = ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_CostType_Fact_Comp", (Locale)ctx.getLocale());
            } else {
                compKsql = this.getRecvSQL(companyIds, compPeriodIds, ccIds, coIds, ciIds, false, compAnalyseTypeEnum, compT_NCM_CostRecoveryReportByEnd, compT_NCM_DataByCostObj);
                compCostTypeTitle = ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_CostType_Recv_Comp", (Locale)ctx.getLocale());
            }
            ss.setMacroValue("baseCostType", baseCostTypeTitle);
            ss.setMacroValue("compCostType", compCostTypeTitle);
            ksql.append("select").append(CRLF);
            ksql.append("FCOMPANYID, FCOSTCENTERID, FCOSTOBJECTID, FCOSTITEMID, FMaterialID,").append(CRLF);
            ksql.append("sum(FBaseCoFinishedQty) as FBaseCoFinishedQty,").append(CRLF);
            ksql.append("sum(FCompCoFinishedQty) as FCompCoFinishedQty,").append(CRLF);
            ksql.append("sum(FBaseMaFinishedQty) as FBaseMaFinishedQty,").append(CRLF);
            ksql.append("sum(FCompMaFinishedQty) as FCompMaFinishedQty,").append(CRLF);
            ksql.append("sum(FBaseMaFinishedAmount) as FBaseMaFinishedAmount,").append(CRLF);
            ksql.append("sum(FCompMaFinishedAmount) as FCompMaFinishedAmount,").append(CRLF);
            ksql.append("sum(FBaseUnitQty) as FBaseUnitQty,").append(CRLF);
            ksql.append("sum(FCompUnitQty) as FCompUnitQty,").append(CRLF);
            ksql.append("(sum(FCompUnitQty) - sum(FBaseUnitQty)) as FUnitQtyDiff,").append(CRLF);
            ksql.append("(CASE WHEN sum(FBaseUnitQty) = 0 THEN 100 ELSE ((sum(FCompUnitQty) - sum(FBaseUnitQty))/sum(FBaseUnitQty) * 100) END) as FUnitQtyDiffRate,").append(CRLF);
            ksql.append("sum(FBaseUnitAmount) as FBaseUnitAmount,").append(CRLF);
            ksql.append("sum(FCompUnitAmount) as FCompUnitAmount,").append(CRLF);
            ksql.append("(sum(FCompUnitAmount) - sum(FBaseUnitAmount)) as FUnitAmountDiff, ").append(CRLF);
            ksql.append("(CASE WHEN sum(FBaseUnitAmount) = 0 THEN 100 ELSE ((sum(FCompUnitAmount) - sum(FBaseUnitAmount))/sum(FBaseUnitAmount)  * 100) END) as FUnitAmountDiffRate").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append(baseKsql).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("union").append(CRLF);
            ksql.append("(").append(CRLF);
            ksql.append(compKsql).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append(") fact").append(CRLF);
            ksql.append("group by").append(CRLF);
            ksql.append("FCOMPANYID, FCOSTCENTERID, FCOSTOBJECTID, FCOSTITEMID, FMaterialID").append(CRLF);
            conn = EJBFactory.getConnection((Context)ctx);
            String T_NCM_FACT = null;
            String dataResult = ksql.toString();
            ksql = new StringBuffer();
            ksql.append("CREATE TABLE T_TMP_FactData ( \n");
            ksql.append("    FCompanyID    \t          VARCHAR(44), \n");
            ksql.append("    FCostCenterID \t          VARCHAR(44), \n");
            ksql.append("    FCostObjectID \t          VARCHAR(44), \n");
            ksql.append("    FCostItemID              VARCHAR(44), \n");
            ksql.append("    FMaterialID              VARCHAR(44), \n");
            ksql.append("    FBaseCoFinishedQty       NUMERIC(21,8), \n");
            ksql.append("    FCompCoFinishedQty       NUMERIC(21,8), \n");
            ksql.append("    FBaseMaFinishedQty       NUMERIC(21,8), \n");
            ksql.append("    FCompMaFinishedQty       NUMERIC(21,8), \n");
            ksql.append("    FBaseMaFinishedAmount    NUMERIC(21,8), \n");
            ksql.append("    FCompMaFinishedAmount    NUMERIC(21,8), \n");
            ksql.append("    FBaseUnitQty             NUMERIC(21,8), \n");
            ksql.append("    FCompUnitQty             NUMERIC(21,8), \n");
            ksql.append("    FUnitQtyDiff             NUMERIC(21,8), \n");
            ksql.append("    FUnitQtyDiffRate         NUMERIC(21,8), \n");
            ksql.append("    FBaseUnitAmount    \t  NUMERIC(21,8), \n");
            ksql.append("    FCompUnitAmount          NUMERIC(21,8), \n");
            ksql.append("    FUnitAmountDiff          NUMERIC(21,8), \n");
            ksql.append("    FUnitAmountDiffRate      NUMERIC(21,8) \n");
            ksql.append(") \n");
            T_NCM_FACT = this.createTempTable(ctx, ss, ksql.toString());
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, T_NCM_FACT);
            ksql = new StringBuffer();
            ksql.append("insert into " + T_NCM_FACT).append(CRLF);
            ksql.append(dataResult).append(CRLF);
            if (ccIds.size() > 0) {
                DbUtil.execute((Context)ctx, (String)ksql.toString());
            }
            int companyAmount = 1;
            int costCenterAmount = 0;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select count(distinct FCostCenterID) from " + T_NCM_FACT));
            if (rowSet.next()) {
                costCenterAmount = rowSet.getInt(1);
            }
            int costObjectAmount = 0;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)("select count(distinct FCostObjectID) from " + T_NCM_FACT));
            if (rowSet.next()) {
                costObjectAmount = rowSet.getInt(1);
            }
            int costItemAmount = 0;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)("select count(distinct FCostItemID) from " + T_NCM_FACT));
            if (rowSet.next()) {
                costItemAmount = rowSet.getInt(1);
            }
            int materialAmount = 0;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)("select count(distinct FMaterialID) from " + T_NCM_FACT));
            if (rowSet.next()) {
                materialAmount = rowSet.getInt(1);
            }
            if ((totalAmount = companyAmount * costCenterAmount * costObjectAmount * costItemAmount * materialAmount * (groupAmount = 5)) > 3000) {
                throw new CostAnalyseException(CostAnalyseException.COST_DATA_TOOBIG);
            }
            ksql = new StringBuffer();
            ksql.append("update " + T_NCM_FACT).append(CRLF);
            ksql.append("set").append(CRLF);
            ksql.append("FBaseCoFinishedQty = null, FBaseMaFinishedQty = null, FBaseMaFinishedAmount = null,").append(CRLF);
            ksql.append("FBaseUnitQty = null, FUnitQtyDiff = null, FUnitQtyDiffRate = null,").append(CRLF);
            ksql.append("FBaseUnitAmount = null, FUnitAmountDiff = null, FUnitAmountDiffRate = null").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("FBaseCoFinishedQty = 0").append(CRLF);
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql = new StringBuffer();
            ksql.append("update " + T_NCM_FACT).append(CRLF);
            ksql.append("set").append(CRLF);
            ksql.append("FCompCoFinishedQty = null, FCompMaFinishedQty = null, FCompMaFinishedAmount = null,").append(CRLF);
            ksql.append("FCompUnitQty = null, FUnitQtyDiff = null, FUnitQtyDiffRate = null,").append(CRLF);
            ksql.append("FCompUnitAmount = null, FUnitAmountDiff = null, FUnitAmountDiffRate = null").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("FCompCoFinishedQty = 0").append(CRLF);
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql = new StringBuffer();
            for (int i = 1; i <= 5; ++i) {
                ksql.append("select").append(CRLF);
                ksql.append("FCompanyID, FCostCenterID, FCostObjectID, FCostItemID, FMaterialID,").append(CRLF);
                ksql.append("FBaseCoFinishedQty, FCompCoFinishedQty, FBaseMaFinishedQty, FCompMaFinishedQty,").append(CRLF);
                ksql.append("FBaseMaFinishedAmount, FCompMaFinishedAmount,").append(CRLF);
                ksql.append("FBaseUnitQty, FCompUnitQty, FUnitQtyDiff, FUnitQtyDiffRate,").append(CRLF);
                ksql.append("FBaseUnitAmount, FCompUnitAmount, FUnitAmountDiff, FUnitAmountDiffRate,").append(CRLF);
                ksql.append(i + " as FMeasureGroup from " + T_NCM_FACT).append(CRLF);
                if (i == 5) continue;
                ksql.append("union").append(CRLF);
            }
            ss.setDataItem("T_NCM_FACT", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("FID, FNumber,").append(CRLF);
            ksql.append("FNAME_").append(loc).append(" as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_ORG_Company").append(CRLF);
            ksql.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FID", companyIds);
            ksql.append(where).append(CRLF);
            ss.setDataItem("T_ORG_Company", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("cc.FID, cc.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(cc.FNumber, ' '),").append(CRLF);
            ksql.append("cc.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_ORG_CostCenter cc").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("cc.FID in (select distinct FCostCenterID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_ORG_CostCenter", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("co.FID, co.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(co.FNumber, ' '),").append(CRLF);
            ksql.append("co.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName,").append(CRLF);
            ksql.append("ISNULL(ma.Fmodel, ' ') as Fmodel,").append(CRLF);
            ksql.append("ISNULL(co.FOrderNumber, ' ') as FOrderNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FNumber, ' ') as FMaterialNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FName_" + loc + ", ' ') as FMaterialName,").append(CRLF);
            ksql.append("ISNULL(p.FNumber, ' ') as FProjectNumber,").append(CRLF);
            ksql.append("ISNULL(t.FNumber, ' ') as FTrackNumber,").append(CRLF);
            ksql.append("LEFT('#,##0.000000000000000000000', ma.FPricePrecision+6) as FPricePrecision,").append(CRLF);
            ksql.append("LEFT('#,##0.000000000000000000000', mu.FQtyPrecision+6) as FQtyPrecision,").append(CRLF);
            ksql.append("ISNULL(co.Fbatchnumber, ' ') as Fbatchnumber").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_BD_CostObject co").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_Material ma").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("co.FStdProductIDID = ma.FID").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_MeasureUnit mu").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("ma.FBaseUnit = mu.FID ").append(CRLF);
            ksql.append("left join T_MM_Project p ").append(CRLF);
            ksql.append("on p.FID = co.FProjectID ").append(CRLF);
            ksql.append("left join T_MM_TrackNumber t ").append(CRLF);
            ksql.append("on t.FID = co.FTrackID ").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("co.FID in (select distinct FCostObjectID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_BD_CostObject", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("ci.FID, ci.FNumber, ").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(ci.FNumber, ' '),").append(CRLF);
            ksql.append("ci.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_NCM_CostItem ci").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("ci.FID in (select distinct FCostItemID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_NCM_CostItem", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("ma.FID, ma.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(ma.FNumber, ' '),").append(CRLF);
            ksql.append("ma.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName,").append(CRLF);
            ksql.append("ISNULL(ma.Fmodel, ' ') as Fmodel,").append(CRLF);
            ksql.append("mu.FNAME_").append(loc).append(" FUnitName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_BD_Material ma").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_MeasureUnit mu").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("ma.FBaseUnit = mu.FID").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("ma.FID in").append(CRLF);
            ksql.append("(select distinct FMaterialID from " + T_NCM_FACT + ")").append(CRLF);
            ss.setDataItem("T_BD_Material", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select 1 as FID, '" + ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_MeasureGroup_FA", (Locale)ctx.getLocale()) + "' as FName").append(CRLF);
            ksql.append("union").append(CRLF);
            ksql.append("select 2 as FID, '" + ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_MeasureGroup_MAFQ", (Locale)ctx.getLocale()) + "' as FName").append(CRLF);
            ksql.append("union").append(CRLF);
            ksql.append("select 3 as FID, '" + ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_MeasureGroup_MAFA", (Locale)ctx.getLocale()) + "' as FName").append(CRLF);
            ksql.append("union").append(CRLF);
            ksql.append("select 4 as FID, '" + ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_MeasureGroup_MAFUQ", (Locale)ctx.getLocale()) + "' as FName").append(CRLF);
            ksql.append("union").append(CRLF);
            ksql.append("select 5 as FID, '" + ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"MAT_MeasureGroup_MAFUA", (Locale)ctx.getLocale()) + "' as FName").append(CRLF);
            ss.setDataItem("T_NCM_MeasureGroup", ksql.toString(), null);
            StringBuffer mdx = new StringBuffer();
            mdx.append("select").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("{[MeasureGroup].[1]} * ").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("    [Measures].[BaseCoFinishedQty0],").append(CRLF);
            mdx.append("    [Measures].[CompCoFinishedQty0]").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append(",").append(CRLF);
            mdx.append("{[MeasureGroup].[2]} * ").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("    [Measures].[BaseMaFinishedQty0],").append(CRLF);
            mdx.append("    [Measures].[CompMaFinishedQty0]").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append(",").append(CRLF);
            mdx.append("{[MeasureGroup].[3]} * ").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("    [Measures].[BaseMaFinishedAmount0],").append(CRLF);
            mdx.append("    [Measures].[CompMaFinishedAmount0]").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append(",").append(CRLF);
            mdx.append("{[MeasureGroup].[4]} * ").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("    [Measures].[BaseUnitQty0],").append(CRLF);
            mdx.append("    [Measures].[CompUnitQty0],").append(CRLF);
            mdx.append("    [Measures].[UnitQtyDiff0],").append(CRLF);
            mdx.append("    [Measures].[UnitQtyDiffRate0]").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append(",").append(CRLF);
            mdx.append("{[MeasureGroup].[5]} * ").append(CRLF);
            mdx.append("{").append(CRLF);
            mdx.append("    [Measures].[BaseUnitAmount0],").append(CRLF);
            mdx.append("    [Measures].[CompUnitAmount0],").append(CRLF);
            mdx.append("    [Measures].[UnitAmountDiff0],").append(CRLF);
            mdx.append("    [Measures].[UnitAmountDiffRate0]").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("ON COLUMNS,").append(CRLF);
            mdx.append("factmembers(Company, CostCenter, CostObject, CostItem, Material)").append(CRLF);
            mdx.append("Dimension properties").append(CRLF);
            mdx.append("    [Material].[MaterialUnit],").append(CRLF);
            mdx.append("    [Material].[MaterialModel],").append(CRLF);
            mdx.append("    [CostObject].[CostBatch],").append(CRLF);
            mdx.append("    [CostObject].[CostModel],").append(CRLF);
            mdx.append("    [CostObject].[MaterialName],").append(CRLF);
            mdx.append("    [CostObject].[MaterialNumber],").append(CRLF);
            mdx.append("    [CostObject].[TrackNumber],").append(CRLF);
            mdx.append("    [CostObject].[ProjectNumber],").append(CRLF);
            mdx.append("    [CostObject].[OrderNumber]").append(CRLF);
            mdx.append("ON ROWS").append(CRLF);
            mdx.append("from CostCube");
            ss.setMdx(mdx.toString());
            schemaSource = ss;
        }
        catch (BOSException e) {
            try {
                super.releaseTables(ctx, ss);
                throw e;
                catch (EASBizException e2) {
                    super.releaseTables(ctx, ss);
                    throw e2;
                }
                catch (Exception e3) {
                    super.releaseTables(ctx, ss);
                    logger.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return schemaSource;
    }

    protected String getFactSQL(Set companyIds, Set basePeriodIds, Set ccIds, Set coIds, Set ciIds, boolean baseType, CostAnalyseTypeEnum analyseTypeEnum, String T_NCM_CostCalMatDetailResult, String T_NCM_DataByCostObj) {
        StringBuffer ksql = null;
        String where = null;
        StringBuffer tbDataByCo = new StringBuffer();
        tbDataByCo.append("select").append(CRLF);
        tbDataByCo.append("FCOMPANYID, FCostCenterID, FCOSTOBJECTID,").append(CRLF);
        tbDataByCo.append("sum(FFinishedQty) as FCoFinishedQty").append(CRLF);
        tbDataByCo.append("from").append(CRLF);
        tbDataByCo.append(T_NCM_DataByCostObj).append(CRLF);
        tbDataByCo.append("where").append(CRLF);
        where = BIRptCommonUtil.buildSQLWhereEqual("FCOMPANYID", companyIds);
        tbDataByCo.append("    ").append(where).append(CRLF);
        tbDataByCo.append("and").append(CRLF);
        where = BIRptCommonUtil.buildSQLWhereEqual("FCALCULATEPERIODID", basePeriodIds);
        tbDataByCo.append("    ").append(where).append(CRLF);
        if (ccIds.size() > 0) {
            tbDataByCo.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTCENTERID", ccIds);
            tbDataByCo.append("    ").append(where).append(CRLF);
        }
        if (coIds.size() > 0) {
            tbDataByCo.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTOBJECTID", coIds);
            tbDataByCo.append("    ").append(where).append(CRLF);
        }
        tbDataByCo.append("group by").append(CRLF);
        tbDataByCo.append("FCOMPANYID,").append(CRLF);
        tbDataByCo.append("FCOSTCENTERID,").append(CRLF);
        tbDataByCo.append("FCOSTOBJECTID").append(CRLF);
        StringBuffer tbDataResult = new StringBuffer();
        if (analyseTypeEnum == CostAnalyseTypeEnum.arithAvg) {
            tbDataResult.append("select").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID, dataResult.FCostCenterID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            tbDataResult.append("sum(dataResult.FFinishedQty) as FMaFinishedQty,").append(CRLF);
            tbDataResult.append("sum(dataResult.FFinishedAmount) as FMaFinishedAmount,").append(CRLF);
            tbDataResult.append("avg(").append(CRLF);
            tbDataResult.append("CASE").append(CRLF);
            tbDataResult.append("    WHEN dataByCo.FFinishedQty = 0 THEN 0").append(CRLF);
            tbDataResult.append("    ELSE dataResult.FFinishedQty/dataByCo.FFinishedQty").append(CRLF);
            tbDataResult.append("END").append(CRLF);
            tbDataResult.append(")").append(CRLF);
            tbDataResult.append("as FUnitQty,").append(CRLF);
            tbDataResult.append("avg(").append(CRLF);
            tbDataResult.append("CASE").append(CRLF);
            tbDataResult.append("    WHEN dataByCo.FFinishedQty = 0 THEN 0").append(CRLF);
            tbDataResult.append("    ELSE dataResult.FFinishedAmount/dataByCo.FFinishedQty").append(CRLF);
            tbDataResult.append("END").append(CRLF);
            tbDataResult.append(")").append(CRLF);
            tbDataResult.append("as FUnitAmount").append(CRLF);
            tbDataResult.append("from").append(CRLF);
            tbDataResult.append(T_NCM_CostCalMatDetailResult).append(" dataResult").append(CRLF);
            tbDataResult.append("join").append(CRLF);
            tbDataResult.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
            tbDataResult.append("on").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("dataResult.FCOSTCENTERID = dataByCo.FCOSTCENTERID").append(CRLF);
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
            tbDataResult.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            tbDataResult.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", basePeriodIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            if (ccIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTCENTERID", ccIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (coIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (ciIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("    ").append("dataResult.FMaterialID IS NOT NULL").append(CRLF);
            tbDataResult.append("group by").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTCENTERID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTITEMID,").append(CRLF);
            tbDataResult.append("dataResult.FMaterialID").append(CRLF);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("dataResult.FCOMPANYID, dataResult.FCostCenterID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            if (baseType) {
                ksql.append("dataByCo.FCoFinishedQty as FBaseCoFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedQty as FBaseMaFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedAmount as FBaseMaFinishedAmount,").append(CRLF);
                ksql.append("dataResult.FUnitQty as FBaseUnitQty,").append(CRLF);
                ksql.append("dataResult.FUnitAmount as FBaseUnitAmount,").append(CRLF);
                ksql.append("0 as FCompCoFinishedQty,").append(CRLF);
                ksql.append("0 as FCompMaFinishedQty,").append(CRLF);
                ksql.append("0 as FCompMaFinishedAmount,").append(CRLF);
                ksql.append("0 as FCompUnitQty,").append(CRLF);
                ksql.append("0 as FCompUnitAmount").append(CRLF);
            } else {
                ksql.append("0 as FBaseCoFinishedQty,").append(CRLF);
                ksql.append("0 as FBaseMaFinishedQty,").append(CRLF);
                ksql.append("0 as FBaseMaFinishedAmount,").append(CRLF);
                ksql.append("0 as FBaseUnitQty,").append(CRLF);
                ksql.append("0 as FBaseUnitAmount,").append(CRLF);
                ksql.append("dataByCo.FCoFinishedQty as FCompCoFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedQty as FCompMaFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedAmount as FCompMaFinishedAmount,").append(CRLF);
                ksql.append("dataResult.FUnitQty as FCompUnitQty,").append(CRLF);
                ksql.append("dataResult.FUnitAmount as FCompUnitAmount").append(CRLF);
            }
            ksql.append("from").append(CRLF);
            ksql.append("(" + tbDataResult + ") dataResult").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("(" + tbDataByCo + ") dataByCo").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("dataResult.FCOSTCENTERID = dataByCo.FCOSTCENTERID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
        } else {
            tbDataResult = new StringBuffer();
            tbDataResult.append("select").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID, dataResult.FCostCenterID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            tbDataResult.append("sum(dataResult.FFinishedQty) as FMaFinishedQty,").append(CRLF);
            tbDataResult.append("sum(dataResult.FFinishedAmount) as FMaFinishedAmount").append(CRLF);
            tbDataResult.append("from").append(CRLF);
            tbDataResult.append(T_NCM_CostCalMatDetailResult).append(" dataResult").append(CRLF);
            tbDataResult.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            tbDataResult.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", basePeriodIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            if (ccIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTCENTERID", ccIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (coIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (ciIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("    ").append("dataResult.FMaterialID IS NOT NULL").append(CRLF);
            tbDataResult.append("group by").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTCENTERID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTITEMID,").append(CRLF);
            tbDataResult.append("dataResult.FMaterialID").append(CRLF);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("dataResult.FCOMPANYID, dataResult.FCostCenterID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            if (baseType) {
                ksql.append("dataByCo.FCoFinishedQty as FBaseCoFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedQty as FBaseMaFinishedQty, ").append(CRLF);
                ksql.append("dataResult.FMaFinishedAmount as FBaseMaFinishedAmount,").append(CRLF);
                ksql.append("(dataResult.FMaFinishedQty/dataByCo.FCoFinishedQty) as FBaseUnitQty,").append(CRLF);
                ksql.append("(dataResult.FMaFinishedAmount/dataByCo.FCoFinishedQty) as FBaseUnitAmount,").append(CRLF);
                ksql.append("0 as FCompCoFinishedQty,").append(CRLF);
                ksql.append("0 as FCompMaFinishedQty,").append(CRLF);
                ksql.append("0 as FCompMaFinishedAmount,").append(CRLF);
                ksql.append("0 as FCompUnitQty,").append(CRLF);
                ksql.append("0 as FCompUnitAmount").append(CRLF);
            } else {
                ksql.append("0 as FBaseCoFinishedQty,").append(CRLF);
                ksql.append("0 as FBaseMaFinishedQty,").append(CRLF);
                ksql.append("0 as FBaseMaFinishedAmount,").append(CRLF);
                ksql.append("0 as FBaseUnitQty,").append(CRLF);
                ksql.append("0 as FBaseUnitAmount,").append(CRLF);
                ksql.append("dataByCo.FCoFinishedQty as FCompCoFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedQty as FCompMaFinishedQty,").append(CRLF);
                ksql.append("dataResult.FMaFinishedAmount as FCompMaFinishedAmount,").append(CRLF);
                ksql.append("(dataResult.FMaFinishedQty/dataByCo.FCoFinishedQty) as FCompUnitQty,").append(CRLF);
                ksql.append("(dataResult.FMaFinishedAmount/dataByCo.FCoFinishedQty) as FCompUnitAmount").append(CRLF);
            }
            ksql.append("from").append(CRLF);
            ksql.append("(" + tbDataResult + ") dataResult").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("(" + tbDataByCo + ") dataByCo").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("dataResult.FCOSTCENTERID = dataByCo.FCOSTCENTERID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
        }
        return ksql.toString();
    }

    protected String getRecvSQL(Set companyIds, Set basePeriodIds, Set ccIds, Set coIds, Set ciIds, boolean baseType, CostAnalyseTypeEnum analyseTypeEnum, String T_NCM_CostRecoveryReportByEnd, String T_NCM_DataByCostObj) {
        StringBuffer ksql = new StringBuffer();
        String where = null;
        StringBuffer tbDataResult = new StringBuffer();
        if (analyseTypeEnum == CostAnalyseTypeEnum.arithAvg) {
            tbDataResult.append("select").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            tbDataResult.append("sum(dataResult.FAfterQty) as FMaFinishedQty,").append(CRLF);
            tbDataResult.append("sum(dataResult.FAfterAmount) as FMaFinishedAmount,").append(CRLF);
            tbDataResult.append("avg(dataResult.FAfterUnitQty)").append(CRLF);
            tbDataResult.append("as FUnitQty,").append(CRLF);
            tbDataResult.append("avg(dataResult.FAfterUnitAmount)").append(CRLF);
            tbDataResult.append("as FUnitAmount").append(CRLF);
            tbDataResult.append("from").append(CRLF);
            tbDataResult.append(T_NCM_CostRecoveryReportByEnd).append(" dataResult").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_CostObject co").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("dataResult.FCOSTOBJECTID = co.FID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("co.FCalculateMode <> ").append(3).append(CRLF);
            tbDataResult.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            tbDataResult.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", basePeriodIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            if (coIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (ciIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("    ").append("dataResult.FMaterialID IS NOT NULL").append(CRLF);
            tbDataResult.append("group by").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTITEMID,").append(CRLF);
            tbDataResult.append("dataResult.FMaterialID").append(CRLF);
        } else {
            tbDataResult.append("select").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
            tbDataResult.append("sum(dataResult.FAfterQty) as FMaFinishedQty,").append(CRLF);
            tbDataResult.append("sum(dataResult.FAfterAmount) as FMaFinishedAmount,").append(CRLF);
            tbDataResult.append("(").append(CRLF);
            tbDataResult.append("CASE").append(CRLF);
            tbDataResult.append("    WHEN sum(dataByCo.FFinishedQty) = 0 THEN 0").append(CRLF);
            tbDataResult.append("    ELSE sum(dataResult.FAfterUnitQty * dataByCo.FFinishedQty)/sum(dataByCo.FFinishedQty)").append(CRLF);
            tbDataResult.append("END").append(CRLF);
            tbDataResult.append(")").append(CRLF);
            tbDataResult.append("as FUnitQty,").append(CRLF);
            tbDataResult.append("(").append(CRLF);
            tbDataResult.append("CASE").append(CRLF);
            tbDataResult.append("    WHEN sum(dataByCo.FFinishedQty) = 0 THEN 0").append(CRLF);
            tbDataResult.append("    ELSE sum(dataResult.FAfterUnitAmount * dataByCo.FFinishedQty)/sum(dataByCo.FFinishedQty)").append(CRLF);
            tbDataResult.append("END").append(CRLF);
            tbDataResult.append(")").append(CRLF);
            tbDataResult.append("as FUnitAmount").append(CRLF);
            tbDataResult.append("from").append(CRLF);
            tbDataResult.append(T_NCM_CostRecoveryReportByEnd).append(" dataResult").append(CRLF);
            tbDataResult.append("join").append(CRLF);
            tbDataResult.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
            tbDataResult.append("on").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
            tbDataResult.append("and").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_CostObject co").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("dataResult.FCOSTOBJECTID = co.FID").append(CRLF);
            ksql.append("and").append(CRLF);
            ksql.append("co.FCalculateMode <> ").append(3).append(CRLF);
            tbDataResult.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            tbDataResult.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", basePeriodIds);
            tbDataResult.append("    ").append(where).append(CRLF);
            if (coIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            if (ciIds.size() > 0) {
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                tbDataResult.append("    ").append(where).append(CRLF);
            }
            tbDataResult.append("group by").append(CRLF);
            tbDataResult.append("dataResult.FCOMPANYID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTOBJECTID,").append(CRLF);
            tbDataResult.append("dataResult.FCOSTITEMID,").append(CRLF);
            tbDataResult.append("dataResult.FMaterialID").append(CRLF);
        }
        StringBuffer tbDataByCo = new StringBuffer();
        tbDataByCo.append("select").append(CRLF);
        tbDataByCo.append("FCOMPANYID, FCostCenterID, FCOSTOBJECTID,").append(CRLF);
        tbDataByCo.append("sum(FFinishedQty) as FCoFinishedQty").append(CRLF);
        tbDataByCo.append("from").append(CRLF);
        tbDataByCo.append(T_NCM_DataByCostObj).append(CRLF);
        tbDataByCo.append("where").append(CRLF);
        where = BIRptCommonUtil.buildSQLWhereEqual("FCOMPANYID", companyIds);
        tbDataByCo.append("    ").append(where).append(CRLF);
        tbDataByCo.append("and").append(CRLF);
        where = BIRptCommonUtil.buildSQLWhereEqual("FCALCULATEPERIODID", basePeriodIds);
        tbDataByCo.append("    ").append(where).append(CRLF);
        if (ccIds.size() > 0) {
            tbDataByCo.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTCENTERID", ccIds);
            tbDataByCo.append("    ").append(where).append(CRLF);
        }
        if (coIds.size() > 0) {
            tbDataByCo.append("and").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTOBJECTID", coIds);
            tbDataByCo.append("    ").append(where).append(CRLF);
        }
        tbDataByCo.append("group by").append(CRLF);
        tbDataByCo.append("FCOMPANYID,").append(CRLF);
        tbDataByCo.append("FCOSTCENTERID,").append(CRLF);
        tbDataByCo.append("FCOSTOBJECTID").append(CRLF);
        ksql = new StringBuffer();
        ksql.append("select").append(CRLF);
        ksql.append("dataResult.FCOMPANYID, dataByCo.FCostCenterID, dataResult.FCOSTOBJECTID, dataResult.FCostItemID, dataResult.FMaterialID,").append(CRLF);
        if (baseType) {
            ksql.append("dataByCo.FCoFinishedQty as FBaseCoFinishedQty,").append(CRLF);
            ksql.append("dataResult.FMaFinishedQty as FBaseMaFinishedQty, ").append(CRLF);
            ksql.append("dataResult.FMaFinishedAmount as FBaseMaFinishedAmount,").append(CRLF);
            ksql.append("dataResult.FUnitQty as FBaseUnitQty,").append(CRLF);
            ksql.append("dataResult.FUnitAmount as FBaseUnitAmount,").append(CRLF);
            ksql.append("0 as FCompCoFinishedQty,").append(CRLF);
            ksql.append("0 as FCompMaFinishedQty,").append(CRLF);
            ksql.append("0 as FCompMaFinishedAmount,").append(CRLF);
            ksql.append("0 as FCompUnitQty,").append(CRLF);
            ksql.append("0 as FCompUnitAmount").append(CRLF);
        } else {
            ksql.append("0 as FBaseCoFinishedQty,").append(CRLF);
            ksql.append("0 as FBaseMaFinishedQty,").append(CRLF);
            ksql.append("0 as FBaseMaFinishedAmount,").append(CRLF);
            ksql.append("0 as FBaseUnitQty,").append(CRLF);
            ksql.append("0 as FBaseUnitAmount,").append(CRLF);
            ksql.append("dataByCo.FCoFinishedQty as FCompCoFinishedQty,").append(CRLF);
            ksql.append("dataResult.FMaFinishedQty as FCompMaFinishedQty,").append(CRLF);
            ksql.append("dataResult.FMaFinishedAmount as FCompMaFinishedAmount,").append(CRLF);
            ksql.append("dataResult.FUnitQty as FCompUnitQty,").append(CRLF);
            ksql.append("dataResult.FUnitAmount as FCompUnitAmount").append(CRLF);
        }
        ksql.append("from").append(CRLF);
        ksql.append("(" + tbDataResult + ") dataResult").append(CRLF);
        ksql.append("join").append(CRLF);
        ksql.append("(" + tbDataByCo + ") dataByCo").append(CRLF);
        ksql.append("on").append(CRLF);
        ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
        ksql.append("and").append(CRLF);
        ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
        return ksql.toString();
    }
}

