/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.CostTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.app.AbstractStructureAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.util.app.BIRptCommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class StructureAnalyseFacadeControllerBean
extends AbstractStructureAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 470650801369300252L;
    private static Logger logger = Logger.getLogger((String)StructureAnalyseFacadeControllerBean.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        String costItemIds;
        SchemaSource schemaSource = super.readySchemaSource(params, ctx);
        schemaSource.setCaller(StructureAnalyseFacadeControllerBean.class);
        schemaSource.setFilename("CostStructureAnalyse.xml");
        String companyId = ((CompanyOrgUnitInfo)params.getObjectElement("prmtCompany.value")).getId().toString();
        String costCenterIds = BIRptCommonUtil.buildSqlIds(ctx, params, "prmtCostCenter.value");
        if (costCenterIds == null) {
            costCenterIds = BIRptCommonUtil.buildDefaultCostCenterIds(ctx, companyId);
        }
        if ((costItemIds = BIRptCommonUtil.buildSqlIds(ctx, params, "prmtCostItem.value")) == null) {
            costItemIds = BIRptCommonUtil.buildDefaultCostItemIds(ctx, companyId);
        }
        String periodIds = BIRptCommonUtil.buildPeriodIds(ctx, params, "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "RPT_PERIODS_KEY");
        CostTypeEnum costType = (CostTypeEnum)((Object)params.getObjectElement("combCostType.value"));
        CostAnalyseTypeEnum analyseTypeEnum = CostAnalyseTypeEnum.arithAvg;
        if (params.getObjectElement("tblType.value") instanceof Object[][]) {
            Object[][] analyseTypes = (Object[][])params.getObjectElement("tblType.value");
            for (int i = 0; i < analyseTypes.length; ++i) {
                Object[] analyse = analyseTypes[i];
                if (!Boolean.TRUE.equals(analyse[2])) continue;
                analyseTypeEnum = (CostAnalyseTypeEnum)((Object)analyse[0]);
                break;
            }
        }
        String locale = StructureAnalyseFacadeControllerBean.getLoc((Context)ctx);
        StringBuffer kSql = new StringBuffer();
        String T_TMP_FactData = null;
        String T_NCM_CostCalResult = null;
        String T_NCM_CostRecoveryReportByEnd = null;
        String T_NCM_DataByCostObj = null;
        String T_temp_cost = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            kSql.setLength(0);
            kSql.append(" CREATE TABLE T_TMP_FactData ( \n");
            kSql.append("   FCompanyID    VARCHAR(44), \n");
            kSql.append("   FCostCenterID VARCHAR(44), \n");
            kSql.append("   FCostObjectID VARCHAR(44), \n");
            kSql.append("   FCostItemID   VARCHAR(44), \n");
            kSql.append("   FUnitCost     NUMERIC(21,8), \n");
            kSql.append("   FCostRate     NUMERIC(10,2)\n");
            kSql.append("   ) \n");
            T_TMP_FactData = this.createTempTable(ctx, schemaSource, kSql.toString());
            kSql.setLength(0);
            kSql.append(" Create table T_temp_cost ( \n");
            kSql.append("  FCostobjectid VARCHAR(44)");
            kSql.append("  )");
            T_temp_cost = this.createTempTable(ctx, schemaSource, kSql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostCenterID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostObjectID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_FactData, "FCostItemID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(T_temp_cost, "FCostObjectID", false, false);
            this.getCostObjectTempTable(ctx, companyId, params, T_temp_cost);
            kSql.setLength(0);
            kSql.append("select count(1) as cou from " + T_temp_cost);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            rs.next();
            int costobjectsize = rs.getInt("cou");
            T_NCM_CostCalResult = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostCalResult", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "RPT_PERIODS_KEY");
            T_NCM_CostRecoveryReportByEnd = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_CostRecoveryReportByEnd", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "RPT_PERIODS_KEY");
            T_NCM_DataByCostObj = BIRptCommonUtil.getPhysicalTblName(ctx, params, companyId, "T_NCM_DataByCostObj", "spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value", "RPT_PERIODS_KEY");
            if (CostTypeEnum.factCost.equals((Object)costType)) {
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)analyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FUnitCost, \n");
                    kSql.append("             FCostRate) \n");
                    kSql.append(" SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          AVG( \n");
                    kSql.append("          \t\tCASE WHEN\u3000dataByCostObj.FFinishedQty = 0 THEN 0 \n");
                    kSql.append("               \t ELSE costCalResult.FFinishedAmount / dataByCostObj.FFinishedQty \n");
                    kSql.append("          \t\tEND \n");
                    kSql.append("              ) \n");
                    kSql.append("          AS FUnitCost, \n");
                    kSql.append("          0 AS FCostRate \n");
                    kSql.append(" FROM     " + T_NCM_CostCalResult + " costCalResult \n");
                    kSql.append("          INNER JOIN " + T_NCM_DataByCostObj + " dataByCostObj \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    kSql.append(" WHERE  costCalResult.FCompanyID = '" + companyId + "' \n");
                    if (periodIds != null) {
                        kSql.append("   AND  costCalResult.FCalculatePeriodID in " + periodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (costobjectsize > 0) {
                        kSql.append("   AND  costCalResult.FCostObjectID  in  \n");
                        kSql.append("( select fcostobjectid from " + T_temp_cost + ") \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" GROUP BY costCalResult.FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID \n");
                    if (costobjectsize > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)analyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FUnitCost, \n");
                    kSql.append("             FCostRate) \n");
                    kSql.append(" SELECT   costCalResult.FCompanyID AS FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID AS FCostItemID, \n");
                    kSql.append("          CASE  \n");
                    kSql.append("            WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("            ELSE SUM(costCalResult.FFinishedAmount) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("          END AS FUnitCost, \n");
                    kSql.append("          0 AS FCostRate \n");
                    kSql.append(" FROM     " + T_NCM_CostCalResult + " costCalResult \n");
                    kSql.append("          INNER JOIN " + T_NCM_DataByCostObj + " dataByCostObj \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = costCalResult.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = costCalResult.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostCenterID = costCalResult.FCostCenterID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = costCalResult.FCostObjectID \n");
                    if (periodIds != null) {
                        kSql.append("   AND  costCalResult.FCalculatePeriodID in " + periodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  costCalResult.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (costobjectsize > 0) {
                        kSql.append("   AND  costCalResult.FCostObjectID  in  \n");
                        kSql.append("( select fcostobjectid from " + T_temp_cost + ") \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  costCalResult.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append("   WHERE  costCalResult.FCompanyID = '" + companyId + "' \n");
                    kSql.append(" GROUP BY costCalResult.FCompanyID, \n");
                    kSql.append("          costCalResult.FCostCenterID, \n");
                    kSql.append("          costCalResult.FCostObjectID, \n");
                    kSql.append("          costCalResult.FCostItemID \n");
                    if (costobjectsize > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            } else {
                if (!CostTypeEnum.factCostAfterRec.equals((Object)costType)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"145_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                if (CostAnalyseTypeEnum.arithAvg.equals((Object)analyseTypeEnum)) {
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FUnitCost, \n");
                    kSql.append("             FCostRate) \n");
                    kSql.append(" SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("          AVG(recoveryData.FAfterUnitAmount) AS FUnitCost, \n");
                    kSql.append("          0 AS FCostRate \n");
                    kSql.append(" FROM     " + T_NCM_DataByCostObj + " dataByCostObj \n");
                    kSql.append("          INNER JOIN T_BD_CostObject co \n");
                    kSql.append("            ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("              AND co.FCalculateMode <> 3\n");
                    kSql.append("          INNER JOIN " + T_NCM_CostRecoveryReportByEnd + " recoveryData \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("               AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("               AND recoveryData.FMaterialID IS NULL \n");
                    kSql.append(" WHERE  dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    if (periodIds != null) {
                        kSql.append("   AND  dataByCostObj.FCalculatePeriodID in " + periodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (costobjectsize > 0) {
                        kSql.append("   AND  dataByCostObj.FCostObjectID  in  \n");
                        kSql.append("( select fcostobjectid from " + T_temp_cost + ") \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" GROUP BY dataByCostObj.FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID \n");
                    if (costobjectsize > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                } else {
                    if (!CostAnalyseTypeEnum.addAvg.equals((Object)analyseTypeEnum)) throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"143_CompareAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + T_TMP_FactData + " \n");
                    kSql.append("            (FCompanyID, \n");
                    kSql.append("             FCostCenterID, \n");
                    kSql.append("             FCostObjectID, \n");
                    kSql.append("             FCostItemID, \n");
                    kSql.append("             FUnitCost, \n");
                    kSql.append("             FCostRate) \n");
                    kSql.append(" SELECT   dataByCostObj.FCompanyID AS FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID AS FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID AS FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID AS FCostItemID, \n");
                    kSql.append("          CASE  \n");
                    kSql.append("            WHEN SUM(dataByCostObj.FFinishedQty) = 0 THEN 0 \n");
                    kSql.append("            ELSE SUM(recoveryData.FAfterUnitAmount * dataByCostObj.FFinishedQty) / SUM(dataByCostObj.FFinishedQty) \n");
                    kSql.append("          END AS FUnitCost, \n");
                    kSql.append("          0 AS FCostRate \n");
                    kSql.append(" FROM     " + T_NCM_DataByCostObj + " dataByCostObj \n");
                    kSql.append("          INNER JOIN T_BD_CostObject co \n");
                    kSql.append("            ON dataByCostObj.FCostObjectID = co.FID \n");
                    kSql.append("              AND co.FCalculateMode <> 3\n");
                    kSql.append("          INNER JOIN " + T_NCM_CostRecoveryReportByEnd + " recoveryData \n");
                    kSql.append("            ON dataByCostObj.FCompanyID = recoveryData.FCompanyID \n");
                    kSql.append("               AND dataByCostObj.FCalculatePeriodID = recoveryData.FCalculatePeriodID \n");
                    kSql.append("               AND dataByCostObj.FCostObjectID = recoveryData.FCostObjectID \n");
                    kSql.append("               AND recoveryData.FCostItemID IS NOT NULL \n");
                    kSql.append("               AND recoveryData.FMaterialID IS NULL \n");
                    if (periodIds != null) {
                        kSql.append("   AND  dataByCostObj.FCalculatePeriodID in " + periodIds + " \n");
                    }
                    if (costCenterIds != null) {
                        kSql.append("   AND  dataByCostObj.FCostCenterID in " + costCenterIds + " \n");
                    }
                    if (costobjectsize > 0) {
                        kSql.append("   AND  dataByCostObj.FCostObjectID  in  \n");
                        kSql.append("( select fcostobjectid from " + T_temp_cost + ") \n");
                    }
                    if (costItemIds != null) {
                        kSql.append("   AND  recoveryData.FCostItemID in " + costItemIds + " \n");
                    }
                    kSql.append(" WHERE  dataByCostObj.FCompanyID = '" + companyId + "' \n");
                    kSql.append(" GROUP BY dataByCostObj.FCompanyID, \n");
                    kSql.append("          dataByCostObj.FCostCenterID, \n");
                    kSql.append("          dataByCostObj.FCostObjectID, \n");
                    kSql.append("          recoveryData.FCostItemID \n");
                    if (costobjectsize > 0) {
                        DbUtil.execute((Context)ctx, (String)kSql.toString());
                    }
                }
            }
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, T_TMP_FactData);
            kSql.setLength(0);
            kSql.append(" DELETE FROM " + T_TMP_FactData + " \n");
            kSql.append(" WHERE       EXISTS (SELECT 1 \n");
            kSql.append("                     FROM   (SELECT   FCompanyID, \n");
            kSql.append("                                      FCostCenterID, \n");
            kSql.append("                                      FCostObjectID \n");
            kSql.append("                             FROM     " + T_TMP_FactData + " \n");
            kSql.append("                             GROUP BY FCompanyID,FCostCenterID,FCostObjectID \n");
            kSql.append("                             HAVING   SUM(FUnitCost) IS NULL) sumData \n");
            kSql.append("                     WHERE  sumData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
            kSql.append("                            AND sumData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
            kSql.append("                            AND sumData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID) \n");
            if (costobjectsize > 0) {
                DbUtil.execute((Context)ctx, (String)kSql.toString());
            }
            kSql.setLength(0);
            kSql.append(" UPDATE " + T_TMP_FactData + "  \n");
            kSql.append(" SET    FCostRate = (SELECT groupData.sumCost  \n");
            kSql.append("                     FROM   (SELECT   SUM(FUnitCost) AS sumCost, \n");
            kSql.append("                                      FCompanyID, \n");
            kSql.append("                                      FCostCenterID, \n");
            kSql.append("                                      FCostObjectID \n");
            kSql.append("                             FROM     " + T_TMP_FactData + " \n");
            kSql.append("                             GROUP BY FCompanyID,FCostCenterID,FCostObjectID) groupData \n");
            kSql.append("                     WHERE  groupData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
            kSql.append("                            AND groupData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
            kSql.append("                            AND groupData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID) \n");
            if (costobjectsize > 0) {
                DbUtil.execute((Context)ctx, (String)kSql.toString());
            }
            kSql.setLength(0);
            kSql.append(" UPDATE " + T_TMP_FactData + "  \n");
            kSql.append(" SET    FCostRate = 100* FUnitCost / FCostRate \n");
            kSql.append(" WHERE  FCostRate <> 0 \n");
            if (costobjectsize > 0) {
                DbUtil.execute((Context)ctx, (String)kSql.toString());
            }
            kSql.setLength(0);
            kSql.append(" UPDATE " + T_TMP_FactData + " \n");
            kSql.append(" SET    FCostRate = (SELECT   " + T_TMP_FactData + ".FCostRate \n");
            kSql.append("                                + 100 \n");
            kSql.append("                                - SUM(sumData.FCostRate) \n");
            kSql.append("                     FROM     " + T_TMP_FactData + " sumData \n");
            kSql.append("                     WHERE    sumData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
            kSql.append("                              AND sumData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
            kSql.append("                              AND sumData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
            kSql.append("                     GROUP BY sumData.FCompanyID,sumData.FCostCenterID,sumData.FCostObjectID) \n");
            kSql.append(" WHERE  NOT EXISTS (SELECT 1 \n");
            kSql.append("                    FROM   " + T_TMP_FactData + " compareData \n");
            kSql.append("                    WHERE  compareData.FCompanyID = " + T_TMP_FactData + ".FCompanyID \n");
            kSql.append("                           AND compareData.FCostCenterID = " + T_TMP_FactData + ".FCostCenterID \n");
            kSql.append("                           AND compareData.FCostObjectID = " + T_TMP_FactData + ".FCostObjectID \n");
            kSql.append("                           AND compareData.FCostRate > " + T_TMP_FactData + ".FCostRate) \n");
            if (costobjectsize > 0) {
                DbUtil.execute((Context)ctx, (String)kSql.toString());
            }
            StringBuffer sqlCompany = new StringBuffer();
            sqlCompany.append(" SELECT A.FID,");
            sqlCompany.append("        A.FNumber,");
            sqlCompany.append("        A.FName_" + locale + " FName,");
            sqlCompany.append("        A.FParentID");
            sqlCompany.append("  FROM T_ORG_Company A");
            sqlCompany.append(" WHERE A.FID = '" + companyId + "'");
            schemaSource.setDataItem("Company", sqlCompany.toString(), null);
            StringBuffer sqlCostCenter = new StringBuffer();
            sqlCostCenter.append(" SELECT A.FID,");
            sqlCostCenter.append("        A.FNumber,");
            sqlCostCenter.append("        A.FNumber ||' '|| A.FName_" + locale + " FName,");
            sqlCostCenter.append("        A.FParentID");
            sqlCostCenter.append("  FROM T_ORG_CostCenter A ");
            sqlCostCenter.append(" WHERE A.FID in (SELECT FCostCenterID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostCenter", sqlCostCenter.toString(), null);
            StringBuffer sqlCostObject = new StringBuffer();
            sqlCostObject.append(" SELECT DISTINCT");
            sqlCostObject.append("        A.FID,");
            sqlCostObject.append("        A.FNumber || ' ' || A.FName_" + locale + " FName, ");
            sqlCostObject.append("        A.FNumber,");
            sqlCostObject.append("        M.FModel FModel, ");
            sqlCostObject.append("        A.FBatchNumber FBatchNumber, ");
            sqlCostObject.append("ISNULL(A.FOrderNumber, ' ') as FOrderNumber,");
            sqlCostObject.append("ISNULL(M.FNumber, ' ') as FMaterialNumber,");
            sqlCostObject.append("ISNULL(M.FName_" + locale + ", ' ') as FMaterialName,");
            sqlCostObject.append("ISNULL(p.FNumber, ' ') as FProjectNumber,");
            sqlCostObject.append("ISNULL(t.FNumber, ' ') as FTrackNumber,");
            sqlCostObject.append("        LEFT('#,##0.000000000000000000000', M.FPricePrecision + 6) FPricePrecision ");
            sqlCostObject.append("   FROM T_BD_CostObject A");
            sqlCostObject.append("   \t  INNER JOIN T_BD_Material M ");
            sqlCostObject.append("           ON A.FStdProductIDID = M.FID ");
            sqlCostObject.append("left join T_MM_Project p ");
            sqlCostObject.append("on p.FID = A.FProjectID ");
            sqlCostObject.append("left join T_MM_TrackNumber t ");
            sqlCostObject.append("on t.FID = A.FTrackID ");
            sqlCostObject.append(" WHERE A.FID in (SELECT FCostObjectID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostObject", sqlCostObject.toString(), null);
            StringBuffer sqlCostItem = new StringBuffer();
            sqlCostItem.append(" SELECT A.FID,");
            sqlCostItem.append("        A.FNumber,");
            sqlCostItem.append("        A.FNumber ||' '|| A.FName_" + locale + " FName");
            sqlCostItem.append("   FROM T_NCM_CostItem A ");
            sqlCostItem.append(" WHERE A.FID in (SELECT FCostItemID FROM " + T_TMP_FactData + ")");
            schemaSource.setDataItem("CostItem", sqlCostItem.toString(), null);
            StringBuffer factSql = new StringBuffer();
            factSql.append(" SELECT * FROM " + T_TMP_FactData);
            schemaSource.setDataItem("Fact", factSql.toString(), null);
            StringBuffer measure = new StringBuffer();
            measure.append("<Measure name=\"UnitCost\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"224_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()) + "\" column=\"FUnitCost\" aggregator=\"sum\" formatString=\"mdx:[CostObject].currentmember.Properties('matPrecision')\"/>\r\n");
            measure.append("<Measure name=\"CostRate\" caption=\"" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"225_StructureAnalyseFacadeControllerBean", (Locale)ctx.getLocale()) + "\" column=\"FCostRate\" aggregator=\"sum\" formatString=\"#,##0.00\"/>\r\n");
            schemaSource.setMacroValue("Measure", measure.toString());
            StringBuffer mdx = new StringBuffer();
            mdx.append(" with  ");
            mdx.append(" member [CostItem].[" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "] as 'sum([CostItem].members)' ");
            mdx.append(" select Non Empty ");
            mdx.append("       {[Company].members} ");
            mdx.append("       * ");
            mdx.append("       {[CostCenter].members} ");
            mdx.append("       * \n");
            mdx.append("       {[CostObject].members} ");
            mdx.append("       \t\tDimension properties ");
            mdx.append("            \t[CostObject].[BatchNumber], ");
            mdx.append("                [CostObject].[Model], ");
            mdx.append("    [CostObject].[MaterialName], ");
            mdx.append("    [CostObject].[MaterialNumber], ");
            mdx.append("    [CostObject].[TrackNumber], ");
            mdx.append("    [CostObject].[ProjectNumber], ");
            mdx.append("    [CostObject].[OrderNumber] ");
            mdx.append("        on rows, ");
            mdx.append("        {[CostItem].members,[CostItem].[" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "]} ");
            mdx.append("        * ");
            mdx.append("        {{[Measures].[UnitCost]},{[Measures].[CostRate]}} ");
            mdx.append("        on columns ");
            mdx.append("  from Fact ");
            schemaSource.setMdx(mdx.toString());
            return schemaSource;
        }
        catch (Exception exc) {
            super.releaseTables(ctx, schemaSource);
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void getCostObjectTempTable(Context ctx, String companyId, RptParams params, String temptable) throws BOSException, EASBizException {
        Set costObjectIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostObject.value");
        Set orderIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtOrder.value");
        Set projectIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtProject.value");
        Set trackIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtTrack.value");
        Set materialIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtMaterial.value");
        String batch = null;
        Object temp = params.getObjectElement("tfBatch.value");
        if (temp != null && temp.toString().length() > 0) {
            batch = temp.toString();
        }
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fcompanyid", (Object)companyId, CompareType.EQUALS));
        if (costObjectIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("fid", (Object)costObjectIds, CompareType.INCLUDE));
        }
        if (orderIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("forderID", (Object)orderIds, CompareType.INCLUDE));
        }
        if (projectIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("fprojectID", (Object)projectIds, CompareType.INCLUDE));
        }
        if (trackIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("ftrackID", (Object)trackIds, CompareType.INCLUDE));
        }
        if (materialIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("fStdProductIDid", (Object)materialIds, CompareType.INCLUDE));
        }
        if (batch != null) {
            filter.getFilterItems().add(new FilterItemInfo("fbatchNumber", (Object)batch, CompareType.EQUALS));
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(temptable);
        sql.append(" select fid from T_bd_costobject where ");
        sql.append(filter.toSql());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

