/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseException;
import com.kingdee.eas.ncm.cal.report.birpt.CostTypeEnum;
import com.kingdee.eas.ncm.cal.report.birpt.app.AbstractTrendAnalyseFacadeControllerBean;
import com.kingdee.eas.ncm.cal.report.birpt.util.app.BIRptCommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrendAnalyseFacadeControllerBean
extends AbstractTrendAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.birpt.app.TrendAnalyseFacadeControllerBean");
    private static final String COST_ANALYSE_RESOURCE_PATH = "com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource";
    private static final String CRLF = "\r\n";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource schemaSource;
        SchemaSource ss = null;
        Connection conn = null;
        try {
            ss = super.readySchemaSource(params, ctx);
            Object temp = null;
            String loc = TrendAnalyseFacadeControllerBean.getLoc((Context)ctx);
            Set companyIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCompany.value");
            if (companyIds.size() != 1) {
                throw new CostAnalyseException(CostAnalyseException.TREND_ORG_ERROR);
            }
            String companyId = (String)companyIds.iterator().next();
            List anaPeriods = BIRptCommonUtil.getPeriods(params, "spYearFrom.value", "spMonthFrom.value", "spYearTo.value", "spMonthTo.value", "RPT_PERIODS_KEY");
            Set periodIds = BIRptCommonUtil.getPeriodIds(ctx, anaPeriods);
            if (periodIds.size() == 0) {
                throw new CostAnalyseException(CostAnalyseException.TREND_PERIOD_ERROR);
            }
            CostTypeEnum costType = null;
            temp = params.getObjectElement("combCostType.value");
            if (temp != null && temp instanceof CostTypeEnum) {
                costType = (CostTypeEnum)((Object)temp);
            }
            if (costType == null) {
                throw new CostAnalyseException(CostAnalyseException.TREND_COSTTYPE_ERROR);
            }
            Set ccIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostCenter.value");
            if (ccIds.size() == 0) {
                ccIds = BIRptCommonUtil.getDefaultCostCenterIds(ctx, companyId);
            }
            Set coIds = BIRptCommonUtil.getCostObjectIds(ctx, companyId, params);
            Set ciIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostItem.value");
            if (ciIds.size() == 0) {
                ciIds = BIRptCommonUtil.getDefaultCostItemIds(ctx, companyId);
            }
            String T_NCM_DataByCostObj = null;
            String T_NCM_CostCalResult = null;
            String T_NCM_CostRecoveryReportByEnd = null;
            T_NCM_DataByCostObj = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_DataByCostObj", anaPeriods);
            if (costType == CostTypeEnum.factCost) {
                T_NCM_CostCalResult = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostCalResult", anaPeriods);
            } else if (costType == CostTypeEnum.factCostAfterRec) {
                T_NCM_CostRecoveryReportByEnd = BIRptCommonUtil.getPhysicalTblName(ctx, companyId, "T_NCM_CostRecoveryReportByEnd", anaPeriods);
            }
            ss.setCaller(TrendAnalyseFacadeControllerBean.class);
            ss.setFilename("TrendAnalyseOLAPSchema.xml");
            StringBuffer ksql = null;
            String where = null;
            ksql = new StringBuffer();
            if (costType == CostTypeEnum.factCost) {
                ksql.append("select").append(CRLF);
                ksql.append("dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID,").append(CRLF);
                ksql.append("dataResult.FCOSTCENTERID,").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("dataResult.FCOSTITEMID,").append(CRLF);
                ksql.append("dataResult.FFinishedAmount/dataByCo.FFinishedQty").append(CRLF);
                ksql.append("as FUnitCost,").append(CRLF);
                ksql.append("dataByCo.FFinishedQty").append(CRLF);
                ksql.append("as FFinishedQty,").append(CRLF);
                ksql.append("dataResult.FFinishedAmount").append(CRLF);
                ksql.append("as FFinishedAmount").append(CRLF);
                ksql.append("from").append(CRLF);
                ksql.append(T_NCM_CostCalResult).append(" dataResult").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTCENTERID = dataByCo.FCOSTCENTERID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
                ksql.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", periodIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("    ").append("dataByCo.FFinishedQty > 0 and dataResult.FFinishedAmount > 0").append(CRLF);
                if (ccIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTCENTERID", ccIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (coIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (ciIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
            } else {
                StringBuffer tbDataResult = new StringBuffer();
                tbDataResult.append("select").append(CRLF);
                tbDataResult.append("FCOMPANYID, FCALCULATEPERIODID, FCOSTOBJECTID, FCOSTITEMID,").append(CRLF);
                tbDataResult.append("FAfterUnitAmount  FFinishedAmount").append(CRLF);
                tbDataResult.append("from").append(CRLF);
                tbDataResult.append(T_NCM_CostRecoveryReportByEnd).append(CRLF);
                tbDataResult.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("FCOMPANYID", companyIds);
                tbDataResult.append("    ").append(where).append(CRLF);
                tbDataResult.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("FCALCULATEPERIODID", periodIds);
                tbDataResult.append("    ").append(where).append(CRLF);
                tbDataResult.append("and").append(CRLF);
                tbDataResult.append("    ").append("FMaterialID IS NULL").append(CRLF);
                if (coIds.size() > 0) {
                    tbDataResult.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTOBJECTID", coIds);
                    tbDataResult.append("    ").append(where).append(CRLF);
                }
                if (ciIds.size() > 0) {
                    tbDataResult.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("FCOSTITEMID", ciIds);
                    tbDataResult.append("    ").append(where).append(CRLF);
                }
                ksql.append("select").append(CRLF);
                ksql.append("dataResult.FCOMPANYID,").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID,").append(CRLF);
                ksql.append("dataByCo.FCOSTCENTERID,").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID,").append(CRLF);
                ksql.append("dataResult.FCOSTITEMID,").append(CRLF);
                ksql.append("dataResult.FFinishedAmount as FUnitCost,").append(CRLF);
                ksql.append("dataByCo.FFinishedQty").append(CRLF);
                ksql.append("as FFinishedQty,").append(CRLF);
                ksql.append("dataResult.FFinishedAmount * dataByCo.FFinishedQty").append(CRLF);
                ksql.append("as FFinishedAmount").append(CRLF);
                ksql.append("from").append(CRLF);
                ksql.append("(" + tbDataResult + ")").append(" dataResult").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append(T_NCM_DataByCostObj).append(" dataByCo").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOMPANYID = dataByCo.FCOMPANYID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCALCULATEPERIODID = dataByCo.FCALCULATEPERIODID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = dataByCo.FCOSTOBJECTID").append(CRLF);
                ksql.append("join").append(CRLF);
                ksql.append("T_BD_CostObject co").append(CRLF);
                ksql.append("on").append(CRLF);
                ksql.append("dataResult.FCOSTOBJECTID = co.FID").append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("co.FCalculateMode <> ").append(3).append(CRLF);
                ksql.append("where").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOMPANYID", companyIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCALCULATEPERIODID", periodIds);
                ksql.append("    ").append(where).append(CRLF);
                ksql.append("and").append(CRLF);
                ksql.append("    ").append("dataResult.FFinishedAmount > 0").append(CRLF);
                if (ccIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataByCo.FCOSTCENTERID", ccIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (coIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTOBJECTID", coIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
                if (ciIds.size() > 0) {
                    ksql.append("and").append(CRLF);
                    where = BIRptCommonUtil.buildSQLWhereEqual("dataResult.FCOSTITEMID", ciIds);
                    ksql.append("    ").append(where).append(CRLF);
                }
            }
            conn = EJBFactory.getConnection((Context)ctx);
            String insertSelect = ksql.toString();
            String T_NCM_FACT = null;
            ksql = new StringBuffer();
            ksql.append("CREATE TABLE T_TMP_FactData ( \n");
            ksql.append("    FCompanyID    \t          VARCHAR(44), \n");
            ksql.append("    FCALCULATEPERIODID       VARCHAR(44), \n");
            ksql.append("    FCostCenterID \t          VARCHAR(44), \n");
            ksql.append("    FCostObjectID \t          VARCHAR(44), \n");
            ksql.append("    FCostItemID              VARCHAR(44), \n");
            ksql.append("    FUnitCost                NUMERIC(28,12), \n");
            ksql.append("    FFinishedQty             NUMERIC(28,9), \n");
            ksql.append("    FFinishedAmount          NUMERIC(28,9) \n");
            ksql.append(") \n");
            T_NCM_FACT = this.createTempTable(ctx, ss, ksql.toString());
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, T_NCM_FACT);
            ksql = new StringBuffer();
            ksql.append("insert into " + T_NCM_FACT).append(CRLF);
            ksql.append(insertSelect).append(CRLF);
            if (coIds.size() > 0) {
                DbUtil.execute((Context)ctx, (String)ksql.toString());
            }
            ksql = new StringBuffer();
            ksql.append("select * from ").append(T_NCM_FACT);
            ss.setDataItem("T_NCM_FACT", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("cc.FID, cc.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(cc.FNumber, ' '),").append(CRLF);
            ksql.append("cc.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_ORG_CostCenter cc").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("cc.FID in (select distinct FCostCenterID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_ORG_CostCenter", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select ").append(CRLF);
            ksql.append("co.FID, co.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(co.FNumber, ' '),").append(CRLF);
            ksql.append("co.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName,").append(CRLF);
            ksql.append("ISNULL(ma.Fmodel, ' ') as Fmodel,").append(CRLF);
            ksql.append("ISNULL(co.Fbatchnumber, ' ') as Fbatchnumber,").append(CRLF);
            ksql.append("ISNULL(co.FOrderNumber, ' ') as FOrderNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FNumber, ' ') as FMaterialNumber,").append(CRLF);
            ksql.append("ISNULL(ma.FName_" + loc + ", ' ') as FMaterialName,").append(CRLF);
            ksql.append("ISNULL(p.FNumber, ' ') as FProjectNumber,").append(CRLF);
            ksql.append("ISNULL(t.FNumber, ' ') as FTrackNumber,").append(CRLF);
            ksql.append("LEFT('#,##0.000000000000000000000', ma.FPricePrecision+6) as FPricePrecision,").append(CRLF);
            ksql.append("LEFT('#,##0.000000000000000000000', mu.FQtyPrecision+6) as FQtyPrecision").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_BD_CostObject co").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_Material ma").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("co.FStdProductIDID = ma.FID").append(CRLF);
            ksql.append("join").append(CRLF);
            ksql.append("T_BD_MeasureUnit mu").append(CRLF);
            ksql.append("on").append(CRLF);
            ksql.append("ma.FBaseUnit = mu.FID").append(CRLF);
            ksql.append("left join T_MM_Project p ").append(CRLF);
            ksql.append("on p.FID = co.FProjectID ").append(CRLF);
            ksql.append("left join T_MM_TrackNumber t ").append(CRLF);
            ksql.append("on t.FID = co.FTrackID ").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("co.FID in (select distinct FCostObjectID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_BD_CostObject", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("ci.FID, ci.FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(ci.FNumber, ' '),").append(CRLF);
            ksql.append("ci.FNAME_").append(loc).append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FName").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_NCM_CostItem ci").append(CRLF);
            ksql.append("where").append(CRLF);
            ksql.append("ci.FID in (select distinct FCostItemID from " + T_NCM_FACT + ")");
            ss.setDataItem("T_NCM_CostItem", ksql.toString(), null);
            ksql = new StringBuffer();
            ksql.append("select").append(CRLF);
            ksql.append("FID, FNumber,").append(CRLF);
            ksql.append("CONCAT(").append(CRLF);
            ksql.append("CONCAT(TOCHAR(FPeriodYear), '").append(ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"YEAR", (Locale)ctx.getLocale())).append("'),").append(CRLF);
            ksql.append("CONCAT(TOCHAR(FPeriodNumber), '").append(ResourceBase.getString((String)COST_ANALYSE_RESOURCE_PATH, (String)"PERIOD", (Locale)ctx.getLocale())).append("')").append(CRLF);
            ksql.append(")").append(CRLF);
            ksql.append("as FPeriod").append(CRLF);
            ksql.append("from").append(CRLF);
            ksql.append("T_BD_Period").append(CRLF);
            ksql.append("where").append(CRLF);
            where = BIRptCommonUtil.buildSQLWhereEqual("FID", periodIds);
            ksql.append(where).append(CRLF);
            ss.setDataItem("T_BD_Period", ksql.toString(), null);
            StringBuffer mdx = new StringBuffer();
            mdx.append("select").append(CRLF);
            mdx.append("non empty {").append(CRLF);
            mdx.append("    {[Measures].members}").append(CRLF);
            mdx.append("    *").append(CRLF);
            mdx.append("    {[Period].members, [Period].[average]}").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("ON COLUMNS,").append(CRLF);
            mdx.append("non empty {").append(CRLF);
            mdx.append("    {[CostCenter].members} *").append(CRLF);
            mdx.append("    {[CostObject].members}").append(CRLF);
            mdx.append("    *").append(CRLF);
            mdx.append("    {[CostItem].members, [CostItem].[total]}").append(CRLF);
            mdx.append("}").append(CRLF);
            mdx.append("Dimension properties").append(CRLF);
            mdx.append("    [CostObject].[CostBatch],").append(CRLF);
            mdx.append("    [CostObject].[CostModel],").append(CRLF);
            mdx.append("    [CostObject].[MaterialName],").append(CRLF);
            mdx.append("    [CostObject].[MaterialNumber],").append(CRLF);
            mdx.append("    [CostObject].[TrackNumber],").append(CRLF);
            mdx.append("    [CostObject].[ProjectNumber],").append(CRLF);
            mdx.append("    [CostObject].[OrderNumber]").append(CRLF);
            mdx.append("ON ROWS").append(CRLF);
            mdx.append("from CostCube").append(CRLF);
            ss.setMdx(mdx.toString());
            schemaSource = ss;
        }
        catch (BOSException e) {
            try {
                super.releaseTables(ctx, ss);
                throw e;
                catch (EASBizException e2) {
                    super.releaseTables(ctx, ss);
                    throw e2;
                }
                catch (Exception e3) {
                    super.releaseTables(ctx, ss);
                    logger.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return schemaSource;
    }
}

