/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.util.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BIRptCommonUtil {
    private static Logger logger = Logger.getLogger((String)BIRptCommonUtil.class.getName());

    public static final String buildSqlIds(Context ctx, RptParams params, String key) {
        Assert.that((String)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"170_BIRptCommonUtil", (Locale)ctx.getLocale()), (params != null ? 1 : 0) != 0);
        Assert.that((String)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"171_BIRptCommonUtil", (Locale)ctx.getLocale()), (!StringUtils.isEmpty((String)key) ? 1 : 0) != 0);
        Object objValue = params.getObjectElement(key);
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof IObjectValue) {
            IObjectValue value = (IObjectValue)objValue;
            if (value.get("id") != null) {
                return "('" + value.get("id").toString() + "')";
            }
            return null;
        }
        if (objValue instanceof IObjectCollection) {
            IObjectCollection objectCol = (IObjectCollection)objValue;
            if (objectCol.size() > 0) {
                StringBuffer inIds = new StringBuffer("(");
                int size = objectCol.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue value = objectCol.getObject(i);
                    if (i != size - 1) {
                        inIds.append("'" + value.get("id").toString() + "',");
                        continue;
                    }
                    inIds.append("'" + value.get("id").toString() + "'");
                }
                inIds.append(")");
                return inIds.toString();
            }
            return null;
        }
        if (objValue instanceof Object[]) {
            Object[] objectArray = (Object[])objValue;
            if (objectArray.length > 0) {
                StringBuffer inIds = new StringBuffer("(");
                int size = objectArray.length;
                for (int i = 0; i < size; ++i) {
                    Object value = objectArray[i];
                    if (value == null) {
                        return null;
                    }
                    Assert.that((String)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"172_BIRptCommonUtil", (Locale)ctx.getLocale()), (boolean)(value instanceof IObjectValue));
                    IObjectValue objectValue = (IObjectValue)value;
                    if (i != size - 1) {
                        inIds.append("'" + objectValue.get("id").toString() + "',");
                        continue;
                    }
                    inIds.append("'" + objectValue.get("id").toString() + "'");
                }
                inIds.append(")");
                return inIds.toString();
            }
            return null;
        }
        throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"173_BIRptCommonUtil", (Locale)ctx.getLocale()));
    }

    public static final String buildPeriodIds(Context ctx, RptParams params, String spinnerYearFrom, String spinnerMonthFrom, String spinnerYearTo, String spinnerMonthTo, String spPeriod) throws BOSException {
        int i;
        Assert.that((ctx != null ? 1 : 0) != 0);
        Assert.that((params != null ? 1 : 0) != 0);
        HashMap periodIdsMap = new HashMap();
        int periodFrom = -1;
        int periodTo = -1;
        if (params.getObjectElement(spPeriod) instanceof Object[][] && ((Object[][])params.getObjectElement(spPeriod)).length > 0) {
            Object[][] periods = (Object[][])params.getObjectElement(spPeriod);
            PeriodInfo period = null;
            for (i = 0; i < periods.length; ++i) {
                period = (PeriodInfo)periods[i][0];
                periodFrom = period.getNumber();
                period = (PeriodInfo)periods[i][1];
                periodTo = period.getNumber();
                BIRptCommonUtil.getPeriodIds(ctx, periodFrom, periodTo, periodIdsMap);
            }
        } else {
            Integer fromYear = (Integer)params.getObjectElement(spinnerYearFrom);
            Integer toYear = (Integer)params.getObjectElement(spinnerYearTo);
            Integer fromMonth = (Integer)params.getObjectElement(spinnerMonthFrom);
            Integer toMonth = (Integer)params.getObjectElement(spinnerMonthTo);
            String fromMonthStr = fromMonth < 10 ? "0" + String.valueOf(fromMonth) : String.valueOf(fromMonth);
            String toMonthStr = toMonth < 10 ? "0" + String.valueOf(toMonth) : String.valueOf(toMonth);
            periodFrom = Integer.valueOf(String.valueOf(fromYear) + fromMonthStr);
            periodTo = Integer.valueOf(String.valueOf(toYear) + toMonthStr);
            BIRptCommonUtil.getPeriodIds(ctx, periodFrom, periodTo, periodIdsMap);
        }
        if (periodIdsMap.isEmpty()) {
            return null;
        }
        Object[] ids = periodIdsMap.keySet().toArray();
        StringBuffer inIds = new StringBuffer("(");
        int size = ids.length;
        for (i = 0; i < size; ++i) {
            Object value = ids[i];
            if (value == null) {
                return null;
            }
            if (i != size - 1) {
                inIds.append("'" + ids[i].toString() + "',");
                continue;
            }
            inIds.append("'" + ids[i].toString() + "'");
        }
        inIds.append(")");
        return inIds.toString();
    }

    public static final String getPhysicalTblName(Context ctx, RptParams params, String companyId, String bizTblName, String spinnerYearFrom, String spinnerMonthFrom, String spinnerYearTo, String spinnerMonthTo, String spPeriod) throws Exception {
        Assert.that((ctx != null ? 1 : 0) != 0);
        Assert.that((params != null ? 1 : 0) != 0);
        Assert.that((!StringUtils.isEmpty((String)companyId) ? 1 : 0) != 0);
        Assert.that((!StringUtils.isEmpty((String)bizTblName) ? 1 : 0) != 0);
        int periodFrom = -1;
        int periodTo = -1;
        if (params.getObjectElement(spPeriod) instanceof Object[][] && ((Object[][])params.getObjectElement(spPeriod)).length > 0) {
            Object[][] periods = (Object[][])params.getObjectElement(spPeriod);
            PeriodInfo period = null;
            for (int i = 0; i < periods.length; ++i) {
                period = (PeriodInfo)periods[i][0];
                if (periodFrom == -1) {
                    periodFrom = period.getNumber();
                } else if (period.getNumber() < periodFrom) {
                    periodFrom = period.getNumber();
                }
                period = (PeriodInfo)periods[i][1];
                if (periodTo == -1) {
                    periodTo = period.getNumber();
                    continue;
                }
                if (period.getNumber() <= periodTo) continue;
                periodTo = period.getNumber();
            }
        } else {
            Integer fromYear = (Integer)params.getObjectElement(spinnerYearFrom);
            Integer toYear = (Integer)params.getObjectElement(spinnerYearTo);
            Integer fromMonth = (Integer)params.getObjectElement(spinnerMonthFrom);
            Integer toMonth = (Integer)params.getObjectElement(spinnerMonthTo);
            String fromMonthStr = fromMonth < 10 ? "0" + String.valueOf(fromMonth) : String.valueOf(fromMonth);
            String toMonthStr = toMonth < 10 ? "0" + String.valueOf(toMonth) : String.valueOf(toMonth);
            periodFrom = Integer.valueOf(String.valueOf(fromYear) + fromMonthStr);
            periodTo = Integer.valueOf(String.valueOf(toYear) + toMonthStr);
        }
        String physicalTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)bizTblName, (int)periodFrom, (int)periodTo);
        return physicalTblName;
    }

    private static void getPeriodIds(Context ctx, int periodFrom, int periodTo, Map periodIdsMap) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT DISTINCT FID \n");
        kSql.append("   FROM T_BD_Period \n");
        kSql.append("  WHERE FNumber >= ? and FNumber <= ? \n");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{periodFrom, periodTo});
        try {
            while (rst.next()) {
                periodIdsMap.put(rst.getString(1), null);
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    public static String buildDefaultCostCenterIds(Context ctx, String companyId) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ccCol = null;
        try {
            ccCol = iOUR.getFromUnit(companyId, 1, 5);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (ccCol == null || ccCol.size() == 0) {
            return null;
        }
        StringBuffer inIds = new StringBuffer("(");
        int size = ccCol.size();
        for (int i = 0; i < size; ++i) {
            String ccId = ccCol.get(i).getId().toString();
            if (i != size - 1) {
                inIds.append("'" + ccId + "',");
                continue;
            }
            inIds.append("'" + ccId + "'");
        }
        inIds.append(")");
        return inIds.toString();
    }

    public static String buildDefaultCostObjectIds(Context ctx, String companyId) throws BOSException, EASBizException {
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        CostObjectCollection coCol = null;
        try {
            coCol = iCostObject.getCostObjectCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (coCol == null || coCol.size() == 0) {
            return null;
        }
        StringBuffer inIds = new StringBuffer("(");
        int size = coCol.size();
        for (int i = 0; i < size; ++i) {
            String ccId = coCol.get(i).getId().toString();
            if (i != size - 1) {
                inIds.append("'" + ccId + "',");
                continue;
            }
            inIds.append("'" + ccId + "'");
        }
        inIds.append(")");
        return inIds.toString();
    }

    public static String buildDefaultCostItemIds(Context ctx, String companyId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
            ObjectUuidPK cuPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            filter = CostItemFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        }
        view.setFilter(filter);
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
        CostItemCollection ciCol = null;
        try {
            ciCol = iCostItem.getCostItemCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (ciCol == null || ciCol.size() == 0) {
            return null;
        }
        StringBuffer inIds = new StringBuffer("(");
        int size = ciCol.size();
        for (int i = 0; i < size; ++i) {
            String ccId = ciCol.get(i).getId().toString();
            if (i != size - 1) {
                inIds.append("'" + ccId + "',");
                continue;
            }
            inIds.append("'" + ccId + "'");
        }
        inIds.append(")");
        return inIds.toString();
    }

    public static Set getDefaultCostCenterIds(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection col = null;
        try {
            col = iOUR.getFromUnit(companyId, 1, 5);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (col == null || col.size() == 0) {
            return ids;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String id = col.get(i).getId().toString();
            ids.add(id);
        }
        return ids;
    }

    public static Set getDefaultCostObjectIds(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        CostObjectCollection col = null;
        try {
            col = iCostObject.getCostObjectCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (col == null || col.size() == 0) {
            return ids;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String id = col.get(i).getId().toString();
            ids.add(id);
        }
        return ids;
    }

    public static Set getCostObjectIds(Context ctx, String companyId, RptParams params) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        Set costObjectIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtCostObject.value");
        Set orderIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtOrder.value");
        Set projectIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtProject.value");
        Set trackIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtTrack.value");
        Set materialIds = BIRptCommonUtil.getObjectIds(ctx, params, "prmtMaterial.value");
        String batch = null;
        Object temp = params.getObjectElement("tfBatch.value");
        if (temp != null && temp.toString().length() > 0) {
            batch = temp.toString();
        }
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        if (costObjectIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectIds, CompareType.INCLUDE));
        }
        if (orderIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("orderID", (Object)orderIds, CompareType.INCLUDE));
        }
        if (projectIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("projectID", (Object)projectIds, CompareType.INCLUDE));
        }
        if (trackIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("trackID", (Object)trackIds, CompareType.INCLUDE));
        }
        if (materialIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialIds, CompareType.INCLUDE));
        }
        if (batch != null) {
            filter.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)batch, CompareType.EQUALS));
        }
        view.setFilter(filter);
        CostObjectCollection col = null;
        try {
            col = iCostObject.getCostObjectCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (col == null || col.size() == 0) {
            return ids;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String id = col.get(i).getId().toString();
            ids.add(id);
        }
        return ids;
    }

    public static Set getDefaultCostItemIds(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
            ObjectUuidPK cuPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            filter = CostItemFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        }
        view.setFilter(filter);
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
        CostItemCollection col = null;
        try {
            col = iCostItem.getCostItemCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
        }
        if (col == null || col.size() == 0) {
            return ids;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String id = col.get(i).getId().toString();
            ids.add(id);
        }
        return ids;
    }

    public static List getPeriods(RptParams params, String keyYearFrom, String keyMonthFrom, String keyYearTo, String keyMonthTo, String keyAdvancePeriod) throws BOSException {
        ArrayList<AnaPeriod> anaPeriods = new ArrayList<AnaPeriod>();
        Object temp = params.getObjectElement(keyAdvancePeriod);
        if (temp instanceof Object[][] && ((Object[][])temp).length > 0) {
            Object[][] periods = (Object[][])temp;
            for (int i = 0; i < periods.length; ++i) {
                AnaPeriod anaPeriod = new AnaPeriod();
                anaPeriod.periodFrom = ((PeriodInfo)periods[i][0]).getNumber();
                anaPeriod.periodTo = ((PeriodInfo)periods[i][1]).getNumber();
                anaPeriods.add(anaPeriod);
            }
        } else {
            Integer yearFrom = (Integer)params.getObjectElement(keyYearFrom);
            Integer monthFrom = (Integer)params.getObjectElement(keyMonthFrom);
            Integer yearTo = (Integer)params.getObjectElement(keyYearTo);
            Integer monthTo = (Integer)params.getObjectElement(keyMonthTo);
            AnaPeriod anaPeriod = new AnaPeriod();
            anaPeriod.periodFrom = BIRptCommonUtil.getNumberOfPeriod(yearFrom, monthFrom);
            anaPeriod.periodTo = BIRptCommonUtil.getNumberOfPeriod(yearTo, monthTo);
            anaPeriods.add(anaPeriod);
        }
        return anaPeriods;
    }

    public static Set getPeriodIds(Context ctx, List anaPeriods) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        if (anaPeriods.size() == 0) {
            return ids;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append("SELECT DISTINCT FID \n");
        kSql.append("FROM T_BD_Period \n");
        kSql.append("WHERE \n");
        Object[] sqlParams = new Object[anaPeriods.size() * 2];
        AnaPeriod period = null;
        for (int i = 0; i < anaPeriods.size(); ++i) {
            kSql.append("(FNumber >= ? and FNumber <= ?)");
            if (i != anaPeriods.size() - 1) {
                kSql.append(" or ");
            }
            kSql.append(" \n");
            period = (AnaPeriod)anaPeriods.get(i);
            sqlParams[i * 2] = period.periodFrom;
            sqlParams[i * 2 + 1] = period.periodTo;
        }
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])sqlParams);
        try {
            while (rst.next()) {
                ids.add(rst.getString(1));
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return ids;
    }

    public static final String getPhysicalTblName(Context ctx, String companyId, String bizTblName, List anaPeriods) throws Exception {
        Assert.that((ctx != null ? 1 : 0) != 0);
        Assert.that((!StringUtils.isEmpty((String)companyId) ? 1 : 0) != 0);
        Assert.that((!StringUtils.isEmpty((String)bizTblName) ? 1 : 0) != 0);
        int periodFrom = Integer.MAX_VALUE;
        int periodTo = Integer.MIN_VALUE;
        for (AnaPeriod anaPeriod : anaPeriods) {
            if (anaPeriod.periodFrom < periodFrom) {
                periodFrom = anaPeriod.periodFrom;
            }
            if (anaPeriod.periodTo <= periodTo) continue;
            periodTo = anaPeriod.periodTo;
        }
        String physicalTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)bizTblName, (int)periodFrom, (int)periodTo);
        return physicalTblName;
    }

    public static Set getObjectIds(Context ctx, RptParams params, String key) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        Object temp = params.getObjectElement(key);
        if (temp == null) {
            return ids;
        }
        if (temp instanceof IObjectValue) {
            IObjectValue value = (IObjectValue)temp;
            if (value.get("id") != null) {
                ids.add(value.get("id").toString());
            }
        } else if (temp instanceof IObjectCollection) {
            IObjectCollection objectCol = (IObjectCollection)temp;
            for (IObjectValue value : objectCol) {
                if (value.get("id") == null) continue;
                ids.add(value.get("id").toString());
            }
        } else if (temp instanceof Object[]) {
            for (Object object : (Object[])temp) {
                if (object == null) continue;
                Assert.that((String)ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"172_BIRptCommonUtil", (Locale)ctx.getLocale()), (boolean)(object instanceof IObjectValue));
                IObjectValue value = (IObjectValue)object;
                if (value.get("id") == null) continue;
                ids.add(value.get("id").toString());
            }
        } else {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"174_BIRptCommonUtil", (Locale)ctx.getLocale()));
        }
        return ids;
    }

    public static String buildSQLWhereIn(String column, Set values) {
        if (values.size() == 0) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        String link = ", ";
        sql.append("(");
        sql.append(column).append(" in ");
        sql.append("(");
        Iterator it = values.iterator();
        while (it.hasNext()) {
            sql.append("'").append(it.next()).append("'").append(link);
        }
        sql.delete(sql.length() - link.length(), sql.length());
        sql.append(")");
        sql.append(")");
        return sql.toString();
    }

    public static String buildSQLWhereEqual(String column, Set values) {
        if (values.size() == 0) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        String link = " or ";
        sql.append("(");
        Iterator it = values.iterator();
        while (it.hasNext()) {
            sql.append(column).append(" = '").append(it.next()).append("'").append(link);
        }
        sql.delete(sql.length() - link.length(), sql.length());
        sql.append(")");
        return sql.toString();
    }

    public static int getNumberOfPeriod(int periodYear, int periodNumber) {
        if (periodYear < 0 || periodYear > 9999) {
            periodYear = 0;
        }
        periodYear *= 100;
        if (periodNumber < 0 || periodNumber > 13) {
            periodNumber = 0;
        }
        return periodYear + periodNumber;
    }

    public static class AnaPeriod {
        public int periodFrom;
        public int periodTo;
    }
}

