/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.formula.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ncm.cal.report.formula.CompanyPeriodInfo;
import com.kingdee.eas.ncm.cal.report.formula.FormulaTypeEnum;
import com.kingdee.eas.ncm.cal.report.formula.PhysicalTblNameInfo;
import com.kingdee.eas.ncm.cal.report.formula.app.AbstractNCMRptFormulaFacadeControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.OrgUnitUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NCMRptFormulaFacadeControllerBean
extends AbstractNCMRptFormulaFacadeControllerBean {
    private static final long serialVersionUID = -2254276048114056845L;
    private static Logger logger = Logger.getLogger((String)NCMRptFormulaFacadeControllerBean.class.getName());

    @Override
    protected Object _getCostItemData(Context ctx, ICalculateContextProvider rptCalcuCtx, String companyNumber, String year, String period, String[] costCenterNumbers, String[] costObjectNumbers, String[] costItemNumbers, String formulaType) throws BOSException, EASBizException {
        long diff;
        Timestamp ts2;
        Timestamp ts1;
        BigDecimal retValue = new BigDecimal("0");
        if (StringUtils.isEmpty((String)companyNumber) || StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period) || costCenterNumbers == null || costCenterNumbers.length == 0 || costObjectNumbers == null || costObjectNumbers.length == 0 || StringUtils.isEmpty((String)formulaType)) {
            return retValue;
        }
        Map companyPeriodMap = new HashMap();
        Map costCalPrdDetailResultTblMap = new HashMap();
        Map balanceTblMap = new HashMap();
        Map balanceEntryTblMap = new HashMap();
        Map balanceMatDetailTblMap = new HashMap();
        int startPeriod = 0;
        int endPeriod = 0;
        if (ctx.get((Object)"NCM_getCostItemData_Params") instanceof Map) {
            Map rptParams = (Map)ctx.get((Object)"NCM_getCostItemData_Params");
            companyPeriodMap = (Map)rptParams.get("companyPeriodMap");
            costCalPrdDetailResultTblMap = (Map)rptParams.get("costCalPrdDetailResultTblMap");
            balanceTblMap = (Map)rptParams.get("balanceTblMap");
            balanceEntryTblMap = (Map)rptParams.get("balanceEntryTblMap");
            balanceMatDetailTblMap = (Map)rptParams.get("balanceMatDetailTblMap");
            if (rptParams.get("startPeriod") instanceof Integer) {
                startPeriod = (Integer)rptParams.get("startPeriod");
            }
            if (rptParams.get("endPeriod") instanceof Integer) {
                endPeriod = (Integer)rptParams.get("endPeriod");
            }
        }
        CompanyPeriodInfo companyPeriodInfo = (CompanyPeriodInfo)((Object)companyPeriodMap.get(companyNumber));
        String companyId = companyPeriodInfo.getCompanyId();
        costCenterNumbers = this.transCostCenterIds(ctx, costCenterNumbers);
        costObjectNumbers = this.transCostObjectIds(ctx, companyId, costObjectNumbers);
        costItemNumbers = this.transCostItemIds(ctx, companyId, costItemNumbers);
        PeriodInfo sysStartPeriodInfo = companyPeriodInfo.getStartPeriodInfo();
        String key = companyId + "|" + "T_NCM_CostCalPrdDetailResult" + "|" + startPeriod + "|" + endPeriod;
        PhysicalTblNameInfo costCalPrdDetailResultTblInfo = (PhysicalTblNameInfo)((Object)costCalPrdDetailResultTblMap.get(key));
        ArrayList<Object[]> otherParams = new ArrayList<Object[]>();
        if (FormulaTypeEnum.curPeriodFinishQty.getValue().equals(formulaType) || FormulaTypeEnum.curYearFinishQty.getValue().equals(formulaType) || FormulaTypeEnum.lastYearCurPriodFinishQty.getValue().equals(formulaType) || FormulaTypeEnum.lastYearAddFinishQty.getValue().equals(formulaType)) {
            int size1 = costCenterNumbers.length;
            for (int i = 0; i < size1; ++i) {
                int size2 = costObjectNumbers.length;
                for (int j = 0; j < size2; ++j) {
                    Object[] param = new Object[]{costCenterNumbers[i].trim(), costObjectNumbers[j].trim()};
                    otherParams.add(param);
                }
            }
            ts1 = new Timestamp(System.currentTimeMillis());
            String getCurrentTblName = null;
            String getHistoryTblName = null;
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
            try {
                getCurrentTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_DataByCostObj", (int)currPeriod.getNumber(), (int)currPeriod.getNumber());
                getHistoryTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_DataByCostObj_History", (int)(currPeriod.getNumber() - 1), (int)(currPeriod.getNumber() - 1));
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
            BigDecimal resultCurrent = Constants.ZERO;
            if (!EmptyUtil.isEmpty((String)costCalPrdDetailResultTblInfo.getCurrentTblName())) {
                resultCurrent = this.getProductData(ctx, getCurrentTblName, companyId, startPeriod, endPeriod, formulaType, otherParams);
            }
            BigDecimal resultHistory = Constants.ZERO;
            if (!EmptyUtil.isEmpty((String)costCalPrdDetailResultTblInfo.getHistoryTblName())) {
                resultHistory = this.getProductData(ctx, getHistoryTblName, companyId, startPeriod, endPeriod, formulaType, otherParams);
            }
            retValue = resultCurrent.add(resultHistory);
            ts2 = new Timestamp(System.currentTimeMillis());
            diff = ts2.getTime() - ts1.getTime();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"210_NCMRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()) + diff));
        } else {
            int size1 = costCenterNumbers.length;
            for (int i = 0; i < size1; ++i) {
                int size2 = costObjectNumbers.length;
                for (int j = 0; j < size2; ++j) {
                    int size3 = costItemNumbers.length;
                    for (int k = 0; k < size3; ++k) {
                        Object[] param = new Object[]{costCenterNumbers[i].trim(), costObjectNumbers[j].trim(), costItemNumbers[k].trim()};
                        otherParams.add(param);
                    }
                }
            }
            ts1 = new Timestamp(System.currentTimeMillis());
            BigDecimal resultCurrent = Constants.ZERO;
            if (!EmptyUtil.isEmpty((String)costCalPrdDetailResultTblInfo.getCurrentTblName())) {
                resultCurrent = this.getMatData(ctx, costCalPrdDetailResultTblInfo.getCurrentTblName(), companyId, startPeriod, endPeriod, formulaType, otherParams);
            }
            BigDecimal resultHistory = Constants.ZERO;
            if (!EmptyUtil.isEmpty((String)costCalPrdDetailResultTblInfo.getHistoryTblName())) {
                resultHistory = this.getMatData(ctx, costCalPrdDetailResultTblInfo.getHistoryTblName(), companyId, startPeriod, endPeriod, formulaType, otherParams);
            }
            retValue = resultCurrent.add(resultHistory);
            Timestamp ts22 = new Timestamp(System.currentTimeMillis());
            long diff2 = ts22.getTime() - ts1.getTime();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"211_NCMRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()) + diff2));
        }
        int sysStartPeriodNumber = sysStartPeriodInfo.getNumber();
        if (startPeriod - sysStartPeriodNumber >= -1) {
            String balanceTbl;
            BigDecimal initData = new BigDecimal("0");
            if (FormulaTypeEnum.curYearFinishQty.getValue().equals(formulaType)) {
                key = companyId + "|" + "T_NCM_Balance" + "|" + sysStartPeriodNumber + "|" + sysStartPeriodNumber;
                balanceTbl = (String)balanceTblMap.get(key);
                Timestamp ts12 = new Timestamp(System.currentTimeMillis());
                initData = this.getInitProductData(ctx, sysStartPeriodNumber, companyId, formulaType, otherParams, balanceTbl);
                Timestamp ts23 = new Timestamp(System.currentTimeMillis());
                long diff3 = ts23.getTime() - ts12.getTime();
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"212_NCMRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()) + diff3));
            } else if (FormulaTypeEnum.curYearConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.curYearConsumeQty.getValue().equals(formulaType)) {
                key = companyId + "|" + "T_NCM_Balance" + "|" + sysStartPeriodNumber + "|" + sysStartPeriodNumber;
                balanceTbl = (String)balanceTblMap.get(key);
                key = companyId + "|" + "T_NCM_BalanceEntry" + "|" + sysStartPeriodNumber + "|" + sysStartPeriodNumber;
                String balanceEntryTbl = (String)balanceEntryTblMap.get(key);
                key = companyId + "|" + "T_NCM_BalanceMatDetail" + "|" + sysStartPeriodNumber + "|" + sysStartPeriodNumber;
                String balanceMatDetailTbl = (String)balanceMatDetailTblMap.get(key);
                Timestamp ts13 = new Timestamp(System.currentTimeMillis());
                initData = this.getInitMatData(ctx, sysStartPeriodNumber, companyId, formulaType, otherParams, balanceTbl, balanceEntryTbl, balanceMatDetailTbl);
                ts2 = new Timestamp(System.currentTimeMillis());
                diff = ts2.getTime() - ts13.getTime();
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"213_NCMRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()) + diff));
            }
            if (initData instanceof BigDecimal && retValue instanceof BigDecimal) {
                retValue = retValue.add(initData);
            }
        }
        return retValue;
    }

    private BigDecimal getMatData(Context ctx, String physicalTbl, final String companyId, final int startPeriod, final int endPeriod, String formulaType, List otherParams) throws BOSException, EASBizException {
        BigDecimal retValue = new BigDecimal("0");
        final boolean isGetAmt = FormulaTypeEnum.curPeriodConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.curYearConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.lastYearCurPriodConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.lastYearAddConsumeAmt.getValue().equals(formulaType);
        StringBuffer kSql = new StringBuffer();
        if (isGetAmt) {
            kSql.append(" SELECT ISNULL(SUM(ISNULL(periodDetail.FFinishedQty, 0)),0) FTotalConsumeQty,   \n");
            kSql.append("        ISNULL(SUM(ISNULL(periodDetail.FFinishedAmount, 0)),0) FTotalCostAmt   \n");
            kSql.append("   FROM " + physicalTbl + " periodDetail --T_NCM_CostCalperiodDetailResult   \n");
            kSql.append("   \t   INNER JOIN T_BD_Period period    \n");
            kSql.append("   \t       on periodDetail.FCalculatePeriodID = period.FID   \n");
            kSql.append("  WHERE periodDetail.FCompanyID = ?   \n");
            kSql.append("    and period.FNumber >= ?");
            kSql.append("    and period.FNumber <= ?");
            kSql.append("    and ( ");
        } else {
            kSql.append(" SELECT ISNULL(SUM(ISNULL(periodDetail.FFinishedQty, 0)),0) FTotalConsumeQty,   \n");
            kSql.append("        ISNULL(SUM(ISNULL(periodDetail.FFinishedAmount, 0)),0) FTotalCostAmt   \n");
            kSql.append("   FROM (");
            kSql.append("   select distinct FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FCostItemID,FFinishedQty,0 as FFinishedAmount  from " + physicalTbl + ") as  ");
            kSql.append(" periodDetail --T_NCM_CostCalperiodDetailResult   \n");
            kSql.append("   \t   INNER JOIN T_BD_Period period    \n");
            kSql.append("   \t       on periodDetail.FCalculatePeriodID = period.FID   \n");
            kSql.append("  WHERE periodDetail.FCompanyID = ?   \n");
            kSql.append("    and period.FNumber >= ?");
            kSql.append("    and period.FNumber <= ?");
            kSql.append("    and ( ");
        }
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" (periodDetail.FCostCenterID = ? AND periodDetail.FCostObjectID = ?  AND periodDetail.FCostItemID = ?) ");
                continue;
            }
            kSql.append(" OR (periodDetail.FCostCenterID = ? AND periodDetail.FCostObjectID = ?  AND periodDetail.FCostItemID = ?) ");
        }
        kSql.append(" )");
        final ArrayList calcus = new ArrayList();
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), (List)otherParams, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, companyId);
                ps.setInt(2, startPeriod);
                ps.setInt(3, endPeriod);
                return 3;
            }

            public void processRow(ResultSet rs) throws SQLException {
                if (isGetAmt) {
                    calcus.add(rs.getBigDecimal("FTotalCostAmt"));
                } else {
                    calcus.add(rs.getBigDecimal("FTotalConsumeQty"));
                }
            }
        });
        int size = calcus.size();
        for (int i = 0; i < size; ++i) {
            retValue = retValue.add((BigDecimal)calcus.get(i));
        }
        return retValue;
    }

    private BigDecimal getProductData(Context ctx, String physicalTbl, final String companyId, final int startPeriod, final int endPeriod, String formulaType, List otherParams) throws BOSException, EASBizException {
        BigDecimal retValue = new BigDecimal("0");
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT ISNULL(SUM(FTotalFinishedQty),0)  as FTotalFinishedQty \n");
        kSql.append("   FROM (SELECT DISTINCT periodDetail.FCostCenterID,  \n");
        kSql.append("                         periodDetail.FCalculatePeriodID,  \n");
        kSql.append("                         periodDetail.FCostObjectID,  \n");
        kSql.append("                         ISNULL(periodDetail.FFinishedQty, 0) as FTotalFinishedQty  \n");
        kSql.append("           FROM " + physicalTbl + " periodDetail   \n");
        kSql.append("          \tINNER JOIN T_BD_Period period   \n");
        kSql.append("          \t\ton periodDetail.FCalculatePeriodID = period.FID  \n");
        kSql.append("          WHERE periodDetail.FCompanyID = ?  \n");
        kSql.append("            AND period.FNumber >= ?  \n");
        kSql.append("            AND period.FNumber <= ?  \n");
        kSql.append("            AND (  \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" (periodDetail.FCostCenterID = ? AND periodDetail.FCostObjectID = ? ) ");
                continue;
            }
            kSql.append(" OR (periodDetail.FCostCenterID = ? AND periodDetail.FCostObjectID = ? ) ");
        }
        kSql.append(" )) a ");
        final ArrayList calcus = new ArrayList();
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), (List)otherParams, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, companyId);
                ps.setInt(2, startPeriod);
                ps.setInt(3, endPeriod);
                return 3;
            }

            public void processRow(ResultSet rs) throws SQLException {
                calcus.add(rs.getBigDecimal("FTotalFinishedQty"));
            }
        });
        int size = calcus.size();
        for (int i = 0; i < size; ++i) {
            retValue = retValue.add((BigDecimal)calcus.get(i));
        }
        return retValue;
    }

    private BigDecimal getInitMatData(Context ctx, final int sysStartPeriod, final String companyId, String formulaType, List otherParams, String balanceTbl, String balanceEntryTbl, String balanceMatDetailTbl) throws BOSException, EASBizException {
        BigDecimal retValue = new BigDecimal("0");
        final boolean isGetAmt = FormulaTypeEnum.curYearConsumeAmt.getValue().equals(formulaType);
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT ISNULL(SUM(finishAmount), 0) as finishAmount,\n");
        kSql.append("        ISNULL(SUM(finishQty), 0) as finishQty \n");
        kSql.append("   FROM (SELECT ISNULL(balanceEntry.FYTDFinishAmount, 0) as finishAmount, \n");
        kSql.append("                ISNULL(SUM(ISNULL(matDetail.FYTDFinishedMatQ, 0)), 0) as finishQty \n");
        kSql.append("           FROM " + balanceTbl + " balance --T_NCM_Balance \n");
        kSql.append("              INNER JOIN " + balanceEntryTbl + " balanceEntry --T_NCM_BalanceEntry \n");
        kSql.append("                 on balance.fid = balanceEntry.Fparentid \n");
        kSql.append("              LEFT OUTER JOIN " + balanceMatDetailTbl + " matDetail --T_NCM_BalanceMatDetail  \n");
        kSql.append("                 on balanceEntry.Fid = matDetail.Fparentid \n");
        kSql.append("              INNER JOIN T_BD_Period period on balance.FCalculatePeriodID = \n");
        kSql.append("                                           period.FID\n");
        kSql.append("  WHERE balance.FCompanyOrg = ?   \n");
        kSql.append("    AND period.FNumber = ?");
        kSql.append("    AND ( ");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" (balance.FCostCenterID = ? AND balance.FCostObjectID = ?  AND balanceEntry.FCostItemID = ?) ");
                continue;
            }
            kSql.append(" or (balance.FCostCenterID = ? AND balance.FCostObjectID = ?  AND balanceEntry.FCostItemID = ?) ");
        }
        kSql.append(" )");
        kSql.append("          GROUP BY balance.FCompanyOrg, \n");
        kSql.append("                   balance.FCalculatePeriodID, \n");
        kSql.append("                   balance.FCostCenterID, \n");
        kSql.append("                   balance.FCostObjectID, \n");
        kSql.append("                   balanceEntry.FCostItemID, \n");
        kSql.append("                   balanceEntry.FYTDFinishAmount) a \n");
        final ArrayList calcus = new ArrayList();
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), (List)otherParams, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, companyId);
                ps.setInt(2, sysStartPeriod);
                return 2;
            }

            public void processRow(ResultSet rs) throws SQLException {
                if (isGetAmt) {
                    calcus.add(rs.getBigDecimal("finishAmount"));
                } else {
                    calcus.add(rs.getBigDecimal("finishQty"));
                }
            }
        });
        int size = calcus.size();
        for (int i = 0; i < size; ++i) {
            retValue = retValue.add((BigDecimal)calcus.get(i));
        }
        return retValue;
    }

    private BigDecimal getInitProductData(Context ctx, final int sysStartPeriod, final String companyId, String formulaType, List otherParams, String balanceTbl) throws BOSException, EASBizException {
        BigDecimal retValue = new BigDecimal("0");
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT ISNULL(SUM(ISNULL(FYTDFinishedQty, 0)), 0) as fytdFinQty \n");
        kSql.append("   FROM (SELECT DISTINCT balance.FCostCenterID,  \n");
        kSql.append("                         balance.FCalculatePeriodID,  \n");
        kSql.append("                         balance.FCostObjectID,  \n");
        kSql.append("                         ISNULL(balance.FYTDFinishedQty, 0) as FYTDFinishedQty  \n");
        kSql.append("           FROM " + balanceTbl + " balance --T_NCM_Balance   \n");
        kSql.append("          \tINNER JOIN T_BD_Period period   \n");
        kSql.append("          \t\ton balance.FCalculatePeriodID = period.FID  \n");
        kSql.append("          WHERE balance.FCompanyOrg = ?  \n");
        kSql.append("            AND period.FNumber = ?  \n");
        kSql.append("            AND (  \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" (balance.FCostCenterID = ? AND balance.FCostObjectID = ? ) ");
                continue;
            }
            kSql.append(" or (balance.FCostCenterID = ? AND balance.FCostObjectID = ? ) ");
        }
        kSql.append(" )) a ");
        final ArrayList calcus = new ArrayList();
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), (List)otherParams, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, companyId);
                ps.setInt(2, sysStartPeriod);
                return 2;
            }

            public void processRow(ResultSet rs) throws SQLException {
                calcus.add(rs.getBigDecimal("fytdFinQty"));
            }
        });
        int size = calcus.size();
        for (int i = 0; i < size; ++i) {
            retValue = retValue.add((BigDecimal)calcus.get(i));
        }
        return retValue;
    }

    private String getCompanyIdByCompanyNumber(Context ctx, String companyNumber) throws BOSException {
        IRowSet rst;
        block4: {
            String string;
            rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)" select FID from T_ORG_Company where FNumber = ? ", (Object[])new String[]{companyNumber});
                if (!rst.next()) break block4;
                string = rst.getString("FID");
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return null;
    }

    private String appendPeriod(String month) {
        int intMount = 0;
        try {
            intMount = Integer.parseInt(month);
        }
        catch (Exception ex) {
            return month;
        }
        if (intMount > 0 && intMount < 10) {
            return "0" + month;
        }
        return month;
    }

    @Override
    protected CostCenterOrgUnitCollection _getChildrenCostCenters(Context ctx, String companyId) throws BOSException, EASBizException {
        CostCenterOrgUnitCollection costCenters = new CostCenterOrgUnitCollection();
        if (StringUtils.isEmpty((String)companyId)) {
            return costCenters;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        ICompanyOrgUnit iCompay = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompay.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        if (company.isIsBizUnit()) {
            costCenters = OrgUnitUtils.getCostCentersByCompany((Context)ctx, (String)companyId, (boolean)true);
        }
        return costCenters;
    }

    private String[] transCostCenterIds(Context ctx, String[] costCenterNumbers) throws BOSException {
        if (costCenterNumbers == null || costCenterNumbers.length == 0) {
            return null;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT FID \n");
        kSql.append("   FROM T_ORG_CostCenter \n");
        kSql.append("  WHERE FNumber in (  \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ,? ");
        }
        kSql.append(" )");
        final ArrayList ids = new ArrayList();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int size = costCenterNumbers.length;
        for (int i = 0; i < size; ++i) {
            Object[] param = new Object[]{costCenterNumbers[i].trim()};
            params.add(param);
        }
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }

            public void processRow(ResultSet rs) throws SQLException {
                ids.add(rs.getString("FID"));
            }
        });
        String[] costCenterIds = new String[ids.size()];
        int size2 = ids.size();
        for (int i = 0; i < size2; ++i) {
            costCenterIds[i] = ids.get(i).toString();
        }
        return costCenterIds;
    }

    private String[] transCostObjectIds(Context ctx, final String companyId, String[] costObjectNumbers) throws BOSException {
        if (costObjectNumbers == null || costObjectNumbers.length == 0 || StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT FID \n");
        kSql.append("   FROM T_BD_CostObject \n");
        kSql.append("  WHERE FCompanyID = ? \n");
        kSql.append("    AND FNumber in (  \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ,? ");
        }
        kSql.append(" )");
        final ArrayList ids = new ArrayList();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int size = costObjectNumbers.length;
        for (int i = 0; i < size; ++i) {
            Object[] param = new Object[]{costObjectNumbers[i].trim()};
            params.add(param);
        }
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, companyId);
                return 1;
            }

            public void processRow(ResultSet rs) throws SQLException {
                ids.add(rs.getString("FID"));
            }
        });
        String[] costOjectIds = new String[ids.size()];
        int size2 = ids.size();
        for (int i = 0; i < size2; ++i) {
            costOjectIds[i] = ids.get(i).toString();
        }
        return costOjectIds;
    }

    private String[] transCostItemIds(Context ctx, String companyId, String[] costItemNumbers) throws BOSException {
        if (costItemNumbers == null || costItemNumbers.length == 0 || StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        final String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : companyId;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT FID \n");
        kSql.append("   FROM T_NCM_CostItem \n");
        kSql.append("  WHERE  \n");
        kSql.append("    ( FAdminCUID = ?  \n");
        kSql.append("        OR  \n");
        kSql.append("      FID IN (SELECT FDataBaseDID  \n");
        kSql.append("                FROM T_BD_DataBaseDAssign  \n");
        kSql.append("               WHERE FBOSObjectType = '548C5A91'  \n");
        kSql.append("                 AND FAssignCUID = ? \n");
        kSql.append("              ) \n");
        kSql.append("     ) \n");
        kSql.append("    AND FNumber in (  \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 0) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ,? ");
        }
        kSql.append(" )");
        final ArrayList ids = new ArrayList();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int size = costItemNumbers.length;
        for (int i = 0; i < size; ++i) {
            Object[] param = new Object[]{costItemNumbers[i].trim()};
            params.add(param);
        }
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, cuid);
                ps.setString(2, cuid);
                return 2;
            }

            public void processRow(ResultSet rs) throws SQLException {
                ids.add(rs.getString("FID"));
            }
        });
        String[] costOjectIds = new String[ids.size()];
        int size2 = ids.size();
        for (int i = 0; i < size2; ++i) {
            costOjectIds[i] = ids.get(i).toString();
        }
        return costOjectIds;
    }
}

