/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.ncm.cal.report.app.CalcYearSum;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeInfo;
import com.kingdee.eas.ncm.common.asynrpt.app.NCMRpt;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class YearSumRpt
extends NCMRpt {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.rpt.app.YearSumRpt");
    String companyID = null;

    protected void build() throws Throwable {
        this.buildReportData(this.params);
    }

    protected RptTableHeader buildTblHeader() {
        String costItemName;
        int i;
        IRowSet irSet;
        String yearSumAmountTbl;
        RptTableHeader header = new RptTableHeader();
        ArrayList<String> headLabels1 = new ArrayList<String>();
        ArrayList<String> headLabels2 = new ArrayList<String>();
        RptTableColumn col = null;
        RptParams filter = this.params;
        col = new RptTableColumn("FCompanyOrg");
        col.setWidth(100);
        header.addColumn(col);
        headLabels1.add(this.getResource("company_name_lable"));
        headLabels2.add(this.getResource("company_name_lable"));
        ArrayList tblData = (ArrayList)filter.getObject("table");
        int qtyCounter = 0;
        for (int i2 = 0; i2 < tblData.size(); ++i2) {
            HashMap row = (HashMap)tblData.get(i2);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                col = new RptTableColumn("FPeriodNumber");
                col.setWidth(78);
                header.addColumn(col);
                headLabels1.add(this.getResource("period_name_label"));
                headLabels2.add(this.getResource("period_name_label"));
                ++qtyCounter;
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                col = new RptTableColumn("FCostCenterNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("costCenter_number_label"));
                headLabels2.add(this.getResource("costCenter_number_label"));
                col = new RptTableColumn("FCostCenterName");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("costCenter_name_label"));
                headLabels2.add(this.getResource("costCenter_name_label"));
                ++qtyCounter;
            }
            if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                col = new RptTableColumn("FCostObjNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("costObject_number_label"));
                headLabels2.add(this.getResource("costObject_number_label"));
                col = new RptTableColumn("FCostObjName");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("costObject_name_label"));
                headLabels2.add(this.getResource("costObject_name_label"));
                col = new RptTableColumn("FOrderNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("manufacturerOrder_name_label"));
                headLabels2.add(this.getResource("manufacturerOrder_name_label"));
                col.setHided(true);
                col = new RptTableColumn("FProductLot");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("lot_label"));
                headLabels2.add(this.getResource("lot_label"));
                col = new RptTableColumn("FProjectNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("project_number_label"));
                headLabels2.add(this.getResource("project_number_label"));
                col.setHided(true);
                col = new RptTableColumn("FTrackNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("track_number_label"));
                headLabels2.add(this.getResource("track_number_label"));
                col.setHided(true);
                col = new RptTableColumn("FProductNumber");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("product_number_label"));
                headLabels2.add(this.getResource("product_number_label"));
                col.setHided(true);
                col = new RptTableColumn("FProductName");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("product_name_label"));
                headLabels2.add(this.getResource("product_name_label"));
                col.setHided(true);
                col = new RptTableColumn("FProductModel");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("product_model_label"));
                headLabels2.add(this.getResource("product_model_label"));
                col.setHided(true);
                col = new RptTableColumn("FProductShortName");
                col.setWidth(100);
                header.addColumn(col);
                headLabels1.add(this.getResource("product_shortName_label"));
                headLabels2.add(this.getResource("product_shortName_label"));
                col.setHided(true);
                ++qtyCounter;
            }
            if (!this.isDisplayByRow() || !"FCostItemID".equalsIgnoreCase(fieldID)) continue;
            col = new RptTableColumn("FCostItemNumber");
            col.setWidth(100);
            header.addColumn(col);
            headLabels1.add(this.getResource("costItem_number_label"));
            headLabels2.add(this.getResource("costItem_number_label"));
            col = new RptTableColumn("FCostItemName");
            col.setWidth(100);
            header.addColumn(col);
            headLabels1.add(this.getResource("costItem_name_label"));
            headLabels2.add(this.getResource("costItem_name_label"));
            ++qtyCounter;
        }
        col = new RptTableColumn("FUnitName");
        col.setWidth(49);
        header.addColumn(col);
        headLabels1.add(this.getResource("baseUnit_name_label"));
        headLabels2.add(this.getResource("baseUnit_name_label"));
        col = new RptTableColumn("FYearSumInQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        headLabels1.add(this.getResource("yearSumInQty_label"));
        headLabels2.add(this.getResource("outPut_label"));
        if (!this.isDisplayByRow()) {
            try {
                String companyID = (String)this.params.getObject("companyId");
                yearSumAmountTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)companyID, (String)"T_NCM_YearSumAmountData");
                irSet = this.getCostItems(yearSumAmountTbl);
                i = 0;
                while (irSet.next()) {
                    costItemName = irSet.getString("FCostItemName");
                    col = new RptTableColumn("FYearSumInAmount" + i);
                    col.setWidth(100);
                    col.setAligment(2);
                    header.addColumn(col);
                    headLabels1.add(this.getResource("yearSumInAmount_label"));
                    headLabels2.add(costItemName);
                    ++i;
                }
            }
            catch (EASBizException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.isDisplayByRow()) {
            col = new RptTableColumn("FYearSumInAmount");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            headLabels1.add(this.getResource("yearSumInAmount_label"));
            headLabels2.add(this.getResource("amount_label"));
        }
        if (!this.isDisplayByRow()) {
            col = new RptTableColumn("FTotalYearSumInAmount");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            headLabels1.add(this.getResource("yearSumInAmount_label"));
            headLabels2.add(this.getResource("cost_label"));
        }
        col = new RptTableColumn("FUnitYearSumInAmount");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        headLabels1.add(this.getResource("yearSumInAmount_label"));
        headLabels2.add(this.getResource("unitcost_label"));
        col = new RptTableColumn("FYearSumComQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        headLabels1.add(this.getResource("yearSumComQty_label"));
        headLabels2.add(this.getResource("outPut_label"));
        if (!this.isDisplayByRow()) {
            try {
                String companyID = (String)this.params.getObject("companyId");
                yearSumAmountTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)companyID, (String)"T_NCM_YearSumAmountData");
                irSet = this.getCostItems(yearSumAmountTbl);
                i = 0;
                while (irSet.next()) {
                    costItemName = irSet.getString("FCostItemName");
                    col = new RptTableColumn("FYearSumComAmount" + i);
                    col.setWidth(100);
                    col.setAligment(2);
                    header.addColumn(col);
                    headLabels1.add(this.getResource("yearSumComQty_label"));
                    headLabels2.add(costItemName);
                    ++i;
                }
            }
            catch (EASBizException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.isDisplayByRow()) {
            col = new RptTableColumn("FYearSumComAmount");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            headLabels1.add(this.getResource("yearSumComQty_label"));
            headLabels2.add(this.getResource("amount_label"));
        }
        if (!this.isDisplayByRow()) {
            col = new RptTableColumn("FTotalYearSumComAmount");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            headLabels1.add(this.getResource("yearSumComQty_label"));
            headLabels2.add(this.getResource("cost_label"));
        }
        col = new RptTableColumn("FUnitYearSumComAmount");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        headLabels1.add(this.getResource("yearSumComQty_label"));
        headLabels2.add(this.getResource("unitcost_label"));
        Object[] labels1 = new Object[headLabels1.size()];
        Object[] labels2 = new Object[headLabels2.size()];
        for (int i3 = 0; i3 < headLabels1.size(); ++i3) {
            labels1[i3] = headLabels1.get(i3);
            labels2[i3] = headLabels2.get(i3);
        }
        header.setLabels((Object[][])new Object[][]{labels1, labels2}, true);
        return header;
    }

    protected RptTableHeader queryTblHeader(AsynRptSchemeInfo scheme) throws Exception {
        return this.buildTblHeader();
    }

    protected String getQueryRowCountSql(String T_TMP_Table) throws Exception {
        String sql = super.getQueryRowCountSql(T_TMP_Table);
        boolean isOnlyDisplayTotal = this.params.getBoolean("isOnlyDisPalyTotal");
        String where = " Where FIsQtyRow = 0 ";
        if (isOnlyDisplayTotal) {
            where = " where FIsTotalRow = 1 ";
        }
        return sql + where;
    }

    protected String getQueryDataSqlByLimit(String T_TMP_Table) throws BOSException, EASBizException {
        StringBuffer orderBy;
        String sql = super.getQueryDataSqlByLimit(T_TMP_Table);
        String orderByMode = null;
        boolean isTotalRowTop = this.params.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = this.params.getBoolean("isOnlyDisPalyTotal");
        String where = " Where FIsQtyRow = 0 ";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        sql = (orderBy = this.getSortString((ArrayList)this.params.getObject("table"), orderByMode)) != null ? sql + where + " Order by FTotalRow2 " + orderByMode + ", " + orderBy.toString() + " FisTotalRow " : sql + where + " Order by FTotalRow2 " + orderByMode;
        return sql;
    }

    private StringBuffer getSortString(ArrayList list, String sortMode) {
        if (list == null) {
            return null;
        }
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap row = (HashMap)list.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodName,FTotalPeriodRow " + sortMode + ",");
                continue;
            }
            if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumber,FTotalCostCenterRow " + sortMode + ",");
                continue;
            }
            if ("FCostObjID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostObjNumber,FTotalCostObjectRow " + sortMode + ",");
                continue;
            }
            if ("FCostItemID".equalsIgnoreCase(fieldID) && this.isDisplayByRow()) {
                orderBy.append("FCostItemNumber,FTotalCostItemRow " + sortMode + ",");
                continue;
            }
            if (!"FBatchID".equalsIgnoreCase(fieldID)) continue;
            orderBy.append("FProductLot,FTotalBatchRow " + sortMode + ",");
        }
        return orderBy;
    }

    private String buildReportData(RptParams filter) throws Exception {
        if (this.params.getBoolean("isDisPlayByRow")) {
            return this.dealwithDataByRow(filter);
        }
        return this.dealwithDataByCloumn(filter);
    }

    private String dealwithDataByRow(RptParams filter) throws Exception {
        Context ctx = this.getContext();
        String companyID = (String)filter.getObject("companyId");
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
            filter.setString("companyName", company.getName());
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        String yearSumAmountTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_YearSumAmountData");
        String yearSumQtyTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_YearSumQtyData");
        String periodFrom = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodTo = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        new CalcYearSum(ctx, filter.getBoolean("isReCalc"), periodFrom, periodTo, companyID);
        String sTmpTblName = this.createTmpTableSQL();
        this.setTmpTable(sTmpTblName);
        Locale la = ctx.getLocale();
        StringBuffer initSql = new StringBuffer();
        initSql.append(" INSERT INTO " + sTmpTblName);
        initSql.append("     (FCompanyOrg,FPeriodID,FPeriodName,FPeriodNumber, \n");
        initSql.append("      FCostCenterID,FCostCenterName,FCostCenterNumber, \n");
        initSql.append("      FCostObjID,FCostObjName,FCostObjNumber,FProductLot,FUnitName, \n");
        initSql.append("      FOrderID,FOrderNumber,FProjectNumber,FTrackNumber, \n");
        initSql.append("      FProductName,FProductNumber,FProductModel,FProductShortName, \n");
        initSql.append("      FCostItemID,FCostItemName,FCostItemNumber, \n");
        initSql.append("      FYearSumInQty,FYearSumInAmount,FYearSumComQty,FYearSumComAmount, \n");
        initSql.append("      FTotalRow,FTotalRow2,FAmountPrecision,FPricePrecision \n");
        initSql.append("     )\n");
        initSql.append(" SELECT\u3000'" + company.getName() + "', \n");
        initSql.append("         \u3000   per.FID,per.FNumber,per.FNumber, \n");
        initSql.append("         \u3000   cc.FID,cc.FName_" + la + ",cc.FNumber, \n");
        initSql.append("         \u3000   co.FID,co.FName_" + la + ",co.FNumber,co.FBatchNumber,unit.FName_" + la + ", \n");
        initSql.append("         \u3000   co.FOrderID,co.FOrderNumber,pro.FNumber,tr.FNumber, \n");
        initSql.append("         \u3000   mat.FName_" + la + ",mat.FNumber,mat.FModel,mat.FShortName, \n");
        initSql.append("         \u3000   ci.FID,ci.FName_" + la + ",ci.FNumber, \n");
        initSql.append("         \u3000   0 FYearSumInQty,FYearSumInAmount,0 FYearSumComQty,FYearSumComAmount, \n");
        initSql.append("      0 FTotalRow,0 FTotalRow2, curr.FPrecision FAmountPrecision,mat.FPricePrecision FPricePrecision \n");
        initSql.append("   From " + yearSumAmountTbl + " amData \n");
        initSql.append("   INNER JOIN T_BD_Period per ON per.FID=amData.FCalculatePeriodID \n");
        initSql.append("   INNER JOIN T_ORG_CostCenter cc ON cc.FID=amData.FCostCenterID \n");
        initSql.append("   INNER JOIN T_BD_CostObject co ON co.FID=amData.FCostObjectID \n");
        initSql.append("   INNER JOIN T_BD_Material mat ON mat.FID=co.FStdProductIDID \n");
        initSql.append("   INNER JOIN t_BD_MeasureUnit unit ON mat.FBaseUnit=unit.FID\n");
        initSql.append("   LEFT JOIN T_MM_Project pro ON pro.FID = co.FProjectID \n");
        initSql.append("   LEFT JOIN T_MM_TrackNumber tr ON tr.FID = co.FTrackID \n");
        initSql.append("   INNER JOIN T_NCM_CostItem ci ON ci.FID = amData.FCostItemID \n");
        initSql.append("   INNER JOIN T_ORG_Company com ON com.FID = co.FCompanyID \n");
        initSql.append("   LEFT JOIN T_BD_Currency curr ON com.FBaseCurrencyID = curr.FID \n");
        initSql.append(" where 1=1 \n");
        this.AppendPredicate(initSql, filter, true, "per.FNumber", "", "");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(initSql, filter, false, "ci.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(initSql, filter, false, "ci.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        NCMDbUtil.execute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" INSERT INTO " + sTmpTblName);
        initSql.append("     (FCompanyOrg,FPeriodID,FPeriodName,FPeriodNumber, \n");
        initSql.append("      FCostCenterID,FCostCenterName,FCostCenterNumber, \n");
        initSql.append("      FCostObjID,FCostObjName,FCostObjNumber,FProductLot,FUnitName, \n");
        initSql.append("      FOrderID,FOrderNumber,FProjectNumber,FTrackNumber, \n");
        initSql.append("      FProductName,FProductNumber,FProductModel,FProductShortName, \n");
        initSql.append("      FYearSumInQty,FYearSumInAmount,FYearSumComQty,FYearSumComAmount, \n");
        initSql.append("      FTotalRow,FTotalRow2,FIsQtyRow,FQtyPrecision \n");
        initSql.append("     )\n");
        initSql.append(" SELECT\u3000'" + company.getName() + "', \n");
        initSql.append("         \u3000   per.FID,per.FNumber,per.FNumber, \n");
        initSql.append("         \u3000   cc.FID,cc.FName_" + la + ",cc.FNumber, \n");
        initSql.append("         \u3000   co.FID,co.FName_" + la + ",co.FNumber,co.FBatchNumber,unit.FName_" + la + ", \n");
        initSql.append("         \u3000   co.FOrderID,co.FOrderNumber,pro.FNumber,tr.FNumber, \n");
        initSql.append("         \u3000   mat.FName_" + la + ",mat.FNumber,mat.FModel,mat.FShortName, \n");
        initSql.append("         \u3000   FYearSumInQty,0 FYearSumInAmount,FYearSumComQty,0 FYearSumComAmount, \n");
        initSql.append("      0 FTotalRow, 0 FTotalRow2, 1 FIsQtyRow,mmu.FqtyPrecision FQtyPrecision \n");
        initSql.append("   From " + yearSumQtyTbl + " qtyData \n");
        initSql.append("   INNER JOIN T_BD_Period per ON per.FID=qtyData.FCalculatePeriodID \n");
        initSql.append("   INNER JOIN T_ORG_CostCenter cc ON cc.FID=qtyData.FCostCenterID \n");
        initSql.append("   INNER JOIN T_BD_CostObject co ON co.FID=qtyData.FCostObjectID \n");
        initSql.append("   INNER JOIN T_BD_Material mat ON mat.FID=co.FStdProductIDID \n");
        initSql.append("   INNER JOIN t_BD_MeasureUnit unit ON mat.FBaseUnit=unit.FID\n");
        initSql.append("   INNER JOIN t_bd_multiMeasureUnit mmu on mat.Fid=mmu.FMaterialID AND mmu.FMeasureUnitID = unit.FID \n");
        initSql.append("   LEFT JOIN T_MM_Project pro ON pro.FID = co.FProjectID \n");
        initSql.append("   LEFT JOIN T_MM_TrackNumber tr ON tr.FID = co.FTrackID \n");
        initSql.append(" where 1=1 \n");
        this.AppendPredicate(initSql, filter, true, "per.FNumber", "", "");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        NCMDbUtil.execute((Context)this.getContext(), (String)initSql.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        initSql.setLength(0);
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("insertby");
            fields = fields.replaceAll("FPeriodName", "FPeriodNumber,FPeriodName");
            initSql.append(" INSERT INTO " + sTmpTblName + "( \n");
            initSql.append(" FCompanyOrg,FTotalRow,FTotalRow2,FIsTotalRow," + fields + ", \n");
            initSql.append(" FYearSumInQty,FYearSumInAmount, \n");
            initSql.append(" FYearSumComQty,FYearSumComAmount, \n");
            initSql.append(" FAmountPrecision,FQtyPrecision,FPricePrecision) \n");
            initSql.append(" SELECT FCompanyOrg," + map.get("totalrow").toString() + ",0 FTotalRow2,1 FIsTotalRow," + fields + ",");
            initSql.append(" Sum(FYearSumInQty) as FYearSumInQty, Sum(FYearSumInAmount) as FYearSumInAmount, \n");
            initSql.append(" Sum(FYearSumComQty) as FYearSumComQty, sum(FYearSumComAmount) as FYearSumComAmount, \n");
            initSql.append(" max(FAmountPrecision),Max(FQtyPrecision),max(FPricePrecision) \n");
            initSql.append(" FROM " + sTmpTblName + "\n");
            initSql.append(" WHERE FTotalRow = 0 \n");
            if (fields.contains("FCostItemID")) {
                initSql.append(" AND FIsQtyRow = 0 \n");
            }
            initSql.append(" group by FCompanyOrg, " + fields);
            initSql.append("\n\n;");
        }
        String totalName = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale());
        initSql.append(" INSERT INTO " + sTmpTblName + "( \n");
        initSql.append(" FCompanyOrg,FTotalRow2,FTotalRow,FIsTotalRow, \n");
        initSql.append(" FYearSumInQty,FYearSumInAmount, \n");
        initSql.append(" FYearSumComQty,FYearSumComAmount, \n");
        initSql.append(" FAmountPrecision,FQtyPrecision,FPricePrecision) \n");
        initSql.append(" SELECT '" + totalName + "',1,105,1,");
        initSql.append(" Sum(FYearSumInQty) as FYearSumInQty, \n");
        initSql.append(" Sum(FYearSumInAmount) as FYearSumInAmount, \n");
        initSql.append(" sum(FYearSumComQty) as FYearSumComQty, \n");
        initSql.append(" sum(FYearSumComAmount) as FYearSumComAmount, \n");
        initSql.append(" max(FAmountPrecision),Max(FQtyPrecision),Max(FPricePrecision) \n");
        initSql.append(" FROM " + sTmpTblName + "\n");
        initSql.append(" where FTotalRow = 0  \n");
        initSql.append("\n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FPeriodNumber,FPeriodName)= (SELECT T2.FNumber, ");
        initSql.append(" T2.FNumber \n");
        initSql.append(" FROM T_BD_Period T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FPeriodID = T2.FID \n");
        initSql.append("   and (" + sTmpTblName + ".FPeriodName is null \n");
        initSql.append("    or " + sTmpTblName + ".FPeriodName=' ')) \n");
        initSql.append("\n\n;");
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        initSql.append(" T2.FName_" + la + " \n");
        initSql.append(" FROM T_ORG_CostCenter T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FCostCenterID = T2.FID \n");
        initSql.append("   and (" + sTmpTblName + ".FCostCenterNumber is null \n");
        initSql.append("    or " + sTmpTblName + ".FCostCenterNumber=' ')) \n");
        initSql.append("\n\n;");
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FCostObjNumber,FCostObjName) = \n");
        initSql.append(" ( SELECT T2.FNumber,T2.FName_" + la + "\n");
        initSql.append(" FROM T_BD_CostObject T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FCostObjID =T2.FID \n ");
        initSql.append("   and (" + sTmpTblName + ".FCostObjNumber is null \n");
        initSql.append("    or " + sTmpTblName + ".FCostObjNumber=' ')) \n");
        initSql.append("\n\n;");
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FCostItemNumber) = \n");
        initSql.append(" ( SELECT T2.FNumber \n");
        initSql.append(" FROM T_NCM_CostItem T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FCostItemID =T2.FID \n ");
        initSql.append("   and (" + sTmpTblName + ".FCostItemNumber is null \n");
        initSql.append("    or " + sTmpTblName + ".FCostItemNumber=' ')) \n");
        initSql.append("\n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        initSql.setLength(0);
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchID")) {
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (field.equals("FPeriodID")) {
                initSql.append(" update " + sTmpTblName + " set FPeriodNumber= FPeriodNumber || ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n");
                initSql.append(" FTotalPeriodrow = 1 \n");
            } else if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID")) {
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                initSql.append(" update " + sTmpTblName + " set " + fieldNumber + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                initSql.append(whichTotal);
            } else {
                fieldName = field.substring(0, field.length() - 2) + "Name";
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                initSql.append(" update " + sTmpTblName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n" + fieldNumber + " = " + fieldNumber + "\n");
                initSql.append(whichTotal);
            }
            initSql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            initSql.append("\n\n;");
        }
        initSql.append("Update " + sTmpTblName + " \n");
        initSql.append("set \n");
        initSql.append("    FYearSumInQty \n");
        initSql.append("= ( \n");
        initSql.append("    select sum(FYearSumInQty) \n");
        initSql.append("    from " + sTmpTblName + " \n");
        initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
        initSql.append(") \n");
        initSql.append("where FTotalRow2 = 1 \n");
        initSql.append("; \n");
        initSql.append("Update " + sTmpTblName + " \n");
        initSql.append("set \n");
        initSql.append("    FYearSumInAmount \n");
        initSql.append("= ( \n");
        initSql.append("    select sum(FYearSumInAmount) \n");
        initSql.append("    from " + sTmpTblName + " \n");
        initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
        initSql.append(") \n");
        initSql.append("where FTotalRow2 = 1 \n");
        initSql.append("; \n");
        initSql.append("Update " + sTmpTblName + " \n");
        initSql.append("set \n");
        initSql.append("    FYearSumComQty \n");
        initSql.append("= ( \n");
        initSql.append("    select sum(FYearSumComQty) \n");
        initSql.append("    from " + sTmpTblName + " \n");
        initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
        initSql.append(") \n");
        initSql.append("where FTotalRow2 = 1 \n");
        initSql.append("; \n");
        initSql.append("Update " + sTmpTblName + " \n");
        initSql.append("set \n");
        initSql.append("    FYearSumComAmount \n");
        initSql.append("= ( \n");
        initSql.append("    select sum(FYearSumComAmount) \n");
        initSql.append("    from " + sTmpTblName + " \n");
        initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
        initSql.append(") \n");
        initSql.append("where FTotalRow2 = 1 \n");
        initSql.append("; \n");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" Update ").append(sTmpTblName).append(" Set FUnitYearSumInAmount = case when FYearSumInQty = 0 then null else round(FYearSumInAmount/FYearSumInQty,FPricePrecision) end , \n");
        initSql.append("   FUnitYearSumComAmount = case when FYearSumComQty = 0 then null else round(FYearSumComAmount/FYearSumComQty,FPricePrecision) end \n");
        initSql.append(" Where FTotalCostObjectRow = 1; \n");
        NCMDbUtil.execute((Context)ctx, (String)initSql.toString());
        return sTmpTblName;
    }

    private String dealwithDataByCloumn(RptParams filter) throws Exception {
        Context ctx = this.getContext();
        String companyID = (String)filter.getObject("companyId");
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
            filter.setString("companyName", company.getName());
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        String yearSumAmountTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_YearSumAmountData");
        String yearSumQtyTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_YearSumQtyData");
        String periodFrom = this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom"));
        String periodTo = this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo"));
        new CalcYearSum(ctx, filter.getBoolean("isReCalc"), periodFrom, periodTo, companyID);
        String sTmpTblName = this.createDisPalyColunTmpTableSQL(yearSumAmountTbl);
        this.setTmpTable(sTmpTblName);
        Locale la = ctx.getLocale();
        StringBuffer initSql = new StringBuffer();
        initSql.append(" INSERT INTO " + sTmpTblName);
        initSql.append("     (FCompanyOrg,FPeriodID,FPeriodName,FPeriodNumber, \n");
        initSql.append("      FCostCenterID,FCostCenterName,FCostCenterNumber, \n");
        initSql.append("      FCostObjID,FCostObjName,FCostObjNumber,FProductLot,FUnitName, \n");
        initSql.append("      FOrderID,FOrderNumber,FProjectNumber,FTrackNumber, \n");
        initSql.append("      FProductName,FProductNumber,FProductModel,FProductShortName, \n");
        initSql.append("      FTotalRow,FTotalRow2,FAmountPrecision,FPricePrecision \n");
        initSql.append("     )\n");
        initSql.append(" SELECT\u3000distinct '" + company.getName() + "', \n");
        initSql.append("         \u3000   per.FID,per.FNumber,per.FNumber, \n");
        initSql.append("         \u3000   cc.FID,cc.FName_" + la + ",cc.FNumber, \n");
        initSql.append("         \u3000   co.FID,co.FName_" + la + ",co.FNumber,co.FBatchNumber,unit.FName_" + la + ", \n");
        initSql.append("         \u3000   co.FOrderID,co.FOrderNumber,pro.FNumber,tr.FNumber, \n");
        initSql.append("         \u3000   mat.FName_" + la + ",mat.FNumber,mat.FModel,mat.FShortName, \n");
        initSql.append("      0 FTotalRow,0 FTotalRow2, curr.FPrecision FAmountPrecision,mat.FPricePrecision FPricePrecision \n");
        initSql.append("   From " + yearSumAmountTbl + " amData \n");
        initSql.append("   INNER JOIN T_BD_Period per ON per.FID=amData.FCalculatePeriodID \n");
        initSql.append("   INNER JOIN T_ORG_CostCenter cc ON cc.FID=amData.FCostCenterID \n");
        initSql.append("   INNER JOIN T_BD_CostObject co ON co.FID=amData.FCostObjectID \n");
        initSql.append("   INNER JOIN T_BD_Material mat ON mat.FID=co.FStdProductIDID \n");
        initSql.append("   INNER JOIN t_BD_MeasureUnit unit ON mat.FBaseUnit=unit.FID\n");
        initSql.append("   LEFT JOIN T_MM_Project pro ON pro.FID = co.FProjectID \n");
        initSql.append("   LEFT JOIN T_MM_TrackNumber tr ON tr.FID = co.FTrackID \n");
        initSql.append("   INNER JOIN T_NCM_CostItem ci ON ci.FID = amData.FCostItemID \n");
        initSql.append("   INNER JOIN T_ORG_Company com ON com.FID = co.FCompanyID \n");
        initSql.append("   LEFT JOIN T_BD_Currency curr ON com.FBaseCurrencyID = curr.FID \n");
        initSql.append(" where 1=1 \n");
        this.AppendPredicate(initSql, filter, true, "per.FNumber", "", "");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(initSql, filter, false, "ci.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(initSql, filter, false, "ci.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        NCMDbUtil.execute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" INSERT INTO " + sTmpTblName);
        initSql.append("     (FCompanyOrg,FPeriodID,FPeriodName,FPeriodNumber, \n");
        initSql.append("      FCostCenterID,FCostCenterName,FCostCenterNumber, \n");
        initSql.append("      FCostObjID,FCostObjName,FCostObjNumber,FProductLot,FUnitName, \n");
        initSql.append("      FOrderID,FOrderNumber,FProjectNumber,FTrackNumber, \n");
        initSql.append("      FProductName,FProductNumber,FProductModel,FProductShortName, \n");
        initSql.append("      FTotalRow,FTotalRow2,FQtyPrecision \n");
        initSql.append("     )\n");
        initSql.append(" SELECT\u3000'" + company.getName() + "', \n");
        initSql.append("         \u3000   per.FID,per.FNumber,per.FNumber, \n");
        initSql.append("         \u3000   cc.FID,cc.FName_" + la + ",cc.FNumber, \n");
        initSql.append("         \u3000   co.FID,co.FName_" + la + ",co.FNumber,co.FBatchNumber,unit.FName_" + la + ", \n");
        initSql.append("         \u3000   co.FOrderID,co.FOrderNumber,pro.FNumber,tr.FNumber, \n");
        initSql.append("         \u3000   mat.FName_" + la + ",mat.FNumber,mat.FModel,mat.FShortName, \n");
        initSql.append("      0 FTotalRow, 0 FTotalRow2,mmu.FqtyPrecision FQtyPrecision \n");
        initSql.append("   From " + yearSumQtyTbl + " qtyData \n");
        initSql.append("   INNER JOIN T_BD_Period per ON per.FID=qtyData.FCalculatePeriodID \n");
        initSql.append("   INNER JOIN T_ORG_CostCenter cc ON cc.FID=qtyData.FCostCenterID \n");
        initSql.append("   INNER JOIN T_BD_CostObject co ON co.FID=qtyData.FCostObjectID \n");
        initSql.append("   INNER JOIN T_BD_Material mat ON mat.FID=co.FStdProductIDID \n");
        initSql.append("   INNER JOIN t_BD_MeasureUnit unit ON mat.FBaseUnit=unit.FID\n");
        initSql.append("   INNER JOIN t_bd_multiMeasureUnit mmu on mat.Fid=mmu.FMaterialID AND mmu.FMeasureUnitID = unit.FID \n");
        initSql.append("   LEFT JOIN T_MM_Project pro ON pro.FID = co.FProjectID \n");
        initSql.append("   LEFT JOIN T_MM_TrackNumber tr ON tr.FID = co.FTrackID \n");
        initSql.append(" where not exists (select 1 from " + sTmpTblName + " data \n");
        initSql.append("                   where data.FCostCenterID = qtyData.FCostCenterID \n");
        initSql.append("                     AND data.FCostObjID = qtyData.FCostObjectID \n");
        initSql.append("                  ) \n");
        this.AppendPredicate(initSql, filter, true, "per.FNumber", "", "");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(initSql, filter, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(initSql, filter, false, "co.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(initSql, filter, false, "co.FBatchNumber", "<=", "txtBatchTo");
        NCMDbUtil.execute((Context)this.getContext(), (String)initSql.toString());
        IRowSet irSet = this.getCostItems(yearSumAmountTbl);
        int j = 0;
        while (irSet.next()) {
            initSql.setLength(0);
            String costItemID = irSet.getString("FCostItemID");
            initSql.append("Update ").append(sTmpTblName).append(" rpt set FYearSumInAmount" + j + " = \n");
            initSql.append(" (Select FYearSumInAmount from ").append(yearSumAmountTbl).append(" data \n");
            initSql.append("   where data.FcostCenterID = rpt.FcostCenterID \n");
            initSql.append("     AND data.FcostObjectID = rpt.FCostObjID \n");
            initSql.append("    AND  data.FCalculatePeriodID = rpt.FPeriodID \n");
            initSql.append("     AND data.FCostItemID = '").append(costItemID).append("' \n");
            initSql.append(" ); \n");
            initSql.append("Update ").append(sTmpTblName).append(" rpt set FYearSumComAmount" + j + " = \n");
            initSql.append(" (Select FYearSumComAmount from ").append(yearSumAmountTbl).append(" data \n");
            initSql.append("   where data.FcostCenterID = rpt.FcostCenterID \n");
            initSql.append("     AND data.FcostObjectID = rpt.FCostObjID \n");
            initSql.append("    AND  data.FCalculatePeriodID = rpt.FPeriodID \n");
            initSql.append("     AND data.FCostItemID = '").append(costItemID).append("' \n");
            initSql.append(" ); \n");
            NCMDbUtil.BatchSqlExecute((Context)ctx, (String)initSql.toString());
            ++j;
        }
        initSql.setLength(0);
        initSql.append("Update ").append(sTmpTblName).append(" rpt set FYearSumInQty = \n");
        initSql.append(" (Select FYearSumInQty from ").append(yearSumQtyTbl).append(" data \n");
        initSql.append("   where data.FcostCenterID = rpt.FcostCenterID \n");
        initSql.append("     AND data.FcostObjectID = rpt.FCostObjID \n");
        initSql.append("    AND  data.FCalculatePeriodID = rpt.FPeriodID \n");
        initSql.append(" ); \n");
        initSql.append("Update ").append(sTmpTblName).append(" rpt set FYearSumComQty = \n");
        initSql.append(" (Select FYearSumComQty from ").append(yearSumQtyTbl).append(" data \n");
        initSql.append("   where data.FcostCenterID = rpt.FcostCenterID \n");
        initSql.append("     AND data.FcostObjectID = rpt.FCostObjID \n");
        initSql.append("    AND  data.FCalculatePeriodID = rpt.FPeriodID \n");
        initSql.append(" ); \n");
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)initSql.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        initSql.setLength(0);
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("insertby");
            fields = fields.replaceAll("FPeriodName", "FPeriodNumber,FPeriodName");
            initSql.append(" INSERT INTO " + sTmpTblName + "( \n");
            initSql.append(" FCompanyOrg,FTotalRow,FTotalRow2,FIsTotalRow," + fields + ", \n");
            irSet = this.getCostItems(yearSumAmountTbl);
            index = 0;
            while (irSet.next()) {
                initSql.append(" FYearSumComAmount" + index + ",FYearSumInAmount" + index + ", \n");
                ++index;
            }
            initSql.append(" FYearSumComQty,FYearSumInQty, \n");
            initSql.append(" FAmountPrecision,FQtyPrecision,FPricePrecision) \n");
            initSql.append(" SELECT FCompanyOrg," + map.get("totalrow").toString() + ",0 FTotalRow2,1 FIsTotalRow," + fields + ",");
            irSet = this.getCostItems(yearSumAmountTbl);
            index = 0;
            while (irSet.next()) {
                initSql.append("  sum(FYearSumComAmount" + index + ") as FYearSumComAmount" + index + ", Sum(FYearSumInAmount" + index + ") as FYearSumInAmount" + index + ", \n");
                ++index;
            }
            initSql.append(" Sum(FYearSumComQty) as FYearSumComQty,Sum(FYearSumInQty) as FYearSumInQty, \n");
            initSql.append(" max(FAmountPrecision),Max(FQtyPrecision),Max(FPricePrecision) \n");
            initSql.append(" FROM " + sTmpTblName + "\n");
            initSql.append(" WHERE FTotalRow = 0 \n");
            if (fields.contains("FCostItemID")) {
                initSql.append(" AND FIsQtyRow = 0 \n");
            }
            initSql.append(" group by FCompanyOrg, " + fields);
            initSql.append("\n\n;");
        }
        String totalName = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale());
        initSql.append(" INSERT INTO " + sTmpTblName + "( \n");
        initSql.append(" FCompanyOrg,FTotalRow2,FTotalRow,FIsTotalRow, \n");
        irSet = this.getCostItems(yearSumAmountTbl);
        index = 0;
        while (irSet.next()) {
            initSql.append(" FYearSumComAmount" + index + ",FYearSumInAmount" + index + ", \n");
            ++index;
        }
        initSql.append(" FYearSumComQty,FYearSumInQty, \n");
        initSql.append(" FAmountPrecision,FQtyPrecision,FPricePrecision) \n");
        initSql.append(" SELECT '" + totalName + "',1,105,1,");
        irSet = this.getCostItems(yearSumAmountTbl);
        index = 0;
        while (irSet.next()) {
            initSql.append(" sum(FYearSumComAmount" + index + ") as FYearSumComAmount" + index + ", \n");
            initSql.append(" Sum(FYearSumInAmount" + index + ") as FYearSumInAmount" + index + ", \n");
            ++index;
        }
        initSql.append(" sum(FYearSumComQty) as FYearSumComQty, \n");
        initSql.append(" Sum(FYearSumInQty) as FYearSumInQty, \n");
        initSql.append(" max(FAmountPrecision),Max(FQtyPrecision),Max(FPricePrecision) \n");
        initSql.append(" FROM " + sTmpTblName + "\n");
        initSql.append(" where FTotalRow = 0  \n");
        initSql.append("\n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FPeriodNumber,FPeriodName)= (SELECT T2.FNumber, ");
        initSql.append(" T2.FNumber \n");
        initSql.append(" FROM T_BD_Period T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FPeriodID = T2.FID \n");
        initSql.append("   and (" + sTmpTblName + ".FPeriodName is null \n");
        initSql.append("    or " + sTmpTblName + ".FPeriodName=' ')) \n");
        initSql.append("\n\n;");
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        initSql.append(" T2.FName_" + la + " \n");
        initSql.append(" FROM T_ORG_CostCenter T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FCostCenterID = T2.FID \n");
        initSql.append("   and (" + sTmpTblName + ".FCostCenterNumber is null \n");
        initSql.append("    or " + sTmpTblName + ".FCostCenterNumber=' ')) \n");
        initSql.append("\n\n;");
        initSql.append(" Update " + sTmpTblName);
        initSql.append(" SET (FCostObjNumber,FCostObjName) = \n");
        initSql.append(" ( SELECT T2.FNumber,T2.FName_" + la + "\n");
        initSql.append(" FROM T_BD_CostObject T2 \n");
        initSql.append(" WHERE " + sTmpTblName + ".FCostObjID =T2.FID \n ");
        initSql.append("   and (" + sTmpTblName + ".FCostObjNumber is null \n");
        initSql.append("    or " + sTmpTblName + ".FCostObjNumber=' ')) \n");
        initSql.append("\n\n;");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        initSql.setLength(0);
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            fieldNumber = field = (String)map.get("id");
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemID")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FBatchID")) {
                whichTotal = ", FTotalBatchRow = 1 ";
            }
            if (field.equals("FPeriodID")) {
                initSql.append(" update " + sTmpTblName + " set FPeriodNumber= FPeriodNumber || ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n");
                initSql.append(" FTotalPeriodrow = 1 \n");
            } else if (field.equalsIgnoreCase("FOrderID") || field.equalsIgnoreCase("FBatchID") || field.equalsIgnoreCase("FProjectID") || field.equalsIgnoreCase("FTrackID")) {
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                initSql.append(" update " + sTmpTblName + " set " + fieldNumber + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' \n");
                initSql.append(whichTotal);
            } else {
                fieldName = field.substring(0, field.length() - 2) + "Name";
                fieldNumber = field.substring(0, field.length() - 2) + "Number";
                initSql.append(" update " + sTmpTblName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "', \n" + fieldNumber + " = " + fieldNumber + "\n");
                initSql.append(whichTotal);
            }
            initSql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            initSql.append("\n\n;");
        }
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        irSet = this.getCostItems(yearSumAmountTbl);
        index = 0;
        initSql.setLength(0);
        while (irSet.next()) {
            initSql.append("Update " + sTmpTblName + " \n");
            initSql.append("set \n");
            initSql.append("    FYearSumComAmount" + index + " \n");
            initSql.append("= ( \n");
            initSql.append("    select sum(FYearSumComAmount" + index + ") \n");
            initSql.append("    from " + sTmpTblName + " \n");
            initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
            initSql.append(") \n");
            initSql.append("where FTotalRow2 = 1 \n");
            initSql.append("; \n");
            initSql.append("Update " + sTmpTblName + " \n");
            initSql.append("set \n");
            initSql.append("    FYearSumInAmount" + index + " \n");
            initSql.append("= ( \n");
            initSql.append("    select sum(FYearSumInAmount" + index + ") \n");
            initSql.append("    from " + sTmpTblName + " \n");
            initSql.append("    where FTotalRow = 0 and FPeriodNumber = '" + periodTo + "' \n");
            initSql.append(") \n");
            initSql.append("where FTotalRow2 = 1 \n");
            initSql.append("; \n");
            ++index;
        }
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        index = 0;
        irSet = this.getCostItems(yearSumAmountTbl);
        initSql.append(" Update ").append(sTmpTblName).append(" Set FTotalYearSumInAmount = \n");
        while (irSet.next()) {
            if (index == 0) {
                initSql.append("isnull(FYearSumInAmount" + index + ",0) ");
            } else {
                initSql.append(" + isnull(FYearSumInAmount" + index + ",0) ");
            }
            ++index;
        }
        initSql.append(";\n ");
        index = 0;
        irSet = this.getCostItems(yearSumAmountTbl);
        initSql.append(" Update ").append(sTmpTblName).append(" Set FTotalYearSumComAmount = \n");
        while (irSet.next()) {
            if (index == 0) {
                initSql.append("isnull(FYearSumComAmount" + index + ",0) ");
            } else {
                initSql.append(" + isnull(FYearSumComAmount" + index + ",0) ");
            }
            ++index;
        }
        initSql.append(";\n ");
        NCMDbUtil.BatchSqlExecute((Context)this.getContext(), (String)initSql.toString());
        initSql.setLength(0);
        initSql.append(" Update ").append(sTmpTblName).append(" Set FUnitYearSumInAmount = case when FYearSumInQty = 0 then null else round(FTotalYearSumInAmount/FYearSumInQty,FPricePrecision) end , \n");
        initSql.append("   FUnitYearSumComAmount = case when FYearSumComQty = 0 then null else round(FTotalYearSumComAmount/FYearSumComQty,FPricePrecision) end \n");
        initSql.append(" Where (FTotalCostObjectRow = 1 or FIsTotalRow = 0) and FTotalRow2 = 0 ; \n");
        NCMDbUtil.execute((Context)ctx, (String)initSql.toString());
        initSql.setLength(0);
        return sTmpTblName;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FCostObjID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductLot varchar(255) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FOrderID varchar(44) ");
        createTable.append(",FOrderNumber varchar(80) default('')");
        createTable.append(",FProjectNumber varchar(80) default('')");
        createTable.append(",FTrackNumber varchar(80) default('')");
        createTable.append(",FProductName varchar(255) default('')");
        createTable.append(",FProductNumber varchar(80) default('')");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FCostItemNumber varchar(80) not null default(' ') ");
        createTable.append(",FCostItemName varchar(255) ");
        createTable.append(",FYearSumInQty NUMERIC(21,8) ");
        createTable.append(",FYearSumInAmount NUMERIC(17,4) ");
        createTable.append(",FYearSumComQty NUMERIC(21,8) ");
        createTable.append(",FYearSumComAmount NUMERIC(17,4) ");
        createTable.append(",FUnitYearSumInAmount NUMERIC(24,12) ");
        createTable.append(",FUnitYearSumComAmount NUMERIC(24,12) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(0) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalBatchRow int not null default(0) ");
        createTable.append(" ,FIsQtyRow int not null default(0) ");
        createTable.append(",FQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(",FPricePrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String createDisPalyColunTmpTableSQL(String tmpTblName) throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg varchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(80) not null default(' ')");
        createTable.append(",FCostCenterName varchar(255) ");
        createTable.append(",FCostObjID varchar(44) ");
        createTable.append(",FCostObjNumber  varchar(80) not null default(' ')");
        createTable.append(",FCostObjName varchar(255) ");
        createTable.append(",FProductLot varchar(255) ");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FOrderID varchar(44) ");
        createTable.append(",FOrderNumber varchar(80) default('')");
        createTable.append(",FProjectNumber varchar(80) default('')");
        createTable.append(",FTrackNumber varchar(80) default('')");
        createTable.append(",FProductName varchar(255) default('')");
        createTable.append(",FProductNumber varchar(80) default('')");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProductShortName nvarchar(80) ");
        createTable.append(",FYearSumInQty NUMERIC(21,8) ");
        createTable.append(",FYearSumComQty NUMERIC(21,8) ");
        String companyID = (String)this.params.getObject("companyId");
        String yearSumAmountTbl = null;
        try {
            yearSumAmountTbl = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)companyID, (String)"T_NCM_YearSumAmountData");
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        IRowSet irSet = this.getCostItems(yearSumAmountTbl);
        for (int i = 0; i < irSet.size(); ++i) {
            createTable.append(",FYearSumInAmount" + i + " NUMERIC(17,4) ");
            createTable.append(",FYearSumComAmount" + i + " NUMERIC(17,4) ");
        }
        createTable.append(",FUnitYearSumInAmount NUMERIC(24,12) ");
        createTable.append(",FUnitYearSumComAmount NUMERIC(24,12) ");
        createTable.append(",FTotalYearSumInAmount NUMERIC(24,12) ");
        createTable.append(",FTotalYearSumComAmount NUMERIC(24,12) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(0) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalBatchRow int not null default(0) ");
        createTable.append(" ,FIsQtyRow int not null default(0) ");
        createTable.append(",FQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(",FPricePrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String fieldID = (String)map.get("id");
            if (!this.isDisplayByRow() && fieldID.equals("FCostItemID")) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(fieldID);
            map.put("insertby", sb.toString());
            map.put("totalrow", 104 - i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            newList.add(map);
        }
        return newList;
    }

    private IRowSet getCostItems(String tmpTblName) throws BOSException {
        if (tmpTblName == null || tmpTblName.length() < 1) {
            return null;
        }
        StringBuffer querySql = new StringBuffer();
        Locale la = this.ctx.getLocale();
        querySql.append("Select distinct ci.FName_" + la + " As FCostItemName,ci.FNumber,data.FCostItemID AS FCostItemID From ").append(tmpTblName).append(" data \n");
        querySql.append("   INNER JOIN T_NCM_CostItem ci ON ci.FID = data.FCostItemID \n");
        querySql.append("   INNER JOIN T_BD_Period per ON per.FID=data.FCalculatePeriodID \n");
        querySql.append("   INNER JOIN T_ORG_CostCenter cc ON cc.FID=data.FCostCenterID \n");
        querySql.append("   INNER JOIN T_BD_CostObject co ON co.FID=data.FCostObjectID \n");
        this.AppendPredicate(querySql, this.params, true, "per.FNumber", "", "");
        this.AppendPredicate(querySql, this.params, false, "cc.FNumber", ">=", "prmtCostCenterFrom");
        this.AppendPredicate(querySql, this.params, false, "cc.FNumber", "<=", "prmtCostCenterTo");
        this.AppendPredicate(querySql, this.params, false, "co.FNumber", ">=", "prmtCostObjectFrom");
        this.AppendPredicate(querySql, this.params, false, "co.FNumber", "<=", "prmtCostObjectTo");
        this.AppendPredicate(querySql, this.params, false, "ci.FNumber", ">=", "prmtCostItemFrom");
        this.AppendPredicate(querySql, this.params, false, "ci.FNumber", "<=", "prmtCostItemTo");
        this.AppendPredicate(querySql, this.params, false, "co.FBatchNumber", ">=", "txtBatchFrom");
        this.AppendPredicate(querySql, this.params, false, "co.FBatchNumber", "<=", "txtBatchTo");
        querySql.append(" Order By ci.FNumber \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)this.getContext(), (String)querySql.toString());
        return rs;
    }

    private boolean isDisplayByRow() {
        return this.params.getBoolean("isDisPlayByRow");
    }

    private String getResource(String key) {
        String value = ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.rpt.RPTResource", (String)key, (Locale)this.ctx.getLocale());
        return value;
    }
}

