/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckInterfaceCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckInterfaceInfo;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemFactory;
import com.kingdee.eas.ncm.cal.CalCostCheckItemInfo;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.cal.ICalCostCheckItem;
import com.kingdee.eas.ncm.cal.app.ICMCalChecker;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.BaseCostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LowTimer;
import java.awt.Color;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostCalCheckTaskExecutor
extends BaseCostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.CostCalCheckTaskExecutor");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.task.CostCalCheckResource";
    public static final String CHECK_ITEM_SHARE_CO_ID = "8RybwGlAnE2RyCcmyggqlBTDwsw=";
    private CalCostCheckItemCollection checkItems;
    private Map costTaskEntriesMap = null;
    private CostTaskEntryInfo totalEntry = null;
    private CostDataCache costDataCache = null;

    public LinkedList buildCostTaskEntries() throws BOSException, EASBizException {
        Class<?>[] cc;
        Set ids;
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        this.costTaskEntriesMap = new HashMap();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkStatus", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("calType", (Object)1));
        Integer stage = (Integer)this.param.get("stage");
        if (stage == null) {
            stage = 1;
        }
        if (stage == 5) {
            HashSet<Integer> stages = new HashSet<Integer>();
            stages.add(1);
            stages.add(stage);
            filter.getFilterItems().add(new FilterItemInfo("stage", stages, CompareType.INCLUDE));
            HashSet<Integer> seqs = new HashSet<Integer>();
            seqs.add(101);
            seqs.add(102);
            seqs.add(103);
            seqs.add(104);
            filter.getFilterItems().add(new FilterItemInfo("seq", seqs, CompareType.NOTINCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("stage", (Object)stage));
        }
        if (!NCMUtils.isCostObjectOfBillRequired((Context)this.ctx)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CHECK_ITEM_SHARE_CO_ID, CompareType.NOTEQUALS));
        }
        if ((ids = (Set)this.param.get("checkItem_ids")) != null && ids.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("stage"));
        sorter.add(new SorterItemInfo("type"));
        sorter.add(new SorterItemInfo("seq"));
        view.setSorter(sorter);
        for (Class<?> c : cc = BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)new BOSObjectType("14C3C2CC")).getClass().getInterfaces()) {
            logger.error((Object)("++++++++++++++" + c.getName() + "++++++++++"));
        }
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getLocalInstance(this.ctx);
        this.checkItems = iCalCostCheckItem.getCalCostCheckItemCollection(view);
        int cIitemSize = this.checkItems.size();
        for (int cItem = 0; cItem < cIitemSize; ++cItem) {
            this.checkItems.get(cItem).getCheckResult().clear();
        }
        int level = 0;
        Object oLevel = this.param.get("CostTaskLevel");
        if (oLevel != null && oLevel instanceof Integer && (level = ((Integer)oLevel).intValue()) < 0) {
            level = 0;
        }
        this.totalEntry = new CostTaskEntryInfo();
        this.totalEntry.setName(this.getResource("CHECK", NCMConst.l1), NCMConst.l1);
        this.totalEntry.setName(this.getResource("CHECK", NCMConst.l2), NCMConst.l2);
        this.totalEntry.setName(this.getResource("CHECK", NCMConst.l3), NCMConst.l3);
        this.totalEntry.setTypeSeq(4000);
        this.totalEntry.setSeq(0);
        this.totalEntry.setLevel(level);
        this.totalEntry.setLeaf(false);
        costTaskEntries.add(this.totalEntry);
        ++level;
        Color yellow = new Color(246, 246, 191);
        int cIitemSize2 = this.checkItems.size();
        for (int cItem = 0; cItem < cIitemSize2; ++cItem) {
            CalCostCheckItemInfo aCalCostCheckItemInfo = this.checkItems.get(cItem);
            CostTaskEntryInfo costTaskEntry = new CostTaskEntryInfo();
            costTaskEntry.setName(aCalCostCheckItemInfo.getSeq() + " " + aCalCostCheckItemInfo.getName(NCMConst.l1), NCMConst.l1);
            costTaskEntry.setName(aCalCostCheckItemInfo.getSeq() + " " + aCalCostCheckItemInfo.getName(NCMConst.l2), NCMConst.l2);
            costTaskEntry.setName(aCalCostCheckItemInfo.getSeq() + " " + aCalCostCheckItemInfo.getName(NCMConst.l3), NCMConst.l3);
            if (aCalCostCheckItemInfo.isIsNeed()) {
                costTaskEntry.setBackground(yellow.getRGB());
            }
            costTaskEntry.setProgress(1);
            costTaskEntry.setStatus(CostTaskStatusEnum.NULL);
            costTaskEntry.setResult(CostTaskResultEnum.NULL);
            costTaskEntry.setTypeSeq(4000);
            costTaskEntry.setSeq(cItem + 1);
            costTaskEntry.setLevel(level);
            costTaskEntry.setLeaf(true);
            this.costTaskEntriesMap.put(aCalCostCheckItemInfo, costTaskEntry);
            costTaskEntries.add(costTaskEntry);
        }
        return costTaskEntries;
    }

    public void beforeExecute() throws Exception {
        super.beforeExecute();
        if (!this.param.containsKey("CostDataCache")) {
            this.costDataCache = new CostDataCache(this.param);
            this.param.put("CostDataCache", this.costDataCache);
        }
    }

    public void afterExecute() throws Exception {
        if (this.costDataCache != null) {
            this.costDataCache.release();
            this.costDataCache = null;
        }
        super.afterExecute();
    }

    public CostTaskResultEnum doExecute() throws Exception {
        IObjectPK logPk = LogUtil.beginLog((Context)this.ctx, (String)"check", (BOSObjectType)BOSObjectType.create((String)"14C3C2CC"), null, (String)this.getResource("CHECK", this.ctx.getLocale()), (String)this.getResource("CHECK", this.ctx.getLocale()), (String)((String)this.param.get("companyId")));
        if (this.totalEntry != null) {
            this.totalEntry.setStatus(CostTaskStatusEnum.RUNNING);
            this.totalEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.totalEntry);
        }
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        String companyOrgID = (String)this.param.get("companyId");
        String periodID = (String)this.param.get("periodId");
        if (companyOrgID == null || periodID == null) {
            return CostTaskResultEnum.FAILURE;
        }
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getLocalInstance(this.ctx);
        CalCostCheckItemCheckInterfaceCollection aCheckInterface = null;
        CalCostCheckItemCheckResultCollection aCheckResult = null;
        CalCostCheckItemInfo aCalCostCheckItemInfo = null;
        LowTimer st = new LowTimer();
        String getcalcHMSString = "";
        long endTime = 0L;
        iCalCostCheckItem.delete("WHERE companyID = '" + companyOrgID + "' ");
        Exception exception = null;
        int cIitemSize = this.checkItems.size();
        for (int cItem = 0; cItem < cIitemSize; ++cItem) {
            exception = null;
            aCalCostCheckItemInfo = this.checkItems.get(cItem);
            CostTaskEntryInfo item = (CostTaskEntryInfo)this.costTaskEntriesMap.get(aCalCostCheckItemInfo);
            if (item != null) {
                item.setStatus(CostTaskStatusEnum.RUNNING);
                item.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
                this.updateCostTaskEntry(item);
            }
            aCalCostCheckItemInfo.setCompanyID(companyOrgID);
            if (aCalCostCheckItemInfo.getNumber() != null) continue;
            aCheckInterface = aCalCostCheckItemInfo.getCheckInterface();
            aCalCostCheckItemInfo.setNumber("isCheck");
            int cInterfaceSize = aCheckInterface.size();
            for (int cInterface = 0; cInterface < cInterfaceSize; ++cInterface) {
                try {
                    if (aCheckInterface.get(cInterface) == null || aCheckInterface.get(cInterface).getInterfaceName() == null) continue;
                    aCalCostCheckItemInfo.setStartDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    st = new LowTimer();
                    getcalcHMSString = "";
                    endTime = 0L;
                    Class<?> checkerClass = Class.forName(aCheckInterface.get(cInterface).getInterfaceName());
                    ICMCalChecker checker = (ICMCalChecker)checkerClass.newInstance();
                    aCheckResult = checker.calChecker(this.param);
                    if (aCheckResult != null) {
                        aCalCostCheckItemInfo.getCheckResult().addCollection(aCheckResult);
                    }
                    if (aCheckResult != null && aCheckResult.size() > 0) {
                        aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    } else {
                        aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.succeed);
                        aCalCostCheckItemInfo.setSimpleName("cost");
                    }
                    endTime = st.msValue();
                    getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                    logger.error((Object)"", (Throwable)e);
                    aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
                    CalCostCheckItemCheckResultInfo aCalCostCheckItemCheckResultInfo = new CalCostCheckItemCheckResultInfo();
                    aCalCostCheckItemCheckResultInfo.setDescription(NCMUtils.getNcmCheckResource((String)"CostCheckErrDescription"));
                    aCalCostCheckItemCheckResultInfo.setReason(NCMUtils.getNcmCheckResource((String)"CostCheckErrReason"));
                    aCalCostCheckItemCheckResultInfo.setSuggestOperation(NCMUtils.getNcmCheckResource((String)"CostCheckErrSuggestOperation"));
                    aCalCostCheckItemInfo.getCheckResult().add(aCalCostCheckItemCheckResultInfo);
                    aCalCostCheckItemInfo.setEndDateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    endTime = st.msValue();
                    getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
                    aCalCostCheckItemInfo.setCalcHMSString(getcalcHMSString);
                    break;
                }
            }
            if (aCheckInterface.size() == 0) {
                logger.error((Object)"check interface not exist2.");
                aCalCostCheckItemInfo.setCheckStatus(CheckStatusEnum.lost);
            }
            IObjectPK pk = this._saveCheckResultToDB(this.ctx, companyOrgID, aCalCostCheckItemInfo);
            if (item != null) {
                item.setStatus(CostTaskStatusEnum.FINISHED);
                if (aCalCostCheckItemInfo.getCheckResult().size() > 0) {
                    if (exception != null) {
                        item.setResult(CostTaskResultEnum.EXCEPTION);
                    } else if (aCalCostCheckItemInfo.isIsNeed()) {
                        item.setResult(CostTaskResultEnum.FAILURE);
                    } else {
                        item.setResult(CostTaskResultEnum.WARN);
                    }
                    item.setReport(this.getResource("ERROR_LOG", NCMConst.l1), NCMConst.l1);
                    item.setReport(this.getResource("ERROR_LOG", NCMConst.l2), NCMConst.l2);
                    item.setReport(this.getResource("ERROR_LOG", NCMConst.l3), NCMConst.l3);
                    item.setFunction("com.kingdee.eas.ncm.cal.client.CalfactCostLogUI");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("checkId", pk.toString());
                    item.setParam(CostTaskUtils.encode(map));
                } else {
                    item.setResult(CostTaskResultEnum.SUCCESS);
                }
                item.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
                this.updateCostTaskEntry(item);
                if (item.getResult().getValue() > result.getValue()) {
                    result = item.getResult();
                }
            }
            aCalCostCheckItemInfo.getCheckResult().clear();
            if (exception != null) break;
        }
        if (this.totalEntry != null) {
            this.totalEntry.setStatus(CostTaskStatusEnum.FINISHED);
            this.totalEntry.setResult(result);
            this.totalEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.totalEntry);
        }
        if (exception != null) {
            throw exception;
        }
        if (result.getValue() <= 3) {
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPk);
        }
        return result;
    }

    protected IObjectPK _saveCheckResultToDB(Context ctx, String companyOrgID, CalCostCheckItemInfo info) throws BOSException, EASBizException {
        info.setNumber(null);
        info.setSimpleName(null);
        info.setId(null);
        int interfaces = info.getCheckInterface().size();
        for (int j = 0; j < interfaces; ++j) {
            CalCostCheckItemCheckInterfaceInfo interfaceEntry = info.getCheckInterface().get(j);
            interfaceEntry.setId(null);
        }
        interfaces = info.getCheckResult().size();
        for (int k = 0; k < interfaces; ++k) {
            String reason;
            CalCostCheckItemCheckResultInfo checkResultEntry = info.getCheckResult().get(k);
            checkResultEntry.setId(null);
            String desc = checkResultEntry.getDescription();
            if (desc != null && desc.length() > 200) {
                checkResultEntry.setDescription(desc.substring(0, 197) + "...");
            }
            if ((reason = checkResultEntry.getReason()) == null || reason.length() <= 512) continue;
            checkResultEntry.setReason(reason.substring(0, 509) + "...");
        }
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getLocalInstance(ctx);
        return iCalCostCheckItem.addnew((CoreBaseInfo)info);
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }
}

