/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckInterfaceCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckInterfaceInfo;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemFactory;
import com.kingdee.eas.ncm.cal.CalCostCheckItemInfo;
import com.kingdee.eas.ncm.cal.CostCalReccLogFactory;
import com.kingdee.eas.ncm.cal.ICalCostCheckItem;
import com.kingdee.eas.ncm.common.app.ICMChecker;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.BaseCostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.util.ResourceBase;
import java.awt.Color;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostCalReccTaskExecutor
extends BaseCostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.task.app.CostCalReccTaskExecutor");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.task.CostCalReccResource";
    private CalCostCheckItemCollection checkItems;
    private Map costTaskEntriesMap = null;
    private CostTaskEntryInfo totalEntry = null;

    public LinkedList buildCostTaskEntries() throws BOSException, EASBizException {
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        this.costTaskEntriesMap = new HashMap();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkStatus", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("calType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("stage", (Object)7));
        Set ids = (Set)this.param.get("checkItem_ids");
        if (ids != null && ids.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("type"));
        sorter.add(new SorterItemInfo("seq"));
        view.setSorter(sorter);
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getLocalInstance(this.ctx);
        this.checkItems = iCalCostCheckItem.getCalCostCheckItemCollection(view);
        int cIitemSize = this.checkItems.size();
        for (int cItem = 0; cItem < cIitemSize; ++cItem) {
            this.checkItems.get(cItem).getCheckResult().clear();
        }
        int level = 0;
        Object oLevel = this.param.get("CostTaskLevel");
        if (oLevel != null && oLevel instanceof Integer && (level = ((Integer)oLevel).intValue()) < 0) {
            level = 0;
        }
        this.totalEntry = new CostTaskEntryInfo();
        this.totalEntry.setName(this.getResource("RECC", NCMConst.l1), NCMConst.l1);
        this.totalEntry.setName(this.getResource("RECC", NCMConst.l2), NCMConst.l2);
        this.totalEntry.setName(this.getResource("RECC", NCMConst.l3), NCMConst.l3);
        this.totalEntry.setTypeSeq(4000);
        this.totalEntry.setLevel(level);
        this.totalEntry.setLeaf(false);
        costTaskEntries.add(this.totalEntry);
        ++level;
        Color yellow = new Color(246, 246, 191);
        int cIitemSize2 = this.checkItems.size();
        for (int cItem = 0; cItem < cIitemSize2; ++cItem) {
            CalCostCheckItemInfo checkItem = this.checkItems.get(cItem);
            CostTaskEntryInfo costTaskEntry = new CostTaskEntryInfo();
            costTaskEntry.setName(checkItem.getName(NCMConst.l1), NCMConst.l1);
            costTaskEntry.setName(checkItem.getName(NCMConst.l2), NCMConst.l2);
            costTaskEntry.setName(checkItem.getName(NCMConst.l3), NCMConst.l3);
            if (checkItem.isIsNeed()) {
                costTaskEntry.setBackground(yellow.getRGB());
            }
            costTaskEntry.setProgress(1);
            costTaskEntry.setStatus(CostTaskStatusEnum.NULL);
            costTaskEntry.setResult(CostTaskResultEnum.NULL);
            costTaskEntry.setTypeSeq(4000);
            costTaskEntry.setSeq(cItem + 1);
            costTaskEntry.setLevel(level);
            costTaskEntry.setLeaf(true);
            this.costTaskEntriesMap.put(checkItem, costTaskEntry);
            costTaskEntries.add(costTaskEntry);
        }
        return costTaskEntries;
    }

    public CostTaskResultEnum doExecute() throws Exception {
        if (this.totalEntry != null) {
            this.totalEntry.setStatus(CostTaskStatusEnum.RUNNING);
            this.totalEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.totalEntry);
        }
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        if (companyId == null || periodId == null) {
            return CostTaskResultEnum.FAILURE;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("where company.id = '" + companyId + "' \n");
        CostCalReccLogFactory.getLocalInstance(this.ctx).delete(sql.toString());
        CalCostCheckItemCheckInterfaceCollection checkInterfaces = null;
        CalCostCheckItemInfo checkItem = null;
        for (int cIndex = 0; cIndex < this.checkItems.size(); ++cIndex) {
            checkItem = this.checkItems.get(cIndex);
            CostTaskEntryInfo item = (CostTaskEntryInfo)this.costTaskEntriesMap.get(checkItem);
            if (item != null) {
                item.setStatus(CostTaskStatusEnum.RUNNING);
                item.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
                this.updateCostTaskEntry(item);
            }
            CostTaskResultEnum checkItemResult = CostTaskResultEnum.SUCCESS;
            try {
                checkInterfaces = checkItem.getCheckInterface();
                for (int ciIndex = 0; ciIndex < checkInterfaces.size(); ++ciIndex) {
                    CalCostCheckItemCheckInterfaceInfo checkInterface = checkInterfaces.get(ciIndex);
                    if (checkInterface == null || checkInterface.getInterfaceName() == null) continue;
                    Class<?> checkerClass = Class.forName(checkInterface.getInterfaceName());
                    ICMChecker checker = (ICMChecker)checkerClass.newInstance();
                    this.param.put("checkItemId", checkItem.getId().toString());
                    this.param.put("checkInterfaceId", checkInterface.getId().toString());
                    CostTaskResultEnum checkInterfaceResult = (CostTaskResultEnum)checker.check(this.ctx, this.param);
                    if (checkInterfaceResult.getValue() <= checkItemResult.getValue()) continue;
                    checkItemResult = checkInterfaceResult;
                }
            }
            catch (Exception e) {
                checkItemResult = CostTaskResultEnum.FAILURE;
            }
            if (item == null) continue;
            item.setStatus(CostTaskStatusEnum.FINISHED);
            item.setResult(checkItemResult);
            item.setReport(this.getResource("RECC_REPORT", NCMConst.l1), NCMConst.l1);
            item.setReport(this.getResource("RECC_REPORT", NCMConst.l2), NCMConst.l2);
            item.setReport(this.getResource("RECC_REPORT", NCMConst.l3), NCMConst.l3);
            item.setFunction("com.kingdee.eas.ncm.cal.client.CostCalReccLogUI");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("companyId", companyId);
            map.put("periodId", periodId);
            map.put("checkItemId", checkItem.getId().toString());
            item.setParam(CostTaskUtils.encode(map));
            item.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(item);
            if (item.getResult().getValue() <= result.getValue()) continue;
            result = item.getResult();
        }
        if (this.totalEntry != null) {
            this.totalEntry.setStatus(CostTaskStatusEnum.FINISHED);
            this.totalEntry.setResult(result);
            this.totalEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.totalEntry);
        }
        return result;
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }
}

