/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.bill.task.app.AuxAllocTaskExecutor;
import com.kingdee.eas.ncm.bill.task.app.CCOAllocTaskExecutor;
import com.kingdee.eas.ncm.bill.task.app.CostAdjustAllocTaskExecutor;
import com.kingdee.eas.ncm.bill.task.app.MatReqAllocTaskExecutor;
import com.kingdee.eas.ncm.bill.task.app.OtherFeeAllocTaskExecutor;
import com.kingdee.eas.ncm.bill.task.app.OtherInWarehsAllocTaskExecutor;
import com.kingdee.eas.ncm.cal.app.Calc.CalcDispatch;
import com.kingdee.eas.ncm.cal.task.app.CostCalCheckTaskExecutor;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.BaseCostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostCalTaskExecutor
extends BaseCostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.CostCalTaskExecutor");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.task.CostCalResource";
    private CCOAllocTaskExecutor ccoExecutor = null;
    private MatReqAllocTaskExecutor matReqExecutor = null;
    private OtherInWarehsAllocTaskExecutor otherInWarehsExecutor = null;
    private CostAdjustAllocTaskExecutor costAdjustExecutor = null;
    private OtherFeeAllocTaskExecutor otherFeeExecutor = null;
    private AuxAllocTaskExecutor auxExecutor = null;
    private CostCalCheckTaskExecutor ckeckExecutor = null;
    private CalcDispatch calcDispatch = null;
    private CostTaskEntryInfo allocEntry = null;
    private CostTaskEntryInfo matEntry = null;
    private CostTaskEntryInfo calEntry = null;
    private CostDataCache costDataCache = null;

    public LinkedList buildCostTaskEntries() throws BOSException, EASBizException {
        Map checkParam;
        Map auxFeeAllocParam;
        Map otherFeeAllocParam;
        LinkedList checkEntries;
        Map costAdjustAllocParam;
        String companyID;
        boolean isIncludeCostAdjustData;
        Map otherInWarehsAllocParam;
        Map matReqAllocParam;
        LinkedList<CostTaskEntryInfo> entries = new LinkedList<CostTaskEntryInfo>();
        this.costDataCache = new CostDataCache(this.param);
        this.param.put("CostDataCache", this.costDataCache);
        Map ccoAllocParam = (Map)this.param.get("ccoAllocParam");
        if (ccoAllocParam != null) {
            ccoAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)ccoAllocParam);
            this.ccoExecutor = new CCOAllocTaskExecutor();
            this.ccoExecutor.init(this.ctx, this.costTask, ccoAllocParam);
            LinkedList checkEntries2 = this.ccoExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries2);
        }
        if ((matReqAllocParam = (Map)this.param.get("matReqAllocParam")) != null) {
            matReqAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)matReqAllocParam);
            this.matReqExecutor = new MatReqAllocTaskExecutor();
            matReqAllocParam.put("CostTaskLevel", 2);
            this.matReqExecutor.init(this.ctx, this.costTask, matReqAllocParam);
            LinkedList checkEntries3 = this.matReqExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries3);
        }
        if ((otherInWarehsAllocParam = (Map)this.param.get("otherInWarehsAllocParam")) != null) {
            otherInWarehsAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)otherInWarehsAllocParam);
            this.otherInWarehsExecutor = new OtherInWarehsAllocTaskExecutor();
            this.otherInWarehsExecutor.init(this.ctx, this.costTask, otherInWarehsAllocParam);
            LinkedList checkEntries4 = this.otherInWarehsExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries4);
        }
        if ((isIncludeCostAdjustData = NCMUtils.isIncludeCostAdjustData((Context)this.ctx, (String)(companyID = (String)this.param.get("companyId")))) && (costAdjustAllocParam = (Map)this.param.get("costAdjustAllocParam")) != null) {
            costAdjustAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)costAdjustAllocParam);
            this.costAdjustExecutor = new CostAdjustAllocTaskExecutor();
            this.costAdjustExecutor.init(this.ctx, this.costTask, costAdjustAllocParam);
            checkEntries = this.costAdjustExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries);
        }
        if (this.matReqExecutor != null || this.otherInWarehsExecutor != null || this.costAdjustExecutor != null) {
            this.matEntry = new CostTaskEntryInfo();
            this.matEntry.setName(this.getResource("MAT_FEE_ALLOC", NCMConst.l1), NCMConst.l1);
            this.matEntry.setName(this.getResource("MAT_FEE_ALLOC", NCMConst.l2), NCMConst.l2);
            this.matEntry.setName(this.getResource("MAT_FEE_ALLOC", NCMConst.l3), NCMConst.l3);
            this.matEntry.setTypeSeq(1200);
            this.matEntry.setStatus(CostTaskStatusEnum.NULL);
            this.matEntry.setResult(CostTaskResultEnum.NULL);
            this.matEntry.setLevel(1);
            this.matEntry.setLeaf(false);
            entries.add(this.matEntry);
        }
        if ((otherFeeAllocParam = (Map)this.param.get("otherFeeAllocParam")) != null) {
            otherFeeAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)otherFeeAllocParam);
            this.otherFeeExecutor = new OtherFeeAllocTaskExecutor();
            otherFeeAllocParam.put("CostTaskLevel", 1);
            this.otherFeeExecutor.init(this.ctx, this.costTask, otherFeeAllocParam);
            checkEntries = this.otherFeeExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries);
        }
        if ((auxFeeAllocParam = (Map)this.param.get("auxFeeAllocParam")) != null) {
            auxFeeAllocParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)auxFeeAllocParam);
            this.auxExecutor = new AuxAllocTaskExecutor();
            this.auxExecutor.init(this.ctx, this.costTask, auxFeeAllocParam);
            LinkedList checkEntries5 = this.auxExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries5);
        }
        if (this.ccoExecutor != null || this.matReqExecutor != null || this.otherInWarehsExecutor != null || this.costAdjustExecutor != null || this.otherFeeExecutor != null || this.auxExecutor != null) {
            this.allocEntry = new CostTaskEntryInfo();
            this.allocEntry.setName(this.getResource("FEE_ALLOC", NCMConst.l1), NCMConst.l1);
            this.allocEntry.setName(this.getResource("FEE_ALLOC", NCMConst.l2), NCMConst.l2);
            this.allocEntry.setName(this.getResource("FEE_ALLOC", NCMConst.l3), NCMConst.l3);
            this.allocEntry.setTypeSeq(1000);
            this.allocEntry.setStatus(CostTaskStatusEnum.NULL);
            this.allocEntry.setResult(CostTaskResultEnum.NULL);
            this.allocEntry.setLevel(0);
            this.allocEntry.setLeaf(false);
            entries.add(this.allocEntry);
        }
        if ((checkParam = (Map)this.param.get("checkParam")) != null) {
            checkParam.put("CostDataCache", this.costDataCache);
            CostTaskUtils.setSubTask((Map)checkParam);
            checkParam.put("stage", 5);
            this.ckeckExecutor = new CostCalCheckTaskExecutor();
            checkParam.put("CostTaskLevel", 1);
            this.ckeckExecutor.init(this.ctx, this.costTask, checkParam);
            LinkedList checkEntries6 = this.ckeckExecutor.buildCostTaskEntries();
            entries.addAll(checkEntries6);
        }
        this.calEntry = new CostTaskEntryInfo();
        this.calEntry.setName(this.getResource("COST_CAL", NCMConst.l1), NCMConst.l1);
        this.calEntry.setName(this.getResource("COST_CAL", NCMConst.l2), NCMConst.l2);
        this.calEntry.setName(this.getResource("COST_CAL", NCMConst.l3), NCMConst.l3);
        this.calEntry.setTypeSeq(3000);
        this.calEntry.setSeq(0);
        this.calEntry.setStatus(CostTaskStatusEnum.NULL);
        this.calEntry.setResult(CostTaskResultEnum.NULL);
        this.calEntry.setLevel(0);
        this.calEntry.setLeaf(false);
        entries.add(this.calEntry);
        this.calcDispatch = new CalcDispatch(this.param);
        this.param.put("CostTaskExecutor", this);
        LinkedList calEntries = this.calcDispatch.buildCostTaskEntries();
        entries.addAll(calEntries);
        return entries;
    }

    public void afterExecute() throws Exception {
        Exception e;
        block4: {
            e = null;
            try {
                if (this.costDataCache != null) {
                    this.costDataCache.release();
                }
            }
            catch (Exception ex) {
                if (e != null) break block4;
                e = ex;
            }
        }
        super.afterExecute();
        if (e != null) {
            throw e;
        }
    }

    public CostTaskResultEnum doExecute() throws Throwable {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        Throwable throwable = null;
        if (this.allocEntry != null) {
            this.allocEntry.setStatus(CostTaskStatusEnum.RUNNING);
            this.allocEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.allocEntry);
        }
        CostTaskResultEnum isAllocSuccess = this.doAlloc();
        if (this.allocEntry != null) {
            this.allocEntry.setStatus(CostTaskStatusEnum.FINISHED);
            this.allocEntry.setResult(isAllocSuccess);
            this.allocEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.allocEntry);
        }
        if (isAllocSuccess.getValue() > result.getValue()) {
            result = isAllocSuccess;
        }
        if (result.getValue() >= 7) {
            return result;
        }
        this.calEntry.setStatus(CostTaskStatusEnum.RUNNING);
        this.calEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
        this.updateCostTaskEntry(this.calEntry);
        CostTaskResultEnum isCalSuccess = CostTaskResultEnum.SUCCESS;
        try {
            isCalSuccess = this.doCal();
        }
        catch (Throwable t) {
            isCalSuccess = CostTaskResultEnum.EXCEPTION;
            throwable = t;
        }
        this.calEntry.setStatus(CostTaskStatusEnum.FINISHED);
        this.calEntry.setResult(isCalSuccess);
        this.calEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
        this.calEntry.setReport(this.getResource("VIEW_REPORT", NCMConst.l1), NCMConst.l1);
        this.calEntry.setReport(this.getResource("VIEW_REPORT", NCMConst.l2), NCMConst.l2);
        this.calEntry.setReport(this.getResource("VIEW_REPORT", NCMConst.l3), NCMConst.l3);
        this.calEntry.setFunction("com.kingdee.eas.ncm.cal.client.CostCalcLogReportUI");
        HashMap map = new HashMap();
        map.put("companyId", this.param.get("companyId"));
        map.put("periodId", this.param.get("periodId"));
        this.calEntry.setParam(CostTaskUtils.encode(map));
        this.updateCostTaskEntry(this.calEntry);
        if (isCalSuccess.getValue() > result.getValue()) {
            result = isCalSuccess;
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    private CostTaskResultEnum doAlloc() throws BOSException, EASBizException {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        CostTaskResultEnum isCCOAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.ccoExecutor != null) {
            isCCOAllocSuccess = this.ccoExecutor.execute();
        }
        if (isCCOAllocSuccess.getValue() > result.getValue()) {
            result = isCCOAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        if (this.matEntry != null) {
            this.matEntry.setStatus(CostTaskStatusEnum.RUNNING);
            this.matEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.matEntry);
        }
        CostTaskResultEnum isMatAllocSuccess = this.doMatAlloc();
        if (this.matEntry != null) {
            this.matEntry.setStatus(CostTaskStatusEnum.FINISHED);
            this.matEntry.setResult(isMatAllocSuccess);
            this.matEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
            this.updateCostTaskEntry(this.matEntry);
        }
        if (isMatAllocSuccess.getValue() > result.getValue()) {
            result = isMatAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        CostTaskResultEnum isOtherAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.otherFeeExecutor != null) {
            isOtherAllocSuccess = this.otherFeeExecutor.execute();
        }
        if (isOtherAllocSuccess.getValue() > result.getValue()) {
            result = isOtherAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        CostTaskResultEnum isAuxAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.auxExecutor != null) {
            isAuxAllocSuccess = this.auxExecutor.execute();
        }
        if (isAuxAllocSuccess.getValue() > result.getValue()) {
            result = isAuxAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        return result;
    }

    private CostTaskResultEnum doMatAlloc() {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        CostTaskResultEnum isMatReqAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.matReqExecutor != null) {
            isMatReqAllocSuccess = this.matReqExecutor.execute();
        }
        if (isMatReqAllocSuccess.getValue() > result.getValue()) {
            result = isMatReqAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        CostTaskResultEnum isOIAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.otherInWarehsExecutor != null) {
            isOIAllocSuccess = this.otherInWarehsExecutor.execute();
        }
        if (isOIAllocSuccess.getValue() > result.getValue()) {
            result = isOIAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        CostTaskResultEnum isCAAllocSuccess = CostTaskResultEnum.SUCCESS;
        if (this.costAdjustExecutor != null) {
            isCAAllocSuccess = this.costAdjustExecutor.execute();
        }
        if (isCAAllocSuccess.getValue() > result.getValue()) {
            result = isCAAllocSuccess;
        }
        if (result.getValue() >= CostTaskResultEnum.FAILURE.getValue()) {
            return result;
        }
        return result;
    }

    private CostTaskResultEnum doCal() throws Throwable {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        CostTaskResultEnum isCheckSuccess = CostTaskResultEnum.SUCCESS;
        if (this.ckeckExecutor != null) {
            isCheckSuccess = this.ckeckExecutor.execute();
        }
        if (isCheckSuccess.getValue() > result.getValue()) {
            result = isCheckSuccess;
        }
        if (result.getValue() >= 7) {
            return result;
        }
        CostTaskResultEnum isCalSuccess = CostTaskResultEnum.FAILURE;
        HashMap calResult = this.calcDispatch.doCalc();
        if (calResult.get("result") != null && calResult.get("result") instanceof CostTaskResultEnum) {
            isCalSuccess = (CostTaskResultEnum)calResult.get("result");
        }
        if (isCalSuccess.getValue() > result.getValue()) {
            result = isCalSuccess;
        }
        return result;
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }
}

