/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.ICalCostFacade;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.BaseCostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostRecoveryTaskExecutor
extends BaseCostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.task.app.CostRecoveryTaskExecutor");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.task.CostRecoveryResource";
    private Map costTaskEntriesMap = null;
    private int dispRank = 0;
    private int rankSeq = 1;

    public CostTaskResultEnum doExecute() throws Throwable {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        Throwable throwable = null;
        this.updateCostTaskEntryRunning("recoveryTotal");
        try {
            CostTaskResultEnum isCheckSuccess = this.doCheck();
            if (isCheckSuccess.getValue() > result.getValue()) {
                result = isCheckSuccess;
            }
            if (result.getValue() >= 7) {
                return result;
            }
            CostTaskResultEnum isCalSuccess = this.doCal();
            if (isCalSuccess.getValue() > result.getValue()) {
                result = isCalSuccess;
            }
        }
        catch (Throwable t) {
            result = CostTaskResultEnum.FAILURE;
            throwable = t;
        }
        CostTaskEntryInfo recoveryTotal = this.getCostTaskEntry("recoveryTotal");
        recoveryTotal.setStatus(CostTaskStatusEnum.FINISHED);
        recoveryTotal.setResult(result);
        recoveryTotal.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.simpleCtx)));
        recoveryTotal.setReport(this.getResource("RECOVERY_REPORT", NCMConst.l1), NCMConst.l1);
        recoveryTotal.setReport(this.getResource("RECOVERY_REPORT", NCMConst.l2), NCMConst.l2);
        recoveryTotal.setReport(this.getResource("RECOVERY_REPORT", NCMConst.l3), NCMConst.l3);
        recoveryTotal.setFunction("com.kingdee.eas.ncm.cal.client.RecoveryCalcLogReportUI");
        HashMap logUIParam = new HashMap();
        logUIParam.put("companyId", this.param.get("companyId"));
        logUIParam.put("periodId", this.param.get("periodId"));
        recoveryTotal.setParam(CostTaskUtils.encode(logUIParam));
        this.updateCostTaskEntry(recoveryTotal);
        if (throwable != null) {
            throw throwable;
        }
        return recoveryTotal.getResult();
    }

    private CostTaskResultEnum doCheck() throws Exception {
        if (this.param.containsKey("RecoveryCheck") && this.param.get("RecoveryCheck").equals("true")) {
            ICalCostFacade iCalCostFacade = CalCostFacadeFactory.getLocalInstance(this.ctx);
            try {
                this.updateCostTaskEntryRunning("recoveryStepCheck");
                Map resultMap = iCalCostFacade.CostRecoveryCheck(this.param);
                CostTaskEntryInfo recoveryStepCheck = this.getCostTaskEntry("recoveryStepCheck");
                recoveryStepCheck.setReport(this.getResource("CHECK_REPORT", NCMConst.l1), NCMConst.l1);
                recoveryStepCheck.setReport(this.getResource("CHECK_REPORT", NCMConst.l2), NCMConst.l2);
                recoveryStepCheck.setReport(this.getResource("CHECK_REPORT", NCMConst.l3), NCMConst.l3);
                recoveryStepCheck.setFunction("com.kingdee.eas.ncm.cal.client.RecoveryCheckLogReportUI");
                HashMap logUIParam = new HashMap();
                logUIParam.put("companyId", this.param.get("companyId"));
                logUIParam.put("periodId", this.param.get("periodId"));
                recoveryStepCheck.setParam(CostTaskUtils.encode(logUIParam));
                if (resultMap.get("HasError").equals(String.valueOf(true))) {
                    if (resultMap.get("CanContinueRecovery").equals(String.valueOf(false))) {
                        this.updateCostTaskEntryFinished("recoveryStepCheck", CostTaskResultEnum.FAILURE);
                        return CostTaskResultEnum.FAILURE;
                    }
                    this.updateCostTaskEntryFinished("recoveryStepCheck", CostTaskResultEnum.WARN);
                    return CostTaskResultEnum.WARN;
                }
                this.updateCostTaskEntryFinished("recoveryStepCheck");
                return CostTaskResultEnum.SUCCESS;
            }
            catch (Exception e) {
                this.updateCostTaskEntryFinished("recoveryStepCheck", CostTaskResultEnum.FAILURE);
                throw e;
            }
        }
        return CostTaskResultEnum.SUCCESS;
    }

    private CostTaskResultEnum doCal() throws Exception {
        String companyId = (String)this.param.get("companyId");
        String periodId = (String)this.param.get("periodId");
        this.param.put("rank", String.valueOf(-1));
        this.param.put("dispRank", String.valueOf(-1));
        this.param.put("costTask", this);
        ICalCostFacade iCalCostFacade = CalCostFacadeFactory.getLocalInstance(this.ctx);
        int lowestRank = -1;
        try {
            this.updateCostTaskEntryRunning("recoveryStepGetRank");
            lowestRank = iCalCostFacade.getLowestRankFromCalcResult(companyId, periodId);
            this.updateCostTaskEntryFinished("recoveryStepGetRank");
        }
        catch (Exception e) {
            this.updateCostTaskEntryFinished("recoveryStepGetRank", CostTaskResultEnum.FAILURE);
            throw e;
        }
        if (lowestRank > 0) {
            this.buildRankCostTaskEntries(lowestRank);
        }
        try {
            this.updateCostTaskEntryRunning("recoveryStepClear");
            iCalCostFacade.CostRecoveryPreProcess(this.param);
            this.updateCostTaskEntryFinished("recoveryStepClear");
        }
        catch (Exception e) {
            this.updateCostTaskEntryFinished("recoveryStepClear", CostTaskResultEnum.FAILURE);
            throw e;
        }
        int dispRank = 0;
        for (int rank = lowestRank; rank >= 0; --rank) {
            this.param.put("rank", String.valueOf(rank));
            this.param.put("dispRank", String.valueOf(++dispRank));
            try {
                this.updateCostTaskEntryRunning("recoveryStepRank" + dispRank);
                this.param.put("costTaskEntriesMap", this.costTaskEntriesMap);
                iCalCostFacade.CostRecovery(this.param);
                this.updateCostTaskEntryFinished("recoveryStepRank" + dispRank);
                continue;
            }
            catch (Exception e) {
                this.updateCostTaskEntryFinished("recoveryStepRank" + dispRank, CostTaskResultEnum.FAILURE);
                throw e;
            }
        }
        try {
            this.updateCostTaskEntryRunning("recoveryStepEnd");
            iCalCostFacade.CostRecoveryEndProcess(this.param);
            this.updateCostTaskEntryFinished("recoveryStepEnd");
        }
        catch (Exception e) {
            this.updateCostTaskEntryFinished("recoveryStepEnd", CostTaskResultEnum.FAILURE);
            throw e;
        }
        return CostTaskResultEnum.SUCCESS;
    }

    public CostTaskEntryInfo getCostTaskEntry(String number) {
        if (number != null && this.costTaskEntriesMap != null) {
            return (CostTaskEntryInfo)this.costTaskEntriesMap.get(number);
        }
        return null;
    }

    public LinkedList buildCostTaskEntries() throws BOSException, EASBizException {
        if (this.costTaskEntriesMap != null) {
            return null;
        }
        this.costTaskEntriesMap = new HashMap();
        LinkedList<CostTaskEntryInfo> entries = new LinkedList<CostTaskEntryInfo>();
        CostTaskEntryInfo recoveryTotal = new CostTaskEntryInfo();
        recoveryTotal.setName(this.getResource("RECOVERY", NCMConst.l3), NCMConst.l3);
        this.setCostTaskEntryName(recoveryTotal, "RECOVERY");
        recoveryTotal.setProgress(1);
        recoveryTotal.setStatus(CostTaskStatusEnum.NULL);
        recoveryTotal.setResult(CostTaskResultEnum.NULL);
        recoveryTotal.setTypeSeq(1100);
        recoveryTotal.setSeq(0);
        recoveryTotal.setLevel(0);
        recoveryTotal.setLeaf(false);
        entries.add(recoveryTotal);
        this.costTaskEntriesMap.put("recoveryTotal", recoveryTotal);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
        this.param.put("ctx", this.ctx);
        this.param.put("CU_ID", DefaultCU.getId().toString());
        this.param.put("CostTaskExecutor", this);
        if (this.param.containsKey("RecoveryCheck") && this.param.get("RecoveryCheck").equals("true")) {
            CostTaskEntryInfo recoveryStepCheck = new CostTaskEntryInfo();
            this.setCostTaskEntryName(recoveryStepCheck, "recoveryStepCheck");
            recoveryStepCheck.setTypeSeq(1100);
            recoveryStepCheck.setSeq(this.rankSeq++);
            recoveryStepCheck.setProgress(3);
            recoveryStepCheck.setResult(CostTaskResultEnum.NULL);
            recoveryStepCheck.setLevel(1);
            recoveryStepCheck.setLeaf(true);
            entries.add(recoveryStepCheck);
            this.costTaskEntriesMap.put("recoveryStepCheck", recoveryStepCheck);
        }
        CostTaskEntryInfo recoveryStepGetRank = new CostTaskEntryInfo();
        this.setCostTaskEntryName(recoveryStepGetRank, "recoveryStepGetRank");
        recoveryStepGetRank.setTypeSeq(1100);
        recoveryStepGetRank.setSeq(this.rankSeq++);
        recoveryStepGetRank.setProgress(3);
        recoveryStepGetRank.setResult(CostTaskResultEnum.NULL);
        recoveryStepGetRank.setLevel(1);
        recoveryStepGetRank.setLeaf(true);
        entries.add(recoveryStepGetRank);
        this.costTaskEntriesMap.put("recoveryStepGetRank", recoveryStepGetRank);
        CostTaskEntryInfo recoveryStepClear = new CostTaskEntryInfo();
        this.setCostTaskEntryName(recoveryStepClear, "recoveryStepClear");
        recoveryStepClear.setTypeSeq(1100);
        recoveryStepClear.setSeq(this.rankSeq++);
        recoveryStepClear.setProgress(2);
        recoveryStepClear.setResult(CostTaskResultEnum.NULL);
        recoveryStepClear.setLevel(1);
        recoveryStepClear.setLeaf(true);
        entries.add(recoveryStepClear);
        this.costTaskEntriesMap.put("recoveryStepClear", recoveryStepClear);
        LinkedList rankEntries = this.buildRankCostTaskEntries(0);
        entries.addAll(rankEntries);
        CostTaskEntryInfo recoveryStepEnd = new CostTaskEntryInfo();
        this.setCostTaskEntryName(recoveryStepEnd, "recoveryStepEnd");
        recoveryStepEnd.setTypeSeq(1101);
        recoveryStepEnd.setSeq(0);
        recoveryStepEnd.setProgress(2);
        recoveryStepEnd.setResult(CostTaskResultEnum.NULL);
        recoveryStepEnd.setLevel(1);
        recoveryStepEnd.setLeaf(true);
        entries.add(recoveryStepEnd);
        this.costTaskEntriesMap.put("recoveryStepEnd", recoveryStepEnd);
        return entries;
    }

    public LinkedList buildRankCostTaskEntries(int lowest) throws BOSException, EASBizException {
        LinkedList<CostTaskEntryInfo> costTaskEntries = new LinkedList<CostTaskEntryInfo>();
        for (int rank = lowest; rank >= (lowest > 0 ? 1 : 0); --rank) {
            ++this.dispRank;
            CostTaskEntryInfo recoveryStepRank = new CostTaskEntryInfo();
            this.setCostTaskEntryName(recoveryStepRank, "recoveryStepRank", new Object[]{this.dispRank});
            recoveryStepRank.setTypeSeq(1100);
            recoveryStepRank.setSeq(this.rankSeq++);
            recoveryStepRank.setProgress(3);
            recoveryStepRank.setResult(CostTaskResultEnum.NULL);
            recoveryStepRank.setLevel(1);
            recoveryStepRank.setLeaf(true);
            costTaskEntries.add(recoveryStepRank);
            this.costTaskEntriesMap.put("recoveryStepRank" + this.dispRank, recoveryStepRank);
        }
        if (lowest > 0 && costTaskEntries.size() > 0) {
            this.addCostTaskEntries(costTaskEntries);
        }
        return costTaskEntries;
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName) {
        this.setCostTaskEntryName(costTaskEntry, resName, null);
    }

    private void setCostTaskEntryName(CostTaskEntryInfo costTaskEntry, String resName, Object[] params) {
        if (params == null) {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3), NCMConst.l3);
        } else {
            costTaskEntry.setName(this.getResource(resName, NCMConst.l1, params), NCMConst.l1);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l2, params), NCMConst.l2);
            costTaskEntry.setName(this.getResource(resName, NCMConst.l3, params), NCMConst.l3);
        }
    }

    protected String getResource(String resName, Locale locale) {
        return this.getResource(resName, locale, null);
    }

    protected String getResource(String resName, Locale locale, Object[] params) {
        String str = ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
        if (params != null) {
            str = MessageFormat.format(str, params);
        }
        return str;
    }
}

