/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.bill.app.CostDataCache;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class CalSeverUtils {
    public static String getNcmCheckResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.CheckResource", (String)key, (Locale)ctx.getLocale());
    }

    public static int getLowestRank(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT TOP 1 B.FRank FROM T_CAL_CostObjectRank A LEFT OUTER JOIN ").append(" T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" WHERE A.FLlcType=0 AND A.FBillStatus =4 AND A.FLlcType=0 ").append(" AND A.FCOMPANYORG ='").append(companyId).append("' AND A.FCalculatePeriod ='").append(periodId).append("' ").append(" ORDER BY B.FRank DESC");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() == 0) {
            return -1;
        }
        try {
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static int getDynLowestRank(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT TOP 1 B.FRank FROM T_CAL_CostObjectRank A LEFT OUTER JOIN ").append(" T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" WHERE A.FBillStatus =4 AND A.FLlcType=2 ").append(" AND A.FCOMPANYORG ='").append(companyId).append("' ").append(" ORDER BY B.FRank DESC");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() == 0) {
            return -1;
        }
        try {
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static int getLowestRankByCostRecovery(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT TOP 1 B.FRank FROM T_CAL_CostObjectRank A LEFT OUTER JOIN ").append(" T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" WHERE A.FBillStatus =4 AND A.FLlcType=1 ").append(" AND A.FCOMPANYORG ='").append(companyId).append("' AND A.FCalculatePeriod ='").append(periodId).append("' ").append(" ORDER BY B.FRank DESC");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() == 0) {
            return -1;
        }
        try {
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static CostObjectCollection getCOForRank(Context ctx, String comId, String periodId, int rank) throws BOSException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT  B.FCostObjectID FROM T_CAL_CostObjectRank A LEFT OUTER JOIN ").append(" T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" WHERE A.FLlcType=0 AND A.FBillStatus =4").append(" AND A.FCOMPANYORG =").append(comId).append(" AND A.FCalculatePeriod =").append(periodId).append(" AND B.FRank =").append(rank);
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)query.toString());
        if (rs.size() == 0) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        try {
            while (rs.next() && rs.getString(1) != null) {
                hs.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        view.setFilter(filter);
        ICostObject ico = CostObjectFactory.getLocalInstance((Context)ctx);
        CostObjectCollection coColl = ico.getCostObjectCollection(view);
        return coColl;
    }

    public static void ClearInvalidAllocResult(Map param) throws EASBizException, BOSException, SQLException {
        Context ctx = (Context)param.get("ctx");
        String companyId = (String)param.get("companyId");
        String periodId = (String)param.get("periodId");
        String tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        String tblOtherAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult");
        String tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult_Adjust");
        String tblOtherAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult_Adjust");
        CostDataCache costDataCache = (CostDataCache)param.get("CostDataCache");
        String T_TMP_MatReq = costDataCache.getMatReqTable();
        StringBuffer sb = new StringBuffer();
        sb.append("Delete from ").append(tblMatAllocResult).append(" ").append('\n').append("where FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom " + T_TMP_MatReq + " S ").append("\twhere S.FSourceBillEntryID=").append(tblMatAllocResult).append(".FSourceBillEntryID ").append('\n').append(")").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_CL_CostAdjustBill S").append("\tinner join T_CL_CostAdjustBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append('\n').append(")").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_IM_OtherInWarehsBill S").append("\tinner join T_IM_OtherInWarehsBillEntry entry on entry.FParentID=S.FID ").append("   inner join T_ORG_CostCenter cc on cc.FID = S.FCostCenterOrgUnitID \n").append("   inner join T_SCM_TransactionType tt on tt.FID = S.FTransactionTypeID \n").append("\tinner join T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid  ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append("     AND S.FIsReversed = 0 AND cc.FCostCenterType = 0 AND tt.FIsManuCostCalculate = 1 and st.FISFORWARDAMT = 1 \n").append('\n').append(");").append('\n');
        sb.append("Delete from ").append(tblOtherAllocResult).append(" ").append("where FCalculatePeriodID='").append(periodId).append("' ").append("\tand not exists(").append("\tSelect 1").append("\tfrom T_NCM_OtherFeeBill S").append("\tinner join T_NCM_OtherFeeBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblOtherAllocResult).append(".FSourceBillID AND entry.FID=").append(tblOtherAllocResult).append(".FSourceBillEntryID and S.FBillStatus=4").append(");").append('\n');
        sb.append("truncate table ").append(tblMatAllocResult_Adjust).append(";").append('\n');
        sb.append("truncate table ").append(tblOtherAllocResult_Adjust).append(";").append('\n');
        String tblAuxAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AuxAllocResult");
        sb.append("Delete from ").append(tblAuxAllocResult).append(" ").append("where FCalculatePeriodID='").append(periodId).append("' ").append("\tand not exists(").append("\tSelect 1").append("\tfrom T_NCM_InnerOverheadBill S").append("\tinner join T_NCM_InnerOverheadBillEntry entry on entry.FParentID=S.FID ").append("\tINNER JOIN T_ORG_CostCenter CC ON ENTRY.FConsumeCostCenterID = CC.FID ").append("\twhere S.FID=").append(tblAuxAllocResult).append(".FSourceBillID AND entry.FID=").append(tblAuxAllocResult).append(".FSourceBillEntryID and S.FBillStatus=4").append("\t\t  AND CC.FCostCenterType < 2 ").append(");").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    public static void ClearInvalidMatFeeAllocResult(Context ctx, String companyId, String periodId) throws EASBizException, BOSException, SQLException {
        String tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        String tblMatAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult_Adjust");
        StringBuffer sb = new StringBuffer();
        sb.append("Delete from ").append(tblMatAllocResult).append(" ").append('\n').append("where FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_IM_MaterialReqBill S").append("\tinner join T_IM_MaterialReqBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append('\n').append(")").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_CL_CostAdjustBill S").append("\tinner join T_CL_CostAdjustBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append('\n').append(")").append('\n').append("AND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_IM_OtherInWarehsBill S").append("\tinner join T_IM_OtherInWarehsBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append('\n').append(");").append('\n');
        sb.append("truncate table ").append(tblMatAllocResult_Adjust).append(";").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    public static void ClearInvalidOtherFeeAllocResult(Context ctx, String companyId, String periodId) throws EASBizException, BOSException, SQLException {
        String tblOtherAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult");
        String tblOtherAllocResult_Adjust = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OtherAllocResult_Adjust");
        StringBuffer sb = new StringBuffer();
        sb.append("Delete from ").append(tblOtherAllocResult).append(" ").append("where FCalculatePeriodID='").append(periodId).append("' ").append("\tand not exists(").append("\tSelect 1").append("\tfrom T_NCM_OtherFeeBill S").append("\tinner join T_NCM_OtherFeeBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblOtherAllocResult).append(".FSourceBillID AND entry.FID=").append(tblOtherAllocResult).append(".FSourceBillEntryID and S.FBillStatus=4").append(");").append('\n');
        sb.append("truncate table ").append(tblOtherAllocResult_Adjust).append(";").append('\n');
        String tblAuxAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_AuxAllocResult");
        sb.append("Delete from ").append(tblAuxAllocResult).append(" ").append("where FCalculatePeriodID='").append(periodId).append("' ").append("\tand not exists(").append("\tSelect 1").append("\tfrom T_NCM_InnerOverheadBill S").append("\tinner join T_NCM_InnerOverheadBillEntry entry on entry.FParentID=S.FID ").append("\tINNER JOIN T_ORG_CostCenter CC ON ENTRY.FConsumeCostCenterID = CC.FID ").append("\twhere S.FID=").append(tblAuxAllocResult).append(".FSourceBillID AND entry.FID=").append(tblAuxAllocResult).append(".FSourceBillEntryID and S.FBillStatus=4").append("\t\t  AND CC.FCostCenterType < 2 ").append(");").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    public static void DynClearInvalidAllocResult(Context ctx, String companyId, String periodId) throws EASBizException, BOSException, SQLException {
        String tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_DynMatAllocResult");
        StringBuffer sb = new StringBuffer();
        sb.append("Delete from ").append(tblMatAllocResult).append(" ").append('\n').append("where FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("\tAND not exists(").append('\n').append("\tSelect 1").append("\tfrom T_IM_MaterialReqBill S").append("\tinner join T_IM_MaterialReqBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append(" \tUNION ALL ").append('\n').append("\tSelect 1").append("\tfrom T_CL_CostAdjustBill S").append("\tinner join T_CL_CostAdjustBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append(" \tUNION ALL ").append('\n').append("\tSelect 1").append("\tfrom T_IM_OtherInWarehsBill S").append("\tinner join T_IM_OtherInWarehsBillEntry entry on entry.FParentID=S.FID ").append("\twhere S.FID=").append(tblMatAllocResult).append(".FSourceBillID AND entry.FID=").append(tblMatAllocResult).append(".FSourceBillEntryID and S.FBaseStatus=4").append('\n').append(");").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
    }

    public static String getParamString(Context ctx, RptParams filter, String key) {
        Object ov = filter.getObject(key);
        if (UIRuleUtil.isNotNull((Object)ov)) {
            if (ov instanceof String) {
                return (String)ov;
            }
            if (ov instanceof IObjectValue) {
                return ((AbstractObjectValue)ov).getString("number");
            }
            if (ov instanceof Collection) {
                Collection coll = (Collection)ov;
                return coll.size() > 1 ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.CALAutoGenerateResource", (String)"0_CalSeverUtils", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.CALAutoGenerateResource", (String)"1_CalSeverUtils", (Locale)ctx.getLocale());
            }
        }
        return "";
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, String periodId) throws BOSException, EASBizException {
        ObjectUuidPK periodInfoPK = new ObjectUuidPK(BOSUuid.read((String)periodId));
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = iPeriod.getPeriodInfo((IObjectPK)periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("endDate"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, String periodId) throws BOSException, EASBizException {
        ObjectUuidPK periodInfoPK = new ObjectUuidPK(BOSUuid.read((String)periodId));
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = iPeriod.getPeriodInfo((IObjectPK)periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getBeginDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("endDate");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(0);
        }
        return prePeriodInfo;
    }
}

