/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllcoUnitStrategy.InnerProd;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocUnitLevelEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.InnerProd.BaseStrategy;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocUtils;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDefinedStrategy
extends BaseStrategy {
    private static Logger logger = Logger.getLogger((String)UserDefinedStrategy.class.getName());
    private String _factor;
    private Context _ctx;
    private String _fieldFlag;
    private AllocUnitLevelEnum _unitLevel;

    public UserDefinedStrategy(Map param, String factor) throws AllocateException {
        super(param);
        Assert.that((boolean)param.containsKey("ctx"));
        Assert.that((factor != null ? 1 : 0) != 0);
        this._factor = factor;
        this._ctx = (Context)this._param.get("ctx");
        this.initUnitInfo();
    }

    public String GetAllocStdDataSql() throws AllocateException {
        super.GetAllocStdDataSql();
        boolean isAllocClassiCO = AllocStdTypeEnum.CLASSI.equals(this._param.get("allocStdType"));
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET {1} = (").append('\n').append("\tSELECT ISNULL(SUM(PARENT.FQty),0) As FQty ").append('\n').append("\tFROM T_NCM_UserDefinedData PARENT ").append('\n').append("\tINNER JOIN {2} R ON R.FCostCenterID=PARENT.FCostCenterID AND R.FCostObjectID=PARENT.FCostObjectID ").append('\n');
        if (isAllocClassiCO) {
            sb.append("\t\tAND R.FProductID = PARENT.FMaterialID ").append('\n');
        }
        if (this._unitLevel.equals((Object)AllocUnitLevelEnum.COSTITEM)) {
            sb.append("\t\tAND R.FCostItemID=PARENT.FCostItemID ").append('\n');
        }
        sb.append("  inner join t_org_costcenter cc on cc.fid =R.fcostcenterID and cc.FCostCenterType = 0 ").append('\n');
        sb.append("\tWHERE R.FID={3}.FID AND PARENT.FCompanyID = ''{4}'' AND PARENT.FCostType = 2 ").append('\n').append("\t\tAND PARENT.FAllocStdUnitID=''{5}'' ").append('\n').append(isAllocClassiCO ? "),FHasAllocData=1 " : ") ");
        return MessageFormat.format(sb.toString(), this._tblAllocData, this._fldFlag, this._tblObjectRange, this._tblAllocData, this._companyId, this._factor);
    }

    public AllocUnitLevelEnum GetAllocUnitLevel() {
        return this._unitLevel;
    }

    public String GetFieldFlag() {
        return this._fieldFlag;
    }

    public String[] GetNoAllocStdDataHint() throws AllocateException {
        String[] ret = new String[]{AllocUtils.getAllocResource((Context)this._ctx, (String)"NoData_Hint_UserData_0"), AllocUtils.getAllocResource((Context)this._ctx, (String)"NoData_Hint_UserData_1")};
        return ret;
    }

    private void initUnitInfo() throws AllocateException {
        AllocStdUnitInfo unit;
        ObjectUuidPK pk = new ObjectUuidPK(this._factor);
        try {
            unit = AllocStdUnitFactory.getLocalInstance((Context)this._ctx).getAllocStdUnitInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
        }
        this._fieldFlag = "F" + unit.getNumber().trim();
        this._unitLevel = unit.getAllocStdType().equals((Object)AllocStdTypeEnum.WIPSTD) ? AllocUnitLevelEnum.COSTITEM : AllocUnitLevelEnum.OBJECT;
    }
}

