/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.DynCostAdjustAllocator;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynAutoCostAdjustAllocator
extends DynCostAdjustAllocator {
    private static Logger logger = Logger.getLogger((String)DynAutoCostAdjustAllocator.class.getName());
    private AllocateExceptionLog _logger;
    Map allocStdSettingCache = null;

    public DynAutoCostAdjustAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (AllocateExceptionLog)param.get("logger");
    }

    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        AllocStdInfo setting = this.GetAllocStdFromCache(currFee);
        if (setting == null) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())}));
        }
        return setting;
    }

    private AllocStdInfo GetAllocStdFromCache(IFeeInfo currFee) {
        if (this.allocStdSettingCache == null) {
            Context ctx = (Context)this._param.get("ctx");
            String companyId = this._param.get("companyId").toString();
            StringBuffer sb = new StringBuffer();
            this.allocStdSettingCache = new HashMap();
            AllocStdSetByPrdCollection allocStdSettingCacheForDirect = null;
            try {
                IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance((Context)ctx);
                sb.append("Select allocStd.*,expense.*,costCenter.* ").append(" where company = '").append(companyId).append("'").append("  AND calculatePeriod IS NULL and CostType = 2 ").append("  AND allocStd.id is not null ");
                allocStdSettingCacheForDirect = fact.getAllocStdSetByPrdCollection(sb.toString());
            }
            catch (BOSException e) {
                this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e));
                logger.error((Object)"", (Throwable)e);
            }
            String expenseId = null;
            String costCenterId = null;
            String key = null;
            for (int i = 0; i < allocStdSettingCacheForDirect.size(); ++i) {
                expenseId = allocStdSettingCacheForDirect.get(i).getExpense().getId().toString();
                costCenterId = allocStdSettingCacheForDirect.get(i).getCostCenter().getId().toString();
                key = expenseId + "_" + costCenterId;
                this.allocStdSettingCache.put(key, allocStdSettingCacheForDirect.get(i).getAllocStd());
            }
        }
        return (AllocStdInfo)this.allocStdSettingCache.get(currFee.GetExpenseId() + "_" + currFee.GetCostCenterId());
    }

    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)e);
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
            if (this._logger.getLogCount() > 0) {
                IRowSet logData = this._logger.GetLogData();
                ret.put("HasError", String.valueOf(true));
                ret.put("logData", (String)logData);
            }
        }
        return ret;
    }

    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.AddLog(e);
        } else {
            this._logger.AddLog(e, possibleReason, adviceHandle);
        }
    }
}

