/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.app.DCChecker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.DCCMCalChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class ManufactureRecFiVoucheredChecker
extends DCCMCalChecker {
    public CalCostCheckItemCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String callPeriodId, String PeriodId) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection results = new CalCostCheckItemCheckResultCollection();
        try {
            this._check(ctx, CompanyOrgID, PeriodId, results);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return results;
    }

    private void _check(Context ctx, String companyOrgID, String PeriodId, CalCostCheckItemCheckResultCollection results) throws BOSException, SQLException {
        CompanyOrgUnitInfo company = null;
        PeriodInfo period = null;
        try {
            company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyOrgID));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodId));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct mb.FNUMBER FROM T_IM_ManufactureRecBill mb").append(" LEFT OUTER JOIN T_SCM_TransactionType tt ON mb.FTransactionTypeID = tt.FId").append(" LEFT OUTER JOIN T_IM_ManufactureRecBillEntry mbe on mbe.FParentId = mb.FId ").append(" WHERE mb.FFiVouchered = 1 AND mb.FBASESTATUS = 4 AND tt.FIsManuCostCalculate = 1 ").append(" AND mbe.FCompanyOrgUnitID = '").append(company.getId()).append("' ").append(" and mb.FBizDate >= TO_DATE('" + dateFormate.format(period.getBeginDate()) + "') ").append("  and mb.FBizDate <= TO_DATE('" + dateFormate.format(period.getEndDate()) + "') ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            return;
        }
        CalCostCheckItemCheckResultInfo result = null;
        StringBuffer tips = new StringBuffer();
        try {
            while (rs.next() && rs.getString(1) != null) {
                result = new CalCostCheckItemCheckResultInfo();
                tips.append(rs.getString(1)).append("\n");
                result.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"40_ManufactureRecFiVoucheredChecker", (Locale)ctx.getLocale()) + tips.toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"41_ManufactureRecFiVoucheredChecker", (Locale)ctx.getLocale()));
                result.setReason(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"24_CompanySetPeriodTypeChecker", (Locale)ctx.getLocale()) + company.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"42_ManufactureRecFiVoucheredChecker", (Locale)ctx.getLocale()));
                result.setSuggestOperation(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"43_ManufactureRecFiVoucheredChecker", (Locale)ctx.getLocale()));
                results.add(result);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

